
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: beh_frebeaux.c					*/
/* date		: Sep 12 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a list	*/
/*		  of behaviour data structures				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <mut309.h>
#include <log120.h>
#include <beh104.h>

/* ###--------------------------------------------------------------### */
/* function	: beh_frebeaux						*/
/* description	: delete a list of BEAUX structures and all objects	*/
/*		  pointed by any os BEAUXs in the list			*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

void beh_frebeaux (listbeaux)

struct beaux *listbeaux;	/* list of beaux to be deleted		*/

  {
  struct beaux *ptbeaux;

	/* ###------------------------------------------------------### */
	/*    for each object of the list, first delete pointed objects	*/
	/* then, delete the object itself				*/
	/* ###------------------------------------------------------### */

  while (listbeaux != NULL)
    {
    freeExpr (listbeaux->ABL);

    ptbeaux   = listbeaux;
    listbeaux = listbeaux->NEXT;
    mbkfree (ptbeaux);
    }

  }
