
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: makbdd.c						*/
/* date		: Feb  8 1993						*/
/* version	: v1.9							*/
/* authors	: VUONG H.N., L.A. TABUSSE, P. BAZARGAN			*/
/* content	: constructs the BDDs of a befig struct. filling the 	*/
/*		  node or binode pointers.				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include <stdio.h>
#include <mut309.h>
#include <mlo402.h>
#include <log120.h>
#include <beh104.h>
#include "beh_makbdd.h"

/* ###--------------------------------------------------------------### */
/* function	: beh_abl2bdd						*/
/* description	: transform recursively abl in bdd 			*/
/* algorithm    : if ATOM(expr)is an operand --terminal variable, 	*/
/*		  then 							*/
/*		    if (it is a constant or a primary variable)		*/
/*		    then return that bdd that is already known 		*/
/*		    else 						*/
/*		      if ((it is an auxiliary variable)&&		*/
/*			  (there is no self-dependence))		*/
/*	   	      then return beh_abl2bdd(that terminal variable)	*/
/*		      else ERROR					*/
/*		  else apply OPER(expr) 				*/
/*			to beh_abl2bdd(every operands) 			*/
/* called func.	: searchInputCct <bdd>, createNodeTermBdd <bdd>,	*/
/* 		: addListBdd <bdd>, applyBdd <bdd>,      		*/
/* 		: addchain <mbk>, freechain <mbk>, delchain <mbk>	*/
/*              : beh_toolbug, beh_error  				*/
/* 		: beh_abl2bdd -- that function is recursive !!!		*/
/* ###--------------------------------------------------------------### */

pNode beh_abl2bdd (ptr_circuit, expr, ptr_befig)
pCircuit ptr_circuit;		/* circuit for level 1 bdd functions 	*/
chain_list *expr;		/* pointer abl expression		*/
struct befig *ptr_befig;	/* pointer on  behavioural figure	*/
  {
  short         oper;
  pNode         pt;
  chain_list   *lstGbd;
  chain_list   *ptr_cntrl = ptr_ctrlst;
  struct beaux *ptr_beaux=ptr_befig->BEAUX;
  int           index;
  char         *atom;
  char         name[256];

  /*--------------------------------------------------------------------*/
  /*  Verifying that an abl is sent to the function			*/
  /*--------------------------------------------------------------------*/
  if (expr == NULL)
    {
    beh_toolbug (2,"beh_abl2bdd",NULL,0);
    }

  /*--------------------------------------------------------------------*/
  /*  Is expr an operand ?						*/
  /*--------------------------------------------------------------------*/
  if (ATOM(expr))
    {			
    atom = (char *)VALUE_ATOM(expr);
					
    /*------------------------------------------------------------------*/
    /* Is atom a constant ?           					*/
    /*------------------------------------------------------------------*/
    if (!strcmp(atom, "'0'"))
      {
      return (zero);
      }
    if (!strcmp(atom, "'d'"))
      {
      return (zero);
      }
    if (!strcmp(atom, "'1'"))
      {
      return (one);
      }

    /*------------------------------------------------------------------*/
    /* is atom a primary variable ?     				*/
    /*------------------------------------------------------------------*/
    if ((index=searchInputCct (ptr_circuit, atom)) != VIDE)
      {
      return (createNodeTermBdd (index));
      }
    
    /*------------------------------------------------------------------*/
    /* neither constant, nor primary it must be an auxiliary variable 	*/
    /*------------------------------------------------------------------*/
    else
      {
      while ((ptr_beaux != NULL) && (ptr_beaux->NAME != atom))
        ptr_beaux = ptr_beaux->NEXT;

      /*----------------------------------------------------------------*/
      /* neither constant, nor primary, nor                             */
      /* auxiliary variable : it's an error                             */
      /*----------------------------------------------------------------*/
      if (ptr_beaux == NULL)		 
        {
        beh_toolbug (1,"beh_abl2bdd",atom,0);
        }

      /*----------------------------------------------------------------*/
      /* does that signal depends of itself ? ptr_ctrlst is the         */
      /* dependance list of expression being transformed from abl to bdd*/
      /*----------------------------------------------------------------*/
      else		
	{				
        while ((ptr_cntrl != NULL) && ((char *) ptr_cntrl->DATA != atom))
          ptr_cntrl = ptr_cntrl->NEXT;

        /*--------------------------------------------------------------*/
	/* to ensure that no signal depends of himself		        */
	/* if it does it's a fatal error!                               */
        /*--------------------------------------------------------------*/
        if (ptr_cntrl != NULL)
          {			
	  beh_error (1,atom);
          exit (1);
          }
        else
          {
          if (ptr_beaux->NODE == NULL)
            {
            ptr_ctrlst = addchain (ptr_ctrlst,atom);

            /*----------------------------------------------------------*/
    	    /* add a signal to the dependences    			*/
	    /* list that ptr_ctrlst is pointing at			*/
            /*----------------------------------------------------------*/
            ptr_beaux->NODE = beh_abl2bdd ( ptr_circuit,ptr_beaux->ABL,ptr_befig);
            ptr_ctrlst = delchain (ptr_ctrlst,ptr_ctrlst);

            /*----------------------------------------------------------*/
	    /* delete a signal to the dependences list   		*/
            /*----------------------------------------------------------*/
            return (ptr_beaux->NODE);
            }
          else
            return (ptr_beaux->NODE);
          }
        }
      }
    }

  /*--------------------------------------------------------------------*/
  /*  Expr is a operator.						*/
  /*--------------------------------------------------------------------*/
  else
    {
    if((oper = OPER(expr))!=STABLE)
     {

     /*------------------------------------------------------------------*/
     /* operator to be applyed on lstgbd list of operands	        */
     /*------------------------------------------------------------------*/
     lstGbd = NULL;	
     while (expr = CDR(expr))
      lstGbd = addListBdd(lstGbd,beh_abl2bdd(ptr_circuit,CAR(expr),ptr_befig));
     pt = applyBdd(oper,lstGbd);
     freechain (lstGbd);
     return(pt);
     }
    else
     { 
     lstGbd = NULL;	
	expr = CDR(expr);
	if(!ATOM(expr))
	  beh_toolbug (0,NULL,NULL,0);

	atom = (char *)VALUE_ATOM(CAR(expr));
  	 	
    if ((index=searchInputCct (ptr_circuit, atom)) != VIDE)
      {
       lstGbd = addListBdd(lstGbd,createNodeTermBdd (index));
      }
	sprintf (name,"%s'delayed",atom);
	atom = namealloc (name);
    if ((index=searchInputCct (ptr_circuit, atom)) != VIDE)
      {
       lstGbd = addListBdd(lstGbd,createNodeTermBdd (index));
      }
     pt = applyBdd(NXOR,lstGbd);
     freechain (lstGbd);
     return(pt);
	
     }		
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: beh_mbddtot						*/
/* description	: evalue bdds for each input, output or bus, connector	*/
/*    	          register signal, and auxiliary signal of ptr_befig	*/
/* called func.	: beh_abl2bdd, addchain <mbk>, delchain <mbk>		*/
/*                beh_initab, beh_fretab, beh_addtab, beh_chktab        */
/* ###--------------------------------------------------------------### */

int beh_mbddtot(ptr_befig, ptr_circuit, reorder, nbr_abl, trace_flg)

struct befig *ptr_befig;		/* pointer on current BEFIG	*/
pCircuit      ptr_circuit;		/* pointer on current circuit	*/
int           reorder;			/* order parameter 		*/
int           nbr_abl;			/* number of abl to perform     */
char          trace_flg;		/* trace signals when making bdd*/

  {
  struct dct_entry **hshtab;

  /*--------------------------------------------------------------------*/
  /*  Initialization of the address dictionnary				*/
  /*--------------------------------------------------------------------*/
  hshtab = beh_initab ();

  /*--------------------------------------------------------------------*/
  /*  Evalue BDDs for each BEAUX					*/
  /*--------------------------------------------------------------------*/
  if (ptr_befig->BEAUX != NULL)
    {
    struct beaux *ptr_beaux;
    ptr_beaux = ptr_befig->BEAUX;
    while (ptr_beaux != NULL)
      {
      if (trace_flg == 1)
        printf ("internal signal : %s\n",ptr_beaux->NAME);

      if ((ptr_beaux->ABL != NULL) && (ptr_beaux->NODE == NULL))
        if ((pNode)beh_chktab(hshtab,ptr_beaux->ABL,NULL,BEH_PNTDFN) == NULL)
	  {
          ptr_ctrlst = addchain (ptr_ctrlst,ptr_beaux->NAME);
          ptr_beaux->NODE = beh_abl2bdd(ptr_circuit,ptr_beaux->ABL,ptr_befig);
          ptr_ctrlst = delchain (ptr_ctrlst,ptr_ctrlst);
	  beh_addtab(hshtab,ptr_beaux->ABL,NULL,BEH_PNTDFN,(int)ptr_beaux->NODE);
	  }
        else
          ptr_beaux->NODE = (pNode)beh_chktab(hshtab,ptr_beaux->ABL,NULL,BEH_PNTDFN);
      ptr_beaux = ptr_beaux->NEXT;
      }
    }

  /*--------------------------------------------------------------------*/
  /*  Evalue BDDs for each BEDLY					*/
  /*--------------------------------------------------------------------*/
  if (ptr_befig->BEDLY != NULL)
    {
    struct beaux *ptr_bedly;
    ptr_bedly = ptr_befig->BEDLY;
    while (ptr_bedly != NULL)
      {
      if (trace_flg == 1)
        printf ("internal signal : %s\n",ptr_bedly->NAME);

      if ((ptr_bedly->ABL != NULL) && (ptr_bedly->NODE == NULL))
        if ((pNode)beh_chktab(hshtab,ptr_bedly->ABL,NULL,BEH_PNTDFN) == NULL)
	  {
          ptr_ctrlst = addchain (ptr_ctrlst,ptr_bedly->NAME);
          ptr_bedly->NODE = beh_abl2bdd(ptr_circuit,ptr_bedly->ABL,ptr_befig);
          ptr_ctrlst = delchain (ptr_ctrlst,ptr_ctrlst);
	  beh_addtab(hshtab,ptr_bedly->ABL,NULL,BEH_PNTDFN,(int)ptr_bedly->NODE);
	  }
        else
          ptr_bedly->NODE = (pNode)beh_chktab(hshtab,ptr_bedly->ABL,NULL,BEH_PNTDFN);
      ptr_bedly = ptr_bedly->NEXT;
      }
    }

  /*--------------------------------------------------------------------*/
  /*  Evalue BDDs for each BEMSG					*/
  /*--------------------------------------------------------------------*/
  if (ptr_befig->BEMSG != NULL)
    {
    struct bemsg *ptr_bemsg;
    ptr_bemsg=ptr_befig->BEMSG;
    while (ptr_bemsg != NULL)
      {
      if ((ptr_bemsg->ABL != NULL) && (ptr_bemsg->NODE == NULL))
        if ((pNode)beh_chktab(hshtab,ptr_bemsg->ABL,NULL,BEH_PNTDFN) == NULL)
	  {
          ptr_bemsg->NODE = beh_abl2bdd(ptr_circuit,ptr_bemsg->ABL,ptr_befig);
	  beh_addtab(hshtab,ptr_bemsg->ABL,NULL,BEH_PNTDFN,(int)ptr_bemsg->NODE);
	  }
        else
          ptr_bemsg->NODE = (pNode)beh_chktab(hshtab,ptr_bemsg->ABL,NULL,BEH_PNTDFN);
      ptr_bemsg = ptr_bemsg->NEXT;
      }
    }
 
  /*--------------------------------------------------------------------*/
  /*  Evalue BDDs for each BEOUT					*/
  /*--------------------------------------------------------------------*/
  if (ptr_befig->BEOUT != NULL)
    {
    struct beout *ptr_beout;
    ptr_beout=ptr_befig->BEOUT;
    while (ptr_beout != NULL)
      {
      if (trace_flg == 1)
        printf ("simple output : %s\n",ptr_beout->NAME);

      if ((ptr_beout->ABL != NULL) && (ptr_beout->NODE == NULL))
        if ((pNode)beh_chktab (hshtab,ptr_beout->ABL,NULL,BEH_PNTDFN) == NULL)
	  {
          ptr_ctrlst = addchain (ptr_ctrlst,ptr_beout->NAME);
          ptr_beout->NODE = beh_abl2bdd(ptr_circuit,ptr_beout->ABL,ptr_befig);
          ptr_ctrlst = delchain (ptr_ctrlst,ptr_ctrlst);
	  beh_addtab(hshtab,ptr_beout->ABL,NULL,BEH_PNTDFN,(int)ptr_beout->NODE);
	  }
        else
          ptr_beout->NODE = (pNode)beh_chktab(hshtab,ptr_beout->ABL,NULL,BEH_PNTDFN);
      ptr_beout = ptr_beout->NEXT;
      }
    }

  /*--------------------------------------------------------------------*/
  /*  Evalue BDDs for each BEBUS					*/
  /*--------------------------------------------------------------------*/
  if (ptr_befig->BEBUS != NULL)
    {
    struct bebus *ptr_bebus;
    ptr_bebus=ptr_befig->BEBUS;
    while (ptr_bebus != NULL)
      {
      if (trace_flg == 1)
        printf ("bussed output : %s\n",ptr_bebus->NAME);

      if (ptr_bebus->BIABL != NULL)
        {
        struct biabl *ptr_biabl;
        struct binode *ptr_binode;

        ptr_biabl = ptr_bebus->BIABL;
        ptr_binode = ptr_bebus->BINODE;
        while (ptr_biabl != NULL)
          {
           
          /*------------------------------------------------------------*/
          /* Evalue BDDs for CNDABL of the BEBUS BIABL structure        */
          /*------------------------------------------------------------*/
          if (ptr_biabl->CNDABL != NULL)
            if((pNode)beh_chktab(hshtab,ptr_biabl->CNDABL,NULL,BEH_PNTDFN) == NULL)
	      {
              ptr_binode->CNDNODE = beh_abl2bdd(ptr_circuit,ptr_biabl->CNDABL,ptr_befig);
	      beh_addtab(hshtab,ptr_biabl->CNDABL,NULL,BEH_PNTDFN,(int)ptr_binode->CNDNODE);
	      }
            else
              ptr_binode->CNDNODE = (pNode)beh_chktab(hshtab,ptr_biabl->CNDABL,NULL,BEH_PNTDFN);

          /*------------------------------------------------------------*/
          /* Evalue BDDs for VALABL of the BEBUS BIABL structure        */
          /*------------------------------------------------------------*/
          if ( ptr_biabl->VALABL != NULL )
            if((pNode) beh_chktab (hshtab,ptr_biabl->VALABL,NULL,BEH_PNTDFN) == NULL)
	      {
              ptr_ctrlst = addchain (ptr_ctrlst,ptr_bebus->NAME);
              ptr_binode->VALNODE = beh_abl2bdd (ptr_circuit,ptr_biabl->VALABL,ptr_befig);
              ptr_ctrlst = delchain (ptr_ctrlst,ptr_ctrlst);
	      beh_addtab (hshtab,ptr_biabl->VALABL,NULL,BEH_PNTDFN,(int)ptr_binode->VALNODE);
	      }
            else
              ptr_binode->VALNODE = (pNode) beh_chktab (hshtab,ptr_biabl->VALABL,NULL,BEH_PNTDFN);

          ptr_biabl = ptr_biabl->NEXT;
          ptr_binode = ptr_binode->NEXT;
          }
        }
      ptr_bebus = ptr_bebus->NEXT;
      }
    }

  /*--------------------------------------------------------------------*/
  /*  Evalue BDDs for each BEBUX					*/
  /*--------------------------------------------------------------------*/
  if (ptr_befig->BEBUX != NULL)
    {
    struct bebux *ptr_bebux;

    ptr_bebux = ptr_befig->BEBUX;
    while (ptr_bebux != NULL)
      {
      if (trace_flg == 1)
        printf ("internal bussed signal : %s\n",ptr_bebux->NAME);

      if (ptr_bebux->BIABL != NULL)
        {
        struct biabl *ptr_biabl;
        struct binode *ptr_binode;

        ptr_biabl = ptr_bebux->BIABL;
        ptr_binode = ptr_bebux->BINODE;
        while (ptr_biabl != NULL)
          {
           
          /*------------------------------------------------------------*/
          /* Evalue BDDs for CNDABL of the BEBUX BIABL structure        */
          /*------------------------------------------------------------*/
          if (ptr_biabl->CNDABL != NULL)
            if((pNode)beh_chktab(hshtab,ptr_biabl->CNDABL,NULL,BEH_PNTDFN) == NULL)
	      {
              ptr_binode->CNDNODE = beh_abl2bdd(ptr_circuit,ptr_biabl->CNDABL,ptr_befig);
	      beh_addtab(hshtab,ptr_biabl->CNDABL,NULL,BEH_PNTDFN,(int)ptr_binode->CNDNODE);
	      }
            else
              ptr_binode->CNDNODE = (pNode)beh_chktab(hshtab,ptr_biabl->CNDABL,NULL,BEH_PNTDFN);

          /*------------------------------------------------------------*/
          /* Evalue BDDs for VALABL of the BEBUX BIABL structure        */
          /*------------------------------------------------------------*/
          if ( ptr_biabl->VALABL != NULL )
            if((pNode) beh_chktab (hshtab,ptr_biabl->VALABL,NULL,BEH_PNTDFN) == NULL)
	      {
              ptr_ctrlst = addchain (ptr_ctrlst,ptr_bebux->NAME);
              ptr_binode->VALNODE = beh_abl2bdd (ptr_circuit,ptr_biabl->VALABL,ptr_befig);
              ptr_ctrlst = delchain (ptr_ctrlst,ptr_ctrlst);
	      beh_addtab (hshtab,ptr_biabl->VALABL,NULL,BEH_PNTDFN,(int)ptr_binode->VALNODE);
	      }
            else
              ptr_binode->VALNODE = (pNode) beh_chktab (hshtab,ptr_biabl->VALABL,NULL,BEH_PNTDFN);

          ptr_biabl = ptr_biabl->NEXT;
          ptr_binode = ptr_binode->NEXT;
          }
        }
      ptr_bebux = ptr_bebux->NEXT;
      }
    }

  /*--------------------------------------------------------------------*/
  /*  Evalue BDDs for each BEREG					*/
  /*--------------------------------------------------------------------*/
  if (ptr_befig->BEREG != NULL)
    {
    struct bereg *ptr_bereg;
    ptr_bereg=ptr_befig->BEREG;
    while (ptr_bereg != NULL)
      {
      if (trace_flg == 1)
        printf ("register : %s\n",ptr_bereg->NAME);

      if (ptr_bereg->BIABL != NULL)
        {
        struct biabl *ptr_biabl;
        struct binode *ptr_binode;
        ptr_biabl = ptr_bereg->BIABL;
        ptr_binode = ptr_bereg->BINODE;
        while (ptr_biabl != NULL)
          {

          /*------------------------------------------------------------*/
          /* Evalue BDDs for CNDABL of the BEREG BIABL structure        */
          /*------------------------------------------------------------*/
          if (ptr_biabl->CNDABL != NULL)
            if((pNode)beh_chktab(hshtab,ptr_biabl->CNDABL,NULL,BEH_PNTDFN) == NULL)
	      {
              ptr_binode->CNDNODE = beh_abl2bdd(ptr_circuit,ptr_biabl->CNDABL,ptr_befig);
	      beh_addtab (hshtab,ptr_biabl->CNDABL,NULL,BEH_PNTDFN,(int)ptr_binode->CNDNODE);
	      }
            else
              ptr_binode->CNDNODE = (pNode)beh_chktab(hshtab,ptr_biabl->CNDABL,NULL,BEH_PNTDFN);

          /*------------------------------------------------------------*/
          /* Evalue BDDs for VALABL of the BEREG BIABL structure        */
          /*------------------------------------------------------------*/
          if (ptr_biabl->VALABL != NULL)
            if ((pNode)beh_chktab(hshtab,ptr_biabl->VALABL,NULL,BEH_PNTDFN) == NULL)
	      {
              ptr_ctrlst = addchain (ptr_ctrlst,ptr_bereg->NAME);
              ptr_binode->VALNODE = beh_abl2bdd(ptr_circuit,ptr_biabl->VALABL,ptr_befig);
              ptr_ctrlst = delchain (ptr_ctrlst,ptr_ctrlst);
	      beh_addtab(hshtab,ptr_biabl->VALABL,NULL,BEH_PNTDFN,(int)ptr_binode->VALNODE);
	      }
            else
              ptr_binode->VALNODE = (pNode)beh_chktab(hshtab,ptr_biabl->VALABL,NULL,BEH_PNTDFN);

          ptr_biabl = ptr_biabl->NEXT;
          ptr_binode = ptr_binode->NEXT;
          }
        }
      ptr_bereg = ptr_bereg->NEXT;
      }
    }

  /*--------------------------------------------------------------------*/
  /*  Removing the whole address dictionnary				*/
  /*--------------------------------------------------------------------*/
  beh_fretab (hshtab);

  return(0);
  }

/* ###--------------------------------------------------------------### */
/* function	: beh_freabl						*/
/* description	: free all ABLs in BEFIG structure			*/
/* called func.	: freeExpr						*/
/* ###--------------------------------------------------------------### */

void beh_freabl (ptr_befig)

struct befig *ptr_befig;		/* pointer on current BEFIG	*/
  {
  struct beaux *ptr_beaux;
  struct bemsg *ptr_bemsg;
  struct beout *ptr_beout;
  struct bebus *ptr_bebus;
  struct biabl *ptr_biabl;
  struct bebux *ptr_bebux;
  struct bereg *ptr_bereg;

  if (ptr_befig != NULL)
    {
    ptr_beaux = ptr_befig->BEAUX;
    while (ptr_beaux != NULL)
      {
      if (ptr_beaux->ABL != NULL)
        {
        freeExpr (ptr_beaux->ABL);
        ptr_beaux->ABL = NULL;
        }
      ptr_beaux = ptr_beaux->NEXT;
      }

    ptr_beaux = ptr_befig->BEDLY;
    while (ptr_beaux != NULL)
      {
      if (ptr_beaux->ABL != NULL)
        {
        freeExpr (ptr_beaux->ABL);
        ptr_beaux->ABL = NULL;
        }
      ptr_beaux = ptr_beaux->NEXT;
      }

    ptr_bemsg = ptr_befig->BEMSG;
    while (ptr_bemsg != NULL)
      {
      if (ptr_bemsg->ABL != NULL)
        {
        freeExpr (ptr_bemsg->ABL);
        ptr_bemsg->ABL = NULL;
        }
      ptr_bemsg = ptr_bemsg->NEXT;
      }

    ptr_beout = ptr_befig->BEOUT;
    while (ptr_beout != NULL)
      {
      if (ptr_beout->ABL != NULL) 
        {
        freeExpr (ptr_beout->ABL);
        ptr_beout->ABL = NULL;
        }
      ptr_beout = ptr_beout->NEXT;
      }

    ptr_bebus = ptr_befig->BEBUS;
    while (ptr_bebus != NULL)
      {
      ptr_biabl = ptr_bebus->BIABL;
      while (ptr_biabl != NULL)
        {
        if (ptr_biabl->CNDABL != NULL)
          {
          freeExpr(ptr_biabl->CNDABL);
          ptr_biabl->CNDABL = NULL;
          }
        if (ptr_biabl->VALABL != NULL)
          {
          freeExpr(ptr_biabl->VALABL);
          ptr_biabl->VALABL = NULL;
          }
        ptr_biabl = ptr_biabl->NEXT;
        }
      ptr_bebus = ptr_bebus->NEXT;
      }

    ptr_bebux = ptr_befig->BEBUX;
    while (ptr_bebux != NULL)
      {
      ptr_biabl  = ptr_bebux->BIABL;
      while (ptr_biabl != NULL)
        {
        if (ptr_biabl->CNDABL != NULL)
          {
          freeExpr (ptr_biabl->CNDABL);
          ptr_biabl->CNDABL = NULL;
          }
        if (ptr_biabl->VALABL != NULL)
          {
          freeExpr   (ptr_biabl->VALABL);
          ptr_biabl->VALABL = NULL;
          }

        ptr_biabl  = ptr_biabl->NEXT;
        }
      ptr_bebux = ptr_bebux->NEXT;
      }

    ptr_bereg = ptr_befig->BEREG;
    while (ptr_bereg != NULL)
      {
      ptr_biabl = ptr_bereg->BIABL;
      while (ptr_biabl != NULL)
        {
        if ( ptr_biabl->CNDABL != NULL )
          {
          freeExpr(ptr_biabl->CNDABL);
          ptr_biabl->CNDABL = NULL;
          }
        if ( ptr_biabl->VALABL != NULL )
          {
          freeExpr(ptr_biabl->VALABL);
          ptr_biabl->VALABL = NULL;
          }
        ptr_biabl = ptr_biabl->NEXT;
        }
      ptr_bereg = ptr_bereg->NEXT;
      }
    }
  }

/* ###--------------------------------------------------------------### */
/* function	: beh_makbdd						*/
/* description	: make bdd for each signal of  a befig structure 	*/
/* 		: if aux_flg is 0, auxiliary variables disappear in bdd,*/
/* 		: and output, bus, and register signal depend only on 	*/
/* 		: primary variables that are inputs and register signals*/
/*              : if aux_flg is 1, auxiliary variables are kept.    	*/
/*              : trace_flg, permit to trace the signals transformed    */
/* called func.	: initializeCct <log>, addInputCct <log>, beh_mbddtot	*/
/* ###--------------------------------------------------------------### */
									
void beh_makbdd (ptr_befig, aux_flg, trace_flg)

struct befig *ptr_befig;
char aux_flg;
char trace_flg;

  {
  berin_list *ptr_rin;
  beaux_list *ptr_aux, *ptr_auxtmp;
  beout_list *ptr_out;
  bebus_list *ptr_bus;
  int         count_rin=0;
  int         count_out=0;

        /* ###------------------------------------------------------### */
        /*    count inputs 						*/
        /* ###------------------------------------------------------### */

  ptr_rin = ptr_befig->BERIN;
  while ( ptr_rin != NULL )
    {
    ptr_rin = ptr_rin->NEXT;
    count_rin++;
    }

       /* ###------------------------------------------------------### */
       /*      add auxiliary delayed signals to berin list		*/
       /* ###------------------------------------------------------### */

  ptr_rin = ptr_befig->BERIN;
  ptr_aux = ptr_befig->BEDLY;
  while (ptr_aux != NULL)
    {
    ptr_rin = beh_addberin(ptr_rin, ptr_aux->NAME);
    ptr_aux = ptr_aux->NEXT;
    count_rin++;
    }
  ptr_befig->BERIN = ptr_rin;

        /* ###------------------------------------------------------### */
        /*      add auxiliary signals to berin list			*/
        /* ###------------------------------------------------------### */

  if (aux_flg==1)
    {
    ptr_rin = ptr_befig->BERIN;
    ptr_aux = ptr_befig->BEAUX;
    while (ptr_aux != NULL)
      {
      ptr_rin = beh_addberin(ptr_rin, ptr_aux->NAME);
      ptr_aux = ptr_aux->NEXT;
      count_rin++;
      }
    ptr_befig->BERIN = ptr_rin;
    }


        /* ###------------------------------------------------------### */
        /*    count outputs 						*/
        /* ###------------------------------------------------------### */

  ptr_out = ptr_befig->BEOUT;
  while(ptr_out != NULL)
    {
    ptr_out = ptr_out->NEXT;
    count_out++;
    }
  ptr_bus = ptr_befig->BEBUS;
  while(ptr_bus != NULL)
     {
     ptr_bus = ptr_bus->NEXT;
     count_out++;
     }

        /* ###------------------------------------------------------### */
        /*    initialization						*/
        /* ###------------------------------------------------------### */

  ptr_befig->CIRCUI = initializeCct(ptr_befig->NAME,count_rin*2,count_out);

        /* ###------------------------------------------------------### */
        /*    Define an index for each input				*/
        /* ###------------------------------------------------------### */

  ptr_rin = ptr_befig->BERIN;
  while (ptr_rin != NULL)
    {
    addInputCct (ptr_befig->CIRCUI,ptr_rin->NAME);
    ptr_rin = ptr_rin->NEXT;
    }

        /* ###------------------------------------------------------### */
        /*    Change ABLs to BDDs for					*/
        /* ###------------------------------------------------------### */

  beh_mbddtot (ptr_befig,ptr_befig->CIRCUI,0,10000, trace_flg);

        /* ###------------------------------------------------------### */
        /*    remove the whole BEAUX list				*/
        /* ###------------------------------------------------------### */

  if ( aux_flg==0 )
    {
    ptr_aux = ptr_befig->BEAUX;
    while ( ptr_aux != NULL )
      {
      ptr_auxtmp = ptr_aux->NEXT;
      mbkfree ( ptr_aux );
      ptr_aux = ptr_auxtmp;
      }
    }
  }

/* ###--------------------------------------------------------------### */
/*  function : beh_initab						*/
/* ###--------------------------------------------------------------### */
static struct dct_entry **beh_initab ()

  {
  struct dct_entry **head;
  int                i;

  head = (struct dct_entry **)
         mbkalloc (sizeof(struct dct_entry *) * BEH_HSZDFN);

  for (i=0 ; i<BEH_HSZDFN ; i++)
    head[i] = NULL;

  return (head);
  }

/* ###--------------------------------------------------------------### */
/*  function : beh_toolbug						*/
/*  content  : print out bugs messages on the standard error output     */
/* ###--------------------------------------------------------------### */
static void beh_toolbug (code,str1,str2,nbr1)

int   code;
char *str1;
char *str2;
int   nbr1;

  {
  (void) fprintf (stderr,"Fatal error %d executing `%s`: ", code,str1);
  switch (code)
    {
    case 0:
      (void) fprintf (stderr,"cannot apply STABLE on an expression\n");
      break;
    case 1:
      (void) fprintf (stderr,"cannot find terminal %s\n",str2);
      break;
    case 2:
      (void) fprintf (stderr,"cannot make BDD of empty expression\n");
      break;
    }
  exit (1);
  }

/* ###--------------------------------------------------------------### */
/*  function : beh_addtab						*/
/* ###--------------------------------------------------------------### */
static void beh_addtab (head,key_str,ctx_str,field,valu)

struct dct_entry **head;
char              *key_str;
char              *ctx_str;
int                field;
int                valu;

  {
  int               found = 0;
  int               index;
  struct dct_entry *entry_pnt;
  struct dct_recrd *recrd_pnt;

  index     = (int) key_str % BEH_HSZDFN;
  entry_pnt = head[index];

  while (entry_pnt != NULL)
    {
    if (entry_pnt->key == key_str)
      {
      found = 1;
      break;
      }
    entry_pnt = entry_pnt->next;
    }

  if (found == 0)
    {
    head[index] = beh_addent (head[index],key_str); 
    entry_pnt = head[index]; 
    }

  found = 0;
  recrd_pnt = entry_pnt->data;
  while (recrd_pnt != NULL)
    {
    if (recrd_pnt->key == ctx_str)
      {
      found = 1;
      break;
      }
    recrd_pnt = recrd_pnt->next;
    }

  if (found == 0)
    {
    entry_pnt->data = beh_addrcd (entry_pnt->data,ctx_str); 
    recrd_pnt       = entry_pnt->data ;
    }

  switch (field)
    {
    case 0 :
      recrd_pnt->fd0_val = valu;
      break;
    case 1 :
      recrd_pnt->fd1_val = valu;
      break;
    case 2 :
      recrd_pnt->fd2_val = valu;
      break;
    case 3 :
      recrd_pnt->fd3_val = valu;
      break;
    case 4 :
      recrd_pnt->fd4_val = valu;
      break;
    case 5 :
      recrd_pnt->fd5_val = valu;
      break;
    case 6 :
      recrd_pnt->fd6_val = valu;
      break;
    case 7 :
      recrd_pnt->pnt_val = valu;
      break;
    }

  }

/* ###--------------------------------------------------------------### */
/*  function : beh_chktab						*/
/* ###--------------------------------------------------------------### */
static int  beh_chktab (head,key_str,ctx_str,field)

struct dct_entry **head;
char              *key_str;
char              *ctx_str;
int                field;

  {
  int               found = 0;
  int               valu = 0;
  struct dct_entry *entry_pnt;
  struct dct_recrd *recrd_pnt;

  entry_pnt = head [(int)key_str % BEH_HSZDFN];

  while (entry_pnt != NULL)
    {
    if (entry_pnt->key == key_str)
      {
      found = 1;
      break;
      }
    entry_pnt = entry_pnt->next;
    }

  if (found == 1)
    {
    found = 0;
    recrd_pnt = entry_pnt->data;
    while (recrd_pnt != NULL)
      {
      if (recrd_pnt->key == ctx_str)
        {
        found = 1;
        break;
        }
      recrd_pnt = recrd_pnt->next;
      }
    if (found == 1)
      {
      switch (field)
        {
        case 0 :
          valu = recrd_pnt->fd0_val;
          break;
        case 1 :
          valu = recrd_pnt->fd1_val;
          break;
        case 2 :
          valu = recrd_pnt->fd2_val;
          break;
        case 3 :
          valu = recrd_pnt->fd3_val;
          break;
        case 4 :
          valu = recrd_pnt->fd4_val;
          break;
        case 5 :
          valu = recrd_pnt->fd5_val;
          break;
        case 6 :
          valu = recrd_pnt->fd6_val;
          break;
        case 7 :
          valu = recrd_pnt->pnt_val;
          break;
        }
      }
    }

  return (valu);
  }

/* ###--------------------------------------------------------------### */
/*  function : beh_fretab						*/
/* ###--------------------------------------------------------------### */
static void beh_fretab (pt_hash)

struct dct_entry **pt_hash;
  {
  struct dct_entry *pt_entry;
  struct dct_entry *pt_nxtentry;
  struct dct_recrd *pt_record;
  int               i;

  if (pt_hash != NULL)
    {
    for (i=0 ; i<BEH_HSZDFN ; i++)
      {
      if ((pt_entry = pt_hash[i]) != NULL)
        {
        while (pt_entry != NULL)
          {
          pt_record = pt_entry->data;

          while (pt_record->next != NULL)
            pt_record = pt_record->next;

          pt_record->next = BEH_DCRHED;
          BEH_DCRHED      = pt_entry->data;

          pt_nxtentry     = pt_entry->next;
          pt_entry->next  = BEH_DCEHED;
          BEH_DCEHED      = pt_entry;
          pt_entry        = pt_nxtentry;
          }
        }
      }
    free (pt_hash);
    }
  }

/* ###--------------------------------------------------------------### */
/*  function : beh_error						*/
/* ###--------------------------------------------------------------### */
static void beh_error (code,str1)

int   code;
char *str1;

  {
  (void)fprintf (stderr,"Error %d :",code);

  switch (code)
    {
    case 1:
      (void) fprintf (stderr,"combinatory loop : `%s`\n",str1);
      break;
    default:
      (void) fprintf (stderr,"syntax error\n");
      break;
    }
  }

/* ###--------------------------------------------------------------### */
/*  function : beh_addent						*/
/* ###--------------------------------------------------------------### */
static struct dct_entry *beh_addent (head , key)

struct dct_entry *head;
char             *key;

  {
  struct dct_entry *entry;
  int               i;

  if (BEH_DCEHED == NULL)
    {
    BEH_DCEHED = (struct dct_entry *)
                 mbkalloc (sizeof(struct dct_entry) * BEH_ALODFN);

    entry = BEH_DCEHED;
    for (i=1 ; i<BEH_ALODFN ; i++)
      {
      entry->next = entry + 1;
      entry++;
      }
    entry->next = NULL;
    }

  entry       = BEH_DCEHED;
  BEH_DCEHED  = BEH_DCEHED->next;

  entry->next = head;
  entry->data = NULL;
  entry->key  = key;

  return (entry);
  }

/* ###--------------------------------------------------------------### */
/*  function : beh_addrcd						*/
/* ###--------------------------------------------------------------### */
static struct dct_recrd *beh_addrcd (head , key)

struct dct_recrd *head;
char             *key;

  {
  struct dct_recrd *recrd;
  int               i;

  if (BEH_DCRHED == NULL)
    {
    BEH_DCRHED = (struct dct_recrd *)
                 mbkalloc (sizeof(struct dct_recrd) * BEH_ALODFN);

    recrd = BEH_DCRHED;
    for (i=1 ; i<BEH_ALODFN ; i++)
      {
      recrd->next = recrd + 1;
      recrd++;
      }
    recrd->next = NULL;
    }

  recrd           = BEH_DCRHED;
  BEH_DCRHED      = BEH_DCRHED->next;

  recrd->next     = head;
  recrd->fd0_val  = 0;
  recrd->fd1_val  = 0;
  recrd->fd2_val  = 0;
  recrd->fd3_val  = 0;
  recrd->fd4_val  = 0;
  recrd->fd5_val  = 0;
  recrd->fd6_val  = 0;
  recrd->pnt_val  = 0;
  recrd->key      = key;

  return (recrd);
  }

