/* ###--------------------------------------------------------------### */
/*									*/
/* file		: vh_asimut.c						*/
/* date		: Feb  8 1993						*/
/* version	: v1.9							*/
/* author	: Pirouz BAZARGAN SABET	& VUONG Huu Nghia		*/
/* description	: VHDL compiler and simulation tool.			*/
/*									*/
/* ###--------------------------------------------------------------### */

/* ###--------------------------------------------------------------### */
/* V1.9 : Now keep auxiliary signals by default, -aux means reduce	*/
/*          the equations.						*/
/*        If result file has no '.' then give out a file named		*/
/*          "result_file.[VH_PATSFX]"					*/
/* V1.8 : Verify all the connectors to accept all mbk inputs : al,..	*/
/*        Read MBK_CATA_LIB, if VH_LIBLST doesn't exist			*/
/*        Does not accept HZ connectors					*/
/* ###--------------------------------------------------------------### */

#ident "@(#) ASIMUT : A SIMUlation Tool running on a VHDL description V1.9"
#include <stdio.h>
#include <string.h>
#include <mut309.h>
#include <mlo402.h>
#include <log120.h>
#include <beh104.h>
#include <pat103.h>
#include "../util/vh_utype.h"
#include "../util/vh_utdef.h"
#include "../linker/vh_ltype.h"
#include "vh_asimut.h"
#include "vh_asdef.h"

extern char MVL_ERRFLG;

main (argc,argv)

int   argc;
char **argv;

  {
  struct chain      *pt_chain;
  int                i , j , patindx;
  int                max_err;
  int                max_delta;
  char               aux_flg     = 1;
  char               init_flg    = 0;
  char               sdebug_flg  = 0;
  char               bdebug_flg  = 0;
  char               pdebug_flg  = 0;
  char               ldebug_flg  = 0;
  char               cdebug_flg  = 0;
  char               ddebug_flg  = 0;
  char               behav_flg   = 0;
  char               nosim_flg   = 0;
  char               nores_flg   = 0;
  char               makbdd_trc  = 0;
  struct lofig      *ptlofig;
  struct befig      *ptbefig = NULL;
  struct befig      *ptbef;
  struct chain      *ptchain;
  struct papat      *pt_papat;
  struct paseq      *pt_paseq;
  char              *str;
  char              *env_valu = NULL;
  char              *buffer;
  struct chain      *search_lst = NULL;
  struct chain      *patsfx_lst = NULL;
  struct chain      *strsfx_lst = NULL;
  struct chain      *behsfx_lst = NULL;
  struct chain      *libpath;
  struct chain      *suffix;
  FILE              *filepnt;
  struct dct_entry **hshtab;
  char               result_file[100];
struct chain  *cur_chain;
struct chain  *order;

  FAST_MODE = 'Y';

  if (argc == 1)
    {
    (void)fprintf(stdout,"ASIMUT %s.\n", vhu_avers());
    vhu_message (1,NULL,0);
    exit (0);
    }

  if (!strcmp(argv[1],"-help"))
    {
    (void)fprintf (stdout,"ASIMUT %s.\n", vhu_avers());
    system ("man asimut");
    exit (0);
    }

  (void)fprintf(stdout,"           A       SSSSS     III    M     M   U     U  TTTTTTT\n");
  (void)fprintf(stdout,"          A A     S     S     I     MM   MM   U     U     T\n");
  (void)fprintf(stdout,"         A   A    S           I     M M M M   U     U     T\n");
  (void)fprintf(stdout,"        A     A    SSSSS      I     M  M  M   U     U     T\n");
  (void)fprintf(stdout,"        AAAAAAA         S     I     M     M   U     U     T\n");
  (void)fprintf(stdout,"        A     A   S     S     I     M     M   U     U     T\n");
  (void)fprintf(stdout,"        A     A .  SSSSS  .  III .  M     M .  UUUUU  .   T  .\n");
  (void)fprintf(stdout,"\n");
  (void)fprintf(stdout,"            A       Simulation                  Tool\n");
  (void)fprintf(stdout,"\n");
  (void)fprintf(stdout,"\n");
  (void)fprintf(stdout,"          Alliance CAD tool\n");
  (void)fprintf(stdout,"          Product : ASIMUT\n");
  (void)fprintf(stdout,"          (c) copyright 1991,1992,1993 MASI lab., CAO & VLSI\n");
  (void)fprintf(stdout,"          Paris, FRANCE, Europe, Earth, Solar system, Milky Way, ...\n");
  (void)fprintf(stdout,"          All rights reserved\n");
  (void)fprintf(stdout,"          Support : e-mail cao-vlsi@masi.ibp.fr\n");
  (void)fprintf(stdout,"\n\t\t\t %s\n\n", vhu_avers());

	/* ###------------------------------------------------------### */
	/*    Initialize :						*/
	/*      - BDD hash tables					*/
	/*      - get MBK environment variables				*/
	/*      - set option flags					*/
	/* ###------------------------------------------------------### */

  vhu_message (2,NULL,0);
  initializeBdd (0);
  mbkenv();

  for (i=2 ; i<argc ; i++)
    {
    if (!strcmp(argv[i],"-t"))
      makbdd_trc = 1;

    if (!strcmp(argv[i],"-aux"))
      aux_flg = 0;

    if (!strcmp(argv[i],"-i"))
      init_flg = i + 1;

    if (!strcmp(argv[i],"-nores"))
      nores_flg = 1;

    if (!strcmp (argv[i],"-c"))
      nosim_flg = 1;

    if (!strcmp(argv[i],"-b"))
      behav_flg = 1;

    if (!strncmp(argv[i],"-d",2))
      {
      for (j=2 ; argv[i][j]!='\0' ; j++)
        {
        switch (argv[i][j])
          {
          case 's':
            sdebug_flg = 1; break;
          case 'b':
            bdebug_flg = 1; break;
          case 'l':
            ldebug_flg = 1; break;
          case 'p':
            pdebug_flg = 1; break;
          case 'c':
            cdebug_flg = 1; break;
          case 'd':
            ddebug_flg = 1; break;
          }
        }
      }
    }
	/* ###------------------------------------------------------### */
	/*    Read the maximum number of simulation errors from the	*/
	/* environment variable VH_MAXERR				*/
	/* ###------------------------------------------------------### */

  str = getenv ("VH_MAXERR");
  if(str != NULL)
    {
    env_valu = (char *)mbkalloc((unsigned int)(strlen(str) + 1) * sizeof(char));
    (void)strcpy (env_valu,str);
    }
  if ((env_valu == NULL) || (sscanf(env_valu,"%d",&max_err) == 0))
    max_err = 10;

	/* ###------------------------------------------------------### */
	/*    Create the list of search libraries from the environment	*/
	/* variable VH_LIBLST						*/
	/* ###------------------------------------------------------### */

  env_valu = NULL;
  str = getenv ("VH_LIBLST");
  if(str == NULL)
    {
    str = getenv ("MBK_CATA_LIB");
    }
  if(str != NULL)
    {
    env_valu = (char *)mbkalloc((unsigned int)(strlen(str) + 1) * sizeof(char));
    (void)strcpy (env_valu,str);
    }
  if (env_valu == NULL)
    search_lst = addchain (NULL,".");
  else
    {
    buffer = strtok (env_valu,":");
    do
      search_lst = addchain (search_lst,buffer);
    while ((buffer = strtok (NULL,":")) != NULL);

    search_lst = (struct chain *) reverse (search_lst);
    } 
	/* ###------------------------------------------------------### */
	/*    Create list of suffix for pattern description files from	*/
	/* the environment variable VH_PATSFX				*/
	/* ###------------------------------------------------------### */

  env_valu = NULL;
  str = getenv ("VH_PATSFX");
  if (str != NULL)
    {
    env_valu = (char *)mbkalloc((unsigned int)(strlen(str) + 1) * sizeof(char));
    (void)strcpy(env_valu,str);
    }
  if (env_valu == NULL)
    patsfx_lst = addchain (NULL,"pat");
  else
    {
    buffer = strtok (env_valu,":");
    do
      patsfx_lst = addchain (patsfx_lst,buffer);
    while ((buffer = strtok (NULL,":")) != NULL);

    patsfx_lst = (struct chain *) reverse (patsfx_lst);
    }

	/* ###------------------------------------------------------### */
	/*    Searching the root file					*/
	/* ###------------------------------------------------------### */

  vhu_message (5,argv[1],0);
  
	/* ###------------------------------------------------------### */
	/*    If there is no structural level call directly the		*/
	/* behaviour compiler						*/
	/* ###------------------------------------------------------### */

  if (behav_flg == 1)
    {

	/* ###------------------------------------------------------### */
	/*    Running the behavioural compiler on the current file	*/
	/* ###------------------------------------------------------### */

    ptbefig    = vhdlloadbefig (ptbefig, argv[1], 1);
    VHU_ERRFLG = ptbefig->ERRFLG;

    if (bdebug_flg == 1)
      dast_dbg (ptbefig,"befig");

    if (VHU_ERRFLG == 0)
      {
      vhu_message (15,NULL,0);
      beh_makbdd (ptbefig, aux_flg, makbdd_trc);
      beh_freabl (ptbefig);
      }

    }
  else
    {
	/* ###------------------------------------------------------### */
	/*    Running the structural compiler on the root file		*/
	/* ###------------------------------------------------------### */

    vhu_message(4,argv[1],0);
    
    VHS_LOFPNT = getlofig(argv[1], 'A');
    VHU_ERRFLG = MVL_ERRFLG;
    if (sdebug_flg == 1)
      dast_dbg (HEAD_LOFIG,"lofig");

    if (VHU_ERRFLG != 0)
      {
      vhu_error (200,NULL);
      exit (1);
      }

    (void)fprintf(stderr,"Flattening the root figure\n");
    rflattenlofig (VHS_LOFPNT,'.','y');

    if (sdebug_flg == 1)
      dast_dbg (HEAD_LOFIG,"lofig");

    ptchain = VHS_LOFPNT->MODELCHAIN;
    while (ptchain != NULL)
      {

	/* ###------------------------------------------------------### */
	/*    Searching behaviour files					*/
	/* ###------------------------------------------------------### */

      vhu_message(5,ptchain->DATA,0);

	/* ###------------------------------------------------------### */
	/*    Running the behavioural compiler on the current file	*/
	/* ###------------------------------------------------------### */

      ptbef         = ptbefig;
      ptbefig       = vhdlloadbefig (ptbefig,(char *)ptchain->DATA,1);
      ptbefig->NEXT = ptbef;
      VHU_ERRFLG    = ptbefig->ERRFLG;


      if (VHU_ERRFLG == 0)
        {
        vhu_message(15,NULL,0);
        beh_makbdd (ptbefig, aux_flg, makbdd_trc);
        beh_freabl (ptbefig);
        }
      ptchain = ptchain->NEXT;
      }
    }

  if (bdebug_flg == 1)
    dast_dbg (ptbefig,"befig");

  if (VHU_ERRFLG != 0)
    {
    vhu_error (200,NULL);
    exit (1);
    }

  if (nosim_flg == 1)
    exit (0);

	/* ###------------------------------------------------------### */
	/*    Searching the pattern description file			*/
	/* ###------------------------------------------------------### */

  vhu_message(6,argv[2],0);

  libpath = search_lst;
  while (libpath != NULL)
    {
    suffix  = patsfx_lst;
    while ( suffix != NULL)
      {
      sprintf(VHU_CURFIL,"%s/%s.%s",libpath->DATA,argv[2],suffix->DATA);
      if ((filepnt = fopen (VHU_CURFIL,"r")) != NULL)
        break;
      suffix = suffix->NEXT;
      }
    if (suffix != NULL)
      break;
    libpath = libpath->NEXT;
    }

	/* ###------------------------------------------------------### */
	/*    Running the pattern description compiler on the current	*/
	/* file								*/
	/* ###------------------------------------------------------### */

  if (filepnt == NULL)
    {
    vhu_error (100,argv[2]);
    exit (1);
    }

  vhu_message(8,VHU_CURFIL,0);
  pt_paseq = pat_prspat (NULL, filepnt, 0);
  fclose (filepnt);

  if (pdebug_flg == 1)
    dast_dbg (pt_paseq,"paseq");

  if (pt_paseq->ERRFLG != 0)
    {
    vhu_error (200,NULL);
    exit (1);
    }

	/* ###------------------------------------------------------### */
	/*    Link previous structures to create the simulator's data	*/
	/* base structures						*/
	/* ###------------------------------------------------------### */

  hshtab = vhu_initab ();

  vhu_message (16,NULL,0);


  if (behav_flg == 1)
    ptlofig = vhl_makgst (ptbefig);

  vhl_resord (hshtab,HEAD_LOFIG,ptbefig);
  if (sdebug_flg == 1)
    dast_dbg (HEAD_LOFIG,"lofig");

  vhl_restor (hshtab,HEAD_LOFIG,ptbefig);
  if (sdebug_flg == 1)
    dast_dbg (HEAD_LOFIG,"lofig");

  if (VHU_ERRFLG != 0)
    {
    vhu_error (200,NULL);
    exit (1);
    }

  vhu_message (9,NULL,0);

  vhl_linker (hshtab, pt_paseq, aux_flg);

  if (ldebug_flg == 1)
    dast_dbg (VHL_HEDLKF,"lkdfig");
  if (pdebug_flg == 1)
    dast_dbg (pt_paseq,"paseq");

  if (VHU_ERRFLG != 0)
    {
    vhu_error (200,NULL);
    exit (1);
    }

  if (init_flg != 0)
    {
    if ((filepnt = fopen (argv[init_flg], "r")) == NULL)
      {
      }
    else
      {
      VHU_ERRFLG = vhx_initfig (VHL_HEDLKF, filepnt);
      fclose (filepnt);
      }
    }

  if (VHU_ERRFLG != 0)
    {
    vhu_error (200,NULL);
    exit (1);
    }

  /* ###------------------------------------------------------------### */
  /*    Simulating the current figure					*/
  /* ###------------------------------------------------------------### */

  pt_papat = pt_paseq->PAPAT;
  patindx  = 0;
  while ((pt_papat != NULL) && (max_err > 0))
    {
    max_delta = VHX_DLTDFN;

	/* ###------------------------------------------------------### */
	/*    Read a new pattern					*/
	/* ###------------------------------------------------------### */

    vhu_message (10, NULL, patindx);
    if (pt_papat->ACTFLAG == 'I')
      vhx_inireg (hshtab, pt_papat->PAINI);

    vhx_redpat  (pt_paseq, pt_papat);

	/* ###------------------------------------------------------### */
	/*    Start the execution of the pattern			*/
	/* ###------------------------------------------------------### */

    vhx_update ();

    if (ddebug_flg == 1)
      dast_dbg (VHL_HEDLKF,"lkdfig");

    while ((VHX_EVENT != NULL) && (max_delta > 0))
      {
      vhx_execute ();

/*========================================================================

if (max_delta < 9000)
  {
printf ("---------------- delta %d ----------------------\n",max_delta);
printf ("      ------- signals --------\n");
pt_chain = VHX_SIGUPD;
while (pt_chain != NULL)
  {
  printf ("%s=%c\n",((struct simsig *)pt_chain->DATA)->NAMECHAIN->DATA,
                    *(((struct simsig *)pt_chain->DATA)->CURVAL));
  pt_chain = pt_chain->NEXT;
  }
printf ("\n");
printf ("      ------- buses --------\n");
pt_chain = VHX_BUSUPD;
while (pt_chain != NULL)
  {
  printf ("%s=%c\n",((struct bussig *)pt_chain->DATA)->NAMECHAIN->DATA,
                    *(((struct bussig *)pt_chain->DATA)->CURVAL));
  pt_chain = pt_chain->NEXT;
  }
printf ("\n");
printf ("      ------- registers --------\n");
pt_chain = VHX_REGUPD;
while (pt_chain != NULL)
  {
  printf ("%s.%s=%c\n",((struct wrireg *)pt_chain->DATA)->LKDINS->INSNAME,
                       ((struct wrireg *)pt_chain->DATA)->BEREG->NAME,
                       *(((struct wrireg *)pt_chain->DATA)->CURVAL));
  pt_chain = pt_chain->NEXT;
  }
printf ("\n");
printf ("      ------- internal sigs --------\n");
pt_chain = VHX_AUXUPD;
while (pt_chain != NULL)
  {
  printf ("%s.%s=%c\n",((struct wriaux *)pt_chain->DATA)->LKDINS->INSNAME,
                       ((struct wriaux *)pt_chain->DATA)->BEAUX->NAME,
                       *(((struct wriaux *)pt_chain->DATA)->CURVAL));
  pt_chain = pt_chain->NEXT;
  }
printf ("\n");
  }
========================================================================*/

      vhx_update  ();
      max_delta--;

      if (ddebug_flg == 1)
        dast_dbg (VHL_HEDLKF,"lkdfig");
      }

    if (cdebug_flg == 1)
      dast_dbg (VHL_HEDLKF,"lkdfig");

    if (max_delta <= 0)
      break;

    max_err -= vhx_wrtpat (pt_paseq, pt_papat);
    if (pdebug_flg == 1)
      dast_dbg (pt_paseq,"paseq");

    if (vhx_chkerr() == 1)
      break;
    pt_papat = pt_papat->NEXT;
    patindx++;
    }

  if (max_delta <= 0)
    vhu_error (105,NULL);

  if (max_err <= 0)
    vhu_error (106,NULL);

  if (pdebug_flg == 1)
    dast_dbg (pt_paseq,"paseq");

  /* ###------------------------------------------------------------### */
  /*    Driving the pat structure 					*/
  /* ###------------------------------------------------------------### */

  if (nores_flg == 0)
    {
    if (pt_paseq->SAVFLG == 'Y')
      {
      sprintf (VHU_CURFIL,"%s.sav",argv[1]);
      if ((filepnt = fopen (VHU_CURFIL, "w")) == NULL)
        {
        vhu_error (107,NULL);
        exit (1);
        }
      vhx_savall (VHL_HEDLKF, filepnt);
      fclose (filepnt);
      }

  /* ###------------------------------------------------------------### */
  /*    Creating the filename of the result file			*/
  /* ###------------------------------------------------------------### */

    if(strchr(argv[3],'.') == NULL)
      sprintf(result_file,"%s.%s",argv[3],patsfx_lst->DATA);
    else
      sprintf(result_file,"%s",argv[3]);

    if ((filepnt = fopen (result_file,"w")) == NULL)
      {
      vhu_error (107,NULL);
      exit (1);
      }
    pat_drvpat (pt_paseq, filepnt);
    fclose (filepnt);
    }

  exit (0);
  }
