#include <X11/Xlib.h>
#include <X11/X.h>
#include <X11/cursorfont.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#define MAXX 1010
#define MAXY 758
#define NORES 1
#define VPERI vdigsl[0]
#define VPLEIN vdigsl[1]
#define VFCOL vdigsl[2]
#define VWI vdigsl[3]
#define VHE vdigsl[4]
#define VXO vdigsl[5]
#define VYO vdigsl[6]
#define LARGEUR 2

static int vdigsl[16];

Display *mdisplay;
int mscreen_number;
GC mcontext;

XGCValues mcvalue;

Window wlola;
Pixmap patern[20],toto;
XSizeHints hin;
XEvent ev;
unsigned long event_mask;
Colormap mcmap;
long colors[16];
int lestyle;

Font font_id[2];
XWindowAttributes attrib;
Cursor curs[10];
static char pat1[]={0x55,0x55,0x55,0x55,0x55,0x55,0x55,0x55};
static char pat2[]={0x42,0x81,0x18,0x24,0x24,0x18,0x81,0x42};
static char pat3[]={0xff,0x00,0xff,0x00,0xff,0x00,0xff,0x00};
static char pat4[]={0x81,0x42,0x24,0x18,0x18,0x24,0x42,0x81};
static char pat5[]={0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff};/*caracteres*/
static char pat6[]={0x7e,0xff,0xff,0xe7,0xe7,0xff,0xff,0x7e};
static char pat7[]={0x10,0x08,0x10,0xaa,0x55,0x08,0x10,0x08};
static char pat8[]={0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa,0xaa};
static char pat9[]={0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa};
static char pat10[]={0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa};
static char pat11[]={0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x81};
/*static char pat1[]={0xf0f0,0xfaf0,0xfaf0,0xf0f0};*/


/****************************************************************************/
/*                   fonction d'initialisation des fenetres....             */
/****************************************************************************/



gemappl_init()
{
int i;

 if(!(mdisplay=XOpenDisplay(0)))
   {
    fprintf(stderr," erreur: mauvais terminal graphique\n");
    exit(1);
   }
 mscreen_number=XDefaultScreen(mdisplay);
 mcmap=DefaultColormap(mdisplay,mscreen_number);
 vdi_coul();
hin.x=0;
hin.y=0;
hin.width=DisplayWidth(mdisplay,0)-20;
hin.height=DisplayHeight(mdisplay,0)-45;
hin.flags=PPosition|PSize;
wlola=XCreateSimpleWindow(mdisplay,DefaultRootWindow(mdisplay),hin.x,hin.y,hin.width,hin.height,1,XWhitePixel(mdisplay,mscreen_number),colors[NOIR]);
XSetStandardProperties(mdisplay,wlola,"ALLIANCE",None,None,None,0,&hin); 
 event_mask=KeyPressMask|ExposureMask|ButtonPressMask|PointerMotionMask|SubstructureNotifyMask;
 XSelectInput(mdisplay,wlola,event_mask);
 mcvalue.foreground=XWhitePixel(mdisplay,mscreen_number);
 mcvalue.background=colors[NOIR];
 mcvalue.fill_style=FillStippled;
 toto=XCreateBitmapFromData(mdisplay,wlola,pat1,16,16);
 mcvalue.stipple=toto;
 mcontext=XCreateGC(mdisplay,wlola,(GCForeground|GCStipple|GCFillStyle|GCBackground),&mcvalue);
 font_id[1]=XLoadFont(mdisplay,"9x15");
 XSetFont(mdisplay,mcontext,font_id[1]);
 XSetForeground(mdisplay,mcontext,VFCOL=colors[NOIR]);
 XSetBackground(mdisplay,mcontext,colors[NOIR]);
 XSetInputFocus(mdisplay,PointerRoot,RevertToNone,CurrentTime);
 patern[DEN00]=XCreateBitmapFromData(mdisplay,wlola,pat1,8,8);
 patern[DEN01]=XCreateBitmapFromData(mdisplay,wlola,pat8,8,8);
 patern[DEN02]=XCreateBitmapFromData(mdisplay,wlola,pat3,8,8);
 patern[DEN03]=XCreateBitmapFromData(mdisplay,wlola,pat4,8,8);
 patern[DEN04]=XCreateBitmapFromData(mdisplay,wlola,pat5,8,8);
 patern[DEN05]=XCreateBitmapFromData(mdisplay,wlola,pat1,8,8);
 patern[DEN06]=XCreateBitmapFromData(mdisplay,wlola,pat10,8,8);
 patern[DEN07]=XCreateBitmapFromData(mdisplay,wlola,pat11,8,8);
 
 init_cur();
 vdisf_interior(0,SOLID);
 vdisf_style(0,DEN04);
}
/****************************************************************************/
/*                desactive la fenetre wlola                                */
/****************************************************************************/
vdi_term()
{
 XUnmapWindow(mdisplay,wlola); 
}

/****************************************************************************/
/*              fonction appele au debut qui attribut une forme aux curseurs*/
/****************************************************************************/

init_cur()
{
curs[CMENU]=XCreateFontCursor(mdisplay,XC_hand2);
curs[CGRAF]=XCreateFontCursor(mdisplay,XC_crosshair);
curs[CKEYB]=XCreateFontCursor(mdisplay,XC_question_arrow);
curs[CTEMP]=XCreateFontCursor(mdisplay,XC_watch);
} 

/*************************************************************************/
/*  fonction reactivant la fenetre apres un vditerm                      */
/*************************************************************************/


vdi_grap()
{
XMapWindow(mdisplay,wlola);
urefresh();
}

/*************************************************************************/

vdi_opnwk()
{
XMapWindow(mdisplay,wlola);
 XSynchronize(mdisplay,0);
}

/*************************************************************************/

gemgraf_handle()
{return(1);}



/***************************************************************************/
/*  procedure servant a determiner la couleur de la surface a remplir      */
/***************************************************************************/



vdisf_color(handle,col)
int handle,col;
{
if (VFCOL!=col)
	{
	XSetForeground(mdisplay,mcontext,VFCOL=colors[col]);
	VFCOL=col;
	}
}


/***************************************************************************/
/*  cette procedure permet de dessiner un rectangle plein ou vide (en fonc-*/
/*  -tion de VPLEIN) la variable pxy passe  par variable etant un tableau  */
/* dont la structure est la suivante pxy[0]=xi, pxy[1]=yi ,pxy[2]=xf,      */
/* pxy[3]=yf                                                               */
/***************************************************************************/



vdi_bar(handle,pxy)
int handle,*pxy;
{
 if(VPLEIN)
   XFillRectangle(mdisplay,wlola,mcontext,pxy[0],pxy[3],pxy[2]-pxy[0]+1,pxy[1]-pxy[3]+1);
 else
   XDrawRectangle(mdisplay,wlola,mcontext,pxy[0],pxy[3],pxy[2]-pxy[0],pxy[1]-pxy[3]);
}


/***************************************************************************/


vdisf_style(handle,no)
cnat handle,no;
{
/*XSetTile(mdisplay,mcontext,patern[no]);*/
XSetStipple(mdisplay,mcontext,patern[no]);
}

/***************************************************************************/


vdis_color()
{}

/***************************************************************************/

vdiswr_mode()
{}

/***************************************************************************/
/*       fonction permettant de commuter de mode "plein" en mode           */
/*                 contour restectivement style HOLLOW et ...              */
/***************************************************************************/


vdisf_interior(handle,style)
cnat handle,style;
{
 switch(style)
	{
 	case SOLID: XSetFillStyle(mdisplay,mcontext,FillSolid);VPLEIN=1;
		    break;

	case PATTERN:
	            XSetFillStyle(mdisplay,mcontext,FillStippled);VPLEIN=1;
		    break;

	case HOLLOW:
		    VPLEIN=0;
	}
}

/**************************************************************************/ 
/* fonction effectuant le choix du curseur courant                        */
/**************************************************************************/


gemgraf_mouse(nb,ty)
cnat nb,*ty;
{
XDefineCursor(mdisplay,wlola,curs[nb]);
}

/**************************************************************************/
/*         fonction renvoyant la taille de la fenetre wlola               */
/**************************************************************************/


gemGetrez()
        {
 	XWindowAttributes locwin;
	 HTEXT=30;
	 LTEXT=18;
  	XGetWindowAttributes(mdisplay,wlola,&locwin);	
         RESOLX(NORES)=locwin.width;
         RESOLY(NORES)=locwin.height;
         return(NORES);
        }

/**************************************************************************/

gemappl_exit()
       {}

/**************************************************************************/

vdi_clswk()
       {}
/**************************************************************************/

vdist_point()
{}

/****************************************************************************/
/*                permet de definir la couleur du texte                     */
/****************************************************************************/


vdist_color(handle,cl)        
int handle ,cl;
{
if (VFCOL!=cl)
	{
	XSetForeground(mdisplay,mcontext,colors[cl]);
	VFCOL=cl;
	}
}

/****************************************************************************/


vdisin_mode()
{}

/****************************************************************************/
/*          fonction permettant d'afficher du texte                         */
/****************************************************************************/


vdi_gtext(handle,x,y,str)
int handle,x,y;
char *str;

{
XDrawString(mdisplay,wlola,mcontext,x,y-2,str,strlen(str));
}

/***************************************************************************/
/*                  permet de dessiner une boite, avec un cadre            */
/*        et un interieur noir                                             */
/***************************************************************************/

vdi_rfbox(handle,pxy)
int handle,*pxy;
{
 cnat temp,type;

temp=VFCOL;
type=VPLEIN;
vdisf_color(0,NOIR);
VPLEIN=1;   
vdi_bar(0,pxy);
VPLEIN=0;
vdisf_color(0,temp);
vdi_bar(0,pxy);
VPLEIN=type;
}

/***************************************************************************/
/* apres un evenement de resizing de la fenetre                            */
/***************************************************************************/

resize()
{
cnat tres,d1,d2,d3,d4,d;
tres=gemGetrez();
        graph.xo=0;graph.yo=((RESOLY(tres)-6)<<1)-HTEXT;y0ecran=graph.yo;
        graph.dx=(RESOLX(tres)-1)<<1;graph.dy=((RESOLY(tres)-6)<<1)-HTEXT;
        info.xo=0;info.yo=(RESOLY(tres)-1)<<1;
        info.dx=(RESOLX(tres)-1)<<1;info.dy=HTEXT+8;
        menu.xo=((RESOLX(tres)-1)<<1)-16*LTEXT;menu.yo=((RESOLY(tres)-6)<<1)-HTEXT;
        menu.dx=16*LTEXT;menu.dy=((RESOLY(tres)-6)<<1)-HTEXT;
        graph.res=config->reso;
        info.res=config->reso;
        menu.res=config->reso;
        xfen=yfen=0l;
	xmire=ymire=2l;
        if (config->grille) grille();
}    
/***************************************************************************/
/* cette fonction  permet d'attendre un evenement de la souris             */
/* xa et ya sont passe par variable et recoivent les coordonnees du point  */
/* de cliquage, de plus la variable term passe elle aussi par variable     */
/* contient l'identificateur du bouton clique  a savoir 31:bouton gauche   */
/* 32:milieu  33:droit                                                     */
/***************************************************************************/


vdism_locator(handle,x,y,xf,yf,term)
cnat handle,x,y,*xf,*yf;   
cnat *term;
{int i,j;
/*XSync(mdisplay,VRAI);*/
*term=31;
while(1)
	{
 	XNextEvent(mdisplay,&ev);
	if(ev.type==ButtonPressMask)
		{
		if (((XButtonEvent *)(&ev))->window==wlola)
		{
		*term+=((XButtonEvent *)(&ev))->button;
		*xf=((XButtonEvent *)(&ev))->x;
		*yf=((XButtonEvent *)(&ev))->y;
		break;
		}
		}
	if (ev.type==MotionNotify)
			if (((XMotionEvent *)(&ev))->window==wlola)
			{
			*xf=((XMotionEvent *)(&ev))->x;
			*yf=((XMotionEvent *)(&ev))->y;
			break;
			}
	if (ev.type==Expose)
		{
			if (((XExposeEvent *)(&ev))->window==wlola)
			{
 			XSetInputFocus(mdisplay,PointerRoot,RevertToNone,CurrentTime);
resize();
			urefresh();	
			break;
			}
		}	

	}
}
/****************************************************************************/



vdirq_string()
{}


/****************************************************************************/
/*          fonction renvoyant un caractere tape au clavier                 */
/****************************************************************************/


gemCrawcin() 
{char aux[2];
KeySym key;
XSetInputFocus(mdisplay,PointerRoot,RevertToNone,CurrentTime);
/*XSync(mdisplay,VRAI);*/
do 
	{
	while(!XCheckWindowEvent(mdisplay,wlola,KeyPressMask,&ev));
	XLookupString((XKeyEvent *)(&ev),aux,1,&key,0);
	}
while ((key==XK_Shift_L)||(key==XK_Shift_R));
if (aux[0]==0x0d) aux[0]='\n';
return((cnat)aux[0]);
} 


/****************************************************************************/


gemgraf_rubbox()
{}


/****************************************************************************/


gemCursconf()
{

}


/****************************************************************************/
/*                    nettoyage de la fenetre                               */
/****************************************************************************/



vdi_clrwk(handle)
int handle;
{
 XClearWindow(mdisplay,wlola);
}

/***************************************************************************/ 


vdi_opnwq()
{}

/***************************************************************************/
/*    determine la couleur d un polyline                                   */
/***************************************************************************/


vdisl_color(handle,index)
int handle,index;
{
if(VFCOL!=index)
	{
	XSetForeground(mdisplay,mcontext,VFCOL=colors[index]);
	VFCOL=index;
	}
}



/**************************************************************************/

vdisf_perimeter()
{}


/*************************************************************************/
/*     fonction servant a tracer un polyline                             */
/*************************************************************************/



vdi_pline(handle,count,pxy)
int handle,count,*pxy;
{
 int i;

if(count>16) return(1);
if(count==2)
	XDrawLine(mdisplay,wlola,mcontext,pxy[0],pxy[1],pxy[2],pxy[3]);
}

 
/***************************************************************************/
/* initialisation de la table des couleurs on notera que la couleur d'indice*/
/* 0 represente la couleur du fond de la fenetre, la couleur 1 etant celle */
/* utilise par defaut pour tracer les contours                             */
/***************************************************************************/



vdi_coul()
{
XColor coul,crgb;

XAllocNamedColor(mdisplay,mcmap,"black",&coul,&crgb);
colors[NOIR]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"blue",&coul,&crgb);
colors[BLEU]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"brown",&coul,&crgb);
colors[BRUN]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"cyan",&coul,&crgb);
colors[CYAN]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"turquoise",&coul,&crgb);
colors[FCYAN]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"green",&coul,&crgb);
colors[VERT]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"light green",&coul,&crgb);
colors[CVERT]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"light red",&coul,&crgb);
colors[CROUGE]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"light blue",&coul,&crgb);
colors[CBLEU]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"white",&coul,&crgb);
colors[BLANC]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"red",&coul,&crgb);
colors[ROUGE]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"magenta",&coul,&crgb);
colors[MAGEN]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"grey",&coul,&crgb);
colors[GRIS]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"orange",&coul,&crgb);
colors[ORANGE]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"yellow",&coul,&crgb);
colors[JAUNE]=coul.pixel;
XAllocNamedColor(mdisplay,mcmap,"pink",&coul,&crgb);
colors[ROSE]=coul.pixel;
}

/****************************************************************************/

vdirq_locator(handle,x,y,xf,yf,term)
cnat handle,x,y,*xf,*yf,*term;
{
/*XSync(mdisplay,VRAI);*/
*term=0x1f;
XWarpPointer(mdisplay,None,wlola,x,y,0,0,x,y);
while(1)
	{
 	XNextEvent(mdisplay,&ev);
	if(ev.type==ButtonPressMask)
		{
		if (((XButtonEvent *)(&ev))->window==wlola)
		{
		*term+=((XButtonEvent *)(&ev))->button;
		*xf=((XButtonEvent *)(&ev))->x;
		*yf=((XButtonEvent *)(&ev))->y+(HTEXT>>1);
		break;
		}
		}
	else
	if (ev.type==Expose)
		{
			if (((XExposeEvent *)(&ev))->window==wlola)
			{
 			XSetInputFocus(mdisplay,PointerRoot,RevertToNone,CurrentTime);
			/*urefresh();*/
			break;
			}
		}	
	}
}

/***************************************************************************/  

vdist_alignment()
{}

/***************************************************************************/  


vdi_show_c(handle,x,y)
cnat handle,x,y;
{
/* XFlush(mdisplay); */
XWarpPointer(mdisplay,None,wlola,x,y,0,0,x,y);
}

/***************************************************************************/  

vdi_hide_c()
{
}

vdi_get_pixel()
	{
	}

vdi_copyarea(handle,pxy,xf,yf)
cnat handle,*pxy,xf,yf;
	{
	XCopyArea(mdisplay,wlola,wlola,mcontext,pxy[0],pxy[3],pxy[2]-pxy[0],pxy[1]-pxy[3],xf,yf);
	}


grille()
{
	cnat x, y;
	cnat pxy[4];
	lnat gx, gy;

	if (graph.res < 6) 
		return(1);
	vdi_hide_c(graph.handle);
	vdisl_color(graph.handle, BLANC);
	gx = (lnat)((graph.xo + (graph.res >> 1)) / graph.res) * graph.res;
	gy = y0ecran - ((lnat)((y0ecran - graph.yo + (graph.res >> 1)) / graph.res) * graph.res);
	for (x = gx; x <= graph.xo + graph.dx; x += graph.res)
		for (y = gy; y >= graph.yo - graph.dy; y -= graph.res) {
			XDrawPoint(mdisplay,wlola,mcontext,x>>1,y>>1);
		}
}

/*********************************************************************************/
/*                                g_souris                                       */
/* but : attend qu'un bouton de la souris soit presse, analyse le deplacement    */
/* parametre :                                                                   */
/*   flag : g_souris stocke dans ce parametre la zone de l'ecran cliquee         */
/*   stat : si != 0 indique la deuxieme saisie pour une fonction (permet de      */
/*          remettre a jour les dx et dy de la zone info du bas)                 */
/*********************************************************************************/
g_souris(flag,stat,indic)
cnat *flag,stat;
char * indic;
{
	cnat x1,x2,y1,y2,term;
	uchar flg;

	gemgraf_mouse(CGRAF,&term);
	term=0;
	*flag=0;
	c_rel(xmire,ymire,&x1,&y1);
	x2=x1;y2=y1;
	if (stat)
		{
			gsourisdx=xmire;
			gsourisdy=ymire;
		}
	vdi_show_c(graph.handle,x1>>1,y1>>1);
	while(1)
		{
			flg=0;
			if (acc_souris)
				{
					vdism_locator(menu.handle,x1>>1,y1>>1,&x2,&y2,&term);
					x2 <<= 1;
					y2 <<= 1;
				}
			else
				clavier1(x1,y1,&x2,&y2,&term);
			ch=(char)term;
			if ((x1!=x2)||(y1!=y2))
				flg=1;
			x1=x2;y1=y2;
			if ((ch==0x20)||(ch==0x21)||(ch==0x22))
				{
					ch+=0x11;
					ch = (ch == '1')?'2':(ch == '2')?'1':'3';
					if (ch=='2') 
						if (y2>graph.yo)
							{
								ch='3';
								return(0);
							}
					if (y2<=graph.yo-graph.dy+16)
						*flag=6;
					else
						if (x2<=graph.xo)
							*flag=4;
						else
							if (x2>=graph.xo+graph.dx)
								*flag=5;
							else
								if (y2>=graph.yo)
									*flag=7; 
								else
									*flag=0;
				} /* if */
			if (flg)
				{
					if (!zoom)
						{
							x2 = (lnat)((x2 + (graph.res>>1)) / graph.res) * graph.res;
							y2 = y0ecran - ((lnat)((y0ecran - y2 + (graph.res>>1)) / graph.res) * graph.res);
						}
					xmire=(lnat)(((x2-graph.xo)<<zoom)/(graph.res>>1))+xfen;
					if (xmire<0l)
						xmire=xfen;
					if (y2<=graph.dy)
						ymire=(lnat)(((graph.yo-y2)<<zoom)/(graph.res>>1))+yfen;
					else
						ymire=yfen;
					if (ymire<0l)
						ymire=yfen;
					if (!(acc_souris))
						vdi_show_c(graph.handle,x1>>1,y1>>1);
					dxinfo(xmire-gsourisdx,ymire-gsourisdy,indic);
#ifdef PC
					show_souris();
#endif
				} /* if */
# ifdef TIME
			info_time();
# endif
			if (ch>=0x31)
				{
					vdi_hide_c(graph.handle);
					break;
				}
	} /* while */
	return(0);
} /* g_souris */

