/*********************************************************************/
/*                      Declarations de types.                       */
/*********************************************************************/

        typedef struct {
                       uchar plot;
                       uchar attr;
                       } point;

        typedef struct fenetre {
                        cnat xo;
                        cnat yo;
                        cnat dx;
                        cnat dy;
                        cnat res;
                        cnat handle;
                       } fenetre;


        typedef struct st_menu  {
                                char nb_options;
                                char titre[TTITRE];
                                char options[NB_MAX][TTITRE];
                                union   {
                                        cnat (*fonction)();
                                        struct st_menu *menu_appel;
                                        } choix[NB_MAX];
                                } tmenu;

        typedef struct st_config {

                                cnat nation;
                                cnat niaff;
                                cnat lam;
                                cnat grille;
				cnat affnomcon;
				cnat fibremoy;
				cnat stick_diagram;
                                uchar style;
                                char pat[20];
                                uchar reso;
                                uchar teinte[7];
                                uchar autom;
				uchar rlog;
                                } tconfig;

        struct st_bens {
                        cnat mode ;
                        cnat cle ;
                        cnat scale ;
                        unsigned char coul[30] ;
                       } bens ;


		typedef struct st_segment {
								lnat x,y,dx,dy;
								uchar layer;
								} segment;
        typedef struct st_motif   {
                                char name[16];
								lnat nbseg;
								segment tab_seg[8];
								lnat xbb,ybb,dxbb,dybb;
								lnat xab,yab,dxab,dyab;
                                } motif;

        typedef struct st_setup
                        {
                        char path[80];
			char pathfile[80];
			char pathcatal[80];
                        char capa_nom[TAILLE_CHAINE];
                        char fond_nom[TAILLE_CHAINE];
                        char mode;                      /* 0 = Micron .                                 */
                                                        /* 1 = Symbolique .                             */

                        struct st_config defconf;       /* Valeur par defaut de la configuration .      */

                        struct st_niveau {
                                cnat nb;                /* Nombre de niveaux a afficher .               */
                                char nom[16][16];        /* Noms des niveaux .                           */
                                uchar couleur[19];      /* Couleurs des niveaux .                       */
                                uchar super[16][2];    /* Table des superpositions de couleurs .       */
                                uchar maxniv;
                                lnat contact[16];       /* Table des contacts physiques entre niveaux . */
                                } niveau;
                        struct st_declar {
                                char entdir[3];         /* Prefixe des noms d'entrees .                 */
                                char sordir[3];         /* Prefixe des noms de sorties .                */
                                cnat nbservi;
                                char servi[16][6];      /* Table des noms de servitudes (sauf alims)    */
                                cnat nbalim;
                                char alim[16][6];       /* Table des noms d'alimentations .             */
                                } declar;
                        struct st_periph {
                                char souris;            /* Type souris  : 0 = Pas de souris .           */
                                                        /*                1 = Souris parallele .        */
                                                        /*        2 = Souris serie .                    */

                                char traceur;           /* Type traceur : 0 = Pas de traceur .          */
                                                        /*        1 = Traceur BENSON .                  */
                                                        /*       ...= Autre .                           */
                                } periph;
                        struct st_outils {
                                char routeur[20];       /* Nom du routeur .                             */
                                char compilateur[20];   /* Nom du compilateur de cellules.              */
                                char testeur[20];       /* Nom du testeur sur masques.                  */
                                char simulateur[20];    /* Nom du simulateur logique.                   */
                                } outils;

                        struct st_syntaxe {
				char sufflog[5];        /* suffixe des fichiers logiques.               */
				char suffphy[5];        /* suffixe des fichiers physiques .              */
                                char titre[80];
				char prefixe_flatten[10];
				char nom_du_catal[80];
				lnat taille_du_catal;
                                } syntaxe;


                        struct  {
                                cnat nbmotif;
                                motif tab_motif[16];
 				lnat tab_layer[16][16];
                               } motifs;
			uchar up,down,right,left,c1,c2,c3;
			uchar rep;
			cnat moti;
            lnat ext[16]; /* extension longitudinale pour le symbolique */
            lnat wmin[16]; /* largeur minimal d'un segment */
            lnat version; /* version du setup */
                        } type_setup;


    typedef struct bbab
        {
            char * nom;
            lnat xbb,ybb,dxbb,dybb;
            lnat xab,yab,dxab,dyab;
        } type_bbab;




/*********************************************************************/
/*********************************************************************/
/*                      Variables globales.                          */
/*********************************************************************/

	
        extern lnat xmire;      /* Abscisse mire.                            */
        extern lnat ymire;      /* Ordonnee   " .                            */
        extern lnat xfen;       /* Abscisse fenetre d'affichage.             */
        extern lnat yfen;       /* Ordonnee    "          "    .             */
        extern char zoom;       /* 2(zoom+1)=nbre de lambda dans un pixel.  */
        extern char fichier[TAILLE_CHAINE];/* Nom du fichier en traitement.             */

        extern desc *fbuf1;     /*      Buffers.     */


        extern cnat reso[2][10];
	extern cnat texatt[2];

        extern lnat status;

	extern cnat dfonc,dmenu,fmenu;

        extern char ch; /* Dernier caractere saisi au clavier.       */
        extern char special;   /* Si special=VRAI, le caractere vient du    */
                        /* pave numerique, si special=FAUX le cara-  */
                        /* ctere vient du clavier.                   */
        extern fenetre graph,menu,info; /* Fenetres d'affichage.             */

        extern tmenu menus[NB_MENUS];   /* Menus.                            */
        extern tconfig *config,mconfig;  /* Configuration editeur.           */




        extern lnat nligne,colonne;
        extern lnat xo,yo,y0ecran;
	extern lnat gsourisdx, gsourisdy;
        extern type_setup *setup;
        extern cnat *fpil,*fpil1,*fpil2;
        extern char **catal;
        extern cnat num_eq;
        extern char *fbuf2;
        extern type_bbab * cache_bbab;
	extern lnat lundo;
extern type_bbab * cherche_bbab();
extern char * namealloc();
