
# line 21 "t_yacc.VER"

# include <stdio.h>

# define  STOPERROR 1	/* arret ou non de la generation en cas d'erreur  */

# define  NBMAXCHB  256	/* longueur max d'un nom de bloc	*/
# define  NBMAXCHAR  256	/* longueur max d'un nom d'objet divers	*/

# define  NBMAXN  1000	/* bornes des tables internes des objets du generateur, voir ci-dessous	*/
# define  NBMAXS  100
# define  NBMAXNS 40
# define  NBMAXB  200
# define  NBMAXF  20 
# define  NBMAXI  40
# define  NBMAXE  20
# define  NBMAXZ  10
# define  NBMAXFLE  1000
# define  FIN	  -1

# define SIMPLE 0	/* mode regles simples, corps simple seulement autorise	*/
# define ALL 1		/* mode regles composees, tout corps autorise		*/
# define EXFAM 2	/* mode interdisant les familles dans une inter. ou env.*/

# define  ENRIEN -1	/* specification de l'axe d'une verif	*/ 
# define  ENX  1
# define  ENY  0
# define  ENXY  2
# define  LONGIT 3
# define  TRANSV 4
# define  FENTRE 5
# define  FENTRX 7
# define  FENTRY 6
# define  FENTXY 8

# define  XSY  0	/* spec de proportion pour la verif rapport	*/
# define  YSX  1
# define  LONLAR  2
# define  LARLON  3

# define  MINI  0	/* spec de borne inf ou max d'une verif		*/
# define  MAXI	1

# define  ERRWRITE     -1	/* # types d'erreur lors de la generation, voir la fonc. yyerror()	*/
# define  ERRINEXIST	1
# define  ERRTODESCR	2
# define  ERRORDRE	3
# define  ERRAXE	4
# define  ERRTABN	5
# define  ERRTABS	6
# define  ERRTABB	7
# define  ERRTABF	8
# define  ERRTABI	9
# define  ERRTABE	10
# define  ERRTABZ	11
# define  ERRFLE	12
# define  ERROPEN	13
# define  ERRCALLOC 	14
# define  ERREXIST	15
# define  ERRSIMPLE	16
# define  ERREXFAM	17

# if STOPERROR
#	define  OUTERR  ;goto yyerrlab;
# else
#	define  OUTERR  ;
# endif


/* types des elements des tables internes, ces tables (i.e. tables de symboles) permettent de retrouver l'indice d'un objet dans la table des corps a partir de ses caracteristiques	*/

typedef  struct { int  ind;
		  char  nom[NBMAXCHAR];
		} typ_n ;

typedef  struct { int  ind;
		  char  pere[NBMAXCHAR];
		  char  sscode[NBMAXCHAR];
		} typ_s ;

typedef  struct { int  ind;
		  char  nom[NBMAXCHB];
		} typ_b ;

typedef  struct { int  ind;
		  char  nom[NBMAXCHAR]; 
		} typ_f ;

typedef  struct { int  ind;
		  int  ic1, ic2;
		} typ_i ;

typedef  struct { int  ind;
		  int  ec1, ec2;
		} typ_e ;

typedef  struct { int  ind;
		  int  x, y, dx, dy;
		} typ_z ;

typedef  struct { int  no;
		  int  attrib;
		} typfle ;

                 
typedef	struct	{
			int ctm,nbv;
			unsigned char niv,listniv[NBMAXN],etat;
		}typ_chv;

typedef struct 	{
			int adrs,nbelmt;
			int listniv[NBMAXN];
		}typ_fchv;

typedef struct 	{
			unsigned char list[NBMAXN];
		}typ_niv_list;

typedef struct 	{
			int list[NBMAXN];
		}typ_elmt_list;


int nbdescr=0;		/* Nbre de descr. d'un tuple dans une boucle  	*/
int noregle=0;		/* No interne de la regle courante 	      	*/
int dftfle=1000;	/* No par defaut attribue aux feuilles non num	*/
int nbmaxmbre=0; 	/* max du champ membre[] de la var famille	*/
int nbmaxbloc=0;        /* nbre de blocs de CATAL[]                     */
int nbmaxmotif=0;	/* nombre de motif de MOTIF[].			*/
int corc=(-1);		/* corps courant d'une regle monodescr 		*/
int dirc=ENXY;		/* axe de verification courant d'une regle	*/
int rapc=0;		/* proportion courante d'un rapport dans 1 regle*/
int bornc=MINI;		/* borne courante de verification dans une regle*/
int corps_able=SIMPLE;	/* autorisation des differents types de corps	*/
int zoned=0;		/* indicateur de fenetrage d'une regle		*/
int ir_c=0;		/* indice de remplissage de CATAL		*/
int ir_tc=0;		/* indice de remplissage de TAB_CORPS  		*/
int ir_n=0;		/* indice de remplissage de tab_n      		*/
int ir_s=0;		/* indice de remplissage de tab_s      		*/
int ir_b=0;		/* indice de remplissage de tab_b      		*/
int ir_f=0;		/* indice de remplissage de tab_f      		*/
int ir_i=0;		/* indice de remplissage de tab_i      		*/
int ir_e=0;		/* indice de remplissage de tab_e      		*/
int ir_z=0;		/* indice de remplissage de tab_z      		*/
int ir_tdm=0;           /* indice de remplissage de DIMMIN[]         */
int ir_tml=0;		/* indice de remplissage de TAB_MLEVEL[]	*/
int irprm=0;		/* indice de remplissage de TAB_PARAM[] 	*/
int irvfc=0;		/* indice de remplissage de TAB_VFONC[]		*/
int irint=0;		/* indice de remplissage de TINTERSE[],TENVELO[]*/
int irenv=0;
int irfle=0;		/* indice de remplissage de tabfle     		*/
int irepart=0;		/* indice de remplissage de TAB_REPAR[noregle] */
int nbmaxfle,nbmaxprm=0;/* Max des 2 indices precedants			*/
int nbmaxvfc=0;
int maxrec=5;		/* val Max des parametres, pour le recouvrement */
int noligne=1;		/* No de la ligne courante du fichier source	*/
int typerror=0;		/* type d'une erreur lors de la generation	*/
int QUAL=0;		/* teste par les comparateurs			*/
int cpt_chv=0;		/* compteur des niveaux concernes de CHAINV[]   */
int cpt_fchv=0;		/* compteur de familles				*/
int cpt_echv=0;		/* compteur d'elements equipotentiels		*/
int cur_val=0;		/* valeur de PUT_ctm() dans le cas ou la regle  */
			/* elementaire courante s'exprime comme une     */
			/* Vexpression.					*/
int cur_ad1,cur_ad2;	/* adresses dans tab_c[] des corps de la Vexpres*/
int OK_VDISTANCE=0;	/* on fait PUT_ctm() que pour les DISTANCEs.	*/	
int nbvmax=0;
int codbloc;		/* id du premier bloc.				*/
int cpt_totbloc=0;	/* compteur de blocs declares.			*/
int cpt_rulparam=0;	/* curent size of curent rule tab of parameters.*/
int PLUS1c=0;		/* Flag for > 2corps rules.			*/
int OUTa=0;		/* not inside a specific area ... 		*/

/* tables internes des objets manipules par le generateur	*/

typ_n		tab_n[NBMAXN];
typ_s		tab_s[NBMAXS];
typ_b		tab_b[NBMAXB];
typ_f		tab_f[NBMAXF];
typ_i		tab_i[NBMAXI];
typ_e		tab_e[NBMAXE];
typ_z		tab_z[NBMAXZ];
typfle		tabfle[NBMAXFLE];
typ_chv 	tab_chv[NBMAXN];
typ_fchv	tab_fchv[NBMAXN];
int		tab_echv[NBMAXN];
unsigned char 	tab_niv_chv[NBMAXN];
int 		tab_nbv_chv[NBMAXN];
int 		tab_ctm_chv[NBMAXN];
int 		tab_etat_chv[NBMAXN];
typ_niv_list	tab_list_chv[NBMAXN];
int 		tab_adrs_fchv[NBMAXN];
int 		tab_nbelmt_fchv[NBMAXN];
typ_elmt_list	tab_list_fchv[NBMAXN];
int 		rule_param[NBMAXN];

FILE *ifnD, *ifnV, *ifnR, *ifnF, *ifnH;	/* fichiers objets a generer	*/

struct typobjln { 
                  char  nom[NBMAXCHAR];
		} ;

struct typobjlm {
                  int  mbre;
		} ;


typedef	struct { int code, obj; } typorient;

char *calloc(),*realloc();

struct typobjln *ptrln;  /* pointeur sur le debut d'1 liste_nom */
int szln=1;  /* taille de la liste_nom :sa valeur courante est  */
             /* > d'1 unite a la taille reelle de liste_nom     */
int szwln;   /* taille d'1 mot de type tstruct typobjln         */

struct typobjlm *ptrlm;
int szlm=1;
int szwlm;

/* valeur initiale des ID des niveaux declares */
unsigned char LID0=6;

/* variable de test de declaration de caisson et de l'echelle*/
int DCAISSON=0,DECHELLE=0,lechelle;

/* compteur pour les statistiques */
int cpt_inst,cpt_trans,cpt_via,cpt_cont;

/* compteur pour les equipotentielles */
int cpt_equip=0,nbelmt_equip_max=0,nb_nivlrg=0;

int CLOSE1=0;


# line 257 "t_yacc.VER"
typedef union  { 
	char chaine[NBMAXCHAR] ;
	int  entier ;
	struct typobjln *objln;
	struct typobjlm *objlm;
	char *opcomp;
	typorient  orient;
       } YYSTYPE;
# define NOM 257
# define NOMBRE 258
# define NOMBRE1 259
# define NBRECHL 260
# define VERIFICATIONS 261
# define SUR 262
# define TECHNO 263
# define COMPRENANT 264
# define NIVEAU 265
# define FAMILLE 266
# define DE 267
# define REGLE 268
# define CHAQUE 269
# define ET_EN 270
# define DESCR 271
# define COMPOSEE 272
# define ET 273
# define OU 274
# define NON 275
# define VERIFIE 276
# define SI 277
# define ALORS 278
# define SINON 279
# define LARGEUR 280
# define LONGUEUR 281
# define ZONE 282
# define LARGEUR1 283
# define LONGUEUR1 284
# define DIMENSION 285
# define SURFACE 286
# define RAPPORT 287
# define DIMENSION1 288
# define SURFACE1 289
# define RAPPORT1 290
# define POSITION 291
# define MULTIPLE 292
# define ORIENTATION 293
# define POSITION1 294
# define UPLET 295
# define ORIENTATION1 296
# define A 297
# define PARTIR 298
# define BLOC 299
# define EN 300
# define MIN 301
# define MAX 302
# define INF 303
# define SUP 304
# define INFE 305
# define SUPE 306
# define EG 307
# define NEG 308
# define ACCOLEMENT 309
# define SUPERPOSE 310
# define DESSUS 311
# define LE 312
# define VERIFIER 313
# define PRESENCE 314
# define DISTANCE 315
# define EXTENSION 316
# define ENTRE 317
# define INCLUSION 318
# define RECOUVREMENT 319
# define DANS 320
# define SUPERPOSITION 321
# define TRANSVERSALEMENT 322
# define LONGITUDINALEMENT 323
# define CARACTERISE 324
# define PAR 325
# define RELATIVE 326
# define GEODESIQUE 327
# define AXIALE 328
# define TOUT 329
# define VNOMBRE 330
# define ENVELOPPE 331
# define INTERSECTION 332
# define EN1 333
# define COMMA 334
# define COLON 335
# define SCOLON 336
# define AMPERSAND 337
# define LBRACK 338
# define RBRACK 339
# define POIN 340
# define DIAL 341
# define LPAR 342
# define RPAR 343
# define X 344
# define Y 345
# define REMBRACE 346
# define LEMBRACE 347
# define DESSIN 348
# define SYMBOLIQUE 349
# define MICRON 350
# define DIRECTIVE 351
# define ECHELLE 352
# define INSTANCE 353
# define TRANSISTOR 354
# define VIA 355
# define CONTACT 356
# define STATISTIQUE 357
# define LARGE 358
# define EQUIP 359
# define MARGE 360
# define PSEUDO 361
# define TRANSPARENT 362
# define POUR 363
# define OPAQUE 364
# define DEHORS 365
# define PLUS 366
# define MOINS 367
# define MUL 368
# define DIV 369
# define MOD 370
# define MOINS_UNA 371
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 2845 "t_yacc.VER"


#include "lex.yy.c"

/* routine d'affichage des erreurs de generation d'apres typerror  */

void yyerror(chnx)
char *chnx;
   { fprintf(stderr,"ligne %d (ou ligne %d) : ",noligne,noligne+1);
     fclose(ifnD);
     fclose(ifnV);
     fclose(ifnR);
     fclose(ifnF);
     fclose(ifnH);
     switch (typerror)
      {	case ERRINEXIST : fprintf(stderr,"corps non declare\n"); break; 
      	case ERREXIST :{ fprintf(stderr,"corps deja declare\n"); 
     			fprintf(stderr,"\n%s\n",chnx);
			}
	break;
      	case ERRTODESCR : fprintf(stderr,"trops de descr. pour cette regle\n"); break; 
      	case ERRORDRE : fprintf(stderr,"un No de descr depasse 999\n"); break; 
	case ERRAXE : fprintf(stderr,"un axe precis doit etre specifie imperativement\n");break;
      	case ERRTABN : fprintf(stderr,"trop de niveaux declares, agrandir tab_n\n"); break; 
      	case ERRTABS : fprintf(stderr,"trop de ss_niveaux declares, agrandir tab_s\n"); break; 
      	case ERRTABB : fprintf(stderr,"trop de blocs declares, agrandir tab_b\n"); break; 
      	case ERRTABF : fprintf(stderr,"trop de familles declarees, agrandir tab_f\n"); break; 
      	case ERRTABI : fprintf(stderr,"trop d'intersections declarees, agrandir tab_i\n"); break; 
      	case ERRTABE : fprintf(stderr,"trop d'enveloppes declarees, agrandir tab_e\n"); break; 
      	case ERRTABZ : fprintf(stderr,"trop de zones declarees, agrandir tab_z\n"); break; 
	case ERRFLE : fprintf(stderr,"trop de feuilles pour une regle, agrandir tabfle\n");break;
      	case ERRCALLOC : fprintf(stderr,"allocation memoire impossible\n"); break; 
      	case ERROPEN : fprintf(stderr,"erreur en ouverture lors de la generation\n"); break; 
	case ERRSIMPLE : fprintf(stderr,"corps composes interdits dans ce bloc\n"); break;
	case ERREXFAM : fprintf(stderr,"familles interdites dans une intersection ou une enveloppe\n"); break;
	case ERRWRITE : fprintf(stderr,"erreur en ecriture lors de la generation\n");break;
	default : fprintf(stderr,"erreur de syntaxe\n");break;
      }
}



yywrap()
{
	return(1);
}


/* routines de generation dans les fichiers JMZdefine, JMZinitvar, JMZfdrc  */
/* JMZihdrc, JMZregles.						    		  */
/* hfdrc # hdebfdrc+JMZfdrc+hfinfdrc et hidrc # hdebihdrc+JMZhdrc+hfinhidrc.	  */

generD(s,x1,x2,x3)
char *s;
{ 
	typerror=fprintf(ifnD,s,x1,x2,x3);
	if (typerror==(-1)){ 
		yyerror("");
		exit(1);
	}
}

generV(s,x1,x2,x3)
char *s;
{
	typerror=fprintf(ifnV,s,x1,x2,x3);
	if (typerror==(-1)){
	      	yyerror("");
		exit(1);
	}
}

generR(s,x1,x2,x3,x4)
char *s;
{
	typerror=fprintf(ifnR,s,x1,x2,x3,x4);
	if (typerror==(-1)) {
	      	yyerror("");
		exit(1);
	}
}

generF(s,x1,x2,x3,x4)
char *s;
{
	typerror=fprintf(ifnF,s,x1,x2,x3,x4);
	if (typerror==(-1)) {
	      	yyerror("");
		exit(1);
	}
}

generH(s,x1,x2,x3,x4)
char *s;
{
	typerror=fprintf(ifnH,s,x1,x2,x3,x4);
	if (typerror==(-1)) {
	      	yyerror("");
		exit(1);
	}
}


/* fonction de recherche d'une feuille dans tabfle par son No et renvoie sa place attribuee dans descr[]  */

cherchfle(ind)
int ind; {int i;
	  for(i=0;i<irfle;i++)
	     if (tabfle[i].no==ind)
		return(tabfle[i].attrib);
	  return(-1);
	 }


/* fonctions de recherche d'une intersection [ resp. d'une enveloppe ] dans tab_i [ resp. tab_e ] et renvoie sa place dans TAB_CORPS, -1 sinon	*/

cherch_i(mi1,mi2)
int mi1,mi2;  {	int i;
		for(i=0;i<ir_i;i++)
		   if (tab_i[i].ic1==mi1 && tab_i[i].ic2==mi2)
		      return(tab_i[i].ind);
		return(-1);
	      }

cherch_e(me1,me2)
int me1,me2;  {	int i;
		for(i=0;i<ir_e;i++)
		   if (tab_e[i].ec1==me1 && tab_e[i].ec2==me2)
		      return(tab_e[i].ind);
		return(-1);
	      }

/*------------------------------------------------------------*/
/*  fonction de recherche de l'indice dans TAB_CORPS[],d'1    */
/*  niveau.                                                   */
/*------------------------------------------------------------*/
int cherch_n(name)
char *name;
{
int i;
char *namet;
  for (i=0;i<NBMAXN;i++)
  {
    namet=tab_n[i].nom;
    if (strcmp(name,namet)==0)
    return(tab_n[i].ind);
  }
  return(-1);
}

/*-----------------------------------------------------------*/
/*  fonction de recherche de l'indice dans TAB_CORPS[],d'1   */
/*  sous_niveau.                                             */
/*-----------------------------------------------------------*/
int cherch_s(father,sscode)
char *father,*sscode;
{
int i;
char *fathert,*sscodet;
  for (i=0;i<NBMAXS;i++)
  {
    fathert=tab_s[i].pere;sscodet=tab_s[i].sscode;
    if (strcmp(father,fathert)==0)
    {
      if (strcmp(sscode,sscodet)==0)
      return(tab_s[i].ind);
    }
  }
  return(-1);
}

/*------------------------------------------------------------*/
/*  fonction de recherche de l'indice dans TAB_CORPS[],d'1    */
/*  bloc.                                                     */
/*------------------------------------------------------------*/
int cherch_b(name)
char *name;
{
int i;
char *namet;
  for (i=0;i<NBMAXB;i++)
  {
    namet=tab_b[i].nom;
    if (strcmp(name,namet)==0)
    return(tab_b[i].ind);
  }
  return(-1);
}

/*------------------------------------------------------------*/
/*  fonction de recherche de l'indice dans TAB_CORPS[],d'1    */
/*  famille.                                                  */
/*------------------------------------------------------------*/
int cherch_f(name)
char *name;
{
int i;
char *namet;
  for (i=0;i<NBMAXF;i++)
  {
    namet=tab_f[i].nom;
    if (strcmp(name,namet)==0)
    return(tab_f[i].ind);
  }
  return(-1);
}

/*------------------------------------------------------------*/
/*  fonction de recherche de l'indice dans TAB_CORPS[],d'1    */
/*  zone                                                      */
/*------------------------------------------------------------*/
int cherch_z(x,y,dx,dy)
int x,y,dx,dy;
{
int i,xt,yt,dxt,dyt;
  for (i=0;i<NBMAXZ;i++)
  {
    if (x==xt)
    {
      if (y==yt)
      {
        if (dx==dxt)
        {
          if (dy==dyt)
          return(tab_z[i].ind);
        }
      }
    }
  }
  return(-1);
}


OK_concerne(adres)
int adres;
{
int i;

	if( adres < ir_n ){
		tab_etat_chv[adres]=1;

		if(PLUS1c){
			for(i=0;i<cpt_rulparam;i++){
				if(rule_param[i] == adres)
					return;
			}
			rule_param[cpt_rulparam]=adres;
			cpt_rulparam++;
		}
	}
}


OK_Fconcerne(adres)
int adres;
{
int i,j;

	for(i=0;i<cpt_fchv;i++){
		if( tab_adrs_fchv[i] == adres ){
			for(j=0;j<tab_nbelmt_fchv[i];j++)
				OK_concerne(tab_list_fchv[i].list[j]);
			for(j=0;j<(tab_nbelmt_fchv[i]-1);j++)
				OK_voisin(tab_list_fchv[i].list[j],tab_list_fchv[i].list[j+1]);
		}
	}


}



OK_voisin(adrs1,adrs2)
int adrs1,adrs2;
{
int nbv1,nbv2,i,lcpt=0;

	if( (adrs1<ir_n)&&(adrs2<ir_n) ){
		nbv1=tab_nbv_chv[adrs1];
		nbv2=tab_nbv_chv[adrs2];
		for(i=0;i<=nbv1;i++){
			if(tab_list_chv[adrs1].list[i] == tab_niv_chv[adrs2])
				break;	
		}
		if((i-1) == nbv1){
			tab_list_chv[adrs1].list[nbv1]=tab_niv_chv[adrs2];
			tab_nbv_chv[adrs1]=nbv1+1;	
			if( (nbv1+1) > nbvmax )
				nbvmax=nbv1+1;
		}
		for(i=0;i<=nbv2;i++){
			if(tab_list_chv[adrs2].list[i] == tab_niv_chv[adrs1])
				break;
		}
		if((i-1) == nbv2){
			tab_list_chv[adrs2].list[nbv2]=tab_niv_chv[adrs1];
			tab_nbv_chv[adrs2]=nbv2+1;	
			if( (nbv2+1) > nbvmax )
				nbvmax=nbv2+1;
		}
	}
	else
		OK_Fvoisin(adrs1,adrs2);
}



OK_Fvoisin(adrs1,adrs2)
int adrs1,adrs2;
{
int i,j,fam1=0,fam2=0,ok_fam1=0,ok_fam2=0,fam,simpl;

	for(i=0;i<cpt_fchv;i++){
		if(tab_adrs_fchv[i] == adrs1){
			fam1=i;ok_fam1++;
		}
		if(tab_adrs_fchv[i] == adrs2){
			fam2=i;ok_fam2++;
		}
	}

	if( (ok_fam1 != 0) && (ok_fam2 != 0) ){
		for(j=0;j<tab_nbelmt_fchv[fam1];j++){
			for(i=0;i<tab_nbelmt_fchv[fam2];i++)
				OK_voisin(tab_list_fchv[fam1].list[j],tab_list_fchv[fam2].list[i]);
		}
	}
	else{
		if( (ok_fam1 != 0)&&(adrs2<ir_n) ){ 
			fam=fam1;simpl=adrs2;
		}
		else{
			if( (ok_fam2 != 0)&&(adrs1<ir_n) ){
				fam=fam2;simpl=adrs1;
			}
		}
		if(simpl<ir_n){
			for(i=0;i<tab_nbelmt_fchv[fam];i++)
				OK_voisin(tab_list_fchv[fam].list[i],simpl);
		}
	}
}



PUT_ctm(adrs1,adrs2,valr)
int adrs1,adrs2,valr;
{
int i;

	if( (adrs1 >= 0) && (adrs2 >= 0) ){
		if( (adrs1<ir_n) && (adrs2<ir_n) ){
			if( tab_ctm_chv[adrs1] < valr )
				tab_ctm_chv[adrs1]=valr;
			if( tab_ctm_chv[adrs2] < valr )
				tab_ctm_chv[adrs2]=valr;
		}
		else
			PUT_Fctm(adrs1,adrs2,valr);
	}
}



PUT_Fctm(adrs1,adrs2,valr)
int adrs1,adrs2,valr;
{
int i,j,fam1=0,fam2=0,ok_fam1=0,ok_fam2=0,fam,simpl;

	for(i=0;i<cpt_fchv;i++){
		if(tab_adrs_fchv[i] == adrs1){
			fam1=i;ok_fam1++;
		}
		if(tab_adrs_fchv[i] == adrs2){
			fam2=i;ok_fam2++;
		}
	}

	if( (ok_fam1 != 0) && (ok_fam2 != 0) ){
		for(j=0;j<tab_nbelmt_fchv[fam1];j++){
			for(i=0;i<tab_nbelmt_fchv[fam2];i++)
				PUT_ctm(tab_list_fchv[fam1].list[j],tab_list_fchv[fam2].list[i],valr);
		}
	}
	else{
		if( (ok_fam1 != 0)&&(adrs2<ir_n) ){ 
			fam=fam1;simpl=adrs2;
		}
		else{
			if( (ok_fam2 != 0)&&(adrs1<ir_n) ){
				fam=fam2;simpl=adrs1;
			}
		}
		if(simpl<ir_n){
			for(i=0;i<tab_nbelmt_fchv[fam];i++)
				PUT_ctm(tab_list_fchv[fam].list[i],simpl,valr);
		}
	}
}



PUT_chainv()
{
int i,j=0,k,ok_reflex=0;

	for(i=0;i<ir_n;i++){
		if(tab_etat_chv[i]){
			j=tab_niv_chv[i]-LID0;
			generV("\nCHAINV[%d].niv=%d;",j,tab_niv_chv[i]);
			for(k=0;k<tab_nbv_chv[i];k++){
				generV("\nCHAINV[%d].list_niv_a[%d]=1;",j,(tab_list_chv[i].list[k]-LID0));
				if(tab_niv_chv[i] == tab_list_chv[i].list[k])
					ok_reflex++;
			}
			if( (!ok_reflex) && (tab_nbv_chv[i]>0) ){
			/* we might generete the curent level as its own neighbour 	*/
		 	/* we are allowed to do that only if curent level has at least	*/
			/* one neighbour, already !!.					*/
				generV("\nCHAINV[%d].list_niv_a[%d]=1;	/* Rflx */",j,j);
				k++;
			}

			generV("\nCHAINV[%d].etat=1;",j);
			generV("\nCHAINV[%d].nb_niv_a=%d;",j,k);
			generV("\nCHAINV[%d].ctm=%d;\n",j,tab_ctm_chv[i]);
			
			ok_reflex=0;
/*
			j++;
*/
		}
	}
/*
	cpt_chv=j;
*/

}



main()
{
      	ifnD=fopen("JMZdefine","w");	/* ouverture des fichiers objets  */
	if (!ifnD) {
	       typerror=ERROPEN; 
		yyerror("");
		exit(1);
	}

      	ifnV=fopen("JMZinitvar","w");
	if (!ifnV){
	       	typerror=ERROPEN; 
		yyerror("");
		exit(1);
	}
	generV("\n\n/*===        debut de l'initialisation des variables.      ===*/\n\n");

      	ifnF=fopen("JMZfdrc","w");
	if (!ifnF){
	       	typerror=ERROPEN; 
		yyerror("");
		exit(1);
	}

      	ifnH=fopen("JMZihdrc","w");
	if (!ifnV){
	       	typerror=ERROPEN; 
		yyerror("");
		exit(1);
	}

      	ifnR=fopen("JMZregles","w");
	if (!ifnR) {
	       	typerror=ERROPEN; 
		yyerror("");
		exit(1);
	}
	generR("\n\n/*===            debut de generation des fonction_regles.		===*/\n");

	return(yyparse()); 	/* analyse du texte source et generation des fichiers objets	*/

}


short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 239,
	267, 1,
	-2, 134,
-1, 246,
	267, 1,
	-2, 135,
-1, 247,
	267, 1,
	-2, 136,
-1, 276,
	267, 1,
	-2, 133,
-1, 298,
	267, 1,
	-2, 137,
-1, 478,
	267, 1,
	-2, 204,
-1, 479,
	267, 1,
	-2, 205,
-1, 480,
	267, 1,
	-2, 206,
-1, 537,
	267, 1,
	-2, 203,
-1, 541,
	267, 1,
	-2, 207,
-1, 598,
	267, 1,
	-2, 216,
-1, 601,
	267, 1,
	-2, 217,
-1, 603,
	267, 1,
	-2, 218,
-1, 632,
	267, 1,
	-2, 213,
-1, 633,
	267, 1,
	-2, 214,
-1, 634,
	267, 1,
	-2, 215,
-1, 677,
	267, 1,
	-2, 212,
-1, 678,
	267, 1,
	-2, 211,
	};
# define YYNPROD 230
# define YYLAST 984
short yyact[]={

 239, 282, 191, 658,   5, 250,   9, 347,  12, 196,
  16, 285, 518,  19, 409, 407, 206,  26, 346, 174,
  33, 249, 281,  75,  41, 212, 213, 214, 215, 216,
 217, 457, 458,  49, 370, 432, 433, 434, 435, 436,
 104,  56,  82, 220, 221, 102,  81, 374, 219, 222,
 223,  90, 456,  67, 225,  50, 224,  73,  20, 132,
 270, 116,  78,  97, 351,  79, 348,  67,  40, 353,
 354,   6,  83,  89, 352, 355, 356,  58,  28,  96,
 358,  43, 357, 207, 208, 209, 210, 211, 432, 433,
 434, 435, 436, 174, 434, 435, 436, 115, 366, 209,
 210, 211, 172, 367, 359, 360,  29, 365, 362, 161,
 363, 158,  23,  91, 536, 474, 131, 163, 164, 368,
 350, 364, 162, 165, 166, 457, 458, 171, 168, 275,
 167, 372, 233,  42, 198, 197, 349, 432, 433, 434,
 435, 436, 237, 238, 149, 577, 576, 575, 574, 361,
 324, 323, 176, 322, 321, 374, 371, 207, 208, 209,
 210, 211, 301, 287, 190, 286, 289, 290, 302, 388,
 201, 205, 351, 332, 289, 290, 172, 353, 354, 138,
 387, 159, 352, 355, 356,  86, 522,  53, 358, 627,
 357, 453, 272, 227, 145, 246, 247, 142, 199, 200,
 140, 171, 109, 254, 255, 133, 366, 256, 117, 106,
  98, 367, 359, 360,  80, 365, 362,  60, 363,  14,
 620, 190, 617, 616, 580, 571, 533, 368, 205, 364,
 280, 608, 465, 268, 399, 395, 336, 276, 313, 372,
  82, 152, 288, 151, 349,  52, 137, 136, 139, 298,
 524, 511, 510, 523, 303, 417, 525, 361, 306, 420,
 421, 174, 416, 192, 371,  61, 308, 309, 310, 296,
 297, 644, 312, 614, 316, 600, 212, 213, 214, 215,
 216, 217, 112, 110, 111, 163, 164, 203, 410, 269,
 162, 165, 166, 288, 277, 410, 168, 279, 167, 320,
 278, 410, 596, 331, 556, 240, 341, 555, 342, 177,
 382, 381, 343, 607, 418, 547, 546, 382, 381, 376,
 192, 339, 317, 382, 381, 150, 660, 509, 288, 455,
 245, 333, 380, 283, 284, 389, 390, 192, 386, 207,
 208, 209, 210, 211, 172, 398, 204, 241,  37, 188,
 688, 242, 410, 202, 408, 698, 402, 378, 228, 657,
 379, 619, 408, 408, 408, 469, 414, 408, 403, 171,
 377, 629, 415, 419, 382, 381, 422, 423, 424, 244,
 243, 427, 382, 381, 613, 581, 192, 431, 628, 288,
  38, 396, 554, 629, 543, 397, 397, 460, 459, 462,
 454, 304,  59, 300, 299, 584, 437, 452, 471, 472,
 318, 473, 478, 479, 480, 232, 585, 483, 484, 475,
 319, 234, 408, 408, 113, 476, 492, 493,  30, 495,
 496, 497, 535, 485, 157, 404, 487, 488, 400, 401,
 408, 274, 186, 182, 183, 670, 669, 631, 408, 408,
 408, 630, 508, 552, 504, 519, 464, 463,  68, 419,
 526, 527, 512, 513, 514,  94, 498, 499, 500, 501,
 502, 503, 405,  17,  10, 155, 101, 701, 537, 700,
 699, 534, 541, 542, 683, 681, 680, 545, 679, 676,
 548, 549, 550, 668, 667, 553, 665, 656, 651, 626,
 622, 538, 539, 540, 606, 599, 558, 559, 560, 589,
 588, 587, 408, 408, 567, 566, 568, 569, 570, 565,
 561, 572, 573, 557, 562, 544, 563, 564, 532, 578,
 579, 529, 528, 521, 520, 517, 516, 515, 416, 507,
 506, 505, 494, 491, 490, 592, 489, 593, 594, 486,
 482, 481, 598, 174, 477, 601, 602, 603, 604, 468,
 586,  34, 605, 430, 590, 429, 609, 610, 611, 161,
 428, 426, 425, 413, 615, 412, 411, 163, 164, 394,
 384, 344, 162, 165, 166, 338, 337, 335, 168, 334,
 167, 325, 621, 184, 311, 307, 632, 633, 634, 305,
 636, 637, 202, 267, 266, 265, 257, 640, 641, 642,
 253, 248, 236, 646, 647, 648, 195, 230, 231, 649,
 650, 635, 194, 652, 638, 193, 639,  85,  76, 107,
  74,  13, 659, 659, 645, 661, 172, 643, 612, 597,
 595, 159, 551, 252, 671, 672, 673, 251,  45,   7,
   3, 128, 127, 126,  93, 662, 663, 664,  57, 677,
 666, 171, 678, 374, 189, 674, 583, 273, 470, 467,
 466, 659, 659, 686, 687, 461, 393, 392, 385, 345,
 340, 271, 374, 326, 327, 353, 354, 696, 697, 121,
 352, 355, 356, 704, 703, 702, 358, 695, 357, 694,
 690, 691, 693, 692, 439, 440, 689, 685, 684, 438,
 441, 442, 682, 675, 366, 444, 655, 443, 654, 367,
 359, 360, 653, 365, 362, 625, 363, 624, 623, 618,
 591, 582, 531, 450, 530, 368, 391, 364, 327, 445,
 446, 330, 329, 448, 295, 449, 181, 372,  44, 328,
 292, 291, 406, 383, 451, 179, 178, 119, 144, 143,
 125, 123, 103,  92,  70, 361, 372,  65,  63,  54,
  51, 170, 371, 156, 160, 154,  64,  35, 100,  66,
  36, 130, 114,  95, 447,  77,  27, 373, 369, 315,
 173, 371, 294, 293, 169, 148, 314, 229, 147, 135,
 153, 129,  25,  99,  46,  62,  48,  32,  47,  31,
  18,  11,  88,  72,  87,  71,  55,  39,  22,  21,
  24,  15,   8,   4,   2, 375, 175, 108,   1,   0,
   0,   0,   0,  69,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,  84,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0, 105,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 118,   0,   0, 120,   0,
 122,   0,   0, 124, 264,   0,   0,   0,   0,   0,
   0,   0,   0,   0, 134,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 141,   0,   0,   0,   0,   0,   0, 146,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 180,
   0,   0,   0, 185,   0,   0, 187,   0,   0,   0,
   0,   0,   0, 218, 226,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 235,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 258, 259,
 260, 261, 262, 263 };
short yypact[]={

 389,-1000,-280, 387, 205,-1000, 366,-116,-1000,-1000,
 202,-1000,-1000,-300,-236,-251,-1000, 152, 295,-1000,
  91,-1000,-284,-216,-1000,-1000,-1000,-1000, 490, 386,
-1000,-304,-1000,-1000, 513, -89,-1000,-151, 512,-1000,
 398,-1000,-1000,-273, 107,-118, -60, 511,-1000,-1000,
 510, 186,  91, 507,-1000, 365,-1000,-346,-1000, 361,
-288,-121,-1000,-316,-292, 186,-1000,-1000, 360,-1000,
-154,-248,-1000,-1000, 506, 394, 194,-291,-1000,-125,
 208,-318, 505,-323,-1000,  91,-1000,-1000,-1000,-1000,
-126, 364, -58,-1000, 148,-294,-1000,-127, 500, 208,
-1000, 430,  91,-1000, 504, -89, 500, 503,-1000,-1000,
 393, 392, 391,-1000,-297,-1000,-130, 500, -94,-1000,
-1000,-1000, -89,-1000, -94, -85,-1000,-164,-1000, -77,
-1000,-1000,-135, 500, -94,-138, 502, 501,-1000,-141,
 500, -94,  12, -91, -93, 207, -94,-1000,-166,-1000,
 -11, 499, 498, 207,-1000, 488,-1000, 170, 294,-166,
 167,   2,  37, 358, 355, 349,-146,  86,  20,-1000,
 -27,-240,-240,-1000,-1000,-142,-1000,  76,-1000,-1000,
-1000,-1000, 294, 294, 137,-214, 145,-1000,-166, 345,
-1000,-1000,-202,  48,  48,  48, 344,-348,-364, 385,
 381, 343,  48,  48,  37, 339,-240,-240,-240,-240,
-240,-240,-1000,-1000,-1000,-1000,-1000,-1000,-1000,  37,
 338, 337, 336,-146, 335, -37,-283,-1000, 422,-143,
-1000,-1000, 294, 166,-1000,-217,  48, -40,-1000,  32,
-175, 494, 493,-1000,-1000, 486,  32,  32,  48, 124,
 122,-183,-176,  48,-1000, 104, 332,  48,-209,-269,
-269,-1000,-1000,-1000, 328,  48,  48,  48, 327,  37,
-1000, -96,   9, 131, 144,-1000,  32,-191,-192,-194,
-195, 324,-1000,-1000,-1000,-1000, 426, 492,-1000, 484,
 483,-167,  27, 322, 320, -98, 319, 318,  32,-1000,
-1000,-1000,-1000,-1000, 421,  48,-1000,  48,-1000,-1000,
-1000,  48, 314, 420,-1000,-211,-1000,  60, 294,-1000,
 313,-1000,-1000,-1000,-1000, 419,-167,-1000,-159,-1000,
-174,-1000, 480,-1000,  48,  48, 478, 418, 417, 312,
 -99,  99,-1000,-1000,  48,-100,-1000, 165,-103,-211,
 160, 405,  52, 309, 308, 306,-146,  -5, -12, -68,
  52,  52,  52, 305, 304,  52, 303, 298, 296,-1000,
-278, 424, 424,-1000,-1000,-144,-1000, 103,  18,-313,
-1000, 101, 100,-1000, 416,-1000,-1000,-167,-1000, 184,
 183,-102,-1000,-1000, 411, 410, 292,  67,  98, 409,
-103,-103, 133,-231, 143,-1000,-211, 287,-1000,-1000,
-219,  48,  48,  48, 284, 283,  48,  48,  52, 282,
  52,  52, 279, 277, 276,  48,  48, 275,  48,  48,
  48, 424, 424, 424, 424, 424, 424,-1000,  52, 274,
 273, 272,-146, 271,   1, -76,  52,  52,  52, 270,
 269, 268,-331,-1000,  48, 267, 266, -84,-1000,  48,
  48,-1000,-1000, 265, 264, 476,-1000,-1000, 474, 261,
-108,-1000,-1000,-103, 157,-1000,-232,  48,  32,  32,
  32,  48,  48,-1000,  97, 258,  48,  -1,  -2,  48,
  48,  48, 380, 180,  48,  95, -13, -16,-229,-274,
-274,-1000,-1000,-1000, 256,  48,  48,  48, 253,  52,
  52,  52, 252, 248, 247,  48,  48,  48,-1000,-109,
  48,  48,-197,-198,-199,-200,-1000,-1000,  48,  48,
-110,  88, 473, 407, 126, 140,-1000,  32, 244, 243,
 242,  32,-1000, 472,  48,-1000,  48,  48, 378, -18,
 377,  48, 238, -45,  48,  48,  48,  48,-1000,-1000,
-1000,  48, 237,  -4, -86,  48,  48,  48, 376,  87,
 -47,  37,-111,-112,-1000,-1000,-1000,-1000,-1000,-1000,
 471,  63,-1000,-114,-103,-1000, 233, 470, 469, 467,
 232,-145,  96, 178, 174,  48,  48,  48,  32,  48,
  48,  32,-1000,  32,-1000,-1000,  48,  48,  48, 375,
 -49, 372,  48,  48,  48,-1000,  37,  37,-1000, 231,
  37,-1000, 464,-1000,-1000,-1000, 460, 458, 230,  61,
  14,  14,  32,  32,  32, 229,-1000,  32, 227, 226,
  74, 173, 172,  48,  48,  48,-1000,-1000,-1000,-1000,
-1000, 406,-1000,-1000,-1000,-1000, 455, 222,  48,-1000,
-1000,  48, 221, 219, 218, 454, 217, 450, 449,  14,
  14,-1000,-1000,-1000,-1000,  53, 448,  32,  32, 445,
 444, 441,-1000, 439,-1000,-1000,  48,  48,  57,-1000,
 213, 212,-1000,-1000,-1000,-1000,-1000,-1000, 210, 437,
 436, 435,-1000,-1000,-1000 };
short yypgo[]={

   0, 828, 780,   2, 664,   0,  11, 827,  16,  15,
  14, 826, 825, 776, 777, 779,   1,   3, 824, 823,
 822, 821, 820, 819, 818, 817, 816, 815, 814, 813,
 812, 811, 810, 809, 808, 807, 806, 805, 804, 803,
 802, 801, 800, 778, 775, 799, 798, 797, 796, 795,
 773, 434, 774,  22,   9, 794, 793, 792, 771, 790,
 789,  18,   7, 120, 788,  34, 787, 786, 785, 783,
 782, 781 };
short yyr1[]={

   0,  16,  17,  17,  13,  13,   1,  18,  23,  24,
  24,  25,  25,   7,   7,   7,   7,  26,  26,  29,
  15,  15,  27,  27,  30,  30,  28,  28,  19,  19,
  31,  31,  32,  32,  35,  33,  33,  36,  34,  34,
  37,  37,  14,  14,   2,   2,   2,  20,  38,  20,
  21,  21,  41,  40,  39,  39,  42,  42,  45,  43,
  47,  44,  46,  49,  49,  11,  11,  11,  50,  50,
  50,  50,  50,  51,  51,  51,  51,  51,  51,  52,
  52,  52,  52,  52,  52,  52,  52,  52,   5,   5,
   5,   5,   5,  56,   5,  57,   5,   5,   6,   6,
   6,   6,   4,   4,   3,   3,   3,   3,   3,   3,
  53,  53,  53,  54,  54,  54,  54,  55,   8,   8,
   8,   8,   8,   8,  58,  58,  58,  58,  58,  58,
  58,  58,  58,  59,  59,  59,  59,  59,  59,  59,
  59,  48,  60,  60,  12,  12,  12,  12,  12,  12,
  12,  12,  61,  61,  61,  61,  61,  62,  62,  62,
  62,  62,  62,  63,  63,  63,  63,  63,  63,  63,
  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,
  63,  63,  63,   9,   9,  10,  10,  10,  10,  10,
  10,  10,  10,  64,  65,  65,  65,  65,  65,  65,
  65,  65,  65,  66,  66,  66,  66,  66,  66,  66,
  66,  66,  66,  66,  66,  66,  66,  66,  66,  22,
  22,  67,  68,  68,  69,  69,  70,  70,  71,  71 };
short yyr2[]={

   0,   0,   1,   1,   1,   3,   5,   4,   5,   2,
   3,   4,   1,   1,   2,   3,   2,   1,   2,   3,
   1,   3,   1,   2,   7,   7,   1,   3,   1,   5,
   1,   3,   1,   2,   3,   1,   2,   3,   1,   2,
   4,   4,   1,   3,   1,   4,   2,   1,   0,   7,
   1,   2,   0,  10,   1,   2,   1,   2,   0,   5,
   0,   5,   2,   1,   3,   1,   9,  11,   1,   3,
   3,   4,   6,   3,   1,   2,   3,   4,   5,   7,
   6,   6,   6,   7,   4,   7,  12,   1,   2,   4,
   5,   3,   3,   0,   7,   0,   7,   8,   1,   2,
   2,   3,   1,   1,   2,   2,   4,   4,   4,   4,
   1,   1,   1,   3,   3,   3,   3,   3,   1,   1,
   1,   1,   1,   1,   3,   3,   3,   3,   3,   2,
   3,   1,   1,   4,   3,   3,   3,   4,   3,   4,
   9,   2,   1,   3,   1,   3,   4,   4,   1,   5,
   6,   6,   1,   3,   3,   4,   6,   3,   1,   2,
   3,   4,   5,   7,   6,   6,   6,   7,   4,   7,
  12,  11,  11,   9,   9,   9,   8,   6,   9,   8,
   5,   8,   1,   1,   1,   3,   3,   2,   2,   4,
   4,   4,   4,   3,   3,   3,   3,   3,   3,   2,
   3,   1,   1,   4,   3,   3,   3,   4,   3,   4,
   9,   8,   8,   6,   6,   6,   5,   5,   5,   1,
   1,   7,   1,   3,   1,   3,   1,   3,   1,   3 };
short yychk[]={

-1000,  -1, -18, 261, -19, -16, 351, 262, -20, -16,
 269, -31, -16, 265, 335, -21, -16, 271, -32, -16,
 358, -23, -24, 348, -22, -40, -16, -67, 329, 357,
 276, -33, -35, -16, 266, -14,  -2, 257, 299, -25,
 352, -16, 349, 297, 258, 262, -38, -34, -36, -16,
 359, 257, 334, 338, 257, -26, -16, 260, 350, 295,
 335, 325, -37, 257, -13, 257, -15, -16, 272,  -2,
 257, -27, -29, -16, 265, 369, 267, -68, -16, 353,
 335, 362, 334, 364, -15, 267, 339, -28, -30, -16,
 299, 361, 257, 260, 271, -69, -16, 354, 335, -39,
 -43, 268, 363, 257, 363, -14, 335, 265,  -7, 260,
 341, 342, 340, 276, -70, -16, 355, 335, -13, 257,
 -43, 259, -14, 257, -13, 257, 260, 260, 260, -41,
 -71, -16, 356, 335, -13, -45, 332, 331, 343, 325,
 335, -13, 335, 257, 257, 335, -13, -46, -49, -16,
 313, 334, 334, -42, -44, 268, -50, -51, 277, 347,
 -52, 275, 288, 283, 284, 289, 290, 296, 294, -55,
 -58, 367, 342, -59, 259, -11, -16, 320, 257, 257,
 -44, 258, 273, 274, -51, -50, 275, -52, 347,  -4,
 -16,  -3, 300, 267, 267, 267, -54, 281, 280, 344,
 345,  -3, 267, 267, 326,  -3,  -8, 366, 367, 368,
 369, 370, 303, 304, 305, 306, 307, 308, -58, 288,
 283, 284, 289, 290, 296, 294, -58, 335, 282, -47,
 -51, -51, 278, 346, 276, -50, 267, 344, 345,  -5,
 257, 299, 303, 332, 331, 282,  -5,  -5, 267, 369,
 369, 262, 262, 267,  -5,  -5,  -3, 267, -58, -58,
 -58, -58, -58, -58,  -4, 267, 267, 267, -54, 326,
 343, 259, 335, -51, 275, 346,  -5, 334, 340, 337,
 270, -53, -16, 301, 302,  -6, 340, 338, -16, 341,
 342, 257, 257, -56, -57, 258, -53, -53,  -5, 280,
 281, 345, 344,  -5, 297, 267,  -5, 267,  -5,  -5,
  -5, 267,  -3, 334, -48, -60, -16, 313, 279, 276,
 -53, 345, 345, 345, 345, 267, 257, 258, 257, 258,
 258,  -6, 340, 304, 267, 267, 334, 267, 267, -53,
 259,  -5,  -5,  -5, 267, 259, -61, -62, 277, 347,
 -63, 275, 285, 280, 281, 286, 287, 293, 291, 315,
 316, 360, 319, 321, 332, 318, 309, 314, 330, -64,
 -65, 367, 342, -66, 258, -12, -16, 310, 297, 300,
 -10, 323, 322, -51, 267, 259,  -6, 339, 343,  -5,
  -5, 258, 259, 259, 267, 334, 292, 297,  -5, 334,
 273, 274, -62, -61, 275, -63, 347,  -9, -16, -10,
 300, 267, 267, 267, -54, -10, 267, 267, 326, -10,
 327, 328,  -9,  -9,  -9, 267, 267,  -9, 267, 267,
 267,  -8, 366, 367, 368, 369, 370, -65, 285, 280,
 281, 286, 287, 293, 291, 315, 316, 360, 319, 321,
 309, 330, -65, 335, 297, 311, 365, 344, 345, 297,
 297, 259,  -6, 273, 273, 334, 259, 259, 267, 298,
 259, -62, -62, 278, 346, 276, -61, 267,  -5,  -5,
  -5, 267, 267,  -5,  -5, -10, 267,  -9,  -9, 267,
 267, 267,  -5,  -5, 267,  -5,  -5,  -5, -65, -65,
 -65, -65, -65, -65,  -9, 267, 267, 267, -54, 326,
 328, 327,  -9,  -9,  -9, 267, 267, 267, 343,  -5,
 267, 267, 270, 337, 334, 340,  -5,  -5, 267, 267,
 258, 258, 267, 334, -62, 275, 346,  -5, -53, -53,
 -53,  -5,  -5, 297, 267,  -5, 317, 317,  -5,  -5,
  -5, 262, 273,  -5, 297, 320, 320, 267,  -5,  -5,
  -5, 267, -10,  -9,  -9, 267, 267, 267,  -5,  -5,
  -5, 334,  -5,  -5, 345, 345, 345, 345,  -5,  -5,
 334, 297, 258, 259, 279, 276, -53, 267, 267, 267,
 -53, 258,  -5,  -5,  -5, 262, 320, 262,  -5, 267,
 320,  -5,  -5,  -5,  -5,  -5, 267, 317, 317,  -5,
  -5,  -5, 262, 297, 320,  -3, 334, 334, 258, 298,
 334, -62, 267, 258, 258, 258, 267, 334, 292, 297,
 273, 273,  -5,  -5,  -5, -53,  -5,  -5, -53, -53,
  -5,  -5,  -5, 262, 320, 262,  -5,  -5,  -5,  -3,
  -3, 267,  -3, 258, 258, 258, 267, 298, -17, -16,
 312, -17, -53, -53, -53, 267, -53, 267, 267, 273,
 273,  -5,  -5,  -5, 259, 258, 267,  -5,  -5, 267,
 267, 267, 258, 267, 258, 258, -17, -17, 297, 258,
 -53, -53, 258, 258, 258, 258,  -5,  -5, 298, 267,
 267, 267, 258, 258, 258 };
short yydef[]={

   0,  -2,   1,   0,   1,  28,   1,   0,   1,  47,
   0,   1,  30,   0,   0,   1,  50,   0,   1,  32,
   0,   7,   1,   0,   6,  51, 219, 220,   0,   0,
  48,   1,  33,  35,   0,  31,  42,  44,   0,   1,
   0,  12,   9,   0,   0,   0,   0,  29,  36,  38,
   0,   1,   0,   0,  46,   1,  17,   0,  10,   0,
   1,   0,  39,   4,   0,   1,  34,  20,   0,  43,
   0,   1,  18,  22,   0,   0,   0,   1, 222,   0,
   0,   0,   0,   0,  37,   0,  45,   8,  23,  26,
   0,   0,   0,  11,   0,   1, 224,   0,   0,  49,
  54,   0,   0,   5,   0,  21,   0,   0,  19,  13,
   0,   0,   0,  52,   1, 226,   0,   0, 223,   4,
  55,  58,  40,  41,  27,   0,  14,   0,  16,   0,
 221, 228,   0,   0, 225,   0,   0,   0,  15,   0,
   0, 227,   1,   0,   0,   0, 229,  59,   0,  63,
   1,   0,   0,  53,  56,   0,  62,  68,   0,   0,
  74,   0,   1,   0,   0,   0,   0,   0,   0,  87,
   0,   0,   0, 131, 132,   0,  65,   0,  24,  25,
  57,  60,   0,   0,   0,   0,   0,  75,   0,   0,
 102, 103,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 118, 119, 120, 121, 122, 123, 129,   1,
   0,   0,   0,   0,   0,   0,   0,  64,   0,   0,
  69,  70,   0,  73,  76,   0,   0, 104, 105,  -2,
   1,   0,   0,  93,  95,   0,  -2,  -2,   0,   0,
   0,   0,   0,   0, 138,   0,   0,   0, 117, 124,
 125, 126, 127, 128,   0,   0,   0,   0,   0,   0,
 130,   0,   1,  71,   0,  77,  -2,   0,   0,   0,
   0,   0, 110, 111, 112,  88,   0,   0,  98,   0,
   0,   1,   0,   0,   0,   0,   0,   0,  -2, 113,
 114, 115, 116,  84,   0,   0, 139,   0, 134, 135,
 136,   0,   0,   0,  61,   0, 142,   1,   0,  78,
   0, 106, 107, 108, 109,   0,   1,  99,   0, 100,
   0,  91,   0,  92,   0,   0,   0,   0,   0,   0,
   0,   0, 133, 137,   0,   0, 141, 152,   0,   0,
 158,   0,   1,   0,   0,   0,   0,   0,   0,   0,
   1,   1,   1,   0,   0,   1,   0,   0,   0, 182,
   0,   0,   0, 201, 202,   0, 144,   0,   0,   0,
 148,   0,   0,  72,   0,  80,  89,   1, 101,   0,
   0,   0,  81,  82,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 159,   0,   0, 183, 184,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   1,   1,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 199,   1,   0,
   0,   0,   0,   0,   0,   0,   1,   1,   1,   0,
   0,   0,   0, 143,   0,   0,   0, 187, 188,   0,
   0,  79,  90,   0,   0,   0,  83,  85,   0,   0,
   0, 153, 154,   0, 157, 160,   0,   0,  -2,  -2,
  -2,   0,   0, 208,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 193, 194,
 195, 196, 197, 198,   0,   0,   0,   0,   0,   0,
   1,   1,   0,   0,   0,   0,   0,   0, 200, 145,
   0,   0,   0,   0,   0,   0, 185, 186,   0,   0,
   0,   0,   0,   0, 155,   0, 161,  -2,   0,   0,
   0,  -2, 168,   0,   0, 209,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 204, 205,
 206,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 146, 147, 189, 190, 191, 192,  94,  96,
   0,   0, 140,  66,   0, 162,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,  -2,   0,
   0,  -2, 180,  -2, 203, 207,   0,   0,   0,   0,
   0,   0,   0,   0,   0, 149,   0,   0,  97,   0,
   0, 156,   0, 164, 165, 166,   0,   0,   0,   0,
   1,   1,  -2,  -2,  -2,   0, 177,   1,   0,   0,
   0,   0,   0,   0,   0,   0, 216, 217, 218, 150,
 151,   0,  67, 163, 167, 169,   0,   0,   0,   2,
   3,   0,   0,   0,   0,   0,   0,   0,   0,   1,
   1, 213, 214, 215,  86,   0,   0,  -2,  -2,   0,
   0,   0, 176,   0, 179, 181,   0,   0,   0, 210,
   0,   0, 173, 174, 175, 178, 211, 212,   0,   0,
   0,   0, 171, 172, 170 };
#ifndef lint
static	char yaccpar_sccsid[] = "@(#)yaccpar 1.6 88/02/08 SMI"; /* from UCB 4.1 83/02/11 */
#endif

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps>= &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 4:
# line 337 "t_yacc.VER"
{
           ptrln=(struct typobjln*)calloc(1,sizeof(struct typobjln)); 
           if (ptrln == NULL){typerror=ERRCALLOC;yyerror() OUTERR }
           sscanf(yypvt[-0].chaine,"%s",ptrln->nom);
           szln++;
           yyval.objln=ptrln;
         } break;
case 5:
# line 353 "t_yacc.VER"
{
         struct typobjln *ptr,*ptrbis;

           szwln=sizeof(struct typobjln);
             ptrbis=(struct typobjln*)realloc(ptrln,szln*szwln);
             if (ptrbis == NULL){typerror=ERRCALLOC;yyerror() OUTERR }
             ptrln=ptrbis;
             ptr=ptrln+(szln-1);
             szln++;

           sscanf(yypvt[-0].chaine,"%s",ptr->nom);
           yyval.objln=ptrln;
         } break;
case 6:
# line 373 "t_yacc.VER"
{ int i;
		/*
		generR("} \n"); 
		*/
		generF("\n");
		generH("\n");
		for (i=0;i<nbdescr;i++){
			generF("}/* END for(%d)... */\n",(nbdescr-i-1));
			generH("}/* END for(%d)... */\n",(nbdescr-i-1));
		}
		generR("\n\n\n/*===		fin de generation des regles_fonction().	===*/\n\n"); 
		/* generF("} END for(Descr[0]... "); */
		generF("\n/*===		fin de generation des boucles de verification.		==*/\n"); 
		/* generH("} END for(Descr[0]... */
		generH("\n/*===		fin de generation des boucles de verification.		==*/\n"); 
		generV("\n");
		PUT_chainv();

		generV("\n\n/*  fin de l'initialisation des variables  */\n\n");
		generD("# define NBMAXCORPS		%d \n",ir_tc);
                if (nbmaxbloc){
                  	generD("# define NBMAXCATAL		%d \n",nbmaxbloc+1);
                  	generD("# define NBMAXBLOC		%d \n",cpt_totbloc);
		}
                if (nbmaxmotif)
                  	generD("# define MAXMOTIF		%d \n",nbmaxmotif+1);
		if(cpt_totbloc)
                  	generD("# define CATAL_MOTIF		\n");
			
                if (nbmaxmbre >0)
                if (ir_tdm)
                  	generD("# define NBMAXONIV		%d \n",ir_tdm);
		if(nbmaxmbre)
                 	generD("# define NBMAXMBRE		%d \n",nbmaxmbre);
                if (ir_tml)
                  	generD("# define NBMAXLEVL		%d \n",ir_tml);
		generD("# define NBMAXREGLE		%d \n",noregle);
		generD("# define NBMAXDESCR		%d \n",nbdescr);
		generD("# define NBMAXPARAM		%d \n",nbmaxprm);
		generD("# define NBMAXVFONC		%d \n",nbmaxvfc);
		generD("# define NBMAXFEUILLE		%d \n",nbmaxfle);
		if(nb_nivlrg)
			generD("\n# define NBMAXNLRG		%d\n",nb_nivlrg);
		if(cpt_equip){
			generD("# define NBMAXEQUIP		%d \n",cpt_equip);
			generD("# define NBMAXELEQ		%d \n",nbelmt_equip_max);
		}
		if(irint)
			generD("# define NBMAXINT		%d \n",irint);
		if(irenv)
			generD("# define NBMAXENV		%d \n",irenv);
                if (nbvmax)
                  generD("# define NBMAXNVOIS		%d \n",nbvmax);
/*
                if (cpt_chv)
                  generD("# define NBMAXNIV		%d \n",cpt_chv);
*/
                  generD("# define NBMAXNIV		%d \n",ir_tc);

		generD("\n/*  fin des bornes de tableau generees  */\n");

		if(DECHELLE)
			generD("\n# define SCALE			%d\n",lechelle);
		if( irint || irenv )
			generD("# define OK_COMPOSITIONS	1\n");
		if(nbelmt_equip_max)
			generD("# define OK_EQUIPOTENTIELLES	1\n");

		generD("\n# define CODBLOC		%d \n",codbloc+LID0);
		generD("\n# define NIV_ABBOX		%d \n",ir_tml+LID0);
		generD("# define Vide			%d \n",ir_tml+LID0+1);

		generD("\n# define CTM			%d \n",maxrec);

		generD("\n/*===  	fin de generation de defines. 		=== */\n");
	



		fclose(ifnD);
		fclose(ifnV);
		fclose(ifnR);
		fclose(ifnF);
		fclose(ifnH);
	      } break;
case 9:
# line 469 "t_yacc.VER"
{	generV("represen=SYMBOLIC ; \n\n");  } break;
case 10:
# line 473 "t_yacc.VER"
{	generV("represen=LAMBDA ; \n\n");  } break;
case 11:
# line 478 "t_yacc.VER"
{
			DECHELLE=1;
			lechelle=yypvt[-2].entier/yypvt[-0].entier; 
		} break;
case 13:
# line 487 "t_yacc.VER"
{  yyval.entier=yypvt[-0].entier;} break;
case 14:
# line 490 "t_yacc.VER"
{  yyval.entier=yypvt[-0].entier;} break;
case 15:
# line 493 "t_yacc.VER"
{  yyval.entier=yypvt[-1].entier;} break;
case 16:
# line 496 "t_yacc.VER"
{ yyval.entier=yypvt[-0].entier; } break;
case 19:
# line 513 "t_yacc.VER"
{
         int res,i;

	     res=cherch_n(yypvt[-1].chaine);
	     if(res == -1)/* on ne genere un niveau que lorsqu'il n'existe
				pas deja				   */
             {
               typerror=fprintf(ifnV,"TAB_CORPS[%d].natcorps=NIVEAU;\n",ir_tc);
               if (typerror==(-1))
                 { yyerror() OUTERR } 
               typerror=fprintf(ifnV,"TAB_CORPS[%d].vcorps.vniveau.vcode=%d;\n",ir_tc,ir_tml+LID0);
               if (typerror==(-1))
                 { yyerror() OUTERR } 
               typerror=fprintf(ifnV,"strcpy(TAB_CORPS[%d].vcorps.vniveau.nom,\"%s\");\n",ir_tc,yypvt[-1].chaine);
               if (typerror==(-1))
                 { yyerror() OUTERR } 

/*   Chargement des niveaux dans TAB_MLEVEL[] pour la reconnaissance par le Parser CIF */
/* ce traitement n'est pas adapte aux sous niveaux qui */
		typerror=fprintf(ifnV,"strcpy(TAB_MLEVEL[%d].level_name,\"%s\");\n",ir_tml,yypvt[-1].chaine);
		typerror=fprintf(ifnV,"TAB_MLEVEL[%d].level_id=%d;\n",ir_tml,ir_tml+LID0);
/*  chargement de DIMMIN[]  */
               typerror=fprintf(ifnV,"DIMMIN[%d].natcorps=NIVEAU;\n",ir_tdm);
               if(typerror==(-1)){yyerror() OUTERR}
               typerror=fprintf(ifnV,"DIMMIN[%d].code1=%d;\n",ir_tdm,ir_tml+LID0);
               if(typerror==(-1)){yyerror() OUTERR}
               typerror=fprintf(ifnV,"DIMMIN[%d].vdimin=%d;\n\n",ir_tdm,yypvt[-0].entier);
               if(typerror==(-1)){yyerror() OUTERR}

               sscanf(yypvt[-1].chaine,"%s",tab_n[ir_n].nom);tab_n[ir_n].ind=ir_tc;

		tab_niv_chv[ir_n]=ir_tml+LID0;/* tab_chv[ir_n].nbv++; */

		ir_tml++;
               ir_tc++;
               ir_tdm++;
               ir_n++; 
               if (ir_n>NBMAXN)
               {
                 typerror=ERRTABN;
                 yyerror() OUTERR 
               }

             }


             else
             {
               typerror=ERREXIST;
               yyerror("declaration de niveau") OUTERR 
             }


         } break;
case 20:
# line 577 "t_yacc.VER"
{
        yyval.objlm=NULL;
       } break;
case 21:
# line 586 "t_yacc.VER"
{
         yyval.objlm = yypvt[-0].objlm;
       } break;
case 24:
# line 602 "t_yacc.VER"
{
		int res,ad1_c,ad2_c;
		
			res=cherch_n(yypvt[-4].chaine);
			if(res == -1 ){ /* le pseudo niveau n'existe pas deja */
               			typerror=fprintf(ifnV,"TAB_CORPS[%d].natcorps=NIVEAU;\n",ir_tc);
               			if (typerror==(-1))
                 		{ yyerror() OUTERR } 
               			typerror=fprintf(ifnV,"TAB_CORPS[%d].vcorps.vniveau.vcode=%d;\n",ir_tc,ir_tml+LID0);
               			if (typerror==(-1))
                 		{ yyerror() OUTERR } 
               			typerror=fprintf(ifnV,"strcpy(TAB_CORPS[%d].vcorps.vniveau.nom,\"%s\");\n",ir_tc,yypvt[-4].chaine);
               			if (typerror==(-1))
                 		{ yyerror() OUTERR } 
/*   Chargement des niveaux dans TAB_MLEVEL[] pour la reconnaissance par le Parser CIF */
/*   Le concepteur peut ainsi utiliser les noms de composition existant deja dans sa BD*/
				typerror=fprintf(ifnV,"strcpy(TAB_MLEVEL[%d].level_name,\"%s\");\n",ir_tml,yypvt[-4].chaine);
				typerror=fprintf(ifnV,"TAB_MLEVEL[%d].level_id=%d;\n",ir_tml,ir_tml+LID0);

/*  chargement de DIMMIN[]  
	En principe on compose les niveaux apres unification => il n'est pas necessaire d'avoir les
	tailles min des niveaux composes.
               typerror=fprintf(ifnV,"DIMMIN[%d].natcorps=NIVEAU;\n",ir_tdm);
               if(typerror==(-1)){yyerror() OUTERR}
               typerror=fprintf(ifnV,"DIMMIN[%d].code1=%d;\n",ir_tdm,ir_tml+LID0);
               if(typerror==(-1)){yyerror() OUTERR}
               typerror=fprintf(ifnV,"DIMMIN[%d].vdimin=%d;\n",ir_tdm,$3);
               if(typerror==(-1)){yyerror() OUTERR}
*/
               			typerror=fprintf(ifnV,"TINTERSE[%d].elmt0=%d;\n",irint,ir_tc);
               			if (typerror==(-1))
                 		{ yyerror() OUTERR } 
				res=cherch_n(yypvt[-2].chaine);
				ad1_c=res;
				if(res != (-1)){
               				typerror=fprintf(ifnV,"TINTERSE[%d].elmt1=%d;\n",irint,res);
               				if(typerror==(-1)){yyerror() OUTERR}
				}
				else{
					typerror=ERRINEXIST;yyerror("declaration de niveaux composes");OUTERR
				}
				res=cherch_n(yypvt[-0].chaine);
				ad2_c=res;
				if(res != (-1)){
               				typerror=fprintf(ifnV,"TINTERSE[%d].elmt2=%d;\n\n",irint,res);
               				if(typerror==(-1)){yyerror() OUTERR}
				}
				else{
					typerror=ERRINEXIST;yyerror("declaration de niveaux composes");OUTERR
				}


               			sscanf(yypvt[-4].chaine,"%s",tab_n[ir_n].nom);tab_n[ir_n].ind=ir_tc;

				tab_niv_chv[ir_n]=ir_tml+LID0;/* tab_chv[ir_n].nbv++; */
				/* OK_voisin(ad1_c,ad2_c); 
					il est juste important d'indiquer aux fonctions	
					de repartition que les niveaux servant a composer
					d'autres niveaux sont concernes par le DRC. On
					suppose la qu'il n y a pas de composistion de
					niveaux sans application de regles sur les
					niveaux resultats de compositions.
				*/
				OK_concerne(ad1_c);
				OK_concerne(ad2_c);

				ir_tml++;
				irint++;
               			ir_tc++;
               			/* ir_tdm++; */
               			ir_n++; 
               			if (ir_n>NBMAXN){
                 			typerror=ERRTABN;
                 			yyerror() OUTERR 
               			}

             		}
             		else{
               			typerror=ERREXIST;
               			yyerror("declaration de niveaux composes") OUTERR 
             		}


           } break;
case 25:
# line 691 "t_yacc.VER"
{
		int res,ad1_c,ad2_c;
		
			res=cherch_n(yypvt[-4].chaine);
			if(res == -1 ){ /* le pseudo niveau n'existe pas deja */
               			typerror=fprintf(ifnV,"TAB_CORPS[%d].natcorps=NIVEAU;\n",ir_tc);
               			if (typerror==(-1))
                 		{ yyerror() OUTERR } 
               			typerror=fprintf(ifnV,"TAB_CORPS[%d].vcorps.vniveau.vcode=%d;\n",ir_tc,ir_tml+LID0);
               			if (typerror==(-1))
                 		{ yyerror() OUTERR } 
               			typerror=fprintf(ifnV,"strcpy(TAB_CORPS[%d].vcorps.vniveau.nom,\"%s\");\n",ir_tc,yypvt[-4].chaine);
               			if (typerror==(-1))
                 		{ yyerror() OUTERR } 
/*   Chargement des niveaux dans TAB_MLEVEL[] pour la reconnaissance par le Parser CIF */
/*   Le concepteur peut ainsi utiliser les noms de composition existant deja dans sa BD*/
				typerror=fprintf(ifnV,"strcpy(TAB_MLEVEL[%d].level_name,\"%s\");\n",ir_tml,yypvt[-4].chaine);
				typerror=fprintf(ifnV,"TAB_MLEVEL[%d].level_id=%d;\n",ir_tml,ir_tml+LID0);

/*  chargement de DIMMIN[]  
	En principe on compose les niveaux apres unification => il n'est pas necessaire d'avoir les
	tailles min des niveaux composes.
               typerror=fprintf(ifnV,"DIMMIN[%d].natcorps=NIVEAU;\n",ir_tdm);
               if(typerror==(-1)){yyerror() OUTERR}
               typerror=fprintf(ifnV,"DIMMIN[%d].code1=%d;\n",ir_tdm,ir_tml+LID0);
               if(typerror==(-1)){yyerror() OUTERR}
               typerror=fprintf(ifnV,"DIMMIN[%d].vdimin=%d;\n",ir_tdm,$3);
               if(typerror==(-1)){yyerror() OUTERR}
*/
               			typerror=fprintf(ifnV,"TENVELOP[%d].elmt0=%d;\n",irenv,ir_tc);
               			if (typerror==(-1))
                 		{ yyerror() OUTERR } 
				res=cherch_n(yypvt[-2].chaine);
				ad1_c=res;
				if(res != (-1)){
               				typerror=fprintf(ifnV,"TENVELOP[%d].elmt1=%d;\n",irenv,res);
               				if(typerror==(-1)){yyerror() OUTERR}
				}
				else{
					typerror=ERRINEXIST;yyerror("declaration de niveaux composes");OUTERR
				}
				res=cherch_n(yypvt[-0].chaine);
				ad2_c=res;
				if(res != (-1)){
               				typerror=fprintf(ifnV,"TENVELOP[%d].elmt2=%d;\n\n",irenv,res);
               				if(typerror==(-1)){yyerror() OUTERR}
				}
				else{
					typerror=ERRINEXIST;yyerror("declaration de niveaux composes");OUTERR
				}


               			sscanf(yypvt[-4].chaine,"%s",tab_n[ir_n].nom);tab_n[ir_n].ind=ir_tc;

				tab_niv_chv[ir_n]=ir_tml+LID0;/* tab_chv[ir_n].nbv++; */
				/* OK_voisin(ad1_c,ad2_c);
					voir INTERSECTION */
				OK_concerne(ad1_c);
				OK_concerne(ad2_c);

				ir_tml++;
				irenv++;
               			ir_tc++;
               			/* ir_tdm++; */
               			ir_n++; 
               			if (ir_n>NBMAXN){
                 			typerror=ERRTABN;
                 			yyerror() OUTERR 
               			}

             		}
             		else{
               			typerror=ERREXIST;
               			yyerror("declaration de niveaux composes") OUTERR 
             		}
	  } break;
case 26:
# line 771 "t_yacc.VER"
{
			codbloc=ir_tml;
		} break;
case 27:
# line 781 "t_yacc.VER"
{
          int res,i;
          struct typobjln *ptr;
          char nomi[NBMAXCHAR+1];
 
		codbloc=ir_tml;	/* position du premier bloc declare dans TAB_CORPS[]. Seuls
				   les objets en dessous de cette position peuvent etre, 
				   eventuelement unifies en surface.				*/

            	ptr=yypvt[-0].objln;
            	for (i=1;i<szln;i++){
              		sscanf(ptr->nom,"%s",nomi);
              		res=cherch_b(nomi);
              		if (res==-1){
                		typerror=fprintf(ifnV,"TAB_CORPS[%d].natcorps=BLOC;\n",ir_tc);
                		if (typerror==(-1))
                  			{ yyerror() OUTERR } 
                		typerror=fprintf(ifnV,"strcpy(TAB_CORPS[%d].vcorps.vbloc.nombloc,\"%s\");\n",ir_tc,nomi);
                		if (typerror==(-1))
                  			{ yyerror() OUTERR } 
                		typerror=fprintf(ifnV,"TAB_CORPS[%d].vcorps.vbloc.codbloc=ir_tml+LID0;\n",ir_tc);
                		if (typerror==(-1))
                  			{ yyerror() OUTERR } 

                		typerror=fprintf(ifnV,"strcpy(CATAL[%d].nombloc,\"%s\");\n",ir_c,nomi);
                		if (typerror==(-1))
                  			{ yyerror() OUTERR } 

                		typerror=fprintf(ifnV,"strcpy(TAB_BLOCID[%d].block_name,\"%s\");\n",cpt_totbloc,nomi);
                		if (typerror==(-1))
                  			{ yyerror() OUTERR } 
                		typerror=fprintf(ifnV,"strcpy(TAB_BLOCID[%d].block_id,\"%d\");\n\n",cpt_totbloc,ir_tml+LID0);
                		if (typerror==(-1))
                  			{ yyerror() OUTERR } 
              
                		sscanf(nomi,"%s",tab_b[ir_b].nom);
                		tab_b[ir_b].ind=ir_tc;

                		ir_c++;ir_tc++;
				ir_tml++;
                		ir_b++;
                		if (ir_b > NBMAXB)
                		{
                  			typerror=ERRTABB;
                  			yyerror() OUTERR 
                		}
                		ptr=ptr+1;
                		nbmaxbloc++;
              
              		}
              		else{
                		typerror=ERREXIST;
                		yyerror("declaration de bloc") OUTERR 
              		}
            	}
            	free(ptrln);
            	szln=1;
          } break;
case 31:
# line 852 "t_yacc.VER"
{
		int i;
		struct typobjlm *ptr;

			nb_nivlrg=szlm;
			generV("\n");

			ptr=yypvt[-0].objlm;
			for(i=1;i<szlm;i++){
				generV("TAB_NILRG[%d]=%d;\n",i-1,ptr->mbre);	
				ptr=ptr+1;
			}

			generV("\n");
			
			free(ptrlm);
			szlm=1;
	     } break;
case 34:
# line 889 "t_yacc.VER"
{
         int res,i=0,sz=0,j;
         struct typobjlm *ptr;

           res=cherch_f(yypvt[-1].chaine);
           if (res==(-1))
           {
             sscanf(yypvt[-1].chaine,"%s",tab_f[ir_f].nom);
             tab_f[ir_f].ind=ir_tc;

             ir_f++;
             if (ir_f > NBMAXF)
             {
               typerror=ERRTABF; yyerror() OUTERR 
             }

             ptr=yypvt[-0].objlm;
             for (j=1;j<szlm;j++)
             {
		tab_list_fchv[cpt_fchv].list[j-1]=ptr->mbre;
               typerror=fprintf(ifnV,"TAB_CORPS[%d].vcorps.vfamille.membre[%d]=%d;\n",ir_tc,i,ptr->mbre);
               if (typerror==(-1))
                 { yyerror() OUTERR } 

               i++;sz++;
               ptr=ptr+1;
             }

		tab_nbelmt_fchv[cpt_fchv]=sz;tab_adrs_fchv[cpt_fchv]=ir_tc;cpt_fchv++;

             typerror=fprintf(ifnV,"TAB_CORPS[%d].natcorps=FAMILLE;\n",ir_tc);
             if (typerror==(-1))
               { yyerror() OUTERR } 
             typerror=fprintf(ifnV,"TAB_CORPS[%d].vcorps.vfamille.nbmembres=%d;\n\n",ir_tc,sz);
             if (typerror==(-1))
               { yyerror() OUTERR } 

             if (sz>nbmaxmbre)
               nbmaxmbre=sz;
             ir_tc++;

             free(ptrlm);
             szlm=1;
           }
           else 
           {
             typerror=ERREXIST;
             yyerror("declaration de famille") OUTERR 
           }
         } break;
case 37:
# line 950 "t_yacc.VER"
{
		int i;
		struct typobjlm *ptr;

			generV("\n");

			ptr=yypvt[-0].objlm;
			for(i=1;i<szlm;i++){
				tab_echv[i-1]=ptr->mbre;

				generV("TAB_EQUIP[%d].equip[%d]=%d;\n",cpt_equip,i-1,ptr->mbre+LID0);	
				ptr=ptr+1;
		
			}
			generV("TAB_EQUIP[%d].nb_elmt=%d;\n",cpt_equip,szlm-1);

			if(nbelmt_equip_max<szlm)
				nbelmt_equip_max=szlm;

			for(i=0;i<(szlm-2);i++)
				OK_voisin(tab_echv[i],tab_echv[i+1]);	

			free(ptrlm);
			szlm=1;

			cpt_equip++;



	  } break;
case 42:
# line 1008 "t_yacc.VER"
{

              ptrlm=(struct typobjlm*)calloc(1,sizeof(struct typobjlm));
              if (ptrlm == NULL){typerror=ERRCALLOC; yyerror() OUTERR }

              ptrlm->mbre=yypvt[-0].entier;
              szlm++;
              yyval.objlm=ptrlm;
            } break;
case 43:
# line 1022 "t_yacc.VER"
{
            struct typobjlm *ptr,*ptrbis;
              szwlm=sizeof(struct typobjlm);
              ptrbis=(struct typobjlm*)realloc(ptrlm,szlm*szwlm);
              if (ptrbis == NULL){typerror=ERRCALLOC; yyerror() OUTERR }
              ptrlm=ptrbis;
              ptr=ptrlm+(szlm-1);
              szlm++;

              ptr->mbre=yypvt[-0].entier;
              yyval.objlm=ptrlm;
            } break;
case 44:
# line 1045 "t_yacc.VER"
{
       int res;

         res=cherch_n(yypvt[-0].chaine);
         if (res == -1){typerror=ERRINEXIST; yyerror() OUTERR }
         yyval.entier=res;
       } break;
case 45:
# line 1060 "t_yacc.VER"
{
       int res;

         res=cherch_s(yypvt[-3].chaine,yypvt[-1].chaine);
         if (res == -1){typerror=ERRINEXIST; yyerror() OUTERR } 
         yyval.entier=res;       
       } break;
case 46:
# line 1073 "t_yacc.VER"
{
       int res;

         res=cherch_b(yypvt[-0].chaine);
         if (res == -1){typerror=ERRINEXIST; yyerror() OUTERR } 
         yyval.entier=res;
       } break;
case 47:
# line 1087 "t_yacc.VER"
{ generR("\n\n\nregle_1corps()\n{\n");nbdescr=0;} break;
case 48:
# line 1091 "t_yacc.VER"
{ 
		generF("\n/*===		debut de generation des boucles de verifications.	===*/");
		generF("\n\nfor(Descr[0]=(-1);Descr[0]<fin_vmb-1;Descr[0]++){/* for(0)... */");
  		generF("\nlist_vois=listvois_buff[cpt_lvois_lvb];\nnbvoisc= *list_vois;\ncpt_lvois_lvb++;");
  		generF("\nnb_corps=1;\n");
  		generF("\ncharg_descr();");
  		generF("\n\nregles_1corps();\n");

		generH("\n/*===		debut de generation des boucles de verifications.	===*/\n\n");
		generH("for(Descr[0]=(-1);Descr[0]<fin_vmb-1;Descr[0]++){/* for(0)... */\n");
  		generH("\nlist_vois=listvois_buff[cpt_lvois_lvb];\nnbvoisc= *list_vois;\ncpt_lvois_lvb++;");
  		generH("\nnb_corps=1;");
  		generH("\n\ncharg_descr();");
		generH("\n\nV_LLL__(verif_masks_buff,Descr[0],llevel[0])");
  		generH("\nif( hverif() ){");
  		generH("\n\nregles_1corps();\n");
		generH("\n}\n");

  		generR("\n\n\nregles_1corps()\n{\n");

	  	corps_able=SIMPLE; 
	  	nbdescr=1;
	} break;
case 50:
# line 1122 "t_yacc.VER"
{	generR("\n\n}/* END regles_%dcorps(). */",nbdescr);CLOSE1++;	} break;
case 51:
# line 1125 "t_yacc.VER"
{ 	generR("\n\n}/* END regles_%dcorps() ... */",nbdescr);	} break;
case 52:
# line 1134 "t_yacc.VER"
{ 
	      int i;
			for (i=nbdescr; i<yypvt[-4].entier; i++)
		    		if (i==0){
					generF("\n\nfor (Descr[%d]=(-1);Descr[%d]<fin_vmb-1;Descr[%d]++){/* for(0)... */\n",i,i,i);
  					generF("\nlist_vois=listvois_buff[cpt_lvois_lvb];\nnbvoisc= *list_vois;\ncpt_lvois_lvb++;");
  					generF("\nnb_corps=1;\n");
  					generF("\ncharg_descr();");

					generH("for (Descr[%d]=(-1);Descr[%d]<fin_vmb-1;Descr[%d]++){/* for(0)... */\n",i,i,i);
  					generH("\nlist_vois=listvois_buff[cpt_lvois_lvb];\nnbvoisc= *list_vois;\ncpt_lvois_lvb++;");
  					generH("\nnb_corps=1;");
  					generH("\n\ncharg_descr();");
					generH("\n\nV_LLL__(verif_masks_buff,Descr[%d],llevel[%d])",i,i);

					generR("\n\n}/* END regles_%dcorps(). */",nbdescr); /* il n' y a pas de regles a 1 corps */
                    		}
		    		else{
					if( !CLOSE1 )
						generR("\n\n}/* END regles_%dcorps(). */",nbdescr); /* fermeture de la precedente regles_fonction */

  					generF("\nfor(Voisins[%d]=1;Voisins[%d]<=nbvoisc;Voisins[%d]++){/* for(%d)... */\n",i,i,i,i);
  					generF("Descr[%d]= *(list_vois+Voisins[%d]);",i,i);
  					generF("\nnb_corps=%d;\nif( newdescr() ){\n\ncharg_descr();\n",i+1);
					generF("\nregles_%dcorps();\n",i+1);
					generF("\n}\n");
					/* generF("\n} END for(Voisins[%d]..) \n",i); */

  					generH("\nfor(Voisins[%d]=1;Voisins[%d]<=nbvoisc;Voisins[%d]++){/* for(%d)... */\n",i,i,i,i);
  					generH("Descr[%d]= *(list_vois+Voisins[%d]);",i,i);
  					generH("\n\nnb_corps=%d;",i+1);
  					generH("\nif( newdescr() ){\n\ncharg_descr();",i+1);
					generH("\n\nV_LLL__(verif_masks_buff,Descr[%d],llevel[%d])",i,i);
					generH("\nif( hverif() ){");
					generH("\n\nregles_%dcorps();\n",i+1);

					if(nbdescr==1)
						generH("traversee();\n");

					generH("\n}");
					generH("\n}"); 
					/* generH("\n} END for(Voisins[%d]..). \n",i); */

					generR("\n\n\nregles_%dcorps()\n{\n",i+1);
                    		}
				nbdescr = yypvt[-4].entier;
				corps_able=ALL;
	      } break;
case 58:
# line 1206 "t_yacc.VER"
{
			generR("\nnbregle=%d;\n",noregle) ;
			generR("if( verif() ){\n") ;

			generV("\n");
		} break;
case 59:
# line 1215 "t_yacc.VER"
{ if (zoned)
			generR("recupere();\naffich_erreur(%d);\n}\n}\n",yypvt[-3].entier);
		  else  generR("affich_erreur(%d);\n}\n",yypvt[-3].entier);
	 	  generV("TAB_PARAM[%d].lon=%d; \n",noregle,irprm);
		  nbmaxprm=irprm>nbmaxprm ? irprm : nbmaxprm;
		  nbmaxvfc=irvfc>nbmaxvfc ? irvfc : nbmaxvfc;
		  irvfc=0;
		  nbmaxfle=1;
		  noregle++ ;
		} break;
case 60:
# line 1231 "t_yacc.VER"
{ irepart=irfle=irprm=zoned=irvfc=0;
			dftfle=1000;
			generV("\n");
			generR("\nnbregle=%d;\n",noregle);
			generR("if( verif() ){\n");

			PLUS1c++;
		      } break;
case 61:
# line 1242 "t_yacc.VER"
{int i,j;
 
			generV("TAB_REPAR[%d].lon=%d; \n",noregle,irfle);
			if (irfle>nbmaxfle) nbmaxfle=irfle;
	 		generV("TAB_PARAM[%d].lon=%d; \n",noregle,irprm);
			nbmaxprm=irprm>nbmaxprm ? irprm : nbmaxprm;
			nbmaxfle=irfle>nbmaxfle ? irfle : nbmaxfle;
			nbmaxvfc=irvfc>nbmaxvfc ? irvfc : nbmaxvfc;
			irvfc=0;
			if (zoned) 
			      generR("recupere();\naffich_erreur(%d);\n}\n}\n",yypvt[-3].entier);
			else  generR("affich_erreur(%d);\n}\n",yypvt[-3].entier);
			noregle++;

			for(i=0;i<cpt_rulparam-1;i++){
				for(j=i+1;j<cpt_rulparam;j++)
					OK_voisin(rule_param[i],rule_param[j]);
			}
			cpt_rulparam=0;
			PLUS1c=0;
		      } break;
case 63:
# line 1275 "t_yacc.VER"
{ generV("TAB_REPAR[%d].lon=1;\n",noregle,noregle);
		  generV("TAB_REPAR[%d].repart[0]=0; \n",noregle);
		  irprm=zoned=0;
		  generR("raport=0; dir=2; borne=0; \nvidepile(); \n");
		  corc=(-1);
		  dirc=ENXY;
		  bornc=MINI;
		  rapc=(-1);
		} break;
case 64:
# line 1287 "t_yacc.VER"
{ if (yypvt[-1].orient.obj==-1) 
			{ generV("TAB_REPAR[%d].lon=1;\n",noregle,noregle);
			  generV("TAB_REPAR[%d].repart[0]=0;\n",noregle);
			  irprm=zoned=0;
			}
		  else { irprm=zoned=1;
			 generV("TAB_REPAR[%d].lon=1;\n",noregle);
			 generV("TAB_REPAR[%d].repart[0]=0;\n",noregle);
			 generV("TAB_PARAM[%d].param[0]=%d;\n",noregle,yypvt[-1].orient.obj);
			 generR("if (au_dessus()) \n{");
		       }
			if (yypvt[-1].orient.code==ENRIEN)
			      { generR(" raport=0; dir=2; borne=0; \nvidepile(); \n");
				dirc=ENXY;
			      }
			else  { dirc=yypvt[-1].orient.code;
				generR(" raport=0; dir=%d; borne=0; \nvidepile(); \n",yypvt[-1].orient.code);
			      }
			corc=rapc=(-1);
			bornc=MINI;
		} break;
case 65:
# line 1313 "t_yacc.VER"
{ yyval.orient.code=(ENRIEN); yyval.orient.obj=(-1); } break;
case 66:
# line 1317 "t_yacc.VER"
{ int z=cherch_z(yypvt[-6].entier,yypvt[-4].entier,yypvt[-2].entier,yypvt[-0].entier);
		  if (z!=-1) yyval.orient.obj=z;
		  else { generV("TAB_CORPS[%d].natcorps=FENETRE ;\n",ir_tc);
			 generV("TAB_CORPS[%d].vcorps.vfenetre.fenx=%d ;\n",ir_tc,yypvt[-6].entier);
			 generV("TAB_CORPS[%d].vcorps.vfenetre.fendx=%d ;\n",ir_tc,yypvt[-2].entier);
			 generV("TAB_CORPS[%d].vcorps.vfenetre.feny=%d ;\n",ir_tc,yypvt[-4].entier);
			 generV("TAB_CORPS[%d].vcorps.vfenetre.fendy=%d ;\n",ir_tc,yypvt[-0].entier);
			 tab_z[ir_z].ind=ir_tc;
			 ir_tc++;
			 tab_z[ir_z].x=yypvt[-6].entier;
			 tab_z[ir_z].y=yypvt[-4].entier;
			 tab_z[ir_z].dx=yypvt[-2].entier;
			 tab_z[ir_z].dy=yypvt[-0].entier;
			 if (ir_z < NBMAXZ-1)  
				 ir_z++;
			 else  { typerror=ERRTABZ; 
				 yyerror() OUTERR 	  }
			 yyval.orient.obj=ir_tc-1;
		       }
		    yyval.orient.code=(ENRIEN);
		  } break;
case 67:
# line 1341 "t_yacc.VER"
{ int z=cherch_z(yypvt[-8].entier,yypvt[-6].entier,yypvt[-4].entier,yypvt[-2].entier);
		  if (z!=-1) yyval.orient.obj=z;
		  else { generV("TAB_CORPS[%d].natcorps=FENETRE ;\n",ir_tc);
			 generV("TAB_CORPS[%d].vcorps.vfenetre.fenx=%d ;\n",ir_tc,yypvt[-8].entier);
			 generV("TAB_CORPS[%d].vcorps.vfenetre.fendx=%d ;\n",ir_tc,yypvt[-4].entier);
			 generV("TAB_CORPS[%d].vcorps.vfenetre.feny=%d ;\n",ir_tc,yypvt[-6].entier);
			 generV("TAB_CORPS[%d].vcorps.vfenetre.fendy=%d ;\n",ir_tc,yypvt[-2].entier);
			 tab_z[ir_z].ind=ir_tc;
			 ir_tc++;
			 tab_z[ir_z].x=yypvt[-8].entier;
			 tab_z[ir_z].y=yypvt[-6].entier;
			 tab_z[ir_z].dx=yypvt[-4].entier;
			 tab_z[ir_z].dy=yypvt[-2].entier;
			 if (ir_z < NBMAXZ-1)  
				 ir_z++;
			 else  { typerror=ERRTABZ; 
				 yyerror() OUTERR 	  }
			 yyval.orient.obj=ir_tc-1;
		       }
		    yyval.orient.code=yypvt[-0].entier;
		  } break;
case 69:
# line 1370 "t_yacc.VER"
{ generR(" et(); \n"); } break;
case 70:
# line 1372 "t_yacc.VER"
{ generR(" ou(); \n"); } break;
case 71:
# line 1374 "t_yacc.VER"
{ generR(" ifthn(); \n"); } break;
case 72:
# line 1376 "t_yacc.VER"
{ generR(" ifthnls(); \n"); } break;
case 75:
# line 1385 "t_yacc.VER"
{ generR(" non(); \n"); } break;
case 76:
# line 1387 "t_yacc.VER"
{ generR(" non(); \n"); } break;
case 77:
# line 1389 "t_yacc.VER"
{ generR(" non(); \n"); } break;
case 78:
# line 1391 "t_yacc.VER"
{ generR(" non(); \n"); } break;
case 79:
# line 1399 "t_yacc.VER"
{ if (yypvt[-3].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-3].entier))
		   { if (corc==-1)
		        corc=yypvt[-3].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		if ((yypvt[-5].entier==ENRIEN)||(yypvt[-5].entier==dirc))
		     generR("dimension(%d);",yypvt[-0].entier);
		else generR("{ dir=%d; dimension(%d);}",yypvt[-5].entier,yypvt[-0].entier);
                if(yypvt[-0].entier>maxrec)
                  if(bornc==0) maxrec=yypvt[-0].entier;
	      } break;
case 80:
# line 1415 "t_yacc.VER"
{ if (yypvt[-3].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-3].entier))
		   { if (corc==-1)
		        corc=yypvt[-3].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }

                if(yypvt[-0].entier>maxrec)
                  if(bornc==0) maxrec=yypvt[-0].entier;
		generR("largeur(%d);",yypvt[-0].entier);

	      } break;
case 81:
# line 1431 "t_yacc.VER"
{ if (yypvt[-3].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-3].entier))
		   { if (corc==-1)
		        corc=yypvt[-3].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }

                if(yypvt[-0].entier>maxrec)
                  if(bornc==0) maxrec=yypvt[-0].entier;
		generR("longueur(%d);",yypvt[-0].entier);

	      } break;
case 82:
# line 1447 "t_yacc.VER"
{ if (yypvt[-3].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-3].entier))
		   { if (corc==-1)
		        corc=yypvt[-3].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		generR("surface(%d);",yypvt[-0].entier);
	      } break;
case 83:
# line 1459 "t_yacc.VER"
{ if (yypvt[-3].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-3].entier))
		   { if (corc==-1)
		        corc=yypvt[-3].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		generR("rapport(%d);",yypvt[-0].entier);
	      } break;
case 84:
# line 1471 "t_yacc.VER"
{ if (yypvt[-0].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-0].entier))
		   { if (corc==-1)
		        corc=yypvt[-0].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		if ((yypvt[-2].entier==ENRIEN)||(yypvt[-2].entier==dirc))
		     generR("orientation();");
		else generR("{dir=%d; orientation();}",yypvt[-2].entier);
	      } break;
case 85:
# line 1485 "t_yacc.VER"
{ if (yypvt[-4].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-4].entier))
		   { if (corc==-1)
		        corc=yypvt[-4].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-4].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		generR("{place pos; pos.x=%d; pos.y=%d; position(pos); } ",yypvt[-2].entier,yypvt[-0].entier);
	      } break;
case 86:
# line 1497 "t_yacc.VER"
{ if (yypvt[-7].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if (yypvt[-9].entier>ENX)  { typerror=ERRAXE; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-7].entier))
		   { if (corc==-1)
		        corc=yypvt[-7].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-7].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		if (yypvt[-9].entier==dirc)
		     generR("{relpos pos; pos.orig=%d;pos.pas=%d; \npos_rel(pos);}",yypvt[-0].entier,yypvt[-4].entier);
		else generR("{ dir=%d; \nrelpos pos; pos.orig=%d;pos.pas=%d; \npos_rel(pos);}",yypvt[-9].entier,yypvt[-0].entier,yypvt[-4].entier);
	      } break;
case 88:
# line 1520 "t_yacc.VER"
{ 
		int ad_tab_n;
		
		   if (corps_able!=SIMPLE)
		      { int a=cherchfle(yypvt[-0].entier);
			if (a==-1) a=irepart++;
			if (a>=nbdescr) { typerror=ERRTODESCR; yyerror() OUTERR  }
		        tabfle[irfle].no=yypvt[-0].entier;
			tabfle[irfle].attrib=a;
			generV("TAB_REPAR[%d].repart[%d]=%d; \n",noregle,irfle,a);
			irfle++;
			if (irfle>=NBMAXFLE) {typerror=ERRFLE; yyerror() OUTERR  }
		      }

		  /* $$=cherch_n($1);*/
		  ad_tab_n=cherch_n(yypvt[-1].chaine);
		  yyval.entier=ad_tab_n;
		  OK_concerne(ad_tab_n);
		} break;
case 89:
# line 1542 "t_yacc.VER"
{
		int ad_tab_n;
		      if (corps_able!=SIMPLE)
		      { int a=cherchfle(yypvt[-0].entier);
			if (a==-1) a=irepart++;
			if (a>=nbdescr) { typerror=ERRTODESCR; yyerror() OUTERR  }
		        tabfle[irfle].no=yypvt[-0].entier;
			tabfle[irfle].attrib=a;
			generV("TAB_REPAR[%d].repart[%d]=%d; \n",noregle,irfle,a);
			irfle++;
			if (irfle>=NBMAXFLE) {typerror=ERRFLE; yyerror() OUTERR  }
		      }
		  yyval.entier=cherch_s(yypvt[-3].chaine,yypvt[-1].chaine);
/* A ACTUALISER en cas d'implanatation de SOUS NIVEAUX 
		  ad_tab_n=cherch_n($1,$3);
		  OK_concerne
*/
		} break;
case 90:
# line 1564 "t_yacc.VER"
{ if (corps_able!=SIMPLE)
		      { int a=cherchfle(yypvt[-0].entier);
			if (a==-1) a=irepart++;
			if (a>=nbdescr) { typerror=ERRTODESCR; yyerror() OUTERR  }
		        tabfle[irfle].no=yypvt[-0].entier;
			tabfle[irfle].attrib=a;
			generV("TAB_REPAR[%d].repart[%d]=%d; \n",noregle,irfle,a);
			irfle++;
			if (irfle>=NBMAXFLE) {typerror=ERRFLE; yyerror() OUTERR  }
		      }
		  yyval.entier=cherch_s(yypvt[-4].chaine,yypvt[-2].chaine);
		} break;
case 91:
# line 1580 "t_yacc.VER"
{ if (corps_able!=SIMPLE)
		      { int a=cherchfle(yypvt[-0].entier);
			if (a==-1) a=irepart++;
			if (a>=nbdescr) { typerror=ERRTODESCR; yyerror() OUTERR  }
		        tabfle[irfle].no=yypvt[-0].entier;
			tabfle[irfle].attrib=a;
			generV("TAB_REPAR[%d].repart[%d]=%d; \n",noregle,irfle,a);
			irfle++;
			if (irfle>=NBMAXFLE) {typerror=ERRFLE; yyerror() OUTERR  }
		      }
		  yyval.entier=cherch_b(yypvt[-1].chaine);
		} break;
case 92:
# line 1596 "t_yacc.VER"
{ 
		int ad_tab_n;
		  if (corps_able==EXFAM) { typerror=ERREXFAM; yyerror() OUTERR  }
		  if (corps_able==ALL)
		      { tabfle[irfle].attrib=irepart++;
			tabfle[irfle].no=dftfle++;
			if (irepart>nbdescr) { typerror=ERRTODESCR; yyerror() OUTERR  }
			generV("TAB_REPAR[%d].repart[%d]=%d; \n",noregle,irfle,irepart-1);
			irfle++;
			if (irfle >= NBMAXFLE) {typerror=ERRFLE; yyerror() OUTERR  }
		      }
		  /* $$=cherch_f($2); */
		  ad_tab_n=cherch_f(yypvt[-1].chaine);
		  yyval.entier=ad_tab_n;
		  OK_Fconcerne(ad_tab_n);
		} break;
case 93:
# line 1615 "t_yacc.VER"
{ if (corps_able==SIMPLE) { typerror=ERRSIMPLE; yyerror() OUTERR  }
		corps_able=EXFAM; } break;
case 94:
# line 1620 "t_yacc.VER"
{ int i=cherch_i(yypvt[-3].entier,yypvt[-0].entier);
		corps_able=ALL;
		if (i!=-1)
		    yyval.entier=i;
		else  { 
			generV("TAB_CORPS[%d].natcorps=INTERSECTION ;\n",ir_tc);
			generV("TAB_CORPS[%d].vcorps.vinter.c1int=%d ;\n",ir_tc,yypvt[-3].entier);
			generV("TAB_CORPS[%d].vcorps.vinter.c2int=%d ;\n",ir_tc,yypvt[-0].entier);
			tab_i[ir_i].ind=ir_tc;
			tab_i[ir_i].ic1=yypvt[-3].entier;
			tab_i[ir_i].ic2=yypvt[-0].entier;
			ir_tc++;

			OK_voisin(yypvt[-3].entier,yypvt[-0].entier);
			OK_concerne(yypvt[-3].entier);
			OK_concerne(yypvt[-0].entier);

			if (ir_i < NBMAXI-1) 
			   ir_i++;
			else  {	typerror=ERRTABI;
				yyerror() OUTERR 	  }
			yyval.entier=ir_tc-1;
		      } 
	      } break;
case 95:
# line 1647 "t_yacc.VER"
{ if (corps_able==SIMPLE) { typerror=ERRSIMPLE; yyerror() OUTERR  }
		corps_able=EXFAM; } break;
case 96:
# line 1652 "t_yacc.VER"
{ int e=cherch_e(yypvt[-3].entier,yypvt[-0].entier);
		corps_able=ALL;
		if (e!=-1)
		    yyval.entier=e;
		else  { generV("TAB_CORPS[%d].natcorps=ENVELOPPE ;\n",ir_tc);
			generV("TAB_CORPS[%d].vcorps.venvelop.c1env=%d ;\n",ir_tc,yypvt[-3].entier);
			generV("TAB_CORPS[%d].vcorps.venvelop.c2env=%d ;\n",ir_tc,yypvt[-0].entier);
			tab_e[ir_e].ind=ir_tc;
			tab_e[ir_e].ec1=yypvt[-3].entier;
			tab_e[ir_e].ec2=yypvt[-0].entier;
			ir_tc++;

			OK_voisin(yypvt[-3].entier,yypvt[-0].entier);
			OK_concerne(yypvt[-3].entier);
			OK_concerne(yypvt[-0].entier);

			if (ir_e < NBMAXE-1) 
			   ir_e++;
			else  {	typerror=ERRTABE;
				yyerror() OUTERR 	  }
			yyval.entier=ir_tc-1;
		      } 
	      } break;
case 97:
# line 1678 "t_yacc.VER"
{ int z=cherch_z(yypvt[-6].entier,yypvt[-4].entier,yypvt[-2].entier,yypvt[-0].entier);
		  if (z!=-1) 
		     yyval.entier=z;
		  else { generV("TAB_CORPS[%d].natcorps=FENETRE ;\n",ir_tc);
			 generV("TAB_CORPS[%d].vcorps.vfenetre.fenx=%d ;\n",ir_tc,yypvt[-6].entier);
			 generV("TAB_CORPS[%d].vcorps.vfenetre.fendx=%d ;\n",ir_tc,yypvt[-2].entier);
			 generV("TAB_CORPS[%d].vcorps.vfenetre.feny=%d ;\n",ir_tc,yypvt[-4].entier);
			 generV("TAB_CORPS[%d].vcorps.vfenetre.fendy=%d ;\n",ir_tc,yypvt[-0].entier);
			 tab_z[ir_z].ind=ir_tc;
			 ir_tc++;
			 tab_z[ir_z].x=yypvt[-6].entier;
			 tab_z[ir_z].y=yypvt[-4].entier;
			 tab_z[ir_z].dx=yypvt[-2].entier;
			 tab_z[ir_z].dy=yypvt[-0].entier;
			 if (ir_z < NBMAXZ-1) 
				 ir_z++;
			 else  { typerror=ERRTABZ; 
				 yyerror() OUTERR 	  }
			 yyval.entier=ir_tc-1;
			}
		  } break;
case 98:
# line 1703 "t_yacc.VER"
{ yyval.entier=dftfle++; } break;
case 99:
# line 1705 "t_yacc.VER"
{ if (yypvt[-0].entier>999) {typerror=ERRORDRE; yyerror() OUTERR } yyval.entier=yypvt[-0].entier; } break;
case 100:
# line 1707 "t_yacc.VER"
{ if (yypvt[-0].entier>999) {typerror=ERRORDRE; yyerror() OUTERR } yyval.entier=yypvt[-0].entier; } break;
case 101:
# line 1709 "t_yacc.VER"
{ if (yypvt[-1].entier>999) {typerror=ERRORDRE; yyerror() OUTERR } yyval.entier=yypvt[-1].entier; } break;
case 102:
# line 1715 "t_yacc.VER"
{ yyval.entier=(ENRIEN); } break;
case 104:
# line 1724 "t_yacc.VER"
{ yyval.entier=ENX; } break;
case 105:
# line 1726 "t_yacc.VER"
{ yyval.entier=ENY; } break;
case 106:
# line 1728 "t_yacc.VER"
{ yyval.entier=ENXY; } break;
case 107:
# line 1730 "t_yacc.VER"
{ yyval.entier=ENXY; } break;
case 108:
# line 1732 "t_yacc.VER"
{ yyval.entier=ENXY; } break;
case 109:
# line 1734 "t_yacc.VER"
{ yyval.entier=ENXY; } break;
case 110:
# line 1740 "t_yacc.VER"
{ if (bornc!=MINI) { generR("\nborne=0; \n"); bornc=MINI ;}} break;
case 111:
# line 1742 "t_yacc.VER"
{ if (bornc!=MINI) { generR("\nborne=0; \n"); bornc=MINI ;}} break;
case 112:
# line 1744 "t_yacc.VER"
{ if (bornc!=MAXI) { generR("\nborne=1; \n"); bornc=MAXI ;}} break;
case 113:
# line 1752 "t_yacc.VER"
{ if (rapc!=LONLAR) {generR("\nraport=1;\n");rapc=LONLAR; }} break;
case 114:
# line 1756 "t_yacc.VER"
{ if (rapc!=LARLON) {generR("\nraport=0;\n");rapc=LARLON; }} break;
case 115:
# line 1760 "t_yacc.VER"
{ if (rapc!=XSY) {generR("\nraport=2;\n");rapc=XSY;       }} break;
case 116:
# line 1764 "t_yacc.VER"
{ if (rapc!=YSX) {generR("\nraport=3;\n");rapc=YSX;       }} break;
case 117:
# line 1770 "t_yacc.VER"
{ generR("%s(); \n",yypvt[-1].opcomp);} break;
case 118:
# line 1775 "t_yacc.VER"
{ yyval.opcomp="inf";generV("TAB_VFONC[%d].vfonc[%d]=0;\n",noregle,irvfc++);QUAL=0;} break;
case 119:
# line 1777 "t_yacc.VER"
{ yyval.opcomp="sup";generV("TAB_VFONC[%d].vfonc[%d]=1;\n",noregle,irvfc++);QUAL=0;} break;
case 120:
# line 1779 "t_yacc.VER"
{ yyval.opcomp="infegal";generV("TAB_VFONC[%d].vfonc[%d]=0;\n",noregle,irvfc++);QUAL=0;} break;
case 121:
# line 1781 "t_yacc.VER"
{ yyval.opcomp="supegal";generV("TAB_VFONC[%d].vfonc[%d]=0;\n",noregle,irvfc++);QUAL=0;} break;
case 122:
# line 1783 "t_yacc.VER"
{ yyval.opcomp="egal"; } break;
case 123:
# line 1785 "t_yacc.VER"
{ yyval.opcomp="diffr"; } break;
case 124:
# line 1791 "t_yacc.VER"
{ generR(" plus(); "); } break;
case 125:
# line 1793 "t_yacc.VER"
{ generR(" moins(); "); } break;
case 126:
# line 1795 "t_yacc.VER"
{ generR(" mul(); "); } break;
case 127:
# line 1797 "t_yacc.VER"
{ generR(" div(); "); } break;
case 128:
# line 1799 "t_yacc.VER"
{ generR(" mod(); "); } break;
case 129:
# line 1803 "t_yacc.VER"
{ generR(" opp(); "); } break;
case 131:
# line 1808 "t_yacc.VER"
{ QUAL=1; } break;
case 132:
# line 1810 "t_yacc.VER"
{ generR("push_v(%d);",yypvt[-0].entier); } break;
case 133:
# line 1819 "t_yacc.VER"
{ if (yypvt[-0].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-0].entier))
		   { if (corc==-1)
		        corc=yypvt[-0].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		if ((yypvt[-2].entier==ENRIEN)||(yypvt[-2].entier==dirc))
		     generR("vdimension();");
		else generR("{ dir=%d; vdimension();}",yypvt[-2].entier);
                
	      } break;
case 134:
# line 1834 "t_yacc.VER"
{ if (yypvt[-0].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-0].entier))
		   { if (corc==-1)
		        corc=yypvt[-0].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		generR("vlargeur();");
	      } break;
case 135:
# line 1846 "t_yacc.VER"
{ if (yypvt[-0].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-0].entier))
		   { if (corc==-1)
		        corc=yypvt[-0].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		generR("vlongueur();");
	      } break;
case 136:
# line 1858 "t_yacc.VER"
{ if (yypvt[-0].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-0].entier))
		   { if (corc==-1)
		        corc=yypvt[-0].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		generR("vsurface();");
	      } break;
case 137:
# line 1870 "t_yacc.VER"
{ if (yypvt[-0].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-0].entier))
		   { if (corc==-1)
		        corc=yypvt[-0].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		generR("vrapport();");
	      } break;
case 138:
# line 1882 "t_yacc.VER"
{ if (yypvt[-0].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-0].entier))
		   { if (corc==-1)
		        corc=yypvt[-0].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		generR("vorientation();");
	      } break;
case 139:
# line 1894 "t_yacc.VER"
{ if (yypvt[-0].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if (yypvt[-2].entier>ENX)  { typerror=ERRAXE; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-0].entier))
		   { if (corc==-1)
		        corc=yypvt[-0].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		if ((yypvt[-2].entier==ENRIEN)||(yypvt[-2].entier==dirc))
		     generR("vposition();");
		else generR("{ dir=%d; vposition();}",yypvt[-2].entier);
	      } break;
case 140:
# line 1909 "t_yacc.VER"
{ if (yypvt[-4].entier==-1)  { typerror=ERRINEXIST; yyerror() OUTERR  } 
		if (yypvt[-6].entier>ENX)  { typerror=ERRAXE; yyerror() OUTERR  } 
		if ((corc==-1)||(corc==yypvt[-4].entier))
		   { if (corc==-1)
		        corc=yypvt[-4].entier;
		     generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-4].entier);
		   }
		else { typerror=ERRTODESCR; yyerror() OUTERR  }
		if ((yypvt[-6].entier==ENRIEN)||(yypvt[-6].entier==dirc))
		     generR("vpos_borne(%d);",yypvt[-0].entier);
		else generR("{dir=%d; vpos_borne(%d);}",yypvt[-6].entier,yypvt[-0].entier);
	      } break;
case 142:
# line 1933 "t_yacc.VER"
{ generR("raport=0; dir=2; borne=0; \nvidepile(); \n");
		dirc=ENXY;
		bornc=MINI;
		rapc=(-1);
	      } break;
case 143:
# line 1941 "t_yacc.VER"
{ if (yypvt[-1].orient.code>ENXY){
			if(OUTa){
		       		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-1].orient.obj);
				generR("if (en_dehors()) \n{");
				zoned=1;
				OUTa=0;
			}
			else{
		       		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-1].orient.obj);
				generR("if (au_dessus()) \n{");
				zoned=1;
			}
	      }
		switch (yypvt[-1].orient.code)
		      {	case ENRIEN : 
				generR("raport=0; dir=2; borne=0; \nvidepile(); \n");
				dirc=(ENRIEN);
				break;
			case FENTRE :
				generR("raport=0; dir=2; borne=0; \nvidepile(); \n");
				dirc=(ENRIEN);
				break;
			case LONGIT : 
				generR("raport=0; borne=0; \n");
				generR("dir=dorientation(); \nvidepile(); \n");
				generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-1].orient.obj);
				{ int i;
				  for (i=0;i<irfle;i++)
				      {	tabfle[i+irfle].no=tabfle[i].no;
					tabfle[i+irfle].attrib=tabfle[i].attrib;
				      }
				  generV("{ int i;\n  for (i=0;i<%d;i++)\n        ",irfle);
				  generV("TAB_REPAR[%d].repart[%d+i]=TAB_REPAR[%d].repart[i];\n}\n",noregle,irfle,noregle);
				  irfle *= 2;
				}
				dirc=(ENRIEN);
				break;
			case TRANSV : 
				generR("borne=0; \n");
				generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-1].orient.obj);
				{ int i;
				  for (i=0;i<irfle;i++)
				      {	tabfle[i+irfle].no=tabfle[i].no;
					tabfle[i+irfle].attrib=tabfle[i].attrib;
				      }
				  generV("{ int i;\n  for (i=0;i<%d;i++)\n        ",irfle);
				  generV("TAB_REPAR[%d].repart[%d+i]=TAB_REPAR[%d].repart[i];\n}\n",noregle,irfle,noregle);
				  irfle *= 2;
				}
				generR("dir=dorientation(); \ndir=((dir!=2) ? 1-dir : dir); \n");
				dirc=(ENRIEN);
				break;
			default :
				generR("raport=0; borne=0; dir=%d; \nvidepile(); \n",yypvt[-1].orient.code > ENXY ? yypvt[-1].orient.code-6 : yypvt[-1].orient.code);
				dirc= yypvt[-1].orient.code > ENXY ? yypvt[-1].orient.code-6 : yypvt[-1].orient.code ;
				break;
		      }
		rapc=(-1);
		bornc=MINI;
	      } break;
case 144:
# line 2007 "t_yacc.VER"
{ yyval.orient.code=(ENRIEN); yyval.orient.obj=(-1); } break;
case 145:
# line 2009 "t_yacc.VER"
{ yyval.orient.code=FENTRE; yyval.orient.obj=yypvt[-0].entier; } break;
case 146:
# line 2011 "t_yacc.VER"
{ yyval.orient.code=FENTRE; yyval.orient.obj=yypvt[-0].entier; } break;
case 147:
# line 2013 "t_yacc.VER"
{ yyval.orient.code=FENTRE; yyval.orient.obj=yypvt[-0].entier; OUTa++;} break;
case 148:
# line 2015 "t_yacc.VER"
{ yyval.orient.code=yypvt[-0].orient.code; yyval.orient.obj=yypvt[-0].orient.obj; } break;
case 149:
# line 2017 "t_yacc.VER"
{ yyval.orient.code=yypvt[-0].entier+6; yyval.orient.obj=yypvt[-2].entier; } break;
case 150:
# line 2019 "t_yacc.VER"
{ yyval.orient.code=yypvt[-0].entier+6; yyval.orient.obj=yypvt[-2].entier; } break;
case 151:
# line 2021 "t_yacc.VER"
{ yyval.orient.code=yypvt[-0].entier+6; yyval.orient.obj=yypvt[-2].entier;OUTa++; } break;
case 153:
# line 2030 "t_yacc.VER"
{ generR(" et(); \n"); } break;
case 154:
# line 2032 "t_yacc.VER"
{ generR(" ou(); \n"); } break;
case 155:
# line 2034 "t_yacc.VER"
{ generR(" ifthn(); \n"); } break;
case 156:
# line 2036 "t_yacc.VER"
{ generR(" ifthnls(); \n"); } break;
case 159:
# line 2046 "t_yacc.VER"
{ generR(" non(); \n"); } break;
case 160:
# line 2048 "t_yacc.VER"
{ generR(" non(); \n"); } break;
case 161:
# line 2050 "t_yacc.VER"
{ generR(" non(); \n"); } break;
case 162:
# line 2052 "t_yacc.VER"
{ generR(" non(); \n"); } break;
case 163:
# line 2061 "t_yacc.VER"
{	if (yypvt[-3].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-5].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-5].orient.code))||((dirc==ENRIEN)&&(yypvt[-5].orient.code==ENXY)))
		generR("dimension(%d); ",yypvt[-0].entier);
	else if (yypvt[-5].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].orient.obj);
			generR("{dir=dorientation(); dimension(%d);} ",yypvt[-0].entier);
		      }
	     else if (yypvt[-5].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); dimension(%d);} ",yypvt[-0].entier);
			      }
		  else  generR("{dir=%d; dimension(%d);} ",yypvt[-5].orient.code,yypvt[-0].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
        if(yypvt[-0].entier>maxrec)
          if(bornc==0) maxrec=yypvt[-0].entier;
      } break;
case 164:
# line 2080 "t_yacc.VER"
{ if (yypvt[-3].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		generR("largeur(%d); ",yypvt[-0].entier);
                if(yypvt[-0].entier>maxrec)
                  if(bornc==0) maxrec=yypvt[-0].entier;
	      } break;
case 165:
# line 2089 "t_yacc.VER"
{ if (yypvt[-3].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		generR("longueur(%d); ",yypvt[-0].entier);
                if(yypvt[-0].entier>maxrec)
                  if(bornc==0) maxrec=yypvt[-0].entier;
	      } break;
case 166:
# line 2098 "t_yacc.VER"
{ if (yypvt[-3].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		generR("surface(%d); ",yypvt[-0].entier);
	      } break;
case 167:
# line 2105 "t_yacc.VER"
{ if (yypvt[-3].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		generR("rapport(%d); ",yypvt[-0].entier);
	      } break;
case 168:
# line 2112 "t_yacc.VER"
{	if (yypvt[-0].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-2].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-2].orient.code))||((dirc==ENRIEN)&&(yypvt[-2].orient.code==ENXY)))
		generR("orientation(); ");
	else if (yypvt[-2].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].orient.obj);
			generR("{dir=dorientation(); orientation();} ");
		      }
	     else if (yypvt[-2].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); orientation();} ");
			      }
		  else  generR("{dir=%d; orientation();} ",yypvt[-2].orient.code);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
      } break;
case 169:
# line 2129 "t_yacc.VER"
{ if (yypvt[-4].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-4].entier);
		generR("{place pos; pos.x=%d; pos.y=%d; position(pos);} ",yypvt[-2].entier,yypvt[-0].entier);
	      } break;
case 170:
# line 2136 "t_yacc.VER"
{	if (yypvt[-7].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if (yypvt[-9].orient.code==ENXY) { typerror=ERRAXE; yyerror() OUTERR  }
	generR("{relpos p; p.orig=%d; p.pas=%d; ",yypvt[-0].entier,yypvt[-4].entier);
	if (!((yypvt[-9].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-9].orient.code))||((dirc==ENRIEN)&&(yypvt[-9].orient.code==ENXY))))
	   if (yypvt[-9].orient.code==LONGIT)
	      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-9].orient.obj);
			generR("dir=dorientation(); ");
		      }
	   else if (yypvt[-9].orient.code==TRANSV)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-9].orient.obj);
			generR("dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); ");
		      }
		else  generR("dir=%d; ",yypvt[-9].orient.code);
	generR("pos_rel(p); } ");
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-7].entier);
      } break;
case 171:
# line 2155 "t_yacc.VER"
{	if ((yypvt[-6].entier==-1)||(yypvt[-3].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-8].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-8].orient.code))||((dirc==ENRIEN)&&(yypvt[-8].orient.code==ENXY)))
		generR("distmin(%d); ",yypvt[-0].entier);
	else if (yypvt[-8].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-8].orient.obj);
			generR("{dir=dorientation(); distmin(%d);} ",yypvt[-0].entier);
		      }
	     else if (yypvt[-8].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-8].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); distmin(%d);} ",yypvt[-0].entier);
			      }
		  else  generR("{dir=%d; distmin(%d);} ",yypvt[-8].orient.code,yypvt[-0].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-6].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
	if (yypvt[-0].entier>maxrec) maxrec=yypvt[-0].entier; 

	OK_voisin(yypvt[-6].entier,yypvt[-3].entier);
	PUT_ctm(yypvt[-6].entier,yypvt[-3].entier,yypvt[-0].entier);

      } break;
case 172:
# line 2178 "t_yacc.VER"
{	if ((yypvt[-6].entier==-1)||(yypvt[-3].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-8].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-8].orient.code))||((dirc==ENRIEN)&&(yypvt[-8].orient.code==ENXY)))
		generR("distance(%d); ",yypvt[-0].entier);
	else if (yypvt[-8].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-8].orient.obj);
			generR("{dir=dorientation(); distance(%d);} ",yypvt[-0].entier);
		      }
	     else if (yypvt[-8].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-8].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); distance(%d);} ",yypvt[-0].entier);
			      }
		  else  generR("{dir=%d; distance(%d);} ",yypvt[-8].orient.code,yypvt[-0].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-6].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
	if (yypvt[-0].entier>maxrec) maxrec=yypvt[-0].entier; 

	OK_voisin(yypvt[-6].entier,yypvt[-3].entier);
	PUT_ctm(yypvt[-6].entier,yypvt[-3].entier,yypvt[-0].entier);

      } break;
case 173:
# line 2201 "t_yacc.VER"
{	if ((yypvt[-5].entier==-1)||(yypvt[-3].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-7].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-7].orient.code))||((dirc==ENRIEN)&&(yypvt[-7].orient.code==ENXY)))
		generR("extension(%d); ",yypvt[-0].entier);
	else if (yypvt[-7].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-7].orient.obj);
			generR("{dir=dorientation(); extension(%d);} ",yypvt[-0].entier);
		      }
	     else if (yypvt[-7].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-7].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); extension(%d);} ",yypvt[-0].entier);
			      }
		  else  generR("{dir=%d; extension(%d);} ",yypvt[-7].orient.code,yypvt[-0].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
	if (yypvt[-0].entier>maxrec) maxrec=yypvt[-0].entier; 

	OK_voisin(yypvt[-5].entier,yypvt[-3].entier);
/*
	PUT_ctm($4,$6,$9);
EN fait seul le verbe DISTANCE impose une valeur de CTM_NIV.
*/

      } break;
case 174:
# line 2227 "t_yacc.VER"
{	if ((yypvt[-5].entier==-1)||(yypvt[-3].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-7].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-7].orient.code))||((dirc==ENRIEN)&&(yypvt[-7].orient.code==ENXY)))
		generR("marge(%d); ",yypvt[-0].entier);
	else if (yypvt[-7].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-7].orient.obj);
			generR("{dir=dorientation(); marge(%d);} ",yypvt[-0].entier);
		      }
	     else if (yypvt[-7].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-7].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); marge(%d);} ",yypvt[-0].entier);
			      }
		  else  generR("{dir=%d; marge(%d);} ",yypvt[-7].orient.code,yypvt[-0].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
	if (yypvt[-0].entier>maxrec) maxrec=yypvt[-0].entier; 

	OK_voisin(yypvt[-5].entier,yypvt[-3].entier);
/*
	PUT_ctm($4,$6,$9);
*/

      } break;
case 175:
# line 2252 "t_yacc.VER"
{	if ((yypvt[-5].entier==-1)||(yypvt[-3].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-7].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-7].orient.code))||((dirc==ENRIEN)&&(yypvt[-7].orient.code==ENXY)))
		generR("recouvrement(%d); ",yypvt[-0].entier);
	else if (yypvt[-7].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-7].orient.obj);
			generR("{dir=dorientation(); recouvrement(%d);} ",yypvt[-0].entier);
		      }
	     else if (yypvt[-7].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-7].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); recouvrement(%d);} ",yypvt[-0].entier);
			      }
		  else  generR("{dir=%d; recouvrement(%d);} ",yypvt[-7].orient.code,yypvt[-0].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
	if (yypvt[-0].entier>maxrec) maxrec=yypvt[-0].entier; 

	OK_voisin(yypvt[-5].entier,yypvt[-3].entier);
/*
	PUT_ctm($4,$6,$9);
*/

      } break;
case 176:
# line 2277 "t_yacc.VER"
{ if ((yypvt[-5].entier==-1)||(yypvt[-3].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].entier);
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		generR("superposition(%d); ",yypvt[-0].entier);
		if (yypvt[-0].entier>maxrec) maxrec=yypvt[-0].entier; 

		OK_voisin(yypvt[-5].entier,yypvt[-3].entier);
/*
		PUT_ctm($3,$5,$8);
*/

	      } break;
case 177:
# line 2292 "t_yacc.VER"
{ if ((yypvt[-3].entier==-1)||(yypvt[-0].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		generR("intersection(); ");

		OK_voisin(yypvt[-3].entier,yypvt[-0].entier);

	      } break;
case 178:
# line 2303 "t_yacc.VER"
{	if ((yypvt[-5].entier==-1)||(yypvt[-3].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-7].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-7].orient.code))||((dirc==ENRIEN)&&(yypvt[-7].orient.code==ENXY)))
		generR("inclusion(%d); ",yypvt[-0].entier);
	else if (yypvt[-7].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-7].orient.obj);
			generR("{dir=dorientation(); inclusion(%d);} ",yypvt[-0].entier);
		      }
	     else if (yypvt[-7].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-7].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); inclusion(%d);} ",yypvt[-0].entier);
			      }
		  else  generR("{dir=%d; inclusion(%d);} ",yypvt[-7].orient.code,yypvt[-0].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		if (yypvt[-0].entier>maxrec) maxrec=yypvt[-0].entier; 

	OK_voisin(yypvt[-5].entier,yypvt[-3].entier);
/*
	PUT_ctm($4,$6,$9);
*/

      } break;
case 179:
# line 2328 "t_yacc.VER"
{ if ((yypvt[-5].entier==-1)||(yypvt[-3].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].entier);
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		generR("accolement(%d); ",yypvt[-0].entier);
		if (yypvt[-0].entier>maxrec) maxrec=yypvt[-0].entier; 

		OK_voisin(yypvt[-5].entier,yypvt[-3].entier);

	      } break;
case 180:
# line 2340 "t_yacc.VER"
{ if ((yypvt[-2].entier==-1)||(yypvt[-0].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].entier);
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		generR("nombre(1); ");
		generD("\n# define	RPRESENCE	1;\n");

		OK_voisin(yypvt[-2].entier,yypvt[-0].entier);

	      } break;
case 181:
# line 2352 "t_yacc.VER"
{ if ((yypvt[-5].entier==-1)||(yypvt[-3].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].entier);
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
		generR("nombre(%d); ",yypvt[-0].entier);

		OK_voisin(yypvt[-5].entier,yypvt[-3].entier);

	      } break;
case 182:
# line 2362 "t_yacc.VER"
{
		if(OK_VDISTANCE){
			PUT_ctm(cur_ad1,cur_ad2,cur_val);
			OK_VDISTANCE=0;
		}
	} break;
case 183:
# line 2374 "t_yacc.VER"
{ yyval.orient.code=(ENRIEN); } break;
case 185:
# line 2384 "t_yacc.VER"
{ yyval.orient.code=LONGIT; yyval.orient.obj=yypvt[-0].entier; } break;
case 186:
# line 2386 "t_yacc.VER"
{ yyval.orient.code=TRANSV; yyval.orient.obj=yypvt[-0].entier; } break;
case 187:
# line 2388 "t_yacc.VER"
{ yyval.orient.code=ENX; } break;
case 188:
# line 2390 "t_yacc.VER"
{ yyval.orient.code=ENY; } break;
case 189:
# line 2392 "t_yacc.VER"
{ yyval.orient.code=ENXY; } break;
case 190:
# line 2394 "t_yacc.VER"
{ yyval.orient.code=ENXY; } break;
case 191:
# line 2396 "t_yacc.VER"
{ yyval.orient.code=ENXY; } break;
case 192:
# line 2398 "t_yacc.VER"
{ yyval.orient.code=ENXY; } break;
case 193:
# line 2405 "t_yacc.VER"
{ 
			generR("%s(); \n",yypvt[-1].opcomp); 
		} break;
case 194:
# line 2413 "t_yacc.VER"
{ generR(" plus(); "); } break;
case 195:
# line 2415 "t_yacc.VER"
{ generR(" moins(); "); } break;
case 196:
# line 2417 "t_yacc.VER"
{ generR(" mul(); "); } break;
case 197:
# line 2419 "t_yacc.VER"
{ generR(" div(); "); } break;
case 198:
# line 2421 "t_yacc.VER"
{ generR(" mod(); "); } break;
case 199:
# line 2425 "t_yacc.VER"
{ generR(" opp(); "); } break;
case 201:
# line 2430 "t_yacc.VER"
{ QUAL=1; } break;
case 202:
# line 2432 "t_yacc.VER"
{ generR("push_v(%d);",yypvt[-0].entier);cur_val=yypvt[-0].entier; } break;
case 203:
# line 2441 "t_yacc.VER"
{	if (yypvt[-0].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-2].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-2].orient.code))||((dirc==ENRIEN)&&(yypvt[-2].orient.code==ENXY)))
		generR("vdimension(); ");
	else if (yypvt[-2].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].orient.obj);
			generR("{dir=dorientation(); vdimension();} ");
		      }
	     else if (yypvt[-2].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); vdimension();} ");
			      }
		  else  generR("{dir=%d; vdimension();} ",yypvt[-2].orient.code);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
      } break;
case 204:
# line 2458 "t_yacc.VER"
{ if (yypvt[-0].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		generR("vlargeur(); ");
	      } break;
case 205:
# line 2465 "t_yacc.VER"
{ if (yypvt[-0].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		generR("vlongueur(); ");
	      } break;
case 206:
# line 2472 "t_yacc.VER"
{ if (yypvt[-0].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		generR("vsurface(); ");
	      } break;
case 207:
# line 2479 "t_yacc.VER"
{ if (yypvt[-0].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		generR("vrapport(); ");
	      } break;
case 208:
# line 2486 "t_yacc.VER"
{ if (yypvt[-0].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		generR("vorientation(); ");
	      } break;
case 209:
# line 2493 "t_yacc.VER"
{	if (yypvt[-0].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if (yypvt[-2].orient.code==ENXY) { typerror=ERRAXE; yyerror() OUTERR  }
	if ((yypvt[-2].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-2].orient.code))||((dirc==ENRIEN)&&(yypvt[-2].orient.code==ENXY)))
		generR("vposition(); ");
	else if (yypvt[-2].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].orient.obj);
			generR("{dir=dorientation(); vposition();} ");
		      }
	     else if (yypvt[-2].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); vposition();} ");
			      }
		  else  generR("{dir=%d; vposition();} ",yypvt[-2].orient.code);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
      } break;
case 210:
# line 2511 "t_yacc.VER"
{	if (yypvt[-4].entier==-1) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if (yypvt[-6].orient.code==ENXY) { typerror=ERRAXE; yyerror() OUTERR  }
	generR("{ ");
	if (!((yypvt[-6].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-6].orient.code))||((dirc==ENRIEN)&&(yypvt[-6].orient.code==ENXY))))
	   if (yypvt[-6].orient.code==LONGIT)
	      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-6].orient.obj);
			generR("dir=dorientation(); ");
		      }
	   else if (yypvt[-6].orient.code==TRANSV)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-6].orient.obj);
			generR("dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); ");
		      }
		else  generR("dir=%d; ",yypvt[-6].orient.code);
	generR("vpos_borne(%d); } ",yypvt[-0].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-4].entier);
      } break;
case 211:
# line 2530 "t_yacc.VER"
{	if ((yypvt[-3].entier==-1)||(yypvt[-0].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-5].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-5].orient.code))||((dirc==ENRIEN)&&(yypvt[-5].orient.code==ENXY)))
		generR("vdistance(); ");
	else if (yypvt[-5].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].orient.obj);
			generR("{dir=dorientation(); vdistance();} ");
		      }
	     else if (yypvt[-5].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); vdistance();} ");
			      }
		  else  generR("{dir=%d; distance();} ",yypvt[-5].orient.code);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);

	OK_voisin(yypvt[-3].entier,yypvt[-0].entier);
	cur_ad1=yypvt[-3].entier;cur_ad2=yypvt[-0].entier;
	OK_VDISTANCE=1;

      } break;
case 212:
# line 2553 "t_yacc.VER"
{	if ((yypvt[-3].entier==-1)||(yypvt[-0].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-5].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-5].orient.code))||((dirc==ENRIEN)&&(yypvt[-5].orient.code==ENXY)))
		generR("vdistmin(); ");
	else if (yypvt[-5].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].orient.obj);
			generR("{dir=dorientation(); vdistmin();} ");
		      }
	     else if (yypvt[-5].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-5].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); vdistmin();} ");
			      }
		  else  generR("{dir=%d; vdistmin();} ",yypvt[-5].orient.code);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-3].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);

	OK_voisin(yypvt[-3].entier,yypvt[-0].entier);
	cur_ad1=yypvt[-3].entier;cur_ad2=yypvt[-0].entier;
	OK_VDISTANCE=1;

      } break;
case 213:
# line 2576 "t_yacc.VER"
{	if ((yypvt[-2].entier==-1)||(yypvt[-0].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-4].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-4].orient.code))||((dirc==ENRIEN)&&(yypvt[-4].orient.code==ENXY)))
		generR("vextension(); ");
	else if (yypvt[-4].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-4].orient.obj);
			generR("{dir=dorientation(); vextension();} ");
		      }
	     else if (yypvt[-4].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-4].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); vextension();} ");
			      }
		  else  generR("{dir=%d; vextension();} ",yypvt[-4].orient.code);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);

	OK_voisin(yypvt[-2].entier,yypvt[-0].entier);
/* INUTILE si SEULs les DISTANCEs imposent un CTM_niv ... */
	cur_ad1=yypvt[-2].entier;cur_ad2=yypvt[-0].entier;

      } break;
case 214:
# line 2599 "t_yacc.VER"
{	if ((yypvt[-2].entier==-1)||(yypvt[-0].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-4].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-4].orient.code))||((dirc==ENRIEN)&&(yypvt[-4].orient.code==ENXY)))
		generR("vmarge(); ");
	else if (yypvt[-4].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-4].orient.obj);
			generR("{dir=dorientation(); vmarge();} ");
		      }
	     else if (yypvt[-4].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-4].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); vmarge();} ");
			      }
		  else  generR("{dir=%d; vmarge();} ",yypvt[-4].orient.code);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);

	OK_voisin(yypvt[-2].entier,yypvt[-0].entier);
	cur_ad1=yypvt[-2].entier;cur_ad2=yypvt[-0].entier;

      } break;
case 215:
# line 2621 "t_yacc.VER"
{	if ((yypvt[-2].entier==-1)||(yypvt[-0].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  }
	if ((yypvt[-4].orient.code==ENRIEN)||((dirc!=ENRIEN)&&(dirc==yypvt[-4].orient.code))||((dirc==ENRIEN)&&(yypvt[-4].orient.code==ENXY)))
		generR("vrecouvrement(); ");
	else if (yypvt[-4].orient.code==LONGIT)
		      { generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-4].orient.obj);
			generR("{dir=dorientation(); vrecouvrement();} ");
		      }
	     else if (yypvt[-4].orient.code==TRANSV)
			      {	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-4].orient.obj);
				generR("{dir=dorientation(); \ndir=((dir==2) ? dir : 1-dir); vrecouvrement();} ");
			      }
		  else  generR("{dir=%d; vrecouvrement();} ",yypvt[-4].orient.code);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].entier);
	generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);

	OK_voisin(yypvt[-2].entier,yypvt[-0].entier);
	cur_ad1=yypvt[-2].entier;cur_ad2=yypvt[-0].entier;

      } break;
case 216:
# line 2643 "t_yacc.VER"
{ if ((yypvt[-2].entier==-1)||(yypvt[-0].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].entier);
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		generR("vsuperposition(); ");

		OK_voisin(yypvt[-2].entier,yypvt[-0].entier);
		cur_ad1=yypvt[-2].entier;cur_ad2=yypvt[-0].entier;

	      } break;
case 217:
# line 2655 "t_yacc.VER"
{ if ((yypvt[-2].entier==-1)||(yypvt[-0].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].entier);
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		generR("vaccolement(); ");

		OK_voisin(yypvt[-2].entier,yypvt[-0].entier);
		cur_ad1=yypvt[-2].entier;cur_ad2=yypvt[-0].entier;

	      } break;
case 218:
# line 2667 "t_yacc.VER"
{ if ((yypvt[-2].entier==-1)||(yypvt[-0].entier==-1)) { typerror=ERRINEXIST; yyerror() OUTERR  } 
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-2].entier);
		generV("TAB_PARAM[%d].param[%d]=%d; \n",noregle,irprm++,yypvt[-0].entier);
		generR("vnombre(); ");

		OK_voisin(yypvt[-2].entier,yypvt[-0].entier);
		cur_ad1=(-1);cur_ad2=(-1);

	      } break;
case 221:
# line 2690 "t_yacc.VER"
{
			generD("\n");
			if(cpt_inst>0){
				generD("# define YESINS 		1\n");
				generD("# define SZINSTAB		%d \n",cpt_inst);
			}

			if(cpt_trans>0){
				generD("# define YESTRA			1\n");
				generD("# define SZTRATAB		%d\n",cpt_trans);
			}

			if(cpt_via>0){
				generD("# define YESVIA			1\n");
				generD("# define SZVIATAB		%d\n",cpt_via);
			}

			if(cpt_cont>0){
				generD("# define YESCON			1\n");
				generD("# define SZCONTAB		%d\n",cpt_cont);
			}
			generD("\n");

		} break;
case 223:
# line 2721 "t_yacc.VER"
{
		int i;
		struct typobjln *ptrr;

			cpt_inst=0;
			typerror=fprintf(ifnV,"\n");
			if(typerror==(-1)){
				yyerror();OUTERR
			}
			ptrr=yypvt[-0].objln;
			for(i=1;i<szln;i++){
				typerror=fprintf(ifnV,"strcpy(STAT_INS_TAB[%d].nom,\"%s\");\n",i-1,ptrr->nom);
				if(typerror==(-1)){
					yyerror();OUTERR
				}
				cpt_inst++;
				ptrr++;
			}

			free(ptrln);
			szln=1;
		} break;
case 225:
# line 2749 "t_yacc.VER"
{
		int i,res;
		struct typobjln *ptrr;

			ptrr=yypvt[-0].objln;
			cpt_trans=0;
			typerror=fprintf(ifnV,"\n");
			if(typerror==(-1)){
				yyerror();OUTERR
			}
			for(i=1;i<szln;i++){
				res=cherch_n(ptrr->nom);
				if( res==(-1) ){
					typerror=ERRINEXIST;
					yyerror();
				}
				typerror=fprintf(ifnV,"strcpy(STAT_TRA_TAB[%d].nom,\"%s\");\n",i-1,ptrr->nom);
				if(typerror==(-1)){
					yyerror();OUTERR
				}
				cpt_trans++;
				ptrr++;
			}

			free(ptrln);
			szln=1;
		} break;
case 227:
# line 2782 "t_yacc.VER"
{
		int i,res;
		struct typobjln *ptrr;

			ptrr=yypvt[-0].objln;
			cpt_via=0;
			typerror=fprintf(ifnV,"\n");
			if(typerror==(-1)){
				yyerror();OUTERR
			}
			for(i=1;i<szln;i++){
				res=cherch_n(ptrr->nom);
				if( res==(-1) ){
					typerror=ERRINEXIST;
					yyerror();
				}
				typerror=fprintf(ifnV,"strcpy(STAT_VIA_TAB[%d].nom,\"%s\");\n",i-1,ptrr->nom);
				if(typerror==(-1)){
					yyerror();OUTERR
				}
				cpt_via++;
				ptrr++;
			}

			free(ptrln);
			szln=1;
		} break;
case 229:
# line 2815 "t_yacc.VER"
{
		int i,res;
		struct typobjln *ptrr;

			ptrr=yypvt[-0].objln;
			cpt_cont=0;
			typerror=fprintf(ifnV,"\n");
			if(typerror==(-1)){
				yyerror();OUTERR
			}
			for(i=1;i<szln;i++){
				res=cherch_n(ptrr->nom);
				if( res==(-1) ){
					typerror=ERRINEXIST;
					yyerror();
				}
				typerror=fprintf(ifnV,"strcpy(STAT_CON_TAB[%d].nom,\"%s\");\n",i-1,ptrr->nom);
				if(typerror==(-1)){
					yyerror();OUTERR
				}
				cpt_cont++;
				ptrr++;
			}

			free(ptrln);
			szln=1;
		} break;
		}
		goto yystack;  /* stack new state and value */

	}
