/****************************************************************************/
/*                                                                          */
/*          REGLES DE DESSIN  SYMBOLIQUE   25 JUIL 1991       V 2.0         */
/*                                                                          */
/****************************************************************************/


verifications sur:


/*                     Type de verification et echelle                      */
/*                        (definition de la longueur)                       */
/*                         -------------------------                        */

   dessin au lambda       /* longueur=valeur numerique lue                  */

   echelle 1/1            /* l'echelle multiplie toutes les longueurs       */
                          /* par ce facteur fractionel                      */


/*      Declaration des niveaux et des tailles minimums de leur masques     */
/*          (reconstitution des fils polygonnaux de meme niveau)            */
/*          ----------------------------------------------------            */

   niveau    CAISSON_N     8  /* caisson N                                  */
   niveau    DIFN    	   4  /* diffusion N (transistor, fil)              */
   niveau    DIFP          4  /* diffusion P (transistor, fil)              */
   niveau    POLY_GRILLE   2  /* polysilicium de grille de transistor       */
   niveau    POLY          2  /* polysilicium d'interconnection             */
   niveau    ALU1          2  /* metal premier niveau                       */
   niveau    ALU2          4  /* metal second niveau                        */
   niveau    COND          2  /* trou de contact ALU1->DIFF                 */
   niveau    CONT          2  /* trou de contact ALU1->POLY/DIFF            */
   niveau    VIA           2  /* trou de contact ALU1->ALU2                 */
   niveau    CAISSON_P     8  /* non utilise                                */
   niveau    NULL          2  /* non utilise                                */


/*			declaration de niveaux composes			    */
/*                      -------------------------------                     */

/* 	   intersections permettant l'interdiction des recouvrements 	    */


   pseudo niveau    INTER_DIFN_CAISSON_N  intersection DIFN , CAISSON_N

   pseudo niveau    INTER_DIFP_DIFN   intersection DIFP , DIFN


   pseudo niveau    INTER_POLY_DIFN   intersection POLY , DIFN
   pseudo niveau    INTER_POLY_DIFP   intersection POLY , DIFP

   pseudo niveau    INTER_CONT_POLY_GRILLE   intersection CONT , POLY_GRILLE

   pseudo niveau    INTER_VIA_POLY_GRILLE    intersection VIA  , POLY_GRILLE
   pseudo niveau    INTER_VIA_POLY    intersection VIA  , POLY
   pseudo niveau    INTER_VIA_CONT    intersection VIA  , CONT

/*      intersections permettant les controles de recouvrement minimums     */

   pseudo niveau    INTER_CAISSON_N_CAISSON_N intersection CAISSON_N, CAISSON_N
   pseudo niveau    INTER_DIFN_DIFN   intersection DIFN , DIFN
   pseudo niveau    INTER_DIFP_DIFP   intersection DIFP , DIFP
   pseudo niveau    INTER_POLY_GRILLE_POLY_GRILLE   intersection POLY_GRILLE , POLY_GRILLE
   pseudo niveau    INTER_POLY_POLY_GRILLE   intersection POLY , POLY_GRILLE
   pseudo niveau    INTER_POLY_POLY   intersection POLY , POLY
   pseudo niveau    INTER_ALU1_ALU1   intersection ALU1 , ALU1
   pseudo niveau    INTER_ALU2_ALU2   intersection ALU2 , ALU2

directives 


/*                   Declaration des niveaux larges                         */
/*               (optimisation du chainage de voisinage)                    */
/*             ---------------------------------------------                */

   niveau large : CAISSON_N


/*                  Declaration des niveaux equipotentiels                  */
/*  (permet la reconstitution de fils polygonnaux sur des geometries...)    */
/*                 (de meme niveau mais nommes differemment)                */ 
/*                 -----------------------------------------                */

   equipotentielle POLY composee de : POLY, POLY_GRILLE

/*                     Declaration des regles a un corps                    */
/*                     ---------------------------------                    */

chaque descripteur verifie par:

   /* - les largeurs minimum, en principe garanties par construction, sont  */
   /*   tout de meme testees.                                               */
   /* - les largeurs maximum des contacts exprime le fait que deux contacts */
   /*     identiques ne doivent pas se toucher                              */

     regle  1 : longueur  de CAISSON_N   min de 8  
     regle  4 : longueur  de DIFN        min de 4 
     regle  5 : longueur  de DIFP        min de 4
     regle  6 : longueur  de POLY_GRILLE min de 2 
     regle  7 : longueur  de POLY        min de 2 
     regle  8 : longueur  de ALU1        min de 2 
     regle  9 : longueur  de ALU2        min de 4 
     regle 10 : longueur  de CONT        max de 2 
     regle 11 : longueur  de VIA         max de 2 
 
/*  Les regles suivantes expriment l'interdiction de recouvrement           */
/*  et d'accolement                                                         */
             
      

     regle 14 : largeur de l'INTER_DIFN_CAISSON_N    < 0

     regle 19 : largeur de l'INTER_DIFP_DIFN         < 0


     regle 24 : largeur de l'INTER_POLY_DIFN         < 0
     regle 25 : largeur de l'INTER_POLY_DIFP         < 0

     regle 26 : largeur de l'INTER_CONT_POLY_GRILLE  < 0

     regle 27 : largeur de l'INTER_VIA_POLY_GRILLE   < 0
     regle 28 : largeur de l'INTER_VIA_POLY          < 0
     regle 29 : largeur de l'INTER_VIA_CONT          < 0

/*  Les regles suivantes expriment la tolerance de l'intersection entre     */
/* masques, lorsque l'une des longueurs de cette intersection est >= un MIN */

     regle 30 : longueur de l'INTER_CAISSON_N_CAISSON_N       >= 8
     regle 33 : longueur de l'INTER_DIFN_DIFN                 >= 4
     regle 34 : longueur de l'INTER_DIFP_DIFP                 >= 4
     regle 35 : longueur de l'INTER_POLY_GRILLE_POLY_GRILLE   >= 2
     regle 36 : longueur de l'INTER_POLY_POLY_GRILLE          >= 2
     regle 37 : longueur de l'INTER_POLY_POLY                 >= 2
     regle 38 : longueur de l'INTER_ALU1_ALU1                 >= 2
     regle 39 : longueur de l'INTER_ALU2_ALU2                 >= 4
 
/*                     Declaration des regles a deux corps                  */
/*                     -----------------------------------                  */

tout 2 uplet de descripteurs verifies par:

/* Chacun des verbes (geometriques) utilises pour la specification des      */
/* regles a 2 fonctions: VERIFICATION (avec min), EVALUATION (avec >=). La  */
/* verification de la distance tient compte de la notion d'equipotentialite.*/
/* Cela se traduit, en cas de detection d'erreur, par l'application d'une   */
/* regle implicite de recouvrement d'erreur,a trois corps (deux explicites, */
/* ceux declares dans la regle, et un implicite equipotentiel avec les deux */
/* premier et realisant leur jonction).                                     */

   /* La distance axiale a deux semantiques suivant que les masques         */
   /* sont en vis a vis ou decales :                                        */
   /*  - en vis a vis, c'est la distance la plus courte                     */
   /*    mesuree sur un axe coupant les deux masques                        */
   /*  - sinon c'est la longeur du plus grand cote du rectangle defini      */
   /*    par les coins les plus proches des masques consideres              */

     regle 40 : distance axiale entre le  CAISSON_N  et le  CAISSON_N  min de 14



     regle 46 : distance axiale entre la  DIFN   et le  CAISSON_N  min de  15
     regle 49 : distance axiale entre la  DIFN   et le  DIFN       min de  6

     regle 50 : distance axiale entre la  DIFP   et le  CAISSON_N  min de  15
     regle 53 : distance axiale entre la  DIFP   et le  DIFN       min de  16
     regle 54 : distance axiale entre la  DIFP   et le  DIFP       min de  6

     regle 57 : distance axiale entre la  POLY_GRILLE  et le  DIFN min de  2
     regle 58 : distance axiale entre la  POLY_GRILLE  et le  DIFP min de  2
     regle 59 : distance axiale entre la POLY_GRILLE et le POLY_GRILLE min de 4

     regle 62 : distance axiale entre la  POLY   et le  DIFN   min de  2
     regle 63 : distance axiale entre la  POLY   et le  DIFP   min de  2
     regle 64 : distance axiale entre la  POLY   et le  POLY_GRILLE   min de  4
     regle 65 : distance axiale entre la  POLY   et le  POLY   min de  4

     regle 66 : distance axiale entre la  ALU1   et le  ALU1   min de  5 

     regle 67 : distance axiale entre la  ALU2   et le  ALU2   min de  4 

     regle 68 : distance axiale entre la  CONT   et le  CONT   min de  6 

     regle 69 : distance axiale entre la  VIA    et le  POLY_GRILLE   min de  4 
     regle 70 : distance axiale entre la  VIA    et le  POLY   min de  4 
     regle 71 : distance axiale entre la  VIA    et le  CONT   min de  4 
     regle 72 : distance axiale entre la  VIA    et le  VIA    min de  6 

     regle 73 : distance axiale entre la  COND   et le  POLY_GRILLE   min de  4 

/*  		Les regles suivantes expriment l'inclusion totale          */

     regle 74 : inclusion de  DIFN   dans   CAISSON_N              min de   1
     regle 75 : inclusion de  DIFP   dans   CAISSON_N              min de   1 
