*
* Small program to convert a MUMOD formatted trajectory file
*       to binary one
*
*    Leif Laaksonen 1992
*
      parameter MAXA = 10000

      real tstep
      real x2,y2,z2
      real x(MAXA),y(MAXA),z(MAXA)
      integer ifre
      integer natom
      integer npts7
      character*120   Infile,Outfile


      write(6,*) "Give input file name"
       read(5,'(A)') Infile
      write(6,*) "Give output file name"
       read(5,'(A)') Outfile

      open(unit=20,status="OLD",file=Infile,
     1     form="FORMATTED",ERR = 1000)
      open(unit=21,status="UNKNOWN",file=Outfile,
     1     form="UNFORMATTED",ERR = 1000)

*     start readind
      read(20,*) tstep,ifre,natom,npts7,x2,y2,z2

      if(natom .gt. MAXA) then
        write(6,*) 'Maximum number of atoms reached'
        call exit
      endif

      write(6,*) 'tspep: ',tstep
      write(6,*) 'ifre : ',ifre
      write(6,*) 'natom: ',natom
      write(6,*) 'npts7: ',npts7
      write(6,*) 'x2: ',x2,'y2: ',y2,'z2: ',z2

* ok do the job
      write(21)  tstep,ifre,natom,npts7,x2,y2,z2

      do 5 i = 1,npts7+1

      read(20,*,end=100,err=200) (x(k),y(k),z(k),k = 1,natom)

      write(21)  (x(k),y(k),z(k),k = 1,natom)

 5    continue

      call exit

 100  Write(6,*) 'ERROR - end of file reached'
      call exit
 200  Write(6,*) 'ERROR - read error'
      call exit
1000  write(6,*) "?ERROR - can't open input/output file"
      call exit
      end
