/*  

                       Copyright (c) 1993 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#ifdef sgi
#include <gl/gl.h>
#include <gl/device.h>
#endif
#include "maxdefs.h"


int PushToWindowStack(long window_id , int plot_type);
int DeleteFromWindowStack(long window_id);
int DeleteWindowStack();
int OpenWindows();
int ShouldIDrawObject();
int OrderLDPWindow(int plot_type);
int OrderRAMAWindow(int plot_type);
long GetMainWindowID();
void HandleWinShut();
void ShowWindowStack();
void DisableMultiWindow();
void EnableMultiWindow();
void SetActiveWindow(long WinId);
long GetActiveWindow();
void DeleteWinUpdateStack();
int  PushToWindowUPDateStack(long WinId);
int  UsingMultiWindowing();
int  ShowLDPwindID();
int  WhichWindowToUpdate(int WinId);
int  HandleInputChange(int Window);
int  UpdateAllOpenWindows();
int  UpdateAllPlots();

/*  structure to contain window information */
   struct {
    long win_ids[MAX_WINDOWS];    /* array to contain window ids */
    long win_num;                 /* number of open windows      */
    int  plot_type[MAX_WINDOWS];  /* type of plot in window      */
    int  Off;                       /* != 0 , control off          */
    int  update;                    /* number of windows to update */
    long needs_update[MAX_WINDOWS]; /* windows that need update    */
                 } WinControl;

/* structure to contain information about window update */
   extern struct {
     int MainW;      /* Main window          */
     int LDPW;       /* Distance plot window */
     int Rama;       /* Ramachandran plot    */
     int Cluster;    /* Cluster plot         */
   } WUpdate;

/* define the different menus which are in use */
      extern struct MuList {
        int SaveMenu;
        int Menu;          /* = 1 , display main menu
                              = 2 , display dynamics menu
                              = 3 , display ldp menu
                           */
                     } MenuList;

    extern int term_type;
    extern int draw_obj_disp;
    extern int ldp_wind;
    extern int rama_wind;
    extern int cluster_wind;
    extern short BLACKv[3];
    extern short bgcolor[3];

    extern void DeleteRamachandranStuff();

/**************************************************************************/
int  PushToWindowStack(long window_id , int plot_type)
/**************************************************************************/
{
     int i;

     i = WinControl.win_num;

     if(i == MAX_WINDOWS) {
       PrintMessage("?ERROR - Max number of windows already open");
       return(1);}

     WinControl.win_ids[i]   = window_id;
     WinControl.plot_type[i] = plot_type;
     WinControl.win_num++;

     return(0);
}

/**************************************************************************/
int DeleteFromWindowStack(long window_id)
/**************************************************************************/
{
    int i,j;

    if(WinControl.win_num < 1) {
       PrintMessage("?ERROR - No windows open at all to be closed");
       return(1);}

    for(i = 0 ; i < WinControl.win_num ; i++) {

        if(window_id == WinControl.win_ids[i]) { /* hit */

          if(i == 0) { /* main window can't be closed */
             PrintMessage("?ERROR - Main window can't be closed");
             return(0);}

           switch(WinControl.plot_type[i]) {

           case LDP_PLOT:
                ldp_wind          = 0;
                draw_obj_disp     = 1;
                MenuList.Menu     = 1;
                MenuList.SaveMenu = 1;
                break;
           case RAMA_PLOT:
                draw_obj_disp     = 1;
                rama_wind         = 0;
                break;

           case CLUSTER_PLOT:
                draw_obj_disp     = 1;
                cluster_wind      = 0;
                break;

	   default:
                PrintMessage("ERROR - Check in DeleteWindowStack");
	      }

           if(i > 0) {
              for( j = i ; j < WinControl.win_num - 1; j++) {
                       WinControl.win_ids[j]   = WinControl.win_ids[j+1];
                       WinControl.plot_type[j] = WinControl.plot_type[j+1];}
	   }
        winclose(window_id);
        WinControl.win_num--;
        return(0);}
      }

     PrintMessage("?ERROR - Window to be closed is unknown");
     return(1);
}
/**************************************************************************/
int DeleteWindowStack()
/**************************************************************************/
{
    WinControl.win_num = 0;
    return(0);
}
/**************************************************************************/
int OpenWindows()
/**************************************************************************/
{
    return(WinControl.win_num);
}
/**************************************************************************/
int ShouldIDrawObject()
/**************************************************************************/
{
    if(WinControl.Off) return(0);

    if(term_type == 1) return(1);

    return(0);
}
/**************************************************************************/
int OrderLDPWindow(int plot_type)
/**************************************************************************/
{
    register int i;
    long WinIds;

    if(WinControl.Off) return(0);

    for(i = 0 ; i < OpenWindows() ; i++) {

        if(WinControl.plot_type[i] == LDP_PLOT) {
           winset(WinControl.win_ids[i]);
           reshapeviewport();
           (void) PushToWindowUPDateStack(WinControl.win_ids[i]);
           return(0);}
    }

           WinIds = winopen("ldp");
           if(WinIds == -1) {
              PrintMessage("?ERROR - can't open LDP window");
              return(1);}

           if(PushToWindowStack(WinIds , LDP_PLOT)) {
              PrintMessage("?ERROR - can't push LDP_PLOT to window stack");
              return(1);}

           (void) PushToWindowUPDateStack(WinIds);
           winset(WinIds);
           doublebuffer();
           RGBmode();
           gconfig();
           reshapeviewport();
           mmode(MVIEWING);
           c3s(bgcolor);
           clear();
           zclear();
           (void)ScareSwapbuffers();

      return(0);
}
/**************************************************************************/
long GetMainWindowID()
/**************************************************************************/
{
    return(WinControl.win_ids[0]);
}
/**************************************************************************/
void HandleWinShut(long WinId)
/**************************************************************************/
{
   if(DeleteFromWindowStack(WinId)) 
      PrintMessage("?ERROR - can't delete window id from stack");

   return;
}
/**************************************************************************/
void ShowWindowStack()
/**************************************************************************/
{
    int i;
    char OutText[BUFF_LEN];

    for(i = 0 ; i < WinControl.win_num ; i++) {

       sprintf(OutText,"(%d) Window ID: %d , type: %d",(i+1),
                                        WinControl.win_ids[i],
                                        WinControl.plot_type[i]);
       PrintMessage(OutText);}

    return;
}
/**************************************************************************/
void  DisableMultiWindow()
/**************************************************************************/
{

     WinControl.Off = 1; 

     return;
}
/**************************************************************************/
void  EnableMultiWindow()
/**************************************************************************/
{

     WinControl.Off = 0; 

     return;
}
/**************************************************************************/
void SetActiveWindow(long WinId)
/**************************************************************************/
{
     winset(WinId);
}
/**************************************************************************/
long GetActiveWindow(long WinId)
/**************************************************************************/
{
     return(winget());
}
/**************************************************************************/
void DeleteWinUpdateStack()
/**************************************************************************/
{
     WinControl.update = 0;
}
/**************************************************************************/
int  PushToWindowUPDateStack(long WinId)
/**************************************************************************/
{
     WinControl.needs_update[WinControl.update] = WinId;

     WinControl.update++;

     return(0);
}
/**************************************************************************/
int  UsingMultiWindowing()     /* == 0 , NO
                                  != 0 , YES */
/**************************************************************************/
{
     if(WinControl.Off)        return(0);

     if(WinControl.win_num < 2) return(0);

     if(WinControl.update  < 2) return(0);

     return(1);
}
/**************************************************************************/
int  ShowLDPwindID()
/**************************************************************************/
{
    register int i;
    long WinIds;

    if(WinControl.Off) return(0);

    for(i = 0 ; i < OpenWindows() ; i++) {

        if(WinControl.plot_type[i] == LDP_PLOT) {
           return((long)WinControl.win_ids[i]);}
    }

    return(-1); /* no ldp window active */
}
/**************************************************************************/
int  ShowRAMAwindID()
/**************************************************************************/
{
    register int i;
    long WinIds;

    if(WinControl.Off) return(0);

    for(i = 0 ; i < OpenWindows() ; i++) {

        if(WinControl.plot_type[i] == RAMA_PLOT) {
           return((long)WinControl.win_ids[i]);}
    }

    return(-1); /* no ramachandran window active */
}
/**************************************************************************/
int WhichWindowToUpdate(int WinId)
/**************************************************************************/
{
    register int i;

    if(WinControl.Off) return(0);

    if(WinId == 0) return(0);   /* ok */

    for(i = 0 ; i < OpenWindows() ; i++) {

        if(WinControl.win_ids[i] == WinId) {
           
           switch(WinControl.plot_type[i]) {

	   case MOLECULE_PLOT:
                WUpdate.MainW = 1;
                return(0);

	   case LDP_PLOT: 
                WUpdate.LDPW  = 1;
                return(0);

           case RAMA_PLOT:
                WUpdate.Rama  = 1;
                return(0);

           case CLUSTER_PLOT:
                WUpdate.Cluster = 1;
                return(0);
           }
	 }
      }
     return(1);
}


/**************************************************************************/
int OrderRAMAWindow(int plot_type)
/**************************************************************************/
{
    register int i;
    long WinIds;

    if(WinControl.Off) return(0);

    for(i = 0 ; i < OpenWindows() ; i++) {

        if(WinControl.plot_type[i] == RAMA_PLOT) {
           winset(WinControl.win_ids[i]);
           reshapeviewport();
           (void) PushToWindowUPDateStack(WinControl.win_ids[i]);
           return(0);}
    }

           WinIds = winopen("rama");
           if(WinIds == -1) {
              PrintMessage("?ERROR - can't open RAMACHANDRAN window");
              return(1);}

           if(PushToWindowStack(WinIds , RAMA_PLOT)) {
              PrintMessage("?ERROR - can't push RAMA_PLOT to window stack");
              return(1);}

           (void) PushToWindowUPDateStack(WinIds);
           winset(WinIds);
           doublebuffer();
           RGBmode();
           gconfig();
           reshapeviewport();
           mmode(MVIEWING);
           c3s(BLACKv);
           clear();
           zclear();
           (void)ScareSwapbuffers();

      return(0);
}
/**************************************************************************/
int  HandleInputChange(int Window)
/**************************************************************************/
{

   register int i;

/* window number 1 is always main window */

   if(WinControl.Off) return(0);

   if(Window == 0) return(0); /* input focus removed, OK */

     if(Window == 1) {
        winset(WinControl.win_ids[1]);
        MenuList.Menu = 1;
        return(0);}

     if(WinControl.win_num < 2) return(0);

   for(i = 1 ; i < WinControl.win_num ; i++) {
      
     if(WinControl.win_ids[i] == Window) {

      switch(WinControl.plot_type[i]) {  

       case MOLECULE_PLOT:
          winset(WinControl.win_ids[i]);
          MenuList.Menu = 1;
          return(0);
     
       case LDP_PLOT: 
          winset(WinControl.win_ids[i]);
          MenuList.Menu = 3;
          return(0);

       case RAMA_PLOT:
          winset(WinControl.win_ids[i]);
          return(0);
	}
    }
   }
   return(1);
}
/***********************************************************************/
int UpdateAllOpenWindows()
/**************************************************************************/
{
    register int i;

    if(WinControl.Off) return(0);

    for(i = 0 ; i < OpenWindows() ; i++) {

           switch(WinControl.plot_type[i]) {

	   case MOLECULE_PLOT:
                WUpdate.MainW   = 1;

	   case LDP_PLOT: 
                WUpdate.LDPW    = 1;

           case RAMA_PLOT:
                WUpdate.Rama    = 1;

           case CLUSTER_PLOT:
                WUpdate.Cluster = 1;
           }
      }
     return(1);
}

/**************************************************************************/
int OrderCLUSTERWindow(int plot_type)
/**************************************************************************/
{
    register int i;
    long WinIds;

    if(WinControl.Off) return(0);

    for(i = 0 ; i < OpenWindows() ; i++) {

        if(WinControl.plot_type[i] == CLUSTER_PLOT) {
           winset(WinControl.win_ids[i]);
           reshapeviewport();
           (void) PushToWindowUPDateStack(WinControl.win_ids[i]);
           return(0);}
    }

           WinIds = winopen("cluster");
           if(WinIds == -1) {
              PrintMessage("?ERROR - can't open CLUSTER window");
              return(1);}

           if(PushToWindowStack(WinIds , RAMA_PLOT)) {
              PrintMessage("?ERROR - can't push CLUSTER_PLOT to window stack");
              return(1);}

           (void) PushToWindowUPDateStack(WinIds);
           winset(WinIds);
           doublebuffer();
           RGBmode();
           gconfig();
           reshapeviewport();
           mmode(MVIEWING);
           c3s(BLACKv);
           clear();
           zclear();
           (void)ScareSwapbuffers();

      return(0);
}
/**************************************************************************/
int  ShowCLUSTERwindID()
/**************************************************************************/
{
    register int i;
    long WinIds;

    if(WinControl.Off) return(0);

    for(i = 0 ; i < OpenWindows() ; i++) {

        if(WinControl.plot_type[i] == CLUSTER_PLOT) {
           return((long)WinControl.win_ids[i]);}
    }

    return(-1); /* no cluster window active */
}
/**************************************************************************/
int UpdateAllPlots()
/**************************************************************************/
{

       WUpdate.MainW   = 1;

       if(ldp_wind)
       WUpdate.LDPW    = 1;

       if(rama_wind)
       WUpdate.Rama    = 1;

       if(cluster_wind)
       WUpdate.Cluster = 1;

       return(0);
}
