/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , VTT/Biotechnical laboratory, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <sys/types.h>
#include <malloc.h>

#include "maxdefs.h"

/*

 Routine to calculate the van der Waals + electrostatic interaction
 from a point in the space to all other atoms or atoms inside 
 a r(cut) value 

 Leif Laaksonen 1990

*/

/* define some externals */

    extern int numat;  /* number of atoms */
    extern int *res1;  /* pointer to residue 1 */
    extern int **cnct; /* atom connection table */
    extern int *atm_type; /* pointer to atom type */
    extern float *x,*y,*z; /* pointers to x,y and z coordinates */
    extern float *atm_charge; /* pointer to atom charge */
    extern char *resnam;    /* pointer to residue name */
    extern char *atnam;     /* pointer to atom name */
    extern char *segment;   /* pointer to segment name */
    extern char *disp_list; /* pointer to display list */
    extern float *vector();
    extern int atom_list_max();

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

    extern struct  param_struct {
    int     type;
    float   bndrad;
    float   vdwrad;
    float   plurad;
    char    global;
    float   emin;
    float   rmin;
    float   patom;
    float   mass;
    int     cnct;
    char    hbond;
    char    atype[4];} ;

    extern int param203_terms;              /* terms in the parameters list */

    extern struct param_struct param203[MAXatc];

    float fpe = 332.0636; /* 4*pi*epsilon in kcal A /(mol*e**2) */

/************************************************************************/
float find_vdwemin(alt) /* find the vdw epsilon min from type alt */
      int alt;                
/************************************************************************/
{

    register int i;

       for(i = 0 ; i < param203_terms ; i++ ) {

          if(param203[i].type == alt) {
          return(param203[i].emin);}
	}

    printf("?ERROR - undefined atom type <%d> \n",alt);
    return(0.0);
}
/************************************************************************/
float find_vdwrmin(alt) /* find the vdw r min from type alt */
      int alt;                
/************************************************************************/
{

    register int i;

       for(i = 0 ; i < param203_terms ; i++ ) {

          if(param203[i].type == alt) {
          return(param203[i].rmin);}
	}

    printf("?ERROR - undefined atom type <%d> \n",alt);
    return(0.0);
}


/************************************************************************/
float vdwel( from , rcut)
      int from; /* index from which atom it is calculated */
      float rcut; /* cut value for the distance */
/************************************************************************/
{
     extern int *ivector();

     static float *sigma;    /* pointer to sigma in L-J potential */
     static float *epsilon;  /* pointer to epsilon in L-J potential */
     static float sigmai;    /* sigma for atom i */
     static float epsiloni;  /* epsilon for atom i */
     static float chargei;   /* charge for atom i */
     static float perm = 1.0;/* dielectric constant */
     static float energy;    /* total vdW + electrostatic interaction */
     register float energy1;   /* VdW energy part */
     register float energy2;   /* Coulomb part */
     static float dist,dist2,dist6,dist12;
     static float sigma1,sigma2,sigma6,sigma12;
     static float dx,dy,dz,en1,en2;
     register float chelp;
     register int i,j;
     static int *jlist;
     static int atom_max;
     static int list;

     atom_max = atom_list_max();
     jlist = ivector(atom_max);

     nonbonds_i(&list,from,jlist,rcut);

     if(list < 1) return(0.0);

     chelp = 1. / pow(2.0,(1.0/6.0));

/* get some space for the working arrays */

     sigma = vector(atom_max);
     epsilon = vector(atom_max);

/* assign the values ... */

        sigmai   =  find_vdwrmin(atm_type[from]) * chelp; 
        epsiloni = -find_vdwemin(atm_type[from]);
        chargei  =  atm_charge[from];

     for(i = 0 ; i < list ; i++) {
     j = jlist[i];

     if(atm_type[j] == 0) { /* atom types not set properly */
       printf("?ERROR - atom types not set or set not properly \n");
       return;}

        sigma[i]   =  find_vdwrmin(atm_type[j]) * chelp; 
        epsilon[i] = -find_vdwemin(atm_type[j]);
      }

/* calculate energy ... */

      energy = 0.0;
      energy1 = 0.0;
      energy2 = 0.0;

      for(i = 0 ; i < list ; i++) {

      j = jlist[i];

         dx = x[j] - x[from];
          dy = y[j] - y[from];
           dz = z[j] - z[from];

         dist2 = 1. / (dx*dx + dy*dy + dz*dz);

         dist = sqrt(dist2);

         dist6  = dist2 * dist2 * dist2;

         sigma1 = 0.5 * (sigma[i] + sigmai);
         sigma2 = sigma1 * sigma1;
         sigma6 = sigma2 * sigma2 * sigma2;
         sigma12 = sigma6 * sigma6;

      energy1 += sqrt(epsilon[i]*epsiloni) * 
                (sigma12 * dist6 - sigma6 ) * dist6;

      energy2 += atm_charge[j] * chargei * dist ;

#ifdef DEBUG
      printf("::dist %f q1 %f q2 %f %f %f \n",1./dist,atm_charge[j],chargei,4.*energy1,fpe*energy2);
      printf("ek %f ei %f \n",epsiloni,epsilon[i]);
      printf("rk %f ri %f \n",sigma[i],sigmai);
#endif
      }

/* finally sum it up */
      
      energy1 = 4.0 * energy1;
      energy2 = fpe * energy2 / perm;

      energy = energy1 + energy2;

      printf("van der Waals part         = %f \n",energy1);
      printf("Coulomb part               = %f \n",energy2);
      printf("Total vdW + Coulomb energy = %f \n",energy);          

/* delete scratch space */
      free(epsilon);
      free(sigma);
      free(jlist);

      return(energy);
}

/* routine to determine the non bonded list from atom i */
/************************************************************************/
nonbonds_i(list,i,jlist,rcut)   
    int *list;    /* length of nonbonded list */
    int i;       /* calculate list from atom i */
    int *jlist;  /* pointer to nonbonded atom list */
    float rcut;  /* cutoff distance */
/************************************************************************/
{

      register int j,k,l;
      static int kk;
      static float dx,dy,dz,dist;
      static float xi,yi,zi;
      register float rcut2;
      register float dist2;

      rcut2 = rcut*rcut;

      *list = 0;
       xi = x[i];
        yi = y[i];
         zi = z[i];

         for(j = 0 ; j < mliste[0] ; j++) {

         if(i == j) continue;

/* if direct bond or if i,j has a common atom */
         for(k = 0 ; k < cnct[j][0] ; k++) {
            if((kk = cnct[j][k+1]) == i) goto not_into; /* direct bond */
                for(l = 0 ; l < cnct[i][0] ; l++) {
                if(kk == cnct[i][l+1] ) goto not_into; /* common atom */
	        }
	 }

         dx = xi - x[j];
          dy = yi - y[j];
           dz = zi - z[j];

         dist2 = (dx*dx + dy*dy + dz*dz);

/* check rcut .... */

         if(dist2 > rcut2) continue;

         jlist[*list] = j;
         (*list)++;

not_into:;                                /* label for "not into list" */
       }

#ifdef DEBUG
       for(j = 0 ; j < *list ; j++) 
          printf(">>%d<< jlist %d \n",j+1,jlist[j]+1);
#endif
}
/* routine to determine the non bonded list */
/************************************************************************/
nonbonds(list,ilist,jlist,rcut)   
    int *list;   /* length of nonbonded list */
    int *ilist;  /* pointer to nonbonded atom list */
    int *jlist;  /*       -"-                      */
    float rcut;  /* cutoff distance */
/************************************************************************/
{

      register int i,j,k,l;
      static int kk;
      static float dx,dy,dz,dist;
      register float dist2;
      register float rcut2;

      rcut2 = rcut*rcut;

      *list = 0;

      for(i = 0 ; i < mliste[0] - 1 ; i++) {

         for(j = i+1 ; j < mliste[0] ; j++) {

/* if direct bond or if i,j has a common atom */
         for(k = 0 ; k < cnct[j][0] ; k++) {
            if((kk = cnct[j][k+1]) == i) goto not_into; /* direct bond */
                for(l = 0 ; l < cnct[i][0] ; l++) {
                if(kk == cnct[i][l+1] ) goto not_into; /* common atom */
	        }
	 }

         dx = x[i] - x[j];
          dy = y[i] - y[j];
           dz = z[i] - z[j];

         dist2 = (dx*dx + dy*dy + dz*dz);

/* check rcut ... */

         if(dist2 > rcut2) continue;         

         ilist[*list] = i;
         jlist[*list] = j;
         (*list)++;

not_into:;                                /* label for "not into list" */
       }
        }

       for(i = 0 ; i < *list ; i++) 
          printf(">>%d<< ilist %d jlist %d \n",i+1,ilist[i],jlist[i]);
}

