/*  

                       Copyright (c) 1990, 1991, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <sys/types.h>
#include <malloc.h>

#ifdef sgi
#include <gl.h>
#include <device.h>
#endif

#include "maxdefs.h"
#include "traja.h"

#define RABS(a)  ( ((a) >= 0.0) ? (a) : -(a))
#define Rabs(a)  ( ((a) >= 0.0) ? (a) : -(a))
#define ROTATE(a,b) rotateO(a,b) /* use own rotation function */
#define TRANSLATE(a,b,c) translateO(a,b,c) /* use own translation function */

#ifdef sgi
#define PICK_READY()     {      getmatrix(xycoor);\
                                 mmode(MPROJECTION);\
                                  getmatrix(RotT);\
                                   multmatrix(xycoor);\
                                  getmatrix(xycoor);\
                                 loadmatrix(RotT);\
                                mmode(MVIEWING);}
#endif  

#define TORSION_JOB(a)   {     if(TorsionRange.Period) {\
                                  if(a < -90.0) a += 360.0;}}

   extern int   check_if_cross();
   extern char *sprint_names();
   extern int TrajectoryLastFrame();
   extern int TrajectoryFirstFrame();
   extern int TrajectoryStepFrame();
   extern int FramesInSet();
   
   extern int yes_no_graph;
   extern int dev,xval,yval;
   extern int *res1;
   extern float HitSphere2; /* square of the "hit sphere" when picking */
   extern float damp;

      extern short val;
      extern long  menuval;
      extern long identmenu;
      extern int numat;
      extern int dev;
      extern int *res1;
      extern int xc,yc;
      extern int text_port;
      extern float xycoor[][4];
      extern float rotB[][4];
      extern float near,far;
      extern float *x,*y,*z;
      extern float pia;
      extern char *atnam;
      extern char *resnam;
      extern char *bottom_line;
      extern char *disp_list;


   extern struct {
   int txcolor[3]; /* text colour , default white */
   char txfont[BUFF_LEN];
   float  txtsize;} txt_param;

/* Define dynamics analyse structure */
   extern struct DynaAnal {
    int observ;                 /* number of observations in this set */
    float *values;              /* pointer to this set */
    char variables[BUFF_LEN];}  /* store the definition of the variable */
                    *DynalAnalWork;
    extern int NumAnalStruct;      /* number of analyse structures defined */
/*                                                   */

   extern int show_text_world();
   extern int atom_list_max();
   extern void PrintMessage();
   extern short line_width;

   extern int current_struct;

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 

/* structure for the dynamics trajectory file */

   extern struct {
    char traj_file[BUFF_LEN];                 /* file name          */
    int natom;                                /* number of atoms    */
    int nstep;                                /* number of steps    */
    int time_bw_steps;                        /* time between steps */
    int time_first_frame;                     /* time of first frame */
    int first_frame;                          /* first frame to be displayed */
    int last_frame;                           /* last frame to be displayed  */
    int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

extern float GetXCoord();
extern float GetYCoord();
extern float GetZCoord();
extern int GetResNum1();
extern char *GetSegName();
extern char *GetResName();
extern char *GetAtmName();
extern int FramesInSet();

       struct GoodStuff {
           int  point_len;  /* length of point array  */
           int *point_vec;
           int  dist_len;   /* length of distance array (in fact 2 times) */
           int *dist_vec;
           int  ang_len;    /* length of angle array (3 times) */
           int *ang_vec;
           int  tors_len;   /* length of torsion array (4 times) */
           int *tors_vec;
           int  cc_len;     /* length of coordinate centre list */
           float *cc_vec;
           int  mc_len;     /* length of mass centre list */
           float *mc_vec;
	 } TrajPropertyList;

         struct {
           int Period;           /* if  = 0 , -180 < angle < 180
                                       != 0 ,  -90 < angle < 270 */
	 } TorsionRange = { 0 };

         int SetTorsPeriod();
         int ShuffleTrajectoryLimits();

/**************************************************************************/
draw_point(point_len,point_vec)

    int point_len,point_vec[];
/**************************************************************************/

{
/* externals      */

    extern float *x,*y,*z;


    int i,j,col_vec[3];
    float vec[3];

    col_vec[0] = 255;
     col_vec[1] = 0;
      col_vec[2] = 255;

#ifdef sgi

    c3i(col_vec);

    bgnpoint();

    for(i = 0 ; i < point_len ; i++ ) {

    j = point_vec[i];
     vec[0] = x[j];
      vec[1] = y[j];
       vec[2] = z[j];
    v3f(vec);}

    endpoint();

#else
   PrintMessage("?ERROR - not implemented ");
#endif 

}
/**************************************************************************/
draw_dist(dist_len,dist_vec)

    int dist_len,*dist_vec;
/**************************************************************************/

{

/* externals      */

    extern float *x,*y,*z;

    int i,j,k,col_vec[3];
    float vec[3];
    float dist_lengt,xpart,ypart,zpart;
    int retv;
    char text[BUFF_LEN];

    col_vec[0] = 255;
     col_vec[1] = 0;
      col_vec[2] = 255;

#ifdef sgi


/* put dotted line on  */
   setlinestyle(3);
/* ..................  */

    for(i = 0 ; i < dist_len ; i = i + 2) {

    c3i(col_vec);

    if(line_width < 2) linewidth(2);
    else
    linewidth(line_width);

    bgnline();

    j = dist_vec[i];
     vec[0] = x[j];
      vec[1] = y[j];
       vec[2] = z[j];
    v3f(vec);

    k = dist_vec[i+1];
     vec[0] = x[k];
      vec[1] = y[k];
       vec[2] = z[k];
    v3f(vec);

    endline();

    linewidth(line_width);
    
 xpart = (x[j]-x[k]);
 ypart = (y[j]-y[k]);
 zpart = (z[j]-z[k]);
 dist_lengt = sqrt(xpart*xpart + ypart*ypart +zpart*zpart);

 sprintf(text,"%.2f",dist_lengt);
/*
 cmov(xpart/2.+x[k] , ypart/2.+y[k] , zpart/2.+z[k]);
 charstr(text);
*/
 retv = show_text_world(text,txt_param.txfont,txt_param.txcolor,
                             txt_param.txtsize,
                        (xpart/2.+x[k]) , 
                        (ypart/2.+y[k]) , 
                        (zpart/2.+z[k]) ,
                        BACKBUFFER);

     }

/* put default line style back */
setlinestyle(0);
/* ........................... */

#else
     PrintMessage("?ERROR - not implemented ");
#endif

}


/**************************************************************************/
draw_ang(ang_len,ang_vec)
   int ang_len,ang_vec[];
/**************************************************************************/

{

/*  externals    */
   extern float pia;
   extern float *x,*y,*z;

   int i,retv;
   int angi,angii,angiii;
   float angle;
   static int ang_col[3] = {255 , 255 , 0};
   float ang_c[9];
   char text[BUFF_LEN];
   float xpart,ypart,zpart;

#ifdef sgi


   for(i = 0 ; i < ang_len ; i = i + 3) {

   c3i(ang_col); /* yellow color on */

    if(line_width < 2) linewidth(2);
    else
    linewidth(line_width);


   bangle(ang_vec[i],ang_vec[i+1],ang_vec[i+2],&angle);
   angle = angle * 180./pia;

   angi = ang_vec[i];
    angii = ang_vec[i+1];
     angiii = ang_vec[i+2];

     bgnline();
      ang_c[0] = x[angi];
       ang_c[1] = y[angi];
        ang_c[2] = z[angi];
      v3f(&ang_c[0]);
      ang_c[3] = x[angii];
       ang_c[4] = y[angii];
        ang_c[5] = z[angii];
      v3f(&ang_c[3]);
      ang_c[6] = x[angiii];
       ang_c[7] = y[angiii];
        ang_c[8] = z[angiii];
      v3f(&ang_c[6]);
     endline();

     linewidth(line_width);

 xpart = (x[angi]-x[angiii]);
 ypart = (y[angi]-y[angiii]);
 zpart = (z[angi]-z[angiii]);

 sprintf(text,"%.2f",angle); 
/*
 cmov(xpart/2.+x[angiii] , ypart/2.+y[angiii] , zpart/2.+z[angiii]);
 charstr(text);
*/
 retv = show_text_world(text,txt_param.txfont,txt_param.txcolor,
                             txt_param.txtsize,
                        xpart/2.+x[angiii] , 
                        ypart/2.+y[angiii] , 
                        zpart/2.+z[angiii],
                        BACKBUFFER);}



#else
    PrintMessage("?ERROR - not implemented ");
#endif

}

/**************************************************************************/
draw_tors(tors_len,tors_vec)

   int tors_len,tors_vec[];
/**************************************************************************/

{

/* externals    */
   extern float *x,*y,*z;

   int i,retv;
   int torsi,torsii,torsiii,torsiv;
   static int ang_col[3] = {0 , 255 , 255};
   extern float pia;
   float angle;
   float tors_c[12];
   float xpart,ypart,zpart;
   char text[BUFF_LEN];

#ifdef sgi


   for(i = 0 ; i < tors_len ; i = i + 4) {

   c3i(ang_col); 

    if(line_width < 2) linewidth(2);
    else
    linewidth(line_width);

   dihed(tors_vec[i],tors_vec[i+1],tors_vec[i+2],tors_vec[i+3],&angle);
   angle = angle * 180./pia;

   torsi = tors_vec[i];
    torsii = tors_vec[i+1];
     torsiii = tors_vec[i+2];
      torsiv = tors_vec[i+3];

   bgnline();
    tors_c[0] = x[torsi];
     tors_c[1] = y[torsi];
      tors_c[2] = z[torsi];
       v3f(&tors_c[0]);
    tors_c[3] = x[torsii];
     tors_c[4] = y[torsii];
      tors_c[5] = z[torsii];
       v3f(&tors_c[3]);
    tors_c[6] = x[torsiii];
     tors_c[7] = y[torsiii];
      tors_c[8] = z[torsiii];
       v3f(&tors_c[6]);
    tors_c[9] = x[torsiv];
     tors_c[10] = y[torsiv];
      tors_c[11] = z[torsiv];
       v3f(&tors_c[9]);
    endline();

    linewidth(line_width);

 xpart = (x[torsii]-x[torsiii]);
 ypart = (y[torsii]-y[torsiii]);
 zpart = (z[torsii]-z[torsiii]);

 sprintf(text,"%.2f",angle); 
/*
 cmov(xpart/2.+x[torsiii] , ypart/2.+y[torsiii] , zpart/2.+z[torsiii]);
 charstr(text);
*/
 retv = show_text_world(text,txt_param.txfont,txt_param.txcolor,
                             txt_param.txtsize,
                        xpart/2.+x[torsiii] , 
                        ypart/2.+y[torsiii] , 
                        zpart/2.+z[torsiii] ,
                        BACKBUFFER);}


#else
    PrintMessage("?ERROR - not implemented ");
#endif

}

/**********************************************************************/
select_point_arr(point_len,point_vec)
       int *point_len;
       int *point_vec;
/**********************************************************************/
{

     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern int *ivector();
     extern float *vector();
     extern int dynamics_frames;
     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern float pia;
     extern int select_list();

     static int i,j,si,sj,loop,atom_max;
     static int *sel_list;
     static int slong;
     char OutText[BUFF_LEN];

     atom_max = atom_list_max();
     sel_list = ivector(atom_max);

     slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

     if(slong > 0 ) {
/*     *dist_len = 0; */
     loop = 0;
     for(i = 0 ; i < slong ; i++ ) {
        si = sel_list[i];
         loop++;
  sprintf(OutText,"Point >%.4s<>%.4s(%d)<>%.4s< ",
         GetSegName(si),GetResName(si),GetResNum1(si),GetAtmName(si));
  PrintMessage(OutText);

         if((*point_len + 1) > MAXdlen) {
         PrintMessage("?ERROR - MAXplen reached in select_point_arr ");
         return;}

         point_vec[*point_len] = si;
         *point_len = *point_len + 1;}

     }
     else
     PrintMessage("?ERROR - no atoms in the selection list ");

     sprintf(OutText,"Selected %d point(s) from the list ",loop);
     PrintMessage(OutText);

     free(sel_list);

}

/**************************************************************************/
build_point_vec(point_len,point_vec,num_obs,obs_vec,numset)

    int point_len,*point_vec;
    int numset;
    int *num_obs;
    float *obs_vec;
/**************************************************************************/

{

/* externals      */

    extern float *x,*y,*z;
    extern float *coordx,*coordy,*coordz;
    extern float sumx,sumy,sumz;
    extern int traj_in_core;
    extern FILE *charmm_oc;
    extern char traj_file[BUFF_LEN];

    static int i,j,k,l,m,ihelp;
    static float vec[3];
    static float dist_lengt,xpart,ypart,zpart;
    static float xpart1,ypart1,zpart1;
    static char text[BUFF_LEN];
    static int retv;
    static int list_loop;
    char OutText[BUFF_LEN];

    *num_obs = 0;
    list_loop = 0;

    PrintMessage("Point analyse facility:");

    switch(traj_in_core) {

    case 1: /* in core */
    ihelp = mliste[0]; /* always first structure */
    for(i = 0 ; i < point_len ; i++) {

    list_loop++;

    j = point_vec[i];

    xpart = 0.0;
     ypart = 0.0;
      zpart = 0.0;

    for(l = 0 ; l < numset ; l++)  {

 xpart += coordx[j + l*ihelp];
  ypart += coordy[j + l*ihelp];
   zpart += coordz[j + l*ihelp];}

    xpart /= ((float)numset);
     ypart /= ((float)numset);
      zpart /= ((float)numset);

    for(l = 0 ; l < numset ; l++)  {

       xpart1 = coordx[j + l*ihelp] - xpart;
        ypart1 = coordy[j + l*ihelp] - ypart;
         zpart1 = coordz[j + l*ihelp] - zpart;

    dist_lengt = sqrt(xpart1*xpart1 + ypart1*ypart1 +zpart1*zpart1);
      
    obs_vec[*num_obs] = dist_lengt;
    (*num_obs)++;}

/*  calc average */
    sprintf(OutText,"Point list: %d",list_loop);
    PrintMessage(OutText);
    calc_vecav(&obs_vec[(*num_obs)-numset],numset,0);
   }

    break;

    case 2: /* out of core */

    charmm_oc = fopen(traj_file,"r");
    if(charmm_oc == NULL) {
    sprintf(OutText,"*** ERROR can't open trajectory file : %s",traj_file);
    PrintMessage(OutText);
    shut_down(1);}

    for(i = 0 ; i < point_len ; i++) {

    list_loop++;

    j = point_vec[i];

    xpart = 0.0;
     ypart = 0.0;
      zpart = 0.0;

    for(l = TrajectoryFirstFrame() - 1; 
        l < TrajectoryLastFrame() ; 
        l +=TrajectoryStepFrame())  {

       mlist_deep     = 0;
       current_struct = 0;

       retv = rtraj_frame(l);
          if(retv < 0) {
            fclose(charmm_oc);
            return;}
       rewind(charmm_oc);

   xpart += x[j];
    ypart += y[j];
     zpart += z[j];}

    xpart /= ((float)numset);
     ypart /= ((float)numset);
      zpart /= ((float)numset);

    for(l = TrajectoryFirstFrame() - 1; 
        l < TrajectoryLastFrame() ; 
        l +=TrajectoryStepFrame())  {

       mlist_deep     = 0;
       current_struct = 0;

       retv = rtraj_frame(l);
          if(retv < 0) {
            fclose(charmm_oc);
            return;}
       rewind(charmm_oc);

       xpart1 = x[j] - xpart;
        ypart1 = y[j] - ypart;
         zpart1 = z[j] - zpart;

    dist_lengt = sqrt(xpart1*xpart1 + ypart1*ypart1 +zpart1*zpart1);
      
    obs_vec[*num_obs] = dist_lengt;
    (*num_obs)++;}

/*  calc average */
    sprintf(OutText,"Point list: %d",list_loop);
    PrintMessage(OutText);
    calc_vecav(&obs_vec[(*num_obs)-numset],numset,0);
    rewind(charmm_oc);}

    fclose(charmm_oc);

    break;}
}



/**************************************************************************/
build_dist_vec(dist_len,dist_vec,num_obs,obs_vec,numset)

    int dist_len,*dist_vec;
    int numset;
    int *num_obs;
    float *obs_vec;
/**************************************************************************/

{

/* externals      */

    extern float *x,*y,*z;
    extern float *coordx,*coordy,*coordz;
    extern float sumx,sumy,sumz;
    extern int traj_in_core;
    extern FILE *charmm_oc;
    extern char traj_file[BUFF_LEN];

    static int i,j,k,l,m,ihelp;
    static float vec[3];
    static float dist_lengt,xpart,ypart,zpart;
    static char text[BUFF_LEN];
    static int retv;
    static int list_loop;
    char OutText[BUFF_LEN];

    *num_obs = 0;
    list_loop = 0;

    PrintMessage("Distance analyse facility:");

    switch(traj_in_core) {

    case 1: /* in core */
    ihelp = mliste[0]; /* always first structure */
    for(i = 0 ; i < dist_len ; i = i + 2) {

    list_loop++;

    j = dist_vec[i];
    k = dist_vec[i+1];

    for(l = 0 ; l < numset ; l++)  {

       for( m = mlists[0] ; m < mliste[0] ; m++) {
       x[m] = coordx[m+l*ihelp] - sumx;
       y[m] = coordy[m+l*ihelp] - sumy;
       z[m] = coordz[m+l*ihelp] - sumz;}

 xpart = (x[j]-x[k]);
  ypart = (y[j]-y[k]);
   zpart = (z[j]-z[k]);
 
    dist_lengt = sqrt(xpart*xpart + ypart*ypart +zpart*zpart);
      
    obs_vec[*num_obs] = dist_lengt;
    (*num_obs)++;}

/*  calc average */
    sprintf(OutText,"Distance list: %d",list_loop);
    PrintMessage(OutText);
    calc_vecav(&obs_vec[(*num_obs)-numset],numset,0);
   }

    break;

    case 2: /* out of core */
    charmm_oc = fopen(traj_file,"r");
    if(charmm_oc == NULL) {
    sprintf(OutText,"*** ERROR can't open trajectory file : %s",traj_file);
    PrintMessage(OutText);
    shut_down(1);}

    for(i = 0 ; i < dist_len ; i = i + 2) {

    list_loop++;

    j = dist_vec[i];
    k = dist_vec[i+1];

    for(l = TrajectoryFirstFrame() - 1 ; 
        l < TrajectoryLastFrame() ; 
        l +=TrajectoryStepFrame())  {

       mlist_deep     = 0;
       current_struct = 0;
       retv = rtraj_frame(l);
          if(retv < 0) {
            fclose(charmm_oc);
            return;}
       rewind(charmm_oc);

       for( m = mlists[0] ; m < mliste[0] ; m++) {
       x[m] = x[m] - sumx;
       y[m] = y[m] - sumy;
       z[m] = z[m] - sumz;}

     xpart = (x[j]-x[k]);
      ypart = (y[j]-y[k]);
       zpart = (z[j]-z[k]);

 dist_lengt = sqrt(xpart*xpart + ypart*ypart + zpart*zpart);
      
    obs_vec[*num_obs] = dist_lengt;
    (*num_obs)++;}

/*  calc average */
    sprintf(OutText,"Distance list: %d",list_loop);
    PrintMessage(OutText);
    calc_vecav(&obs_vec[(*num_obs)-numset],numset,0);
    rewind(charmm_oc);}

    fclose(charmm_oc);

    break;}
}


/**************************************************************************/
build_ang_vec(ang_len,ang_vec,num_obs,obs_vec,numset)
   int ang_len,ang_vec[];
    int *num_obs;
    int numset;
    float *obs_vec;
/**************************************************************************/

{

/*  externals    */
   extern float pia;
   extern float *x,*y,*z;
    extern float *coordx,*coordy,*coordz;
    extern float sumx,sumy,sumz;
    extern int traj_in_core;
    extern FILE *charmm_oc;
    extern char traj_file[BUFF_LEN];

   static int i,l,k;
   static int angi,angii,angiii;
   static float angle;
   static float ang_c[9];
   static char text[BUFF_LEN];
   static float xpart,ypart,zpart;
   static int retv;
   static int ihelp;
   static int list_loop;
   char OutText[BUFF_LEN];

    *num_obs = 0;
    list_loop = 0;

    PrintMessage("Angle analyse facility: ");

    switch(traj_in_core) {

    case 1: /* in core */
    ihelp = mliste[0]; /* always first structure */
    for(i = 0 ; i < ang_len ; i = i + 3) {

    list_loop++;

    for(l = 0 ; l < numset ; l++)  {

       for( k = mlists[0] ; k < mliste[0] ; k++) {
       x[k] = coordx[k+l*ihelp] - sumx;
       y[k] = coordy[k+l*ihelp] - sumy;
       z[k] = coordz[k+l*ihelp] - sumz;}

   bangle(ang_vec[i],ang_vec[i+1],ang_vec[i+2],&angle);
   angle = angle * 180./pia;
    obs_vec[*num_obs] = angle;
    (*num_obs)++;}

/*  calc average */
    sprintf(OutText,"Angle list: %d",list_loop);
    PrintMessage(OutText);
    calc_vecav(&obs_vec[(*num_obs)-numset],numset,1);
    }

    break;

    case 2: /* out of core */
    charmm_oc = fopen(traj_file,"r");
    if(charmm_oc == NULL) {
    sprintf(OutText,"*** ERROR can't open trajectory file : %s",traj_file);
    PrintMessage(OutText);
    shut_down(1);}

    for(i = 0 ; i < ang_len ; i = i + 3) {

    list_loop++;

    for(l = TrajectoryFirstFrame() - 1; 
        l < TrajectoryLastFrame() ; 
        l +=TrajectoryStepFrame())  {

    mlist_deep     = 0;
    current_struct = 0;
    retv = rtraj_frame(l);
          if(retv < 0) {
            fclose(charmm_oc);
            return;}
       rewind(charmm_oc);

       for( k = mlists[0] ; k < mliste[0] ; k++) {
       x[k] = x[k] - sumx;
       y[k] = y[k] - sumy;
       z[k] = z[k] - sumz;}

   bangle(ang_vec[i],ang_vec[i+1],ang_vec[i+2],&angle);
   angle = angle * 180./pia;
    obs_vec[*num_obs] = angle;
    (*num_obs)++;}

/*  calc average */
    sprintf(OutText,"Angle list: %d",list_loop);
    PrintMessage(OutText);
    calc_vecav(&obs_vec[(*num_obs)-numset],numset,1);
    rewind(charmm_oc);}

    fclose(charmm_oc);

    break;}
}

/**************************************************************************/
build_tors_vec(tors_len,tors_vec,num_obs,obs_vec,numset)

   int tors_len,tors_vec[];
   int *num_obs;
   int numset;
   float obs_vec[];
/**************************************************************************/

{

/* externals    */
   extern float *x,*y,*z;
    extern float *coordx,*coordy,*coordz;
    extern float sumx,sumy,sumz;
    extern int traj_in_core;
    extern FILE *charmm_oc;
    extern char traj_file[BUFF_LEN];
    extern float pia;

   static int i,l,k;
   static int torsi,torsii,torsiii,torsiv;
   static float angle;
   static float tors_c[12];
   static float xpart,ypart,zpart;
   static char text[BUFF_LEN];
   static int retv;
   static int ihelp;
   static int list_loop;
   char OutText[BUFF_LEN];

    *num_obs = 0;
    list_loop = 0;

    PrintMessage("Torsion analyse facility:");

    switch(traj_in_core) {

    case 1: /* in core */

    ihelp = mliste[0]; /* always first structure */
    for(i = 0 ; i < tors_len ; i = i + 4) {

    list_loop++;

    for(l = 0 ; l < numset ; l++)  {

       for( k = mlists[0] ; k < mliste[0] ; k++) {
       x[k] = coordx[k+l*ihelp] - sumx;
       y[k] = coordy[k+l*ihelp] - sumy;
       z[k] = coordz[k+l*ihelp] - sumz;}

   dihed(tors_vec[i],tors_vec[i+1],tors_vec[i+2],tors_vec[i+3],&angle);
   angle = angle * 180./pia;
    TORSION_JOB(angle);
    obs_vec[*num_obs] = angle;
    (*num_obs)++;}

/*  calc average */
    sprintf(OutText,"Torsion list: %d",list_loop);
    PrintMessage(OutText);
    calc_vecav(&obs_vec[(*num_obs)-numset],numset,1);
   }

   break;

    case 2: /* out of core */

    charmm_oc = fopen(traj_file,"r");
    if(charmm_oc == NULL) {
    sprintf(OutText,"*** ERROR can't open trajectory file : %s",traj_file);
    PrintMessage(OutText);
    shut_down(1);}

    for(i = 0 ; i < tors_len ; i = i + 4) {

    list_loop++;

    for(l = TrajectoryFirstFrame() - 1 ; 
        l < TrajectoryLastFrame() ; 
        l +=TrajectoryStepFrame()) {

    mlist_deep     = 0;
    current_struct = 0;
    retv = rtraj_frame(l);
          if(retv < 0) {
            fclose(charmm_oc);
            return;}
       rewind(charmm_oc);

       for( k = mlists[0] ; k < mliste[0] ; k++) {
       x[k] = x[k] - sumx;
       y[k] = y[k] - sumy;
       z[k] = z[k] - sumz;}

   dihed(tors_vec[i],tors_vec[i+1],tors_vec[i+2],tors_vec[i+3],&angle);
   angle = angle * 180./pia;
    TORSION_JOB(angle);
    obs_vec[*num_obs] = angle;
    (*num_obs)++;}

/*  calc average */
    sprintf(OutText,"Torsion list: %d",list_loop);
    PrintMessage(OutText);
    calc_vecav(&obs_vec[(*num_obs)-numset],numset,1);
    rewind(charmm_oc);}

    fclose(charmm_oc);

    break;}

}
/**************************************************************************/
build_eng_vec(alt,num_obs,obs_vec,numset)

   int alt;
   int *num_obs;
   int numset;
   float *obs_vec;
/**************************************************************************/
{

   extern struct et {
   int step_nr;
   float time_in_fs;
   float tote;
   float kine;
   float pote;
   float temp;
   float bond;
   float angl;
   float dihe;
   float impr;
   float vdw;
   float elec;
   float hbond;
   float charm; };

 extern  struct et *traj_energy;
 extern  int et_count;

 int i;

 *num_obs = 0;

 if(et_count != numset)  {
 printf("\07\07\n");
 PrintMessage("?ERROR - et_count != numset");
 return;}

 for(i = 0 ; i < et_count ; i++) {
 switch(alt) {

 case 1: /* total energy */
 obs_vec[*num_obs] = traj_energy[i].tote;
 (*num_obs)++;

 break;
 case 2: /* kinetic energy */
 obs_vec[*num_obs] = traj_energy[i].kine;
 (*num_obs)++;

 break;
 case 3: /* potential energy */
 obs_vec[*num_obs] = traj_energy[i].pote;
 (*num_obs)++;

 break;
 case 4: /* temperature */
 obs_vec[*num_obs] = traj_energy[i].temp;
 (*num_obs)++;

 break;

 case 5: /* bond */
 obs_vec[*num_obs] = traj_energy[i].bond;
 (*num_obs)++;

 break;

 case 6: /* angle */
 obs_vec[*num_obs] = traj_energy[i].angl;
 (*num_obs)++;

 break;

 case 7: /* dihe */
 obs_vec[*num_obs] = traj_energy[i].dihe;
 (*num_obs)++;

 break;

 case 8: /* impr */
 obs_vec[*num_obs] = traj_energy[i].impr;
 (*num_obs)++;

 break;

 case 9: /* vdw */
 obs_vec[*num_obs] = traj_energy[i].vdw;
 (*num_obs)++;

 break;

 case 10: /* elec */
 obs_vec[*num_obs] = traj_energy[i].elec;
 (*num_obs)++;

 break;

 case 11: /* hbond */
 obs_vec[*num_obs] = traj_energy[i].elec;
 (*num_obs)++;

 break;
 }}

    switch(alt) {
    case 1: PrintMessage("Total energy analyse facility:");
            break;
    case 2: PrintMessage("Kinetic energy analyse facility:");
            break;
    case 3: PrintMessage("Potential energy analyse facility:");
            break;
    case 4: PrintMessage("Temperature analyse facility:");
            break;
    case 5: PrintMessage("Bond energy analyse facility:");
            break;
    case 6: PrintMessage("Angle energy analyse facility:");
            break;
    case 7: PrintMessage("Dihedral energy analyse facility:");
            break;
    case 8: PrintMessage("Improper energy analyse facility:");
            break;
    case 9: PrintMessage("Van der Waals energy analyse facility:");
            break;
    case 10: PrintMessage("Electronic energy analyse facility:");
            break;
    case 11: PrintMessage("Hydrogen bond energy analyse facility:");
            break;
    }

/*  calc average */
    calc_vecav(&obs_vec[(*num_obs)-numset],numset,0);

}
/**************************************************************************/
calc_vecav(vec_list,numbers,alt)  /* calc average for the list */

      float *vec_list;    /* list of values */
      int numbers;        /* number of elements in the list */
      int alt;            /* if = 0 normal list if > 0 it's an angle list */
/**************************************************************************/
{
      extern float pia;

      register int i;
      register float vec_sum,devi;
      static   float vmin,vmax;
      static   float veci,pia2;
      static   int imin,imax;
      static   float vecx,vecy,vecxi,vecyi,vecxii,vecyii,vec_swap;
      static   float d2ij,d2,d2jk,d2ik;
      static   int swap_flag;
      char OutText[BUFF_LEN];

      pia2 = pia / 180.0;
      vmin =   1.e+20;
      vmax =      0.0;
      imin = -1;
      imax = -1;

      vecx = 0.0;
       vecy = 0.0;

      vec_sum=0.0;
      devi=0.0;
      swap_flag = 0;

      switch(alt) {

      case 0:
      for(i=0;i<numbers;i++) vec_sum += vec_list[i];
       vec_sum = vec_sum / (float)numbers;
      break;

      default:

      for(i=0;i<numbers;i++) {
       veci = vec_list[i];
       devi = veci * pia2;
       vecx += cos((double)devi);
       vecy += sin((double)devi);
        }
      vecx /= (float)numbers;
      vecy /= (float)numbers;

      vec_sum = asin((double)(vecy / sqrt(vecx*vecx + vecy*vecy))) / pia * 180.0;
      swap_flag = 0;
      if(vecx < 0.0) {
        vec_sum = 180.0 - vec_sum;
               if(vec_sum > 180.0) swap_flag = 1;} 
      break;
      }

      devi = 0.0;

      switch(alt) {

      case 0:
       for(i=0;i<numbers;i++)  {
        veci = vec_list[i] - vec_sum;
        devi += veci * veci;
               if(RABS(veci) < RABS(vmin)) {
                                     vmin = veci;
                                     imin = i + 1;}

               if(RABS(veci) > RABS(vmax)) {
                                     vmax = veci;
                                     imax = i + 1;}
      }
      break;

      default:
       devi = 0.0;
       d2ij = vecx*vecx + vecy*vecy;
       for(i = 0 ; i < numbers ; i++)  {
        veci = vec_list[i] * pia2;
        vecxii=cos((double)veci);
        vecyii=sin((double)veci);
       d2jk = vecxii*vecxii + vecyii*vecyii; 
       vecxi = vecx - vecxii;
        vecyi = vecy - vecyii;
       d2ik = vecxi*vecxi + vecyi*vecyi;
         veci = 0.5 *(d2ij + d2jk - d2ik) / sqrt(d2ij*d2jk);
         veci = (veci >  1.0 ?  1.0 : veci);
         veci = (veci < -1.0 ? -1.0 : veci);
         veci = acos((double)veci) / pia * 180.0;

           devi += veci * veci;
   
               if(RABS(veci) < RABS(vmin)) {
                                     vmin = veci;
                                     imin = i + 1;}

               if(RABS(veci) > RABS(vmax)) {
                                     vmax = veci;
                                     imax = i + 1;}
       }
       break;}

      if(swap_flag) vec_sum = vec_sum - 360.0;

      if(numbers > 1)
      devi = devi /(float)(numbers-1);

      devi = sqrt(devi);

      sprintf(OutText,"Av. value , max. diff.  (entry nr '%d') , min. diff.  \
(entry nr '%d') , st. dev.",imax,imin);
      PrintMessage(OutText);
      sprintf(OutText," %f     %f                 %f                 %f ",vec_sum,vmax,vmin,devi);
      PrintMessage(OutText);

}

/**********************************************************************/
select_dist_arr(dist_len,dist_vec)
       int *dist_len;
       int *dist_vec;
/**********************************************************************/
{

     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern int *ivector();
     extern float *vector();
     extern int dynamics_frames;
     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern float pia;
     extern int select_list();

     static int i,j,si,sj,loop;
     static int *sel_list1;
     static int slong1;
     static int *sel_list2;
     static int slong2,atom_max;
     static float dist,tmp1,tmp2,tmp3;
     static int cross;
     char OutText[BUFF_LEN];
     char TAtm[MAX_ATM_NAME_LEN];
     char TRes[MAX_RES_NAME_LEN];
     char TSeg[MAX_SEG_NAME_LEN];

     atom_max = atom_list_max();
     sel_list1 = ivector(atom_max);
     sel_list2 = ivector(atom_max);

     slong1 = select_list(parsed[3],parsed[4],parsed[5],sel_list1);
     slong2 = select_list(parsed[6],parsed[7],parsed[8],sel_list2);

     if(slong1 > 0 && slong2 > 0) {

     cross = check_if_cross(parsed[9]);

/*     *dist_len = 0; */
     loop = 0;
     for(i = 0 ; i < slong1 ; i++ ) {
        si = sel_list1[i];
        for(j = 0 ; j < slong2 ; j++) {
           sj = sel_list2[j];

       if(cross) {
                 if(res1[si] != res1[sj]) continue;}

         loop++;
                tmp1 = (x[si]-x[sj]);
                tmp2 = (y[si]-y[sj]);
                tmp3 = (z[si]-z[sj]);

  dist = sqrt( tmp1 * tmp1 + tmp2 * tmp2 + tmp3 * tmp3);

    strncpy(TAtm,GetAtmName(si),MAX_ATM_NAME_LEN);
    strncpy(TRes,GetResName(si),MAX_RES_NAME_LEN);
    strncpy(TSeg,GetSegName(si),MAX_SEG_NAME_LEN);

  sprintf(OutText,"Distance >%.4s<>%.4s(%d)<>%.4s<  -  >%.4s<>%.4s(%d)<>%.4s<",
         TSeg,TRes,GetResNum1(si),TAtm,
         GetSegName(sj),GetResName(sj),GetResNum1(sj),GetAtmName(sj));
         PrintMessage(OutText);
  sprintf(OutText," %f ",dist);
         PrintMessage(OutText);

         if((*dist_len + 2) > MAXdlen) {
         PrintMessage("?ERROR - MAXdlen reached in pre_dist_arr ");
         return;}

         dist_vec[*dist_len] = si;
         dist_vec[*dist_len + 1] = sj;
         *dist_len = *dist_len + 2;}

     }}
     else
     PrintMessage("?ERROR - no atoms in the selection list 1 or 2 ");

     sprintf(OutText,"Selected %d distance(s) from the list ",loop);
     PrintMessage(OutText);

     free(sel_list1);
     free(sel_list2);

}

/**********************************************************************/
select_ang_arr(dist_len,dist_vec)
       int *dist_len;
       int *dist_vec;
/**********************************************************************/
{

     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern int *ivector();
     extern float *vector();
     extern int dynamics_frames;
     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern float pia;
     extern int select_list();

     static int i,j,k,si,sj,sk,loop,atom_max;
     static int *sel_list1;
     static slong1;
     static int *sel_list2;
     static slong2;
     static int *sel_list3;
     static slong3;
     static float angle;
     static int cross;
     char OutText[BUFF_LEN];
     char TAtm[MAX_ATM_NAME_LEN];
     char TRes[MAX_RES_NAME_LEN];
     char TSeg[MAX_SEG_NAME_LEN];
     char TAtm1[MAX_ATM_NAME_LEN];
     char TRes1[MAX_RES_NAME_LEN];
     char TSeg1[MAX_SEG_NAME_LEN];

     atom_max = atom_list_max();
     sel_list1 = ivector(atom_max);
     sel_list2 = ivector(atom_max);
     sel_list3 = ivector(atom_max);

     slong1 = select_list(parsed[3],parsed[4],parsed[5],sel_list1);
     slong2 = select_list(parsed[6],parsed[7],parsed[8],sel_list2);
     slong3 = select_list(parsed[9],parsed[10],parsed[11],sel_list3);

     if(slong1 > 0 && slong2 > 0 && slong3 > 0) {

     cross = check_if_cross(parsed[12]);

/*     *dist_len = 0; */
     loop = 0;
     for(i = 0 ; i < slong1 ; i++ ) {
        si = sel_list1[i];
        for(j = 0 ; j < slong2 ; j++) {
           sj = sel_list2[j];
         for(k = 0 ; k < slong3 ; k++) {
            sk = sel_list3[k];

          if(cross) {
                    if(res1[si] != res1[sj] ||
                       res1[si] != res1[sk] || 
                       res1[sj] != res1[sk]) continue;}

         loop++;
bangle(si,sj,sk,&angle);

    strncpy(TAtm,GetAtmName(si),MAX_ATM_NAME_LEN);
    strncpy(TRes,GetResName(si),MAX_RES_NAME_LEN);
    strncpy(TSeg,GetSegName(si),MAX_SEG_NAME_LEN);

    strncpy(TAtm1,GetAtmName(sj),MAX_ATM_NAME_LEN);
    strncpy(TRes1,GetResName(sj),MAX_RES_NAME_LEN);
    strncpy(TSeg1,GetSegName(sj),MAX_SEG_NAME_LEN);

sprintf(OutText,"Angle >%.4s<>%.4s(%d)<>%.4s<->%.4s<>%.4s(%d)<>%.4s<->%.4s<>%.4s(%d)<>%.4s<",
         TSeg ,TRes ,GetResNum1(si),TAtm,
         TSeg1,TRes1,GetResNum1(sj),TAtm1,
         GetSegName(sk),GetResName(sk),GetResNum1(sk),GetAtmName(sk));
         PrintMessage(OutText);

  sprintf(OutText," %f ",180.*angle/pia);
         PrintMessage(OutText);

         if((*dist_len  + 3) > MAXalen) {
         PrintMessage("?ERROR - MAXalen reached in pre_dist_arr");
         return;}

         dist_vec[*dist_len] = si;
         dist_vec[*dist_len + 1] = sj;
         dist_vec[*dist_len + 2] = sk;
         *dist_len = *dist_len + 3;}

     }}}
     else
     PrintMessage("?ERROR - no atoms in selection list 1,2 or 3"); 

     sprintf(OutText,"Selected %d angle(s) from the list ",loop);
     PrintMessage(OutText);

     free(sel_list1);
     free(sel_list2);
     free(sel_list3);

}

/**********************************************************************/
select_tors_arr(dist_len,dist_vec)
       int *dist_len;
       int *dist_vec;
/**********************************************************************/
{

     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern int *ivector();
     extern float *vector();
     extern int dynamics_frames;
     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern float pia;

     static int i,j,k,l,si,sj,sk,sl,loop,atom_max;
     static int *sel_list1;
     static int slong1;
     static int *sel_list2;
     static int slong2;
     static int *sel_list3;
     static int slong3;
     static int *sel_list4;
     static int slong4;
     static float angle;
     static int cross;
     char OutText[BUFF_LEN];
     char TAtm[MAX_ATM_NAME_LEN];
     char TRes[MAX_RES_NAME_LEN];
     char TSeg[MAX_SEG_NAME_LEN];
     char TAtm1[MAX_ATM_NAME_LEN];
     char TRes1[MAX_RES_NAME_LEN];
     char TSeg1[MAX_SEG_NAME_LEN];
     char TAtm2[MAX_ATM_NAME_LEN];
     char TRes2[MAX_RES_NAME_LEN];
     char TSeg2[MAX_SEG_NAME_LEN];

     atom_max = atom_list_max();

     sel_list1 = ivector(atom_max);
     sel_list2 = ivector(atom_max);
     sel_list3 = ivector(atom_max);
     sel_list4 = ivector(atom_max);

     slong1 = select_list(parsed[3],parsed[4],parsed[5],sel_list1);
     slong2 = select_list(parsed[6],parsed[7],parsed[8],sel_list2);
     slong3 = select_list(parsed[9],parsed[10],parsed[11],sel_list3);
     slong4 = select_list(parsed[12],parsed[13],parsed[14],sel_list4);

     if(slong1 > 0 && slong2 > 0 && slong3 > 0 && slong4 > 0) {

     cross = check_if_cross(parsed[15]);

/*     *dist_len = 0; */
     loop = 0;
     for(i = 0 ; i < slong1 ; i++ ) {
        si = sel_list1[i];
        for(j = 0 ; j < slong2 ; j++) {
           sj = sel_list2[j];
           for(k = 0 ; k < slong3 ; k++) {
              sk = sel_list3[k];
              for(l = 0 ; l < slong4 ; l++) {
                 sl = sel_list4[l];

         if(cross) {
                   if(res1[si] != res1[sj] || 
                      res1[si] != res1[sk] || 
                      res1[si] != res1[sl] || 
                      res1[sj] != res1[sk] ||
                      res1[sj] != res1[sl] || 
                      res1[sk] != res1[sl]) continue;}

         loop++;
dihed(si,sj,sk,sl,&angle);
    strncpy(TAtm,GetAtmName(si),MAX_ATM_NAME_LEN);
    strncpy(TRes,GetResName(si),MAX_RES_NAME_LEN);
    strncpy(TSeg,GetSegName(si),MAX_SEG_NAME_LEN);

    strncpy(TAtm1,GetAtmName(sj),MAX_ATM_NAME_LEN);
    strncpy(TRes1,GetResName(sj),MAX_RES_NAME_LEN);
    strncpy(TSeg1,GetSegName(sj),MAX_SEG_NAME_LEN);

    strncpy(TAtm2,GetAtmName(sk),MAX_ATM_NAME_LEN);
    strncpy(TRes2,GetResName(sk),MAX_RES_NAME_LEN);
    strncpy(TSeg2,GetSegName(sk),MAX_SEG_NAME_LEN);

sprintf(OutText,"Torsion >%.4s<>%.4s(%d)<>%.4s<->%.4s<>%.4s(%d)<>%.4s<->%.4s<>%.4s(%d)<>%.4s<->%.4s<>%.4s(%d)<>%.4s<",
         TSeg ,TRes ,GetResNum1(si),TAtm,
         TSeg1,TRes1,GetResNum1(sj),TAtm1,
         TSeg2,TRes2,GetResNum1(sk),TAtm2,
         GetSegName(sl),GetResName(sl),GetResNum1(sl),GetAtmName(sl));
         PrintMessage(OutText);

         sprintf(OutText," %f ",180.*angle/pia);
         PrintMessage(OutText);


         if((*dist_len + 4) > MAXtlen) {
         PrintMessage("?ERROR - MAXtlen reached in pre_dist_arr ");
         return;}

         dist_vec[*dist_len] = si;
         dist_vec[*dist_len + 1] = sj;
         dist_vec[*dist_len + 2] = sk;
         dist_vec[*dist_len + 3] = sl;
         *dist_len = *dist_len + 4;}

     }}}}
     else
     PrintMessage("?ERROR - no atoms in the selection list 1,2,3 or 4 ");

     sprintf(OutText,"Selected %d torsion angle(s) from the list ",loop);
     PrintMessage(OutText);

     free(sel_list1);
     free(sel_list2);
     free(sel_list3);
     free(sel_list4);

 }
 
/**************************************************************************/
write_ang_vec(ang_len,ang_vec)
      int ang_len;
      int *ang_vec;
/**************************************************************************/
{
      int i,j;
      char OutText[BUFF_LEN];
      char Text1[BUFF_LEN],Text2[BUFF_LEN],Text3[BUFF_LEN];

      if(ang_len < 1) {
        PrintMessage("?ERROR - angle list is empty ");
         return;}

      j = 1;
      for(i = 0 ; i < ang_len ; i = i + 3) {
         strncpy(Text1,sprint_names(ang_vec[i]),BUFF_LEN);
         strncpy(Text2,sprint_names(ang_vec[i + 1]),BUFF_LEN);
         strncpy(Text3,sprint_names(ang_vec[i + 2]),BUFF_LEN);
         sprintf(OutText,"Nr: (%d) %s-%s-%s",j,
                                          Text1,
                                          Text2,
                                          Text3);
         PrintMessage(OutText);
         j++;}
} 
/**************************************************************************/
write_dist_vec(dist_len,dist_vec)
      int dist_len;
      int *dist_vec;
/**************************************************************************/
{
     int i,j;
     char OutText[BUFF_LEN];
     char Text1[BUFF_LEN],Text2[BUFF_LEN];

     if(dist_len < 1) {
       PrintMessage("?ERROR - distance list is empty");
        return;}

     j=1;
     for(i = 0 ; i < dist_len ; i = i + 2) {
        strncpy(Text1,sprint_names(dist_vec[i]),BUFF_LEN);
        strncpy(Text2,sprint_names(dist_vec[i + 1]),BUFF_LEN);

        sprintf(OutText,"Nr: (%d) %s-%s",j,
                                  Text1,
                                  Text2);
        PrintMessage(OutText);
        j++;}
}
/**************************************************************************/
write_tors_vec(tors_len,tors_vec)
      int tors_len;
      int *tors_vec;
/**************************************************************************/
{
     int i,j;
     char OutText[BUFF_LEN];
     char Text1[BUFF_LEN],Text2[BUFF_LEN],Text3[BUFF_LEN],Text4[BUFF_LEN];


     if(tors_len < 1) {
       PrintMessage("?ERROR - torsion list is empty");
        return;}

     j=1;
     for(i = 0 ; i < tors_len ; i = i + 4) {
        strncpy(Text1,sprint_names(tors_vec[i]),BUFF_LEN);
        strncpy(Text2,sprint_names(tors_vec[i + 1]),BUFF_LEN);
        strncpy(Text3,sprint_names(tors_vec[i + 2]),BUFF_LEN);
        strncpy(Text4,sprint_names(tors_vec[i + 3]),BUFF_LEN);

        sprintf(OutText,"Nr: (%d) %s-%s-%s-%s",j,
                                    Text1,
                                    Text2,
                                    Text3,
                                    Text4);
        PrintMessage(OutText);
        j++;}
} 

/*  build up the distance array to be analyzed with the dynamics trajectory */
/***********************************************************************/
dist_arr(dist_len,dist_vec)

    int *dist_len,*dist_vec;
/***********************************************************************/
{
      extern int *atm_type;
      extern float *atm_charge;

     register int oldx,oldy;
     register short dx,dy;

      static int xsiz,ysiz,xo,yo,i,j;
      static int DisplayFlag;
      static int pick_p,pick_num,repeat;
      static float xx,yy,xtr,ytr,dist;
      static float ddx,ddy,ddz,tmp1,tmp2;
      float diffs;
      char text[BUFF_LEN];
      float RotT[4][4];

#ifdef sgi

      switch(yes_no_graph) {

      case 0: /* graphics is turned off */
              select_dist_arr(dist_len,dist_vec);
              break;

      case 1: /* pick your selection list with mouse */

      diffs = far - near;

      PICK_READY();
  
      PrintMessage(" >>>>>> PRESS e-key to return from DISTANCE facility <<<<<< \n");

      text_port = 1;  /* display text from now */

      strncpy(bottom_line,"Pick two atoms for a distance",PORTchar);

      going_on();

      *dist_len = 0;

      pick_p=0;   /* reset the pick */
      repeat = mliste[mlist_deep - 1] + 1;

      while(1) {

      DisplayFlag = 0;

        while(qtest()) {

          dev=qread(&val);

          switch(dev) {              /* main switch board */

                      case ESCKEY:
                        shut_down(0); 

		      case EKEY: 
                        qreset();
                        text_port = 0;
                        return; 

		      case REDRAW:
                        DisplayFlag = 1;
                        reshapeviewport();
                        break;

		      case MENUBUTTON:
                       { menuval = dopup(identmenu);
                           switch( menuval) {
                           case 1:
                           text_port = 0;
                            qreset();
                           return;break;
                           case 2:
                           shut_down(0);
                           case 3:
                           if(text_port ==0) text_port = 1;
                           else
                           text_port =0;
                           DisplayFlag = 1;
                           break;}}
                        break;

/* track MOUSEX                         */
		      case MOUSEX:
                        oldx=xval;
                         xval=val;
                          dx= oldx-xval;
                      
                       if(getbutton(LEFTMOUSE)) {
                        if(getbutton(MIDDLEMOUSE)) {
                        ddx=Rabs((float) xval/((float) oldx));
                        DisplayFlag = 0;
                        scale(ddx , ddx , ddx);
                        qreset();
                        bang_it(); break;}

                        if(getbutton(PAD2)) {
                        DisplayFlag = 0;
                          qreset();
                          TRANSLATE( 0.0 , 0.0 , (((float)dx) * damp) );
                           bang_it(); break;}

                        if(getbutton(PAD8)) {
                        DisplayFlag = 0;
                           qreset();
                           TRANSLATE( 0.0 , (((float)dx) * damp) , 0.0 );
                            bang_it(); break;}

                        if(getbutton(PAD6)) {
                        DisplayFlag = 0;
                            qreset();
                            TRANSLATE( (((float)dx) * damp) , 0.0 , 0.0);
                             bang_it(); break;}

                          ROTATE( -dx ,'y');
                           DisplayFlag = 1;}

                        if(getbutton(MIDDLEMOUSE)) {
                          ROTATE( dx , 'z');
                           DisplayFlag = 1;}
                       break;

/* track MOUSEY                         */
		      case MOUSEY:
                        oldy=yval;
                         yval=val;
                          dy= oldy-yval;

                        if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
                         ddy=Rabs((float) yval/((float) oldy));
                         DisplayFlag = 0;
                         scale(ddy , ddy , ddy);
                         qreset();
                         bang_it(); break;}

		         if(getbutton(LEFTMOUSE)) {
                           ROTATE(  dy ,'x');
                            DisplayFlag = 1;}

		         if(getbutton(MIDDLEMOUSE)) {
                           ROTATE( dy , 'z');
                            DisplayFlag = 1;}
                       break;

		    case LEFTMOUSE:
                       { if(!val) break;
                          xc=getvaluator(MOUSEX);
                          yc=getvaluator(MOUSEY);
            
                          getmatrix(xycoor);
                           mmode(MPROJECTION); 
                            getmatrix(RotT);
                             multmatrix(xycoor);
                            getmatrix(xycoor);
                           loadmatrix(RotT);
                           mmode(MVIEWING);

                         /* Reset queue                              */
                          qreset();

                          getsize(&xsiz,&ysiz);
                          getorigin(&xo,&yo);

            xx=near + diffs*((float)(xc+1-xo)/ (float) xsiz);
            yy=near + diffs*((float)(yc+1-yo)/ (float) ysiz);


            for( j = 0 ; j < mlist_deep ; j++) {
            for( i = mlists[j] ; i < mliste[j] ; i++) {
    
/* don't count undisplayed atoms (disp_list[i] = 0)      */
            if(disp_list[i] == 0) continue;

     xtr= 0.5 * diffs * (xycoor[0][0]*x[i]+xycoor[1][0]*y[i]+
          xycoor[2][0]*z[i]+xycoor[3][0]-rotB[3][0]);
     ytr= 0.5 * diffs * (xycoor[0][1]*x[i]+xycoor[1][1]*y[i]+
          xycoor[2][1]*z[i]+xycoor[3][1]-rotB[3][1]);

           tmp1 = (xx-xtr);
           tmp2 = (yy-ytr);

             if((tmp1 * tmp1 + tmp2 * tmp2) < HitSphere2 ) {

             if( i == repeat) break;
             repeat = i;
             sprintf(text," (%d:%.4s:%.4s) \007\n",i+1,atnam+4*i,resnam+(4*i));
             PrintMessage(text);

             DisplayFlag = 1;

             if(!pick_p) { pick_num=i ; pick_p++ ; goto PickExit;}

             dist = sqrt((x[pick_num]-x[i])*(x[pick_num]-x[i]) +
                         (y[pick_num]-y[i])*(y[pick_num]-y[i]) +
                         (z[pick_num]-z[i])*(z[pick_num]-z[i]));

             sprintf(text,"\n Distance %d_%.4s:%.4s- %d_%.4s:%.4s = %f \n\n",
                                                        res1[pick_num],
                                                      atnam+4*pick_num,
                                                     resnam+4*pick_num,
                                                               res1[i],
                                                             atnam+4*i,
                                                            resnam+4*i,
                                                                 dist);

             PrintMessage(text);

/* fill distance vector  */

            if((*dist_len + 2) >= MAXdlen) {
            printf("\07\07\n");
            PrintMessage(" ****** ERROR too many distances defined ***** ");
            return;}

            dist_vec[*dist_len] = pick_num;
            dist_vec[(*dist_len)+1] = i;
            *dist_len = (*dist_len) + 2;

             pick_p=0; qreset(); break;

	   }}}
PickExit:;
		       }
            break;
		      }
	  } 
            if(DisplayFlag) {
              DisplayFlag = 0;
              bang_it();}
    }

    }
#else
              select_dist_arr(dist_len,dist_vec);
#endif
}



/***********************************************************************/
ang_arr(ang_len,ang_vec)

       int *ang_len,ang_vec[];
/***********************************************************************/
{
      extern int *atm_type;
      extern float *atm_charge;

     register int oldx,oldy;
     register short dx,dy;

      static int xsiz,ysiz,xo,yo,i,j;
      static int DisplayFlag;
      static int pick_p,pick_num[2],repeat;
      static float xx,yy,xtr,ytr,angle;
      static float ddx,ddy,ddz,tmp1,tmp2;
      float diffs;
      char text[BUFF_LEN];
      float RotT[4][4];

#ifdef sgi

      switch(yes_no_graph) {

      case 0: /* graphics is turned off */
              select_ang_arr(ang_len,ang_vec);
              break;

      case 1: /* pick your selection list with mouse */


      *ang_len = 0;

      diffs = far - near;

      PICK_READY();
  
      PrintMessage(" >>>>>> PRESS e-key to return from ANGLE facility <<<<<< \n");

      text_port = 1;  /* display text from now */

      strncpy(bottom_line,"Pick three atoms for an angle",PORTchar);

      going_on();

      pick_p=0;   /* reset the pick */
      repeat = mliste[mlist_deep - 1] + 1;

      while(1) {

      DisplayFlag = 0;

        while(qtest()) {

          dev=qread(&val);

          switch(dev) {              /* main switch board */

                      case ESCKEY:
                        shut_down(0); 

		      case EKEY: 
                        qreset();
                        text_port = 0;
                        return; 

		      case REDRAW:
                        DisplayFlag = 1;
                        reshapeviewport();
                        break;

		      case MENUBUTTON:
                       { menuval = dopup(identmenu);
                           switch( menuval) {
                           case 1:
                           text_port = 0;
                            qreset();
                           return;break;
                           case 2:
                           shut_down(0);
                           case 3:
                           if(text_port ==0) text_port = 1;
                           else
                           text_port =0;
                           DisplayFlag = 1;
                           break;}}
                        break;

/* track MOUSEX                         */
		      case MOUSEX:
                        oldx=xval;
                         xval=val;
                          dx= oldx-xval;
                      
                       if(getbutton(LEFTMOUSE)) {
                        if(getbutton(MIDDLEMOUSE)) {
                        ddx=Rabs((float) xval/((float) oldx));
                        DisplayFlag = 0;
                        scale(ddx , ddx , ddx);
                        qreset();
                        bang_it(); break;}

                        if(getbutton(PAD2)) {
                        DisplayFlag = 0;
                          qreset();
                          TRANSLATE( 0.0 , 0.0 , (((float)dx) * damp) );
                           bang_it(); break;}

                        if(getbutton(PAD8)) {
                        DisplayFlag = 0;
                           qreset();
                           TRANSLATE( 0.0 , (((float)dx) * damp) , 0.0 );
                            bang_it(); break;}

                        if(getbutton(PAD6)) {
                        DisplayFlag = 0;
                            qreset();
                            TRANSLATE( (((float)dx) * damp) , 0.0 , 0.0);
                             bang_it(); break;}

                          ROTATE( -dx ,'y');
                           DisplayFlag = 1;}

                        if(getbutton(MIDDLEMOUSE)) {
                          ROTATE( dx , 'z');
                           DisplayFlag = 1;}
                       break;

/* track MOUSEY                         */
		      case MOUSEY:
                        oldy=yval;
                         yval=val;
                          dy= oldy-yval;

                        if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
                         ddy=Rabs((float) yval/((float) oldy));
                         DisplayFlag = 0;
                         scale(ddy , ddy , ddy);
                         qreset();
                         bang_it(); break;}

		         if(getbutton(LEFTMOUSE)) {
                           ROTATE(  dy ,'x');
                            DisplayFlag = 1;}

		         if(getbutton(MIDDLEMOUSE)) {
                           ROTATE( dy , 'z');
                            DisplayFlag = 1;}
                       break;

		    case LEFTMOUSE:
                       { if(!val) break;
                          xc=getvaluator(MOUSEX);
                          yc=getvaluator(MOUSEY);
            
                          getmatrix(xycoor);
                           mmode(MPROJECTION); 
                            getmatrix(RotT);
                             multmatrix(xycoor);
                            getmatrix(xycoor);
                           loadmatrix(RotT);
                           mmode(MVIEWING);

                         /* Reset queue                              */
                          qreset();

                          getsize(&xsiz,&ysiz);
                          getorigin(&xo,&yo);

            xx=near + diffs*((float)(xc+1-xo)/ (float) xsiz);
            yy=near + diffs*((float)(yc+1-yo)/ (float) ysiz);


            for( j = 0 ; j < mlist_deep ; j++) {
            for( i = mlists[j] ; i < mliste[j] ; i++) {
    
/* don't count undisplayed atoms (disp_list[i] = 0)      */
            if(disp_list[i] == 0) continue;



     xtr= 0.5 * diffs * (xycoor[0][0]*x[i]+xycoor[1][0]*y[i]+
          xycoor[2][0]*z[i]+xycoor[3][0]-rotB[3][0]);
     ytr= 0.5 * diffs * (xycoor[0][1]*x[i]+xycoor[1][1]*y[i]+
          xycoor[2][1]*z[i]+xycoor[3][1]-rotB[3][1]);

           tmp1 = (xx-xtr);
           tmp2 = (yy-ytr);

             if((tmp1 * tmp1 + tmp2 * tmp2) < HitSphere2 ) {

             if( i == repeat) break;
             repeat = i;
             sprintf(text," (%d:%.4s:%.4s) \007\n",i+1,atnam+4*i,resnam+(4*i));
             PrintMessage(text);

             DisplayFlag = 1;

             if(pick_p < 2 ) {pick_num[pick_p]=i ; pick_p++ ; goto PickExit;}

             bangle(pick_num[0],pick_num[1],i,&angle);

/*  in degrees */
             angle = angle*180.0/pia;

sprintf(text,"\n Angle %d_:%.4s:%.4s- %d_:%.4s:%.4s- %d_:%.4s:%.4s = %f \n\n",
                                                           pick_num[0]+1,
                                                     atnam+4*pick_num[0],
                                                    resnam+4*pick_num[0],
                                                           pick_num[1]+1,
                                                     atnam+4*pick_num[1],
                                                    resnam+4*pick_num[1],
                                                                     i+1,
                                                               atnam+4*i,
                                                       resnam+4*i,angle);

             PrintMessage(text);

            if((*ang_len + 3) >= MAXalen) {
            printf("\07\07\n");
            PrintMessage(" ****** ERROR too many angles defined *****");
            return;}

            ang_vec[*ang_len] = pick_num[0];
            ang_vec[(*ang_len)+1] = pick_num[1];
            ang_vec[(*ang_len)+2] = i;
            *ang_len = (*ang_len) + 3;

             pick_p=0; qreset(); break;

	   }}}
PickExit:;
		       }
            break;
		      }
	  } 
            if(DisplayFlag) {
              DisplayFlag = 0;
              bang_it();}
    }

    }

#else 
              select_ang_arr(ang_len,ang_vec);
#endif
}

/***********************************************************************/
tors_arr(tor_len,tor_vec)

       int *tor_len,tor_vec[];
/***********************************************************************/
{
      extern int *atm_type;
      extern float *atm_charge;

     register int oldx,oldy;
     register short dx,dy;

      static int xsiz,ysiz,xo,yo,i,j;
      static int DisplayFlag;
      static int pick_p,pick_num[3],repeat;
      static float xx,yy,xtr,ytr,angle;
      static float ddx,ddy,ddz,tmp1,tmp2;
      float diffs;
      char text[BUFF_LEN];
      float RotT[4][4];

#ifdef sgi

      switch(yes_no_graph) {

      case 0: /* graphics is turned off */
              select_tors_arr(tor_len,tor_vec);
              break;

      case 1: /* pick your selection list with mouse */


      *tor_len = 0;

      diffs = far - near;

      PICK_READY();
  
      PrintMessage(" >>>>>> PRESS e-key to return from TORSION facility <<<<<< \n");

      text_port = 1;  /* display text from now */

      strncpy(bottom_line,"Pick four atoms for a torsion angle",PORTchar);
      going_on();

      pick_p=0;   /* reset the pick */
      repeat = mliste[mlist_deep - 1] + 1;

      while(1) {

      DisplayFlag = 0;

        while(qtest()) {

          dev=qread(&val);

          switch(dev) {              /* main switch board */

                      case ESCKEY:
                        shut_down(0); 

		      case EKEY: 
                        qreset();
                        text_port = 0;
                        return; 

		      case REDRAW:
                        DisplayFlag = 1;
                        reshapeviewport();
                        break;

		      case MENUBUTTON:
                       { menuval = dopup(identmenu);
                           switch( menuval) {
                           case 1:
                           text_port = 0;
                            qreset();
                           return;break;
                           case 2:
                           shut_down(0);
                           case 3:
                           if(text_port ==0) text_port = 1;
                           else
                           text_port =0;
                           DisplayFlag = 1;
                           break;}}
                        break;

/* track MOUSEX                         */
		      case MOUSEX:
                        oldx=xval;
                         xval=val;
                          dx= oldx-xval;
                      
                       if(getbutton(LEFTMOUSE)) {
                        if(getbutton(MIDDLEMOUSE)) {
                        ddx=Rabs((float) xval/((float) oldx));
                        DisplayFlag = 0;
                        scale(ddx , ddx , ddx);
                        qreset();
                        bang_it(); break;}

                        if(getbutton(PAD2)) {
                        DisplayFlag = 0;
                          qreset();
                          TRANSLATE( 0.0 , 0.0 , (((float)dx) * damp) );
                           bang_it(); break;}

                        if(getbutton(PAD8)) {
                        DisplayFlag = 0;
                           qreset();
                           TRANSLATE( 0.0 , (((float)dx) * damp) , 0.0 );
                            bang_it(); break;}

                        if(getbutton(PAD6)) {
                        DisplayFlag = 0;
                            qreset();
                            TRANSLATE( (((float)dx) * damp) , 0.0 , 0.0);
                             bang_it(); break;}

                          ROTATE( -dx ,'y');
                           DisplayFlag = 1;}

                        if(getbutton(MIDDLEMOUSE)) {
                          ROTATE( dx , 'z');
                           DisplayFlag = 1;}
                       break;

/* track MOUSEY                         */
		      case MOUSEY:
                        oldy=yval;
                         yval=val;
                          dy= oldy-yval;

                        if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
                         ddy=Rabs((float) yval/((float) oldy));
                         DisplayFlag = 0;
                         scale(ddy , ddy , ddy);
                         qreset();
                         bang_it(); break;}

		         if(getbutton(LEFTMOUSE)) {
                           ROTATE(  dy ,'x');
                            DisplayFlag = 1;}

		         if(getbutton(MIDDLEMOUSE)) {
                           ROTATE( dy , 'z');
                            DisplayFlag = 1;}
                       break;

		    case LEFTMOUSE:
                       { if(!val) break;
                          xc=getvaluator(MOUSEX);
                          yc=getvaluator(MOUSEY);
            
                          getmatrix(xycoor);
                           mmode(MPROJECTION); 
                            getmatrix(RotT);
                             multmatrix(xycoor);
                            getmatrix(xycoor);
                           loadmatrix(RotT);
                           mmode(MVIEWING);

                         /* Reset queue                              */
                          qreset();

                          getsize(&xsiz,&ysiz);
                          getorigin(&xo,&yo);

            xx=near + diffs*((float)(xc+1-xo)/ (float) xsiz);
            yy=near + diffs*((float)(yc+1-yo)/ (float) ysiz);


            for( j = 0 ; j < mlist_deep ; j++) {
            for( i = mlists[j] ; i < mliste[j] ; i++) {
    
/* don't count undisplayed atoms (disp_list[i] = 0)      */
            if(disp_list[i] == 0) continue;



     xtr= 0.5 * diffs * (xycoor[0][0]*x[i]+xycoor[1][0]*y[i]+
          xycoor[2][0]*z[i]+xycoor[3][0]-rotB[3][0]);
     ytr= 0.5 * diffs * (xycoor[0][1]*x[i]+xycoor[1][1]*y[i]+
          xycoor[2][1]*z[i]+xycoor[3][1]-rotB[3][1]);

           tmp1 = (xx-xtr);
           tmp2 = (yy-ytr);

             if((tmp1 * tmp1 + tmp2 * tmp2) < HitSphere2 ) {

             if( i == repeat) break;
             repeat = i;
             sprintf(text," (%d:%.4s:%.4s) \007\n",i+1,atnam+4*i,resnam+(4*i));
             PrintMessage(text);

             DisplayFlag = 1;

             if(pick_p < 3 ) {pick_num[pick_p]=i ; pick_p++ ; goto PickExit;}

             dihed(pick_num[0],pick_num[1],pick_num[2],i,&angle);

/*  in degrees */
             angle = angle*180.0/pia;

sprintf(text,"\n Torsion %d_%.4s:%.4s- %d_%.4s:%.4s- %d_%.4s:%.4s- %d_%.4s:%.4s = %f \n\n",
                                                           pick_num[0]+1,
                                                     atnam+4*pick_num[0],
                                                    resnam+4*pick_num[0],
                                                           pick_num[1]+1,
                                                     atnam+4*pick_num[1],
                                                    resnam+4*pick_num[1],
                                                           pick_num[2]+1,
                                                     atnam+4*pick_num[2],
                                                    resnam+4*pick_num[2],
                                                                     i+1,
                                                               atnam+4*i,
                                                       resnam+4*i,angle);
             PrintMessage(text);

          if((*tor_len + 4) >= MAXtlen) {
          printf("\07\07\n");
          PrintMessage("****** ERROR too many torsion angles defined *****");
          return;}

            tor_vec[*tor_len] = pick_num[0];
            tor_vec[(*tor_len)+1] = pick_num[1];
            tor_vec[(*tor_len)+2] = pick_num[2];
            tor_vec[(*tor_len)+3] = i;
            *tor_len = (*tor_len) + 4;

             pick_p=0; qreset(); break;

	   }}}
PickExit:;
		       }
            break;
		      }
	  } 
            if(DisplayFlag) {
              DisplayFlag = 0;
              bang_it();}
    }
    }

#else
              select_tors_arr(tor_len,tor_vec);
#endif
}



/***********************************************************************/
point_arr(point_len,point_vec)

    int *point_len,point_vec[];
/***********************************************************************/
{
      extern int *atm_type;
      extern float *atm_charge;

     register int oldx,oldy;
     register short dx,dy;

      static int xsiz,ysiz,xo,yo,i,j;
      static int DisplayFlag;
      static float xx,yy,xtr,ytr;
      static float ddx,ddy,ddz,tmp1,tmp2;
      static int pick_p,pick_num,repeat;
      static float diffs;
      char text[BUFF_LEN];
      float RotT[4][4];

#ifdef sgi

      switch(yes_no_graph) {

      case 0: /* graphics is turned off */
              select_point_arr(point_len,point_vec);
              break;

      case 1: /* pick your selection list with mouse */

      diffs = far - near;

      PICK_READY();

      PrintMessage(" >>>>>> PRESS e-key to return from POINT facility <<<<<<");

      text_port = 1;  /* display text from now */

      strncpy(bottom_line,"Pick an atom.",PORTchar);
      going_on();

      *point_len = 0;

      pick_p=0;   /* reset the pick */
      repeat = mlists[0] + 1;

      while(1) {

      DisplayFlag = 0;

        while(qtest()) {

          dev=qread(&val);

          switch(dev) {              /* main switch board */

                      case ESCKEY:
                        shut_down(0); 

		      case EKEY: 
                        qreset();
                        text_port = 0;
                        return; 

		      case REDRAW:
                        DisplayFlag = 1;
                        reshapeviewport();
                        break;

		      case MENUBUTTON:
                       { menuval = dopup(identmenu);
                           switch( menuval) {
                           case 1:
                           text_port = 0;
                            qreset();
                           return;break;
                           case 2:
                           shut_down(0);
                           case 3:
                           if(text_port ==0) text_port = 1;
                           else
                           text_port =0;
                           DisplayFlag = 1;
                           break;}}
                        break;

/* track MOUSEX                         */
		      case MOUSEX:
                        oldx=xval;
                         xval=val;
                          dx= oldx-xval;
                      
                       if(getbutton(LEFTMOUSE)) {
                        if(getbutton(MIDDLEMOUSE)) {
                        ddx=Rabs((float) xval/((float) oldx));
                        DisplayFlag = 0;
                        scale(ddx , ddx , ddx);
                        qreset();
                        bang_it(); break;}

                        if(getbutton(PAD2)) {
                        DisplayFlag = 0;
                          qreset();
                          TRANSLATE( 0.0 , 0.0 , (((float)dx) * damp) );
                           bang_it(); break;}

                        if(getbutton(PAD8)) {
                        DisplayFlag = 0;
                           qreset();
                           TRANSLATE( 0.0 , (((float)dx) * damp) , 0.0 );
                            bang_it(); break;}

                        if(getbutton(PAD6)) {
                        DisplayFlag = 0;
                            qreset();
                            TRANSLATE( (((float)dx) * damp) , 0.0 , 0.0);
                             bang_it(); break;}

                          ROTATE( -dx ,'y');
                           DisplayFlag = 1;}

                        if(getbutton(MIDDLEMOUSE)) {
                          ROTATE( dx , 'z');
                           DisplayFlag = 1;}
                       break;

/* track MOUSEY                         */
		      case MOUSEY:
                        oldy=yval;
                         yval=val;
                          dy= oldy-yval;

                        if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
                         ddy=Rabs((float) yval/((float) oldy));
                         DisplayFlag = 0;
                         scale(ddy , ddy , ddy);
                          qreset();
                         bang_it(); break;}

		         if(getbutton(LEFTMOUSE)) {
                           ROTATE(  dy ,'x');
                            DisplayFlag = 1;}

		         if(getbutton(MIDDLEMOUSE)) {
                           ROTATE( dy , 'z');
                            DisplayFlag = 1;}
                       break;

		    case LEFTMOUSE:
                       { if(!val) break;
                          xc=getvaluator(MOUSEX);
                          yc=getvaluator(MOUSEY);
            
                          getmatrix(xycoor);
                           mmode(MPROJECTION); 
                            getmatrix(RotT);
                             multmatrix(xycoor);
                            getmatrix(xycoor);
                           loadmatrix(RotT);
                           mmode(MVIEWING);

                         /* Reset queue                              */
                          qreset();

                          getsize(&xsiz,&ysiz);
                          getorigin(&xo,&yo);

            xx=near + diffs*((float)(xc+1-xo)/ (float) xsiz);
            yy=near + diffs*((float)(yc+1-yo)/ (float) ysiz);


            for( j = 0 ; j < mlist_deep ; j++) {
            for( i = mlists[j] ; i < mliste[j] ; i++) {
    
/* don't count undisplayed atoms (disp_list[i] = 0)      */
            if(disp_list[i] == 0) continue;



     xtr= 0.5 * diffs * (xycoor[0][0]*x[i]+xycoor[1][0]*y[i]+
          xycoor[2][0]*z[i]+xycoor[3][0]-rotB[3][0]);
     ytr= 0.5 * diffs * (xycoor[0][1]*x[i]+xycoor[1][1]*y[i]+
          xycoor[2][1]*z[i]+xycoor[3][1]-rotB[3][1]);

/*
           printf(" xtr %f ytr %f xx %f yy %f \n",xtr,ytr,xx,yy);
*/
           tmp1 = (xx-xtr);
           tmp2 = (yy-ytr);

             if((tmp1 * tmp1 + tmp2 * tmp2) < HitSphere2 ) {
             if( i == repeat) break;
             repeat = i;

sprintf(text," (%d:%.4s:%.4s) \007",res1[i],atnam+4*i,resnam+(4*i));
PrintMessage(text);

/* fill point vector  */

            if((*point_len + 1) >= MAXplen) {
            printf("\07\07\n");
            PrintMessage(" ****** ERROR too many points defined *****");
            return;}

            point_vec[*point_len] = i;
            *point_len = (*point_len) + 1;

            DisplayFlag = 1;
            break;
	   }}}
		       }
            break;
		       }
	  } 
            if(DisplayFlag) {
              DisplayFlag = 0;
              bang_it();}
    }
    }
#else
       PrintMessage("?ERROR - not implemented ");
#endif
}

/***********************************************************************/
int TrajAnalysisPointers( PointLen, PointVec,
                      DistLen,  DistVec,
                      AngLen,   AngVec,
                      TorsLen,  TorsVec,
                      CCLen,    CCVec,
                      MCLen,    MCVec)
     int  PointLen;
     int *PointVec;
     int  DistLen;
     int *DistVec;
     int  AngLen;
     int *AngVec;
     int  TorsLen;
     int *TorsVec;
     int  CCLen;
     float *CCVec;
     int  MCLen;
     float *MCVec;
/***********************************************************************/
{
     TrajPropertyList.point_len = PointLen;
     TrajPropertyList.dist_len  = DistLen;
     TrajPropertyList.ang_len   = AngLen;
     TrajPropertyList.tors_len  = TorsLen;

     TrajPropertyList.cc_len = CCLen;
     TrajPropertyList.mc_len = MCLen;

     TrajPropertyList.point_vec = PointVec;
     TrajPropertyList.dist_vec  = DistVec;
     TrajPropertyList.ang_vec   = AngVec;
     TrajPropertyList.tors_vec  = TorsVec;

     TrajPropertyList.cc_vec = CCVec;
     TrajPropertyList.mc_vec = MCVec;

     return(0);
}
/**************************************************************************/
int SetTorsPeriod(Alt)
    int Alt;
/**************************************************************************/
{
    if(!Alt) {
        TorsionRange.Period = 0;
        PrintMessage("Torsion values are in the range -180 < tors < 180 degrees");}
    else {
        TorsionRange.Period = 1;
        PrintMessage("Torsion values are in the range    0 < tors < 360 degrees");}

    return(0);
}
/**************************************************************************/
int ShuffleTrajectoryLimits(int *Numset)
/**************************************************************************/
{

  if(trajectory_info.first_frame == 0)
                trajectory_info.first_frame =       1;

  if(trajectory_info.last_frame  == 0)
                trajectory_info.last_frame  = *Numset;

  if(trajectory_info.last_frame > *Numset)
                trajectory_info.last_frame  = *Numset;

  if(trajectory_info.delta_frame == 0)
                trajectory_info.delta_frame =       1;

#ifdef DEBUG
printf(": 2\n");
printf("First:   %d\n",trajectory_info.first_frame);
printf("Last:    %d\n",trajectory_info.last_frame);
printf("Delta:   %d\n",trajectory_info.delta_frame);
#endif

    return(0);
}
