/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <malloc.h>
#include <ctype.h>
#ifdef sgi
#include <gl/gl.h>
#endif
#include "maxdefs.h"

  extern int numat;
  extern FILE *charmm_oc;
  extern int **atmcol;
  extern short BOX;
  extern float *vector();
  extern int   *ivector();
  extern float *x;
  extern float *y;
  extern float *z;
  extern float sumx;
  extern float sumy;
  extern float sumz;
  extern int indexo();
  extern int draw_obj_disp;
  extern char *disp_list;
  extern int atom_list_max();
  extern void PrintMessage();
  extern int TrajectoryLastFrame();
  extern int TrajectoryFirstFrame();
  extern int TrajectoryStepFrame();
  extern int FramesInSet();
  extern int alpha_trace;

/* structure to hold the trace of atoms       */

   struct {
   int trace_on;        /* switch to indicate that a trace is saved (=1)   */
   int trace_sets;      /* number of trace sets                            */
   int trace_step;      /* step length                                     */
   int *trace_atoms;    /* number of traced atoms in each set              */
   int *trace_list;     /* list of atoms to be traced                      */
   float *trx;          /* array to contain the x coordinates of the trace */
   float *try;
   float *trz;} trace_info;

/* structure to hold the trace of ramachandran       */

   struct {
   int trace_on;        /* switch to indicate that a trace is saved (=1)   */
   int trace_sets;      /* number of trace sets                            */
   int trace_step;      /* step length                                     */
   int *trace_atoms;    /* number of traced atoms in each set              */
   int *trace_list;     /* list of atoms to be traced                      */
   float *phi;          /* array to contain the x coordinates of the trace */
   float *psi;} trace_info_rama;

/* structure for the dynamics trajectory file */

   extern struct {
    char traj_file[BUFF_LEN];                 /* file name          */
    int natom;                                /* number of atoms    */
    int nstep;                                /* number of steps    */
    int time_bw_steps;                        /* time between steps */
    int time_first_frame;                     /* time of first frame */
    int first_frame;                          /* first frame to be displayed */
    int last_frame;                           /* last frame to be displayed  */
    int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

/* molecule lists */
 extern int current_struct;    /* molecule to be displayed */
 extern int mlist_deep;        /* stack number indicator */
 extern int mlists[MAX_MLIST]; /* First index for molecule list */
 extern int mliste[MAX_MLIST]; /* Second index for molecule list */
 extern char mnlist[MAX_MLIST][BUFF_LEN]; /* name list for molecule file names */


    int trace_wind; /* = 0 no display , = 1 display on */

/************************************************************************/
trace_fac(input,num)   /* trace facility */
   char *input; 
   int num;
/************************************************************************/
{

     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     int i;
     char OutText[BUFF_LEN];

/* switch to small characters                 */
     toller(parsed[1]);

/* help tace                                  */
   if(indexo(parsed[1],"?") == 1) {
   PrintMessage("trac*e atom segment:residue:atom [ifirst ilast istep] [append]! Trace atom(s)");
   return;}

/* atom                                       */
   if(indexo(parsed[1],"atom") == 1) {
   PrintMessage("!WARNING - this will destroy all other molecules than the first set/structure");
   trace_atom(parsed[2],parsed[3],parsed[4],parsed[5],parsed[6],parsed[7],parsed[8]);
   return;
   }

/* turn trace off                             */
   if(indexo(parsed[1],"-ato") == 1) {
     if(trace_info.trace_on == 1) {
     free((char *)trace_info.trx);   
      free((char *)trace_info.try);   
       free((char *)trace_info.trz);   
        free((char *)trace_info.trace_list);
         free((char *)trace_info.trace_atoms);
     trace_info.trace_on = 0;
     trace_wind = 0;
     draw_obj_disp = 1;
/* turn atom display on   (works always with the first molecule) */
      if(!alpha_trace)
          for(i = mlists[0] ; i < mliste[0] ; i++) disp_list[i] = 1;
     return;}
     else {
     PrintMessage("?ERROR - no trace to be deleted");
     return;}
   }

#ifdef JUNK
/* rama                                         */
   if(indexo(parsed[1],"rama") == 1) {
   printf("!WARNING - this will destroy all other molecules than the first set \n");
   trace_rama(parsed[2],parsed[3],parsed[4],parsed[5],parsed[6],parsed[7],parsed[8]);
   return;
   }

#endif

/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of trace_fac */

/* trace the movement of the atoms in the selection list.
   The data come from the trajectory file */
/************************************************************************/
trace_atom(text1,text2,text3,text4,text5,text6,text7)
      char *text1;
      char *text2;
      char *text3;
      char *text4;  /* first frame */
      char *text5;  /* last frame  */
      char *text6;  /* step        */
      char *text7;  /* append      */
/************************************************************************/
{

      static int *sel_list;
      static int slong;
      static float vec[3];
      static float *tx,*ty,*tz;
      static int i,j,jj,loop,new_len,new_len1,atom_max;
      static int append;
      static int first_frame;
      static int last_frame;
      static int step_frame;
      static int retv;

      first_frame = 0;
      last_frame  = 0;
      step_frame  = 0;

      if(isdigit(text4[0])) {
       first_frame = atoi(text4);
       last_frame  = atoi(text5);
       step_frame  = atoi(text6);}

        if(first_frame == 0) first_frame = TrajectoryFirstFrame();
        if(last_frame == 0)  last_frame  = TrajectoryLastFrame();
        if(step_frame == 0)  step_frame  = TrajectoryStepFrame();

     i = check_frame_region(&first_frame,&last_frame,&step_frame);
     if(i > 0) return;

     trajectory_info.first_frame =  first_frame;
     trajectory_info.last_frame  =  last_frame;
     trajectory_info.delta_frame =  step_frame;
     trace_info.trace_step       =  step_frame;

     atom_max = atom_list_max();
     sel_list = ivector(atom_max);

     slong = select_list(text1,text2,text3,sel_list);

     if(slong > 0) { 

/* delete all other molecule sets */

     mlist_deep = 1;  
     current_struct = 0;

/* check that the trajectory file is known */
    if(trajectory_info.traj_file[0] == '\0') {
      printf("?ERROR - trajectory file name not set \n");
      check_if_fatal(1);
      return;}
/* do it ... */
     /* open trajectory file */

        charmm_oc = fopen(trajectory_info.traj_file,"r");
        if(charmm_oc == NULL) {
        printf(">>> Can't open input file: %s\n",trajectory_info.traj_file);
        check_if_fatal(1); 
        return;}

     append = 0;
     if((indexo(text4,"appe") == 1) ||
        (indexo(text5,"appe") == 1) ||
        (indexo(text6,"appe") == 1) ||
        (indexo(text7,"appe") == 1)) { 
       append = 1;
/* check if there is something to be appended to */
       if(trace_info.trace_sets == 0) { /* no there is nothing */
         append = 0;
         printf("?WARNING - can't append to an empty list \n");
       }}

/* get some scratch space and save the x,y and z coordinates */
     tx = vector(atom_max);
      ty = vector(atom_max);
       tz = vector(atom_max);

/* save coordinates */
     for(i = mlists[0] ; i < mliste[0] ; i++) {
        tx[i] = x[i];
         ty[i] = y[i];
          tz[i] = z[i];}


    switch(append) {

    case 0:  /* new list */

/* prepare the trace info structure */
    if(trace_info.trace_on > 0 || trace_info.trace_atoms != 0) {
     free(trace_info.trx);   
      free(trace_info.try);   
       free(trace_info.trz);   
        free(trace_info.trace_list);
         free(trace_info.trace_atoms);
         trace_info.trace_atoms = 0;}

         trace_info.trace_atoms = ivector(1);

/* get space to save the trace                               */
     trace_info.trace_list = ivector(slong);
      for(i = 0 ; i < slong ; i++)
          trace_info.trace_list[i] = sel_list[i];

     jj = slong * ((last_frame - first_frame + 1) / step_frame);

     printf("!INFO - will grab '%d' bytes of memory now\n",3*jj*sizeof(int));

     trace_info.trx = vector(jj);
      trace_info.try = vector(jj);
       trace_info.trz = vector(jj);



/* loop through the conformations */

   loop = 0;
   for(i = (first_frame - 1) ; i < last_frame ; i += step_frame) {  /* frames   */

      mlist_deep     = 0;
      current_struct = 0;
      retv = rtraj_frame(i);         /* read trajectory into x,y and z */
      if(retv < 0) {
        fclose(charmm_oc);
        return;}
      rewind(charmm_oc);

      for(j = 0 ; j < slong ; j++) {  /* atoms */
      jj = sel_list[j];
        trace_info.trx[loop] = x[jj] - sumx;
         trace_info.try[loop] = y[jj] - sumy;
          trace_info.trz[loop] = z[jj] - sumz; 
          loop++;}
}

      trace_info.trace_on = 1; /* trace is ready to be displayed */
      trace_info.trace_atoms[0] = slong;
      trace_info.trace_sets = 1;

     break; /* end of new list */

     case 1: /* append to old list */

/* realloc further space            */

       new_len = 0;

       for( i = 0 ; i < trace_info.trace_sets ; i++) 
             new_len += trace_info.trace_atoms[i];

    new_len1 = (new_len + slong) * ((last_frame - first_frame + 1) / step_frame);

    trace_info.trace_list = (int *) realloc((char *) trace_info.trace_list, 
                                           (new_len +slong) * sizeof(int));
    trace_info.trace_atoms = (int *) realloc((char *) trace_info.trace_atoms, 
                                   (trace_info.trace_sets + 1)* sizeof(int));
    trace_info.trx = (float *) realloc((char *) trace_info.trx,
                            new_len1 * sizeof(float));
    trace_info.try = (float *) realloc((char *) trace_info.try,
                            new_len1 * sizeof(float));
    trace_info.trz = (float *) realloc((char *) trace_info.trz,
                            new_len1 * sizeof(float));


      for(i = 0 ; i < slong ; i++)
          trace_info.trace_list[i + new_len] = sel_list[i];


/* loop through the conformations */


   loop = new_len * (last_frame - first_frame + 1) / step_frame;
   for(i = (first_frame - 1) ; i < last_frame ; i += step_frame) {  
                                                   /* frames  */

      mlist_deep     = 0;
      current_struct = 0;
      retv = rtraj_frame(i);         /* read trajectory into x,y and z */
      if(retv < 0) {
        fclose(charmm_oc);
        return;}
      rewind(charmm_oc);

      for(j = 0 ; j < slong ; j++) {  /* atoms */
      jj = sel_list[j];
        trace_info.trx[loop] = x[jj] - sumx;
         trace_info.try[loop] = y[jj] - sumy;
          trace_info.trz[loop] = z[jj] - sumz; 
          loop++;}
}

      trace_info.trace_on = 1; /* trace is ready to be displayed */

      trace_info.trace_atoms[trace_info.trace_sets] = slong;

      trace_info.trace_sets++;

     break; /* end of append list */
   }

/* put values back */
     for(i = mlists[0] ; i < mliste[0] ; i++) {
        x[i] = tx[i];
         y[i] = ty[i];
          z[i] = tz[i];}

   free((char *)tx); /* free the scratch space */
    free((char *)ty);
     free((char *)tz);

   free((char *)sel_list);

   fclose(charmm_oc);

   return;}

/* done */

     else {
/* prepare the trace info structure */
     trace_info.trace_sets = slong;
     printf("?WARNING - no atoms in the selection list \n");
     return;}

}

/************************************************************************/
plot_atom_trace()
/************************************************************************/
{

   static int i,j,k,jj,loop,loopI,in_set,in_set1;
   static float vec[3];


#ifdef sgi

    in_set  = 0;
    in_set1 = 0;

    for(k = 0 ; k < trace_info.trace_sets ; k++) {

    for(j = 0 ; j < trace_info.trace_atoms[k] ; j++) {

    bgnline();
 
     loopI = 0;
     for(i = (trajectory_info.first_frame - 1) ; 
         i <  trajectory_info.last_frame       ; 
         i += trajectory_info.delta_frame) {

     jj = in_set + loopI * trace_info.trace_atoms[k];

                   loopI++;

     vec[0] = trace_info.trx[j + jj]; 
      vec[1] = trace_info.try[j + jj]; 
       vec[2] = trace_info.trz[j + jj]; 

     c3i(atmcol[trace_info.trace_list[j + in_set1]]);
     v3f(vec);
     loop++;

     if(loop > 250) {
     endline();
     bgnline();
     loop = 0;}}

    endline();

    }
   in_set  += (trajectory_info.last_frame - trajectory_info.first_frame + 1) *
               trace_info.trace_atoms[k];
   in_set1 += trace_info.trace_atoms[k];}

#else

  printf("?ERROR - not implemented on this device \n");

#endif

}


/* Check number of dynamics frames 

   On return:   0 , ok
                1 , error in the supplied range 
*/
/************************************************************************/
int check_frame_region(first,last,delta)
      int *first; 
      int *last;
      int *delta;
/************************************************************************/
{

   if(*first < 1)
      *first = 1;
   if(*last  < 1)
      *last  = trajectory_info.nstep;
   if(*delta < 1)
      *delta == 1;

/* check that there is a named trajectory file */
   if(trajectory_info.traj_file[0] == '\0') {
     PrintMessage("?ERROR - there is no named trajectory file");
     return(1);}

/* check first that 'first' is < than 'last' */
   if(*first > *last) {
      PrintMessage("?ERROR - error in range, first frame > last frame");
      return(1);}

/* check that first frame is > 0 and that last frame is <= max frames */
   if(*first < 1) {
     PrintMessage("?ERROR - first frame number has to be > 0");
     return(1);}

   if(*last > trajectory_info.nstep) {
     PrintMessage("?ERROR - last frame number > total number of frames");
     return(1);}

#ifdef JUNK
/* check the step */
   if(((*last - *first + 1)%(*delta))) {
     PrintMessage("?ERROR - the step length is not correct (not a multiplier)");
     return(1);}
#endif

/* ok ... */
     return(0);
}





/* trace the movement of the atoms in the selection list.
   The data come from the trajectory file */
/************************************************************************/
trace_rama(text1,text2,text3,text4,text5,text6,text7)
      char *text1;
      char *text2;
      char *text3;
      char *text4;  /* first frame */
      char *text5;  /* last frame  */
      char *text6;  /* step        */
      char *text7;  /* append      */
/************************************************************************/
{

      static int *sel_list;
      static int slong;
      static float vec[3];
      static float *tx,*ty,*tz;
      static int i,j,jj,loop,new_len,new_len1,atom_max;
      static int append;
      static int first_frame;
      static int last_frame;
      static int step_frame;
      static int retv;

      first_frame = 0;
      last_frame  = 0;
      step_frame  = 0;

      if(isdigit(text4[0])) {
       first_frame = atoi(text4);
       last_frame  = atoi(text5);
       step_frame  = atoi(text6);}

        if(first_frame == 0) first_frame = TrajectoryFirstFrame();
        if(last_frame == 0)  last_frame  = TrajectoryLastFrame();
        if(step_frame == 0)  step_frame  = TrajectoryStepFrame();

     i = check_frame_region(&first_frame,&last_frame,&step_frame);
     if(i > 0) return;

     trajectory_info.first_frame =  first_frame;
     trajectory_info.last_frame  =  last_frame;
     trajectory_info.delta_frame =  step_frame;
     trace_info_rama.trace_step = step_frame;

     atom_max = atom_list_max();
     sel_list = ivector(atom_max);

     slong = select_list(text1,text2,text3,sel_list);

     if(slong > 0) { 

/* delete all other molecule sets */

     mlist_deep = 1;  
     current_struct = 0;

/* check that the trajectory file is known */
    if(trajectory_info.traj_file[0] == '\0') {
      printf("?ERROR - trajectory file name not set \n");
      check_if_fatal(1);
      return;}
/* do it ... */
     /* open trajectory file */

        charmm_oc = fopen(trajectory_info.traj_file,"r");
        if(charmm_oc == NULL) {
        printf(">>> Can't open input file: %s\n",trajectory_info.traj_file);
        check_if_fatal(1); 
        return;}

     append = 0;
     if((indexo(text4,"appe") == 1) ||
        (indexo(text5,"appe") == 1) ||
        (indexo(text6,"appe") == 1) ||
        (indexo(text7,"appe") == 1)) { 
       append = 1;
/* check if there is something to be appended to */
       if(trace_info_rama.trace_sets == 0) { /* no there is nothing */
         append = 0;
         printf("?WARNING - can't append to an empty list \n");
       }}

/* get some scratch space and save the x,y and z coordinates */
     tx = vector(atom_max);
      ty = vector(atom_max);
       tz = vector(atom_max);

/* save coordinates */
     for(i = mlists[0] ; i < mliste[0] ; i++) {
        tx[i] = x[i];
         ty[i] = y[i];
          tz[i] = z[i];}


    switch(append) {

    case 0:  /* new list */

/* prepare the trace info structure */
         trace_info_rama.trace_atoms = ivector(1);

/* get space to save the trace                               */
     trace_info_rama.trace_list = ivector(slong);
      for(i = 0 ; i < slong ; i++)
          trace_info_rama.trace_list[i] = sel_list[i];

     jj = slong * ((last_frame - first_frame + 1) / step_frame);

     printf("!INFO - will grabb '%d' new bytes space now\n",3*jj*sizeof(int));

     trace_info_rama.phi = vector(jj);
      trace_info_rama.psi = vector(jj);


/* loop through the conformations */

   loop = 0;
   for(i = (first_frame - 1) ; i < last_frame ; i += step_frame) {  /* frames   */

      mlist_deep     = 0;
      current_struct = 0;
      retv = rtraj_frame(i);         /* read trajectory into x,y and z */
      if(retv < 0) {
        fclose(charmm_oc);
        return;}
      rewind(charmm_oc);

      for(j = 0 ; j < slong ; j++) {  /* atoms */
      jj = sel_list[j];
        trace_info_rama.phi[loop] = x[jj] - sumx;
         trace_info_rama.psi[loop] = y[jj] - sumy;
          loop++;}
}

      trace_info_rama.trace_on = 1; /* trace is ready to be displayed */
      trace_info_rama.trace_atoms[0] = slong;
      trace_info_rama.trace_sets = 1;

     break; /* end of new list */

     case 1: /* append to old list */

/* realloc further space            */

       new_len = 0;

       for( i = 0 ; i < trace_info_rama.trace_sets ; i++) 
             new_len += trace_info_rama.trace_atoms[i];

    new_len1 = (new_len + slong) * ((last_frame - first_frame + 1) / step_frame);

    trace_info_rama.trace_list = (int *) realloc((char *) trace_info_rama.trace_list, 
                                           (new_len +slong) * sizeof(int));
    trace_info_rama.trace_atoms = (int *) realloc((char *) trace_info_rama.trace_atoms, 
                                   (trace_info_rama.trace_sets + 1)* sizeof(int));
    trace_info_rama.phi = (float *) realloc((char *) trace_info_rama.phi,
                            new_len1 * sizeof(float));
    trace_info_rama.psi = (float *) realloc((char *) trace_info_rama.psi,
                            new_len1 * sizeof(float));


      for(i = 0 ; i < slong ; i++)
          trace_info_rama.trace_list[i + new_len] = sel_list[i];


/* loop through the conformations */


   loop = new_len * (last_frame - first_frame + 1) / step_frame;
   for(i = (first_frame - 1) ; i < last_frame ; i += step_frame) {  /* frames  */

      mlist_deep     = 0;
      current_struct = 0;
      retv = rtraj_frame(i);         /* read trajectory into x,y and z */
      if(retv < 0) {
        fclose(charmm_oc);
        return;}
      rewind(charmm_oc);

      for(j = 0 ; j < slong ; j++) {  /* atoms */
      jj = sel_list[j];
        trace_info_rama.phi[loop] = x[jj] - sumx;
         trace_info_rama.psi[loop] = y[jj] - sumy;
          loop++;}
}

      trace_info_rama.trace_on = 1; /* trace is ready to be displayed */

      trace_info_rama.trace_atoms[trace_info_rama.trace_sets] = slong;

      trace_info_rama.trace_sets++;

     break; /* end of append list */
   }

/* put values back */
     for(i = mlists[0] ; i < mliste[0] ; i++) {
        x[i] = tx[i];
         y[i] = ty[i];
          z[i] = tz[i];}

   free((char *)tx); /* free the scratch space */
    free((char *)ty);
     free((char *)tz);

   free((char *)sel_list);

   fclose(charmm_oc);

   return;}

/* done */

     else {
/* prepare the trace info structure */
     trace_info_rama.trace_sets = slong;
     printf("?WARNING - no atoms in the selection list \n");
     return;}

}
