/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

/*
   This routine calculates the torsion angle for the atoms ia , ib , ic , id.

   This routine is kindly provided by Dr. Florian Muller-Plathe.

   1990
*/

#include <stdio.h>
#include <math.h>

#define SIGN(a,b)  ((b >= 0.0) ? (a) : -(a))

    extern float *x;
    extern float *y;
    extern float *z;

/***********************************************************************/
void dihed(ia,ib,ic,id,angle)
      int ia;
      int ib;
      int ic;
      int id;
      float *angle;
/***********************************************************************/
{
      static float eabx,eaby,eabz;
      static float ebcx,ebcy,ebcz;
      static float ecdx,ecdy,ecdz;
      static float abbcx,abbcy,abbcz;
      static float dccbx,dccby,dccbz;
      static float abcdx,abcdy,abcdz,signum;
      static float cosdel,xrcd;
      static float rab,rbc,rcd,xrbc,xrab,cosb,phib,xsinb,cosc,phic,xsinc;
         
/*        bond lengths and unit vectors    */

         eabx = x[ib] - x[ia];
         eaby = y[ib] - y[ia];
         eabz = z[ib] - z[ia];

         rab = sqrt (eabx * eabx + eaby * eaby + eabz * eabz);
         xrab = 1.0 / rab;
         eabx = eabx * xrab;
         eaby = eaby * xrab;
         eabz = eabz * xrab;
         ebcx = x[ic] - x[ib];
         ebcy = y[ic] - y[ib];
         ebcz = z[ic] - z[ib];

         rbc = sqrt (ebcx * ebcx + ebcy * ebcy + ebcz * ebcz);
         xrbc = 1.0 / rbc;
         ebcx = ebcx * xrbc;
         ebcy = ebcy * xrbc;
         ebcz = ebcz * xrbc;
         ecdx = x[id] - x[ic];
         ecdy = y[id] - y[ic];
         ecdz = z[id] - z[ic];

         rcd = sqrt (ecdx * ecdx + ecdy * ecdy + ecdz * ecdz);
         xrcd = 1.0 / rcd;
         ecdx = ecdx * xrcd;
         ecdy = ecdy * xrcd;
         ecdz = ecdz * xrcd;

/*
        cross and dot products between unit vectors, and bond (!)
        angles
*/
         abbcx = eaby * ebcz - eabz * ebcy;
         abbcy = eabz * ebcx - eabx * ebcz;
         abbcz = eabx * ebcy - eaby * ebcx;
         cosb = - (eabx * ebcx + eaby * ebcy + eabz * ebcz);
         phib = acos(cosb);
         xsinb = 1.0 / sin(phib);
         dccbx = ecdy * ebcz - ecdz * ebcy;
         dccby = ecdz * ebcx - ecdx * ebcz;
         dccbz = ecdx * ebcy - ecdy * ebcx;
         cosc = - (ecdx * ebcx + ecdy * ebcy + ecdz * ebcz);
         phic = acos(cosc);
         xsinc = 1.0 / sin(phic);

/*        torsional angle    */

         abcdx = - ( abbcy * dccbz - abbcz * dccby );
         abcdy = - ( abbcz * dccbx - abbcx * dccbz );
         abcdz = - ( abbcx * dccby - abbcy * dccbx );
         signum = SIGN(1.0,
                (abcdx * ebcx + abcdy * ebcy + abcdz * ebcz) );
         cosdel = - (abbcx * dccbx + abbcy * dccby + abbcz * dccbz)
                 *  xsinb * xsinc;

         if(cosdel < -1.0) cosdel = -1.0;
         if(cosdel >  1.0) cosdel =  1.0;

         *angle = signum * acos (cosdel);

}
/***********************************************************************/
void Dihed(iax , iay , iaz ,
           ibx , iby , ibz ,
           icx , icy , icz ,
           idx , idy , idz ,angle)

      float iax,iay,iaz;
      float ibx,iby,ibz;
      float icx,icy,icz;
      float idx,idy,idz;
      float *angle;
/***********************************************************************/
{
      static float eabx,eaby,eabz;
      static float ebcx,ebcy,ebcz;
      static float ecdx,ecdy,ecdz;
      static float abbcx,abbcy,abbcz;
      static float dccbx,dccby,dccbz;
      static float abcdx,abcdy,abcdz,signum;
      static float cosdel,xrcd;
      static float rab,rbc,rcd,xrbc,xrab,cosb,phib,xsinb,cosc,phic,xsinc;
         
/*        bond lengths and unit vectors    */

         eabx = ibx - iax;
         eaby = iby - iay;
         eabz = ibz - iaz;

         rab = sqrt (eabx * eabx + eaby * eaby + eabz * eabz);
         xrab = 1.0 / rab;
         eabx = eabx * xrab;
         eaby = eaby * xrab;
         eabz = eabz * xrab;
         ebcx = icx - ibx;
         ebcy = icy - iby;
         ebcz = icz - ibz;

         rbc = sqrt (ebcx * ebcx + ebcy * ebcy + ebcz * ebcz);
         xrbc = 1.0 / rbc;
         ebcx = ebcx * xrbc;
         ebcy = ebcy * xrbc;
         ebcz = ebcz * xrbc;
         ecdx = idx - icx;
         ecdy = idy - icy;
         ecdz = idz - icz;

         rcd = sqrt (ecdx * ecdx + ecdy * ecdy + ecdz * ecdz);
         xrcd = 1.0 / rcd;
         ecdx = ecdx * xrcd;
         ecdy = ecdy * xrcd;
         ecdz = ecdz * xrcd;

/*
        cross and dot products between unit vectors, and bond (!)
        angles
*/
         abbcx = eaby * ebcz - eabz * ebcy;
         abbcy = eabz * ebcx - eabx * ebcz;
         abbcz = eabx * ebcy - eaby * ebcx;
         cosb = - (eabx * ebcx + eaby * ebcy + eabz * ebcz);
         phib = acos(cosb);
         xsinb = 1.0 / sin(phib);
         dccbx = ecdy * ebcz - ecdz * ebcy;
         dccby = ecdz * ebcx - ecdx * ebcz;
         dccbz = ecdx * ebcy - ecdy * ebcx;
         cosc = - (ecdx * ebcx + ecdy * ebcy + ecdz * ebcz);
         phic = acos(cosc);
         xsinc = 1.0 / sin(phic);

/*        torsional angle    */

         abcdx = - ( abbcy * dccbz - abbcz * dccby );
         abcdy = - ( abbcz * dccbx - abbcx * dccbz );
         abcdz = - ( abbcx * dccby - abbcy * dccbx );
         signum = SIGN(1.0,
                (abcdx * ebcx + abcdy * ebcy + abcdz * ebcz) );
         cosdel = - (abbcx * dccbx + abbcy * dccby + abbcz * dccbz)
                 *  xsinb * xsinc;

         if(cosdel < -1.0) cosdel = -1.0;
         if(cosdel >  1.0) cosdel =  1.0;

         *angle = signum * acos (cosdel);

}


