
/*
 * accept --
 *
 *	This program demonstrates a simple server program. Any text
 *	sent by a client is displayed. When the client closes the
 *	connection, the server exits.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by Silicon Graphics, Inc.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <netdb.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>

/* Listen for connect requests on this arbitrarily-chosen port */
#define SERVER_PORT	(IPPORT_USERRESERVED + 123)

#define LINE_LEN	80

    int allowed = 0;
    char *allowed_host = "130.188.33.1";

/*************************************************************************/
acting_server()
/*************************************************************************/
{
    int sock, length, msgsock, cnt;
    int i,j;
    char line[LINE_LEN];
    char *con_host;
    struct sockaddr_in sin;
    struct hostent *hp;

#ifdef CRAY
    setenv("HOSTLOOKUP named");
#endif

    hp = gethostbyname("geeni.bio.vtt.fi");
    if( hp == NULL) {
    fprintf(stderr,"Can't find address for bio.vtt.fi\n\n");
    exit(1);}

    /* Create a socket */

    if ((sock = socket (AF_INET,SOCK_STREAM,0)) < 0) {
	perror("opening stream socket");
	exit(1);
    }

    /* Initialize the socket's address structure */

    sin.sin_family = AF_INET;
#ifdef sgi
    sin.sin_addr.s_addr = INADDR_ANY; 
/*    sin.sin_addr.s_addr = inet_addr("130.188.33.1");  */
#endif
    sin.sin_port = htons(SERVER_PORT);

    /* Assign an address to this socket */

    if (bind (sock,(struct sockaddr *) &sin,sizeof(sin)) < 0) {
	perror("binding stream socket");
	exit(1);
    }

    printf("Listening for connect requests on port %d\n", SERVER_PORT);

    /* Prepare the socket queue for connection requests */

    listen(sock,5);

    length = sizeof(sin);
    msgsock = accept(sock, &sin, &length);
    if (msgsock < 0) {
	perror("accept");
	exit(1);
    }

#ifdef CRAY
    con_host = inet_ntoa(sin.sin_addr);
    printf("Connection from host %s, port %d\n",
	con_host, sin.sin_port);
    fflush(stdout);
#else
    con_host = inet_ntoa(sin.sin_addr.s_addr);
    printf("Connection from host %s, port %d\n",
	con_host, sin.sin_port);
#endif

/* check if host allowed to connect */
    if(strcmp(con_host,allowed_host) != 0 || allowed) {
      strcpy(line,"\n\n\07Hello there, connection is not allowed from your node !! \n");
      write(msgsock,line,sizeof(line));
    printf("?ERROR - sorry buddy, you are not allowed to connect \n");
    printf("Connection tried from: <%s> \n",con_host);
    exit(1);}

    strcpy(line,"Hello there, I'm ready to start\n");

        write(msgsock,line,sizeof(line));

    /* Read from the message socket and write to standard output */

    while ((cnt = read(msgsock, line, LINE_LEN)) > 0) {
	write(1, line, cnt);

        write(msgsock,"Hello there, I'm ready",22);
    }

    close(msgsock);
    printf("Connection closed\n");
}
/*
 * connect --
 *
 *	This program connects to a server program and sends any data
 *	typed by the user to the server.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by Silicon Graphics, Inc.
 *
 * This program was hacked further by Leif Laaksonen 1990
 *
 */

static void die();

#define LINE_LEN	80

/* The server listens for connect requests on this port */
#define SERVER_PORT	(IPPORT_USERRESERVED + 123)



connect_to_server(server_name)
    char *server_name;
{
    int cnt, sock;
    struct sockaddr_in sin;
    struct hostent *hp;
    char line[LINE_LEN];

#ifdef sgi

    if ((sock = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
	perror("Can't open socket");
 exit(1);
    }

    /* Initialize the socket address to the server's address. */

    bzero((char *) &sin, sizeof(sin));
    sin.sin_family = AF_INET;
    hp = gethostbyname(server_name);    /* to get host address */
    if (hp == NULL) {
	fprintf(stderr, "Can't find address for %s\n", server_name);
	return;
    }
    bcopy (hp->h_addr, &(sin.sin_addr.s_addr), hp->h_length);
    sin.sin_port = htons(SERVER_PORT);

    /* Connect to the server */

    if (connect(sock, &sin,sizeof(sin)) < 0) {
	close(sock);
	perror("Connect to server");
	return;
    }

    printf("Connection established. Enter your message below. To exit, type ^D\n");

    /*
     * If the server goes away while sending data, we'll get a SIGPIPE signal. 
     * Catch it so we can print an error message.
     */
    signal(SIGPIPE, die);

    strcpy(line , getlogin());
    strcat(line , "\n");
    if(write(sock,line, LINE_LEN) < 0) {
      printf("?ERROR - writing to socket \n");
      shut_down(1);}

    gethostname(line,LINE_LEN);
    strcat(line,"\n");
    if(write(sock,line,LINE_LEN) < 0) {
      printf("?ERROR - writing to socket \n");
      shut_down(1);}

    read(sock,line,LINE_LEN);
    printf("Message from server: %s\n",line);
 
    while ((cnt = read(0, line, LINE_LEN)) > 0) {
	printf("sending <");
	fflush(stdout);
	write(1, line, cnt-1);
	printf("\\n>\n");
	fflush(stdout);

	/* Send input to the remote host */

	if (write(sock, line, cnt) < 0) {
	    perror("Error writing to socket");
	    shut_down(1);
	}
    }
    printf ("Done\n");
    close(sock);

#else

    printf("?ERROR - you are the server (can't connect to it) \n");
#endif
}

static void
die()
{
#ifdef sgi
    fprintf(stderr, "Server closed connection\n");
    shut_down(1);
#else
    printf("?ERROR - you should not come here ????? \n");
#endif
}


