/*  

                       Copyright (c) 1990, 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <sys/types.h>
#include <malloc.h>
#include "maxdefs.h"

#define Rabs(a)    ( ( a ) > 0 ? (a) : -(a))

#define MAXppconf 10   /* maximum number of ppconf entries */

      extern char *segment;
      extern char *resnam;
      extern char *atnam;
      extern int  *res1;
      extern int  numat;
      extern int minres1,maxres1,minres2,maxres2;
      extern float *x;
      extern float *y;
      extern float *z;
      extern float pia;
      extern int term_type;
      extern int draw_obj_disp;
      extern int num_ka;
      extern char *nam_ka3;
      extern char *nam_ka1;
      extern short bgcolor[];
      extern short obcolor[];

      extern int *ivector();
      extern float *vector();
      extern char *cvector();
      extern int OrderRAMAWindow(int plot_type);
      extern long GetMainWindowID();
      extern int  UsingMultiWindowing();

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

    extern struct secang {

    char phi[16];  /* space for 4 * 4 characters */
    char psi[16];
    char omega[16];};

    extern struct secang ppept_ang;

      int *phi_i;  /* index array to phi torsion angle array */
      int *psi_i;  /* index array to psi torsion angle array */
      int *omega_i;  /* index array to omega torsion angle array */
      int phi_e;     /* length of array */
      int psi_e;
      int omega_e;
      int *resi_num; /* residue numbers */
      float *phi_v;  /* the real values */
      float *psi_v;
      float *omega_v;

     extern int pp_loop;   /* keeps track of how many motifs are defined */

     extern struct pconf {

     char name[10];
     float phi;
     float psi;
     float omega;
     float rpt;
     float tpr;
     float delta;
     char color[BUFF_LEN];}; 

     extern struct pconf ppept_conf[MAXppconf];


/* structure to hold the trace of ramachandran       */

   extern struct {
    int trace_on;        /* switch to indicate that a trace is saved (=1)   */
    int trace_sets;      /* number of trace sets                            */
    int trace_step;      /* step length                                     */
    int *trace_atoms;    /* number of traced atoms in each set              */
    int *trace_list;     /* list of atoms to be traced                      */
    float *phi;          /* array to contain the x coordinates of the trace */
    float *psi;} trace_info_rama;

   extern int num_ka; /* number of known amino acids */
   extern char *nam_ka3; /* symbol as three letter names */
   extern char *nam_ka1; /* symbol as one letter names */

/* structure to contain information about window update */
   extern struct {
     int MainW;      /* Main window          */
     int LDPW;       /* Distance plot window */
     int Rama;       /* Ramachandran plot    */
     int Cluster;    /* Cluster plot         */
   } WUpdate;

      int rama_wind = 0; /* = 0 no display of Ramachandran plot , = 1 display */

/***************************************************************************/
pre_rama()
/***************************************************************************/
{
     sec_struct(1);
}

/***************************************************************************/
sec_struct(alt)
    int alt;
/***************************************************************************/
{
    static int i,j,chains;
    static int first,first_aa;
    static char chelp1[4];
    static char chelp2[4];
    static float angle;
    static int *gap_list;
    static char OutText[BUFF_LEN];

    if(mliste[0] < 1) {
    draw_obj_disp = 1;
    rama_wind = 0;
      PrintMessage("?ERROR - no atoms for secondary structure analyzis");
       return;}

/* check that this is a protein */

   first_aa = -1;
   for(i = mlists[0] ; i < mliste[0] ; i++) { 
            if((j = is_it_amin(resnam+4*i)) == 0) {
            first_aa = res1[i];
            break;}}

   if(j < 0) {
    draw_obj_disp = 1;
    rama_wind = 0;
   PrintMessage("?ERROR - this is most likely not a protein");
   return;}

/* check if there are several independent chains */
    gap_list   = ivector(maxres1 + 1);
    chains = same_chain(gap_list);
    if(chains > 0) {
    PrintMessage("I'm sorry but this does not work for a protein with independent chains");
    sprintf(OutText,"There are now '%d' chains ",(chains+1));
    PrintMessage(OutText);
    free(gap_list);
    draw_obj_disp = 1;
    rama_wind = 0;
    return;}
/* window control stuff */

     if(!WUpdate.Rama) return;

     if(OrderRAMAWindow(RAMA_PLOT)) {
        PrintMessage("?ERROR - in window handling in RAMA plot");
        return;}
/*......................*/
    

/* check first if there is already memory reserved */
   if(phi_e > 0) {
     phi_e = 0;
      free(phi_v);
       free(phi_i);}
    if(psi_e > 0) {
      psi_e = 0;
       free(psi_v);
        free(psi_i);}
    if(omega_e > 0) {
      omega_e = 0;
       free(omega_v);
        free(omega_i);
         free(resi_num);}

/* get space for the index arrays */
    phi_i      = ivector(MAX_ATM_NAME_LEN * (maxres1 + 1));    
     psi_i     = ivector(MAX_ATM_NAME_LEN * (maxres1 + 1));    
       omega_i = ivector(MAX_ATM_NAME_LEN * (maxres1 + 1));

    phi_v      =  vector(maxres1 + 1);
    psi_v      =  vector(maxres1 + 1);
    omega_v    =  vector(maxres1 + 1);
    resi_num   = ivector(maxres1 + 1);

    phi_e = 0;
     psi_e = 0;
      omega_e = 0;


    first = first_aa; /* first residue number */

/* find phi c */
    phi_e = 0;
    strncpy(chelp2,ppept_ang.phi,MAX_ATM_NAME_LEN);
    toller(chelp2);

    for(i = mlists[0] ; i < mliste[0] ; i++) {

       if(res1[i] == first) {
       strncpy(chelp1,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
       toller(chelp1);

          if(strncmp(chelp1,chelp2,MAX_ATM_NAME_LEN) == 0) {
          phi_i[MAX_ATM_NAME_LEN*phi_e] = i;
          phi_e++;
          if(phi_e > maxres1) {
             printf("?ERROR - reached limit for phi_e\n");
             return;}
          first++;}
        }
     }         
/* find phi n */
    phi_e = 0;
    first = first_aa + 1; /* first residue number */
    strncpy(chelp2,ppept_ang.phi+MAX_ATM_NAME_LEN,MAX_ATM_NAME_LEN);
    toller(chelp2);
    for(i = mlists[0] ; i < mliste[0] ; i++) {

       if(res1[i] == first) {
       strncpy(chelp1,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
       toller(chelp1);
          if(strncmp(chelp1,chelp2,MAX_ATM_NAME_LEN) == 0) {
          phi_i[MAX_ATM_NAME_LEN*phi_e + 1] = i;
          phi_e++;
          if(phi_e > maxres1) {
             printf("?ERROR - reached limit for phi_e\n");
             rama_wind = 0;
             return;}
          first++;}
        }
     }         
/* find phi ca*/
    phi_e = 0;
    first = first_aa + 1; /* first residue number */
    strncpy(chelp2,ppept_ang.phi+(2*MAX_ATM_NAME_LEN),MAX_ATM_NAME_LEN);
    toller(chelp2);
    for(i = mlists[0] ; i < mliste[0] ; i++) {

       if(res1[i] == first) {
       strncpy(chelp1,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
       toller(chelp1);
          if(strncmp(chelp1,chelp2,MAX_ATM_NAME_LEN) == 0) {
          phi_i[MAX_ATM_NAME_LEN*phi_e + 2] = i;
          phi_e++;
          if(phi_e > maxres1) {
             printf("?ERROR - reached limit for phi_e\n");
             rama_wind = 0;
             return;}
          first++;}
        }
     }         
/* find phi c */
    phi_e = 0;
    first = first_aa + 1; /* first residue number */
    strncpy(chelp2,ppept_ang.phi+(3*MAX_ATM_NAME_LEN),MAX_ATM_NAME_LEN);
    toller(chelp2);
    for(i = mlists[0] ; i < mliste[0] ; i++) {

       if(res1[i] == first) {
       strncpy(chelp1,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
       toller(chelp1);
          if(strncmp(chelp1,chelp2,MAX_ATM_NAME_LEN) == 0) {
          phi_i[MAX_ATM_NAME_LEN*phi_e + 3] = i;
          phi_e++;
          if(phi_e > maxres1) {
             printf("?ERROR - reached limit for phi_e\n");
             rama_wind = 0;
             return;}
          first++;}
        }
     }         

     for(i = 0 ; i < phi_e ; i++)  {
     dihed(phi_i[MAX_ATM_NAME_LEN*i],phi_i[MAX_ATM_NAME_LEN*i+1],phi_i[MAX_ATM_NAME_LEN*i+2],phi_i[MAX_ATM_NAME_LEN*i+3],&angle);
#ifdef DEBUG
     print_names(phi_i[MAX_ATM_NAME_LEN*i]);
     print_names(phi_i[MAX_ATM_NAME_LEN*i+1]);
     print_names(phi_i[MAX_ATM_NAME_LEN*i+2]);
     print_names(phi_i[MAX_ATM_NAME_LEN*i+3]);
     phi_v[i] = 180.*angle/pia;
     printf(" = %f \n",180.*angle/pia);
#endif
     phi_v[i] = 180.*angle/pia;
     }


    first = res1[0]; /* first residue number */

/* find psi n */
    psi_e = 0;
    first = first_aa; /* first residue number */
    strncpy(chelp2,ppept_ang.psi,MAX_ATM_NAME_LEN);
    toller(chelp2);

    for(i = mlists[0] ; i < mliste[0] ; i++) {

       if(res1[i] == first) {
       strncpy(chelp1,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
       toller(chelp1);

          if(strncmp(chelp1,chelp2,MAX_ATM_NAME_LEN) == 0) {
          resi_num[psi_e] = res1[i];
          psi_i[MAX_ATM_NAME_LEN*psi_e] = i;
          psi_e++;
          if(psi_e > maxres1) {
             printf("?ERROR - reached limit for psi_e\n");
             rama_wind = 0;
             return;}
          first++;}
        }
     }         
/* find psi ca */
    psi_e = 0;
    first = first_aa; /* first residue number */
    strncpy(chelp2,ppept_ang.psi+MAX_ATM_NAME_LEN,MAX_ATM_NAME_LEN);
    toller(chelp2);
    for(i = mlists[0] ; i < mliste[0] ; i++) {

       if(res1[i] == first) {
       strncpy(chelp1,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
       toller(chelp1);
          if(strncmp(chelp1,chelp2,MAX_ATM_NAME_LEN) == 0) {
          psi_i[MAX_ATM_NAME_LEN*psi_e + 1] = i;
          psi_e++;
          if(psi_e > maxres1) {
             PrintMessage("?ERROR - reached limit for psi_e");
             rama_wind = 0;
             return;}
          first++;}
        }
     }         
/* find psi c*/
    psi_e = 0;
    first = first_aa; /* first residue number */
    strncpy(chelp2,ppept_ang.psi+(2*MAX_ATM_NAME_LEN),MAX_ATM_NAME_LEN);
    toller(chelp2);
    for(i = mlists[0] ; i < mliste[0] ; i++) {

       if(res1[i] == first) {
       strncpy(chelp1,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
       toller(chelp1);
          if(strncmp(chelp1,chelp2,MAX_ATM_NAME_LEN) == 0) {
          psi_i[MAX_ATM_NAME_LEN*psi_e + 2] = i;
          psi_e++;
          if(psi_e > maxres1) {
             PrintMessage("?ERROR - reached limit for psi_e");
             rama_wind = 0;
             return;}
          first++;}
        }
     }         
/* find psi n */
    psi_e = 0;
    first = first_aa + 1; /* first residue number */
    strncpy(chelp2,ppept_ang.psi+(3*MAX_ATM_NAME_LEN),MAX_ATM_NAME_LEN);
    toller(chelp2);
    for(i = mlists[0] ; i < mliste[0] ; i++) {

       if(res1[i] == first) {
       strncpy(chelp1,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
       toller(chelp1);
          if(strncmp(chelp1,chelp2,MAX_ATM_NAME_LEN) == 0) {
          psi_i[MAX_ATM_NAME_LEN*psi_e + 3] = i;
          psi_e++;
          if(psi_e > maxres1) {
             PrintMessage("?ERROR - reached limit for psi_e");
             rama_wind = 0;
             return;}
          first++;}
        }
     }         

     for(i = 0 ; i < psi_e ; i++)  {
     dihed(psi_i[MAX_ATM_NAME_LEN*i],psi_i[MAX_ATM_NAME_LEN*i+1],psi_i[MAX_ATM_NAME_LEN*i+2],psi_i[MAX_ATM_NAME_LEN*i+3],&angle);

#ifdef DEBUG
     print_names(psi_i[MAX_ATM_NAME_LEN*i]);
     print_names(psi_i[MAX_ATM_NAME_LEN*i+1]);
     print_names(psi_i[MAX_ATM_NAME_LEN*i+2]);
     print_names(psi_i[MAX_ATM_NAME_LEN*i+3]);
     psi_v[i] = 180.*angle/pia;
     printf(" = %f\n",180.*angle/pia);
#endif
     psi_v[i] = 180.*angle/pia;
     }

    first = first_aa; /* first residue number */

/* find omega ca */
    omega_e = 0;
    strncpy(chelp2,ppept_ang.omega,MAX_ATM_NAME_LEN);
    toller(chelp2);

    for(i = mlists[0] ; i < mliste[0] ; i++) {

       if(res1[i] == first) {
       strncpy(chelp1,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
       toller(chelp1);

          if(strncmp(chelp1,chelp2,2) == 0) {
          omega_i[MAX_ATM_NAME_LEN*omega_e] = i;
          omega_e++;
          if(omega_e > maxres1) {
             PrintMessage("?ERROR - reached limit for omega_e");
             rama_wind = 0;
             return;}
          first++;}
        }
     }         
/* find omega c */
    omega_e = 0;
    first = first_aa; /* first residue number */
    strncpy(chelp2,ppept_ang.omega+MAX_ATM_NAME_LEN,MAX_ATM_NAME_LEN);
    toller(chelp2);
    for(i = mlists[0] ; i < mliste[0] ; i++) {

       if(res1[i] == first) {
       strncpy(chelp1,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
       toller(chelp1);
          if(strncmp(chelp1,chelp2,MAX_ATM_NAME_LEN) == 0) {
          omega_i[MAX_ATM_NAME_LEN*omega_e + 1] = i;
          omega_e++;
          if(omega_e > maxres1) {
             PrintMessage("?ERROR - reached limit for omega_e");
             rama_wind = 0;
             return;}
          first++;}
        }
     }         
/* find omega n*/
    omega_e = 0;
    first = first_aa + 1; /* first residue number */
    strncpy(chelp2,ppept_ang.omega+(2*MAX_ATM_NAME_LEN),MAX_ATM_NAME_LEN);
    toller(chelp2);
    for(i = mlists[0] ; i < mliste[0] ; i++) {

       if(res1[i] == first) {
       strncpy(chelp1,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
       toller(chelp1);
          if(strncmp(chelp1,chelp2,MAX_ATM_NAME_LEN) == 0) {
          omega_i[MAX_ATM_NAME_LEN*omega_e + 2] = i;
          omega_e++;
          if(omega_e > maxres1) {
             PrintMessage("?ERROR - reached limit for omega_e");
             rama_wind = 0;
             return;}
          first++;}
        }
     }         
/* find omega ca */
    omega_e = 0;
    first = first_aa + 1; /* first residue number */
    strncpy(chelp2,ppept_ang.omega+(3*MAX_ATM_NAME_LEN),MAX_ATM_NAME_LEN);
    toller(chelp2);
    for(i = mlists[0] ; i < mliste[0] ; i++) {

       if(res1[i] == first) {
       strncpy(chelp1,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
       toller(chelp1);
          if(strncmp(chelp1,chelp2,MAX_ATM_NAME_LEN) == 0) {
          omega_i[MAX_ATM_NAME_LEN*omega_e + 3] = i;
          omega_e++;
          if(omega_e > maxres1) {
             PrintMessage("?ERROR - reached limit for omega_e");
             rama_wind = 0;
             return;}
          first++;}
        }
     }         

     for(i = 0 ; i < omega_e ; i++)  {
     dihed(omega_i[MAX_ATM_NAME_LEN*i],omega_i[MAX_ATM_NAME_LEN*i+1],omega_i[MAX_ATM_NAME_LEN*i+2],omega_i[MAX_ATM_NAME_LEN*i+3],&angle);

#ifdef DEBUG
     print_names(omega_i[MAX_ATM_NAME_LEN*i]);
     print_names(omega_i[MAX_ATM_NAME_LEN*i+1]);
     print_names(omega_i[MAX_ATM_NAME_LEN*i+2]);
     print_names(omega_i[MAX_ATM_NAME_LEN*i+3]);
     omega_v[i] = 180.*angle/pia;
     printf(" = %f\n",180.*angle/pia);
#endif
     omega_v[i] = 180.*angle/pia;
     }

     if(phi_e == 0 || psi_e == 0 || omega_e == 0) { /* probably not a protein*/
       PrintMessage(
        "?ERROR - can't find needed atoms (This is not a protein?)");
               rama_wind = 0;
               draw_obj_disp = 1;
       return;}

     if(alt == 2) { /* colour by secondary structure */
                    color_by_sec(omega_e,phi_v,psi_v);
		  }

     if(alt == 1) {
         if(term_type == 1 || term_type == 3) {
               plot_rama(omega_e,phi_v,psi_v,res1[0] , (res1[0] + 1), resi_num);
         }
     }

      if(UsingMultiWindowing()) {
         ScareSwapbuffers();
         winset(GetMainWindowID());}
}

/***************************************************************************/
color_by_sec(num,phi_v,psi_v)
            int num;
            float *phi_v;
            float *psi_v;
/***************************************************************************/
{
    int i,j;

    for(i = 0 ; i < num-1 ; i++) {

       for(j = 0 ; j < pp_loop ; j++) {

/*
       printf(" %d: %f %f %f %f \n",i+1,phi_v[i],ppept_conf[j].phi,psi_v[i+1],ppept_conf[j].psi);
*/
       if((Rabs(phi_v[i] - ppept_conf[j].phi) < ppept_conf[j].delta) &&
          (Rabs(psi_v[i+1] - ppept_conf[j].psi) < ppept_conf[j].delta)) {

          printf(" '%s' \n",ppept_conf[j].color);}}
     }
}

/***************************************************************************/
int is_it_amin(text)   /* checks to see if name in text is an amino acid */
          char *text;  /* on return 0 = yes it is , < 0 it is not        */
/***************************************************************************/
{

   int i;
   char ctemp[MAX_RES_NAME_LEN];

   strncpy(ctemp,text,MAX_RES_NAME_LEN);
   tupper(ctemp);

   for(i = 0 ; i < num_ka ; i++) {
       if(strncmp(ctemp,nam_ka3+MAX_ATM_NAME_LEN*i,3) == 0) return(0);
     }

   return(-1);
}
/***************************************************************************/
int same_chain(gap_list)
         int  *gap_list;
/***************************************************************************/
{
    int i,j,k,alpha_c,its_gap,*alpha_list;
    float dist,dx,dy,dz;
    char ctemp[MAX_ATM_NAME_LEN];

/* go and hunt for the alpha carbons */
    alpha_c = 0;

/* always just for the first molecule */
  alpha_list = ivector(mliste[0]);
  for( i = mlists[0] ; i < mliste[0] ; i++) {
  strncpy(ctemp,atnam+MAX_ATM_NAME_LEN*i,MAX_ATM_NAME_LEN);
  tupper(ctemp);
  if(strncmp(ctemp,"CA",2) == 0) {
   alpha_list[alpha_c] = i;
   alpha_c++;
  }}

    gap_list[0] = 0;
    its_gap = 0;

    for( i = 1 ; i < alpha_c ; i++) {
     j = alpha_list[i];
      k = alpha_list[i-1];
       gap_list[i]=0;
    dx = (x[j]-x[k]);
    dy = (y[j]-y[k]);
    dz = (z[j]-z[k]);
     dist=dx * dx + dy * dy + dz * dz;

    if(dist > GAP_dist ) { 
    its_gap++;
    gap_list[its_gap]= res1[i] ; } 
    } 

  free(alpha_list);
  return(its_gap);
}
