
#define  SCARE_VERSION "Version 1.6 (r 931206)"

/*

                       Copyright (c) 1991, 1992, 1993 by:
        Leif Laaksonen , Centre for Scientific Computing , ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved

*/

/*
**
**   This program is usefull in analyzing molecular dynamics trajectories.
**   At the moment it is made to analyze CHARMM, DISCOVER, YASP, AMBER, 
**   GROMOS, HyperChem and MUMOD trajectories but other MD programs can 
**   easily be interfaced.
**
**   Molecules can now be displayed as balls and sticks, liquorice or CPK
**   Some surface generation possibilities have been added.
**   Interface to ICON8, VSS, PROBSURF and DENSITY has also been added.
**
**
**   Leif Laaksonen, December 1993
**
**   Center for Scientific Computing
**   P.O.Box 405
**   FIN-02101 Espoo
**   FINLAND
**
**   Mail: Leif.Laaksonen@csc.fi


     The proper reference to this program is:

     L. Laaksonen, J. Mol. Graph. 10 (1992) 33
 
*/

/*
     Additions worth mentioning:

     Version 1.6  *********************************************************

     1993-12-09:  There is now a REAL stereo option available. It is proved
                  to work with the StereoView glasses but MIGHT even work
                  with other stereo devices but I have not tried. The 
                  stereo mode has to be supported (of course) on your
                  SGI machine. However, I don't know on which SGI machines
                  it is not supported. To put stereo mode on use the
                  command "set stereo on". To get off the stereo mode press
                  the escape key.

                  It is now possible to deal with a defined set of frames
                  in your trajectory file. The command "set trajectory
                  limits first last step" defines the frames to deal with.

                  I have included a primitive way of clustering the 
                  trajectory conformations. The command "calculate
                  cluster seg1:res1:atm1 [seg2:res2:atm2]" calculates
                  the root mean square deviation (RMSD) matrix for the
                  defined atom sets for the defined frames. This can
                  shown with the command "plot cluster". This matrix
                  can be saved to disk or read from disk with the
                  commands "read cluster data data.file" and "write
                  cluster data data.file". For details about the
                  superimposing of the defined atoms see the quatfit.c
                  file.

                  A very crude facility has been added to be able to
                  translate and rotate a molecule or a part of a 
                  molecule. First use the command "define atom
                  selection seg:res:atm" to define the atoms which
                  will be manipulated. If you press key 5 in the
                  numeric keypad while you do the normal rotation or
                  translation this action applies only to the
                  the selected atoms and the rest of the system is
                  not affected. This will later be used extensively
                  to prepare input to various programs. Stay tuned!
                  It is worth remembering that this option changes
                  the value of the coordinates (this does not go
                  through the rotation matrix) so it is not 
                  possible to use this for surface display (the
                  surface will be placed on a different place than the
                  atoms. I will implement this in a more clever way
                  when I have the time.
*/
                  


#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <malloc.h>
#include <math.h>
#include <errno.h>
#include <ctype.h>
#include <signal.h>
#ifdef sgi
#include <sys/wait.h>
#endif
#include <setjmp.h>

#ifdef sgi
#include <gl/gl.h>
#include <device.h>
#include <gl/sphere.h>
#endif

#if defined(USEFORMS) && defined(sgi)
#include "../forms/FORMS/forms.h"
#endif

#include "maxdefs.h"

/* define the graphics window for video recording */
#define VIDEO_x1       80
#define VIDEO_x2      660
#define VIDEO_y1        0
#define VIDEO_y2      580

/* define the graphics window for the demo */
#ifdef  INDIGO_ENTRY
#define DEMO_x1        50
#define DEMO_x2       780
#define DEMO_y1        10
#define DEMO_y2       740
#else
#define DEMO_x1       150
#define DEMO_x2      1150
#define DEMO_y1        10
#define DEMO_y2      1010
#endif

#define ROTATE(a,b)      rotateO(a,b)      /* use own rotation function    */
#define TRANSLATE(a,b,c) translateO(a,b,c) /* use own translation function */
#define TRANSLATE_SELECTION(a,b,c) TranslateCoordinatesX(a,b,c)
                                           /* translate a selction         */
#define ROTATE_SELECTION(a , b)    RotateCoordinates1X(a , b)
                                           /* rotate a selection           */
#define SCALE(a,b,c)     scaleO(a,b,c)     /* use own scale function       */
#define STRTOK(a,b)      own_strtok(a,b)

#define LOGFILE "SCARECROW.LOG"
#define STREAMER_DATA_FILE "streamer.data"

#ifdef sgi

#define MOUSEX_NOISE_LIMIT  5
#define MOUSEY_NOISE_LIMIT  5

#define SURFACE_DEF()     {  mmode(MVIEWING);\
                             MakeOrtho();\
                             def_simple_light_calc();\
                             use_simple_light_calc();}

#define NO_SURFACE()      {  getmatrix(rotM);\
                             mmode(MSINGLE);\
                             MakeOrtho();\
                             loadmatrix(rotM);}

#define CHANGE_COLOR(i)   {  if(CurMaterial == 22) {\
                             lmcolor(LMC_DIFFUSE);\
                             RGBcolor((short)atmcol[i][0],\
                                      (short)atmcol[i][1],\
                                      (short)atmcol[i][2]);\
                             lmcolor(LMC_COLOR);}}
#endif

#define MAX(a,b)  ( ( a ) > (b) ? (a) : (b))
#define MIN(a,b)  ( ( a ) < (b) ? (a) : (b))
#define Rabs(a)    ( ( a ) > 0.0 ? (a) : -(a))
#define Iabs(a)    ( ( a ) > 0   ? (a) : -(a))

#define SHOW_TEXT_SERIES()       { sprintf(text,"*%d*",(l+1));  \
                    retv = show_text(text,txt_param.txfont,txt_param.txcolor,\
                             txt_param.txtsize, \
                             0.92 , 0.53 , BACKBUFFER);}

/* externals  */

#if defined(USEFORMS) && defined(sgi)
extern void SetUpContour();
extern int ShowFormMask();
Show_Form_StereoMode();
#endif

extern void qcomm();
extern int RunFKey();
extern void get_wall_secs();
extern void pre_read_karp();
extern void pre_read_pdb();
extern int show_text();
extern void ResetView();
extern int read_col_tbl();
extern int Show_Edit_Colour();
extern int calc_neigh;
extern int keyb_command;
extern int atom_list_max();
extern int read_traj_yasp();
extern int show_text();
extern int read_et();
extern void PrintMessage();
extern void init_cursors();
extern void sel_struct();
extern int set_traj_type();
extern void SetLineWidth();
extern float find_vdwrad();
extern void  MakeOrtho();
extern int TellBytes();
extern int ShowReadDict();
extern void edit_text();
extern int TrajAnalysisPointers();
extern char *own_strtok();
extern int PushToWindowStack(long window_id , int plot_type);
extern int DeleteFromWindowStack(long window_id);
extern int DeleteWindowStack();
extern int OpenWindows();
extern int ShouldIDrawObject();
extern long GetMainWindowID();
extern void HandleWinShut(long WinId);
extern void DisableMultiWindow();
extern int  WhichWindowToUpdate(int WinId);
extern int  HandleInputChange(int Window);
extern int  UpdateAllOpenWindows();
extern int  TrajectoryLastFrame();
extern int  TrajectoryFirstFrame();
extern int  TrajectoryStepFrame();
extern int  DeleteTrajectoryInfo();
extern int  IsStereoOn();
extern int  SetRealStereoOFF();
extern  int ADDdistStereo(float a);
extern  int SUBdistStereo(float a);
extern  int ADDeyeStereo(float a);
extern  int SUBeyeStereo(float a);
extern  int SelectionListInUse();
extern  int RotateCoordinates1X(float Crot , char Caxis);
extern  int TranslateCoordinatesX(float a, float b, float c);
extern  int PlotDistObj();
extern  int PlotAngleObj();
extern  int PlotTorsionObj();
extern  int  UsingMultiWindowing();


extern int trace_wind; /* = 0 no display , = 1 display on */
extern int display_text; /* display text if > 0 */
extern char prompt[];
extern int colour_structure_by    ; /* = 0 , normal colouring
                                       = 1 , by frame total energy
                                       = 2 , by frame kinetic energy
                                       = 3 , by frame potential energy
                                       = 4 , by frame temperature 
                                    */
extern int ldp_wind;
extern int rama_wind;
extern int cluster_wind;
extern int b_disp_a;
extern jmp_buf jumper;
extern char *find_atype();
extern float GetXCoord();
extern float GetYCoord();
extern float GetZCoord();
extern int GetResNum1();
extern char *GetSegName();
extern char *GetResName();
extern char *GetAtmName();
extern int GetLastFrame();
extern int PutLastFrame();
extern int GetFirstFrame();
extern int PutFirstFrame();
extern int GetStepFrame();
extern int PutStepFrame();
extern int GetNumFrames();
extern int ShowFrameStat();
extern int ResetFrame();
extern int CheckFrames();
extern int ShuffleTrajectoryLimits();


    extern int AutoScreenBlank;     /* != 0 do always screenblank between
                                            frames
                                       == 0 no screenblank between frames */

    extern struct {
      int PlotDist;
      int PlotAng;
      int PlotTors;
	 } PlotVariables;


    extern struct {
      int  OnOff;
      float Xsize;
      float Ysize;
      float Zsize;
      float Xplace;
      float Yplace;
      float Zplace;
    } BoxInfo;

    extern struct {
    int plot_color_scale; /* = 0 , off , != 0 on */
    int which_plot;       /* = 0 no plot,
                               1 force plot,
                               2 energy scale
                          */
    int num_level; /* number of colour scales */ 
                  } scale_plot;

/* save command line parameters */
    struct {
      int   argc;
      char **argv;
    } ComLinePars;

   struct {
    int   tote_set;
    int   kine_set;
    int   pote_set;
    int   temp_set;
    int   bond_set;
    int   angl_set;
    int   dihe_set;
    int   impr_set;
    int   vdw_set;
    int   elec_set;
    int   hbond_set;
    int   charm_set;
   float min_tote;
   float max_tote;
   float min_kine;
   float max_kine;
   float min_pote;
   float max_pote;
   float min_temp;
   float max_temp;
   float min_bond;
   float max_bond;
   float min_angl;
   float max_angl;
   float min_dihe;
   float max_dihe;
   float min_impr;
   float max_impr;
   float min_vdw;
   float max_vdw;
   float min_elec;
   float max_elec;
   float min_hbond;
   float max_hbond;
   float min_charm;
   float max_charm; } traj_energy_limits = { 
   0,0,0,0,0,0,0,0,0,0,0,0,
   0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,
   0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};

    struct SimCryst {
    double xtlabc[6];} ShapeIndex;

    extern struct {
         int Set;         /* =  0 , not set, != 0 set              */
         int FirstFrame;  /* first frame in trajectory to be displ */
         int LastFrame;   /* last          -"-                     */
         int StepFrame;   /* step to be used                       */
                  } TrajFrame;

    extern struct LineSeg {
      int    Show;           /* if != 0 show the lines     */
      int    Lines;          /* number of lines            */
      float *LineCoord;      /* pointer to the coordinates */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
    } PlotLine;

    extern struct SphereSeg {
      int    Show;             /* if != 0 show the sphere      */
      int    Spheres;          /* number of spheres            */
      float *SphereCoord;      /* pointer to the coordinates   */
      float *Radius;           /* pointer to sphere radius     */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
      float  Alpha;
    } PlotSphere;

    extern struct PlaneSeg {
      int    Show;             /* if != 0 show the plane       */
      int    Planes;           /* number of planes             */
      float *PlaneCoord;       /* pointer to the coordinates   */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
      float  Alpha;
    } PlotPlane;

    extern struct CylinderSeg {
      int    Show;           /* if != 0 show the cylinders       */
      int    Cylinders;          /* number of cylinders          */
      float *CylinderCoord;      /* pointer to the coordinates   */
      float *CylinderRad;        /* cylinder radius              */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
      float  Alpha;
    } PlotCylinder;

/* pointers for force calculation */

     extern struct force_struct {
     int    set;  /* switch if the forces are set = 0 , not != 0, yes */
     int   plot;  /* switch for a plot = 0 , no plot , != 0 a plot */
     float  *fx;  /* pointers to the forces */
     float  *fy;
     float  *fz;
     int *sel_list; /* selection list */
     int  ent_list; /* entries in the selection list */
     float scale; /* scale factor */
     int   maxfi; /* index of max force atom */
     float maxfa; /* value of the max force  */
     int   minfi; /* index on min force atom */
     float minfa; /* value of the min force  */ } atm_force; 

     extern int CurMaterial;

    extern struct {                 
                    /* coordinate manipulation at read coordinates */
     int AtomCent;
           } CoordMani;

/* contour structure */
     extern int    ContoursDefined;   /* number of contours defined */

     extern struct Contour_Struct {
     float *data;           /* contour data */
     float min;
     float max;
     int xdim;
     int ydim;
     int zdim;
     float Xtrans;
     float Ytrans;
     float Ztrans;
     float Xscale;
     float Yscale;
     float Zscale;
     float ColVal[MAX_CONT];
     int   NumVal;
     char  ColNam[MAX_CONT][BUFF_LEN];
     char  ContFile[BUFF_LEN];
     float AlphaBlend;
     int   ContSmooth;
     char  Name[BUFF_LEN];
     int   Display;} ContourInfo[MAX_CONTOURS];

     extern struct StreamST {
     char CHARMM[BUFF_LEN];
     char VSS[BUFF_LEN];
     char ICON8[BUFF_LEN];
     char PROBESURF[BUFF_LEN];
     char DENSITY[BUFF_LEN];};

     extern struct StreamST StreamerInfo;

     extern  struct {
       int    Mean;                   /* != 0 average is calulated  */
       int    Plot;                   /* != 0 plot is on            */
       int    Set;                    /* != 0 collection is on      */
       int    Numbers;                /* number of observations     */
       float *XValues;                /* X - pointer to values      */
       float *YValues;                /* Y - pointer to values      */
     } RaDiFu;

    extern struct {
      int NumCurves;
      int Step;
      int *NumObs;
      float *Xvalues;
      float *Yvalues;
      float *Zvalues;} PlotCurves;

/* structure to contain info about start up window */
      extern struct {
         int X;
         int Y;
         int XW;
         int YW;
         int Set; } StartWindow;

       extern struct {
         float Angle;       /* rotation angle */
         float Translate;   /* translation from the centre */
         int   Active;      /* == 0 off , != 0 on */
         int   Set;         /* == 0 reset , != do not reset */
                  } StereoPlot;


     extern struct {
        int CalcConn; } Connect;

     struct {                /* structure to handle error situations */
     int ERRORcode;} Problems;

     struct {                /* text structure for dyna display */
      float XC;
      float YC;
      int   Display;
      char  TString[BUFF_LEN]; } Text_Disp = { 0.0 , 0.0 , 0 , "\0"};

/* declare functions */

void draw_obj();
void rotateO();
void print_obj();
void draw_cube();
void DrawBox();
void bang_it();
char *cvector();
float *vector();
double *dvector();
int *ivector();
short *svector();
void plot_stick();
void licorice();
void stick_alpha();
void plot_cpk();
int  test_queue();
int  ReadCommandStack();
int  SaveCommandStack();
int  GetStartUpWindow();
void GetSIGUSR2();

/* end of declaration */


/* B A N N E R                              */

char *Banner = "\n\n\
    *****************************************************************\n\
    *                                                               *\n\
    *           * * * * *  S C A R E C R O W  * * * * *             *\n\
    *                                                               *\n\
    *   Molecular Dynamics trajectory display and analysis program  *\n\
    *                                                               *\n\
    *   COPYRIGHT (C) Leif Laaksonen (1991, 1992, 1993)             *\n\
    *                                                               *\n\
    *   Version 1.6   (r. 931217)                                   *\n\
    *                                                               *\n\
    *****************************************************************\n\n";

char *usage = "\n\
  *******************************************************************\n\
  *                                                                 *\n\
  *  Help page to get you off the ground.                           *\n\
  *                                                                 *\n\
  *  Following options allowed on the command line:                 *\n\
  *                                                                 *\n\
  *  dynal -ainteger -ifile.name -s -v -h -t -ln -pfile.name        *\n\
  *                                                                 *\n\
  *  -ainteger changes the maximum number of atoms to 'integer'     *\n\
  *  -ifile.name the program is driven from file 'file.name'        *\n\
  *  -s the program wakes up as a server (not yet working)          *\n\
  *  -v enable the video option                                     *\n\
  *  -pfile.name start SCARECROW with parameter file 'file.param'   *\n\
  *  -t start SCARECROW without any graphics                        *\n\
  *  -ln do not write a log file  (SCARECROW.LOG)                   *\n\
  *  -ly force the write of the log file (SCARECROW.LOG)            *\n\
  *  -h print this help                                             *\n\
  *                                                                 *\n\
  *******************************************************************";

/*  debug structure */
    struct {
    int DebugL;} DebugS = { 0 };

/*  MAGIC structure */
    struct {
    int level;}  Magic = { 0 };

/*  cell dimensions */
    struct cell_dim {
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;
    float Xtrans;
    float Ytrans;
    float Ztrans;};
    
    struct cell_dim cell;

/*  Symmetric shape index data for a Crystal/Constant pressure calculation */
    struct sym_shape {
     float xtlabc[6];};       /* lower triangle is used */

    struct sym_shape SymShapeMat;

/* structur containing pointers to dynamics display variables */
    struct dyna_disp_var {
      int numset;             /* number of sets (or variables) */
      int current_set;        /* index to current set          */
      int point_len;          /* length of point array         */
      int *point_vec;         /* pointer to point array        */
      int dist_len;           /* length of dist array          */
      int *dist_vec;          /* pointer to dist array         */
      int ang_len;            /* length of angle array         */
      int *ang_vec;           /* pointer to angle array        */
      int tors_len;           /* length of torsion array       */
      int *tors_vec;          /* pointer to torsion array      */
      int obs_vec_len;        /* observation array length      */
      int obs_vec_curr;       /* display current               */
      float *obs_vec;};       /* pointer to observation array  */

    struct dyna_disp_var play_dynam_frames;

/* structure for the dynamics trajectory file */

   struct {
   char traj_file[BUFF_LEN];                 /* file name          */
   int natom;                                /* number of atoms    */
   int nstep;                                /* number of steps    */
   int time_bw_steps;                        /* time between steps */
   int time_first_frame;                     /* time of first frame */
   int first_frame;                          /* first frame to be displayed */
   int last_frame;                           /* last frame to be displayed  */
   int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

   float AUtoA = 0.529167;   /* conversion atomic units to A */

/* terminal */
   char which_term[BUFF_LEN];     /* string to hold the terminal type     */
   int  term_type = 0;       /* integer which tells which kind of terminal
                                the user is using:
                                = 0 ; terminal undefined
                                  1 ; iris- type
                                  2 ; vt100
                                  3 ; input from file with graphics
                                  4 ; input from file without graphics
                                  5 ; running in server mode 
                             */
   int yes_no_graph = 0;       /* switch for controling if a command given
                                  from keyboard should be hooked to graphics */

   int server_mode = 0;      /* = 0 normal session , = 1 run in server mode */

   int video_mode = 0;       /* = 0 normal , = 1 video mode on */

   char input_from_file[BUFF_LEN]; /* file name if the commands are read from a
                                      file instead of the mouse/keyboard */

   char scr_data[BUFF_LEN]; /* path to the directory where the data stuff is */
   char scr_bin[BUFF_LEN];  /* path to the scarecrow bin directory           */
   char home_path[BUFF_LEN]; /* home path */

/* names of start up files  ................................................*/
   char scare_start[BUFF_LEN] = ".scarecrow";
                                      /*  Scarecrow start up file           */
   char atom_param[BUFF_LEN] = "atom_param.par";
                                      /*  Atom parameter file               */
   char scare_param[BUFF_LEN] = "scare_param.par";
                                      /*  Scarecrow parameter file          */

   char col_table_name[BUFF_LEN] = "colour.tbl";
/*..........................................................................*/

   char *module_name;          /* pointer to program name                   */

   int numat;                  /*  Number of atoms                          */
   int MAXatom = MAXatm;       /*  the real maximum number of atoms the
                                   programs is able to deal with            */
   float *x,*y,*z,*bvalue;     /*  x,y and z values and bvalue              */
   int *res1,*res2;            /*  array for the residue 1 and 2 in charmm
                                   files                                    */
   char  *resnam,*atnam,*segment; 
                               /* residue name , atom name and segment 
                                  names                                     */
   float *atm_charge;        /* atom charge                                 */
   int   *atm_type;          /* atom type in the working force field        */
   int maxres1,maxres2;      /*  highest residue 1 and 2 numbers            */
   int minres1,minres2;      /*  lowest  residue 1 and 2 numbers            */
   int   ca_num;             /*  number of alpha carbons                    */
   int  *ca_list;            /*  list of alpha carbons                      */
   char *ca_disp_list;       /*  alpha carbon display list                  */
   int   MAXca;              /*  maximum numbers of alpha-carbons           */
   char *disp_list;          /*  display list                               */
   int   label_deep = 0;     /*  number of labels to be displayed           */
   char *label_list;         /*  label list off = 0 , on > 0                */
   char *gap_vec;            /*  keeps track of "gaps" = different chains   */
   int   gap_loop=0;         /*  number of gaps                             */
   int   alpha_trace=0;      /*  switch for the on/off of the alpha trace
                                 display                                    */
   int dampfn = 1;           /*  display only every dampfn frame            */
   float *xcomp;             /*  comparison data set (working array)        */
   float *ycomp;
   float *zcomp;
   float mx[MAXmom],my[MAXmom],mz[MAXmom]; /* vector for moments            */

/* This is now basicly used for the differen trajectory formats             */
   int   force_type = 0;     /* type of force field
                                = 0 , undefined
                                = 1 , CHARMM
                                = 2 , DISCOVER
                                = 3 , AMBER 
                                = 4 , YASP 
                                = 5 , MUMOD
                                = 6 , GROMOS
                                = 7 , HyperChem     */
/*..........................................................................*/
   int   dic_read=0;         /* = 0 no dictionary read and if > 0 dic is 
                                read */
   char  dic_file[BUFF_LEN]; /* name of dictionary file                     */
   float sumx,sumy,sumz;     /* the shift in the coordinates to get molecule
                                in centre of the screen                     */
   int liq_surf=0;         

   int surf_style=0;     /*  parameter for surface style 0 = vdW
                                                         1 = covalent radius */

   int  sphere_seg=10;   /*  A sphere is divided in 10 segments (20 segments
                              for the other angle                           */

   int  cyl_seg=20;      /*  A cylinder is divided in 20 segments           */

   int sphere_array[Sphere_max]; /* an array to contain the precalculated
                                   j index in the sphere matrix  */
   float vsphe[MAXsphp][3],vspher[4][3];

   float vcylinder[MAXcylp][3];

   float *vdw_list;           /* van der Waals radius list           */

   float *corad;              /* covalent radius list                */

   float liq_rads = 0.3;        /* radius of liquorice sphere          */

   float liq_radc = 0.3;        /* radius of liquorice cylinder        */

   float *cpk_scale;        /* scale factor for scaling the cpk display */

   int yn_surf=0;             /* yn_surf = 0 no surface , = 1 surface */

   float pia;                 /* value for pi                        */

   float pia1800;             /* value pi/1800. value is needed in rotate */

   float Piper180;            /* value pi/180                              */

   float THRSH=3.5 , cnv;
   int **cnct;


   int dev = 0,xval = 0,yval = 0;
   int xc,yc,xc1=0,xc2=0,yc1=0,yc2=0,dxc,dyc;
   long xsize,ysize,xorg,yorg;
   long win_ids[10];         /* array to contain window id-number */
   int winnr=0;              /* string to contain the number of open windows */
   short val,BOX=0;
   float minx=0.0,maxx = 1.0,
         miny=0.0,maxy = 1.0,
         minz=0.0,maxz = 1.0,
         near=0.0,far=1.0;

/* molecule lists */
   int current_struct = 0;/* molecule to be displayed */
   int mlist_deep=0;      /* stack number indicator */
   int mlists[MAX_MLIST]; /* First index for molecule list */
   int mliste[MAX_MLIST]; /* Second index for molecule list */
   char mnlist[MAX_MLIST][BUFF_LEN]; /* name list for molecule file names */

/* structure to contain pointers to parsed strings */
   struct Pinfo {
     int num;    /* number of parsed strings in the input string */
     int Return; /* = 0 ok , <> 0 ERROR                          */ 
     char *Point[MAXparse];}   /* pointer to the strings */ 
   ParseInfo;

   char parsed[MAXparse][MAXlinel];
   char input_file[BUFF_LEN];           /* name of molecule file */
   int  input_file_set = 0;        /* switch for input file set/not set */

   float damp = 1.0;

   float rotM[4][4];  /*  rotation matrix supplied by user  */
   float rotS[4][4];  /*  rotation matrix from stack        */
   float rotB[4][4];
   float rotL[4][4];  /*  this is used for the shading (keep light fixed) */
   float idmat[4][4] = { 1.0 , 0.0 , 0.0 , 0.0 ,
                         0.0 , 1.0 , 0.0 , 0.0 ,
                         0.0 , 0.0 , 1.0 , 0.0 ,
                         0.0 , 0.0 , 0.0 , 1.0};

   float xycoor[4][4];

   float idmat3[3][3] = { 1.0 , 0.0 , 0.0 ,
                          0.0 , 1.0 , 0.0 ,
                          0.0 , 0.0 , 1.0 }; 

   struct ManMatrix {
     float Rot[3][3];
     float Trans[3];
     float Scale[3];} OwnManMtx;

   struct TrackRMat { /* all objects have their own rotate matrix */
     int   Numbers;
     float Rotate[4][4];} *RotaMat;

   struct  param_struct {

    int     type;
    float   bndrad;
    float   vdwrad;
    float   plurad;
    char    global;
    float   emin;
    float   rmin;
    float   patom;
    float   mass;
    int     cnct;
    char    hbond;
    char    atype[4];} ;

int param203_terms;              /* terms in the parameters list */

struct param_struct param203[MAXatc];

struct own_struct {
 
    int  entry;
    char water[MAX_RES_NAME_LEN*MAXwater];
    int  colour[MAXwater][3]; }; 
    
struct own_struct   own_param;

struct secang {

    char phi[16];  /* space for 4 * 4 characters */
    char psi[16];
    char omega[16];};

struct secang ppept_ang;

struct pconf {

     char name[10];  /* name of conformation */
     float phi;      /* phi angle            */
     float psi;      /* psi angle            */
     float omega;    /* omega angle          */
     float rpt;      /* residues per turn    */
     float tpr;      /* translation per residue */
     float delta;    /* allowed deviation for angles */
     char color[BUFF_LEN];}; /* colour conformation with */

#define MAXppconf 10   /* maximum number of ppconf entries */
struct pconf ppept_conf[MAXppconf];

int pp_loop;           /* keeps track of how many motifs are defined */

/*  Colour definitions                        */

   short BLACKv[3]={0 , 0, 0};   /* black */
   short REDv[3]=  { 255 , 0 , 0};  /* red      */
   short GREENv[3]={0 , 255 , 0};   /* green  */
   short YELLOWv[3]={ 255 , 255 , 0};  /* yellow */
   short BLUEv[3]= {0 , 0 , 255};      /* blue  */
   short MAGENTAv[3]={ 255 , 0 , 255}; /* magenta   */
   short CYANv[3]={0 , 255 , 255};     /* cyan    */
   short WHITEv[3]={255 , 255 , 255};  /* white   */

   int atm_col_num = 0;
   char def_atm_col[MAX_ATM_NAME_LEN*MAXcat] = 
   {"H???C???N???O???S???P???Na??Cl??Ca??Si??Sn??"};
   int def_acol[MAXcat][3] =  {{ 255 , 255 , 255 } , /* hydrogen */
                               {   0 , 255 ,   0 } , /* carbon   */
                               {   0 ,   0 , 255 } , /* nitrogen */
                               { 255 ,   0 ,   0 } , /* oxygen   */
                               { 255 , 255 ,   0 } , /* sulphur  */
                               { 255 , 255 ,   0 } , /* phosphore  */
                               {   0 ,   0 , 255 } , /* Sodium   */
                               { 255 ,   0 , 255 } , /* Chlorine */
			       { 255 ,   0 , 255 } , /* Calcium  */
			       { 255 ,   0 , 255 } , /* Silicon  */
			       { 255 ,   0 , 255 }}; /* Tin      */

  short bgcolor[3] = { 0 , 0 , 0 }; /* background color default black */
  short txcolor[3] = { 255 , 255 , 255 }; /* text colour , default white */
  short obcolor[3] = { 255 ,   0 , 255 }; /* object colour , default magenta */

   struct {
   int txcolor[3]; /* text colour , default white */
   char txfont[BUFF_LEN];
   float  txtsize;} txt_param;
   

   int red=0;
   int green=0;
   int blue=0;

/* different line settings                      */

   short def_line_style = 5; /* Number of line styles defined (0,1,2,3,4) */

   short line_width = 1;     /* Line width in pixels */

   float light_coord[3];  /* keep track of the right place of the light */
 
   int surface_reset = 0; /* default is surface off for all atoms */

   char *surface_list;     /* this list contains information about which atoms
                             should be displayed as surfaces */

   char *liquorice_list;   /* list containing information about which atoms
                             should be displayed as liquorice */

   int **atmcol;

   long menuMain,menuDisplay,menuZone,menuColour,menuval;
   long menuMeasure,identmenu,menuSurface;
   long menuSurfUtil,menuIdentify,menuDynamics,menuTrajectory;
   long menuDynAnal,menuDynDisp,menuIO,menuColourUtil;
   long menuIOcharmm,menuIOpdb,menuIOyasp,menuIOmopac,menuIOinsight;

   long menu_dyn,menuDynFill,menuDelete;

   long menuUtil,menuUtil2Dp,menuUtilsi,menuUtilq;

   long menuSet,menusetBonds;

   long menuLicoriceParam;

   long menusetAtoms;

   long menuPlot;

   long menuLDP;

   long menuEdit,menuEditBond;

#if defined(USEFORMS) && defined(sgi)

   long menuReadAlt;

#endif

   long menuSetFile;

/* list of standard covalent radii as they are used in CSD 3.1 
   Cambridge Structural Data Base System. User's Manual
   Part II, page 84.
*/ 


   int num_elements=MAXelements;

   char *element={"\
Ac  Ag  Al  Am  As  Au  B   Ba  Be  Bi  Br  C   Ca  Cd  \
Ce  Cl  Co  Cr  Cs  Cu  D   Dy  Er  Eu  F   Fe  Ga  Gd  \
Ge  H   Hf  Hg  Ho  I   In  Ir  K   La  Li  Lu  Mg  Mn  \
Mo  N   Na  Nb  Nd  Ni  Np  O   Os  P   Pa  Pb  Pd  Pm  \
Po  Pr  Pt  Pu  Ra  Rb  Re  Rh  Ru  S   Sb  Sc  Se  Si  \
Sm  Sn  Sr  Ta  Tb  Tc  Te  Th  Ti  Tl  Tm  U   V   W   \
Y   Yb  Zn  Zr  He  Ne  Ar  Kr  Xe  Rn"};

    int element_p[MAXelements] =
   { 89 , 47 , 13 , 95 , 33 , 79 , 5  , 56 , 4  , 83 , 35 , 6  , 20 , 48 , 
     58 , 17 , 27 , 24 , 55 , 29 , 0  , 66 , 68 , 63 , 9  , 26 , 31 , 64 ,
     32 , 1  , 72 , 80 , 67 , 53 , 49 , 77 , 19 , 57 , 3  , 71 , 12 , 25 ,
     42 , 7  , 11 , 41 , 60 , 28 , 93 , 8  , 76 , 15 , 91 , 82 , 46 , 61 ,
     84 , 59 , 78 , 94 , 88 , 37 , 75 , 45 , 44 , 16 , 51 , 55 , 34 , 14 ,
     62 , 50 , 38 , 73 , 73 , 65 , 43 , 90 , 22 , 81 , 69 , 92 , 23 , 74 ,
     39 , 70 , 30 , 40 , 2  , 10 , 18 , 36 , 54 , 86};
 
    float covar[MAXelements] =
   { 1.88 , 1.59 , 1.35 , 1.51 , 1.21 , 1.50 , 0.83 , 1.34 , 0.35 , 1.54
    ,1.21 , 0.68 , 0.99 , 1.69,
     1.83 , 0.99 , 1.33 , 1.35 , 1.67 , 1.52 , 0.23 , 1.75 , 1.73 , 1.99,
     0.64 , 1.34 , 1.22 , 1.79,
    1.17,0.23,1.57,1.70,1.74,1.40,1.63,1.32,1.33,1.87,0.68,1.72,1.10,1.35,
    1.47,0.68,0.97,1.48,1.81,1.50,1.55,0.68,1.37,1.05,1.61,1.54,1.50,1.80,
    1.68,1.82,1.50,1.53,1.90,1.47,1.35,1.45,1.40,1.02,1.46,1.44,1.22,1.20,
    1.80,1.46,1.12,1.43,1.76,1.35,1.47,1.79,1.47,1.55,1.72,1.58,1.33,1.37,
    1.78,1.94,1.45,1.56,0.00,0.00,0.00,0.00,0.00,0.00};

    float max_corad2 = 16.0 ; /* trigger value in connection search */

    int search_window = 31;/* search window for the atom connection analyzis */
                           /* the bigger this value is the longer it takes */

/* functions */

  int covalent_rad();

/* dynamics trajectory analysis parameters  */

  char traj_file[BUFF_LEN];
  int  traj_file_set = 0;        /* switch for trajectory file set/not set 
                                    0 ==> file is not set
                                    1 ==> charmm trajectory
                                    2 ==> discover trajectory
                                    3 ==> amber trajectory
                                    4 ==> yasp trajectory
                                    5 ==> mumod trajectory
                                    6 ==> gromos trajectory
                                    7 ==> hyperchem trajectory
                                 */
  char *traj_file_type[8] = {"File type is not set",
                             "CHARMm trajectory",
                             "DISCOVER trajectory",
                             "AMBER trajectory",
                             "YASP trajectory",
                             "MUMOD trajectory",
                             "GROMOS trajectory",
                             "HyperChem trajectory"};

  float *coordx,*coordy,*coordz;

  struct {
  int nfreat;                        /* number of free atoms */
  int *free_atom_list;} free_alist;  /* list of free (not fixed) atoms */

  int point_arr_set=0;           /* switch for setting of the point array */
  int dist_arr_set=0;            /*           -"-             dist        */
  int ang_arr_set=0;             /*           -"-             ang         */
  int tors_arr_set=0;            /*           _"_             tors        */
  int etot_arr_set=0;            /*           _"_             etot        */
  int pen_arr_set=0;             /*           -"-            pot en       */
  int max_traj_mem=16;           /* maximum trajectory memory available in
                                    megabytes */
  int traj_in_core=0;            /* switch which tells the program if all
                                    trajectory display/analysis should be
                                    done in core (=1) or out of core (=2)
                                    I don't yet know (=0). */
  FILE *charmm_oc;               /* pointer for the out of core trajectory */

  FILE *yasp_oc;                 /* yasp file pointer                      */

  int   rfile_deep = 0;          /* level indicator   */
  FILE *rfile_point[MAX_FILES];  /* list of pointers in case of recursive
                                    read of input file ('@' read) */

struct et {   /* structure to contain some values from the trajectory */
   int step_nr;
   float time_in_fs;
   float tote;
   float kine;
   float pote;
   float temp;
   float bond;
   float angl;
   float dihe;
   float impr;
   float vdw;
   float elec;
   float hbond;
   float charm; };

   struct et *traj_energy;

   struct {       /* log file structure */
   char file[BUFF_LEN];
   FILE *log_p;
   int ok;
   int lines;} LogFile;

/* define the CHARMm structure                          */
   struct CHARMm { /* Charmm structure */
   int numat;          /* number of atoms in this structure */
   int *res1;          /* residue number 1 list */
   int *res2;          /* residue number 2 list */
   char *resnam;       /* residue name list */
   char *atnam;        /* atom name list */
   char *segment;      /* segment name list */
   float *x;           /* x,y and z coordinates */
   float *y;
   float *z;
   float *bvalue;}      /* bvalue list */
                   *Charmm_struct;
   int NumCharmmStruct = 0;     /* number of Charmm structures present */
/* end of CHARMm structure                           */

/* define the display structure                          */
   struct DisplayParms { /* display related parameters   */
          char *disp_list;      /* display list */
          int *atmcol[3];       /* atom colour */
          char *surface_list;   /* surface list */
          char *liquorice_list; /* licorice list */
          float *cpk_scale;}    /* cpk_scale list */
       *DisplayPRMS;

/* Define dynamics analyse structure */
   struct DynaAnal {
    int observ;                 /* number of observations in this set */
    float *values;              /* pointer to this set */
    char variables[BUFF_LEN];}  /* store the definition of the variable */
                    *DynalAnalWork;
    int NumAnalStruct = 0;      /* number of analyse structures defined */
/*                                                   */

float time_bw_step=0; /* time between the different frames to be displayed */

int et_count = 0;

char energy_file[BUFF_LEN];  /* name of trajectory energy file */

/* parameters handling the graphical objects  */

   int draw_obj_disp= 1;  /* switch for the main object display
                           = 1 on
                           = 0 off */
   float *trax,*tray,*traz; 
   /* these are the translation vectors for the objects  */

   int disp_obj[50];

   int text_port=0;
   int deep=0;
/*   char text[PORTchar];  */
   char win_text[PORTline][PORTchar];
   int  text_bottom=1;    /* switch for controling the text on the bottom line
                             0 = off , 1 = on */
   char *bottom_line;  /* text which will be displayed at the bottom line */
   int  no_graphics_yet = 0;  /* if > 0 graphics is possible */

/* utility handling and functions  */

   float *xsave;   /* pointers for saving the coordinates */
   float *ysave;
   float *zsave;
   int   coord_save=0; /* parameter to tell the system if the coordinates
                          are put aside */

   int z_clip=0; /* z_clip = 0 left mouse button off , z_clip = 1 button on */
   int y_clip=0;
   int x_clip=0;
   int xyz_clip=0;

/* The programs knows about the following amino acids BY DEFAULT , more
   can be added in the parameter file */

   int num_ka=20; /* number of known amino acids */
   char *nam_ka3 = 
   "ALA ARG ASN ASP CYS GLN GLU GLY HIS ILE LEU LYS MET PHE PRO SER THR TRP TYR VAL"; /* symbol as three letter names */
   char *nam_ka1 = "ARNDCQEGHILKMFPSTWYV"; /* symbol as one letter names */

/* things specific for CHARMM                               */

   short *charmm_aty;     /* pointer for the charmm atom type. SCARECROW
                             tries to resolve the charmm atom types     */

/* externals */

    extern struct {
      int corr_wind;   /* switch to indicate that window is on = 1 , off = 0 */
      int corr_vec1;   /* number of correlation vector 1 */
      int corr_vec2;   /* number of correlation vector 2 */
      int corr_obs;    /* number of points in vectors 1 and 2 */
      float *corr_val;} /* pointer to the correlation values */  
    corr_info;

/* structure to follow up rotations and translation */
      struct ObjInfo {
       float RotX;
       float RotY;
       float RotZ;
       float TransX;
       float TransY;
       float TransZ;} MolLoc = { 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0};

/*
      Scarecrow is using the following Projection Transformations

      0 => Scarecrow is using ortho
      1 =>                    perspective
*/
      struct Projection {
       int Fovy;           /* in tenths of degrees */
       int Transformation; } Model = { 400 , 0 };
  
/* define the different menus which are in use */
      struct MuList {
        int SaveMenu;
        int Menu;          /* = 1 , display main menu
                              = 2 , display dynamics menu
                              = 3 , display ldp menu
                              = 4 , cluster plot menu
                           */
                     } MenuList = { 1 , 1};


   float HitSphere2 = GRIDB; /* square of the "hit sphere" when picking */

/* double/single buffer controller                          */
   struct {
   char Changed;       /* if > 0 mode has changed               */
   int BufferMode;     /* 1 = single buffer , 2 = double buffer */
   } DBuffer;

/* structure to contain information about window update */
   struct {
     int MainW;      /* Main window          */
     int LDPW;       /* Distance plot window */
     int Rama;       /* Ramachandran plot    */
     int Cluster;    /* Cluster plot         */
   } WUpdate = {0 , 0 , 0 , 0};

/* the hard stuff starts here ...                           */

/* catch the control-C and make a user interrup */
/**************************************************************************/
void control_c(i)
   int i;
/**************************************************************************/
{
   extern jmp_buf jumper;

   longjmp(jumper,1); /* return to the user prompt */

}

/**************************************************************************/
/* define the signal handler */
void sig_handler(i)
   int i;
/**************************************************************************/
{
   extern char *sys_errlist[];

   char OutText[BUFF_LEN];

   PrintMessage("**** Signal was caught ****\n");
    perror("=> ");
     sprintf(OutText,"Signal code is: %d, errno : %d.\n",i,errno);
      PrintMessage(OutText);
      sprintf(OutText,"Type of error: %s.\n",sys_errlist[errno]);
     PrintMessage(OutText);
   shut_down(i);
}

/**************************************************************************/
main(argc,argv)          /* main program              */
   int argc;
   char *argv[];
                         /* Leif Laaksonen 1990       */
/**************************************************************************/
{

   int i,retv;
   char OutText[BUFF_LEN];
   float TimeNow = 0.0;

/* set timer and go ... */
   get_wall_secs(&TimeNow);

#if defined(sgi)
/* just for memory allocation */
   mallopt(M_FREEHD , 1);
#endif

/********************* look for the command line input ***********************/

     ComLinePars.argc = argc;
     ComLinePars.argv = argv;
 
/* parse the command line input ...    */
/* check the input line if argc > 0    */
   if(argc > 1 ) {
                 for( i = 1 ; i < argc ; i++) {
                 /* check first that it is a '-' command */
                    if(argv[i][0] == '-' ) { /* yes it is */
/* '-a' change number of atoms           */
      if(argv[i][1] == 'a')  {
      sscanf(&argv[i][2],"%d",&MAXatom);} /* end of '-a' */
/* '-i' input from file                  */
      if(argv[i][1] == 'i') {
/* disable the text at the bottom */
      text_bottom = 0;
      sscanf(&argv[i][2],"%s",input_from_file);
      LogFile.ok = 1; /* don't write to log file */
      }
/* '-s' put scarecrow in the server mode */
      if(argv[i][1] == 's') server_mode = 1;
/* '-v' put video mode on                */
      if(argv[i][1] == 'v') video_mode = 1;
/* '-h' give some help                   */
      if(argv[i][1] == 'h') {
      printf("%s\n",usage);
      exit(0);}
/* '-p' start scarecrow with an other parameter file  */
      if(argv[i][1] == 'p') 
      sscanf(&argv[i][2],"%s",scare_param);
/* '-t' start scarecrow without any graphics     */
      if(argv[i][1] == 't')
      term_type = -1;
/* '-l' control of log file                      */
      if(argv[i][1] == 'l') {
        if(argv[i][2] == 'n' || argv[i][2] == 'N') LogFile.ok = 1;
        if(argv[i][2] == 'y' || argv[i][2] == 'Y') LogFile.ok = 0;
      }
/* '-w' window control place windoe at XxYxW and w pixels wide */
      if(argv[i][1] == 'w') {
        (void) GetStartUpWindow(&argv[i][2]);
      }

    }
   }
  }

/********************** command line now handled *****************************/

/* The execution starts here ... */

      bottom_line = cvector(PORTchar);

/*  handle signals   */

   signal(SIGFPE,sig_handler);  /*  floating point exception */
   signal(SIGBUS,sig_handler);  /*  bus error                */
   signal(SIGSEGV,sig_handler); /*  segmentation violation   */
   signal(SIGILL,sig_handler);  /*  illegal instruction      */
   signal(SIGINT,control_c);    /*  control C handle         */
   signal(SIGUSR2,GetSIGUSR2);

/*********************/

/*  some precalculated constants  */
   pia = acos(-1.0);
   pia1800 = pia / 1800.;
   Piper180= pia / 180.;
   Problems.ERRORcode = 0;
   atm_col_num = strlen(def_atm_col)/MAX_ATM_NAME_LEN;
    if((atm_col_num * MAX_ATM_NAME_LEN - strlen(def_atm_col))) {
        PrintMessage("?ERROR - something fishy in your 'def_atm_col' string");
        exit(1);}

/* open log file and old command stack (if available) */
   OpenLogFile();
   retv = ReadCommandStack();
/*   announce ...        */

   PrintMessage(Banner);

   get_date(1);  /* print date and time */

   module_name = argv[0]; /* save program name (this is needed in get_proc_info)*/

#ifdef DEBUG
   get_proc_info(); /* print process info */
#endif

/* this is a fake */
  if(term_type == 0)
     term_type = det_term(); /* look for the terminal type */
  else
     term_type = 0;

   get_env(); /* go and get some environment parameters */

/* dimension the system for a number of atoms (default or from command line */
      MAXca   =  MAXatom;
      sprintf(OutText,"    Maxatoms is now defined to: %d atoms \n",MAXatom);
      PrintMessage(OutText);
/****************************************************************************/

   get_space();                      /* grab the space for default length */

/* this is not in use now (WILL FIX IT LATER) */
/*   retv = read_start(scare_start);*/  /* read startup scarecrow            */

   get_proc_info(); /* print process info now when ready to start ... */

#ifdef sgi
   if(term_type == 1)
   foreground();
   graf_init();                      /* initialize graphics             */
#endif

   PrintMessage("\n    Reading parameter files ...\n");
   retv = read_par(atom_param);  /* read QUANTA parameter file      */

   retv = read_own(scare_param); /* read own parameter file         */

   retv = read_streamer(STREAMER_DATA_FILE); /* streamer data file */

   retv = read_col_tbl(col_table_name); /* read colour table file */   
   PrintMessage("    Done. \n");

   trax[0] = 0.0;
    tray[0] = 0.0;
     traz[0] = 0.0;

/* dive into server mode */
   if(server_mode) {
     acting_server();
     PrintMessage("\nExit from server mode \n");
     shut_down(0);}

#ifdef sgi
   if(term_type == 1) { /* iris graphics */
     strncpy(bottom_line,"** Choose from main menu",PORTchar);
     plot_mol();                       /* main routine to control display */
   }                   /* end of iris graphics */
#endif

   if(term_type != 1) { /* all other terminals and input from file */

/* let there be light ... */
#ifdef sgi
       if(term_type == 3) {
                           SURFACE_DEF();
			  }
#endif 
     plot_mol_term();
   }
   
     exit(0);

}   /* End of main routine */

/***************************************************************************/
float *vector_add(vec,nh)   /* add more memory to a floating pointer array */
     float *vec;            /* name of array to get more memory */
     int nh;                /* new length of array              */
                            /* Leif Laaksonen 1990              */
/***************************************************************************/
{
     static float *v;

     v = (float *) realloc((char *)vec , (nh*sizeof(float)));
     if( v == NULL) {
     PrintMessage("\n** ERROR in vector ... Reallocation failure \n\n");
     shut_down(1); }

     return v;
}
/***************************************************************************/
double *dvector_add(vec,nh)   /* add more memory to a double pointer array */
     double *vec;             /* name of array to get more memory */
     int nh;                  /* new length of array              */
                              /* Leif Laaksonen 1990              */
/***************************************************************************/
{
     static double *v;

     v = (double *) realloc((char *)vec , (nh*sizeof(double)));
     if( v == NULL) {
     PrintMessage("\n** ERROR in dvector ... Reallocation failure \n\n");
     shut_down(1); }

     return v;
}

/***************************************************************************/
double *dvector(nh)   /* reserve memory for double array */
     int nh;         /* expected length of array       */
                     /* Leif Laaksonen 1990            */
/***************************************************************************/
{
     static double *v;

     v = (double *) malloc(nh*sizeof(double));
     if( v == NULL) {
     PrintMessage("\n** ERROR in dvector ... Allocation failure \n\n");
     shut_down(1); }

     return v;
}


/***************************************************************************/
float *vector(nh)   /* reserve memory for float array */
     int nh;        /* expected length of array       */
                    /* Leif Laaksonen 1990            */
/***************************************************************************/
{
     static float *v;

     v = (float *) malloc(nh*sizeof(float));
     if( v == NULL) {
     PrintMessage("\n** ERROR in vector ... Allocation failure \n\n");
     shut_down(1); }

     return v;
}

/***************************************************************************/
int *ivector_add(vec,nh)    /* add more memory to an integer pointer array */
     int *vec;              /* name of array to get more memory */
     int nh;                /* new length of array              */
                            /* Leif Laaksonen 1990              */
/***************************************************************************/
{
     static int *v;

     v = (int *) realloc((char *)vec , (nh*sizeof(int)));
     if( v == NULL) {
     PrintMessage("\n** ERROR in ivector ... Reallocation failure \n\n");
     shut_down(1); }

     return v;
}

/***************************************************************************/
int *ivector(nh)  /* reserve memory for integer array */
     int nh;      /* expected length of array         */
                  /* Leif Laaksonen 1990              */
/***************************************************************************/
{
     static int *v;

     v = (int *) malloc(nh*sizeof(int));
     if( v == NULL) {
     PrintMessage("\n** ERROR in ivector ... Allocation failure ... \n\n");
     shut_down(1); }

     return v;
}


/***************************************************************************/
char *cvector_add(vec,nh)   /* add more space to character array */
     char *vec;             /* array to get the space */
     int nh;                /* expected length        */
                            /* Leif Laaksonen 1990    */
/***************************************************************************/
{
     static char *v;

     v = (char *) realloc( vec , nh);
     if( v == NULL) {
     PrintMessage("\n?ERROR - in cvector ... Reallocation failure \n\n");
     shut_down(1); }

     return v;
}

/***************************************************************************/
char *cvector(nh)   /* reserve memory for character array */
     int nh;        /* length of character array          */
                    /* Leif Laaksonen 1990                */
/***************************************************************************/
{
     static char *v;

     v = (char *) malloc( nh );
     if( v == NULL) {
     PrintMessage("\n** ERROR in cvector ... Allocation failure ...\n\n");
     shut_down(1); }

     return v;
}

/***************************************************************************/
short *svector(nh)  /* reserve memory for a short array */
     int nh;      /* expected length of array         */
                  /* Leif Laaksonen 1990              */
/***************************************************************************/
{
     short *v;

     v = (short *) malloc(nh*sizeof(short));
     if( v == NULL) {
     PrintMessage("\n** ERROR in svector ... Allocation failure ... \n\n");
     shut_down(1); }

     return v;
}

/***************************************************************************/
short *svector_add(vec,nh)  /* add more memory to an integer pointer array */
     short *vec;            /* name of array to get more memory */
     int nh;                /* new length of array              */
                            /* Leif Laaksonen 1990              */
/***************************************************************************/
{
     static short *v;

     v = (short *) realloc((char *)vec , (nh*sizeof(short)));
     if( v == NULL) {
     PrintMessage("\n** ERROR in svector ... Reallocation failure \n\n");
     shut_down(1); }

     return v;
}

/***********************************************************************/
atom_conn(mlist_deep_s)
     int mlist_deep_s;
                 /* calculates the atom connection  
                 a window of 'serach_window' atoms backward and forward is used
                 to find the connection. if you need more change
                 the "grid" parameter.
                 the algorithm is very simple. all atoms have a defined
                 covalent radius rc(i). a distance r(i,j) is calculated
                 between atoms i and j. there is a covalent bond between
                 atom i and j if the following is true
                 rc(i)+rc(j) - delta < r(i,j) < rc(i)+rc(j) + delta
                 where the delta is a small value (look for COVdelta).

                 Leif Laaksonen 1990       */
/***********************************************************************/
{
   int i,j,k;
   int grid, first , last;
   float ipj;
   int from,to;
   register float w1,w2,w3,r;
   char OutText[BUFF_LEN];

   grid = search_window;

   from = mlists[mlist_deep_s - 1];
   to   = mliste[mlist_deep_s - 1];

   if(to - from < 1 ) return; /* no atoms */

/* kill old connection table */
   for( i = from ; i < to ; i++) {
    k=0;
     for(j = 0 ; j < MAXconn ; j++) cnct[i][j]=0;

/* Do only the search in a grid   */

      first = ( (i - grid) > from ? (i - grid) : from );
      last  = ( (i + grid) < to ? (i + grid) : to);

      for( j = first ; j < last ; j++) {

       if( i == j ) continue;

         w1 = x[i] - x[j];
            r = w1 * w1;
            if(r > max_corad2) continue;
          w2 = y[i] - y[j];
             r += w2 * w2;
             if(r > max_corad2) continue;
           w3 = z[i] - z[j];
              r += w3 * w3;
              if(r > max_corad2) continue;

       ipj = corad[i] + corad[j];

       r = sqrt(r);

        if(r < ipj + COVdelt && r > ipj - COVdelt ) {

/*  Special case nr 1:  */
/*  Hydrogens can be close to each other without a bond */

        if(*(atnam+MAX_ATM_NAME_LEN*i) == 'H' && 
           *(atnam+MAX_ATM_NAME_LEN*j) == 'H') continue ;

        k=k+1;

        if( k > MAXconn) {
        PrintMessage("*** ERROR . Max connections exceeded");
        sprintf(OutText,"Atom nr: %d, '%.4s:%.4s:%.4s'",(i+1),
                                                        GetSegName(i),
                                                        GetResName(i),
                                                        GetAtmName(i));
        PrintMessage(OutText);
        shut_down (1); }

            cnct[i][k]=j;
            cnct[i][0]=k; 

        }
       }
      }
#ifdef DEBUG
CheckConnTable(cnct);
#endif
}

#ifdef sgi
/***********************************************************************/
graf_init()  /* graphics initialization stuff */
/***********************************************************************/
{
   static  char text[BUFF_LEN]="ScareCrow_";
   static  char add[BUFF_LEN];
   static  int  i;

   int MinWx;
   int MinWy;

    if(term_type == 1) {   /* this is an iris- terminal */

/* do a hardware check  */
   HWlookup();

/* put system to work according to the graphics hardware available */
/*   glcompat(GLC_ZRANGEMAP , 1);  */
   for(i = 0 ; i < MAX_CONTOURS ; i++) {
       ContourInfo[i].AlphaBlend = 1.0;}

/* put double buffer mode on as default */
   DBuffer.BufferMode = 2;
   DBuffer.Changed    = 0;

/* protect against mouse noise */

#ifdef JUNK
     noise(MOUSEX , MOUSEX_NOISE_LIMIT);
     noise(MOUSEY , MOUSEY_NOISE_LIMIT);

     noise(TIMER0 , 4);   /* redraw event */
     noise(TIMER1 , 2);   /* mouse event  */
#endif

/* check font manager fonts */
     GetFMfonts();

/* FORMS */
#if defined(USEFORMS) && defined(sgi)
   create_the_forms();
#endif

/* define the smallest window size */
   MinWx = MIN_W_X;
    MinWy = MIN_W_Y;

   minsize(MinWx , MinWy);

/* define text font      */
   txt_param.txcolor[0] = 255;
   txt_param.txcolor[1] = 255;
   txt_param.txcolor[2] = 255; /* text colour , default white */
   strncpy(txt_param.txfont,"Courier-Bold",BUFF_LEN); /* text font */
   txt_param.txtsize = 20.;    /* text size */

     if(video_mode == 0) {
/*        keepaspect(1 , 1); */
         if(input_from_file[0] != '\0') { 
           prefposition(DEMO_x1 , DEMO_x2 , DEMO_y1 , DEMO_y2); /* from file */
           term_type = 3;} /* input from file with graphics */

       if(StartWindow.Set) {
         prefposition(StartWindow.X , (StartWindow.X + StartWindow.XW) ,
                      StartWindow.Y , (StartWindow.Y + StartWindow.YW));}

     if((win_ids[winnr]=winopen("plot")) == -1) {  
                                          /* try to open the window now ... */
        PrintMessage("?ERROR - can't open main window");
        shut_down(1);}

     no_graphics_yet = 1;

/* define cursors                  */
     init_cursors();
     }        /* end of "this is not video mode" */
     else {   /* start of video mode             */
/* video mode              */
/* NO SCREENBLANKS !!!!!!!*/
    blanktime((long)0);

/* make a black background */
    noborder();
    prefposition(0  , SCREENXP , 0 , SCREENYP);
    if( (win_ids[winnr] = winopen(" ")) == -1) {
    PrintMessage(" can't open background window \n");
    shut_down(1);}
    winnr++;
    c3s(BLACKv);
    clear();
/* define the display window */
    noborder();
       if(StartWindow.Set) {
         prefposition(StartWindow.X , (StartWindow.X + StartWindow.XW) ,
                      StartWindow.Y , (StartWindow.Y + StartWindow.YW));}
       else
         prefposition(VIDEO_x1 , VIDEO_x2 , VIDEO_y1 , VIDEO_y2); 
                                                           /* from file */
     win_ids[winnr]=winopen("plot"); /* try to open the window now ... */

     no_graphics_yet = 1;

/* define cursors                  */
   init_cursors();

     if(win_ids[winnr] == -1 ) {
      PrintMessage("?ERROR - can't open main display window \n");
      shut_down(1);}
     winset(win_ids[winnr]);
    c3s(BLACKv);
    clear();
    zclear();

      if(input_from_file[0] != '\0') { 
        term_type = 3;} /* input from file with graphics */
     }

/* if it is not possible to open a window switch to a vt100 terminal */
     if(win_ids[winnr] == -1) {
     PrintMessage("?ERROR - unable to open a window. (Switching to vt100)\n");
     term_type = 2;
     return;}

/* push window identifier into stack */
     if(PushToWindowStack(win_ids[winnr] , MOLECULE_PLOT)) {
       PrintMessage("?ERROR - can't open main window");
       shut_down(1);}

     DisableMultiWindow();

     winnr=winnr+1;
      sprintf(add,"%d",winnr); 
       strcat(text,add); 
        wintitle(text);
       doublebuffer();
      RGBmode();
     gconfig();

     lsetdepth(0x0, 0x7FFFFF);
     zbuffer(TRUE);
     qdevice(REDRAW);
      qdevice(LEFTMOUSE);
       qdevice(MIDDLEMOUSE);
        qdevice(MOUSEX);
         qdevice(MOUSEY);
          qdevice(ESCKEY);
           qdevice(MENUBUTTON);
           qdevice(EKEY);
           qdevice(FKEY);
          qdevice(ZKEY);
         qdevice(RKEY);
        qdevice(QKEY);
       qdevice(UPARROWKEY);
      qdevice(DOWNARROWKEY);
     qdevice(LEFTARROWKEY);
    qdevice(RIGHTARROWKEY);
     qdevice(KEYBD);
     qdevice(F1KEY);
      qdevice(F2KEY);
       qdevice(F3KEY);
        qdevice(F4KEY);
         qdevice(F5KEY);
          qdevice(F6KEY);
          qdevice(F7KEY);
         qdevice(F8KEY);
        qdevice(F9KEY);
       qdevice(F10KEY);
      qdevice(F11KEY);
     qdevice(F12KEY);
    qdevice(WINSHUT);
   qdevice(INPUTCHANGE);

/*
     qdevice(PAD8);
     qdevice(PAD6);
     qdevice(PAD2);
*/
/* define line width                            */
   linewidth(line_width);

/* define line styles                           */

  deflinestyle(1,0x3FFF); /* long dash */
  deflinestyle(2,0x5555); /* dotted */
  deflinestyle(3,0x3333); /* short dash */
  deflinestyle(4,0xB5AD); /* dotdashed */  

/* clear window */
     c3s(bgcolor);
     clear();
     zclear();
     ScareSwapbuffers();
/* almost ready */

/* define menus */

     menuEditBond = defpup(
         "EditBond %t | Add bond %x1020 | Delete bond %x1021");

     menuEdit     = defpup(
         "Edit %t | Bond %m | Text %x1022",menuEditBond);


/*     menuDelete = defpup(
"Delete %t | Dist vec %x900 | Ang vec %x901 | Tors vec %x902 |Dele all %x903");
*/
     menuDelete = defpup(
"Delete %t | Dele all vectors %x903");
     menuColourUtil = defpup(
     "Colour util %t | Background %x716 | Text %x717 | Object %x718 ");
     menuDynFill = defpup(
     "Fill vector %t | Distance %x708 | Angle %x709 | Torsion %x710 | Tot E %x711 | Pot E %x712 | Kin E %x713 | Temp %x714");

#ifndef USEFORMS
     menuIOcharmm = defpup(
"CHARMM %t | Read coord %x800 | Read dictionary %x802");
     menuIOpdb =defpup(
"PDB %t | Read coord %x801");
     menuIOyasp = defpup(
"YASP %t | Read coord %x804");
     menuIOmopac = defpup(
"MOPAC %t | Read coord  %x810");
     menuIOinsight = defpup(
"INSIGHT %t | Read coord %x811");

     menuIO = defpup(" Read/Write %t | CHARMM %m | PDB %m |INSIGHT %m | YASP %m | MOPAC %m",
              menuIOcharmm,menuIOpdb,menuIOinsight,menuIOyasp,menuIOmopac);
#endif
     menuDynDisp = defpup(
     "Display %t | Av struct %x706 | Movie %x701 | Step %x705 | Display freq %x719 | Plot %x715");
     menuDynAnal = defpup(
     "Analyse %t | Point %x707 | Distance %x702 | Angle %x703 | Torsion %x704");
     menuDynamics = defpup(
     "Dynamics %t | Define traj file %x700 | Display %m | Analyse %m | Fill vector %m | Delete vector %m",
     menuDynDisp,menuDynAnal,menuDynFill,menuDelete);
     menuSurfUtil = defpup(
     "CPK type %t | vdW %x500 | Covalent %x501 | Liquorice %x502 ");
     menuColour = defpup(
     "Colour %t | Range %x21 | Hydro %x25 | Charge %x38 | Blend %x24 | Utility %m | Reset %x22",
     menuColourUtil);
     menuSurface= defpup(
     "Zone %t | All atoms %x13 | Range %x211 |  Append %x212 | Surf type %m | -CPK %x215 | Reset %x213",menuSurfUtil);
     menuZone= defpup(
     "Zone %t | Range %x111 | Append %x115 | Round %x114 | Reset %x113");
     menuDisplay = defpup(
     "Display %t | Zone %m  | Alpha-carbon %x11 | CPK %m | Stereo %x1024 | Center %x9 | Neighbours %x15 | -Neighbours %x915 | Z-translate %x18 | X-translate %x27 | Y-translate %x26 | End-translation %x28 | Clip %x29 | Reset %x17 | Return %x12 ",
      menuZone,menuSurface);
     menuPlot = defpup(
     "Plot menu %t | Ldp %x1007 | -Ldp %x1008 | Ramachandran %x1009 | -Ramachandran %x1010 | Trace %x1011 | -Trace %x1012 | Contour %x1015 | -Contour %x1016"); 
     menuMeasure = defpup(
     "Measure %t | Distance %x31 | Angle %x32 | Torsion %x33 ");
     menuIdentify = defpup(
     "Identify %t | Atom  %x600 | Full %x601 ");
     menuLicoriceParam = defpup(
     "Licorice params %t | Cylinder rad %x1004 | Sphere rad %x1005");
     menusetAtoms = defpup(
     "Set atom params %t | Set search window %x1006");
     menusetBonds = defpup(
     "Set bond type %t | Sharp half %x1000 | Soft %x1001");
     menuSetFile = defpup(
     "Set file params %t | Masks %x1023");
     menuSet = defpup(
     "Set menu %t | Atom params %m | Bonds %m | Box (on/off) %x14 | File %m| Full screen on %x1002 | Full screen off %x1003 | Licorice param %m | Line width %x1013",menusetAtoms,menusetBonds,menuSetFile,menuLicoriceParam); 

#if defined(USEFORMS) && defined(sgi)
     menuReadAlt = defpup("Read menu %t | Coordinates %x1017 | Text %x1018 | Dictionary %x1019");
     menuMain = defpup(
     "Main menu %t | Display %m | Colour %m | Identify %m | Dynamics %m | Plot %m | Set things %m | Shell %x6 | Measure %m | Read %m | Edit %m | Utility %x950 | Command stack %x1014 | Text (on/off) %x16 | Molecule (on/off) %x39 | Hardcopy %x19 | Restart SCARECROW %x6000 | QUIT %x5",
      menuDisplay,menuColour,menuIdentify,menuDynamics,menuPlot,menuSet,menuMeasure,menuReadAlt,menuEdit);

#else

     menuMain = defpup(
     "Main menu %t | Display %m | Colour %m | Identify %m | Dynamics %m | Plot %m | Set things %m | Shell %x6 | Measure %m | Read/Write %m | Edit %m | Utility %x950 | Command stack %x1014 | Text (on/off) %x16 | Molecule (on/off) %x39 | Hardcopy %x19 | Restart SCARECROW %x6000 | QUIT %x5",
      menuDisplay,menuColour,menuIdentify,menuDynamics,menuPlot,menuSet,menuMeasure,menuIO,menuEdit);
#endif

      identmenu = defpup(" And now?  %t | Return %x1 | Text (on/off) %x3 | Exit %x2");

      menuTrajectory = defpup(
      "Analyse %t | Return %x800");

/*  dynamics menu              */

     menu_dyn = defpup(
" Dynamics %t | Display %m | Colour %m |  Identify %m | Shell %x6 | Measure %m | Display freq %x719 | Def new frame %x801 | Text (on/off) %x16 | Object (on/off) %x715 | Molecule (on/off) %x39 | Next series plot %x2 | Delete %m | Hardcopy %x19 | Return %x1 | QUIT %x5",
      menuDisplay,menuColour,menuIdentify,menuMeasure,menuDelete);

/*  utility menu               */

     menuUtil2Dp = defpup(" 2D plot %t | Read data %x1");
     menuUtilsi  = defpup(" Struc info %t | Max/min x,y,z %x1 | Calc RDF %x2");
     menuUtilq   = defpup(" QM interface %t | icon8 %x1");

     menuUtil = defpup(
" Utility %t | 2D plot %x1 | Struc info %x2 | QM interface %x3");

     menuLDP  = defpup(
" LDP menu %t | Analyse %x5000 | Return %x5001");

/*default matrix mode */
   mmode(MVIEWING);

   MakeOrtho();

     c3s(bgcolor);
     clear();
     c3s(GREENv);
     ScareSwapbuffers();
  } /* end of iris graphics initialization */

}

/*   plot_mol handles the 3-d plotting   */
/***********************************************************************/
plot_mol()
/***********************************************************************/
{

     static int i,retv;
     register int oldx,oldy;
     register short dx,dy;
     static float ddx,ddy,screenr;
     static char command[MAXlinel];
     static int cstatus;
     static int num_pos;
     static int tx_switch = 0;
     static int ty_switch = 0;
     static int tz_switch = 0;
     static int ts_switch = 0;
     static int do_it;
     static int DoI;
     static long OldWinID;
     static float Transfer;

     char OutText[BUFF_LEN];

     DoI = 1;

      mmode(MVIEWING);
      MakeOrtho();

/* if input_file_set = 1 or 2 start from the file taken from .scarecrow */
     
     c3s(bgcolor);
     clear();

#ifndef FAST     
     build_array();            /* calculate the array needed for surface
                                  calculations */
#endif

/* take into acount that the screen is NOT a square */
      screenr = (float)(SCREENXP)/(float)(SCREENYP);

      SURFACE_DEF();

      damp = 1.0;

      reshapeviewport();

      scale( 0.999 , 0.999 , 0.999);

      getmatrix(rotB);

      xval = getvaluator(MOUSEX);
      yval = getvaluator(MOUSEY);

/* bang it on the screen ...   */
      
      bang_it();

      while(1) {
/* land here from the lonjmp */
      retv = setjmp(jumper);
      if(retv != 0) {
        PrintMessage("\n**** User Interrupt ****\n");}

       while(qtest()) {

       WUpdate.MainW = 1;

       dev=qread(&val);
         if( dev == REDRAW ) {

          OldWinID     = winget();
          if(WhichWindowToUpdate((int) val)) {
             PrintMessage("?ERROR - screwed up the window control");}
          bang_it();
          if(OldWinID == GetMainWindowID()) {
             tell_window_size();}
          else
             winset(OldWinID);
          }

/* protect against closing of a window  */
          else if (dev == WINSHUT) 
                   HandleWinShut((long)val);

          else if (dev == INPUTCHANGE) {
                   if(HandleInputChange((int)val))
                      PrintMessage("?ERROR - in handling of input change");
		 }
                   
          else if(dev == UPARROWKEY && 
                  IsStereoON()      && 
                  getbutton(UPARROWKEY)) {
                                 (void)SUBdistStereo(far/20.);
                                 bang_it();}
          else if(dev == DOWNARROWKEY && 
                  IsStereoON()        &&
                  getbutton(DOWNARROWKEY)) {
                                 (void)ADDdistStereo(far/20.);
                                 bang_it();}
          else if(dev == LEFTARROWKEY && 
                  IsStereoON()        &&
                  getbutton(LEFTARROWKEY)) {
                                 (void)SUBeyeStereo(0.025);
                                 bang_it();}
          else if(dev == RIGHTARROWKEY && 
                  IsStereoON()         &&
                  getbutton(RIGHTARROWKEY)) {
                                 (void)ADDeyeStereo(0.025);
                                 bang_it();}

          else if (dev == KEYBD)   {
/* command (character) is expected from the keyboard (go and get it ...) */

       if(Magic.level) continue;

          winset(GetMainWindowID());

          if(val == 26) {
           DoI = 0;
            continue;} /* don't hook on ascii 26 (see keyb_input) */

          cstatus = keyb_input(command);
          strncpy(bottom_line,prompt,PORTchar);
          strncat(bottom_line,command,(PORTchar - strlen(bottom_line)));
          going_on();
/* received end of line, go for the command */
          if(cstatus) { 
     qcomm(command);

     sprintf(OutText,"%s%s",prompt,command);
     PrintMessage(OutText);

     (void)own_parser(command,parsed,&num_pos,SEP_STRING); /* parsing driver */

     if(num_pos < 1) continue;

     exe_command(command,num_pos); /* execute the command on input string */
          }}

          else if (dev == ESCKEY) {
          if(IsStereoON()) {
             if(SetRealStereoOFF()) {
                PrintMessage("?ERROR - in turning the stereo mode OFF");
             }
          }}

          else if (dev == MOUSEX) {
               oldx = xval;
               xval = (int)val; 
               dx   = (short)(oldx-xval);
           if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
              if((ts_switch++)%dampfn) break;
            ddx=Rabs((float) xval/((float) oldx));
            scale(ddx , ddx , ddx);
            bang_it(); qreset(); break;}


/* y - axis translation */
           if(getbutton(LEFTMOUSE) && (z_clip || getbutton(PAD2))) {
            qreset();
            if(SelectionListInUse() || getbutton(PAD5))
              TRANSLATE_SELECTION(0.0 , 0.0 , (((float)dx) * damp));
            else
              TRANSLATE( 0.0 , 0.0 , (((float)dx) * damp) );
            bang_it(); break;}

/* y - axis translation */
           if(getbutton(LEFTMOUSE) && (y_clip || getbutton(PAD8))) {
            qreset();
            if(SelectionListInUse() || getbutton(PAD5))
              TRANSLATE_SELECTION(0.0 , (((float)dx) * damp) , 0.0);
            else
              TRANSLATE( 0.0 , (((float)dx) * damp) , 0.0 );
            bang_it(); break;}

/* x - axis translation */
           if(getbutton(LEFTMOUSE) && (x_clip || getbutton(PAD6))) {
            qreset();
            if(SelectionListInUse() || getbutton(PAD5))
	      TRANSLATE_SELECTION((((float)dx) * damp) , 0.0 , 0.0);
	    else
              TRANSLATE( (((float)dx) * damp) , 0.0 , 0.0);
            bang_it(); break;}

/*
           if(getbutton(LEFTMOUSE) && xyz_clip > 0) {
            qreset();
            ddx = (float)dx / 10.;
            ortho(near - ddx , far + ddx,
                  near - ddx , far + ddx,
                  near - ddx , far + ddx);
            bang_it(); break;}
*/

           if(getbutton(LEFTMOUSE)) {
               if((tx_switch++)%dampfn) break;
                 if(SelectionListInUse() || getbutton(PAD5)) {
                   Transfer = (((float)dx)*0.1);
                   ROTATE_SELECTION(Transfer , 'y');}
                 else
                   ROTATE( -dx ,'y');
                 do_it = 1;}

            if(getbutton(MIDDLEMOUSE)) {
              if((tz_switch++)%dampfn) break;
                 if(SelectionListInUse() || getbutton(PAD5)) {
                   Transfer = (-((float)dx)*0.1);
                   ROTATE_SELECTION( Transfer , 'z');}
                 else
                   ROTATE( dx , 'z');
                do_it = 1;}}

          else if (dev == MOUSEY) {
            oldy = yval;
            yval = (int)val;
            dy   = (short)(oldy-yval);

           if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
            if((ts_switch++)%dampfn) break;
            ddy=Rabs((float) yval/((float) oldy));
            scale(ddy , ddy , ddy);
            bang_it(); qreset(); break;}

           if(getbutton(LEFTMOUSE)) {
              if((ty_switch++)%dampfn) break;
                 if(SelectionListInUse() || getbutton(PAD5)) {
                   Transfer = (-((float)dy)*0.1);
                   ROTATE_SELECTION( Transfer , 'x');}
                 else
                   ROTATE( dy  ,'x');
                do_it = 1;}

           if(getbutton(MIDDLEMOUSE)) {
              if((tz_switch++)%dampfn) break;
                 if(SelectionListInUse() || getbutton(PAD5)) {
                   Transfer = (-((float)dy)*0.1);
                   ROTATE_SELECTION( Transfer , 'z');}
                 else
                   ROTATE( dy , 'z');
                do_it = 1;}}

/*          else if (dev == ZKEY) return; */ 

          else if (dev == F1KEY)  {
               if(!val) break;
               if(RunFKey(1)) 
                 PrintMessage("?ERROR - problems with function keys");
               break;}

          else if (dev == F2KEY)  {
               if(!val) break;
               if(RunFKey(2)) 
                 PrintMessage("?ERROR - problems with function keys");
               break;}

          else if (dev == F3KEY)  {
               if(!val) break;
               if(RunFKey(3)) 
                 PrintMessage("?ERROR - problems with function keys");
               break;}

          else if (dev == F4KEY)  {
               if(!val) break;
               if(RunFKey(4)) 
                 PrintMessage("?ERROR - problems with function keys");
               break;}

          else if (dev == F5KEY)  {
               if(!val) break;
               if(RunFKey(5)) 
                 PrintMessage("?ERROR - problems with function keys");
               break;}

          else if (dev == F6KEY)  {
               if(!val) break;
               if(RunFKey(6)) 
                 PrintMessage("?ERROR - problems with function keys");
               break;}

          else if (dev == F7KEY)  {
               if(!val) break;
               if(RunFKey(7)) 
                 PrintMessage("?ERROR - problems with function keys");
               break;}

          else if (dev == F8KEY)  {
               if(!val) break;
               if(RunFKey(8)) 
                 PrintMessage("?ERROR - problems with function keys");
               break;}

          else if (dev == F9KEY)  {
               if(!val) break;
               if(RunFKey(9)) 
                 PrintMessage("?ERROR - problems with function keys");
               break;}

          else if (dev == F10KEY)  {
               if(!val) break;
               if(RunFKey(10)) 
                 PrintMessage("?ERROR - problems with function keys");
               break;}

          else if (dev == F11KEY)  {
               if(!val) break;
               if(RunFKey(11)) 
                 PrintMessage("?ERROR - problems with function keys");
               break;}

          else if (dev == F12KEY)  {
               if(!val) break;
               if(RunFKey(12)) 
                 PrintMessage("?ERROR - problems with function keys");
               break;}

          else if (dev == MENUBUTTON) {

/* magic stuff */
          if(Magic.level) {
            ResetView();
            bang_it();
            continue;}

/* values from    1 ... 4999 are reserved for the main menu
               5000 ... 5999 are reserved for the ldp menu
               6000          is reserved for reset of SCARECROW
             */

/* menu switch .... */
               switch(MenuList.Menu) {
	       case 1:  /* main menu */
                menuval = dopup(menuMain);
                break;
	       case 3:
                menuval = dopup(menuLDP);
                break;
	       default:
                PrintMessage("?ERROR - in choosing menu ");
                break;}

            switch(menuval) {

            case 6:   make_shell(); /* create a unix shell */
                      bang_it();
                      break;

            case 8:   move_obj();
                      break;

            case 9:   center_obj(1);
                      bang_it();
                      break;

            case 11:  disp_zone(4); 
                      bang_it();
                      break;

            case 14:  if(BOX == 0) BOX=1;
                      else
                      BOX=0;
                      bang_it();
                      break;
   
            case 15:  neighbours(0);  /* display neighbours */
                      bang_it();
                      break;

            case 915: /* delete neighbours */
                      neighbours(2);
                      break;

            case 16:  if(text_port == 0) text_port=1;
                      else
                      text_port=0;
                      bang_it();
                      break;

            case 38:  /* colour by atomic charges           */
                      color_by_charge(0);
                      bang_it();
                      break;

            case 39:  if(draw_obj_disp == 0) draw_obj_disp = 1;
                      else 
                      draw_obj_disp = 0;
                      c3s(bgcolor);
                      clear();
                      zclear();
                      bang_it();
                      break;

            case 17:  /*  reset picture */ 
                      mmode(MVIEWING);
                      MakeOrtho();
                      damp = 1.0;
                      reshapeviewport();
                      trax[0]= 0.0;
                       tray[0] = 0.0;
                        traz[0] = 0.0;
                      bang_it(); 
                      break;

            case 18:  if(z_clip == 0) z_clip = 1;
                      else
                      z_clip = 0;
                      x_clip = 0;
                      y_clip = 0;
                      break;

            case 26:  if(y_clip == 0) y_clip = 1;
                      else
                      y_clip = 0;
                      x_clip = 0;
                      z_clip = 0;
                      break;

            case 27:  if(x_clip == 0) x_clip = 1;
                      else
                      x_clip = 0;
                      y_clip = 0;
                      z_clip = 0;
                      break;

            case 28: /* turn all translates off */
                      z_clip = 0;
                      y_clip = 0;
                      x_clip = 0;
                      break;

            case 29: /* do clipping             */
                      if(xyz_clip == 0) xyz_clip =1;
                      else
                      xyz_clip = 0;
                      break;

            case 19:  /* make a hardcopy */
                      hardcopy("\0");
                      bang_it();
                      break;

            case 111: disp_zone(1); /* by range */ 
                      bang_it();
                      break;

            case 113: disp_zone(2); /* reset zone */
                      bang_it();
                      break;

            case 114: disp_zone(3); /* sphere round */
                      bang_it();
                      break;

            case 115: disp_zone(5); /* append to display */
                      bang_it();
                      break;

            case 21:  colour_zone(1); /* colour by range */
                      bang_it() ;
                      break;

            case 22:  colour_zone(2); /* reset colour */
                      bang_it() ;
                      break;

            case 24:  Alpha_Blend(); 
                      def_simple_light_calc();
                      use_simple_light_calc();
                      blendfunction(BF_SA, BF_ONE);
                      bang_it() ;
                      break;

            case 25:  in_water(); 
                      bang_it() ;
                      break;

            case 600:  identify(1);break;

            case 601:  identify(2);break;

            case  31:  distance();break;

            case  32: mangle(); break;

            case  33: mtorsion(); break; 

            case 13:  /* surface on all atoms */
                      if(liq_surf) {
                               send_command("set atom lico");
                               send_command("set atom -cpk");}
                      else
                               send_command("set atom cpk");
                      yn_surf = 1;
                      SURFACE_DEF();
                      bang_it();
                      break;

            case 211: surface_zone(1);   /* surface zone */ 
                      yn_surf=1;
                      SURFACE_DEF(); 
                      bang_it();
                      break;

            case 212: surface_zone(2);   /* append to surface zone */ 
                      yn_surf=1;
                      SURFACE_DEF(); 
                      bang_it();
                      break;

            case 213: surface_zone(3); /* reset surface zone */
                      yn_surf=1;
/*                      SURFACE_DEF(); */
                      bang_it();
                      break;

            case 215: /* no surface */ 
                         send_command("set atom -cpk");
                      if(liq_surf)
                         send_command("set atom -lico");
                      bang_it();
                      break;

            case 500: surf_style=0;
                      bang_it();
            PrintMessage(" ===> Surface is drawn as van der Waals spheres \n");
                      break;

            case 501: surf_style=1;
                      bang_it();
            PrintMessage(" ===> Surface is drawn as covalent radius spheres \n");
                      break;

            case 502: if(liq_surf == 0) liq_surf=1;
                      else liq_surf=0;
                      bang_it();
                      break;

            case 700: study_dynamics(1);
                      break;

            case 701: study_dynamics(2);
                      break;

            case 702: study_dynamics(3);
                      break;

            case 703: study_dynamics(4);
                      break;

            case 704: study_dynamics(5);
                      break;

            case 705: study_dynamics(6);
                      break;

            case 706: study_dynamics(7);
                      bang_it();
                      break;

            case 707: study_dynamics(8);
                      break;

            case 708: study_dynamics(9);
                      break;

            case 709: study_dynamics(10);
                      break;

            case 710: study_dynamics(11);
                      break;

            case 711: study_dynamics(12);
                      break;

            case 712: study_dynamics(13);
                      break;

            case 713: study_dynamics(14);
                      break;

            case 714: study_dynamics(15);
                      break;

            case 715: disp_obj[0] = 1;
                      break;

            case 716: colour_util(1); /* define background colour */
                      bang_it();
                      break;

            case 717: colour_util(2); /* define text colour  */
                      bang_it();
                      break;

            case 718: colour_util(3); /* define object colour */
                      bang_it();
                      break;

            case 719: def_frame_freq();
                      break;

#ifndef USEFORMS
            case 800: pre_read_karp();
                      input_file_set = 1;
                      damp = 1.0;
                      bang_it();
                      break;

            case 801: pre_read_pdb();
                      input_file_set = 2;
                      damp = 1.0;
                      bang_it();
                      break;

            case 802: /* ready to read in force field and atom types */
                      pre_force();
                      bang_it();
                      break;
 
            case 804: pre_read_yasp();
                      input_file_set = 2;
                      damp = 1.0;
                      bang_it();
                      break;

            case 810: pre_read_mopac();
                      input_file_set = 2;
                      damp = 1.0;
                      bang_it();
                      break;

            case 811: pre_read_insight();
                      input_file_set = 2;
                      damp = 1.0;
                      bang_it();
                      break;
#endif

            case 900: study_dynamics(16);
                      bang_it();
                      break;

            case 901: study_dynamics(17);
                      bang_it();
                      break;

            case 902: study_dynamics(18);
                      bang_it();
                      break;

            case 903: study_dynamics(19);
                      bang_it();
                      break;

            case 950: pre_utility();
                  /*    bang_it(); */
                      break;

            case 1000: /* sharp half bond type on */
                       b_disp_a = 1;
                       bang_it();
                       break;

            case 1001: /* soft bond type on       */
                       b_disp_a = 0;
                       bang_it();
                       break;

            case 1002: /* full screen on */
                       full_screen();
                       bang_it();
                       break;
         
            case 1003: /* full screen off */
                       endfull_screen();
                       bang_it();
                       break;

            case 1004: /* set licorice cylinder rad */
                       SetLicoParam(1);
                       bang_it();
                       break;

            case 1005: /* set licorice sphere rad */
                       SetLicoParam(2);
                       bang_it();
                       break;

            case 1006: /* set search window */
                       SetSearchWindow();
                       break;

            case 1007: /* Do a ldp plot */
                       send_command("plot ldp");
                       bang_it();
                       if(MenuList.Menu != 3) {
                          MenuList.SaveMenu = MenuList.Menu;
                          MenuList.Menu = 3;}
                       break;

            case 1008: /* Delete a ldp plot */
                       send_command("plot -ldp");
                       bang_it();
                       MenuList.Menu = MenuList.SaveMenu;
                       break;

            case 1009: /* Do a Ramachandran plot */
                       send_command("plot ramachandran");
                       bang_it();
                       break;

            case 1010: /* Delete a Ramachandran plot */
                       send_command("plot -ramachandran");
                       bang_it();
                       break;

            case 1011: /* plot trace   */
                       send_command("plot trace");
                       bang_it();
                       break;

            case 1012: /* delete trace plot */
                       send_command("plot -trace");
                       bang_it();
                       break;

            case 1013: /* set line width in pixels */
                       SetLineWidth();
                       bang_it();
                       break;

            case 1014: /* select from the command stack */
                       retv = MenuCStack();
                       DoI = 0;
                       break;

            case 1015: /* contour display     */
#if defined(USEFORMS) && defined(sgi)
                       SetUpContour();
#endif
                       break;

            case 1016: /* turn contour off    */
                       send_command("plot -contour");
                       bang_it();
                       break;

#if defined(USEFORMS) && defined(sgi)
            case 1017: /* show read form    */
                       FormsForRead();
                       bang_it();
                       break;


            case 1018: /* show read text    */
                       (void)send_command("read text");
                       break;

            case 1019: /* read a dictionary file */
                       (void)ShowReadDict();
                       break;
#endif

            case 1020: /* edit bond => add */
                       AddNewBond();
                       bang_it();
                       break;

            case 1021: /* edit bond => delete */
                       DeleteOldBond();
                       bang_it();
                       break; 

            case 1022: /* edit text     */
#if defined(USEFORMS) && defined(sgi)
                       edit_text("***","***",0);
#else
                       PrintMessage("?ERROR - not implemented on this device");
#endif
                       break;

            case 1023: /* change file masks     */
#if defined(USEFORMS) && defined(sgi)
                       (void)ShowFormMask();
#else
                       PrintMessage("?ERROR - not implemented on this device");
#endif
                       break;

            case 1024: /* stereo mode */
#if defined(USEFORMS) && defined(sgi)
                       (void)Show_Form_StereoMode();
#else
                       PrintMessage("?ERROR - not implemented on this device");
#endif
                       break;

/* ldp switches ... */
            case 5000: /* analyse */
                       PollLdpMouse();
                       break;

            case 5001: /* return */
                       send_command("plot -ldp");
                       MenuList.Menu = MenuList.SaveMenu;
                       bang_it();
                       break;

            case 6000: /* reset scarecrow */
                       PrintMessage("Reseting SCARECROW \n");
                       reset_scarecrow();
                       PrintMessage("Done ...\n");
                       bang_it();
                       break;
      
            case  5: shut_down(0);}
            if(DoI) {
             strncpy(bottom_line,"** Choose from the main menu",PORTchar);
             going_on();}
            DoI = 1;}


      }
      if(do_it) {
         bang_it();
         do_it = 0;}
      }
}

#endif

/***********************************************************************/
calc_mp(alt)  /* calculate molecule mid point */
     int alt;
/***********************************************************************/
{
     int i;
     float numsum;
     int from,to;
     char OutText[BUFF_LEN];


     from = mlists[mlist_deep - 1];
     to   = mliste[mlist_deep - 1];

     if(alt == 0) {

       if(mlist_deep != 1) { /* correct the already read in coordinates */
         for(i = mlists[0] ; i < mliste[mlist_deep - 2] ; i++) {
            x[i] += sumx;
             y[i] += sumy;
              z[i] += sumz;}}

       sumx=0.0; sumy=0.0; sumz=0.0;
       numsum = 0.0;

     from = mlists[0];
     to   = mliste[mlist_deep - 1];

       for(i = from ; i < to ; i++) {
       if(disp_list[i] == 0) continue;
       numsum = numsum + 1.;
       sumx=sumx+x[i]; sumy=sumy+y[i]; sumz=sumz+z[i]; }

       sumx=sumx/numsum; 
        sumy=sumy/numsum; 
         sumz=sumz/numsum;

       trax[0]= -sumx;
        tray[0]= -sumz;
         traz[0]= -sumz;
     }

     for(i = from ; i < to ; i++) {
      x[i]=x[i]-sumx; y[i]=y[i]-sumy; z[i]=z[i]-sumz; }


     if(DebugS.DebugL) {
       sprintf(OutText,"Translating ... x: %f , y: %f , z: %f \n",
                        -sumx,-sumy,-sumz);
       PrintMessage(OutText);}

}

#ifdef sgi

/***********************************************************************/
void draw_obj()  /* main object displayer */
/***********************************************************************/
{

   if(draw_obj_disp == 0 ) return; /* no display */

   if(mliste[mlist_deep - 1] < 1) return; /* no atoms to display */

   plot_stick();     /* plot the stick display */

   if(alpha_trace) stick_alpha(); /* alpha trace display */

   if(liq_surf > 0) {  /* do the liquorice display */
   liquorice();
/*   return; */ }

   if(yn_surf > 0 ) {
   plot_cpk();
   }

}

#endif

/***********************************************************************/
cal_moment()   /* calculate the moment */
/***********************************************************************/
{

  int i;
  float sum,charge,msumx,msumy,msumz;
  char OutText[BUFF_LEN];

  msumx=0.0;
   msumy=0.0;
    msumz=0.0;

  charge=0.0;

   if(mliste[mlist_deep - 1] < 1) return; /* no atoms */

   for( i = mlists[mlist_deep - 1] ; i < mliste[mlist_deep - 1] ; i++) {

    msumx = msumx + x[i]*atm_charge[i];
    msumy = msumy + y[i]*atm_charge[i];
    msumz = msumz + z[i]*atm_charge[i];

    charge = charge + atm_charge[i];}

   mx[0]=msumx ;
   my[0]=msumy ;
   mz[0]=msumz ;

   sum = sqrt(msumx*msumx + msumy*msumy + msumz*msumz);

   sprintf(OutText," Charge of molecule is : %f \n",charge);
   PrintMessage(OutText);
   sprintf(OutText," sumx: %f , sumy: %f , sumz: %f , sum: %f\n",msumx,msumy,msumz,sum);
   PrintMessage(OutText);
}

#ifdef sgi

/***********************************************************************/
void draw_cube()  /* display a cube around the molecule */
/***********************************************************************/
{

    DrawBox( cell.a      , cell.b      , cell.c , 
             cell.Xtrans , cell.Ytrans , cell.Ztrans );

}
/***********************************************************************/
void DrawCube(Side , Xplace , Yplace , Zplace)  
                   /* display a cube around the molecule (side length is 
                      Side  at Xplace , Yplace and Zplace ) */
     float Side;
     float Xplace;
     float Yplace;
     float Zplace;
/***********************************************************************/
{

    static pixel2 = 2;

    c3s(obcolor);

    Side = 0.5 * Side;
    
/* set line width to at least 2 pixels */

     if(line_width < 2) linewidth(pixel2);

     pushmatrix();
     translate(Xplace , Yplace , Zplace);

     move(-Side , -Side , -Side);
     draw(-Side , -Side ,  Side);
     draw( Side , -Side ,  Side);
     draw( Side ,  Side ,  Side);
     draw(-Side ,  Side ,  Side);
     draw(-Side , -Side ,  Side);
     move(-Side , -Side , -Side);
     draw(-Side ,  Side , -Side);
     draw( Side ,  Side , -Side);
     draw( Side , -Side , -Side);
     draw(-Side , -Side , -Side);
     move( Side , -Side , -Side);
     draw( Side , -Side ,  Side);
     move(-Side ,  Side , -Side);
     draw(-Side ,  Side ,  Side);
     move( Side ,  Side , -Side);
     draw( Side ,  Side ,  Side);

     popmatrix();

     linewidth(line_width);
}

/***********************************************************************/
void DrawBox(SideX , SideY , SideZ , Xplace , Yplace , Zplace)  
                                     /* display a cube around the molecule 
                                        (side length is SideX, SideY and
                                        SideZ) */
     float SideX;
     float SideY;
     float SideZ;
     float Xplace;
      float Yplace;
       float Zplace;
/***********************************************************************/
{

    static pixel2 = 2;

    c3s(obcolor);

    SideX = 0.5 * SideX;
     SideY = 0.5 * SideY;
      SideZ = 0.5 * SideZ;
    
/* set line width to at least 2 pixels */

     if(line_width < 2) linewidth(pixel2);

     pushmatrix();
     translate( Xplace , Yplace , Zplace);

     move(-SideX , -SideY , -SideZ);
     draw(-SideX , -SideY ,  SideZ);
     draw( SideX , -SideY ,  SideZ);
     draw( SideX ,  SideY ,  SideZ);
     draw(-SideX ,  SideY ,  SideZ);
     draw(-SideX , -SideY ,  SideZ);
     move(-SideX , -SideY , -SideZ);
     draw(-SideX ,  SideY , -SideZ);
     draw( SideX ,  SideY , -SideZ);
     draw( SideX , -SideY , -SideZ);
     draw(-SideX , -SideY , -SideZ);
     move( SideX , -SideY , -SideZ);
     draw( SideX , -SideY ,  SideZ);
     move(-SideX ,  SideY , -SideZ);
     draw(-SideX ,  SideY ,  SideZ);
     move( SideX ,  SideY , -SideZ);
     draw( SideX ,  SideY ,  SideZ);

     linewidth(line_width);

     popmatrix();
}

#endif

/***********************************************************************/
void rotateO( angl , axis)  /* own rotation driver */

  short angl;
  char axis;
/***********************************************************************/
{
/* externals  

  extern float pia,rotM[][4],rotS[][4];

*/

  static float rot_angle;

#ifdef DEBUG
  static char OutText[BUFF_LEN];
#endif

  register float cosa , sina;      /* temporary scalars  */

  if(!(angl >= 0 ? angl : -angl)) return;

  rot_angle = pia1800*(float)(angl);  /* angle in tenths of degrees */

#ifdef sgi
  cosa = fcos(rot_angle);
  sina = fsin(rot_angle);
#else
  cosa = cos((double)rot_angle);
  sina = sin((double)rot_angle);
#endif

  if(axis == 'x' || axis == 'X') {  /* x-axis rotation */

#ifdef DEBUG
  sprintf(OutText,"Rotate %d 0 0 ",angl);
  PrintMessage(OutText);
#endif

  rotM[0][0]=1.;
  rotM[0][1]=0.0;
  rotM[0][2]=0.0;
  rotM[0][3]=0.0;

  rotM[1][0]=0.0;
  rotM[1][1]=  cosa;
  rotM[1][2]=  sina;
  rotM[1][3]=0.0;

  rotM[2][0]=0.0;
  rotM[2][1]= -sina;
  rotM[2][2]=  cosa;
  rotM[2][3]=0.0;

  rotM[3][0]=0.0;
  rotM[3][1]=0.0;
  rotM[3][2]=0.0;
  rotM[3][3]=1.0;

#ifdef sgi      
  getmatrix(rotS);
  loadmatrix(rotM);
  multmatrix(rotS); 

#endif

  return;           }  /* end of x-rotation */

  if(axis == 'y' || axis == 'Y') {  /* y-axis rotation */

#ifdef DEBUG
  sprintf(OutText,"Rotate 0 %d 0 ",angl);
  PrintMessage(OutText);
#endif

  rotM[0][0]=  cosa;
  rotM[0][1]=0.0;
  rotM[0][2]= -sina;
  rotM[0][3]=0.0;

  rotM[1][0]=0.0;
  rotM[1][1]=1.0;
  rotM[1][2]=0.0;
  rotM[1][3]=0.0;

  rotM[2][0]=  sina;
  rotM[2][1]=0.0;
  rotM[2][2]=  cosa;
  rotM[2][3]=0.0;

  rotM[3][0]=0.0;
  rotM[3][1]=0.0;
  rotM[3][2]=0.0;
  rotM[3][3]=1.0;

#ifdef sgi    
  getmatrix(rotS);
  loadmatrix(rotM);
  multmatrix(rotS); 

#endif

  return;         }  /* end of y-rotation */

  if(axis == 'z' || axis == 'Z') {  /* z-axis rotation */

#ifdef DEBUG
  sprintf(OutText,"Rotate 0 0 %d ",angl);
  PrintMessage(OutText);
#endif

  rotM[0][0]=  cosa;
  rotM[0][1]=  sina;
  rotM[0][2]=0.0;
  rotM[0][3]=0.0;

  rotM[1][0]= -sina;
  rotM[1][1]=  cosa;
  rotM[1][2]=0.0;
  rotM[1][3]=0.0;

  rotM[2][0]=0.0;
  rotM[2][1]=0.0;
  rotM[2][2]=1.0;
  rotM[2][3]=0.0;

  rotM[3][0]=0.0;
  rotM[3][1]=0.0;
  rotM[3][2]=0.0;
  rotM[3][3]=1.0;

#ifdef sgi      
  getmatrix(rotS);
  loadmatrix(rotM);
  multmatrix(rotS); 
  
#endif

  return;        }  /* end of z-rotation */

}

/***********************************************************************/
translateO( xt , yt , zt)  /* own translator driver */

  float xt,yt,zt;
/***********************************************************************/
{
/* externals  

  extern float rotM[][4],rotS[][4];

*/
/*
  static float farmnear;
  farmnear = far - near;
*/
#ifdef DEBUG
  static char OutText[BUFF_LEN];
#endif  

  rotM[0][0]=1.;
  rotM[0][1]=0.0;
  rotM[0][2]=0.0;
  rotM[0][3]=0.0;

  rotM[1][0]=0.0;
  rotM[1][1]=1.0;
  rotM[1][2]=0.0;
  rotM[1][3]=0.0;

  rotM[2][0]=0.0;
  rotM[2][1]=0.0;
  rotM[2][2]=1.0;
  rotM[2][3]=0.0;

  rotM[3][0]= xt ; /* - (far + xt + near + xt) / farmnear; */  
  rotM[3][1]= yt ; /* - (far + yt + near + yt) / farmnear; */ 
  rotM[3][2]= zt ; /* - (far + zt + near + zt) / farmnear; */
  rotM[3][3]=    1.0;

#ifdef DEBUG
  sprintf(OutText,"Translate %f %f %f ",xt,yt.zt);
  PrintMessage(OutText);
#endif

#ifdef sgi


  getmatrix(rotS);
  loadmatrix(rotM);
  multmatrix(rotS); 

#endif

} /* end of own translator */

/***********************************************************************/
scaleO( xt , yt , zt)  /* own scale driver */

  float xt,yt,zt;
/***********************************************************************/
{
/* externals  

  extern float rotM[][4],rotS[][4];

*/

#ifdef DEBUG
  static char OutText[BUFF_LEN];
#endif  

  rotM[0][0]=xt;
  rotM[0][1]=0.0;
  rotM[0][2]=0.0;
  rotM[0][3]=0.0;

  rotM[1][0]=0.0;
  rotM[1][1]=yt;
  rotM[1][2]=0.0;
  rotM[1][3]=0.0;

  rotM[2][0]=0.0;
  rotM[2][1]=0.0;
  rotM[2][2]=zt;
  rotM[2][3]=0.0;

  rotM[3][0]= 0.0;
  rotM[3][1]= 0.0;
  rotM[3][2]= 0.0;
  rotM[3][3]= 1.0;

#ifdef DEBUG
  sprintf(OutText,"Scale %f %f %f ",xt,yt.zt);
  PrintMessage(OutText);
#endif

#ifdef sgi


  getmatrix(rotS);
  loadmatrix(rotM);
  multmatrix(rotS); 

#endif

} /* end of own scale */


/***********************************************************************/
disp_zone(fun)  /* determines which atoms are to be displayed */

 int fun;
/***********************************************************************/
{
  int i,j;
  float rad;
  char text[BUFF_LEN];
  char comm_text[BUFF_LEN];

  switch(fun) {

  case 1:

#ifdef sgi

  dialog4("Choose display zone ...","Give range:  ",text);

  sprintf(comm_text,"set atom displ %s",text);
  send_command(comm_text);
  return;  
#else

  PrintMessage("?ERROR - not implemented on this device \n");
  return;
#endif

  case 2:

  PrintMessage(" Reseting zone ...\n\n");

        if(mlist_deep < 2)
          strncpy(text,"set atom displ *:*:*",BUFF_LEN);
        else
          strncpy(text,"set atom displ *:*:* append",BUFF_LEN);

          send_command(text);
  alpha_trace=0;
  return;

  case 4:    /* build alpha trace list */

  /* send command can't be used here because the type in command is using
     this part (fix it as soon as possible)*/

  ca_num = 0;
  for(j = 0 ; j < mlist_deep ; j++) {
  for( i = mlists[j] ; i < mliste[j] ; i++) {
    ca_disp_list[i] = 0;
     if(!disp_list[i]) continue;                  /* put only currently
                                                     displayed CA atoms to
                                                     the CA list */
     disp_list[i]=0;  /* turn off atom display */

  if(strncmp(atnam+MAX_ATM_NAME_LEN*i,"CA",2) == 0) {
  disp_list[i]    = 1;  /* turn on atom display */
  ca_disp_list[i] = 1;}} 

  for( i = mlists[j] ; i < mliste[j] ; i++) {
  if(ca_disp_list[i] == 0) continue;
  if(strncmp(atnam+MAX_ATM_NAME_LEN*i,"CA",2) == 0) {
  ca_list[ca_num] = i;
  ca_num = ca_num + 1;
  disp_list[i] = 1;  /* turn ca atoms display on */

  if(ca_num >= MAXca) {
  PrintMessage("** ERROR. Too many alpha carbons \n\n");
  return; }
}}}

  alpha_trace=1;
  gap_check();
  return;

  case 3:
#ifdef sgi

  dialog4("Display zone is chosen by a sphere ...","Give radius:  ",text);
  rad = atof(text);

  dialog4("Display zone is chosen by a sphere ...","Give range:  ",text);

  sprintf(comm_text,"set atom round %s %f",text,rad);

  send_command(comm_text);

  return;
#endif

   case 5:
#ifdef sgi
  again6:;
  dialog4("Display zone is chosen by append...","Give range:  ",text);

  sprintf(comm_text,"set atom display %s append",text);

  send_command(comm_text);

  PrintMessage("\n OK...\n\n");

  return;
  

#else
  PrintMessage("?ERROR - not implemented on this device \n");
  return;
#endif

  }
}


/***********************************************************************/
gap_check()  /* checks if there are several non connected chains */
/***********************************************************************/
{

/*  
    subroutine for checking if there are "gaps" in the alpha-carbon chain 

    Leif Laaksonen 1989

*/

    int i,j,k;
    float dist;
    float tmp1,tmp2,tmp3;
    char OutText[BUFF_LEN];

    gap_vec[0]=0;
    gap_loop=0;

    for( i = 1 ; i < ca_num ; i++) {
     j = ca_list[i];
      k = ca_list[i-1];
       gap_vec[i]=0;
        tmp1 = (x[j]-x[k]);
        tmp2 = (y[j]-y[k]);
        tmp3 = (z[j]-z[k]);
        dist = tmp1 * tmp1 + tmp2 * tmp2 + tmp3 * tmp3;

    if(dist > GAP_dist ) { 
    sprintf(OutText,"Chain break between CA (Res. num %d) - CA (Res.num %d)",
            res1[k],res1[j]);
    PrintMessage(OutText);
    gap_loop=gap_loop+1;
    gap_vec[i] = 1 ; } 
    } 

/* look also for different molecules */
    if(mlist_deep < 2) return;
    for(j = 1 ; j < mlist_deep ; j++) { 
       i = mlists[j];
       gap_vec[i] = 1;
       gap_loop++;}

}

/***********************************************************************/
set_colour(alt)   /* default atom colouring */
     int alt;     /* = 0 set atom colours first time ,
                    != 0 reset atom colours to the default */
/***********************************************************************/
{                /* Set the default colouring on 
                    Leif Laaksonen   1989        */
   int i,j;
   int from,to;
   int Found;

   if(mlist_deep < 1) 
     PrintMessage("?ERROR - no atoms defined (can't define colours)");

   if(alt) {
      if(mlist_deep > 1 && term_type == 1) sel_struct(&i);
      else
      i = current_struct;

      if(i != mlist_deep) {
         from = mlists[current_struct];
         to   = mliste[current_struct];}
      else {
         from = mlists[0];
         to   = mliste[mlist_deep - 1];}}
    else {
         from = mlists[current_struct];
         to   = mliste[current_struct];}


     for( i = from ; i < to ; i++ ) {

     Found = 0;

     if(!alt) {
      disp_list[i]=1; /* full display on */
       surface_list[i] = surface_reset; 
        liquorice_list[i] = surface_reset;}

/* default colour cyan      */
                                       atmcol[i][0] = CYANv[0];
                                       atmcol[i][1] = CYANv[1];
                                       atmcol[i][2] = CYANv[2];

/* first try to match 2 characters ... */

      for(j=0 ; j < atm_col_num ; j++) {

       if(isdigit(atnam[MAX_ATM_NAME_LEN*i])) {
          if(strncmp((atnam+MAX_ATM_NAME_LEN*i+1),
	              def_atm_col+MAX_ATM_NAME_LEN*j,2) == 0) {
	                         atmcol[i][0] = def_acol[j][0];
	                         atmcol[i][1] = def_acol[j][1];
	                         atmcol[i][2] = def_acol[j][2];
				              Found = 1;
				              break;}}
       
       else if(strncmp((atnam+MAX_ATM_NAME_LEN*i),
                   def_atm_col+MAX_ATM_NAME_LEN*j,2) == 0) {
                              atmcol[i][0] = def_acol[j][0];
                              atmcol[i][1] = def_acol[j][1];
                              atmcol[i][2] = def_acol[j][2];
       Found = 1;
       break;}
       }

/* if no match try a 1 character match ... */

      if(!Found) {
      for(j=0 ; j < atm_col_num ; j++) {

       if(isdigit(atnam[MAX_ATM_NAME_LEN*i])) {
          if(strncmp((atnam+MAX_ATM_NAME_LEN*i+1),
	              def_atm_col+MAX_ATM_NAME_LEN*j,1) == 0) {
	                         atmcol[i][0] = def_acol[j][0];
	                         atmcol[i][1] = def_acol[j][1];
	                         atmcol[i][2] = def_acol[j][2];
				              break;}}

       else if(strncmp((atnam+MAX_ATM_NAME_LEN*i),
                   def_atm_col+MAX_ATM_NAME_LEN*j,1) == 0) {
                              atmcol[i][0] = def_acol[j][0];
                              atmcol[i][1] = def_acol[j][1];
                              atmcol[i][2] = def_acol[j][2];
       break;}
     }}

 }

}

/***********************************************************************/
colour_zone(fun)  /* determines which atoms should be coloured */

 int fun;
/***********************************************************************/
{
  char text[BUFF_LEN];
  char comm_text[BUFF_LEN];

  switch(fun) {

  case 1:

again: ;

  dialog4("Choose colour zone ...","Give range:  ",text);

#ifdef USEFORMS
  if(Show_Edit_Colour()) return;
#else
  edit_colour();
#endif

  sprintf(comm_text,"set atom colo %s  %d %d %d",text,red,green,blue);
  send_command(comm_text);

  PrintMessage("\n OK...\n\n");
  return;
  
  case 2:
  PrintMessage(" Reseting zone ...\n\n");
  colour_structure_by = 0;
  set_colour(1);
  return;
  }
}

 
/***********************************************************************/
edit_colour()   /* lets the user choose a colour */
/***********************************************************************/

{
     int k;
     int oldx,oldy;
     int dx,dy;

#ifdef sgi
     prefposition(getgdesc(GD_XPMAX)-240 , getgdesc(GD_XPMAX)-40 , 10 , 210 );
     k=winopen("Edit");
     doublebuffer();
     RGBmode();
     gconfig();


     qdevice(REDRAW);
     qdevice(LEFTMOUSE);
     qdevice(MIDDLEMOUSE);
     qdevice(MOUSEX);
     qdevice(MOUSEY);
     qdevice(ESCKEY);
     qdevice(RIGHTMOUSE);
     qdevice(RKEY);


     winset(k);  /* set to new window */

{
     short collect[3];
      collect[0] = (short)red;
       collect[1] = (short)green;
        collect[2] = (short)blue;
     c3s( collect );
     clear() ;
      ScareSwapbuffers();}

      reshapeviewport();

      colour_box();

      while(1) {
       while(qtest()) {
       dev=qread(&val);
         if( dev == REDRAW ) {

      reshapeviewport();
      clear();

      ScareSwapbuffers(); 
          }

          else if (dev == ESCKEY) {
          shut_down(0); }

          else if (dev == MOUSEX) {
               oldx=xval;
               xval=val;
               dx=oldx-xval;
               
           if(getbutton(LEFTMOUSE)) {

               red = red + dx;
               if(red > 255) red = 255;
               if(red < 0  ) red =   0;

               colour_box(); }

            if(getbutton(MIDDLEMOUSE)) {
               green = green + dx;
               if(green > 255) green = 255;
               if(green < 0  ) green =   0;

              colour_box();}

            if(getbutton(RIGHTMOUSE)) {
               blue = blue + dx;
               if(blue > 255) blue = 255;
               if(blue < 0  ) blue =   0;

              colour_box();}}

          else if (dev == MOUSEY) {
            oldy=yval;
            yval=val;
            dy=oldy-yval;

           if(getbutton(LEFTMOUSE)) {
               red = red + dy;
               if(red > 255) red = 255;
               if(red < 0  ) red =   0;

            colour_box();}

           if(getbutton(MIDDLEMOUSE)) {
               green = green + dy;
               if(green > 255) green = 255;
               if(green < 0  ) green =   0;

            colour_box();}

            if(getbutton(RIGHTMOUSE)) {
               blue = blue + dy;
               if(blue > 255) blue = 255;
               if(blue < 0  ) blue =   0;

              colour_box();}}

          else if (dev == RKEY) {
           qreset();
          winclose(k);
          return;}

        }
      }
#else

     PrintMessage("?ERROR - not implemented on this device \n");

#endif

}

#ifdef sgi

/***********************************************************************/
colour_box()   /* make a coloured box */
/***********************************************************************/
{
     int put3=130, put2=70, put1=10,put4=170;
     short collect[BUFF_LEN];
     char text[BUFF_LEN];

     collect[0] = red;
      collect[1] = green;
       collect[2] = blue;

               c3s( collect );
               clear();
               c3s(txcolor);
               cmov2i(5 , put4);
               charstr("* press 'r' to return *");
               c3s(REDv);
               sprintf(text,"%d",red);
               cmov2i(50 , put3);
               charstr(text);
               c3s(GREENv);
               sprintf(text,"%d",green);
               cmov2i(50 , put2);
               charstr(text);
               c3s(BLUEv);
               sprintf(text,"%d",blue);
               cmov2i(50 , put1);
               charstr(text);
               c3s( collect );
              ScareSwapbuffers();

}

#endif

/***********************************************************************/
build_sphere(n,radius)   /* render a sphere */
   int n;
   float radius;
/***********************************************************************/
{

/*  externals  

    extern float vsphe[][3];

*/


   int i,j,k,m;
   float jstep,ysphek,zsphek,xsphei,ysphei;
   float delta,istep,jjstep,iistep;

   m = 2 * n;
   istep = pia / (float) (n - 1);
   jstep = 2.0 *  pia / (float) (m - 1);
   delta = 1.e-05;
   k=0;

   for( i = 1 ; i <= n ; i++) {

       iistep = (i-1)*istep + delta;
       xsphei = radius * cos(iistep);
       ysphei = radius * sin(iistep);

          for( j = 1 ; j <= m ; j++) {
       jjstep=(j-1)*jstep;
       ysphek   =  ysphei*cos(jjstep);
       zsphek   = -ysphei*sin(jjstep);
       vsphe[k][0] =  xsphei;
       vsphe[k][1] =  ysphek;
       vsphe[k][2] =  zsphek;

/*
       printf(" jstep: %f jjstep: %f\n",jstep,jjstep);
       printf(" cos(jjstep): %f sin(jjstep): %f\n",cos(jjstep),sin(jjstep));
       printf(" %f %f %f\n",vsphe[k][0],vsphe[k][1],vsphe[k][2]);
*/

       ++k;
       if( k > MAXsphp) {
       PrintMessage(">>>> ERROR , too many points in the vsphe array <<<<<\n");
       shut_down (1);}
       } delta=0.0; }

}


#ifdef sgi

/*
** def_simple_light_calc()
** tell the graphics library to DEFINE a simple
** lighting calculation that accounts for diffuse
** and ambient reflection. 
*/
/***********************************************************************/
def_simple_light_calc()
/***********************************************************************/
{
/*
     lmdef(DEFMATERIAL, 1 , 0  , material);
     lmdef(DEFLIGHT, 1 , 0 , light1);
     lmdef(DEFLIGHT, 2 , 0 , light2);
     lmdef(DEFLMODEL, 1 , 0 , NULL);
*/
     DefineMaterials();
     DefineLights();
     lmdef(DEFLMODEL, 1 , 0 , NULL);
}

/*
** use_simple_light_calc()
** tell the graphics library to USE the simple lighting calculation
** that we defined earlier
*/
use_simple_light_calc()
{
     SetMaterial( 22 );
     SetLight( 1 );
     lmbind(LMODEL , 1);
}

#endif

/*
     Format of the atom parameter file. Most values are the same as in
     the parameter file in QUANTA (Polygen) or the equivalent parameter
     file in CHARMM.
 
     Leif Laaksonen  1989,1991

     I will also include some own parameters when I have the time.

All this data is taken from APPENDIX B of the QUANTA Reference Manual 1990.
===========================================================================

     The titles of the columns in the file are:

 (1)    (2)     (3)     (4)     (5)     (6)    (7)   (8)   (9)    (10)  (11)
Number bndrad  vdwrad  plurad  global  emin   rmin  patom hbond  atype mass 
 1     0.4000  0.9500  0.100     F    -0.0498  0.8  0.044  D     H     1.008  
 .
 .
 .

(1):    Atom type number (type).
(2):    Bonding radius (bndrad).
(3):    van der Waals spheres radius (vdwrad).
(4):    Sphere radius (plurad) in plots. (Not used in SCARECROW).
(5):    Value (global) is used in global search for bonds.
(6,7):  Value (emin and rmin) used in the calculation of van der
        Waals and electrostatic energy. 
(8):    Atom polarizabilities (patom).
(9):    The atom is either a hydrogen bond acceptor (A), donor (D or E), or
        not hydrogen bonded (N)
(10):   The CHARMm atom type (atype).
(11):   Atom mass (mass).

The parameters in QUANTA 3.0 are similar to those used in Vesion 21 of CHARMm.
The emin rmin values differ for HA and all metals; bndrad differs for 
hydrogens. Atoms with Mxx are metals; atoms with Xxx are halogens.

If you wish to extend the parameter file to include your own atom types, it is
recommended to use atom numbers greater than 300.

*/


/***********************************************************************/
int read_par(par_file)
     char *par_file;               /* name of the par file to be read */
/***********************************************************************/
{

/*  externals    */


/*               */

     int  i,j,k,lines=0,linel=BUFF_LEN;
     char input[MAXlinel];
     char text[MAXlinel];
     char temp1[BUFF_LEN];
     char temp2[BUFF_LEN];
     char temp3[BUFF_LEN];
     FILE *par_p;

     char chelp[BUFF_LEN];
     char OutText[BUFF_LEN];
     
#ifdef EXTERNALS
/*
     external routines

     extern int tupper(/* string */);
     extern void print_line(/* string */);

*/
#endif

/* look always only into the data directory */
     strncpy(chelp,scr_data,BUFF_LEN);
     strcat(chelp,"/");
     strncat(chelp,par_file,(BUFF_LEN - strlen(chelp)));

     par_p=fopen(chelp,"r");
     if(par_p==NULL) {
     sprintf(OutText,"?ERROR -  Can't open parameter file: %s \n",chelp);
     PrintMessage(OutText);
     shut_down (1); }

/*   We are ready now to start reading.
     First line HAS to start with a "*". After that it is free to have or
     have not a coment. Last line has to be just a "*"  */

#ifdef DEBUG
     sprintf(OutText,"Reading par203.par-file: %s ...",chelp);
     PrintMessage(OutText);
#endif

/* 1 line */
     fgets(input,MAXlinel,par_p);   /*    read first line and check for "*" */
     if(input[0] != '*') {
     PrintMessage("\n>>>>>> First line in a par-file has to start with a '*'-sign <<<<<<\n\n");
     return (1); }

/*  read rest of the file (main loop)    */
     i=0;
     while(fgets(input,MAXlinel,par_p) != NULL) {

     tupper(input);   /*  switch to upper case letters   */

     sscanf(input,"%d %f %f %f %c %f %f %f %c %s %f\n",
     &param203[i].type,
     &param203[i].bndrad,
     &param203[i].vdwrad,
     &param203[i].plurad,
     temp1,
     &param203[i].emin,
     &param203[i].rmin,
     &param203[i].patom,
     temp2,
     temp3,
     &param203[i].mass);
     param203[i].global = temp1[0];
      param203[i].hbond  = temp2[0];
       strncpy(param203[i].atype,temp3, MAX_ATM_NAME_LEN );
        param203[i].cnct = 0;  /* not used now */
     ++i; 
     if(i > MAXatc) {
     PrintMessage("\n\n>>>>>>> MAXatc reached in read_par <<<<<<<\n\n");
     return (1);}}

     param203_terms = i;
   
#ifdef DEBUG
     for(j = 0 ; j < i; j++) {

     printf("%d %f %f %f %c %f %f %f %c %.4s\n",
     param203[j].type,
     param203[j].bndrad,
     param203[j].vdwrad,
     param203[j].plurad,
     param203[j].global,
     param203[j].emin,
     param203[j].rmin,
     param203[j].mass,
     param203[j].cnct,
     param203[j].hbond,
     param203[j].atype);
} 

#endif
   
     fclose(par_p);

#ifdef DEBUG
     PrintMessage(" done\n");
#endif 

    return (0);
}



/*    Utility function to convert character string to upper case */
/***********************************************************************/
tupper( string )
char string[];
/***********************************************************************/
{
  int i,j;

  i=0;

  while(string[i] != '\0')
        ++i;
  for( j = 0 ; j < i ; j++)
      string[j]=toupper(string[j]);
}
/*   Utility function to convert character string to lower case  */
/***********************************************************************/
toller( string )
char string[];
/***********************************************************************/
{
  int i,j;

  i=0;

  while(string[i] != '\0')
        ++i;
  for( j = 0 ; j < i ; j++)
      string[j]=tolower(string[j]);
}

/*    Utility function to convert character string to upper case up
      to the '(' */
/***********************************************************************/
tupper2p( string )
char string[];
/***********************************************************************/
{
  int i,j;

  i=0;

  while(string[i] != '\0' && string[i] != '(')
        ++i;
  for( j = 0 ; j < i ; j++) 
      string[j]=toupper(string[j]);
}
/*   Utility function to convert character string to lower case  */
/***********************************************************************/
toller2p( string )
char string[];
/***********************************************************************/
{
  int i,j;

  i=0;

  while(string[i] != '\0' && string[i] != '(')
        ++i;
  for( j = 0 ; j < i ; j++)
      string[j]=tolower(string[j]);
}

/*    Utility function to convert character string to upper case up
      to the '[' */
/***********************************************************************/
tupper2b( string )
char string[];
/***********************************************************************/
{
  int i,j;

  i=0;

  while(string[i] != '\0' && string[i] != '[')
        ++i;
  for( j = 0 ; j < i ; j++) 
      string[j]=toupper(string[j]);
}
/*   Utility function to convert character string to lower case  */
/***********************************************************************/
toller2b( string )
char string[];
/***********************************************************************/
{
  int i,j;

  i=0;

  while(string[i] != '\0' && string[i] != '[')
        ++i;
  for( j = 0 ; j < i ; j++)
      string[j]=tolower(string[j]);
}

/***********************************************************************/
vdw_rad()  /* determine the van der Waals radius */
/***********************************************************************/
{

    int i,j;
    int from,to;

    from = mlists[mlist_deep - 1];
    to   = mliste[mlist_deep - 1];

  for(i = from ; i < to ; i++) {

/* brookhaven protein databank files can have hydrogens where the first
   character is a number
*/
    if(isdigit(atnam[MAX_ATM_NAME_LEN*i])) {
       if(atnam[MAX_ATM_NAME_LEN*i+1] == 'H') {   /* default atom type 3 */
          vdw_list[i] = find_vdwrad(3); continue;}}

/* .... */
	   
    if(!strncmp(atnam+MAX_ATM_NAME_LEN*i,"Ca",2)) { /* Calcium  84 */
       vdw_list[i] = find_vdwrad(84); continue;}

    if(!strncmp(atnam+MAX_ATM_NAME_LEN*i,"Na",2)) { /* Sodium   81 */
       vdw_list[i] = find_vdwrad(81); continue;}

    if(!strncmp(atnam+MAX_ATM_NAME_LEN*i,"Cl",2)) { /* Chlorine 93 */
       vdw_list[i] = find_vdwrad(93); continue;}

    if(!strncmp(atnam+MAX_ATM_NAME_LEN*i,"Si",2)) { /* Silicon 90 */
       vdw_list[i] = find_vdwrad(90); continue;}

    if(!strncmp(atnam+MAX_ATM_NAME_LEN*i,"Sn",2)) { /* Led    113 */
       vdw_list[i] = find_vdwrad(113); continue;}

    if(atnam[MAX_ATM_NAME_LEN*i] == 'H') {   /* default atom type 3 */
     vdw_list[i] = find_vdwrad(3); continue;}

    if(atnam[MAX_ATM_NAME_LEN*i] == 'C') {   /* default atom type 10 */
     vdw_list[i] = find_vdwrad(10); continue;}

    if(atnam[MAX_ATM_NAME_LEN*i] == 'N') {   /* default atom type 32 */
     vdw_list[i] = find_vdwrad(32); continue;}

    if(atnam[MAX_ATM_NAME_LEN*i] == 'O') {   /* default atom type 40 */
     vdw_list[i] = find_vdwrad(40); continue;}

    if(atnam[MAX_ATM_NAME_LEN*i] == 'P') {   /* default atom type 60 */
     vdw_list[i] = find_vdwrad(60); continue;}

    if(atnam[MAX_ATM_NAME_LEN*i] == 'S') {   /* default atom type 70 */
     vdw_list[i] = find_vdwrad(70); continue;}

    vdw_list[i] = find_vdwrad(499);}     /* default atom type */
    

}

/***********************************************************************/
build_array()   /* ???  */
/***********************************************************************/
{
    int i;

    sphere_array[0] = 0;
    for(i = 1 ; i <= sphere_seg ; i++)
    sphere_array[i] = 2*sphere_seg*i;
}

/*   Subroutine bangle          */
/*   Calculate the angle between atoms i,j and k
     using c2=a2+b2-2ab*cos(angle)
     and calculate the bond lengths i-j and j-k.

     leif laaksonen   1989

*/

/***********************************************************************/
bangle( i, j, k , angijk )  /* calculate bond angle */
float *angijk ;
/***********************************************************************/
{
static double d2ij,d2jk,d2ik,tmp1,tmp2,tmp3,temp;

            tmp1 = (x[i]-x[j]);
            tmp2 = (y[i]-y[j]);
            tmp3 = (z[i]-z[j]);

       d2ij= tmp1 * tmp1 +
             tmp2 * tmp2 +
             tmp3 * tmp3;

            tmp1 = (x[j]-x[k]);
            tmp2 = (y[j]-y[k]);
            tmp3 = (z[j]-z[k]);

       d2jk= tmp1 * tmp1 +
             tmp2 * tmp2 +
             tmp3 * tmp3;

            tmp1 = (x[i]-x[k]);
            tmp2 = (y[i]-y[k]);
            tmp3 = (z[i]-z[k]);

       d2ik= tmp1 * tmp1 +
             tmp2 * tmp2 +
             tmp3 * tmp3;

       temp =  0.5*(d2ij+d2jk-d2ik)/sqrt(d2ij*d2jk);

       *angijk= ( temp >  1. ?  1. : temp);
       *angijk= ( temp < -1. ? -1. : temp);

       *angijk = acos( *angijk ) ;

}

#ifdef sgi

/***********************************************************************/
Alpha_Blend()   /* changes the alpha-blend factor */
/***********************************************************************/
{
/*  function to change alpha blend factor */

    float alpha_b;

    printf("\07\n");
    PrintMessage("*** NOT YET WORKING  !!!!!!!");
    return;
new:;
#ifdef JUNK
    printf("\nOld ALPHA value : %f\n",material[9]);
    printf("\nGive new ALPHA (0.0 ... 1.0) : ");
    scanf("%f",&alpha_b);
    if( alpha_b < 0.0 || alpha_b > 1.0 ) goto new;

    material[9] = alpha_b;
#endif
}

/***********************************************************************/
surface_zone(fun)  /* determines which atoms are displayed as surfaces */

 int fun;
/***********************************************************************/
{
  int i,from,to;
  char text[BUFF_LEN];
  char comm_text[BUFF_LEN];

  switch(fun) {

  case 1:   /*  send surface zone command  */


  dialog4("Choose surface zone ...","Give range:  ",text);

  sprintf(comm_text,"set atom cpk %s ",text);

  send_command(comm_text);

  PrintMessage("\n OK...");
  return;

  case 3:
  PrintMessage(" Reseting surface ...");
  for( i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {
     surface_list[i] = surface_reset; 
     liquorice_list[i] = surface_reset;}
  return;


  case 2:

  dialog4("Surface zone is chosen by append ...","Give range:  ",text);

  sprintf(comm_text,"set atom cpk %s append",text);

  send_command(comm_text);

  PrintMessage("\n OK...");


   return;
  
  }

}

#endif

/***********************************************************************/
gauss (a , m)    /* gaussian elimination driver */

      float a[][4];
      int m;
/***********************************************************************/
{
   double aji,pivot;
   int i,j,k;

/*
C
C     GAUSS ELIMINATION PROCEDURE
C
*/
/*
      for(i = 0 ; i < m ; i++) {
        for(j = 0 ; j < m+1 ; j++) { printf("** %f ",a[i][j]);}printf("\n");}
*/

      for( i = 0 ; i < m ; i++ ) {
      pivot = a[i][i];

      if ( Rabs(pivot) < 1.0e-10)  {
      printf(" Element i: %d %f\n",i,a[i][i]);
      printf(" Singularity in Gauss \n");
      shut_down(1); }

         for( k = 0 ; k < m+1 ; k++ ) {
         a[i][k] = a[i][k]/pivot; }

          for( j = 0 ; j < m ; j++ ) {
            if( j == i ) continue;
            aji = a[j][i];
               for( k = 0 ; k < m+1 ; k++ ) {
               a[j][k] = a[j][k] - aji*a[i][k]; }
        }
       }
}

/***********************************************************************/
int  indexo( text , look)  /* imitates the FORTRAN index function */

     char text[],look[];
/***********************************************************************/
{
     int i , i1 , i2;

     i1=strlen(text);
     i2=strlen(look);

     if( i2 > i1) {
     return (0); }

     for(i = 0 ; i < (i1-i2+1)  ; i++) {
      if(strncmp(text+(i),look,i2) == 0) return (i+1);
     }
     return (0);
}

/*
     program to parse a string into tokens

     leif laaksonen 1989

     text   :  string to parsed to tokens (max MAXlinel characters)
     tokens :  array to contain the parsed text (should be defined
               as global tokens[MAXparse][MAXlinel])
     k      :  number of parsed strings in the tokens array
     searchs:  string which separates the tokens from each other
               NOW searchs HAS TO BE A CHARACTER
*/


/***********************************************************************/
int parsing(text,tokens,k,searchs)   /* main driver for the parser */
   char *text,*searchs;
   char tokens[][MAXlinel];
   int *k;
/***********************************************************************/
{
   int i,j,l;
   int found;

/* blank parse list */
   for(i = 0 ; i < MAXparse ; i++) tokens[i][0]='\0';

   if(text[0] == '#') { *k= -1;
                        return ( -1);}   /* Comment line */

   *k=0;
    l=0;
   if( strlen(searchs) > 1 ) {
   printf(" Search string %s too long: only one character is accepted",searchs);
   return(1); }

   j=strlen(text);

/*  delete possible spaces at the end */
   l=j;
   for(i=j-1;i>=0;i--){
    if(text[i] == ' ') l--;
    else break;}

   j=l;
    text[j]='\0';

   if(j == 0) {
    strcpy(tokens[0]," ");
     *k= -1;
     return( -1);}    /* nothing on input line */

   l=0;
   *k= -1;
   found=0;

   for( i = 0 ; i < j ; i++) {

   if(text[i] == ' ' || text[i] == '\n') {
    l=0;
     found=0;
     continue;}   /*  jump over spaces  */

   if(text[i] == '#') {
      return(0);}


   if(text[i] == searchs[0]) {
    l=0;
     found=0;
     continue;}
   else {
    if(found == 0) (*k)++;
    found=1;   /* flag on */
    tokens[*k][l++]=text[i];
     tokens[*k][l]='\0';}

   }

     return (0);  /* OK , return  */
}

/***********************************************************************/
int char_buff(input)   /*determines the length of a string (before NULL) */

    char input[];
/***********************************************************************/
{

    int i,j;

    j = strlen(input);  /* whole length */

    for( i = 0 ; i  < j ; i++) {

     if(input[i] == '\0') break; 
    }

    return (i);
}

/***********************************************************************/
void print_error(input)  /* displays an error message on dies  */

   char *input;
/***********************************************************************/
{

   printf("\n********************************************************\n");
   printf("%s\n",input);
   printf(  "********************************************************\n");

   shut_down (1);
}
/* kill_null is a function to kill the NULL in a char array (aal but the last)
   NULL is replaced with blank.
*/

void kill_null(text,num)

     char text[];
     int num;
{
     int i;

      for( i = 0 ; i < num ; i++) if(text[i] == '\0') text[i] = ' ';

}

/***********************************************************************/
int read_own(own_par)   /* reads own parameter file */

     char *own_par;               /* name of the RTF file to be read */
/***********************************************************************/
{

/* externals                   */
     extern int alias_deep;
     extern char alias_stack[][MAXlinel];
     extern char alias_eq[][MAXlinel];

     int i,j,k;
     int print_input;
     char input[MAXlinel];
     char text[MAXlinel];
     FILE *own_p;

     char chelp[2*BUFF_LEN];
     char OutText[BUFF_LEN];

     strcpy(chelp,scr_data);
     strcat(chelp,"/");
     strcat(chelp,own_par);

     own_param.entry=0;
     print_input=0;
     own_p=fopen(chelp,"r");
     if(own_p==NULL) {
     sprintf(OutText,"?ERROR - Can't open parameter file: %s ",chelp);
     PrintMessage(OutText);
     PrintMessage("?ERROR - Impossible to continue.");
     shut_down (1); }

/*   We are ready now to start reading.
     First line is a comment line. 
*/

#ifdef DEBUG
     printf("Reading 'scarecrow' parameter file: %s ...",chelp);
#endif

/* 1 line */
     fgets(input,MAXlinel,own_p);   /*  */

/*  read rest of the file (main loop)    */
     i=0;
     while(fgets(input,MAXlinel,own_p) != NULL) {
     if(print_input > 0) print_line(input);

     k=0;                         /* k before parsing */
     parsing(input,parsed,&k," ");

     tupper(parsed[0]);   /*  switch to upper case letters   */

/*   The following subcommands are recogniced:

     ALIAS         Aliases for commands

     MASS          Atomic mass and type definition  (removed)

     SECANG        Name of atoms building the phi, psi and omega angle

     PCONF         Parameters for the secondary structure

     BGcolour      Background colour.

     OBcolour      Colour of objects.

     TXcolour      Text colour.

     MAXTRAJMEM    Maximum memory available for reading the trajectory
                   information. If the memory needed to store the trajectory
                   is larger than MAXTRAJMEM everything is done out of core.
                   The value is in megabytes.

     LIQUORICE     Radius of the liquorice sphere and cylinder. 

     WATER         How the residue/molecule is classified in water.

     SET           The set command can be used. The command will be
                   sent to SCARECROW through the command interpreter.

     SCRDATA       Data path to scarecrow data directory 

     SCRBIN        Data path to the bin directory

     END           This subcommand terminates all input definitions.

*/
     if(k >= 0) {

/*   SECANG  card                 */

     if(indexo(parsed[0],"SECANG") == 1) {  /* start secang */
      tupper(parsed[1]);
      if(indexo(parsed[1],"PHI") == 1) {
       strncpy(&ppept_ang.phi[0],parsed[2],4);
       strncpy(&ppept_ang.phi[4],parsed[3],4);
       strncpy(&ppept_ang.phi[8],parsed[4],4);
       strncpy(&ppept_ang.phi[12],parsed[5],4);}

      if(indexo(parsed[1],"PSI") == 1) {
       strncpy(&ppept_ang.psi[0],parsed[2],4);
       strncpy(&ppept_ang.psi[4],parsed[3],4);
       strncpy(&ppept_ang.psi[8],parsed[4],4);
       strncpy(&ppept_ang.psi[12],parsed[5],4);}

      if(indexo(parsed[1],"OMEGA") == 1) {
       strncpy(&ppept_ang.omega[0],parsed[2],4);
       strncpy(&ppept_ang.omega[4],parsed[3],4);
       strncpy(&ppept_ang.omega[8],parsed[4],4);
       strncpy(&ppept_ang.omega[12],parsed[5],4);}
     } /* end secang */

/*   PCONF card                   */

      if(indexo(parsed[0],"PCONF") == 1) { /* start pconf */
       sscanf(input,"%*s %s %f %f %f %f %f %f %s",
       ppept_conf[pp_loop].name,
       &ppept_conf[pp_loop].phi,
       &ppept_conf[pp_loop].psi,
       &ppept_conf[pp_loop].omega,
       &ppept_conf[pp_loop].rpt,
       &ppept_conf[pp_loop].tpr,
       &ppept_conf[pp_loop].delta,
       ppept_conf[pp_loop].color); 
       pp_loop++;

     } /* end pconf */

/*   MASS        (removed instruction)                 */ 

       if(indexo(parsed[0],"MASS") == 1) { /* start mass */
       PrintMessage("?WARNING - the MASS statement is removed");
       continue;}

/*   MAXTRAJMEM card              */

     if(indexo(parsed[0],"MAXTRAJMEM") == 1) {
     max_traj_mem = atoi(parsed[1]);
     continue; }

/*   ALIAS  card                  */

     if(indexo(parsed[0],"ALIAS") == 1) {
        toller(parsed[1]);
        strcpy(alias_eq[alias_deep],parsed[1]);
        for(i = 2 ; i < k+1 ; i++)  {
         strcat(alias_stack[alias_deep]," ");
         strcat(alias_stack[alias_deep],parsed[i]);}

         if(alias_deep == MAXparse) {
         PrintMessage("?ERROR - alias stack is full ");
         shut_down(1);}

        alias_deep++;

     continue;}

/*   WATER  card                  */

     if( indexo(parsed[0],"WATER") == 1) {
     j=own_param.entry;
     sscanf(input,"%s %s",text,own_param.water+MAX_RES_NAME_LEN*j);
     own_param.colour[j][0] = atoi(parsed[2]);
     own_param.colour[j][1] = atoi(parsed[3]);
     own_param.colour[j][2] = atoi(parsed[4]);
     own_param.entry++;
     if(own_param.entry > MAXwater) {
     print_error(">>>>> Too many water definitions in own_param file <<<<<");
     PrintMessage(">>>>> Too many water definitions in own_param file <<<<<");
     shut_down(1);
     }
     continue;}

/*   SCARE DATA directory path    */

     if( indexo(parsed[0],"SCRDATA") == 1) {
       if(parsed[1][0] == '\0') continue;
       strcpy(scr_data,parsed[1]);
         continue;}

/*   SCARE BIN directory path    */

     if( indexo(parsed[0],"SCRBIN") == 1) {
       if(parsed[1][0] == '\0') continue;
       strcpy(scr_bin,parsed[1]);
         continue;}

/*   LIQUORICE card               */

     if( indexo(parsed[0],"LIQUORICE") == 1) {
     if(k > 0) liq_rads = atof(parsed[1]);
     if(k > 1) liq_radc = atof(parsed[2]);
     continue;}

/*   BGcolour card              */

     if( indexo(parsed[0],"BGCOLOUR") == 1) {

     if(isdigit(parsed[1][0])) {
      bgcolor[0] = atoi(parsed[1]);
      bgcolor[1] = atoi(parsed[2]);
      bgcolor[2] = atoi(parsed[3]);}
     else 
     name_to_rgb(parsed[1],&bgcolor[0],&bgcolor[1],&bgcolor[2]);
     continue;}

/*   TXcolour card              */

     if( indexo(parsed[0],"TXCOLOUR") == 1) {
      if(isdigit(parsed[1][0])) {
      txcolor[0] = atoi(parsed[1]);
      txcolor[1] = atoi(parsed[2]);
      txcolor[2] = atoi(parsed[3]);}
     else 
     name_to_rgb(parsed[1],&txcolor[0],&txcolor[1],&txcolor[2]);

      txt_param.txcolor[0] = txcolor[0];
      txt_param.txcolor[1] = txcolor[1];
      txt_param.txcolor[2] = txcolor[2];

     continue;}

/*   OBcolour card              */

     if( indexo(parsed[0],"OBCOLOUR") == 1) {
      if(isdigit(parsed[1][0])) {
      obcolor[0] = atoi(parsed[1]);
      obcolor[1] = atoi(parsed[2]);
      obcolor[2] = atoi(parsed[3]);}
     else 
     name_to_rgb(parsed[1],&obcolor[0],&obcolor[1],&obcolor[2]);

     continue;}

/*   SET command                  */
     if(indexo(parsed[0],"SET") == 1) {
       if(input[strlen(input)-1] == '\n')
                 input[strlen(input)-1] = '\0';
       send_command(input);
         continue;}

/*   PRINT card                 */

     if( indexo(parsed[0],"PRINT") == 1) {
     print_input=1;continue;}
     
/*   END card                   */

     if( indexo(parsed[0],"END") == 1 ) {
     break ;}                        /*  return now ...  */

}

}

#ifdef DEBUG
     printf(" done\n");
#endif

     fclose(own_p);
     return (0);
}

/***********************************************************************/
print_line(string)
/***********************************************************************/

    char *string;
{
    int i,j;

    i=strlen(string);
    for(j = i-1 ; j >= 0 ; j++) {
     if(string[j] != ' ') break;}

      string[j]='\0';
    for(i=0; i < j ; i++) putchar(string[i]);
    putchar('\n');
}


/***********************************************************************/
in_water() /* colour the atoms according to hydrophilic/hydrophobic
/***********************************************************************/
{

   int i,j,k;

   for(i = mlists[0] ; i < mliste[mlist_deep - 1] ; i++) {

      for(j = 0 ; j < own_param.entry ; j++) {
       k = strlen(own_param.water+MAX_RES_NAME_LEN*j);
        if(k > MAX_RES_NAME_LEN) k = MAX_RES_NAME_LEN;
      if(strncasecmp(resnam+4*i,own_param.water+MAX_RES_NAME_LEN*j,k) == 0){
      atmcol[i][0]=own_param.colour[j][0];
      atmcol[i][1]=own_param.colour[j][1];
      atmcol[i][2]=own_param.colour[j][2];
      break;}}

      }
}


/***********************************************************************/
int covalent_rad(nro,atom,covrad) 
                         /* assign a covalent bond distance to an atom */
  
   char atom[];
   int nro;
   float *covrad;
/***********************************************************************/
{
   int i,j,k;
   char local[4];
   char OutText[BUFF_LEN];

   *covrad = 1.0;   /*  default covalent radius  */
   strncpy(local,atom,4);

   if(isdigit(atom[0])) {
     for(i = 0 ; i < strlen(atom) - 1 ; i++) 
                                             atom[i] = atom[i+1];
     atom[strlen(atom) - 1] = '\0';
     PrintMessage(">>>>> Warning: Atom name begin with a digit <<<<<");}

   for(i=1 ; i < MAX_ATM_NAME_LEN ; i++) {

    if(atom[i] == '\0')  atom[i]=' ';
    if(isdigit(atom[i])) atom[i]=' '; }

   j = 0;
   if(atom[1] != ' ') j=1;
    if(atom[2] != ' ') j=2;
     if(atom[3] != ' ') j=3;

/* element now ready without numbers in it */

   for(k = j ; k >= 0           ; k--) {
   for(i = 0 ; i <  MAXelements ; i++) {

    if(strncmp(atom,element+MAX_ATM_NAME_LEN*i,4) == 0) {
    *covrad=covar[i];
    return(0);}
   }
   atom[k]=' ';}

   sprintf(OutText,">>>> Following element nr: %d unknown: '%.4s'",nro+1,local);
   PrintMessage(OutText);
   return(1);
   
}

#ifdef sgi

/***********************************************************************/
liquorice()   /* display the molecule as liquorice */
/***********************************************************************/
{


   register int i,j,cyl;
   static int k,l,lookup,ii,im1,jj,kc;
   static float div_rad;
   static float xh,yh,zh;
   static float light_rot[3][4],vec[6],vecc[4][3],rad;
   static float n0[6];
   static float diffs,xtr=0.0,ytr=0.0,ztr=1.0;
   static float alpha,beta,diffx,diffy,diffz,zproj;
   static float cyl_rot[3][3],cyl_rotm[3][3];
   static float cosa,sina;
   static float xi,yi,zi;
   static float xk,yk,zk;
   static float *vspher_run;
   static int from,to;
   static int in_blend = 0;
   static float param[4];
   static int SayCol[3] = {0 , 255 , 0};

/* change cursor ...    */
   setcursor(CURS_TYPE);
/* show some text */
   if(DBuffer.BufferMode == 2 && !video_mode)
     k = show_text("Working ...","Helvetica",SayCol,15.,0.8,0.9,FRONTBUFFER);

   diffs = far - near;

   backface(TRUE);

   in_blend = 0;
/*
     if(material[9] < 1.0) {
     backface(FALSE);
     in_blend = 1;
     blendfunction(BF_SA, BF_ONE);}
*/

#ifndef FAST
   build_array();
   build_sphere( sphere_seg , liq_rads);
#endif

   build_cylinder( cyl_seg , liq_radc);

   if(alpha_trace) {
   alpha_trace_liq();
/*   return; */}


   from = 0;
   to   = mliste[mlist_deep - 1];

/* throw out the cylinders */

   rad = liq_radc;  /* radius of the cylinder */

   div_rad = 1.0 / rad;

   for(i = from ; i < to ; i++ ) {

   if(disp_list[i] != 1) continue;  /* check if the atom should be displayed */

   if(liquorice_list[i] !=1) continue; /* check if there should be a surface */

   xi = x[i];
    yi = y[i];
     zi = z[i];

   if((l = cnct[i][0])  > 0) {
  
    vec[0]=xi;
     vec[1]=yi;
      vec[2]=zi;

   for( j = 1 ; j <= l ; j ++) {
  
/* the points are x[i],y[i],z[i] and x[k],y[k],z[k] */

  
   k=cnct[i][j];

   if(liquorice_list[k] !=1) continue; /* check if there should be a surface */

   if(disp_list[k] != 1) continue;  /* check if the atom should be displayed */

        if(k > i) continue;     /* avoid counting the bond twice */

   xk = x[k];
    yk = y[k];
     zk = z[k];

   diffx = xk-xi;
   diffy = yk-yi;
   diffz = zk-zi;

/*  rotate first alpha degrees around the z-axis to get the x-axis along
    the vector r(i,j) (the projection on the x-y plane) */
 
   if(Rabs(diffx) > 1.e-05) {
   alpha = atan(diffy/diffx);}
   else  alpha = pia/2.;
/*   if(diffy < 0.0 && diffx < 0.0) alpha = alpha + pia; */

#ifdef sgi
   cosa = fcos(alpha);
    sina = fsin(alpha);
#else
   cosa = cos((double)alpha);
    sina = sin((double)alpha);
#endif

   cyl_rot[0][0]=  cosa;
   cyl_rot[0][1]=  sina;
   cyl_rot[0][2]=  0.0;
   cyl_rot[1][0]= -sina;
   cyl_rot[1][1]=  cosa;
   cyl_rot[1][2]=  0.0;
   cyl_rot[2][0]=  0.0;
   cyl_rot[2][1]=  0.0;
   cyl_rot[2][2]=  1.0;

   zproj = sqrt( diffx*diffx + diffy*diffy);

/*  rotate now beta degrees around the y-axis to get the x' axis to point along
    the vector r(i,j,k) */

   
   if(Rabs(zproj) > 1.e-05) {
   beta = atan(diffz/zproj);}
   else beta = pia/2.;

   if(diffx < 0.0) beta =  pia - beta; 

#ifdef sgi
   cosa = fcos(beta);
    sina = fsin(beta);
#else
   cosa = cos((double)beta);
    sina = sin((double)beta);
#endif

   cyl_rotm[0][0]=   cosa;  /* + */
   cyl_rotm[0][1]=  0.0;
   cyl_rotm[0][2]=   sina;  /* - */
   cyl_rotm[1][0]=  0.0;
   cyl_rotm[1][1]=  1.0;
   cyl_rotm[1][2]=  0.0; 
   cyl_rotm[2][0]=  -sina;  /* + */
   cyl_rotm[2][1]=  0.0;
   cyl_rotm[2][2]=  cosa;   /* + */


   mult3(cyl_rotm,cyl_rot);

/* cyl_rot contains now the rotation matrix */

/* start rotating around x' to construct the cylinder */

   if(b_disp_a == 0) {    /* soft display */

   lookup=0;

   for(cyl = 1 ; cyl < cyl_seg ; cyl++) {

   CHANGE_COLOR(i); 

  bgnpolygon();

   mult4(vcylinder[lookup],cyl_rot,vec);
   vecc[0][0] = vec[0] + xi;
    vecc[0][1] = vec[1] + yi;
     vecc[0][2] = vec[2] + zi;

   n0[0] = vec[0] * div_rad;
    n0[1] = vec[1] * div_rad;
     n0[2] = vec[2] * div_rad;

    n3f(n0); v3f(vecc[0]);


   CHANGE_COLOR(k); 


   vecc[1][0] = vec[0] + xk;
    vecc[1][1] = vec[1] + yk;
     vecc[1][2] = vec[2] + zk;

    n3f(n0); v3f(vecc[1]);

   kc=lookup+1;
   mult4(vcylinder[kc],cyl_rot,vec);
   vecc[2][0] = vec[0] + xk;
    vecc[2][1] = vec[1] + yk;
     vecc[2][2] = vec[2] + zk;

   n0[0] = vec[0] * div_rad;
    n0[1] = vec[1] * div_rad;
     n0[2] = vec[2] * div_rad;

    n3f(n0); v3f(vecc[2]);

   vecc[3][0] = vec[0] + xi;
    vecc[3][1] = vec[1] + yi;
     vecc[3][2] = vec[2] + zi;

    CHANGE_COLOR(i);

    n3f(n0); v3f(vecc[3]);

    endpolygon();

   lookup++;}
  
 }
/**********/
   else {   /* sharp half */
/**********/
   
   xh = (xi + xk) / 2.0;
    yh = (yi + yk) / 2.0;
     zh = (zi + zk) / 2.0;

   lookup=0;

   for(cyl = 1 ; cyl < cyl_seg ; cyl++) {

    CHANGE_COLOR(i);

  bgnpolygon();

   mult4(vcylinder[lookup],cyl_rot,vec);
   vecc[0][0] = vec[0] + xi;
    vecc[0][1] = vec[1] + yi;
     vecc[0][2] = vec[2] + zi;

   n0[0] = vec[0] * div_rad;
    n0[1] = vec[1] * div_rad;
     n0[2] = vec[2] * div_rad;

    n3f(n0); v3f(vecc[0]);

   vecc[1][0] = vec[0] + xh;
    vecc[1][1] = vec[1] + yh;
     vecc[1][2] = vec[2] + zh;

    n3f(n0); v3f(vecc[1]);

   kc=lookup+1;
   mult4(vcylinder[kc],cyl_rot,vec);
   vecc[2][0] = vec[0] + xh;
    vecc[2][1] = vec[1] + yh;
     vecc[2][2] = vec[2] + zh;

   n0[3] = vec[0] * div_rad;
    n0[4] = vec[1] * div_rad;
     n0[5] = vec[2] * div_rad;

    n3f(&n0[3]); v3f(vecc[2]);

   vecc[3][0] = vec[0] + xi;
    vecc[3][1] = vec[1] + yi;
     vecc[3][2] = vec[2] + zi;

    n3f(&n0[3]); v3f(vecc[3]);
   endpolygon();

/*                                         */

   CHANGE_COLOR(k);

   bgnpolygon();

   mult4(vcylinder[lookup],cyl_rot,vec);
   vecc[0][0] = vec[0] + xh;
    vecc[0][1] = vec[1] + yh;
     vecc[0][2] = vec[2] + zh;

    n3f(n0); v3f(vecc[0]);

   vecc[1][0] = vec[0] + xk;
    vecc[1][1] = vec[1] + yk;
     vecc[1][2] = vec[2] + zk;

    n3f(n0); v3f(vecc[1]);

   kc=lookup+1;
   mult4(vcylinder[kc],cyl_rot,vec);
   vecc[2][0] = vec[0] + xk;
    vecc[2][1] = vec[1] + yk;
     vecc[2][2] = vec[2] + zk;

    n3f(&n0[3]); v3f(vecc[2]);

   vecc[3][0] = vec[0] + xh;
    vecc[3][1] = vec[1] + yh;
     vecc[3][2] = vec[2] + zh;

    n3f(&n0[3]); v3f(vecc[3]);

    endpolygon();

   lookup++;
  
 }}
/**********/
}}} 



/* throw out the balls */

     backface(TRUE);
/*
     if(material[9] < 1.0) {
     backface(FALSE);
     blendfunction(BF_SA, BF_ONE);}
*/

  for(k = from ; k < to ; k++) {

  if(disp_list[k] != 1) continue;  /* check if the atom should be displayed */

  if(liquorice_list[k] !=1) continue; /* check if there should be a surface */

  xk = x[k];
   yk = y[k];
    zk = z[k];


   CHANGE_COLOR(k);

   rad = liq_rads;   /* radius of the sphere */

#ifdef FAST

   param[0] = xk;
    param[1] = yk;
     param[2] = zk;
      param[3] = rad;

   i = sphdraw(param);
   if(i < 0) {
     PrintMessage("?ERROR - error in sphdraw ");
     return;}

#else


   div_rad = 1.0 / rad;

   for(i = 1 ; i < sphere_seg ; i++) {

    ii = sphere_array[i];
     im1 = sphere_array[i-1];

    for(j = 1 ; j <= 2*sphere_seg ; j++) {

    vspher_run = vspher[0];

    bgnpolygon();

    jj = j+im1-1;
    *vspher_run++ = xk+vsphe[jj][0];
    *vspher_run++ = yk+vsphe[jj][1];
    *vspher_run++ = zk+vsphe[jj][2];

    n0[0]=vsphe[jj][0] * div_rad ;
    n0[1]=vsphe[jj][1] * div_rad ;
    n0[2]=vsphe[jj][2] * div_rad ;

    n3f(n0); v3f(vspher[0]);

    ++jj;
    *vspher_run++ = xk+vsphe[jj][0];
    *vspher_run++ = yk+vsphe[jj][1];
    *vspher_run++ = zk+vsphe[jj][2];

    n0[0]=vsphe[jj][0] * div_rad ;
    n0[1]=vsphe[jj][1] * div_rad ;
    n0[2]=vsphe[jj][2] * div_rad ;

    n3f(n0); v3f(vspher[1]);

    jj = j+ii;
    *vspher_run++ = xk+vsphe[jj][0];
    *vspher_run++ = yk+vsphe[jj][1];
    *vspher_run++ = zk+vsphe[jj][2];

    n0[0]=vsphe[jj][0] * div_rad ;
    n0[1]=vsphe[jj][1] * div_rad ;
    n0[2]=vsphe[jj][2] * div_rad ;

    n3f(n0); v3f(vspher[2]);

    --jj;
    *vspher_run++ = xk+vsphe[jj][0];
    *vspher_run++ = yk+vsphe[jj][1];
    *vspher_run   = zk+vsphe[jj][2];

    n0[0]=vsphe[jj][0] * div_rad ;
    n0[1]=vsphe[jj][1] * div_rad ;
    n0[2]=vsphe[jj][2] * div_rad ;

    n3f(n0); v3f(vspher[3]);
    endpolygon();  }}

#endif

} 

    if(in_blend) {
     blendfunction(BF_ONE, BF_ZERO);
    }

    backface(FALSE); 

/* change cursor back ...    */
   setcursor(0);
}

#endif

/***********************************************************************/
mult3(a,b)   /* matrix multiplication matrix * matrix  */

   float a[][3],b[][3];
/***********************************************************************/
{
/* a , b and the result c are square */
   int i,j,k;
   int three=3,nh=3;
   float c[3][3],temp;

          for(i = 0 ; i < nh ; i++) {
           for(j = 0 ; j < nh ; j++) {
            c[i][j]=0.0;}}

      for(k = 0 ; k < nh ; k++) {
/*   */
         for( j = 0 ; j < nh ; j++) {
/*   */
          temp=b[k][j];
          for(i = 0 ; i < nh ; i++) {
          c[i][j]=c[i][j]+a[i][k]*temp;}
      }}
/* move data from c to b    */
      for(i = 0 ; i < three ; i++) {
       for(j = 0 ; j < three ; j++) { 
        b[i][j]=c[i][j];}}
}

/***********************************************************************/
mult4(a,b,c)

   float a[],b[][3],c[];
/***********************************************************************/
{
/* a is an array , b  square */

   c[0]  = b[0][0]*a[0] + b[1][0]*a[1] + b[2][0]*a[2];
   c[1]  = b[0][1]*a[0] + b[1][1]*a[1] + b[2][1]*a[2];
   c[2]  = b[0][2]*a[0] + b[1][2]*a[1] + b[2][2]*a[2];

}
/***********************************************************************/
build_cylinder(m,radius)    /* render the cylinder  */
   int m;
   float radius;
/***********************************************************************/
{

/*  externals  

    extern float vcylinder[][3];

*/

   register j,k;
   static float jstep,ysphek,zsphek;
   static float jjstep;

   jstep = 2.0 *  pia / (float) (m - 1);
   k=0;



          for( j = m ; j >= 1 ; j--) {
       jjstep=(j-1)*jstep;
       ysphek   =  radius*cos(jjstep);
       zsphek   =  radius*sin(jjstep);
       vcylinder[k][0] =  0.0;
       vcylinder[k][1] =  ysphek;
       vcylinder[k][2] =  zsphek;

       ++k;
       if( k > MAXcylp) {
       PrintMessage(">>>> ERROR , too many points in the vcylinder array <<<<<");
       shut_down (1);}
       }

}

#ifdef sgi

/***********************************************************************/
alpha_trace_liq()  /* render the alpha-trace as liquorice  */
/***********************************************************************/
{
   int i,j,k,l,lookup,cyl,nn;
   register int ii,im1,jj,kc,kk;
   static float light_rot[3][4],vec[6],vecc[4][3],rad;
   static float n0[6];
   static float diffs,xtr=0.0,ytr=0.0,ztr=1.0;
   static float alpha,beta,diffx,diffy,diffz,zproj;
   static float cyl_rot[3][3],cyl_rotm[3][3];
   static float cosa,sina;
   static float xi,yi,zi;
   static float xk,yk,zk;
   static float xh,yh,zh;
   static float *vspher_run;
   static float div_rad;
   static float param[4];
   static int SayCol[3] = {255 , 0 , 255};


/* change cursor ...    */
   setcursor(CURS_TYPE);
/* show some text */
   if(DBuffer.BufferMode == 2 && !video_mode)
      k = show_text("Working ...","Helvetica",SayCol,15.,0.8,0.9,FRONTBUFFER);

   diffs = far - near;

     backface(TRUE);

/*
     if(material[9] < 1.0) {
     backface(FALSE);
     blendfunction(BF_SA, BF_ONE);}
*/

#ifndef FAST
   build_sphere( sphere_seg , liq_rads);
#endif

   build_cylinder( cyl_seg , liq_radc);


/* throw out the balls */


  for(kk = 0 ; kk < ca_num ; kk++) {
  
  k = ca_list[kk];

  xk = x[k];
   yk = y[k];
    zk = z[k];


 if(ca_disp_list[k] != 1) continue; /* check if the atom should be displayed */

 if(liquorice_list[k] !=1) continue; /* check if there should be a surface */

   CHANGE_COLOR(k);

   rad = liq_rads;   /* radius of the sphere */

#ifdef FAST

   param[0] = xk;
    param[1] = yk;
     param[2] = zk;
      param[3] = rad;

   i = sphdraw(param);
   if(i < 0) {
     printf("?ERROR - error in sphdraw \n");
     return;}

#else


   div_rad = 1.0 / rad;

   for(i = 1 ; i < sphere_seg ; i++) {

    ii = sphere_array[i];
     im1 = sphere_array[i-1];

    for(j = 1 ; j <= 2*sphere_seg ; j++) {

    vspher_run = vspher[0];

    bgnpolygon();

    jj = j+im1-1;
    *vspher_run++ = xk+vsphe[jj][0];
    *vspher_run++ = yk+vsphe[jj][1];
    *vspher_run++ = zk+vsphe[jj][2];

    n0[0]=vsphe[jj][0] * div_rad ;
    n0[1]=vsphe[jj][1] * div_rad ;
    n0[2]=vsphe[jj][2] * div_rad ;

    n3f(n0); v3f(vspher[0]);

    ++jj;
    *vspher_run++ = xk+vsphe[jj][0];
    *vspher_run++ = yk+vsphe[jj][1];
    *vspher_run++ = zk+vsphe[jj][2];

    n0[0]=vsphe[jj][0] * div_rad ;
    n0[1]=vsphe[jj][1] * div_rad ;
    n0[2]=vsphe[jj][2] * div_rad ;

    n3f(n0); v3f(vspher[1]);

    jj = j+ii;
    *vspher_run++ = xk+vsphe[jj][0];
    *vspher_run++ = yk+vsphe[jj][1];
    *vspher_run++ = zk+vsphe[jj][2];

    n0[0]=vsphe[jj][0] * div_rad ;
    n0[1]=vsphe[jj][1] * div_rad ;
    n0[2]=vsphe[jj][2] * div_rad ;

    n3f(n0); v3f(vspher[2]);

    --jj;
    *vspher_run++ = xk+vsphe[jj][0];
    *vspher_run++ = yk+vsphe[jj][1];
    *vspher_run   = zk+vsphe[jj][2];

    n0[0]=vsphe[jj][0] * div_rad ;
    n0[1]=vsphe[jj][1] * div_rad ;
    n0[2]=vsphe[jj][2] * div_rad ;

    n3f(n0); v3f(vspher[3]);
    endpolygon();  }}

#endif
} 

/* throw out the cylinders */

     backface(TRUE);

/*
     if(material[9] < 1.0) {
     backface(FALSE);
     blendfunction(BF_SA, BF_ONE);}
*/

   rad = liq_radc;  /* radius of the cylinder */

   div_rad = 1.0 / liq_radc;

   for(kk = 0 ; kk < ca_num-1 ; kk++ ) {

   if(gap_vec[kk+1] > 0 ) continue;

   i = ca_list[kk];

   xi = x[i];
    yi = y[i];
     zi = z[i];

  if(ca_disp_list[i] != 1) continue;/* check if the atom should be displayed */

  if(liquorice_list[i] !=1) continue; /* check if there should be a surface */
  
    vec[0]=x[i];
     vec[1]=y[i];
      vec[2]=z[i];

   k = ca_list[kk+1];

   if(ca_disp_list[k] != 1) continue;/* check if the atom should be displayed */
  
/* the points are x[i],y[i],z[i] and x[k],y[k],z[k] */

   xk = x[k];
    yk = y[k];
     zk = z[k];

   diffx = xk-xi;
   diffy = yk-yi;
   diffz = zk-zi;

/*  rotate first alpha degrees around the z-axis to get the x-axis along
    the vector r(i,j) (the projection on the x-y plane) */
 
   if(Rabs(diffx) > 1.e-05) {
   alpha = atan(diffy/diffx);}
   else  alpha = pia/2;

#ifdef sgi
   cosa = fcos(alpha);
    sina = fsin(alpha);
#else
   cosa = cos((double)alpha);
    sina = sin((double)alpha);
#endif

   cyl_rot[0][0]=  cosa;
   cyl_rot[0][1]=  sina;
   cyl_rot[0][2]=  0.0;
   cyl_rot[1][0]= -sina;
   cyl_rot[1][1]=  cosa;
   cyl_rot[1][2]=  0.0;
   cyl_rot[2][0]=  0.0;
   cyl_rot[2][1]=  0.0;
   cyl_rot[2][2]=  1.0;

   zproj = sqrt( diffx*diffx + diffy*diffy);

/*  rotate now beta degrees around the y-axis to get the x' axis to point along
    the vector r(i,j,k) */

   
   if(Rabs(zproj) > 1.e-05) {
   beta = atan(diffz/zproj);}
   else beta = pia/2.;

   if(diffx < 0.0) beta =  pia - beta; 

#ifdef sgi
   cosa = fcos(beta);
    sina = fsin(beta);
#else
   cosa = cos((double)beta);
    sina = sin((double)beta);
#endif

   cyl_rotm[0][0]=   cosa;
   cyl_rotm[0][1]=  0.0;
   cyl_rotm[0][2]=   sina;
   cyl_rotm[1][0]=  0.0;
   cyl_rotm[1][1]=  1.0;
   cyl_rotm[1][2]=  0.0; 
   cyl_rotm[2][0]=  -sina;
   cyl_rotm[2][1]=  0.0;
   cyl_rotm[2][2]=  cosa;


   mult3(cyl_rotm,cyl_rot);

/* cyl_rot contains now the rotation matrix */

/* start rotating around x' to construct the cylinder */


   if(b_disp_a == 0) {    /* soft display */

   lookup=0;

   for(cyl = 1 ; cyl < cyl_seg ; cyl++) {

   CHANGE_COLOR(i); 

  bgnpolygon();

   mult4(vcylinder[lookup],cyl_rot,vec);
   vecc[0][0] = vec[0] + xi;
    vecc[0][1] = vec[1] + yi;
     vecc[0][2] = vec[2] + zi;

   n0[0] = vec[0] * div_rad;
    n0[1] = vec[1] * div_rad;
     n0[2] = vec[2] * div_rad;

    n3f(n0); v3f(vecc[0]);

   CHANGE_COLOR(k);

   vecc[1][0] = vec[0] + xk;
    vecc[1][1] = vec[1] + yk;
     vecc[1][2] = vec[2] + zk;

    n3f(n0); v3f(vecc[1]);

   kc=lookup+1;
   mult4(vcylinder[kc],cyl_rot,vec);
   vecc[2][0] = vec[0] + xk;
    vecc[2][1] = vec[1] + yk;
     vecc[2][2] = vec[2] + zk;

   n0[0] = vec[0] * div_rad;
    n0[1] = vec[1] * div_rad;
     n0[2] = vec[2] * div_rad;

    n3f(n0); v3f(vecc[2]);

   vecc[3][0] = vec[0] + xi;
    vecc[3][1] = vec[1] + yi;
     vecc[3][2] = vec[2] + zi;

   CHANGE_COLOR(i);

    n3f(n0); v3f(vecc[3]);

    endpolygon();

   lookup++;}
  
 }
/**********/
   else {   /* sharp half */
/**********/
   
   xh = (xi + xk) / 2.0;
    yh = (yi + yk) / 2.0;
     zh = (zi + zk) / 2.0;

   lookup=0;

   for(cyl = 1 ; cyl < cyl_seg ; cyl++) {

   CHANGE_COLOR(i);

  bgnpolygon();

   mult4(vcylinder[lookup],cyl_rot,vec);
   vecc[0][0] = vec[0] + xi;
    vecc[0][1] = vec[1] + yi;
     vecc[0][2] = vec[2] + zi;

   n0[0] = vec[0] * div_rad;
    n0[1] = vec[1] * div_rad;
     n0[2] = vec[2] * div_rad;

    n3f(n0); v3f(vecc[0]);

   vecc[1][0] = vec[0] + xh;
    vecc[1][1] = vec[1] + yh;
     vecc[1][2] = vec[2] + zh;

    n3f(n0); v3f(vecc[1]);

   kc=lookup+1;
   mult4(vcylinder[kc],cyl_rot,vec);
   vecc[2][0] = vec[0] + xh;
    vecc[2][1] = vec[1] + yh;
     vecc[2][2] = vec[2] + zh;

   n0[3] = vec[0] * div_rad;
    n0[4] = vec[1] * div_rad;
     n0[5] = vec[2] * div_rad;

    n3f(&n0[3]); v3f(vecc[2]);

   vecc[3][0] = vec[0] + xi;
    vecc[3][1] = vec[1] + yi;
     vecc[3][2] = vec[2] + zi;

    n3f(&n0[3]); v3f(vecc[3]);
   endpolygon();

/*                                         */

   CHANGE_COLOR(k);

   bgnpolygon();

   mult4(vcylinder[lookup],cyl_rot,vec);
   vecc[0][0] = vec[0] + xh;
    vecc[0][1] = vec[1] + yh;
     vecc[0][2] = vec[2] + zh;

    n3f(n0); v3f(vecc[0]);

   vecc[1][0] = vec[0] + xk;
    vecc[1][1] = vec[1] + yk;
     vecc[1][2] = vec[2] + zk;

    n3f(n0); v3f(vecc[1]);

   kc=lookup+1;
   mult4(vcylinder[kc],cyl_rot,vec);
   vecc[2][0] = vec[0] + xk;
    vecc[2][1] = vec[1] + yk;
     vecc[2][2] = vec[2] + zk;

    n3f(&n0[3]); v3f(vecc[2]);

   vecc[3][0] = vec[0] + xh;
    vecc[3][1] = vec[1] + yh;
     vecc[3][2] = vec[2] + zh;

    n3f(&n0[3]); v3f(vecc[3]);

    endpolygon();

   lookup++;
  
 }}}

    backface(FALSE); 

/* change cursor back to default ...    */
   setcursor( 0 );
}

#endif

/***********************************************************************/
make_shell()    /* create a window shell  */
/***********************************************************************/
{
     int status;

     if(fork() == 0) 
     execlp("/bin/wsh", "wsh" , "-F" , "-p 100,100" , (char *) 0);

     wait(&status);
}

#include "traja.h"
/*
    This is the "working horse" of the different dynamics analyzis and
    display facility

    Leif Laaksonen 1990

*/

#ifdef sgi

/************************************************************************/
study_dynamics(alt)    /* main driver for trajectory analysis  */
/************************************************************************/

    int alt;

{

    extern int dynamics_frames;
    extern int dynamics_pasback[20];
    extern int check_pow_2();
    extern int man_times_int;
    extern int man_times_float;
    extern int times_nr;


    static int i,numset,pasback[20];
/*
    The point_vec, dist_vec, ang_vec and tors_vec point with an index to
    an atom in the atom list, so they are always >= 0, if the value is
    smaller than 0 it means:

    (-1): This point is a mass centre
    (-2): This point is a coordinate centre
*/
    static int point_len=0;  /* length of point array  */
    static int point_vec[MAXplen];
    static int dist_len=0;   /* length of distance array (in fact 2 times) */
    static int dist_vec[MAXdlen];
    static int ang_len=0;    /* length of angle array (3 times) */
    static int ang_vec[MAXalen];
    static int tors_len=0;   /* length of torsion array (4 times) */
    static int tors_vec[MAXtlen];
    static int cc_len = 0;   /* length of coordinate centre list */
    static float cc_vec[MAXcclen];
    static int mc_len = 0;   /* length of mass centre list       */
    static float mc_vec[MAXmclen];
    static int num_obs=0;
    static float *obs_vec;
    static int    obs_vec_point = 0;
    char   text[BUFF_LEN];
    char   inport[BUFF_LEN];

/* export some pointers */
    play_dynam_frames.numset      = FramesInSet();
    play_dynam_frames.obs_vec_len = obs_vec_point;
    play_dynam_frames.point_vec   = point_vec;
    play_dynam_frames.dist_vec    = dist_vec;
    play_dynam_frames.ang_vec     = ang_vec;
    play_dynam_frames.tors_vec    = tors_vec;
    play_dynam_frames.obs_vec     = obs_vec;
    play_dynam_frames.current_set = -1;

    numset = play_dynam_frames.numset; 

    strcpy(bottom_line,"           ");

/* most likely we will scramble the x,y and z vectors so save them NOW!
   (they are retrieved on exit) */
    if(coord_save ==0) man_coordinates(1);
/* done */

    switch(alt) {   /* main switch board */

    case 1:  /* read name of trajectory file and check some information */

#if defined(USEFORMS) && defined(sgi)
    if(ShowForm3()) break;
#else
    dialog4("Reading trajectory file name.","File name : ",inport);
    if(inport[0] == '\0') break;

/* check that file exist */
     i = check_if_file_exist(inport);
     if(i < 0) {
       PrintMessage("?ERROR - file does not exist");
       break;}
     strncpy(traj_file,inport,BUFF_LEN);
     strncpy(trajectory_info.traj_file,inport,BUFF_LEN);
       sprintf(inport,"Trajectory file name: %s",traj_file);
        PrintMessage(inport);
    dialog4("Reading trajectory file type...","File type : ",inport);
    traj_file_set = set_traj_type(inport);
     force_type   = traj_file_set;
#endif

/*  check the trajectory file */
    i = read_traj(1,&numset,pasback);
    if(i < 0) 
       break;

/*  save the information to some support variables */
    dynamics_frames = FramesInSet();
     for(i=0;i<20;i++) dynamics_pasback[i] = pasback[i];
      break;  /* end of switch 1 */

    case 2:  /* Show time, make a movie */

      strcpy(bottom_line,"Reading trajectory file ...");
       going_on();

          i = read_traj(1,&numset,pasback); /*check if in/out of core*/
          if(i < 0) break;

/* it's in core */
    if(traj_in_core == 1) { /* in core (2) */
     i = read_traj(2,&numset,pasback);
       if(i < 0) break;
      strcpy(bottom_line,"Displaying dynamics trajectory.");
       going_on();
         plot_dynamics(1,FramesInSet(),pasback,
                         point_len,point_vec,
                         dist_len,dist_vec,
                         ang_len, ang_vec,
                         tors_len,tors_vec,
                         num_obs,obs_vec,
                         &obs_vec_point); 

     free(coordx); /* free temprary arrays */
      free(coordy);
       free(coordz); } /* end of in core (2) */

     /* out of core (2)*/
     if(traj_in_core == 2) { /* out of core (2) */
     /*  check the trajectory file (just to be sure everything is known)*/
     i = read_traj(1,&numset,pasback);
       if(i < 0) break;
      strcpy(bottom_line,"Displaying dynamics trajectory.");
       going_on();
        plot_dynamics(4,FramesInSet(),pasback,
                         point_len,point_vec,
                         dist_len,dist_vec,
                         ang_len, ang_vec,
                         tors_len,tors_vec,
                         num_obs,obs_vec,
                         &obs_vec_point);;}    /* end of out of core (2) */

     break;

/* all this can be done in core */
    case 3: /* setting up distance array to be analyzed */
     /*    dist_len=0; */
      dist_arr(&dist_len,dist_vec);
       break;

/* all this can be done in core */
    case 4: /* setting up angle array */
     /*    ang_len=0; */
      ang_arr(&ang_len,ang_vec);
       break;

/* all this can be done in core */
    case 5: /* setting up torsion array */
     /*    tors_len = 0; */
      tors_arr(&tors_len,tors_vec);
       break;

/* this again is a more tricky case (both in and out of core) */
    case 6: /* move by frame (using the arrow keys) */
     strcpy(bottom_line,"Reading trajectory file ...");
      going_on();

       i = read_traj(1,&numset,pasback); /*check if in/out of core*/
       if( i < 0) break;

    if(traj_in_core == 1) { /* do it in core (6)*/
     i = read_traj(2,&numset,pasback);
       if(i < 0) break;
      strcpy(bottom_line,"Displaying dynamics trajectory.");
       going_on();
        plot_dynamics(2,FramesInSet(),pasback,
                         point_len,point_vec,
                         dist_len,dist_vec,
                         ang_len, ang_vec,
                         tors_len,tors_vec,
                         num_obs,obs_vec,
                         &obs_vec_point);

     free(coordx); /* delete scratch space */
      free(coordy);
       free(coordz);} /* end of in core (6) */

     if(traj_in_core == 2) { /* do it out of core (6)*/
      strcpy(bottom_line,"Displaying dynamics trajectory.");
       going_on();
        plot_dynamics(6,FramesInSet(),pasback,
                         point_len,point_vec,
                         dist_len,dist_vec,
                         ang_len, ang_vec,
                         tors_len,tors_vec,
                         num_obs,obs_vec,
                         &obs_vec_point);

    }
    break; /* end of out of core (6) */

    case 7: /* average structure analyzis */

/* this as always done out of core (could be changed later on) */

     strcpy(bottom_line,"Reading trajectory file ...");
      going_on();
        strcpy(bottom_line,"Calculating average structure.");
         going_on();
          traj_av_structure();
           strcpy(bottom_line,"Displaying average structure.");
            going_on();
             plot_dynamics(3,FramesInSet(),pasback,
                             point_len,point_vec,
                             dist_len,dist_vec,
                             ang_len, ang_vec,
                             tors_len,tors_vec,
                             num_obs,obs_vec,
                             &obs_vec_point);

       break;

    case 8: /* setting up point array */

/*       point_len = 0; */
       point_arr(&point_len,point_vec);
       break;

     case 9: /* fill distance array for graphic display */

     i = read_traj(1,&numset,pasback); /*check if in/out of core*/
       if(i < 0) break;

     if(dist_len < 1) {
     printf("\07\07 *** No distance array set up ***\n");
     break;} 

      strcpy(bottom_line,"Reading trajectory to set up distance array...");
      going_on();

     if(traj_in_core == 1) {
       i = read_traj(2,&numset,pasback);
         if(i < 0) break;}

      sprintf(bottom_line,"Building distance array ...");
      going_on();

     if(obs_vec_point == 0) 
     obs_vec = vector(dist_len * FramesInSet());
     else
     /* add space for one set of obs */
     obs_vec = vector_add(obs_vec,(obs_vec_point+dist_len/2) * FramesInSet()); 

         build_dist_vec(dist_len,
                        dist_vec,
                        &num_obs,
  &obs_vec[obs_vec_point*FramesInSet()],
                          FramesInSet());

    obs_vec_point += dist_len / 2;

     dist_arr_set = 1;

/* update play structure */
    play_dynam_frames.dist_len = dist_len;
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

       if(traj_in_core == 1) { /* delete scratch space */
          free(coordx);
          free(coordy);
          free(coordz);}
    break; /* end of fill distance array */
    

    case 10: /* fill angle array for graphic display */

     i = read_traj(1,&numset,pasback); /*check if in/out of core*/
       if(i < 0) break;

     if(ang_len < 1) {
      printf("\07\07 *** No angle array set up ***\n");
      break;}

      strcpy(bottom_line,"Reading trajectory to set up angle array...");
      going_on();

      if(traj_in_core == 1) {
        i = read_traj(2,&numset,pasback);
          if(i < 0) break;}

      strcpy(bottom_line,"Building angle array...");
      going_on();

      if(obs_vec_point == 0) 
      obs_vec = vector(ang_len * FramesInSet());
      else
      /* add space for angle array */
      obs_vec = vector_add(obs_vec,(obs_vec_point+ang_len/3) * FramesInSet()); 

                    build_ang_vec(ang_len,
                                  ang_vec,
  &num_obs,&obs_vec[obs_vec_point * FramesInSet()],
                                   FramesInSet());
      obs_vec_point += ang_len / 3;

/* update play structure */
    play_dynam_frames.ang_len = ang_len;
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;


      if(traj_in_core == 1) { /* free some scratch space */
         free(coordx);
         free(coordy);
         free(coordz);}
      break; /* end of fill angle array */

     case 11: /* fill torsion array for graphic display */

     i = read_traj(1,&numset,pasback); /*check if in/out of core*/
       if(i < 0) break;

       if(tors_len < 1) {
       printf("\07\07\n");
       PrintMessage("*** No torsion array set up ***");
       break;}

     strcpy(bottom_line,"Reading trajectory to set up torsion array...");
     going_on();

    if(traj_in_core == 1) {
      i = read_traj(2,&numset,pasback);
        if(i < 0) break;}

      strcpy(bottom_line,"Building torsion array...");
      going_on();

    if(obs_vec_point == 0) 
    obs_vec = vector(tors_len * FramesInSet());
    else
    /* add space for torsion array */
    obs_vec = vector_add(obs_vec,(obs_vec_point+tors_len/4) * FramesInSet());

               build_tors_vec(tors_len,
                              tors_vec,
                              &num_obs,
        &obs_vec[obs_vec_point * FramesInSet()],
                                 FramesInSet());

    obs_vec_point += tors_len / 4;
    tors_arr_set = 1;

/* update play structure */
    play_dynam_frames.tors_len = tors_len;
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;
  
    if(traj_in_core == 1) { /* free scratch space */
       free(coordx);
       free(coordy);
       free(coordz); }
    break; /* end of fill torsion array */

    case 12: /* file total energy array for graphics */

    if(numset < 0) {
    i = read_traj(1,&numset,pasback);
    if(i < 0) 
       break;}
             if(et_count ==0) {
             if(keyb_command ==0 && energy_file[0] == '\0')
             dialog4("Give name of energy file.","File name : ",energy_file);
             i = read_et();
             if(i < 0) break;}

    if(et_count != FramesInSet()) {
       printf("?ERROR - wrong number of parameters in energy file , can't fill array\n");
       break;}

          if(obs_vec_point == 0) 
           obs_vec = vector(FramesInSet());
          else
           obs_vec = vector_add(obs_vec,(obs_vec_point+1) * FramesInSet());
            build_eng_vec(1,&num_obs,&obs_vec[obs_vec_point*FramesInSet()],
                             FramesInSet());
             obs_vec_point++;

/* update play structure */
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

   traj_energy_limits.tote_set = 1;

          break; /* end of fill energy array */

      case 13: /* fill potential energy array for graphics */

    if(numset < 0) {
    i = read_traj(1,&numset,pasback);
    if(i < 0) 
       break;}
             if(et_count ==0) {
             if(keyb_command ==0 && energy_file[0] == '\0')
             dialog4("Give name of energy file.","File name : ",energy_file);
             i = read_et();
             if(i < 0) break;}

    if(et_count != FramesInSet()) {
    PrintMessage("?ERROR - wrong number of parameters in energy file , can't fill array");
       break;}

          if(obs_vec_point == 0) 
           obs_vec = vector(FramesInSet());
          else
           obs_vec = vector_add(obs_vec,(obs_vec_point+1) * FramesInSet());
            build_eng_vec(2,&num_obs,&obs_vec[obs_vec_point*FramesInSet()],
                             FramesInSet());
             obs_vec_point++;

/* update play structure */
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

   traj_energy_limits.kine_set = 1;

          break; /* end of potential energy array */

    case 14: /* fill kinetic energy array for graphics */

    if(numset < 0) {
    i = read_traj(1,&numset,pasback);
    if(i < 0) 
       break;}
             if(et_count ==0) {
             if(keyb_command ==0 && energy_file[0] == '\0')
             dialog4("Give name of energy file.","File name : ",energy_file);
             i = read_et();
             if(i < 0) break;}

    if(et_count != FramesInSet()) {
    PrintMessage("?ERROR - wrong number of parameters in energy file , can't fill array");
       break;}

          if(obs_vec_point == 0) 
           obs_vec = vector(FramesInSet());
          else
           obs_vec = vector_add(obs_vec,(obs_vec_point+1) * FramesInSet());
            build_eng_vec(3,&num_obs,&obs_vec[obs_vec_point*FramesInSet()],
                             FramesInSet());
             obs_vec_point++;

/* update play structure */
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

   traj_energy_limits.pote_set = 1;

          break; /* end of kinetic energy array */

      case 15: /* fill temperature array for graphics  */

    if(numset < 0) {
    i = read_traj(1,&numset,pasback);
    if(i < 0) 
       break;}
          if(et_count ==0) {
             if(keyb_command ==0 && energy_file[0] == '\0')
          dialog4("Give name of temperature file.","File name : ",energy_file);
             i = read_et();
             if(i < 0) break;}

    if(et_count != FramesInSet()) {
    PrintMessage("?ERROR - wrong number of parameters in energy file , can't fill array");
       break;}

          if(obs_vec_point == 0) 
           obs_vec = vector(FramesInSet());
          else
           obs_vec = vector_add(obs_vec,(obs_vec_point+1) * FramesInSet());
            build_eng_vec(4,&num_obs,&obs_vec[obs_vec_point*FramesInSet()],
                             FramesInSet());
             obs_vec_point++;

/* update play structure */
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

   traj_energy_limits.temp_set = 1;

          break; /* end of temp array */

    case 17:
    case 18:
    case 19:
    case 16: /* kill 2d plot vector                  */
             if(obs_vec_point > 0) {
                free(obs_vec);}
             obs_vec_point=0;
             point_len    = 0;
              dist_len    = 0;
               ang_len    = 0;
                tors_len  = 0;
             break;

     case 20:  /* calc correlation */

               if(obs_vec_point == 0 || numset == 0) {
               PrintMessage("?ERROR - no observations set up ");
               break;}

               if(corr_info.corr_vec1 < 1 || 
                  corr_info.corr_vec1 > obs_vec_point) {
               PrintMessage("?ERROR - wrong indec for correlation list ");
               break;}

               if(corr_info.corr_vec2 < 1 || 
                  corr_info.corr_vec2 > obs_vec_point) {
               PrintMessage("?ERROR - wrong index for correlation list ");
               break;}

/* free memory */
               if(corr_info.corr_obs > 0) {
                 corr_info.corr_obs = 0;
                  free(corr_info.corr_val);}

               corr_info.corr_val = vector(2 * check_pow_2(FramesInSet()));
               pre_correl(obs_vec_point,obs_vec,FramesInSet(),corr_info.corr_val);
/* save values */
               corr_info.corr_obs = FramesInSet();
               break;

     case 21:  /* plot correlation function */
               /* put corr plot window on */
               corr_info.corr_wind = 1;
               if(coord_save > 0) man_coordinates(2);
               return; /* no redraw of screen */
               break;

     case 22:  /* write array to disk */
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to write ");
               break;}

               write_to_disk(obs_vec_point,obs_vec,FramesInSet());
               break; 

     case 24:  /* write distance array */
               write_dist_vec(dist_len,dist_vec);
               break;

     case 23:  /* write angle array */
               write_ang_vec(ang_len,ang_vec);
               break;

     case 25:  /* write torsion array */
               write_tors_vec(tors_len,tors_vec);
               break;
     
     case 26:  /* mantime DAVErage          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number ");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,1,man_times_float,
                    man_times_int);
            break;

     case 27:  /* mantime SQUAre          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,2,man_times_float,
                    man_times_int);
            break;

     case 28:  /* mantime COS          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,3,man_times_float,
                    man_times_int);
            break;

     case 29:  /* mantime COS2          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,4,man_times_float,
                    man_times_int);
            break;


     case 30:  /* mantime SQRT          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,5,man_times_float,
                    man_times_int);
            break;

     case 31:  /* mantime DINItial          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,6,man_times_float,
                    man_times_int);
            break;

     case 32:  /* mantime COPY nr          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,7,man_times_float,
                    man_times_int);
            break;

     case 33:  /* mantime ADD nr          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,8,man_times_float,
                    man_times_int);
            break;

     case 34:  /* mantime LOG          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,9,man_times_float,
                    man_times_int);
            break;

     case 35:  /* mantime exp          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,10,man_times_float,
                    man_times_int);
            break;

     case 36:  /* mantime POWer          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,11,man_times_float,
                    man_times_int);
            break;

     case 37:  /* mantime MULT nr          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,12,man_times_float,
                    man_times_int);
            break;

     case 38:  /* mantime DIVIde          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,13,man_times_float,
                    man_times_int);
            break;

     case 39:  /* mantime SHIFt float          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,14,man_times_float,
                    man_times_int);
            break;

     case 40:  /* mantime DMIN          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,15,man_times_float,
                    man_times_int);
            break;

     case 41:  /* mantime ABS          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,16,man_times_float,
                    man_times_int);
            break;

     case 42:  /* mantime DIVFirst          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,17,man_times_float,
                    man_times_int);
            break;

     case 43:  /* mantime DIVMaximum          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,18,man_times_float,
                    man_times_int);
            break;

     case 44:  /* mantime ZERO          */ 
               if(obs_vec_point < 1 || numset < 1) {
               PrintMessage("?ERROR - nothing to manipulate");
               break;}
               if(times_nr < 1 || times_nr > obs_vec_point) {
               PrintMessage("?ERROR - wrong time series number");
               break;}
            mantime(obs_vec,FramesInSet(),times_nr,19,man_times_float,
                    man_times_int);
            break;

      case 45: /* free obs_vec array */
             if(obs_vec_point > 0) {
             PrintMessage(">> Deleting time series scratch array");
                free(obs_vec);}
             else 
             PrintMessage("?ERROR - no time series to delete");

             obs_vec_point=0;
             break; 

     case 46: /* fill point array for graphic display */

     i = read_traj(1,&numset,pasback); /*check if in/out of core*/
       if(i < 0) break;

     if(point_len < 1) {
     printf("\07\07 *** No point array set up ***\n");
     break;} 

      strcpy(bottom_line,"Reading trajectory to set up point array...");
      going_on();

     if(traj_in_core == 1) {
       i = read_traj(2,&numset,pasback);
         if(i < 0) break;}

      sprintf(bottom_line,"Building point array ...");
      going_on();

     if(obs_vec_point == 0) 
     obs_vec = vector( point_len * FramesInSet());
     else
     /* add space for one set of obs */
     obs_vec = vector_add(obs_vec,(obs_vec_point+point_len) * FramesInSet()); 

         build_point_vec(point_len,
                        point_vec,
                        &num_obs,
  &obs_vec[obs_vec_point * FramesInSet()],
                          FramesInSet());

    obs_vec_point += point_len;

     point_arr_set = 1;

/* update play structure */
    play_dynam_frames.point_len = point_len;
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

       if(traj_in_core == 1) { /* delete scratch space */
          free(coordx);
          free(coordy);
          free(coordz);}
    break; /* end of fill point array */
    
      case 50: /* fill bond array for graphics  */

    if(numset < 0) {
    i = read_traj(1,&numset,pasback);
    if(i < 0) 
       break;}
          if(et_count ==0) {
             if(keyb_command ==0 && energy_file[0] == '\0')
          dialog4("Give name of bond energy file.","File name : ",energy_file);
             i = read_et();
             if(i < 0) break;}

    if(et_count != FramesInSet()) {
    PrintMessage("?ERROR - wrong number of parameters in energy file , can't fill array");
       break;}

          if(obs_vec_point == 0) 
           obs_vec = vector(FramesInSet());
          else
           obs_vec = vector_add(obs_vec,(obs_vec_point+1) * FramesInSet());
            build_eng_vec(5,&num_obs,&obs_vec[obs_vec_point*FramesInSet()],
                             FramesInSet());
             obs_vec_point++;

/* update play structure */
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

   traj_energy_limits.bond_set = 1;

          break; /* end of bond array */

      case 51: /* fill angle array for graphics  */

    if(numset < 0) {
    i = read_traj(1,&numset,pasback);
    if(i < 0) 
       break;}
          if(et_count ==0) {
             if(keyb_command ==0 && energy_file[0] == '\0')
          dialog4("Give name of angle energy file.","File name : ",energy_file);
             i = read_et();
             if(i < 0) break;}

    if(et_count != FramesInSet()) {
    PrintMessage("?ERROR - wrong number of parameters in energy file , can't fill array");
       break;}

          if(obs_vec_point == 0) 
           obs_vec = vector(FramesInSet());
          else
           obs_vec = vector_add(obs_vec,(obs_vec_point+1) * FramesInSet());
            build_eng_vec(6,&num_obs,&obs_vec[obs_vec_point*FramesInSet()],
                             FramesInSet());
             obs_vec_point++;

/* update play structure */
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

   traj_energy_limits.angl_set = 1;

          break; /* end of bond array */

      case 52: /* fill dihe array for graphics  */

    if(numset < 0) {
    i = read_traj(1,&numset,pasback);
    if(i < 0) 
       break;}
          if(et_count ==0) {
             if(keyb_command ==0 && energy_file[0] == '\0')
          dialog4("Give name of bond energy file.","File name : ",energy_file);
             i = read_et();
             if(i < 0) break;}

    if(et_count != FramesInSet()) {
    PrintMessage("?ERROR - wrong number of parameters in energy file , can't fill array");
       break;}

          if(obs_vec_point == 0) 
           obs_vec = vector(FramesInSet());
          else
           obs_vec = vector_add(obs_vec,(obs_vec_point+1) * FramesInSet());
            build_eng_vec(7,&num_obs,&obs_vec[obs_vec_point*FramesInSet()],
                             FramesInSet());
             obs_vec_point++;

/* update play structure */
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

   traj_energy_limits.dihe_set = 1;

          break; /* end of dihedral array */

      case 53: /* fill improper array for graphics  */

    if(numset < 0) {
    i = read_traj(1,&numset,pasback);
    if(i < 0) 
       break;}
          if(et_count ==0) {
             if(keyb_command ==0 && energy_file[0] == '\0')
          dialog4("Give name of improper  energy file.","File name : ",energy_file);
             i = read_et();
             if(i < 0) break;}

    if(et_count != FramesInSet()) {
    PrintMessage("?ERROR - wrong number of parameters in energy file , can't fill array");
       break;}

          if(obs_vec_point == 0) 
           obs_vec = vector(FramesInSet());
          else
           obs_vec = vector_add(obs_vec,(obs_vec_point+1) * FramesInSet());
            build_eng_vec(8,&num_obs,&obs_vec[obs_vec_point*FramesInSet()],
                             FramesInSet());
             obs_vec_point++;

/* update play structure */
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

   traj_energy_limits.impr_set = 1;

          break; /* end of bond array */

      case 54: /* fill vdw array for graphics  */

    if(numset < 0) {
    i = read_traj(1,&numset,pasback);
    if(i < 0) 
       break;}
          if(et_count ==0) {
             if(keyb_command ==0 && energy_file[0] == '\0')
          dialog4("Give name of vdw energy file.","File name : ",energy_file);
             i = read_et();
             if(i < 0) break;}

    if(et_count != FramesInSet()) {
    PrintMessage("?ERROR - wrong number of parameters in energy file , can't fill array");
       break;}

          if(obs_vec_point == 0) 
           obs_vec = vector(FramesInSet());
          else
           obs_vec = vector_add(obs_vec,(obs_vec_point+1) * FramesInSet());
            build_eng_vec(9,&num_obs,&obs_vec[obs_vec_point*FramesInSet()],
                             FramesInSet());
             obs_vec_point++;

/* update play structure */
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

   traj_energy_limits.vdw_set = 1;

          break; /* end of vdw array */

      case 55: /* fill elec array for graphics  */

    if(numset < 0) {
    i = read_traj(1,&numset,pasback);
    if(i < 0) 
       break;}
          if(et_count ==0) {
             if(keyb_command ==0 && energy_file[0] == '\0')
          dialog4("Give name of elec energy file.","File name : ",energy_file);
             i = read_et();
             if(i < 0) break;}

    if(et_count != FramesInSet()) {
    PrintMessage("?ERROR - wrong number of parameters in energy file , can't fill array");
       break;}

          if(obs_vec_point == 0) 
           obs_vec = vector(FramesInSet());
          else
           obs_vec = vector_add(obs_vec,(obs_vec_point+1) * FramesInSet());
            build_eng_vec(10,&num_obs,&obs_vec[obs_vec_point * FramesInSet()],
                              FramesInSet());
             obs_vec_point++;

/* update play structure */
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

   traj_energy_limits.elec_set = 1;

          break; /* end of elec array */

      case 56: /* fill hbond array for graphics  */

    if(numset < 0) {
    i = read_traj(1,&numset,pasback);
    if(i < 0) 
       break;}
          if(et_count ==0) {
             if(keyb_command ==0 && energy_file[0] == '\0')
          dialog4("Give name of hbond energy file.","File name : ",energy_file);
             i = read_et();
             if(i < 0) break;}

    if(et_count != FramesInSet()) {
    PrintMessage("?ERROR - wrong number of parameters in energy file , can't fill array");
       break;}

          if(obs_vec_point == 0) 
           obs_vec = vector(FramesInSet());
          else
           obs_vec = vector_add(obs_vec,(obs_vec_point+1) * FramesInSet());
            build_eng_vec(11,&num_obs,&obs_vec[obs_vec_point * FramesInSet()],
                              FramesInSet());
             obs_vec_point++;

/* update play structure */
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

   traj_energy_limits.hbond_set = 1;

          break; /* end of hbond array */

#ifdef JUNK
      case 57: /* fill external array for graphics  */

      if(keyb_command ==0)
          dialog4("Give name of elec energy file.","File name : ",text);
             i = ReadExternal(text);
    if(i != FramesInSet()) {
    PrintMessage(
    "?ERROR - wrong number of parameters in energy file , can't fill array");
    break;}
             if(i < 0) break;}

          if(obs_vec_point == 0) 
           obs_vec = vector(FramesInSet());
          else
           obs_vec = vector_add(obs_vec,(obs_vec_point+1) * FramesInSet());
            build_eng_vec(12,&num_obs,&obs_vec[obs_vec_point * FramesInSet()],
                              FramesInSet());
             obs_vec_point++;

/* update play structure */
    play_dynam_frames.obs_vec_len = obs_vec_point; 
/* export pointer */
    play_dynam_frames.obs_vec  = obs_vec;

   traj_energy_limits.elec_set = 1;

          break; /* end of external array */
#endif

     }

/* update structure */
    play_dynam_frames.numset      = FramesInSet();
    play_dynam_frames.point_len   = point_len;
    play_dynam_frames.dist_len    = dist_len;
    play_dynam_frames.ang_len     = ang_len;
    play_dynam_frames.tors_len    = tors_len;
    play_dynam_frames.obs_vec_len = obs_vec_point;
    play_dynam_frames.current_set = -1;

    (void)TrajAnalysisPointers(point_len, point_vec,
                           dist_len,  dist_vec,
                           ang_len,   ang_vec,
                           tors_len,  tors_vec,
                           cc_len,    cc_vec,
                           mc_len,    mc_vec);

    if(coord_save > 0) {
       man_coordinates(2);
       if(traj_file_set == 4) atom_conn(mlist_deep);
    }

    if(yes_no_graph) {
      if(keyb_command == 0)
         bang_it();
      strcpy(bottom_line,"** Choose from main menu");
      going_on();}

    keyb_command = 0; /* reset keyboard command switch */
}

#define SWITCH_FROM_QUE()     { switch(funct_ret) {               \
                              case 1:  text_bottom = 1; return;   \
                              case 3:                             \
                              l++;                                \
                              if(l == *obs_vec_point) l = 0;      \
                              play_dynam_frames.obs_vec_curr = l; \
                              break;                              \
                              case 4:                             \
                              disp_obj[0] = 0;                    \
                              if(*obs_vec_point > 0) {             \
                              *obs_vec_point = 0;                  \
                              dist_len = 0; ang_len = 0;          \
                              tors_len = 0; free(obs_vec);}       \
                              break;                              \
                              case 5: dist_len=0; break;          \
                              case 6: ang_len=0; break;           \
                              case 7: tors_len=0; break;}}

/*  plot the dynamics trajectory    */
/*************************************************************************/
plot_dynamics(ialt,numset,pasback,
                    point_len,point_vec,
                    dist_len,dist_vec,
                    ang_len, ang_vec ,
                    tors_len,tors_vec,
                    num_obs,obs_vec,
                    obs_vec_point)
/*************************************************************************/
 

    int    numset,pasback[];
    int    point_len,*point_vec;
    int    dist_len,*dist_vec;
    int    ang_len,*ang_vec;
    int    tors_len,*tors_vec;
    int    num_obs;
    float *obs_vec;
    int   *obs_vec_point;
    int ialt;

{
     static int i,j,k,l=0,funct_ret;
     float ddx,ddy;
     char text[BUFF_LEN],input;
     char OutText[BUFF_LEN];
     int retv;
     int step;
     int Loop1;
     int Loop2;

     funct_ret=0;

     text_bottom = 0;          /* turn text at bottom off     */

#ifndef FAST
     build_array();            /* calculate the array needed for surface
                                  calculations */
#endif

     l=0; /* start always from plot nr 1 */

    step = mliste[0];

/*  main loop here */

      (void)UpdateAllOpenWindows();

      switch(ialt) {

      case 1: /* movie in core */
      while(1) {

      Loop1 = 0;

      for(k = (TrajectoryFirstFrame() - 1) ; 
          k <  TrajectoryLastFrame() ; 
          k += TrajectoryStepFrame()  ){

      for(i = mlists[0] ; i < mliste[0]  ; i++ ){
          x[i] = coordx[i + Loop1 * step] - sumx ;
          y[i] = coordy[i + Loop1 * step] - sumy ;
          z[i] = coordz[i + Loop1 * step] - sumz ;}

      if(traj_file_set == 4 || Connect.CalcConn) atom_conn(mlist_deep);

      if(colour_structure_by) do_colouring(k , colour_structure_by);

      play_dynam_frames.current_set = Loop1;

      c3s(txcolor);
      sprintf(text,"Frame nr: %d, time: %d fs",Loop1+1,
                    pasback[1]+k*pasback[2]);
      Send_put_text(0.005 , 0.005 , text);

      bang_it();

      funct_ret = test_queue(UPDATE_OFF);

      rest_sec(time_bw_step); /* wait here for time_bw_step seconds */


      SWITCH_FROM_QUE();

      Loop1++;

      /*    */}}

      break;

      case 2: /* move by arrow keys */

      k = 0;
      dev = 0;
/* plot first frame ...                      */

      if(colour_structure_by) do_colouring(k , colour_structure_by);

      play_dynam_frames.current_set = k;

      DoSanitary();

      c3s(txcolor);
      sprintf(text,"Frame nr: %d, time: %d fs",k+1,pasback[1] + 
              TrajectoryStepFrame() * k *pasback[2]);
      Send_put_text(0.005 , 0.005 , text);

       bang_it();

/* first frame on screen ...   */

/* now the others              */

      while(1) {

      funct_ret = test_queue(UPDATE_OFF);

      if(funct_ret == -1) { /* temporary fix !!! */
             if(colour_structure_by) do_colouring(k , colour_structure_by);
             c3s(txcolor);
             sprintf(text,
             "Frame nr: %d, time: %d fs",k+1,pasback[1] + 
              TrajectoryStepFrame() * k * pasback[2]);
             Send_put_text(0.005 , 0.005 , text);
             bang_it();}

      switch(funct_ret) {

      case 0: goto last1;
      case 1:  {text_bottom = 1; return;}
      case 3: 
             l++; 
             if(l == *obs_vec_point) l = 0; 
             play_dynam_frames.obs_vec_curr = l;
             break;
      case 4: 
      disp_obj[0] = 0;
      if(*obs_vec_point > 0) {
       *obs_vec_point = 0;
        dist_len = 0; 
         ang_len = 0; 
          tors_len = 0; 
           free(obs_vec);}
       break;
      case 5: dist_len=0; break;
      case 6: ang_len=0; break;
      case 7: tors_len=0; break;
      case 8: k++; break;  /* uparrowkey */
      case 9: k--; break;  /* downarrowkey */
      case 10: /* specify a new frame */
               dialog4("Defining a new frame ...","Give frame nr:  ",text);
               j = atoi(text);
               if(j > 0 && j <= FramesInSet()) k = j - 1;
               break;
      default: goto last1;}

      if(k == FramesInSet()) {
      k = FramesInSet() - 1;
      printf("\07\07\n"); }
      if(k < 0) {
      k = 0;
      printf("\07\07\n"); }
 
      for(i = mlists[0] ; i < mliste[0]  ; i++ ){
          x[i] = coordx[i+k*step] - sumx ;
          y[i] = coordy[i+k*step] - sumy ;
          z[i] = coordz[i+k*step] - sumz ;}

      if(traj_file_set == 4 || Connect.CalcConn) atom_conn(mlist_deep);

      if(colour_structure_by) do_colouring(k , colour_structure_by);

      play_dynam_frames.current_set = k;

      DoSanitary();

      c3s(txcolor);
      sprintf(text,"Frame nr: %d, time: %d fs",k+1,pasback[1]+k*pasback[2]);
      Send_put_text(0.005 , 0.005 , text);

       bang_it();

      last1:;
      /*    */}

      break;

      case 3: /* average structure */

      plot_av(FramesInSet(),point_len,point_vec,dist_len,dist_vec,ang_len,
              ang_vec,tors_len,tors_vec);

      while(1) {

      funct_ret = test_queue(UPDATE_ON);

      if(funct_ret == 1) {text_bottom = 1; return;}
      
      if(funct_ret == 2) {
      plot_av(numset,point_len,point_vec,dist_len,dist_vec,ang_len,ang_vec,
              tors_len,tors_vec);}
      }

      break;

      case 4: /* out of core movie */
/* open trajectory file */
   charmm_oc = fopen(traj_file,"r");
   if(charmm_oc == NULL) {
   sprintf(OutText,">>> Can't open input file: %s",traj_file);
   PrintMessage(OutText);
   shut_down(1); }

      while(1) {

      for(k = (TrajectoryFirstFrame() - 1) ; 
          k <  TrajectoryLastFrame() ; 
          k += TrajectoryStepFrame() ){

/*  read frame ... */

   mlist_deep     = 0;
   current_struct = 0;

      retv = rtraj_frame(k);

           if(retv < 0) {
              fclose(charmm_oc);
              text_bottom = 1;
              return;}

   rewind(charmm_oc);

      for(i = mlists[0] ; i < mliste[0]  ; i++ ){
          x[i] = x[i] - sumx ;
          y[i] = y[i] - sumy ;
          z[i] = z[i] - sumz ;}

      if(traj_file_set == 4 || Connect.CalcConn) atom_conn(mlist_deep);

      if(colour_structure_by) do_colouring(k , colour_structure_by);

      play_dynam_frames.current_set = k;

      DoSanitary();

      c3s(txcolor);
      sprintf(text,"Frame nr: %d, time: %d fs",k+1,pasback[1]+k*pasback[2]);
      Send_put_text(0.005 , 0.005 , text);

       bang_it();

      rest_sec(time_bw_step); /* wait here for time_bw_step seconds */

      funct_ret = test_queue(UPDATE_OFF);

      switch(funct_ret) {

      case 1:  
      fclose(charmm_oc);
      text_bottom = 1;
      return;
      case 3: 
             l++; 
             if(l == *obs_vec_point) l = 0; 
             play_dynam_frames.obs_vec_curr = l;
             break;
      case 4: 
      disp_obj[0] = 0;
      if(*obs_vec_point > 0) {
       *obs_vec_point = 0;
        dist_len = 0; 
         ang_len = 0; 
          tors_len = 0; 
           free(obs_vec);}
        break;
      case 5: dist_len=0; break;
      case 6: ang_len=0; break;
      case 7: tors_len=0; break;}

      /*    */}
      rewind(charmm_oc);}

      break;

      case 5: /* out of core average structure */

      printf("\007\n");
      PrintMessage("?ERROR - THIS PART IS REMOVED");
      break;

      case 6: /* out of core step frame */
/* open trajectory file */
   charmm_oc = fopen(traj_file,"r");
   if(charmm_oc == NULL) {
   sprintf(OutText,">>> Can't open input file: %s",traj_file);
   PrintMessage(OutText);
   shut_down(1); }

      k = 0;
      dev = 0;
/* make the first frame ready ... */

   mlist_deep     = 0;
   current_struct = 0;

      retv = rtraj_frame(k);
           if(retv < 0) {
              fclose(charmm_oc);
              text_bottom = 1;
              return;}

   rewind(charmm_oc);

      for(i = mlists[0] ; i < mliste[0]  ; i++ ){
          x[i] = x[i] - sumx ;
          y[i] = y[i] - sumy ;
          z[i] = z[i] - sumz ;}

      if(traj_file_set == 4 | Connect.CalcConn) atom_conn(mlist_deep);

      if(colour_structure_by) do_colouring(k , colour_structure_by);

      play_dynam_frames.current_set = k;

      DoSanitary();

      c3s(txcolor);
      sprintf(text,"Frame nr: %d, time: %d fs",k+1,pasback[1]+k*pasback[2]);
      Send_put_text(0.005 , 0.005 , text);

       bang_it();

/* first frame is now ready and put on screen ...*/

/* go on with the rest ...                       */
      while(1) {

      funct_ret = test_queue(UPDATE_OFF); /* look into queue */

      if(funct_ret == -1) { /* temporary fix !!! */
             if(colour_structure_by) do_colouring(k , colour_structure_by);
             c3s(txcolor);
             sprintf(text,
             "Frame nr: %d, time: %d fs",k+1,pasback[1]+k*pasback[2]);
             Send_put_text(0.005 , 0.005 , text);
             bang_it();}

      switch(funct_ret) {

      case 0: goto last;
      case 1:  fclose(charmm_oc); text_bottom = 1; return;
      case 3: 
             l++; 
             if(l == *obs_vec_point) l = 0; 
             play_dynam_frames.obs_vec_curr = l;
             break;
      case 4: 
      disp_obj[0] = 0;
      if(*obs_vec_point > 0) {
       *obs_vec_point = 0;
        dist_len = 0; 
         ang_len = 0; 
          tors_len = 0; 
           free(obs_vec);}
        break;
      case 5: dist_len=0; break;
      case 6: ang_len=0; break;
      case 7: tors_len=0; break;
      case 8: k++; break;  /* uparrowkey */
      case 9: k--; break;  /* downarrowkey */
      case 10: /* specify a new frame */
               dialog4("Defining a new frame ...","Give frame nr:  ",text);
               j = atoi(text);
               if(j > 0 && j <= numset) k = j - 1;
               break;
      default: goto last;}

      if(k == numset) {
      k = numset-1;
      printf("\07\07\n");
      goto last; }
      if(k < 0) {
      k = 0;
      printf("\07\07\n"); }
 
/*  read frame ... */

      mlist_deep     = 0;
      current_struct = 0;

      retv = rtraj_frame(k);
           if(retv < 0) {
              fclose(charmm_oc);
              text_bottom = 1;
              return;}

   rewind(charmm_oc);

      for(i = mlists[0] ; i < mliste[0]  ; i++ ){
          x[i] = x[i] - sumx ;
          y[i] = y[i] - sumy ;
          z[i] = z[i] - sumz ;}

      if(traj_file_set == 4 || Connect.CalcConn) atom_conn(mlist_deep);

      if(colour_structure_by) do_colouring(k , colour_structure_by);

      play_dynam_frames.current_set = k;

      DoSanitary();

      c3s(txcolor);
      sprintf(text,"Frame nr: %d, time: %d fs",k+1,pasback[1]+k*pasback[2]);
      Send_put_text(0.005 , 0.005 , text);

       bang_it();

      last:;
      /*    */}

      break;
   }
   text_bottom = 1;
   return;
}
/***************************************************************************/
plot_av(        /* plot average structure and some statistics */
        numset,
        point_len,point_vec,
        dist_len,dist_vec,
        ang_len,ang_vec,
        tors_len,tors_vec)

        int numset;
        int point_len,*point_vec;
        int dist_len,*dist_vec;
        int ang_len,*ang_vec;
        int tors_len,*tors_vec;
/***************************************************************************/
{

       bang_it();

}

#endif

#define MOD(a,b)  (((a+1)/b)*b - (a+1))

/***************************************************************************/
int read_traj(ialt,numset,pasback)  /* read the right file type   */
    int *numset;
    int pasback[];
    int ialt;
/***************************************************************************/
{
         static int retv;

         switch(force_type) {

         case 0: /* type is not set */
                 PrintMessage("?ERROR - trajectory type is not set");
                 return(-1);

	 case 1: /* charmm type */
                 retv = read_traj_charmm(ialt,numset,pasback);
                 (void)ShuffleTrajectoryLimits(numset);
                 play_dynam_frames.numset = FramesInSet();
                 return(retv);              

	 case 2: /* discover type */
                 retv = get_frame_discover( -1 , 0);
                 pasback[2] = trajectory_info.time_bw_steps;
                 pasback[1] = trajectory_info.time_first_frame;
                 (void)ShuffleTrajectoryLimits(numset);
                 play_dynam_frames.numset = FramesInSet();
                 *numset = play_dynam_frames.numset;
                 return(retv);

 	 case 3: /* amber type */
                 retv = read_traj_amber(ialt,numset,pasback);
                 (void)ShuffleTrajectoryLimits(numset);
                 play_dynam_frames.numset = FramesInSet();
                 return(retv);

	 case 4: /* yasp type */
                 retv = read_traj_yasp(ialt,numset,pasback);
                 (void)ShuffleTrajectoryLimits(numset);
                 play_dynam_frames.numset = FramesInSet();
                 return(retv);

	 case 5: /* mumod type */
                 retv = read_traj_mumod(ialt,numset,pasback);
                 (void)ShuffleTrajectoryLimits(numset);
                 play_dynam_frames.numset = FramesInSet();
                 return(retv);

	 case 6: /* gromos type */
                 retv = read_traj_gromos(ialt,numset,pasback);
                 (void)ShuffleTrajectoryLimits(numset);
                 play_dynam_frames.numset = FramesInSet();
                 return(retv);

	 case 7: /* hyperchem type */
                 retv = read_traj_hyperchem(ialt,numset,pasback);
                 (void)ShuffleTrajectoryLimits(numset);
                 play_dynam_frames.numset = FramesInSet();
                 return(retv);

	 default: /* there is something wrong */
                 PrintMessage("?ERROR - can't continue (in 'read_traj')");
                 shut_down(1);
	       }
}

#define CHARMM_TEXT_FIELD 80

/***************************************************************************/
int read_traj_charmm(ialt,numset,pasback)  /* read charmm trajectory   */
/***************************************************************************/

    int *numset,pasback[20],ialt;
{

/*  
     Program to read CHARMm binary files

     leif laaksonen  1989
*/

/* 1 HDR , ICONTR  */
  char hdr[4];      /* unknown header information */
  int icntrl[20];  /* contains information about the datasets held in file

                     (1) number of data sets in the file. Not necessary correct
                     (2) time of the first data set. Usually in femtoseconds
                     (3) time steps between data sets
                     (9) number of fixed atoms (NFIXED)  
                     (11) 1 for crystal/constant pressure calculation
                          0 otherwise
                     (20) version number (22 for CHARMm 22, 0 for
                          previous version */

/* 2 TITLE         */
  int ntitl;      /* (title(i,j), i=1,10),j=1,ntitl)
                     double precision title(10,10) */

/* 3 NATOM          (NFREAT = NATOM - NFIXED) */
  int natom;


FILE  *charmm;  /* CHARMm input file pointer  */
   static int icount,i,j;
   static int record;
   static int need_memory;
   static int nstep,istep,ifbeg,ifstep;

   static int read_loop;
   static int nfreat;
   static int qcrys;
   static int CrystLen;

   static float *tax; /* temp vectors in case of fixed atoms */
   static float *tay;
   static float *taz;
   static int jumps;
   static int JumpLen;
   static int MemLen;
   static int NumBytesInFile , DeltaBytes;
   char title[BUFF_LEN];
   char OutText[BUFF_LEN];

   charmm = fopen(traj_file,"r");
   if(charmm == NULL) {
   sprintf(OutText,">>> Can't open input file: %s",traj_file);
   PrintMessage(OutText);
   return(-1); }

    CrystLen = 0;

/*  start reading  */

#ifdef CRAY

    icount = fread(&record,sizeof(int), 1 ,charmm);
    icount = fread(hdr,sizeof(char), 4 ,charmm);
    icount = fread(icntrl,sizeof(int), 20 ,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);
    icount = fread(&ntitl,sizeof(int), 1 ,charmm);

    if(ntitl > MAX_TITLE_LINES_TRAJ) {
    PrintMessage("?ERROR - problems in reading the title in the trajectory file");
    PrintMessage("Are you sure this is a CHARMM trajectory?");
    return(-1);}

    sprintf(title,"Title of file %s is:",traj_file);
    PrintMessage(title);

    sprintf(OutText,"Title of file %s is:",traj_file);
    for(i = 0 ; i < ntitl ; i++) {
       for(j = 0 ; j < BUFF_LEN ; j++) title[i] = '\0';
    icount = fread(title, CHARMM_TEXT_FIELD ,1,charmm);
/* kill the last chap */
    title[ CHARMM_TEXT_FIELD - 1 ] = '\0';
    sprintf(OutText,"%s",title);
    PrintMessage(OutText);
    }
    
    nfreat = natom;

    icount = fread(&record,sizeof(int), 1 ,charmm);
    icount = fread(&natom,sizeof(int), 1 , charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    qcrys = 0;
    if(icntrl[10]) {
      qcrys = 1;
       CrystLen = 2 * sizeof(int) + 6 * sizeof(float);}

    if(icntrl[8] > 0) {/* there are fixed atoms */
     if(free_alist.nfreat > 0) free(free_alist.free_atom_list);
    nfreat = natom - icntrl[8];
    free_alist.nfreat = nfreat;
    free_alist.free_atom_list = ivector(nfreat);

      tax = vector(nfreat);
       tay = vector(nfreat);
        taz = vector(nfreat);

    icount = fread(free_alist.free_atom_list,sizeof(int), nfreat , charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);}

#else
  
    icount = fread(&record,sizeof(int), 1 ,charmm);

    icount = fread(hdr,sizeof(char), 4 ,charmm);
    icount = fread(icntrl,sizeof(int), 20 ,charmm);

    icount = fread(&record,sizeof(int), 1 ,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    icount = fread(&ntitl,sizeof(int), 1 ,charmm);

    if(ntitl > MAX_TITLE_LINES_TRAJ) {
    PrintMessage("?ERROR - problems in reading the title in the trajectory file");
    PrintMessage("Are you sure this is a CHARMM trajectory?");
    return(-1);}

    sprintf(OutText,"Title of file %s is:",traj_file);
    PrintMessage(OutText);
    for(i = 0 ; i < ntitl ; i++) {
       for(j = 0 ; j < BUFF_LEN ; j++) title[i] = '\0';
    icount = fread(title, CHARMM_TEXT_FIELD ,1,charmm);
/* kill the last chap */
    title[ CHARMM_TEXT_FIELD - 1] = '\0';
    sprintf(OutText,"%s",title);
    PrintMessage(OutText);
    }

    icount = fread(&record,sizeof(int), 1 ,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    icount = fread(&natom,sizeof(int), 1 , charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    nfreat = natom;

    qcrys = 0;
    if(icntrl[10]) {
      qcrys = 1;
       CrystLen = 2 * sizeof(int) + 6 * sizeof(double);}

    if(icntrl[8] > 0) {/* there are fixed atoms */
     if(free_alist.nfreat > 0) free(free_alist.free_atom_list);
    nfreat = natom - icntrl[8];
    free_alist.nfreat = nfreat;
    free_alist.free_atom_list = ivector(nfreat);

      tax = vector(nfreat);
       tay = vector(nfreat);
        taz = vector(nfreat);

    icount = fread(&record,sizeof(int), 1 ,charmm);
    icount = fread(free_alist.free_atom_list,sizeof(int), nfreat , charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);}

#endif
/*                                  */

        for(i = 0 ; i < 20 ; i++) pasback[i] = icntrl[i];

	nstep=icntrl[0];
        *numset = nstep;
	ifbeg=icntrl[1];
	ifstep=icntrl[2];

/* update trajectory info ... */
        trajectory_info.natom            = natom;
        trajectory_info.nstep            = nstep;
        trajectory_info.time_bw_steps    = icntrl[2];
        trajectory_info.time_first_frame = icntrl[1];

  sprintf(title," Info for trajectory file   : %s   ",traj_file);
  PrintMessage(title);
  if(icntrl[19]) {
  sprintf(title," CHARMM version             : %d   ",icntrl[19]);
  PrintMessage(title);}
  sprintf(title," Atoms found                : %d   ",natom);
  PrintMessage(title);
  sprintf(title," Free atoms                 : %d   ",nfreat);
  PrintMessage(title);
  sprintf(title," Dynamics steps             : %d   ",nstep);
  PrintMessage(title);
  sprintf(title," Time between data sets     : %d   ",icntrl[2]);
  PrintMessage(title);
  sprintf(title," Time of the first data set : %d   ",icntrl[1]);
  PrintMessage(title);
/*
  sprintf(title," Will be retrieving every %d th set",every_step);
  PrintMessage(title);
*/
/* test that number of atoms in the file is the same as for the displayed
   molecule  */

  if(natom != mliste[0]) {
  printf("\07\07\n");
  PrintMessage(" **** ERROR number of atoms in the file does not match ****");
  check_if_fatal(1);

    if(icntrl[8]) {
      free(tax);
       free(tay);
        free(taz);}

  return(-1);}

/* if ialt is = 1 this is just a test of the trajectory file */
        if(ialt == 1) {

         if(qcrys) {
             need_memory = 
                           nstep * (3 * natom * sizeof(float) + 
                                    6 * sizeof(double));}
         else {
             need_memory =
                           nstep * (3 * natom * sizeof(float));}

                 /*bytes of memory needed */
        need_memory = need_memory / 1000; /* now in kbytes */

  sprintf(title," Memory needed for keeping everything in core is : %d Kb\n",need_memory);
  PrintMessage(title);

/* check that the number of frames are REALLY stored in the file */


       NumBytesInFile = TellBytes(charmm);

       if(icntrl[8]) {
        icount = 3 * (natom * sizeof(float) + 2 * sizeof(int)) + 
                 3 * (nstep - 1) * (nfreat * sizeof(float) +
                     2 * sizeof(float));}
       else
        icount = 3 * nstep * (natom * sizeof(float) + 2 * sizeof(int));

       if(qcrys) icount += nstep * CrystLen;

       if(icount - NumBytesInFile) {
         PrintMessage("?ERROR - there are not that many frames in the file");}

  fclose(charmm);
/* check if trajectory display/analysis can be done in core */
        traj_in_core = 1; /* in core */
        if(need_memory > max_traj_mem*1000) traj_in_core = 2; /* out of core */
  if(traj_in_core == 1){
  PrintMessage(" Trajectory display/analysis will be done in core");}
  if(traj_in_core == 2) {
  PrintMessage(" Trajectory display/analysis will be done out of core");}

    if(icntrl[8]) {
      free(tax);
       free(tay);
        free(taz);}

        return(0);}

/* go and get the memory   */

        coordx = (float *) malloc(FramesInSet() * natom*sizeof(float));
        coordy = (float *) malloc(FramesInSet() * natom*sizeof(float));
        coordz = (float *) malloc(FramesInSet() * natom*sizeof(float));

   if(coordx == NULL || coordy == NULL || coordz == NULL) {
   PrintMessage(" Memory allocation failure in read_traj ");
    if(icntrl[8]) {
      free(tax);
       free(tay);
        free(taz);}
   return(-1); }

        read_loop = 0;

         if(qcrys) {
             MemLen     =
                           3 * natom * sizeof(float) +
                                   6 * sizeof(double) + 8 * sizeof(int);}
         else {
             MemLen     =
                           3 * natom * sizeof(float) + 6 * sizeof(int);}

/* skip records if needed */
        JumpLen = TrajectoryFirstFrame() - 1;
        if(JumpLen) {
           if(ftell(charmm,JumpLen * MemLen,SEEK_CUR)) {
              PrintMessage("?ERROR - can't retrieve frame");

              if(icntrl[8]) {
                free(tax);
                 free(tay);
                  free(taz);}

              return(-1);}}

        JumpLen = TrajectoryStepFrame() - 1;

	for( istep = (TrajectoryFirstFrame() - 1) ; 
             istep <  TrajectoryLastFrame() ; 
             istep += TrajectoryStepFrame()) {

                    
     if(DebugS.DebugL) {
      sprintf(OutText," Retrieving frame number : %d ",read_loop+1);
       PrintMessage(OutText);}

#ifdef CRAY

    if(icntrl[8] > 0 && istep > 0) {

/* shuffle over first set */
       jumps = read_loop*natom;
    for( i = 0 ; i < natom ; i++) {
       coordx[jumps + i] = coordx[i];
        coordy[jumps + i] = coordy[i];
         coordz[jumps + i] = coordz[i];}

    if(qcrys) {
      icount = fread(&record,sizeof(int), 1 ,charmm);
       icount = fread(ShapeIndex.xtlabc,sizeof(float),6,charmm);
        icount = fread(&record,sizeof(int), 1 ,charmm);}

    icount = fread(tax,sizeof(float),nfreat,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    icount = fread(tay,sizeof(float),nfreat,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    icount = fread(taz,sizeof(float),nfreat,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

/* put new values in */
    for(i = 0 ; i < nfreat; i++) {
       coordx[jumps + free_alist.free_atom_list[i] - 1] = tax[i];
        coordy[jumps + free_alist.free_atom_list[i] - 1] = tay[i];
         coordz[jumps + free_alist.free_atom_list[i] - 1] = taz[i];}
       
    }

    else {

    if(qcrys) {
      icount = fread(&record,sizeof(int), 1 ,charmm);
       icount = fread(ShapeIndex.xtlabc,sizeof(float),6,charmm);
        icount = fread(&record,sizeof(int), 1 ,charmm);}

    icount = fread(&coordx[read_loop*natom],sizeof(float),natom,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    icount = fread(&coordy[read_loop*natom],sizeof(float),natom,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    icount = fread(&coordz[read_loop*natom],sizeof(float),natom,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);
  }

#else

    if(icntrl[8] > 0 && istep > 0) {

/* shuffle over first set */
       jumps = read_loop*natom;

    for( i = 0 ; i < natom ; i++) {
       coordx[jumps + i] = coordx[i];
        coordy[jumps + i] = coordy[i];
         coordz[jumps + i] = coordz[i];}

    if(qcrys) {
      icount = fread(&record,sizeof(int), 1 ,charmm);
       icount = fread(ShapeIndex.xtlabc,sizeof(double),6,charmm);
        icount = fread(&record,sizeof(int), 1 ,charmm);}

    icount = fread(&record,sizeof(int), 1 ,charmm);
    icount = fread(tax,sizeof(float),nfreat,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    icount = fread(&record,sizeof(int), 1 ,charmm);
    icount = fread(tay,sizeof(float),nfreat,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    icount = fread(&record,sizeof(int), 1 ,charmm);
    icount = fread(taz,sizeof(float),nfreat,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);
    
/* put new values in */
    for(i = 0 ; i < nfreat; i++) {
       coordx[jumps + free_alist.free_atom_list[i] - 1] = tax[i];
        coordy[jumps + free_alist.free_atom_list[i] - 1] = tay[i];
         coordz[jumps + free_alist.free_atom_list[i] - 1] = taz[i];}

    }
    else {

    if(qcrys) {
      icount = fread(&record,sizeof(int), 1 ,charmm);
       icount = fread(ShapeIndex.xtlabc,sizeof(double),6,charmm);
        icount = fread(&record,sizeof(int), 1 ,charmm);}

    icount = fread(&record,sizeof(int), 1 ,charmm);
    icount = fread(&coordx[read_loop*natom],sizeof(float),natom,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    icount = fread(&record,sizeof(int), 1 ,charmm);
    icount = fread(&coordy[read_loop*natom],sizeof(float),natom,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    icount = fread(&record,sizeof(int), 1 ,charmm);
    icount = fread(&coordz[read_loop*natom],sizeof(float),natom,charmm);
    icount = fread(&record,sizeof(int), 1 ,charmm);

    }
#endif

        if(JumpLen) {
           if(fseek(charmm , JumpLen * MemLen , SEEK_CUR)) {
              PrintMessage("?ERROR - can't retrieve frame");
              if(icntrl[8]) {
                free(tax);
                 free(tay);
                  free(taz);}
              return(-1);}}

    read_loop++;
  }
/*                                  */
    if(icntrl[8]) {
      free(tax);
       free(tay);
        free(taz);}

    fclose(charmm);
    return(0);
}

#ifdef sgi


/*************************************************************************/
int test_queue(UpdateScreen)   /* test the event queue  */
    int UpdateScreen;
/*************************************************************************/
{

/* just for the reference 
   static int dev,xval,yval; */

     static   int oldx,oldy;
     static   short dx,dy;
     static   int out;
     static float ddx,ddy;
     static int do_it,loop;
     static long Qentry;
     static short Qbuffer[QUEUE_LEN];
     static long  OldWinId;

     out   = 0;

       (void)UpdateAllOpenWindows();

       if(qtest()) {   /* -- 1 -- */

       out = 2;
       do_it = 0;

     Qentry = blkqread(Qbuffer,QUEUE_LEN);

/*       dev = qread(&val); */

     for(loop = 0 ; loop < Qentry ; loop += 2) {
         dev = (int)Qbuffer[loop];
          val =     Qbuffer[loop+1];

/* don't hook on these */
/*       if(dev == LEFTMOUSE || dev == MIDDLEMOUSE) continue; */


         if(dev == REDRAW) {
          if(WhichWindowToUpdate((int) val)) {
             PrintMessage("?ERROR - screwed up the window control");}
         reshapeviewport();
         do_it = 1;}

         else if (dev == WINSHUT) 
                   HandleWinShut((long)val);

         else if (dev == INPUTCHANGE) {
                   if(HandleInputChange((int)val))
                     PrintMessage("?ERROR - in handling of input change");
		 }
       else if(dev == MOUSEX) {
 
               oldx = xval;
               xval = (int)val;
               dx   = (short)(oldx-xval);

       if(!dx) continue;

           if(getbutton(LEFTMOUSE)) { /* leftmouse case */ 
              if(getbutton(MIDDLEMOUSE)) {
               ddx= Rabs((float)xval/((float) oldx));
                scale(ddx , ddx , ddx);
                 do_it = 1;
                  out = -1;
                   continue;}

              if(z_clip || getbutton(PAD2)) {
               TRANSLATE( 0.0 , 0.0 , (((float)dx) * damp) );
                do_it = 1;
                 out = -1;}

              if(y_clip || getbutton(PAD8)) {
               TRANSLATE( 0.0 , (((float)dx) * damp) , 0.0 );
                do_it = 1;
                 out = -1;}

              if(x_clip || getbutton(PAD6)) {
               TRANSLATE((((float)dx) * damp) , 0.0 , 0.0);
                do_it = 1;
                 out = -1;}

                ROTATE( -dx ,'y');
                  out = -1;
                  do_it = 1;}

            if(getbutton(MIDDLEMOUSE)) { /* middle mouse case */
               ROTATE( dx , 'z');
                do_it = 1;
                 out = -1;}

            }

          else if(dev == MOUSEY) {

            oldy = yval;
            yval = (int)val;
            dy   = (short)(oldy-yval);

          if(!dy) continue;

           if(getbutton(LEFTMOUSE)) { /*leftmouse case */ 
              if(getbutton(MIDDLEMOUSE)) {
/*
               ddy= Rabs((float)yval/((float) oldy));
                scale(ddy , ddy , ddy);
                 do_it = 1;
*/
                  continue;}

              ROTATE( dy  ,'x');
               do_it = 1;
                out = -1;}

           if(getbutton(MIDDLEMOUSE)) {
              ROTATE( dy , 'z');
               do_it = 1;
                out = -1;}

           }

       else if(dev == UPARROWKEY) {
               if(!val) continue;
          qreset(); 
          return(8);}

       else if(dev == DOWNARROWKEY) {
               if(!val) continue;
          qreset(); 
          return(9);}

       else if(dev == ESCKEY) {
          qreset();
          return(1);}

       else if(dev == QKEY) {
          qreset(); 
          return(1);}

       else if( dev == FKEY) {
          qreset(); 
          return(10);} /* specify a frame */

       else if(dev == RKEY) {
             qreset();
             return(1);}

       else if(dev == MENUBUTTON) 
	  { /* menubutton */
            menuval = dopup(menu_dyn);

            switch(menuval) {

            case 1:   return(1);

            case 2:   return(3);

            case 6:   make_shell();
                      bang_it();
                      break;

            case 8:   move_obj(1);
                      bang_it();
                      break;

            case 9:   center_obj(1);
                      bang_it();
                      break;

            case 11:  disp_zone(4); 
                      bang_it();
                      break;

            case 14:  if(BOX == 0) BOX=1;
                      else
                      BOX=0;
                      bang_it();
                      break;
   
            case 18:  if(z_clip == 0) z_clip = 1;
                      else
                      z_clip = 0;
                      break;

            case 26:  if(y_clip == 0) y_clip = 1;
                      else
                      y_clip = 0;
                      break;

            case 27:  if(x_clip == 0) x_clip = 1;
                      else
                      x_clip = 0;
                      break;

            case 28: /* turn all translates off */
                      z_clip = 0;
                      y_clip = 0;
                      x_clip = 0;
                      break;

            case 17:  /*  reset picture */ 
                      mmode(MVIEWING);
                      MakeOrtho();
                      damp = 1.0;
                      reshapeviewport();
                      DoSanitary();
                       bang_it();
                      ScareSwapbuffers(); 
                      break;

            case 19:  /* make hardcopy */
                      hardcopy("\0");
                      bang_it();
                      break;

            case 111: disp_zone(1); 
                      bang_it();
                      break;

            case 112: disp_zone(2); 
                      bang_it();
                      break;

            case 113: disp_zone(3); 
                      bang_it();
                      break;

            case 114: disp_zone(5);
                      bang_it();
                      break;

            case 115: disp_zone(6);
                      bang_it();
                      break;

            case 21:  colour_zone(1);
                      bang_it() ;
                      break;

            case 22:  colour_zone(2);
                      bang_it() ;
                      break;

            case 23:  colour_zone(3); 
                      bang_it() ;
                      break;

            case 24:  Alpha_Blend(); 
                      def_simple_light_calc();
                      use_simple_light_calc();
                      blendfunction(BF_SA, BF_ONE);
                      bang_it() ;
                      break;

            case 25:  in_water(); 
                      bang_it() ;
                      break;

            case 38:  /* colour by atomic charges           */
                      color_by_charge(0);
                      bang_it();
                      break;

            case 39:  if(draw_obj_disp == 0) draw_obj_disp = 1;
                      else 
                      draw_obj_disp = 0;
                      c3s(bgcolor);
                      clear();
                      zclear();
                      bang_it();
                      break;

            case 600:  identify(1);break;

            case 601:  identify(2);break;

            case  31:  distance();break;

            case  32: mangle(); break;

            case  33: mtorsion(); break; 

            case 13:  yn_surf = 1;
                      SURFACE_DEF();
                      bang_it();
                      break;

            case 211: surface_zone(1); 
                      yn_surf=1;
                      SURFACE_DEF();
                      bang_it();
                      break;

            case 212: surface_zone(2); 
                      yn_surf=1;
                      SURFACE_DEF();
                      bang_it();
                      break;

            case 213: surface_zone(3);
                      yn_surf=1;
                      SURFACE_DEF();
                      bang_it();
                      break;

            case 411: surface_zone(4);
                      yn_surf=1;
                      SURFACE_DEF();
                      bang_it();
                      break;

            case 412: surface_zone(5);
                      yn_surf=1;
                      SURFACE_DEF();
                      bang_it();
                      break;

            case 215: yn_surf=0; 
                      bang_it();
                      break;

            case 500: surf_style=0;
                      bang_it();
            PrintMessage(" ===> Surface is drawn as van der Waals spheres");
                      break;

            case 501: surf_style=1;
                      bang_it();
            PrintMessage(" ===> Surface is drawn as covalent radius spheres");
                      break;

            case 502: if(liq_surf == 0) liq_surf=1;
                      else liq_surf=0;
                      bang_it();
                      break;

       case 700: 
                 PrintMessage("Sorry but you are already doing dynamics");
                 printf("\07\07\n");
                 break;

       case 715: 
                 if(!play_dynam_frames.obs_vec_len) {
                    PrintMessage("?ERROR - no 2D display defined");
                    break;}
                 if(disp_obj[0] == 0) disp_obj[0] = 1;
                 else
                 disp_obj[0] = 0;
                 break;

            case 716: colour_util(1); /* define background colour */
                      bang_it();
                      break;

            case 717: colour_util(2); /* define text colour  */
                      bang_it();
                      break;

            case 718: colour_util(3); /* define object colour */
                      bang_it();
                      break;

            case 719: def_frame_freq();
                      break;

            case 801: /* specify a new frame */
                        return(10);

            case 900:   return(5);

            case 901:   return(6);

            case 902:   return(7);

            case 903:   return(4);

            case  5:    shut_down(0); }}


    if(do_it && UpdateScreen) {
       bang_it();
        do_it = 0;}
   }}                     /* -- 1 -- */
    
    return(out);
}
/************************************************************************/
Send_put_text(XC , YC , String)
      float XC;
      float YC;
      char  String[];
/************************************************************************/
{
      if(String[0] != '\0') {
         Text_Disp.Display = 1;
         Text_Disp.XC = XC;
         Text_Disp.YC = YC;
          strncpy(Text_Disp.TString , String , BUFF_LEN);}
       else {
         Text_Disp.Display = 0;}
}
/************************************************************************/
put_text()  /* display text string */
/************************************************************************/
{

   static int retv;

      Text_Disp.Display = 0;   /* default always off */

      retv = show_text(Text_Disp.TString ,
                       txt_param.txfont,txt_param.txcolor,
                       txt_param.txtsize,
                       Text_Disp.XC , 
                       Text_Disp.YC , BACKBUFFER);
}

#endif

/*************************************************************************/
get_space()     /* reserve the needed amount of memory */
/*************************************************************************/
{
     extern char *atnam_stack;
     extern char *resnam_stack;
     extern char *segment_stack;
     extern int atnam_stack_max;
     extern int resnam_stack_max;
     extern int segment_stack_max;
     extern int *atnam_stack_num;
     extern int *resnam_stack_num;

     int i;

#ifdef DEBUG
     printf("\nGetting space...\n");
#endif

/*   Go and get the space needed for the arrays ... */

/* most of these reflects the parameters in a CHARMM type file */

     x = vector(MAXatom);
     y = vector(MAXatom);
     z = vector(MAXatom);

     bvalue = vector(MAXatom);  /* can be used as the partial charges */

     res1 = ivector(MAXatom);
     res2 = ivector(MAXatom);
   
     resnam = cvector(MAX_RES_NAME_LEN * MAXatom);
     atnam  = cvector(MAX_ATM_NAME_LEN * MAXatom);
     segment= cvector(MAX_SEG_NAME_LEN * MAXatom);

/* end of charmm file parameters                                */

/* alpha carbon parameters                                      */
     ca_list      = ivector(MAXatom);
     ca_disp_list = cvector(MAXatom);
/* general display parameters                                   */
     disp_list    = cvector(MAXatom);
     gap_vec      = cvector(MAXatom);
/* generate label list                                          */
     label_list   = cvector(MAXatom);

/* build atom colour array                                      */
     atmcol = (int **) malloc(MAXatom*sizeof(int *));
     for( i = 0 ; i < MAXatom ; i++) 
          atmcol[i] = (int *) malloc( 3 * sizeof(int));
     if(atmcol == NULL) {
     PrintMessage("** ERROR. Allocation failure for atmcol");
     shut_down (1); }
/* end of atom colour                                           */

/* build atom connection array                                  */
     cnct  = (int **) malloc(MAXatom*sizeof(int *));
     for( i = 0 ; i < MAXatom ; i++ )
           cnct[i]= (int *) malloc((MAXconn+1)*sizeof(int));
     if(cnct == NULL) {
     PrintMessage("** ERROR. Allocation failure for cnct");
     shut_down (1); }
/* end of atom connection                                       */

/* covalent radius list                                         */
     corad = vector(MAXatom);
      if(corad == NULL) {
       PrintMessage("** ERROR. Allocation failure for corad");
        shut_down (1); }

/* vdW radius list                                              */
     vdw_list = vector(MAXatom);
      if(vdw_list == NULL) {
        PrintMessage("** ERROR. Allocation failure for vdw_list");
        shut_down (1); } /* end */

/* switch for atom surface                                      */
      surface_list = cvector(MAXatom);
       if(surface_list == NULL ) {
         PrintMessage("** ERROR. Allocation failure for surface_list");
         shut_down(1); }  /* end */

/* switch for atom liquorice                                    */
      liquorice_list = cvector(MAXatom);
        if(liquorice_list == NULL ) {
          PrintMessage("** ERROR. Allocation failure for liquorice_list");
          shut_down(1); }  /* end */

      trax = vector(MAXobjects);
      tray = vector(MAXobjects);
      traz = vector(MAXobjects);
      if(trax == NULL || tray == NULL || traz == NULL) {
      PrintMessage("** ERROR. Allocation failure for trax, tray or traz");}

/* atnam, resnam and segment name stacks       */

      atnam_stack = cvector(MAX_ATM_NAME_LEN       * atnam_stack_max);
       atnam_stack_num = ivector(atnam_stack_max);
        resnam_stack_num = ivector(resnam_stack_max);
         resnam_stack = cvector(MAX_RES_NAME_LEN   * resnam_stack_max);
          segment_stack = cvector(MAX_SEG_NAME_LEN * segment_stack_max);

/* atom charge list                                 */

      atm_charge = vector(MAXatom);

/* atom type list                                   */

      atm_type   = ivector(MAXatom);

/* cpk scale list                                   */

      cpk_scale = vector(MAXatom);

/* reset trajectory info                            */
   (void)DeleteTrajectoryInfo();

#ifdef DEBUG
   printf("Returning now from get_space ... \n");
#endif

}
/**************************************************************************/
shut_down(alt)    /* last routine before the end */
/**************************************************************************/
   int alt;
{
   int SaveOk;

   extern int term_type;

   get_date(2);

   if(!LogFile.ok) CloseLogFile();

   SaveOk = SaveCommandStack();

   exit(alt);
}
/**************************************************************************/
man_coordinates(alt)    /* put the coordinates aside */
   int alt;
/**************************************************************************/
{
   int i;
   int atom_max;

   switch(alt) {

   case 1:     /* grab space and put x,y and z to a safe place */

   xsave = vector(mliste[mlist_deep - 1]);
   ysave = vector(mliste[mlist_deep - 1]);
   zsave = vector(mliste[mlist_deep - 1]);

   for(i = mlists[0] ; i <  mliste[mlist_deep - 1] ; i++) {
    xsave[i] = x[i];
    ysave[i] = y[i];
    zsave[i] = z[i]; }
   coord_save = 1;   /* put the switch on */
   break;

   case 2:   /* the safe place is not needed put x,y and z back and
                free the space */

   for(i = mlists[0] ; i <  mliste[mlist_deep - 1] ; i++) {
    x[i] = xsave[i];
    y[i] = ysave[i];
    z[i] = zsave[i]; }

   free(xsave);
    free(ysave);
     free(zsave);
   coord_save = 0;   /* put the switch off */
   break;

   default:
   printf(" \007\007\n");
   PrintMessage("**** ERROR in man_coordinates ***");
   exit(1);
   }

}

#ifdef sgi

/**************************************************************************/
void print_obj()   /* this function handles the display of the objects */
/**************************************************************************/
{
   extern int term_type;

   if(term_type != 1 || yes_no_graph == 0) return;

   if(text_port) print_text();
   if(text_bottom) going_on(); 
}
/***********************************************************************/
center_obj(alt)    /* center the object */
  int alt;
/***********************************************************************/
{
      static int xsiz,ysiz,xo,yo,i,j;
      static float xx,yy,xtr,ytr,ztr,tmp1,tmp2;
      static float ddx,ddy,ddz;
      float diffs;
      char text[BUFF_LEN];
      float RotT[4][4];

      diffs = far - near;

      getmatrix(xycoor);
       mmode(MPROJECTION); 
        getmatrix(RotT);
         multmatrix(xycoor);
        getmatrix(xycoor);
       loadmatrix(RotT);
      mmode(MVIEWING);

      PrintMessage("Pick one atom for the new centre ");  
      text_port = 1;

      while(1) {

        while(qtest()) {

          dev=qread(&val);

            if(dev == ESCKEY) {
            shut_down(0); }

            else if(dev == EKEY) {
            text_port = 0;
            qreset();
            return; }

            else if(dev == REDRAW) {
            reshapeviewport();
            bang_it();
            }


            else if(dev == MENUBUTTON) {
            menuval = dopup(identmenu);
            switch( menuval) {
            case 1:
            text_port = 0;
            return;break;
            case 2:
            shut_down(0);
            case 3:
            if(text_port ==0) text_port = 1;
            else
            text_port =0;
            bang_it();
            break;}
            }

            else if(dev == LEFTMOUSE && val) {
            xc=getvaluator(MOUSEX);
            yc=getvaluator(MOUSEY);
            
   /* Reset queue                              */

            qreset();

            getsize(&xsiz,&ysiz);
            getorigin(&xo,&yo);
/*
            xx=minx + (maxx-minx)*((float)(xc+1-xo)/ (float) xsiz);
            yy=miny + (maxy-miny)*((float)(yc+1-yo)/ (float) ysiz);
*/  

            xx=near + diffs*((float)(xc+1-xo)/ (float) xsiz);
            yy=near + diffs*((float)(yc+1-yo)/ (float) ysiz);

            for( i = 0 ; i < mliste[mlist_deep - 1] ; i++) {
    
    
     xtr= 0.5 * diffs * (xycoor[0][0]*x[i]+xycoor[1][0]*y[i]+
          xycoor[2][0]*z[i]+xycoor[3][0]-rotB[3][0]);
     ytr= 0.5 * diffs * (xycoor[0][1]*x[i]+xycoor[1][1]*y[i]+
          xycoor[2][1]*z[i]+xycoor[3][1]-rotB[3][1]);
     ztr= 0.5 * diffs * (xycoor[0][2]*x[i]+xycoor[1][2]*y[i]+
          xycoor[2][2]*z[i]+xycoor[3][2]-rotB[3][2]);
  
/*
           if(i == 220) {
           printf(" xtr %f ytr %f xx %f yy %f \n",xtr,ytr,xx,yy);
           printf(" xtr1 %f ytr1 %f\n",0.5*diffs*(rotB[3][0]-xycoor[3][0]),
           0.5*diffs*(rotB[3][1]-xycoor[3][1]));}
*/

           tmp1 = (xx-xtr);
           tmp2 = (yy-ytr);

             if((tmp1 * tmp1 + tmp2 * tmp2) < HitSphere2 ) {

             switch(alt) {

             case 1:

sprintf(text," (%d:%.4s:%.4s) ",GetResNum1(i),GetAtmName(i),GetResName(i));
PrintMessage(text);
bang_it();

/*  new centre is this point i */
/*
      sumx = x[i];
       sumy = y[i];
        sumz = z[i];

      for(j=0 ; j < mliste[0] ; j++) {
       x[j] = x[j] - sumx;
        y[j] = y[j] - sumy;
         z[j] = z[j] - sumz; }
*/

      TRANSLATE( -xtr , -ytr , -ztr);

             text_port = 0;  /* put text port off */
             return;
             break;

             case 2:
             break;
                  }

              break; }
            }
            qreset();
            }
         }
       }
}

#endif

/************************************************************************/
int own_parser(text,tokens,k,searchs)

        char *text;
        char tokens[][MAXlinel];
        int *k;
        char *searchs;
/************************************************************************/
{

        char *find;
        char save_text[MAXlinel];
        static int i,kill;

        ParseInfo.Return = 0; /* always OK return (this is not used yet) */

/* delete first the old information      */
        for(i = 0 ; i < MAXparse ; i++) {
        tokens[i][0] = '\0';}
        *k=0;
/* check first to see if this is a comment line */
        if(text[0] == '#') {
         ParseInfo.num = 0;
          return (-1);} /* yes it is a comment */
/* go and hunt for the '#' marks         */
        kill = 0;
        if(text[0] == '\10') return(0);
        for(i=0 ; i < strlen(text) ; i++) {
          if(text[i] == '#') {
            kill = i;
            break;
          }
        }

        if(kill > 0) {
          for(i = kill ; i < strlen(text) ; i++) text[i] = '\0';
        }
/* save first the string                 */
        strcpy(save_text,text);
/* look into the string for tokens       */
        find = STRTOK(save_text,searchs);
/* if nothing to retrieve => return      */
        *k=0;
        if(find == NULL)  {
         ParseInfo.num = 0;
          return(0);}
/* put the found string into the work array */
        strncpy(tokens[0],find,MAXlinel);
        (*k)++;
/* hunt for more tokens ...              */
        for(;;) {
         find = STRTOK(NULL,searchs);
         if(find == NULL) break;
/* is there something more ...           */
         strcpy(tokens[*k],find);
         (*k)++;
        }
/* ready to return with things I have found ...   */
        for(i = 0 ; i < *k ; i++) 
            ParseInfo.Point[i] = parsed[i];
        ParseInfo.num = *k;
        return(0);
}
         
#ifdef sgi

/***********************************************************************/
void plot_cpk()  /* plot molecule as cpk spheres */
/***********************************************************************/
{

   register int i,j,k,jj;
   register float rad_div;
   static int l,nn,ii,im1;
   static float light_rot[3][4],vec[6],rad;
   static float n0[3],rad_old;
   static float diffs,xtr=0.0,ytr=0.0,ztr=1.0;
   static float xk,yk,zk;
   static float *vspher_run;
   static int from,to;
   static int in_blend = 0;
   static float param[4];
   static int SayCol[3] = {255 , 0 , 0};


/* change cursor ...    */
   setcursor(CURS_TYPE);
/* show some text */
   if(DBuffer.BufferMode == 2 && !video_mode)
      k = show_text("Working ...","Helvetica",SayCol,15.,0.8,0.9,FRONTBUFFER);

   from = 0;
   to   = mliste[mlist_deep - 1];

   rad=0.0;

   nn = sphere_seg;

#ifndef FAST
   build_array();
#endif

   backface(TRUE); /* put backface on */

   in_blend = 0;
/*
     if(material[9] < 1.0) {
     backface(FALSE); 
     in_blend = 1;
     blendfunction(BF_SA, BF_ONE);}
*/

  for(k = from ; k < to ; k++) {

  xk = x[k];
   yk = y[k];
    zk = z[k];

  if(disp_list[k] != 1) continue;  /* check if the atom should be displayed */

  if(surface_list[k] !=1) continue; /* check if there should be a surface */

   CHANGE_COLOR(k);

   rad_old = rad;

   if(surf_style == 0) rad = vdw_list[k] * cpk_scale[k];
   if(surf_style == 1) rad = corad[k] * cpk_scale[k];

#ifdef FAST

   param[0] = xk;
    param[1] = yk;
     param[2] = zk;
      param[3] = rad;

   if(sphdraw(param) < 0) {
     PrintMessage("?ERROR - error in sphdraw ");
     return;}

#else

   if(rad_old != rad)
   build_sphere( nn , rad);

   rad_div = 1.0 / rad;

   for(i = 1 ; i < nn ; i++) {

    ii = sphere_array[i];
     im1 = sphere_array[i-1];

    for(j = 1 ; j <= 2*nn ; j++) {

    vspher_run = vspher[0];

    bgnpolygon();

    jj = j+im1-1;
    *vspher_run++ = xk+vsphe[jj][0];
    *vspher_run++ = yk+vsphe[jj][1];
    *vspher_run++ = zk+vsphe[jj][2];

    n0[0]=vsphe[jj][0] * rad_div ;
    n0[1]=vsphe[jj][1] * rad_div ;
    n0[2]=vsphe[jj][2] * rad_div ;

    n3f(n0); v3f(vspher[0]);

    ++jj;
    *vspher_run++ = xk+vsphe[jj][0];
    *vspher_run++ = yk+vsphe[jj][1];
    *vspher_run++ = zk+vsphe[jj][2];

    n0[0]=vsphe[jj][0] * rad_div ;
    n0[1]=vsphe[jj][1] * rad_div ;
    n0[2]=vsphe[jj][2] * rad_div ;

    n3f(n0); v3f(vspher[1]);

    jj = j+ii;
    *vspher_run++ = xk+vsphe[jj][0];
    *vspher_run++ = yk+vsphe[jj][1];
    *vspher_run++ = zk+vsphe[jj][2];

    n0[0]=vsphe[jj][0] * rad_div ;
    n0[1]=vsphe[jj][1] * rad_div ;
    n0[2]=vsphe[jj][2] * rad_div ;

    n3f(n0); v3f(vspher[2]);

    --jj;
    *vspher_run++ = xk+vsphe[jj][0];
    *vspher_run++ = yk+vsphe[jj][1];
    *vspher_run   = zk+vsphe[jj][2];

    n0[0]=vsphe[jj][0] * rad_div ;
    n0[1]=vsphe[jj][1] * rad_div ;
    n0[2]=vsphe[jj][2] * rad_div ;

    n3f(n0); v3f(vspher[3]);
    endpolygon();  }}

#endif

} 

    if(in_blend) {
     blendfunction(BF_ONE, BF_ZERO);
   }
    
    backface(FALSE);

/* change cursor back ...    */
   setcursor(0);
    
}

#endif

/***********************************************************************/
void bang_it()  /* bang the stuff on the screen */   
/***********************************************************************/
{

  extern int term_type;
  extern int display_text;
  extern int calc_neigh;
  extern int video_dev;
  extern int frame_count;
  extern int trace_wind;


#ifdef sgi
  static int first_frame=TRUE;
#endif


#ifdef sgi
  if(term_type == 2) {
    PrintMessage("?ERROR - I don't know how to do it on a vt100 terminal");
    return;}

/* do first the sanitary stuff ... */
     DoSanitary();

     if(StereoPlot.Active) {
        PlotStereo();}
     else {
       draw_obj(); 
       draw_other_stuff();}

     winset(GetMainWindowID());

       WUpdate.MainW   = 0;
       WUpdate.LDPW    = 0;
       WUpdate.Rama    = 0;
       WUpdate.Cluster = 0;


#ifdef VIDEO_SCARE

  switch(video_dev) {

  case 0:  /* tape device */

  if( video_mode == 0 ) {
  ScareSwapbuffers();
  return;}

  if(first_frame)
  {
  frame_count++;
  update_video_log(frame_count);
    ScareSwapbuffers();
    minivas_record(FALSE,1);
    first_frame=FALSE;
    return;
  }
  if(!minivas_waitrec(5))
  {
    PrintMessage("minivas recorder didn't lock! sorry!");
    shut_down(1);
  }
  frame_count++;
  update_video_log(frame_count);
  ScareSwapbuffers();
  minivas_record(FALSE,1);
  break;

  case 1:  /* CD device */
  frame_count++;
  update_video_log(frame_count);
  ScareSwapbuffers();
/*
  W A R N I N G !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  This is a local command and will most likely not work 
  on other machines or nodes.

  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*/
  system("laser -r");
  break;

  default: /* error */
          PrintMessage("?ERROR - wrong video output device defined ");
          shut_down(1);
  } 
#else 
  ScareSwapbuffers();
#endif

#else
 
   PrintMessage("?ERROR - not implemented on this device ");

#endif
}
/**************************************************************************/
OpenLogFile()
/**************************************************************************/
{
    strncpy(LogFile.file,LOGFILE,strlen(LOGFILE));
    
    LogFile.lines = 0;

    if(LogFile.ok) return;  /* don't use log file */

    LogFile.log_p = fopen(LogFile.file,"w");

    if(LogFile.log_p == NULL) {
      PrintMessage("?ERROR - can't open log file ");
      LogFile.ok = 1;}
}
/**************************************************************************/
WriteToLogFile(text)
   char *text;
/**************************************************************************/
{
     if(LogFile.ok) return;  /* don't write to log file */
     fprintf(LogFile.log_p,"%s\n",text);
     fflush(LogFile.log_p);
}
/**************************************************************************/
CloseLogFile()
/**************************************************************************/
{
   fclose(LogFile.log_p);
}
/**************************************************************************/
tell_window_size()
/**************************************************************************/
{
   long xpix,ypix;
   long Xorig,Yorig;
   char OutText[BUFF_LEN];

         getsize(&xpix,&ypix);
         getorigin(&Xorig,&Yorig);
         sprintf(OutText,"Window is now at: (%d,%d) and '%d' * '%d' pixels",
                 Xorig,Yorig,xpix,ypix);
         PrintMessage(OutText);
}

#if defined(sgi)
/***********************************************************************/
identify(alt)    /* identify an atom */
  int alt;
/***********************************************************************/
{
      extern int *atm_type;
      extern float *atm_charge;

     register int oldx,oldy;
     register short dx,dy;

      static int xsiz,ysiz,xo,yo,i,j;
      static int DisplayFlag;
      static float xx,yy,xtr,ytr;
      static float ddx,ddy,ddz,tmp1,tmp2;
      float diffs;
      char text[BUFF_LEN];
      float RotT[4][4];
      int Picks;
       float Cpicks[6];

      diffs = far - near;

      Picks = 0;
      for(i = 0 ; i < 6 ; i++) Cpicks[i] = 0.0;

      PrintMessage(" >>>>>> PRESS e-key to return from IDENTIFY facility <<<<<< \n");

      text_port = 1;  /* display text from now */

      strncpy(bottom_line,"Pick an atom.",PORTchar);
      going_on();

      while(1) {

      DisplayFlag = 0;

        while(qtest()) {

          dev=qread(&val);

          switch(dev) {              /* main switch board */

                      case ESCKEY:
                        shut_down(0); 

		      case EKEY: 
                        text_port = 0;
                         qreset();
                        return; 

		      case REDRAW:
                        DisplayFlag = 1;
                        reshapeviewport();
                        break;

		      case MENUBUTTON:
                       { menuval = dopup(identmenu);
                           switch( menuval) {
                           case 1:
                           text_port = 0;
                            qreset();
                           return;break;
                           case 2:
                           shut_down(0);
                           case 3:
                           if(text_port ==0) text_port = 1;
                           else
                           text_port =0;
                           DisplayFlag = 1;
                           break;}}
                        break;

/* track MOUSEX                         */
		      case MOUSEX:
                        oldx=xval;
                         xval=val;
                          dx= oldx-xval;
                      
                       if(getbutton(LEFTMOUSE)) {
                        if(getbutton(MIDDLEMOUSE)) {
                        ddx=Rabs((float) xval/((float) oldx));
                        DisplayFlag = 0;
                        scale(ddx , ddx , ddx);
                        qreset();
                        bang_it(); break;}

                        if(getbutton(PAD2)) {
                        DisplayFlag = 0;
                          qreset();
                          TRANSLATE( 0.0 , 0.0 , (((float)dx) * damp) );
                           bang_it(); break;}

                        if(getbutton(PAD8)) {
                        DisplayFlag = 0;
                           qreset();
                           TRANSLATE( 0.0 , (((float)dx) * damp) , 0.0 );
                            bang_it(); break;}

                        if(getbutton(PAD6)) {
                        DisplayFlag = 0;
                            qreset();
                            TRANSLATE( (((float)dx) * damp) , 0.0 , 0.0);
                             bang_it(); break;}

                          ROTATE( -dx ,'y');
                           DisplayFlag = 1;}

                        if(getbutton(MIDDLEMOUSE)) {
                          ROTATE( dx , 'z');
                           DisplayFlag = 1;}

                       break;

/* track MOUSEY                         */
		      case MOUSEY:
                        oldy=yval;
                         yval=val;
                          dy= oldy-yval;

                        if(getbutton(LEFTMOUSE)) {
                         if(getbutton(MIDDLEMOUSE)) {
                         ddy=Rabs((float) yval/((float) oldy));
                         DisplayFlag = 0;
                         scale(ddy , ddy , ddy);
                         qreset();
                         bang_it(); break;}

                           ROTATE(  dy ,'x');
                            DisplayFlag = 1;}

		         if(getbutton(MIDDLEMOUSE)) {
                           ROTATE( dy , 'z');
                            DisplayFlag = 1;}
                       break;

		    case LEFTMOUSE:
                       { if(!val) break;
                          xc=getvaluator(MOUSEX);
                          yc=getvaluator(MOUSEY);
            
                          getmatrix(xycoor);
                           mmode(MPROJECTION); 
                            getmatrix(RotT);
                             multmatrix(xycoor);
                            getmatrix(xycoor);
                           loadmatrix(RotT);
                           mmode(MVIEWING);

                         /* Reset queue                              */
                          qreset();

                          getsize(&xsiz,&ysiz);
                          getorigin(&xo,&yo);

            xx=near + diffs*((float)(xc+1-xo)/ (float) xsiz);
            yy=near + diffs*((float)(yc+1-yo)/ (float) ysiz);


            for( j = 0 ; j < mlist_deep ; j++) {
            for( i = mlists[j] ; i < mliste[j] ; i++) {
    
/* don't count undisplayed atoms (disp_list[i] = 0)      */
            if(disp_list[i] == 0) continue;



     xtr= 0.5 * diffs * (xycoor[0][0]*x[i]+xycoor[1][0]*y[i]+
          xycoor[2][0]*z[i]+xycoor[3][0]-rotB[3][0]);
     ytr= 0.5 * diffs * (xycoor[0][1]*x[i]+xycoor[1][1]*y[i]+
          xycoor[2][1]*z[i]+xycoor[3][1]-rotB[3][1]);

/*
           printf(" xtr %f ytr %f xx %f yy %f \n",xtr,ytr,xx,yy);
*/
           tmp1 = (xx-xtr);
           tmp2 = (yy-ytr);

             if((tmp1 * tmp1 + tmp2 * tmp2) < HitSphere2 ) {

             {switch(alt) {

             case 1:
             sprintf(text," %.4s:%.4s(%d):%.4s(%d)",
                                                GetSegName(i),
                                                GetResName(i),
                                                GetResNum1(i),
                                                GetAtmName(i),
                                                (i+1));
             PrintMessage(text);
             sprintf(text," File: %s",mnlist[j]);
             PrintMessage(text);

             bang_it();
             break;

             case 2:
             sprintf(text," Atom nr: %d , residue nr: %d ,  atom name: %.4s , residue name: %.4s,",
             i+1,GetResNum1(i),GetAtmName(i),GetResName(i));
             PrintMessage(text);
             sprintf(text," segment name : %.4s ",GetSegName(i));
             PrintMessage(text);
             sprintf(text," atom type: %d (%.4s)",atm_type[i],find_atype(atm_type[i]));
             PrintMessage(text);
             sprintf(text," atom charge: %5.3f",atm_charge[i]);
             PrintMessage(text);
             sprintf(text," x : %f y: %f z: %f ",x[i]+sumx,
                                                   y[i]+sumy,
                                                   z[i]+sumz);
             PrintMessage(text);
             sprintf(text," File: %s",mnlist[j]);
             PrintMessage(text);

/*             Handle_Picks(i,Picks,Cpicks); */

             DisplayFlag = 1;
              Picks++;
             break;
	   }}}
            }}
            break;
		       }}
	  } 
            if(DisplayFlag) {
              DisplayFlag = 0;
              bang_it();}
    }
}


/***********************************************************************/
distance()   /* calculate a distance */
/***********************************************************************/
{
      extern int *atm_type;
      extern float *atm_charge;

     register int oldx,oldy;
     register short dx,dy;

      static int xsiz,ysiz,xo,yo,i,j;
      static int DisplayFlag;
      static int pick_p,pick_num,repeat;
      static float xx,yy,xtr,ytr,dist;
      static float ddx,ddy,ddz,tmp1,tmp2;
      float diffs;
      char text[BUFF_LEN];
      float RotT[4][4];
      char TRes[MAX_RES_NAME_LEN],TAtm[MAX_ATM_NAME_LEN];

      diffs = far - near;
  
      PrintMessage(" >>>>>> PRESS e-key to return from DISTANCE facility <<<<<< \n");

      text_port = 1;  /* display text from now */

      strncpy(bottom_line,"Pick two atoms for a distance",PORTchar);

      going_on();

      pick_p=0;   /* reset the pick */
      repeat = mliste[mlist_deep - 1] + 1;

      while(1) {

      DisplayFlag = 0;

        while(qtest()) {

          dev=qread(&val);

          switch(dev) {              /* main switch board */

                      case ESCKEY:
                        shut_down(0); 

		      case EKEY: 
                        qreset();
                        text_port = 0;
                        return; 

		      case REDRAW:
                        DisplayFlag = 1;
                        reshapeviewport();
                        break;

		      case MENUBUTTON:
                       { menuval = dopup(identmenu);
                           switch( menuval) {
                           case 1:
                           text_port = 0;
                           qreset();
                           return;break;
                           case 2:
                           shut_down(0);
                           case 3:
                           if(text_port ==0) text_port = 1;
                           else
                           text_port =0;
                           DisplayFlag = 1;
                           break;}}
                        break;

/* track MOUSEX                         */
		      case MOUSEX:
                        oldx=xval;
                         xval=val;
                          dx= oldx-xval;
                      
                       if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
                        ddx=Rabs((float) xval/((float) oldx));
                        DisplayFlag = 0;
                        scale(ddx , ddx , ddx);
                        qreset();
                        bang_it(); break;}

		        if(getbutton(LEFTMOUSE)) {
                         if(!val) break;
                          ROTATE( -dx ,'y');
                           DisplayFlag = 1;}

                        if(getbutton(MIDDLEMOUSE)) {
                         if(!val) break;
                          ROTATE( dx , 'z');
                           DisplayFlag = 1;}
                       break;

/* track MOUSEY                         */
		      case MOUSEY:
                        oldy=yval;
                         yval=val;
                          dy= oldy-yval;

                        if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
                         ddy=Rabs((float) yval/((float) oldy));
                         DisplayFlag = 0;
                         scale(ddy , ddy , ddy);
                         qreset();
                         bang_it(); break;}

		         if(getbutton(LEFTMOUSE)) {
                          if(!val) break;
                           ROTATE(  dy ,'x');
                            DisplayFlag = 1;}

		         if(getbutton(MIDDLEMOUSE)) {
                          if(!val) break;
                           ROTATE( dy , 'z');
                            DisplayFlag = 1;}
                       break;

		    case LEFTMOUSE:
                       { if(!val) break;
                          xc=getvaluator(MOUSEX);
                          yc=getvaluator(MOUSEY);
            
                          getmatrix(xycoor);
                           mmode(MPROJECTION); 
                            getmatrix(RotT);
                             multmatrix(xycoor);
                            getmatrix(xycoor);
                           loadmatrix(RotT);
                           mmode(MVIEWING);

                         /* Reset queue                              */
                          qreset();

                          getsize(&xsiz,&ysiz);
                          getorigin(&xo,&yo);

            xx=near + diffs*((float)(xc+1-xo)/ (float) xsiz);
            yy=near + diffs*((float)(yc+1-yo)/ (float) ysiz);


            for( j = 0 ; j < mlist_deep ; j++) {
            for( i = mlists[j] ; i < mliste[j] ; i++) {
    
/* don't count undisplayed atoms (disp_list[i] = 0)      */
            if(disp_list[i] == 0) continue;

     xtr= 0.5 * diffs * (xycoor[0][0]*x[i]+xycoor[1][0]*y[i]+
          xycoor[2][0]*z[i]+xycoor[3][0]-rotB[3][0]);
     ytr= 0.5 * diffs * (xycoor[0][1]*x[i]+xycoor[1][1]*y[i]+
          xycoor[2][1]*z[i]+xycoor[3][1]-rotB[3][1]);

           tmp1 = (xx-xtr);
           tmp2 = (yy-ytr);

             if((tmp1 * tmp1 + tmp2 * tmp2) < HitSphere2 ) {

             if( i == repeat) break;
             repeat = i;
/* hit ... */
             sprintf(text," (%d:%.4s:%.4s)(%d)",GetResNum1(i),
                                                GetAtmName(i),
                                                GetResName(i),
                                                (j+1));
             printf("\007\n");
             PrintMessage(text);

             DisplayFlag = 1;

             if(!pick_p) { pick_num=i ; pick_p++ ; goto PickExit;}

             dist = sqrt((x[pick_num]-x[i])*(x[pick_num]-x[i]) +
                         (y[pick_num]-y[i])*(y[pick_num]-y[i]) +
                         (z[pick_num]-z[i])*(z[pick_num]-z[i]));

             strncpy(TAtm,GetAtmName(pick_num),MAX_ATM_NAME_LEN);
             strncpy(TRes,GetResName(pick_num),MAX_RES_NAME_LEN);

             sprintf(text,"\n Distance %d_%.4s:%.4s - %d_%.4s:%.4s = %f \n\n",
                                                        GetResNum1(pick_num),
                                                        TAtm,
                                                        TRes,
                                                        GetResNum1(i),
                                                        GetAtmName(i),
                                                        GetResName(i),
                                                                 dist);
             PrintMessage(text);

             pick_p=0; qreset(); break;

	   }}}
PickExit:;
		       }
            break;
		      }
	  } 
            if(DisplayFlag) {
              DisplayFlag = 0;
              bang_it();}
    }
}

/***********************************************************************/
mangle()    /* measure bond angle */
/***********************************************************************/
{
      extern int *atm_type;
      extern float *atm_charge;

     register int oldx,oldy;
     register short dx,dy;

      static int xsiz,ysiz,xo,yo,i,j;
      static int DisplayFlag;
      static int pick_p,pick_num[2],repeat;
      static float xx,yy,xtr,ytr,angle;
      static float ddx,ddy,ddz,tmp1,tmp2;
      float diffs;
      char text[BUFF_LEN];
      float RotT[4][4];
      char TRes[MAX_RES_NAME_LEN],TAtm[MAX_ATM_NAME_LEN];
      char TRes1[MAX_RES_NAME_LEN],TAtm1[MAX_ATM_NAME_LEN];

      diffs = far - near;
  
      PrintMessage(" >>>>>> PRESS e-key to return from ANGLE facility <<<<<< \n");

      text_port = 1;  /* display text from now */

      strncpy(bottom_line,"Pick three atoms for an angle",PORTchar);

      going_on();

      pick_p=0;   /* reset the pick */
      repeat = mliste[mlist_deep - 1] + 1;

      while(1) {

      DisplayFlag = 0;

        while(qtest()) {

          dev=qread(&val);

          switch(dev) {              /* main switch board */

                      case ESCKEY:
                        shut_down(0); 

		      case EKEY: 
                        qreset();
                        text_port = 0;
                        return; 

		      case REDRAW:
                        DisplayFlag = 1;
                        reshapeviewport();
                        break;

		      case MENUBUTTON:
                       { menuval = dopup(identmenu);
                           switch( menuval) {
                           case 1:
                           text_port = 0;
                           qreset();
                           return;break;
                           case 2:
                           shut_down(0);
                           case 3:
                           if(text_port ==0) text_port = 1;
                           else
                           text_port =0;
                           DisplayFlag = 1;
                           break;}}
                        break;

/* track MOUSEX                         */
		      case MOUSEX:
                        oldx=xval;
                         xval=val;
                          dx= oldx-xval;
                      
                       if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
                        ddx=Rabs((float) xval/((float) oldx));
                        DisplayFlag = 0;
                        scale(ddx , ddx , ddx);
                        qreset();
                        bang_it(); break;}

		        if(getbutton(LEFTMOUSE)) {
                         if(!val) break;
                          ROTATE( -dx ,'y');
                           DisplayFlag = 1;}

                        if(getbutton(MIDDLEMOUSE)) {
                         if(!val) break;
                          ROTATE( dx , 'z');
                           DisplayFlag = 1;}
                       break;

/* track MOUSEY                         */
		      case MOUSEY:
                        oldy=yval;
                         yval=val;
                          dy= oldy-yval;

                        if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
                         ddy=Rabs((float) yval/((float) oldy));
                         DisplayFlag = 0;
                         scale(ddy , ddy , ddy);
                         qreset();
                         bang_it(); break;}

		         if(getbutton(LEFTMOUSE)) {
                          if(!val) break;
                           ROTATE(  dy ,'x');
                            DisplayFlag = 1;}

		         if(getbutton(MIDDLEMOUSE)) {
                          if(!val) break;
                           ROTATE( dy , 'z');
                            DisplayFlag = 1;}
                       break;

		    case LEFTMOUSE:
                       { if(!val) break;
                          xc=getvaluator(MOUSEX);
                          yc=getvaluator(MOUSEY);
            
                          getmatrix(xycoor);
                           mmode(MPROJECTION); 
                            getmatrix(RotT);
                             multmatrix(xycoor);
                            getmatrix(xycoor);
                           loadmatrix(RotT);
                           mmode(MVIEWING);

                         /* Reset queue                              */
                          qreset();

                          getsize(&xsiz,&ysiz);
                          getorigin(&xo,&yo);

            xx=near + diffs*((float)(xc+1-xo)/ (float) xsiz);
            yy=near + diffs*((float)(yc+1-yo)/ (float) ysiz);


            for( j = 0 ; j < mlist_deep ; j++) {
            for( i = mlists[j] ; i < mliste[j] ; i++) {
    
/* don't count undisplayed atoms (disp_list[i] = 0)      */
            if(disp_list[i] == 0) continue;



     xtr= 0.5 * diffs * (xycoor[0][0]*x[i]+xycoor[1][0]*y[i]+
          xycoor[2][0]*z[i]+xycoor[3][0]-rotB[3][0]);
     ytr= 0.5 * diffs * (xycoor[0][1]*x[i]+xycoor[1][1]*y[i]+
          xycoor[2][1]*z[i]+xycoor[3][1]-rotB[3][1]);

           tmp1 = (xx-xtr);
           tmp2 = (yy-ytr);

             if((tmp1 * tmp1 + tmp2 * tmp2) < HitSphere2 ) {

             if( i == repeat) break;
             repeat = i;
/* hit ... */
             sprintf(text," (%d:%.4s:%.4s)(%d) ",GetResNum1(i),
                                                 GetAtmName(i),
                                                 GetResName(i),
                                                 (j+1));
             printf("\007\n");
             PrintMessage(text);

             DisplayFlag = 1;

             if(pick_p < 2 ) {pick_num[pick_p]=i ; pick_p++ ; goto PickExit;}

             bangle(pick_num[0],pick_num[1],i,&angle);

/*  in degrees */
             angle = angle*180.0/pia;

             strncpy(TAtm,GetAtmName(pick_num[0]),MAX_ATM_NAME_LEN);
             strncpy(TRes,GetResName(pick_num[0]),MAX_RES_NAME_LEN);

             strncpy(TAtm1,GetAtmName(pick_num[1]),MAX_ATM_NAME_LEN);
             strncpy(TRes1,GetResName(pick_num[1]),MAX_RES_NAME_LEN);


sprintf(text,"\n Angle %d_%.4s:%.4s- %d_:%.4s:%.4s- %d_:%.4s:%.4s = %f \n\n",
                                                           pick_num[0]+1,
                                                    TAtm,
                                                    TRes,
                                                           pick_num[1]+1,
                                                    TAtm1,
                                                    TRes1,
                                                                     i+1,
                                                    GetAtmName(i),
                                                    GetResName(i),angle);

             PrintMessage(text);

             pick_p=0; qreset(); break;

	   }}}
PickExit:;
		       }
            break;
		      }
	  } 
            if(DisplayFlag) {
              DisplayFlag = 0;
              bang_it();}
    }
}

/***********************************************************************/
mtorsion()    /* measures a torsion angle */
/***********************************************************************/
{
      extern int *atm_type;
      extern float *atm_charge;

     register int oldx,oldy;
     register short dx,dy;

      static int xsiz,ysiz,xo,yo,i,j;
      static int DisplayFlag;
      static int pick_p,pick_num[3],repeat;
      static float xx,yy,xtr,ytr,angle;
      static float ddx,ddy,ddz,tmp1,tmp2;
      float diffs;
      char text[BUFF_LEN];
      float RotT[4][4];
      char TRes[MAX_RES_NAME_LEN],TAtm[MAX_ATM_NAME_LEN];
      char TRes1[MAX_RES_NAME_LEN],TAtm1[MAX_ATM_NAME_LEN];
      char TRes2[MAX_RES_NAME_LEN],TAtm2[MAX_ATM_NAME_LEN];

      diffs = far - near;
  
      PrintMessage(" >>>>>> PRESS e-key to return from TORSION facility <<<<<< \n");

      text_port = 1;  /* display text from now */

      strcpy(bottom_line,"Pick four atoms for a torsion angle");
      going_on();

      pick_p=0;   /* reset the pick */
      repeat = mliste[mlist_deep - 1] + 1;

      while(1) {

      DisplayFlag = 0;

        while(qtest()) {

          dev=qread(&val);

          switch(dev) {              /* main switch board */

                      case ESCKEY:
                        shut_down(0); 

		      case EKEY: 
                        qreset();
                        text_port = 0;
                        return; 

		      case REDRAW:
                        DisplayFlag = 1;
                        reshapeviewport();
                        break;

		      case MENUBUTTON:
                       { menuval = dopup(identmenu);
                           switch( menuval) {
                           case 1:
                           text_port = 0;
                           qreset();
                           return;break;
                           case 2:
                           shut_down(0);
                           case 3:
                           if(text_port ==0) text_port = 1;
                           else
                           text_port =0;
                           DisplayFlag = 1;
                           break;}}
                        break;

/* track MOUSEX                         */
		      case MOUSEX:
                        oldx=xval;
                         xval=val;
                          dx= oldx-xval;
                      
                       if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
                        ddx=Rabs((float) xval/((float) oldx));
                        DisplayFlag = 0;
                        scale(ddx , ddx , ddx);
                        qreset();
                        bang_it(); break;}

		        if(getbutton(LEFTMOUSE)) {
                         if(!val) break;
                          ROTATE( -dx ,'y');
                           DisplayFlag = 1;}

                        if(getbutton(MIDDLEMOUSE)) {
                         if(!val) break;
                          ROTATE( dx , 'z');
                           DisplayFlag = 1;}
                       break;

/* track MOUSEY                         */
		      case MOUSEY:
                        oldy=yval;
                         yval=val;
                          dy= oldy-yval;

                        if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
                         ddy=Rabs((float) yval/((float) oldy));
                         DisplayFlag = 0;
                         scale(ddy , ddy , ddy);
                         qreset();
                         bang_it(); break;}

		         if(getbutton(LEFTMOUSE)) {
                          if(!val) break;
                           ROTATE(  dy ,'x');
                            DisplayFlag = 1;}

		         if(getbutton(MIDDLEMOUSE)) {
                          if(!val) break;
                           ROTATE( dy , 'z');
                            DisplayFlag = 1;}
                       break;

		    case LEFTMOUSE:
                       { if(!val) break;
                          xc=getvaluator(MOUSEX);
                          yc=getvaluator(MOUSEY);
            
                          getmatrix(xycoor);
                           mmode(MPROJECTION); 
                            getmatrix(RotT);
                             multmatrix(xycoor);
                            getmatrix(xycoor);
                           loadmatrix(RotT);
                           mmode(MVIEWING);

                         /* Reset queue                              */
                          qreset();

                          getsize(&xsiz,&ysiz);
                          getorigin(&xo,&yo);

            xx=near + diffs*((float)(xc+1-xo)/ (float) xsiz);
            yy=near + diffs*((float)(yc+1-yo)/ (float) ysiz);


            for( j = 0 ; j < mlist_deep ; j++) {
            for( i = mlists[j] ; i < mliste[j] ; i++) {
    
/* don't count undisplayed atoms (disp_list[i] = 0)      */
            if(disp_list[i] == 0) continue;



     xtr= 0.5 * diffs * (xycoor[0][0]*x[i]+xycoor[1][0]*y[i]+
          xycoor[2][0]*z[i]+xycoor[3][0]-rotB[3][0]);
     ytr= 0.5 * diffs * (xycoor[0][1]*x[i]+xycoor[1][1]*y[i]+
          xycoor[2][1]*z[i]+xycoor[3][1]-rotB[3][1]);

           tmp1 = (xx-xtr);
           tmp2 = (yy-ytr);

             if((tmp1 * tmp1 + tmp2 * tmp2) < HitSphere2 ) {

             if( i == repeat) break;
/* hit ... */
             repeat = i;
             sprintf(text," (%d:%.4s:%.4s)(%d)",GetResNum1(i),
                                                GetAtmName(i),
                                                GetResName(i),
                                                (j+1));
             printf("\007\n");
             PrintMessage(text);

             DisplayFlag = 1;

             if(pick_p < 3 ) {pick_num[pick_p]=i ;pick_p++ ; goto PickExit;}

             dihed(pick_num[0],pick_num[1],pick_num[2],i,&angle);

/*  in degrees */
             angle = angle*180.0/pia;

             strncpy(TAtm,GetAtmName(pick_num[0]),MAX_ATM_NAME_LEN);
             strncpy(TRes,GetResName(pick_num[0]),MAX_RES_NAME_LEN);

             strncpy(TAtm1,GetAtmName(pick_num[1]),MAX_ATM_NAME_LEN);
             strncpy(TRes1,GetResName(pick_num[1]),MAX_RES_NAME_LEN);

             strncpy(TAtm2,GetAtmName(pick_num[2]),MAX_ATM_NAME_LEN);
             strncpy(TRes2,GetResName(pick_num[2]),MAX_RES_NAME_LEN);


sprintf(text,"\n Torsion %d_%.4s:%.4s- %d_%.4s:%.4s- %d_%.4s:%.4s- %d_%.4s:%.4s = %f \n\n",
                                                           pick_num[0]+1,
                                                    TAtm,
                                                    TRes,
                                                           pick_num[1]+1,
                                                    TAtm1,
                                                    TRes1,
                                                           pick_num[2]+1,
                                                    TAtm2,
                                                    TRes2,
                                                                     i+1,
                                                    GetAtmName(i),
                                                    GetResName(i),angle);
             PrintMessage(text);

             pick_p=0; qreset() ; break;

	   }}}
PickExit:;
		       }
            break;
		      }
	  } 
            if(DisplayFlag) {
              DisplayFlag = 0;
              bang_it();}
    }
}
#endif
/***********************************************************************/
Handle_Picks(ip,Picks,Cpicks)
     int    ip;
     int    Picks;
     float *Cpicks;
/***********************************************************************/
{
     char OutText[BUFF_LEN];

     if(!Picks) {
      Cpicks[0] = Cpicks[1] = x[ip] + sumx;
      Cpicks[2] = Cpicks[3] = y[ip] + sumy;
      Cpicks[4] = Cpicks[5] = z[ip] + sumz;
      return;}

      if((x[ip]+sumx) < Cpicks[0]) Cpicks[0] = x[ip]+sumx;
      if((x[ip]+sumx) > Cpicks[1]) Cpicks[1] = x[ip]+sumx;

      if((y[ip]+sumy) < Cpicks[2]) Cpicks[2] = y[ip]+sumy;
      if((y[ip]+sumy) > Cpicks[3]) Cpicks[3] = y[ip]+sumy;

      if((z[ip]+sumz) < Cpicks[4]) Cpicks[4] = z[ip]+sumz;
      if((z[ip]+sumz) > Cpicks[5]) Cpicks[5] = z[ip]+sumz;

      sprintf(OutText,"MinX %f , MaxX %f\n",Cpicks[0],Cpicks[1]);
      PrintMessage(OutText);

      sprintf(OutText,"MinY %f , MaxY %f\n",Cpicks[2],Cpicks[3]);
      PrintMessage(OutText);

      sprintf(OutText,"MinZ %f , MaxZ %f\n",Cpicks[4],Cpicks[5]);
      PrintMessage(OutText);
}

      

#ifdef sgi
/************************************************************************/
void RedrawScreen()
/************************************************************************/
{
          reshapeviewport();
          bang_it();

}
/************************************************************************/
DoSanitary()
/************************************************************************/
{
   if(!AutoScreenBlank) return;     /* no screenblank */

   winset(GetMainWindowID());
   reshapeviewport();
   c3s(bgcolor); /* background */
    clear();
     zclear();
}
/************************************************************************/
ReshapeViewport()
/************************************************************************/
{
/*
       float savePV[4][4];
*/
       float saveMV[4][4];


       reshapeviewport();
/*
       mmode(MPROJECTION);
        getmatrix(savePV);
*/
       mmode(MVIEWING);
        getmatrix(saveMV);

       MakeOrtho();

/*
       mmode(MPROJECTION);
        loadmatrix(savePV);
*/
       mmode(MVIEWING);
        loadmatrix(saveMV);

}

/************************************************************************/
draw_other_stuff()
/************************************************************************/
{
      winset(GetMainWindowID());

      print_obj(); 
       if(PlotLine.Show)   (void)PlotLineSeg();
       if(PlotSphere.Show) (void)PlotSphereSeg();
       if(PlotPlane.Show)  (void) PlotPlaneSeg();
       if(PlotCylinder.Show) (void)PlotCylinderSeg();
/*      screen_stat(); */
      if(ldp_wind)   pre_ldp();
       if(rama_wind) pre_rama();
        if(cluster_wind) pre_cluster();
        if(trace_wind) plot_atom_trace();
         if(label_deep)  label_ident();
          if(calc_neigh) plot_dist_list();
           if(PlotCurves.NumCurves) PlotCurves2Screen();
           if(atm_force.plot) plot_force();
            if(disp_obj[0]) plot_dyn_obj();
             if(PlotVariables.PlotDist) {
                if(PlotDistObj())    PlotVariables.PlotDist = 0;}
             if(PlotVariables.PlotAng)  {
                if(PlotAngleObj())   PlotVariables.PlotAng  = 0;}
             if(PlotVariables.PlotTors) {
                if(PlotTorsionObj()) PlotVariables.PlotTors = 0;}
             if(ContoursDefined) PlotIsoSurf();
             if(corr_info.corr_wind) pre_plot_corr();
              if(RaDiFu.Plot) PlotRDFcurve();
              if(BOX) draw_cube();
               if(BoxInfo.OnOff)
                  DrawBox(BoxInfo.Xsize , 
                          BoxInfo.Ysize , 
                          BoxInfo.Zsize ,
                          BoxInfo.Xplace , 
                          BoxInfo.Yplace , 
                          BoxInfo.Zplace);
               if(scale_plot.plot_color_scale) disp_color_scale();
               if(display_text) drive_text();
                if(Text_Disp.Display) put_text();

}
#endif
