/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/
 
 
/*
   This program reads a YASP coordinate file
 
   Leif Laaksonen 1990
*/
 
#include <stdio.h>
#include <math.h>
#include <string.h>

#include "maxdefs.h"

#if defined(USEFORMS) && defined(sgi)
#include "../forms/FORMS/forms.h"
#endif

#define YASP_LINE_LEN   80   /* yasp file line length */
 
extern int numat;
extern char input_file[BUFF_LEN];
extern int indexo();
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */
 
     extern void send_command();
     extern void PrintMessage();
     extern void dialog4();

extern int PutSegName();
extern int PutResName();
extern int PutAtmName();
extern int PutResNum1();
extern int PutResNum2();
extern int PutXCoord();
extern int PutYCoord();
extern int PutZCoord();
extern int PutBValue();
extern int PutAtmCharge();
extern int NumStructLists();
extern int StartIndexStructList();

/*************************************************************************/
pre_read_yasp()  /* pre routine for reading a yasp file */
 
/*************************************************************************/
{
 
    extern char *bottom_line;
    char text[BUFF_LEN];
    char Cline[BUFF_LEN];
    int ret_val;

#ifdef sgi
 
#ifdef USEFORMS && sgi
  { char *fname;
  fname = fl_show_file_selector("Give name of YASP file:  ","","","");
  if(fname == NULL) 
    text[0] = '\0';
      else
      strncpy(text,fname,BUFF_LEN);}
#else
    dialog4("Reading YASP file.","Give name of YASP file:  ",text);
#endif
     if(text[0] == '\0') return;
    strncpy(input_file,text,BUFF_LEN);
      strncpy(Cline,"read coord yasp ",BUFF_LEN);
       strncat(Cline,text,(BUFF_LEN - strlen(Cline)));
    strncpy(bottom_line,"Reading YASP file ...",PORTchar);
    going_on();
    send_command(Cline);
    return; 
#else

    printf("?ERROR - not implemented on this device \n");

#endif

}
 
/*************************************************************************/
int read_yasp(inp_file)
/*************************************************************************/
    char *inp_file;
{
 

   int   TRs1,TRs2;
   float TXc,TYc,TZc,TBv;
   char  TResN[BUFF_LEN];
   char  TAtmN[BUFF_LEN];
   char  TSegN[BUFF_LEN];

 
char input[YASP_LINE_LEN];
char temp[YASP_LINE_LEN];
int tatomn,tres1,tres2;
int i,j,k;
char OutText[BUFF_LEN];
 
FILE *yasp_in;
 
      yasp_in=fopen(inp_file,"r");
       if(yasp_in == NULL) {
        sprintf(OutText,"Can't open input file : %s",inp_file);
        PrintMessage(OutText);
        return(1);
      }
 
      TRs1 = 1;
      TRs2 = 1;
      TBv  = 0.0;

      sprintf(OutText,"********** Reading : %s **********",inp_file);
      PrintMessage(OutText);
/*
      Start reading file
 
*/
 
     while(fgets(input,YASP_LINE_LEN,yasp_in) != NULL) {
     strcpy(temp,input);
     toller(temp);
 
/* Title card */
 
     if(( k = indexo(temp,"title:")) == 1) {
       PrintMessage(input);}
 
/* Coordinates card */
 
     if(( k = indexo(temp,"coordinates:")) == 1) {
       fgets(input,YASP_LINE_LEN,yasp_in);
       sscanf(input,"%d",&numat);

/* it's possible to already update now */

       update_mlist(numat);

 
      for(i = mlists[mlist_deep - 1] ; i < mliste[mlist_deep - 1] ; i++ ) {
       fgets(input,YASP_LINE_LEN,yasp_in);
         sscanf(input," %*d %s %f %f %f ",
	 temp,
	 &TXc ,&TYc ,&TZc );
 
         TXc *= 10.;
         TYc *= 10.;
         TZc *= 10.;
 
         j = PutXCoord(TXc , i);
          j = PutYCoord(TYc , i);
           j = PutZCoord(TZc , i);


/* truncate and put atom name in right place */
         k = strlen(temp);
          for(j = 1 ; j < k ; j++) {
             if(temp[j] == 39) {
                temp[j] = '\0';
                break;}
	   }
 
         if(temp[0] == 39)
          j = PutAtmName((temp+1) , i);
         else
          j = PutAtmName(temp , i);
/* add dummies */
         j = PutSegName("YASP" , i);
          j = PutResName("YASP" , i);

         j = PutResNum1(TRs1 , i);
         j = PutResNum2(TRs2 , i);

         j = PutBValue(TBv , i);
         j = PutAtmCharge( 0.0 , i);
     }
     }
/* Coordinates/velocities card */
 
     if(( k = indexo(temp,"coordinates/velocities:")) == 1) {
       fgets(input,YASP_LINE_LEN,yasp_in);
       sscanf(input,"%d",&numat);
 
      for(i = mlists[mlist_deep - 1] ; i < mliste[mlist_deep - 1] ; i++ ) {
         sscanf(input," %*d %s %f %f %f ",
	 temp,
	 &TXc ,&TYc ,&TZc );
 
         TXc *= 10.;
         TYc *= 10.;
         TZc *= 10.;
 
         j = PutXCoord(TXc , i);
          j = PutYCoord(TYc , i);
           j = PutZCoord(TZc , i);

       fgets(input,YASP_LINE_LEN,yasp_in); /* read velocities (not used) */
 
 
/* truncate and put atom name in right place */
         k = strlen(temp);
          for(j = 1 ; j < k ; j++) {
             if(temp[j] == 39) {
                temp[j] = '\0';
                break;}
	   }
 
         if(temp[0] == 39)
          j = PutAtmName((temp+1) , i);
         else
          j = PutAtmName(temp , i);
/* add dummies */
         j = PutSegName("YASP" , i);
          j = PutResName("YASP" , i);

         j = PutResNum1(TRs1 , i);
         j = PutResNum2(TRs2 , i);

         j = PutBValue(TBv , i);
         j = PutAtmCharge( 0.0 , i);
     }
 
     }
 
/* basta card */
      if(( k = indexo(temp,"basta:")) == 1) {
      PrintMessage("**********   Done   **********");
        return(0);}
 
   }
 
      PrintMessage("**********   Done   **********");
    
     return(0);
 }
