/*  

                       Copyright (c) 1992 by:
        Leif Laaksonen , Centre for Scientific Computing , ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/
 
 
/*
   This program reads a MUMOD coordinate file
 
   Leif Laaksonen 1990
*/
 
#include <stdio.h>
#include <math.h>
#include <string.h>

#include "maxdefs.h"

#if defined(USEFORMS) && defined(sgi)
#include "../forms/FORMS/forms.h"
#endif

#define MUMOD_LINE_LEN   120   /* MUMOD file line length */

#define Kill_Comma(InText)  {int Cloop; for(Cloop = 0 ; \
                                           Cloop < strlen(InText);\
                                           Cloop++) {\
                                if(InText[Cloop] == ',') InText[Cloop] = ' ';}}

#define FREE1    free(molecu); free(n); free(nsite);
#define FREE2    free(name); free(sitmas); free(charge); free(xpr); free(ypr); free(zpr);
#define FREE3    free(xm); free(ym); free(zm);

extern int MAXatom;
extern int numat;
extern char input_file[BUFF_LEN];
extern int indexo();
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */
 
     extern void send_command();
     extern void PrintMessage();
     extern void dialog4();
     extern float *vector();
     extern int   *ivector();
     extern char  *cvector();

extern int PutSegName();
extern int PutResName();
extern int PutAtmName();
extern int PutResNum1();
extern int PutResNum2();
extern int PutXCoord();
extern int PutYCoord();
extern int PutZCoord();
extern int PutBValue();
extern int PutAtmCharge();
extern float GetAtmCharge();
extern float GetXCoord();
extern float GetYCoord();
extern float GetZCoord();

/*************************************************************************/
pre_read_mumod()  /* pre routine for reading a MUMOD file */
 
/*************************************************************************/
{
 
    extern char *bottom_line;
    char text[BUFF_LEN];
    char Cline[BUFF_LEN];
    int ret_val;

#ifdef sgi
 
#if defined(USEFORMS) && defined(sgi)
  { char *fname;
  fname = fl_show_file_selector("Give name of MUMOD file:  ","","","");
  if(fname == NULL) 
    text[0] = '\0';
      else
      strncpy(text,fname,BUFF_LEN);}
#else
    dialog4("Reading MUMOD file.","Give name of MUMOD file:  ",text);
#endif
     if(text[0] == '\0') return;
    strncpy(input_file,text,BUFF_LEN);
      strncpy(Cline,"read coord mumod ",BUFF_LEN);
       strncat(Cline,text,(BUFF_LEN - strlen(Cline)));
    strncpy(bottom_line,"Reading MUMOD file ...",PORTchar);
    going_on();
    send_command(Cline);
    return; 
#else

    printf("?ERROR - not implemented on this device \n");

#endif

}
 
/*************************************************************************/
int read_mumod(inp_file)
/*************************************************************************/
    char *inp_file;
{
 

   int   TRs1,TRs2;
   float TXc,TYc,TZc,TBv;
   char  TResN[BUFF_LEN];
   char  TAtmN[BUFF_LEN];
   char  TSegN[BUFF_LEN];
   int   Mumod_Cards = 1;
   int   Mumod_Atoms = 0;
   int   Atom_point;
   int   Resi_point;
 
char input_text[MUMOD_LINE_LEN];
char temp[MUMOD_LINE_LEN];
int tatomn,tres1,tres2;
int i,j,k,l,poc;
char OutText[BUFF_LEN];
/* mumod variables */
int   ntype;
char **molecu;
int  *n;
int  *nsite;
char  **name;
float *sitmas;
float *charge;
float *xpr;
float *ypr;
float *zpr;
float *xm;
float *ym;
float *zm;
 
FILE *mumod_in;
 
      mumod_in=fopen(inp_file,"r");
       if(mumod_in == NULL) {
        sprintf(OutText,"Can't open input file : %s",inp_file);
        PrintMessage(OutText);
        return(1);
      }
 
      sprintf(OutText,"********** Reading : %s **********",inp_file);
      PrintMessage(OutText);
/*
      Start reading file
 
*/
     Mumod_Cards = 0;

     if(fgets(input_text,MUMOD_LINE_LEN,mumod_in) == NULL) {
        PrintMessage("?ERROR - can't read first line");
         fclose(mumod_in);
        return(1);}

     Mumod_Cards++;
     strcpy(temp,input_text);
     toller(temp);
       if( (k = indexo(temp,"new")) == 0) {
        PrintMessage("?ERROR - on first line in mumod input file");
        PrintMessage(input_text);
        fclose(mumod_in);
        return(1);}
 
     while(fgets(input_text,MUMOD_LINE_LEN,mumod_in) != NULL) {
      Mumod_Cards++;
       strcpy(temp,input_text);

        toller(temp);
        if(indexo(temp,"end") == 1) break;

        i = strlen(input_text);
        if(input_text[i - 1] == '\n') input_text[i - 1] = '\0';
        PrintMessage(input_text);
        continue;}

     if(fgets(input_text,MUMOD_LINE_LEN,mumod_in) == NULL) {
        PrintMessage("?ERROR - can't read input file");
        fclose(mumod_in);
        return(1);}
     PrintMessage(input_text);
     if(fgets(input_text,MUMOD_LINE_LEN,mumod_in) == NULL) {
        PrintMessage("?ERROR - can't read input file");
        fclose(mumod_in);
        return(1);}
     PrintMessage(input_text);
        
     Mumod_Cards += 2;

     if(fgets(input_text,MUMOD_LINE_LEN,mumod_in) == NULL) {
        PrintMessage("?ERROR - can't read input file");
        fclose(mumod_in);
        return(1);}
     ntype = atoi(input_text);

     molecu = (char **) malloc(ntype * sizeof(char *));

     for(i = 0 ; i < ntype ; i++) {  
        molecu[i] = (char *) malloc(BUFF_LEN);
        if(molecu[i] == NULL) {
        PrintMessage("?ERROR - can't alloc memory in 'rmumod.c'");
        fclose(mumod_in);
        return(1);}}

     n      = ivector(ntype);
     nsite  = ivector(ntype);

     Resi_point = 1;

       if(mlist_deep == 0) 
        Atom_point = 0;
         else
          Atom_point = mliste[mlist_deep - 1];


     for(i = 0 ; i < ntype ; i++) {      /* ntype loop */

     if(fgets(input_text,MUMOD_LINE_LEN,mumod_in) == NULL) {
        PrintMessage("?ERROR - can't read input file");
        fclose(mumod_in);
         FREE1;
        return(1);}

     sscanf(input_text,"%s %d %d %*s",molecu[i],&n[i],&nsite[i]);

     name = (char **) malloc(nsite[i] * sizeof(char *));

     for(poc = 0 ; poc < nsite[i] ; poc++) {
        name[poc] = (char *) malloc(BUFF_LEN);
        if(name[poc] == NULL) {
        PrintMessage("?ERROR - can't alloc memory in 'rmumod.c'");
        fclose(mumod_in);
         FREE1;
        return(1);}}

     sitmas = vector(nsite[i]);
     charge = vector(nsite[i]);
     xpr    = vector(nsite[i]);
     ypr    = vector(nsite[i]);
     zpr    = vector(nsite[i]);

     for(j = 0 ; j < nsite[i] ; j++) {     /* nsite(i) loop */

     if(fgets(input_text,MUMOD_LINE_LEN,mumod_in) == NULL) {
        PrintMessage("?ERROR - can't read input file");
        fclose(mumod_in);
         FREE1;
          FREE2;
        return(1);}

     sscanf(input_text,"%s %f %*d %f %f %f %f",name[j],&sitmas[j],&charge[j],
                                          &xpr[j],&ypr[j],&zpr[j]);
   }

     for(j = 0 ; j < nsite[i] ; j++) {      /* nsite(i) loop */
     if(fgets(input_text,MUMOD_LINE_LEN,mumod_in) == NULL) {
        PrintMessage("?ERROR - can't read input file");
        fclose(mumod_in);
         FREE1;
          FREE2;
        return(1);}}


/* build the coordinate data */
     for(k = 0 ; k < n[i] ; k++) {
        for(l = 0 ; l < nsite[i] ; l++) {

     (void)PutSegName(molecu[i],Atom_point);
     (void)PutResName(molecu[i],Atom_point);
     (void)PutAtmName(name[l],Atom_point);
     (void)PutResNum1(Resi_point,Atom_point);
     (void)PutResNum2(Resi_point,Atom_point);
     (void)PutBValue(0.0,Atom_point);
     (void)PutXCoord(xpr[l],Atom_point);
      (void)PutYCoord(ypr[l],Atom_point);
       (void)PutZCoord(zpr[l],Atom_point);
        (void)PutAtmCharge(charge[l],Atom_point);
     Atom_point++;}
        Resi_point++;
      }

     FREE2;
   }

       if(mlist_deep == 0) 
        Atom_point = 0;
         else
          Atom_point = mliste[mlist_deep - 1];

     for(i = 0 ; i < ntype ; i++) {

      xm = vector(n[i]);
      ym = vector(n[i]);
      zm = vector(n[i]);

      for(j = 0 ; j < n[i] ; j++) {

     if(fgets(input_text,MUMOD_LINE_LEN,mumod_in) == NULL) {
        PrintMessage("?ERROR - can't read input file (3)");
        fclose(mumod_in);
         FREE1;
          FREE3;
        return(1);}

     Kill_Comma(input_text);

     sscanf(input_text,"%f %f %f",&xm[j],&ym[j],&zm[j]);}

      for(j = 0 ; j < n[i] ; j++) {
      for(k = 0 ; k < nsite[i] ; k++) {

        TXc = GetXCoord(Atom_point) + xm[j];
         TYc = GetYCoord(Atom_point) + ym[j];
          TZc = GetZCoord(Atom_point) + zm[j];
        (void)PutXCoord(TXc,Atom_point);
        (void)PutYCoord(TYc,Atom_point);
        (void)PutZCoord(TZc,Atom_point);

        if(Atom_point == MAXatom) {
        PrintMessage("?ERROR - max atoms reached");
        return(1);}

        Atom_point++;}
   }
        FREE3;
    }

/* it's possible to already update now */

       Mumod_Atoms = 0;
       for(i = 0 ; i < ntype ; i++) {
          Mumod_Atoms += n[i] * nsite[i];}
    
       numat =  Mumod_Atoms;
       update_mlist(numat);

 
 
      PrintMessage("**********   Done   **********");

        fclose(mumod_in);
        FREE1;
      return(0);    
 }

