/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/


/*
   This program reads a charmm "free format" coordinate file

   Leif Laaksonen 1990
  
   The format is:

   * A comment
   *
     number_of_atoms
   atom_number residue_number residue_name atom_name x y z coordinates segment name residue number bvalue 

   Example:
   * This is a example
   *
     3
   1 1 ALA N  0.0 0.0 0.0 MAIN 1 0.0
   2 1 ALA CA 0.0 0.0 0.0 MAIN 1 0.0
   3 1 ALA CB 0.0 0.0 0.0 MAIN 1 0.0  

*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>

#include "maxdefs.h"

#define FREE_LINE_LEN   80   /* pdb file line length */

extern void send_command();
extern char input_file[BUFF_LEN];
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */


/*************************************************************************/
pre_read_free(alt)  /* pre routine for reading a free format file */

    int alt;
/*************************************************************************/
{
    extern char *bottom_line;
    extern int MAXatom;
    char text[BUFF_LEN];
    char Cline[BUFF_LEN];
    int ret_val;

    switch(alt) {

    case 0:
    dialog4("Reading Free format file","Give name of 'free format' file:  ",text);
    if(text[0] == '\0') return;
    strncpy(input_file,text,BUFF_LEN);
      strncpy(Cline,"read coord free ",BUFF_LEN);
       strncat(Cline,text,(BUFF_LEN - strlen(Cline)));
    strcpy(bottom_line,"Reading 'free format' file...");
    going_on();
    send_command(Cline);
    break;

    case 1:
    strncpy(text,input_file,BUFF_LEN);
    break;}

    ret_val = read_free(text);

    if(ret_val) return;
    do_util();
}

/*************************************************************************/
int read_free(inp_file)  /* Free format file reader */
/*************************************************************************/
    char inp_file[];
{

/*  externals                                      */
   extern int numat,*res1,*res2;
   extern float *x,*y,*z,*bvalue;
   extern char  *resnam,*atnam,*segment;
   extern int MAXatom;
/*                                                 */

char inputl[FREE_LINE_LEN];   /* input line */
char ident[6];              /* tag at the beginning of line */
char cres1[10],cx[10],cy[10],cz[10],cbvalue[10];
int tatomn,tres1,tres2;
int i,j,k,loop,step;

FILE *free_in;

      free_in=fopen(inp_file,"r");
       if(free_in == NULL) {
        printf("\n\n Can't open input file : %s \n\n",inp_file);
        return(1);
       }

      printf("********** Reading : %s **********\n",inp_file);

       fgets(inputl,FREE_LINE_LEN,free_in);
       printf("%s",inputl);

       while(strncmp(inputl,"*",1) == 0) {
         fgets(inputl,FREE_LINE_LEN,free_in);
         if(strncmp(inputl,"*",1) != 0) break;
         printf("%s",inputl);
       }

      sscanf(inputl,"%d",&numat);

       update_mlist(numat);

        for(i = mlists[mlist_deep - 1] ; i < mliste[mlist_deep - 1]; i++ ) {
        fgets(inputl,FREE_LINE_LEN,free_in);

        sscanf(inputl,"%*d %d %s %s %f %f %f %s %d %f",
        &res1[i],resnam+4*i,atnam+4*i,&x[i],&y[i],&z[i],segment+4*i,&res1[i],
        &bvalue[i]);

        if(i == MAXatom) {
        printf("?ERROR - max atoms reached \n");
        shut_down(1);}
     } /*end atom*/

       fclose(free_in);

       return(0);

}
