/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/times.h>
#include <sys/param.h>

/**************************************************************************/
void rest_sec(seconds) /* rest in this routine for the 'second' number of secs */

   float seconds;
/**************************************************************************/
{

   long ret_in;
   long ret_out;
   float retf_in;
   float retf_out;

   struct tms buffer;

   ret_in = times(&buffer);  /*start time */
   retf_in = (float)ret_in / (float)(HZ);
   while(1) {
    ret_out = times(&buffer);
     retf_out = (float)ret_out / (float)(HZ);
      if( (retf_out - retf_in) > seconds ) return; }
}
/**************************************************************************/
void get_cpu_secs(Msecs,Csecs)   /* get used cpu seconds */
     float *Msecs;  /* main process */
     float *Csecs;  /* child processes */
/**************************************************************************/
{
/* return used cpu seconds. This routine can to be called  
   with a negative value to set the cpu time = 0 */

   long ret_in;
   static float start = 0.0;
   static float start_child = 0.0;

   struct tms buffer;

   ret_in = times(&buffer);  /*start time */

   if(*Msecs < 0.0 ) {
   start       = (float)(buffer.tms_utime  + buffer.tms_stime)  / (float)(HZ);
   start_child = (float)(buffer.tms_cutime + buffer.tms_cstime) / (float)(HZ);}
   else {
   *Msecs = (float)(buffer.tms_utime  + buffer.tms_stime)  / (float)(HZ) - start;
   *Csecs = (float)(buffer.tms_cutime + buffer.tms_cstime) / (float)(HZ) - start_child;}
}

