/*  

                       Copyright (c) 1990, 1991, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#ifdef sgi
#include <gl.h>
#endif
#include "maxdefs.h"

     extern void PrintMessage();
     extern void iso_release_memory();
     extern void MakeOrtho();
     extern int  DeleteRDF();
     extern void DelLineSeg();
     extern void DelSphereSeg();
     extern int  ResetRealStereoParams();
     extern int DelManSelectionList();
     extern int TurnOFFObjPlot();

     extern char parsed[MAXparse][MAXlinel];
     extern int dic_read;
     extern int numat;
     extern float near,far;
     extern float rotB[4][4];
     extern int term_type;
     extern float *trax,*tray,*traz;
     extern int alpha_trace;
     extern int colour_structure_by;
     extern float idmat[4][4];
     extern int label_deep;
     extern int force_type;

/* structur containing pointers to dynamics display variables */
    extern struct dyna_disp_var {
      int numset;             /* number of sets (or variables) */
      int current_set;        /* index to current set          */
      int point_len;          /* length of point array         */
      int *point_vec;         /* pointer to point array        */
      int dist_len;           /* length of dist array          */
      int *dist_vec;          /* pointer to dist array         */
      int ang_len;            /* length of angle array         */
      int *ang_vec;           /* pointer to angle array        */
      int tors_len;           /* length of torsion array       */
      int *tors_vec;          /* pointer to torsion array      */
      int obs_vec_len;        /* observation array length      */
      int obs_vec_curr;       /* display current               */
      float *obs_vec;};       /* pointer to observation array  */

    extern struct dyna_disp_var play_dynam_frames;

/* structure for the dynamics trajectory file */

   extern struct {
    char traj_file[BUFF_LEN];                 /* file name          */
    int natom;                                /* number of atoms    */
    int nstep;                                /* number of steps    */
    int time_bw_steps;                        /* time between steps */
    int time_first_frame;                     /* time of first frame */
    int first_frame;                          /* first frame to be displayed */
    int last_frame;                           /* last frame to be displayed  */
    int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     
/* molecule lists */
   extern int current_struct;  /* molecule to be displayed */
   extern int mlist_deep;      /* stack number indicator */

   extern char input_file[BUFF_LEN];           /* name of molecule file */
   extern int input_file_set;        /* switch for input file set/not set */

/* dynamics trajectory analysis parameters  */

  extern char traj_file[BUFF_LEN];
  extern int  traj_file_set;       /* switch for trajectory file set/not set 
                                    0 ==> file is not set
                                    1 ==> charmm trajectory
                                    2 ==> yasp trajectory
                                    3 ==> discover trajectory
                                 */

  extern int point_arr_set;      /* switch for setting of the point array */
  extern int dist_arr_set;       /*           -"-             dist        */
  extern int ang_arr_set;        /*           -"-             ang         */
  extern int tors_arr_set;       /*           _"_             tors        */
  extern int etot_arr_set;       /*           _"_             etot        */
  extern int pen_arr_set;        /*           -"-            pot en       */

  extern char energy_file[BUFF_LEN];  /* name of trajectory energy file */

   struct {
    int   tote_set;
    int   kine_set;
    int   pote_set;
    int   temp_set;
    int   bond_set;
    int   angl_set;
    int   dihe_set;
    int   impr_set;
    int   vdw_set;
    int   elec_set;
    int   hbond_set;
    int   charm_set;
   float min_tote;
   float max_tote;
   float min_kine;
   float max_kine;
   float min_pote;
   float max_pote;
   float min_temp;
   float max_temp;
   float min_bond;
   float max_bond;
   float min_angl;
   float max_angl;
   float min_dihe;
   float max_dihe;
   float min_impr;
   float max_impr;
   float min_vdw;
   float max_vdw;
   float min_elec;
   float max_elec;
   float min_hbond;
   float max_hbond;
   float min_charm;
   float max_charm; } traj_energy_limits ;

   extern int et_count;

/* pointers for force calculation */

     extern struct force_struct {
     int    set;  /* switch if the forces are set = 0 , not != 0, yes */
     int   plot;  /* switch for a plot = 0 , no plot , != 0 a plot */
     float  *fx;  /* pointers to the forces */
     float  *fy;
     float  *fz;
     int *sel_list; /* selection list */
     int  ent_list; /* entries in the selection list */
     float scale; /* scale factor */
     int   maxfi; /* index of max force atom */
     float maxfa; /* value of the max force  */
     int   minfi; /* index on min force atom */
     float minfa; /* value of the min force  */ } atm_force; 

    extern struct {
     int plot_color_scale; /* = 0 , off , != 0 on */
     int which_plot;       /* = 0 no plot,
                                1 force plot,
                                2 charge plot
                           */
     int num_level; } scale_plot;

     extern struct {
       int set;          /* = 0 , colouring not set , > 0 colouring set */
       float max;
       float min;}   charge_color;

/* structure to hold the trace of atoms       */

   extern struct {
   int trace_on;        /* switch to indicate that a trace is saved (=1)   */
   int trace_sets;      /* number of trace sets                            */
   int trace_step;      /* step length                                     */
   int *trace_atoms;    /* number of traced atoms in each set              */
   int *trace_list;     /* list of atoms to be traced                      */
   float *trx;          /* array to contain the x coordinates of the trace */
   float *try;
   float *trz;} trace_info;

/* structure to hold the trace of ramachandran       */

   extern struct {
   int trace_on;        /* switch to indicate that a trace is saved (=1)   */
   int trace_sets;      /* number of trace sets                            */
   int trace_step;      /* step length                                     */
   int *trace_atoms;    /* number of traced atoms in each set              */
   int *trace_list;     /* list of atoms to be traced                      */
   float *phi;          /* array to contain the x coordinates of the trace */
   float *psi;} trace_info_rama;

   extern int trace_wind; /* = 0 no display , = 1 display on */

/* define the CHARMm structure                          */
   extern struct CHARMm { /* Charmm structure */
     int numat;          /* number of atoms in this structure */
     int *res1;          /* residue number 1 list */
     int *res2;          /* residue number 2 list */
     char *resnam;       /* residue name list */
     char *atnam;        /* atom name list */
     char *segment;      /* segment name list */
     float *x;           /* x,y and z coordinates */
     float *y;
     float *z;
     float *bvalue;}      /* bvalue list */
                     *Charmm_struct;
   extern int NumCharmmStruct;  /* number of Charmm structures present */
/* end of CHARMm structure                           */

/* contour structure */
     extern int    ContoursDefined;

     extern struct Contour_Struct {
     float *data;           /* contour data */
     float min;
     float max;
     int xdim;
     int ydim;
     int zdim;
     float Xtrans;
     float Ytrans;
     float Ztrans;
     float Xscale;
     float Yscale;
     float Zscale;
     float ColVal[MAX_CONT];
     int   NumVal;
     char  ColNam[MAX_CONT][BUFF_LEN];
     char  ContFile[BUFF_LEN];
     float AlphaBlend;
     int   ContSmooth;
     char  Name[BUFF_LEN];
     int   Display;} ContourInfo[MAX_CONTOURS];

    extern struct SURF_LIM {
    int set;             /* = 0 , not set , > 0 set */
    float Xmin;
    float Xmax;
    float Ymin;
    float Ymax;
    float Zmin;
    float Zmax;
    char  MeshFile[BUFF_LEN];
    char  WFFile[BUFF_LEN];
    float ProbeVal;
    int Orbital;
    int Dmethod;
    int Xpts;
    int Ypts;
    int Zpts;
                   } DENSITY_limits , PROBE_limits , VSS_limits;

    extern struct SphereSeg {
      int    Show;             /* if != 0 show the sphere      */
      int    Spheres;          /* number of spheres            */
      float *SphereCoord;      /* pointer to the coordinates   */
      float *Radius;           /* pointer to sphere radius     */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
    } PlotSphere;

       extern struct {
         float Angle;       /* rotation angle */
         float Translate;   /* translation from the centre */
         int   Active;      /* == 0 off , != 0 on */
         int   Set;         /* == 0 reset , != do not reset */
                  } StereoPlot;

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

     extern struct {
        int InUse;
        int  slong;           /* length of the list */
        int *sel_list;        /* index to atoms     */
      } ManSelection;

     int  DeleteTrajectoryInfo();

/************************************************************************/
reset_fac(input,num)   /* reset command */
   char *input; 
   int num;
/************************************************************************/
{

     int i;
     char OutText[BUFF_LEN];
     static float saveM[4][4];
     static char *rst_txt = "\n\
  *********************** reset command *******************************\n\
    rese*t atom colo*our                ! Reset atom colour\n\
           scar*ecrow                   ! Reset program (start from scratch)\n\
           view                         ! Reset view \n";

/* switch to small characters                 */
     toller(parsed[1]);

/* help display                               */
   if(indexo(parsed[1],"?") == 1) {
   printf("%s",rst_txt);
   return;}

/* reset scarecrow                 */
   if(indexo(parsed[1],"scar") == 1) {
     printf("Reseting SCARECROW \n");

      reset_scarecrow();
      printf("Done...\n");
     return;}

/* no other commands allowed for non iris terminals */
   if(term_type == 1 || term_type == 3) {

/* reset atom colour                                    */
   if(indexo(parsed[1],"atom") == 1) {
     toller(parsed[2]);
     if(indexo(parsed[2],"colo") == 1)  {
       sprintf(OutText,"Reseting atom colours for structure '%d'",
                       (current_struct+1));
       PrintMessage(OutText);
       colour_zone(2);
       return;}
   }

/* reset view */
   if(indexo(parsed[1],"view") == 1) {
#ifdef sgi
      mmode(MVIEWING); 
      MakeOrtho();
      loadmatrix(idmat);
      reshapeviewport();

                      trax[0]= 0.0;
                       tray[0] = 0.0;
                        traz[0] = 0.0;
#endif
     return;}

/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

     }
     else
     return;

}      /* end of reset_fac */

/************************************************************************/
reset_scarecrow()
/************************************************************************/
{
     numat = 0;
      play_dynam_frames.numset = 0;
      play_dynam_frames.current_set = 0;
      play_dynam_frames.point_len   = 0;
      play_dynam_frames.dist_len    = 0;
      play_dynam_frames.ang_len     = 0;
      play_dynam_frames.tors_len    = 0;
      play_dynam_frames.obs_vec_len = 0;

      (void)DeleteTrajectoryInfo();

      traj_file[0] = '\0';

      current_struct = 0;
      mlist_deep = 0;
      mliste[0] = 0;
      mlists[0] = 0;

      input_file[0] = '\0';
      input_file_set = 0;

      traj_file[0] = '\0';
      traj_file_set = 0;
      force_type    = 0;

      point_arr_set = 0;      /* switch for setting of the point array */
      dist_arr_set = 0;       /*           -"-             dist        */
      ang_arr_set = 0;        /*           -"-             ang         */
      tors_arr_set = 0;       /*           _"_             tors        */
      etot_arr_set = 0;       /*           _"_             etot        */
      pen_arr_set = 0;        /*           -"-            pot en       */

      energy_file[0] = '\0';

      alpha_trace = 0;

      colour_structure_by = 0;

      traj_energy_limits.tote_set = 0; 
      traj_energy_limits.kine_set = 0; 
      traj_energy_limits.pote_set = 0; 
      traj_energy_limits.temp_set = 0; 

      et_count = 0;

      if(atm_force.set != 0) {
        atm_force.set  = 0;
        atm_force.plot = 0;
         free(atm_force.fx);
          free(atm_force.fy);
           free(atm_force.fz);}
      if(atm_force.ent_list) {
         atm_force.ent_list = 0;
         free(atm_force.sel_list);}

         scale_plot.plot_color_scale = 0;
         scale_plot.which_plot       = 0;

         charge_color.set = 0;

      if(trace_info.trace_on) {
     free((char *)trace_info.trx);   
      free((char *)trace_info.try);   
       free((char *)trace_info.trz);   
        free((char *)trace_info.trace_list);
         free((char *)trace_info.trace_atoms);
     trace_info.trace_on = 0;
     trace_wind = 0;
        trace_info.trace_sets = 0;}


     if(NumCharmmStruct) free(Charmm_struct);
       NumCharmmStruct = 0;

     if(ContoursDefined)
        (void)DeleteContoursAll();

     label_deep = 0;

     alpha_trace = 0;

                       DENSITY_limits.set = 0;
                       PROBE_limits.set   = 0;
                       VSS_limits.set     = 0;

     (void)DeleteRDF();

           DelLineSeg();
            DelSphereSeg();
             DelCylinderSeg();

     StereoPlot.Active = 0;
      StereoPlot.Set   = 0;

     (void)ResetRealStereoParams();

     (void)DelManSelectionList();

     (void)TurnOFFObjPlot();
}
/************************************************************************/
void ResetView()
/************************************************************************/
{

#if defined(sgi)
      mmode(MVIEWING); 
      MakeOrtho();
      loadmatrix(idmat);
      reshapeviewport();
#endif
                      trax[0]= 0.0;
                       tray[0] = 0.0;
                        traz[0] = 0.0;

}

/************************************************************************/
int DeleteContoursAll()
/************************************************************************/
{
    int i;

    for(i = 0 ; i < ContoursDefined ; i++) {
     free(ContourInfo[i].data);
          ContourInfo[i].data        = NULL;
          ContourInfo[i].ContFile[0] = '\0';
          ContourInfo[i].NumVal      = 0;
          ContourInfo[i].AlphaBlend  = 1.0;
          ContourInfo[i].Display     = 0;}

    iso_release_memory();

    ContoursDefined = 0;

    return(0);
}

/************************************************************************/
int  DeleteTrajectoryInfo()
/************************************************************************/
{
      trajectory_info.traj_file[0] = '\0';
      trajectory_info.natom = 0;
      trajectory_info.nstep = 0;
      trajectory_info.time_bw_steps    = 0;
      trajectory_info.time_first_frame = 0;
      trajectory_info.first_frame      = 0;
      trajectory_info.last_frame       = 0;
      trajectory_info.delta_frame      = 0;

      return(0);
}

