/*  

                       Copyright (c) 1990 by:
        Leif Laaksonen , VTT/Biotechnical laboratory, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <ctype.h>

#include "maxdefs.h"

#define MAX(a,b)  ( ( a ) > (b) ? (a) : (b))
#define MIN(a,b)  ( ( a ) < (b) ? (a) : (b))
#define Rabs(a)    ( ( a ) > 0 ? (a) : -(a))

/*  externals    */

     extern char scr_data[];
     extern char parsed[MAXparse][MAXlinel];
     extern FILE *RetFilePoint();

     extern struct StreamST {
     char CHARMM[BUFF_LEN];
     char VSS[BUFF_LEN];
     char ICON8[BUFF_LEN];
     char PROBESURF[BUFF_LEN];
     char DENSITY[BUFF_LEN];};

     extern struct StreamST StreamerInfo;
/*               */


/***********************************************************************/
int read_streamer(type_file)
     char *type_file;               /* name of streamer file to be read */
/***********************************************************************/
{

     char input[MAXlinel];
     char text[MAXlinel];
     char chelp[BUFF_LEN];
     char OutText[BUFF_LEN];
     FILE *par_p;

     par_p = RetFilePoint(type_file);

     if(!par_p) return(1);

/*   We are ready now to start reading.
     First line HAS to start with a "*". 
*/

#ifdef DEBUG
     sprintf(OutText,"Reading streamer-file: %s ...",chelp);
     PrintMessage(OutText);
#endif

/* 1 line */
     fgets(input,MAXlinel,par_p);   /*    read first line and check for "*" */
     if(input[0] != '*') {
     sprintf(OutText,"\n>>>>>> First line in a par-file has to start with a '*'-sign <<<<<<");
     PrintMessage(OutText);
     return (1); }

/*  read rest of the file (main loop)    */

     while(fgets(input,MAXlinel,par_p) != NULL) {
     if(strncasecmp(input,"*charmm",7) == 0) {
       if(fgets(input,MAXlinel,par_p) != NULL) {
                  if(input[strlen(input) - 1] == '\n') 
                       input[strlen(input) - 1] = '\0';
                  strncpy(StreamerInfo.CHARMM,input,BUFF_LEN);}
       else
                  return(1);}
     if(strncasecmp(input,"*vss",4) == 0) {
       if(fgets(input,MAXlinel,par_p) != NULL) {
                  if(input[strlen(input) - 1] == '\n') 
                       input[strlen(input) - 1] = '\0';
                  strncpy(StreamerInfo.VSS,input,BUFF_LEN);}
       else
                  return(1);}
     if(strncasecmp(input,"*icon8",6) == 0) {
       if(fgets(input,MAXlinel,par_p) != NULL) {
                  if(input[strlen(input) - 1] == '\n') 
                       input[strlen(input) - 1] = '\0';
                  strncpy(StreamerInfo.ICON8,input,BUFF_LEN);}
       else
                  return(1);}
     if(strncasecmp(input,"*probesurf",10) == 0) {
       if(fgets(input,MAXlinel,par_p) != NULL) {
                  if(input[strlen(input) - 1] == '\n') 
                       input[strlen(input) - 1] = '\0';
                  strncpy(StreamerInfo.PROBESURF,input,BUFF_LEN);}
       else
                  return(1);}
     if(strncasecmp(input,"*density",8) == 0) {
       if(fgets(input,MAXlinel,par_p) != NULL) {
                  if(input[strlen(input) - 1] == '\n') 
                       input[strlen(input) - 1] = '\0';
                  strncpy(StreamerInfo.DENSITY,input,BUFF_LEN);}
       else
                  return(1);}
     }

     fclose(par_p);

#ifdef DEBUG
     printf("STREAMER definitions ...\n\n");
     printf("CHARMM   : '%s' \n",StreamerInfo.CHARMM);
     printf("VSS      : '%s' \n",StreamerInfo.VSS);
     printf("ICON8    : '%s' \n",StreamerInfo.ICON8);
     printf("PROBESURF: '%s' \n",StreamerInfo.PROBESURF);
     printf("DENSITY  : '%s' \n",StreamerInfo.DENSITY);
#endif
     return (0);
}

