/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include <ctype.h>
#ifdef sgi
#include <gl/gl.h>
#include <gl/sphere.h>
#endif
#include "maxdefs.h"

#define INPUT_LINE BUFF_LEN

#define SHOW_TEXT_SERIES()      { sprintf(text,"*%d*", \
                                 (play_dynam_frames.obs_vec_curr+1)); \
            retv = show_text(text,txt_param.txfont,txt_param.txcolor, \
                                                   txt_param.txtsize, \
                                                    0.92 , 0.53 ,     \
                                                   BACKBUFFER);}

#define Clean_Up()       { if(graf_dist_list.num > 0) \
                            free(graf_dist_list.list); \
                            graf_dist_list.num = 0; \
                            calc_neigh = 0;}

#define CHANGE_COLOR(i)   {  if(CurMaterial == 22) {\
                             lmcolor(LMC_DIFFUSE);\
                             RGBcolor((short)atmcol[i][0],\
                                      (short)atmcol[i][1],\
                                      (short)atmcol[i][2]);\
                             lmcolor(LMC_COLOR);}}

#define Rabs(a)    ( ( a ) > 0.0 ? (a) : -(a))

#define ROTATE(a,b) rotateO(a,b) /* use own rotation function */
#define TRANSLATE(a,b,c) translateO(a,b,c) /* use own translation function */

    extern int DeleteContoursAll();
    extern void rotateO();
    extern void translateO();
    extern void PrintMessage();
    extern void iso_release_memory();
    extern void send_command();
    extern void draw_other_stuff();
    extern int  DeleteRDF();
    extern float *vector();
    extern int   *ivector();
    extern float *vector_add();
    extern short *svector();
    extern short *svector_add();
    extern int  Show_Form_StereoMode();
    extern int LookRepField();
    extern int ShouldIDrawObject();
    extern int PushAtomToLDP(int Watom , char *seg , char *res , char *atom);
    extern int DeleteLDPList();
    extern int name_to_rgb();
    extern char *LookForPar();
    extern int  ShowLDPwindID();
    extern void HandleWinShut();
    extern int ShowCLUSTERwindID();
    extern int ResetLDPBounds();
    extern int ChangeLDPBounds();
    extern int ResetClusterBounds();
    extern int ChangeClusterBounds();
    extern int ShowRealStereo();

    extern short BLUEv[];
    extern short REDv[];
    extern short obcolor[];
    extern int term_type;
    extern int draw_obj_disp;
    extern int ldp_wind;
    extern int rama_wind;
    extern int indexo();
    extern int trace_wind; /* = 0 , no display , = 1 trace display */
    extern char *disp_list;
    extern int disp_obj[];
    extern int **atmcol;
    extern short line_width;
    extern int alpha_trace;
    extern int CurMaterial;
    extern float sumx,sumy,sumz;
    extern float near,far;
    extern int cyl_seg;
    extern float pia;
    extern float vcylinder[MAXcylp][3];
    extern int cluster_wind;

/* structur containing pointers to dynamics display variables */
    extern struct dyna_disp_var {
      int numset;             /* number of sets (or variables) */
      int current_set;        /* index to current set          */
      int point_len;          /* length of point array         */
      int *point_vec;         /* pointer to point array        */
      int dist_len;           /* length of dist array          */
      int *dist_vec;          /* pointer to dist array         */
      int ang_len;            /* length of angle array         */
      int *ang_vec;           /* pointer to angle array        */
      int tors_len;           /* length of torsion array       */
      int *tors_vec;          /* pointer to torsion array      */
      int obs_vec_len;        /* observation array length      */
      int obs_vec_curr;       /* display current               */
      float *obs_vec;};       /* pointer to observation array  */

    extern struct dyna_disp_var play_dynam_frames;

/* structure to hold the trace of atoms       */

   extern struct {
    int trace_on;        /* switch to indicate that a trace is saved (=1)   */
    int trace_sets;      /* number of trace sets                            */
    int trace_step;      /* step length                                     */
    int *trace_atoms;    /* number of traced atoms in each set              */
    int *trace_list;     /* list of atoms to be traced                      */
    float *trx;          /* array to contain the x coordinates of the trace */
    float *try;
    float *trz;} trace_info;

    extern short BOX;

    struct {
      int corr_wind;   /* switch to indicate that window is on = 1 , off = 0 */
      int corr_vec1;   /* number of correlation vector 1 */
      int corr_vec2;   /* number of correlation vector 2 */
      int corr_obs;    /* number of points in vectors 1 and 2 */
      float *corr_val;} /* pointer to the correlation values */  
    corr_info;

/* contour structure */
     extern int    ContoursDefined;   /* number of contours defined */

     extern struct Contour_Struct {
     float *data;           /* contour data */
     float min;
     float max;
     int xdim;
     int ydim;
     int zdim;
     float Xtrans;
     float Ytrans;
     float Ztrans;
     float Xscale;
     float Yscale;
     float Zscale;
     float ColVal[MAX_CONT];
     int   NumVal;
     char  ColNam[MAX_CONT][BUFF_LEN];
     char  ContFile[BUFF_LEN];
     float AlphaBlend;
     int   ContSmooth;
     char  Name[BUFF_LEN];
     int   Display;} ContourInfo[MAX_CONTOURS];

/* structure to contain information about window update */
   extern struct {
     int MainW;      /* Main window          */
     int LDPW;       /* Distance plot window */
     int Rama;       /* Ramachandran plot    */
     int Cluster;    /* Cluster plot         */
   } WUpdate;

    extern  int *phi_i;  /* index array to phi torsion angle array */
    extern  int *psi_i;  /* index array to psi torsion angle array */
    extern  int *omega_i;  /* index array to omega torsion angle array */
    extern  int phi_e;     /* length of array */
    extern  int psi_e;
    extern  int omega_e;
    extern  int *resi_num; /* residue numbers */
    extern  float *phi_v;  /* the real values */
    extern  float *psi_v;
    extern  float *omega_v;

    extern struct {
    int txcolor[3]; /* text colour , default white */
    char txfont[BUFF_LEN]; /*text font */
    float  txtsize; /* text size */} txt_param;

   extern struct et {
   int step_nr;
   float time_in_fs;
   float tote;
   float kine;
   float pote;
   float temp;
   float bond;
   float angl;
   float dihe;
   float impr;
   float vdw;
   float elec;
   float hbond;
   float charm; };

   extern struct et *traj_energy;


   struct {
    int   tote_set;
    int   kine_set;
    int   pote_set;
    int   temp_set;
    int   bond_set;
    int   angl_set;
    int   dihe_set;
    int   impr_set;
    int   vdw_set;
    int   elec_set;
    int   hbond_set;
    int   charm_set;
   float min_tote;
   float max_tote;
   float min_kine;
   float max_kine;
   float min_pote;
   float max_pote;
   float min_temp;
   float max_temp;
   float min_bond;
   float max_bond;
   float min_angl;
   float max_angl;
   float min_dihe;
   float max_dihe;
   float min_impr;
   float max_impr;
   float min_vdw;
   float max_vdw;
   float min_elec;
   float max_elec;
   float min_hbond;
   float max_hbond;
   float min_charm;
   float max_charm; } traj_energy_limits ;

   extern int et_count;

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

   extern int current_struct;

    extern struct flush_dist_list {
     int num;
     int *list;};

    extern struct flush_dist_list graf_dist_list;

    extern int calc_neigh;   /* = 0 no calculation , > 0 calculation */

/* pointers for force calculation */

     extern struct force_struct {
     int    set;  /* switch if the forces are set = 0 , not != 0, yes */
     int   plot;  /* switch for a plot = 0 , no plot , != 0 a plot */
     float  *fx;  /* pointers to the forces */
     float  *fy;
     float  *fz;
     int *sel_list; /* selection list */
     int  ent_list; /* entries in the selection list */
     float scale; /* scale factor */
     int   maxfi; /* index of max force atom */
     float maxfa; /* value of the max force  */
     int   minfi; /* index on min force atom */
     float minfa; /* value of the min force  */ } atm_force; 

     extern struct {
       int set;          /* = 0 , colouring not set , > 0 colouring set */
       float max;
       float min;}   charge_color;

/* define the different menus which are in use */
      extern struct MuList {
        int SaveMenu;
        int Menu;          /* = 1 , display main menu
                              = 2 , display dynamics menu
                              = 3 , display ldp menu
                           */
                     } MenuList;

    extern  struct {
       int    Mean;                   /* != 0 average is calulated  */
       int    Plot;                   /* != 0 plot is on            */
       int    Set;                    /* != 0 collection is on      */
       int    Numbers;                /* number of observations     */
       float *XValues;                /* X - pointer to values      */
       float *YValues;                /* Y - pointer to values      */
     } RaDiFu;


/*
      Scarecrow is using the following Projection Transformations

      0 => Scarecrow is using ortho
      1 =>                    perspective
*/
      extern struct Projection {
       int Fovy;           /* in tenths of degrees */
       int Transformation; } Model;

       extern struct {
         float Angle;       /* rotation angle */
         float Translate;   /* translation from the centre */
         int   Active;      /* == 0 off , != 0 on */
         int   Set;         /* == 0 reset , != do not reset */
                  } StereoPlot;

     extern float *x;
      extern float *y;
       extern float *z;

     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern int term_type;

    int rama_plot_char;   /* = 0 , plot a character , = 1 , plot 
                             as amino acid number */

    int keyb_command;     /* if > 0 , the coommand comes from the keyboard */

    struct {
    int plot_color_scale; /* = 0 , off , != 0 on */
    int which_plot;       /* = 0 no plot,
                               1 force plot,
                               2 charge plot
                          */
    int num_level; } scale_plot;

    struct LineSeg {
      int    Show;           /* if != 0 show the lines     */
      int    Lines;          /* number of lines            */
      float *LineCoord;      /* pointer to the coordinates */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
    } PlotLine = { 0 , 0 , NULL , NULL , NULL , NULL};

    struct SphereSeg {
      int    Show;             /* if != 0 show the sphere      */
      int    Spheres;          /* number of spheres            */
      float *SphereCoord;      /* pointer to the coordinates   */
      float *Radius;           /* pointer to sphere radius     */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
      float *Alpha;
    } PlotSphere = { 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL};

    struct PlaneSeg {
      int    Show;             /* if != 0 show the plane       */
      int    Planes;           /* number of planes             */
      float *PlaneCoord;       /* pointer to the coordinates   */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
      float *Alpha;
    } PlotPlane = { 0 , 0 , NULL , NULL , NULL , NULL , NULL};

    struct {
      int NumCurves;
      int Step;
      int *NumObs;
      float *Xvalues;
      float *Yvalues;
      float *Zvalues;} PlotCurves = { 0 , 100 , NULL , NULL , NULL ,NULL};

    struct CylinderSeg {
      int    Show;           /* if != 0 show the cylinders       */
      int    Cylinders;          /* number of cylinders          */
      float *CylinderCoord;      /* pointer to the coordinates   */
      float *CylinderRad;        /* cylinder radius              */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
      float *Alpha;
    } PlotCylinder = { 0 , 0 , NULL , NULL , NULL , NULL , NULL , NULL};

    struct {
      int  OnOff;
      float Xsize;
      float Ysize;
      float Zsize;
      float Xplace;
      float Yplace;
      float Zplace;
    } BoxInfo = { 0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0};

    struct {
     int PlotDist;
     int PlotAng;
     int PlotTors;
    } PlotVariables = { 0 , 0 , 0};
    
    int  PlotLineBall();
    int  CheckContourName();
    int  SplitColourLine();
    void DeleteRamachandranStuff();
    void DeleteClusterStuff();

    int PlotDistObj();
    int PlotAngleObj();
    int PlotTorsionObj();
    int TurnOFFObjPlot();

/************************************************************************/
plot_fac(input,num)   /* plot command */
   char *input; 
   int num;
/************************************************************************/
{

     int i;
     char OutText[BUFF_LEN];
     float help1,help2,help3,help4;
     static char *lusage1 = "\n\
******************* plot facility ***********************************\n\
 plot  angl*e list                            ! Plot the angle list\n\
      -ang*le                                 ! Turn the angle plot off\n\
       clus*ter                               ! Plot a cluster matrix\n\
      -clu*ster                               ! Turn the cluster plot off\n\
       corr*elation seriesnumber              ! Plot corr series 'nr'  \n\
      -cor*relation                           ! Delete plot and scratch space \n\
       cont*our tag [level colour ...]        ! Plot a contour plot \n\
      -con*tour [tag]                         ! Turn contour plot(s) off \n\
       curv*e file.name                       ! Plot curve from file \n\
      -cur*ve                                 ! Delete curve plot \n\
       cyli*nder[(col)] x1:y1:z1 x2:y2:z2 rad [appe*nd] ! Plot a cylinder\n\
      -cyl*nder                               ! Delete cylinder plot\n\
       dist*ance list                         ! Plot distance list\n\
      -dis*tance                              ! Turn the dist plot off\n\
       forc*e [seg:res:atm]                   ! Plot atom forces  \n\
      -for*ce                                 ! Delete force plot \n\
       ldp                                    ! Plot linear distance plot \n\
      -ldp                                    ! Delete ldp plot \n\
       line[(col)] x1:y1:z2 x2:y2:z2 [append] ! Plot line from 1 to 2\n";
      static char *lusage2 = "\
      -lin*e                                  ! Turn plot of line off \n\
      -nei*ghbours                            ! Turn neigbhbour display off\n\
       plan*e x1:y1:z1 x2:y2:z2 x3:y3:z3 x4:y4:z4 [appe*nd] \n\
      -pla*ne                                 ! Turn plot of plane off \n\
       poin*t file.name                       ! Plot points from file \n\
       rdf                                    ! Plot the RDF\n\
      -rdf                                    ! Delete the RDF plot \n\
       rama*chandran [char/num]               ! Plot a Ramachandran plot \n\
      -ram*achandran                          ! Delete scratch space \n\
       scal*e alt [nlevels min max]           ! Plot colour scale \n\
      -sca*le                                 ! Remove scale plot \n\
       sphe*re[(col)] x:y:z rad [appe*nd]     ! Plot sphere at x,y z and rad\n\
      -sph*ere                                ! Delete the sphere plot\n\
       ster*eo                                ! Show stereo panel\n\
      -ste*reo                                ! Turn stereo display off\n\
       tors*ion list                          ! Plot torsion list\n\
      -tor*ion                                ! Turn the torsion plot off\n\
       trac*e                                 ! Plot atom trace    \n\
      -tra*ce                                 ! Delete plot and scratch space \n\
       time*series                            ! Plot time series \n\
      -tim*eseries                            ! Delete plot and scratch space\n\
";
  

#ifdef sgi

/* help text                                  */
   if(indexo(parsed[1],"?") == 1) {
     printf("%s\n",lusage1);
     printf("%s",lusage2);
     return;
   }

/* check first if graphics is allowed ... */
   if(term_type != 1 && term_type != 3) {
     printf("?ERROR - there is no graphics available/on \n");
     return;}
 
/* switch to small characters                 */
     toller(parsed[1]);

/* plot points                                */
   if(indexo(parsed[1],"poin") == 1) {
     plot_points(parsed[2]);
     return;}

/* plot curve                                  */
    if(indexo(parsed[1],"curv") == 1) {
      plot_curve(parsed[2]);
      return;}
    if(indexo(parsed[1],"-cur") == 1) {
      FreePlotCurves();
      return;}

/* plot a contour plot                         */
    if(indexo(parsed[1],"cont") == 1) {

/* chack that name exists                      */
       i = CheckContourName(parsed[2]);

       if(i < 0) {
         PrintMessage("?ERROR - no contours defined or wrong name");
         return;}

       if(parsed[3][0] != '\0')
                               DefIsoLevel(i);
      if(ContourInfo[i].NumVal < 1) {
        PrintMessage("?ERROR - no contours defined ");
        return;}
       ContourInfo[i].Display = 1;
       return;}

    if(indexo(parsed[1],"-con") == 1) {
/* chack that name exists                      */

       if(parsed[2][0] == '\0') {
         (void) DeleteContoursAll();
          return;}

       i = CheckContourName(parsed[2]);

       if(i < 0) {
         PrintMessage("?ERROR - no contours defined or wrong name");
         return;}

      if(ContourInfo[i].NumVal < 1) {
        PrintMessage("?ERROR - no contours defined to turn off");
        return;}

      (void) DeleteContour(i);

       iso_release_memory();
       return;}

/* plot timeseries                                  */
    if(indexo(parsed[1],"time") == 1) {
      disp_obj[0] = 1;
      Clean_Up();
      return;}

    if(indexo(parsed[1],"-tim") == 1) {
      disp_obj[0] = 0;
      study_dynamics(45);
      return;}

/* plot trace                                  */
    if(indexo(parsed[1],"trac") == 1) {
      if(trace_info.trace_on == 0) {
        printf("?ERROR - no trace defined/calculated \n");
        return;}
      BOX = 1;
      draw_obj_disp = 1;
      trace_wind = 1;
      Clean_Up();
/* turn the atom display off */
      for(i = 0 ; i < mliste[0] ; i++) disp_list[i] = 0;
      return;}

    if(indexo(parsed[1],"-tra") == 1) {
     if(trace_info.trace_on == 1) {
     free(trace_info.trx);   
      free(trace_info.try);   
       free(trace_info.trz);   
        free(trace_info.trace_list);
         free(trace_info.trace_atoms);
         trace_info.trace_atoms = 0;
     trace_info.trace_on = 0;
     trace_wind = 0;
     draw_obj_disp = 1;
/* turn atom display on    */
      for(i = 0 ; i < mliste[0] ; i++) disp_list[i] = 1;
     return;}
     else {
     printf("?ERROR - no trace to be deleted \n");
      return;}
     }

/* ramachandran */
   if(indexo(parsed[1],"rama") == 1 ) {
       rama_plot_char = 0; /* default plot character */
       rama_wind = 1;
       draw_obj_disp = ShouldIDrawObject();
       WUpdate.Rama = 1;
       toller(parsed[2]);
       Clean_Up();
       if(indexo(parsed[2],"char") == 1) {
         rama_plot_char = 0;
         return;}
       if(indexo(parsed[2],"num") == 1) {
         rama_plot_char = 1;
         return;}

   return;}
   if(indexo(parsed[1],"-ram") == 1) {
     (void)DeleteRamachandranStuff();
        if(UsingMultiWindowing())
          (void)HandleWinShut(ShowRAMAwindID());
     return;}

/* plot ldp                                   */
   if(indexo(parsed[1],"ldp") == 1) {
     ldp_wind = 1;
     WUpdate.LDPW  = 1;                   /* need to update ldp stuff */
     draw_obj_disp = ShouldIDrawObject();
     Clean_Up();
               if(MenuList.Menu != 3) {
                  MenuList.SaveMenu = MenuList.Menu;
                  MenuList.Menu = 3;}

     (void)LookRepField( 2 , parsed[2]);
     
     (void) PushAtomToLDP( 1 , parsed[2] , parsed[3] , parsed[4]);
     (void) PushAtomToLDP( 2 , parsed[5] , parsed[6] , parsed[7]);
     return;}

   if(indexo(parsed[1],"-ldp") == 1) {
         draw_obj_disp = 1;
         ldp_wind = 0;
         WUpdate.LDPW  = 0;
         alpha_trace = 0;
         (void)DeleteLDPList();
        if(UsingMultiWindowing())
           (void)HandleWinShut(ShowLDPwindID());
     Clean_Up();
      MenuList.Menu = MenuList.SaveMenu; /* put old value back */
     return;}

/* plot correlation                           */
   if(indexo(parsed[1],"corr") == 1) {
     if(corr_info.corr_obs < 1) {
       printf("?ERROR - no correlation analyzis to be displayed \n");
       return;}
     keyb_command = 1;
     corr_info.corr_wind = 1;
     Clean_Up();
     study_dynamics(21);
     return;}

   if(indexo(parsed[1],"-cor") == 1) {
     corr_info.corr_wind = 0;
     corr_info.corr_obs = 0;
     free(corr_info.corr_val);
     return;}

/* plot colour scale                          */
      if(indexo(parsed[1],"scal") == 1) {
        toller(parsed[2]);

      scale_plot.which_plot = 0;

/* force */
        if(indexo(parsed[2],"forc") == 1) {
          if(atm_force.set == 0) {
            printf("?ERROR - no forces set to be coloured \n");
            return;}
          scale_plot.which_plot = 1;
        }
/* charge */
        if(indexo(parsed[2],"char") == 1) {
          if(charge_color.set == 0) {
            printf("?ERROR - no charges set to be coloured \n");
            return;}
          scale_plot.which_plot = 2;
        }
/* tote */
        if(indexo(parsed[2],"tote") == 1) {
          if(traj_energy_limits.tote_set == 0) {
            printf("?ERROR - no total energy set to be coloured \n");
            return;}
          scale_plot.which_plot = 3;
        }
/* kine */
        if(indexo(parsed[2],"kine") == 1) {
          if(traj_energy_limits.kine_set == 0) {
            printf("?ERROR - no kinetic energy set to be coloured \n");
            return;}
          scale_plot.which_plot = 4;
        }
/* pote */
        if(indexo(parsed[2],"pote") == 1) {
          if(traj_energy_limits.pote_set == 0) {
            printf("?ERROR - no potential energy set to be coloured \n");
            return;}
          scale_plot.which_plot = 5;
        }
/* temp */
        if(indexo(parsed[2],"temp") == 1) {
          if(traj_energy_limits.temp_set == 0) {
            printf("?ERROR - no temperature set to be coloured \n");
            return;}
          scale_plot.which_plot = 6;
        }

        scale_plot.plot_color_scale = 1;
        scale_plot.num_level = atoi(parsed[3]);
        if(scale_plot.num_level < 1) scale_plot.num_level = 5;
        if(parsed[4][0] != '\0' &&
           parsed[5][0] != '\0') {
/* make new colouring */
          switch(scale_plot.which_plot) {
                case 1: /* force */
                        atm_force.set = 2; /* min max supplied */
                        atm_force.minfa = atof(parsed[4]);
                        atm_force.maxfa = atof(parsed[5]);
                        colour_by_force();
                        break;
		case 2: /* charge */
                        charge_color.max = atof(parsed[5]);
                        charge_color.min = atof(parsed[4]);
                        color_by_charge(1);
                        break;
                default:
                        PrintMessage("?ERROR - scale error ");
                        break;}
	}
        return;}

      if(indexo(parsed[1],"-sca") == 1) {
#ifdef sgi
        scale_plot.plot_color_scale = 0;
#else
        printf("?ERROR - not implemented on this device \n");
#endif
        return;}


/* plot force                                 */
    if(indexo(parsed[1],"forc") == 1) {
      if(atm_force.set == 0) {
        printf("?ERROR - no forces set to be displayed \n");
        return;}
      atm_force.plot = 1;
      force_sel_list(parsed[2],parsed[3],parsed[4],parsed[5]);
      return;}

    if(indexo(parsed[1],"-for") == 1) {
      if(atm_force.set == 0) {
        printf("?ERROR - no forces set te be deleted \n");
        return;}
      atm_force.plot = 0;
      atm_force.ent_list = 0;
      free(atm_force.sel_list);
      return;}

   if(indexo(parsed[1],"-nei") == 1) {
     if(graf_dist_list.num < 1) {
       PrintMessage("?ERROR - no neigbours to be deleted");
       return;}
     free(graf_dist_list.list);
      graf_dist_list.num = 0;
       calc_neigh = 0;
        return;}

/* plot rdf                                   */
   if(indexo(parsed[1],"rdf") == 1) {
     if(!RaDiFu.Set) {
              PrintMessage("?ERROR - no RDF defined to be displayed");
	             return;}
      if(term_type == 1 || term_type == 3) {
       if(RaDiFu.Plot) return;
        RaDiFu.Plot = 1;}
     return;}
   if(indexo(parsed[1],"-rdf") == 1) {

     if(!RaDiFu.Set) {
       PrintMessage("?ERROR - no RDF defined to be deleted");
       return;}

      (void)DeleteRDF(); /* delete it */
     return;}

/* plot line                                  */
   if(indexo(parsed[1],"-lin") == 1) {
      DelLineSeg();
       return;}

   if(indexo(parsed[1],"line") == 1) {

          (void)LookRepField( 2 , parsed[2]);

     if(PushLineStack(parsed[2],parsed[3],parsed[4],
                      parsed[5],parsed[6],parsed[7],parsed[8],
                      LookForPar(parsed[1]))) return;
     return;}

/* plot cylinder                                  */
   if(indexo(parsed[1],"-cyl") == 1) {
      DelCylinderSeg();
       return;}

   if(indexo(parsed[1],"cyli") == 1) {
#ifdef sgi

          (void)LookRepField( 2 , parsed[2]);

     if(PushCylinderStack(parsed[2],parsed[3],parsed[4],
                          parsed[5],parsed[6],parsed[7],
                          parsed[8],parsed[9],
                          LookForPar(parsed[1]))) return;
#else
     PrintMessage("?ERROR - Not implemented on this device");
#endif
     return;}

/* plot sphere                                */
    if(indexo(parsed[1],"-sph") == 1) {
       DelSphereSeg();
       return;}

    if(indexo(parsed[1],"sphe") == 1) {
      if(PushSphereStack(parsed[2],parsed[3],parsed[4],parsed[5],parsed[6],
                         LookForPar(parsed[1]))) 
         return;
      return;}

/* plot plane                                */
    if(indexo(parsed[1],"-pla") == 1) {
       DelPlaneSeg();
       return;}

    if(indexo(parsed[1],"plan") == 1) {

          (void)LookRepField( 4 , parsed[2]);

      if(PushPlaneStack(parsed[2],parsed[3],parsed[4],
                        parsed[5],parsed[6],parsed[7],
                        parsed[8],parsed[9],parsed[10],
                        parsed[11],parsed[12],parsed[13],parsed[14],
                        LookForPar(parsed[1]))) 
         return;
      return;}

/* plot stereo                               */
     if(indexo(parsed[1],"ster") == 1) {
#ifdef USEFORMS
        if(term_type == 1) {
           (void)Show_Form_StereoMode();
                 return;}
        StereoPlot.Active = 1;
        return;
#else
      PrintMessage("?ERROR - works only with the forms library");
      return;
#endif
      }

     if(indexo(parsed[1],"-ste") == 1) {
        StereoPlot.Active = 0;
        return;
     }


/* cluster */
   if(indexo(parsed[1],"clus") == 1 ) {
       cluster_wind    = 1;
       draw_obj_disp   = ShouldIDrawObject();
       WUpdate.Cluster = 1;
       Clean_Up();
       return;}

   if(indexo(parsed[1],"-clu") == 1) {
        (void)DeleteClusterStuff();
        if(UsingMultiWindowing())
          (void)HandleWinShut(ShowCLUSTERwindID());
     return;}

/* plot box */
   if(indexo(parsed[1],"box") == 1 ) {
      BoxInfo.OnOff = 1;
      if(parsed[2][0] == '\0') return;
      BoxInfo.Xsize = atof(parsed[2]);
      BoxInfo.Ysize = atof(parsed[3]);
      BoxInfo.Zsize = atof(parsed[4]);
      BoxInfo.Xplace= atof(parsed[5]);
      BoxInfo.Yplace= atof(parsed[6]);
      BoxInfo.Zplace= atof(parsed[7]);
      return;}

   if(indexo(parsed[1],"-box") == 1 ) {
      BoxInfo.OnOff = 0;
   }

   if(indexo(parsed[1],"dist") == 1) {
      toller(parsed[2]);
      if(indexo(parsed[2],"list") == 1) {
      PlotVariables.PlotDist = 1;
      return;}
      if(indexo(parsed[2],"off") == 1) {
      PlotVariables.PlotDist = 0;
      return;}}

   if(indexo(parsed[1],"-dis") == 1) {
      PlotVariables.PlotDist = 0;
      return;}

   if(indexo(parsed[1],"angl") == 1) {
      toller(parsed[2]);
      if(indexo(parsed[2],"list") == 1) {
      PlotVariables.PlotAng = 1;
      return;}
      if(indexo(parsed[2],"off") == 1) {
      PlotVariables.PlotAng = 0;
      return;}}

   if(indexo(parsed[1],"-ang") == 1) {
      PlotVariables.PlotAng = 0;
      return;}

   if(indexo(parsed[1],"tors") == 1) {
      toller(parsed[2]);
      if(indexo(parsed[2],"list") == 1) {
      PlotVariables.PlotTors = 1;
      return;}
      if(indexo(parsed[2],"off") == 1) {
      PlotVariables.PlotTors = 0;
      return;}}

   if(indexo(parsed[1],"-tor") == 1) {
      PlotVariables.PlotTors = 0;
      return;}


/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

#else

     sprintf(OutText,"?ERROR - not implemented on this machine \n");
     PrintMessage(OutText);

#endif

}      /* end of display_fac */

#ifdef sgi

/************************************************************************/
plot_points(file)
     char *file; /* input file name */
/************************************************************************/
{
    FILE *file_p;
    int i;
    static float xyzc[3];
    static char input[BUFF_LEN];

    file_p = fopen(file,"r");
    if(file_p == NULL) {
    printf("?ERROR - can't open file '%s'\n",file);
    return;}

    frontbuffer(TRUE);

    c3s(BLUEv);

    while(fgets(input,INPUT_LINE,file_p) != NULL) {
    sscanf(input,"%f %f %f",&xyzc[0],&xyzc[1],&xyzc[2]);

    if(input[0] == '*') {
      c3s(REDv);
      continue;}
/*
    bgnpoint();
    v3f(xyzc);
    endpoint();
*/
    plot_cross(xyzc[0],xyzc[1],xyzc[2]); }

    frontbuffer(FALSE);

}
/************************************************************************/
plot_curve(file)
     char *file; /* input file name */
/************************************************************************/
{
    FILE *file_p;
    static int i,j,num_points;
    static char input[BUFF_LEN];

    file_p = fopen(file,"r");
    if(file_p == NULL) {
    printf("?ERROR - can't open file '%s'\n",file);
    return;}

/* first line is a comment */
    if(fgets(input,BUFF_LEN,file_p) == NULL) {
       PrintMessage("Can't read input file");
        fclose(file_p);
       return;}
    PrintMessage(input);

    num_points = 0;
    i          = 0;
    j          = PlotCurves.Step;

    if(PlotCurves.NumCurves) {
       FreePlotCurves();}

    PlotCurves.NumObs = ivector(1);
    PlotCurves.Xvalues =  vector(PlotCurves.Step);
     PlotCurves.Yvalues =  vector(PlotCurves.Step);
      PlotCurves.Zvalues =  vector(PlotCurves.Step);

    while(fgets(input,BUFF_LEN,file_p) != NULL) {

        if(i < j) {
                   sscanf(input,"%f %f %f",
                          &PlotCurves.Xvalues[i],
                          &PlotCurves.Yvalues[i],
                          &PlotCurves.Zvalues[i]);
                   }
         else {
                   j +=   PlotCurves.Step;
                   PlotCurves.Xvalues = vector_add(PlotCurves.Xvalues , j);
                   PlotCurves.Yvalues = vector_add(PlotCurves.Yvalues , j);
                   PlotCurves.Zvalues = vector_add(PlotCurves.Zvalues , j);
                   sscanf(input,"%f %f %f",
                          &PlotCurves.Xvalues[i],
                          &PlotCurves.Yvalues[i],
                          &PlotCurves.Zvalues[i]);
                   }

                   PlotCurves.Xvalues[i] -= sumx;
                   PlotCurves.Yvalues[i] -= sumy;
                   PlotCurves.Zvalues[i] -= sumz;
                   i++;
     }

    PlotCurves.NumCurves   = 1;
    PlotCurves.NumObs[0]   = i;
    sprintf(input,"Number of points: %d ",i);
    PrintMessage(input);
    fclose(file_p);
}

#endif

/****************************************************************************/
plot_dyn_obj()
/****************************************************************************/
{
      int iplace,retv;
      char text[BUFF_LEN];

/*
      if(play_dynam_frames.dist_len > 0) 
        draw_dist(play_dynam_frames.dist_len,play_dynam_frames.dist_vec);
     
      if(play_dynam_frames.ang_len > 0)  
        draw_ang(play_dynam_frames.ang_len,play_dynam_frames.ang_vec);

      if(play_dynam_frames.tors_len > 0) 
        draw_tors(play_dynam_frames.tors_len,play_dynam_frames.tors_vec);

*/

      if(play_dynam_frames.obs_vec_len) {
        iplace = play_dynam_frames.numset * play_dynam_frames.obs_vec_curr;
  
        plot_2d(2 , play_dynam_frames.current_set ,
                    play_dynam_frames.numset,
                   &play_dynam_frames.obs_vec[iplace]);

        SHOW_TEXT_SERIES();}

}

/****************************************************************************/
do_colouring(k , alt)
      int k;
      int alt;
/****************************************************************************/
{
        float delta;
        double step;
        int i,rr,gg,bb;

/* always the first molecule */

        switch(alt) {

        case 1:
        delta = traj_energy_limits.max_tote - traj_energy_limits.min_tote;
        step = (traj_energy[k].tote - traj_energy_limits.min_tote) / delta;
        break;
        case 2:
        delta = traj_energy_limits.max_kine - traj_energy_limits.min_kine;
        step = (traj_energy[k].kine - traj_energy_limits.min_kine) / delta;
        break;
        case 3:
        delta = traj_energy_limits.max_pote - traj_energy_limits.min_pote;
        step = (traj_energy[k].pote - traj_energy_limits.min_pote) / delta;
        break;
        case 4:
        delta = traj_energy_limits.max_temp - traj_energy_limits.min_temp;
        step = (traj_energy[k].temp - traj_energy_limits.min_temp) / delta;
        break;
        default:
        printf("?ERROR - wrong 'alt' in 'do_colouring' \n");
        return;
        } 

           pre_rainbow(step,&rr,&gg,&bb);

        for(i = mlists[0] ; i < mliste[0] ; i++) {
           atmcol[i][0] = rr;
           atmcol[i][1] = gg;
           atmcol[i][2] = bb;
	 }
}
/****************************************************************************/
plot_force()
/****************************************************************************/
{
   static int i,j;
   static float vec[6];

#ifdef sgi

   for(j = 0 ; j < atm_force.ent_list ; j++) {
      
   i = atm_force.sel_list[j];

     vec[0] = x[i];
      vec[1] = y[i];
       vec[2] = z[i];

     vec[3] = vec[0] + atm_force.fx[i] / atm_force.scale;
      vec[4] = vec[1] + atm_force.fy[i] / atm_force.scale;
       vec[5] = vec[2] + atm_force.fz[i] / atm_force.scale;

     c3i(atmcol[i]);
     CHANGE_COLOR(i);

     if(PlotLineBall(&vec[0],&vec[3])) {
       PrintMessage("?ERROR - problems in PlotLineBall");
       return;}

      }
      
#else

  printf("?ERROR - not implemented on this device \n");

#endif
   }
/****************************************************************************/
force_sel_list(text1,text2,text3,text4)
         char *text1;
         char *text2;
         char *text3;
         char *text4;
/****************************************************************************/
{
     extern int *ivector();
     extern int atom_list_max();

     register int i;
     static int ihelp,atom_list;
     char chelp[BUFF_LEN];

     atom_list = atom_list_max();

     atm_force.sel_list = ivector(atom_list);

     atm_force.ent_list = select_list(text1,text2,text3,atm_force.sel_list);

     if(atm_force.ent_list == 0) 
       printf("?ERROR - no atoms in the selection list \n"); 
           
}

/****************************************************************************/
DefIsoLevel( CurrCont)
   int CurrCont;
/****************************************************************************/
{

   int i;
   char OutText[BUFF_LEN];

   i = 0;
   while(1) {
     if((i+1) == MAX_CONT) {
       PrintMessage("?ERROR - max contour levels reached\n");
       break;} 
     if(parsed[3+i+i][0] == '\0') break;
     ContourInfo[CurrCont].ColVal[i] = atof(parsed[3+i+i]);
      if(parsed[4+i+i][0] == '\0') strncpy(parsed[4+i+i],"white",BUFF_LEN);
      strncpy(ContourInfo[CurrCont].ColNam[i],parsed[4+i+i],BUFF_LEN);
       sprintf(OutText,"Looking for threshold %f in colour '%s'",
               ContourInfo[CurrCont].ColVal[i],
               ContourInfo[CurrCont].ColNam[i]);
       PrintMessage(OutText);
       i++;}

       ContourInfo[CurrCont].NumVal = i;

 }
#ifdef sgi
/****************************************************************************/
PlotLineBall(StartP,EndP)
    float *StartP;  /* Start point */
    float *EndP;    /* End point   */
/****************************************************************************/
{
    float  al,bl,cl;
    float  Alen;    /* line length      */
    float  vec[6];
#ifdef FAST
    float  param[4];
#endif

    al = EndP[0] - StartP[0];
     bl = EndP[1] - StartP[1];
      cl = EndP[2] - StartP[2];

    Alen = sqrt(al*al + bl*bl + cl*cl);
    

   if(line_width > 2) 
      linewidth(line_width);
   else
      linewidth(2);

bgnline();
     v3f(StartP);
     v3f(EndP);
endline();

      linewidth(line_width);

#ifdef FAST

   param[0] = EndP[0];
    param[1] = EndP[1];
     param[2] = EndP[2];
      param[3] = Alen / 10.;

   if(sphdraw(param) < 0) {
     PrintMessage("?ERROR - error in sphdraw ");
     return(1);}

#endif
     return(0);
}
#endif
/****************************************************************************/
int RaDiFuPlot()
/****************************************************************************/
{
    if(!RaDiFu.Set || !RaDiFu.Numbers) {
      PrintMessage("?ERROR - no RDF to be displayed");
       return(0);}

    return(1);
}



/****************************************************************************/
int PushLineStack(InputP1,InputP2,InputP3,InputP4,InputP5,InputP6,InputP7,
                  InputP8)
    char *InputP1;
    char *InputP2;
    char *InputP3;
    char *InputP4;
    char *InputP5;
    char *InputP6;
    char *InputP7;
    char *InputP8;
/****************************************************************************/
{
#ifdef sgi
    float Xc1,Yc1,Zc1;
    float Xc2,Yc2,Zc2;
    int iappend = 0;
    int Location;
    int LineRed;
    int LineGreen;
    int LineBlue;

    Xc1 = atof(InputP1);
     Yc1 = atof(InputP2);
      Zc1 = atof(InputP3);

    Xc2 = atof(InputP4);
     Yc2 = atof(InputP5);
      Zc2 = atof(InputP6);

    if(InputP8 != NULL) {
       if(isalpha(InputP8[0])) {
         if(name_to_rgb(InputP8 , &LineRed , &LineGreen , &LineBlue)) {
         PrintMessage("?ERROR - can't resolve the colour");
         return(1);}}
       else {
         (void)SplitColourLine(InputP8,&LineRed,&LineGreen,&LineBlue);}}
    else {
       LineRed   = (int)obcolor[0];
       LineGreen = (int)obcolor[1];
       LineBlue  = (int)obcolor[2];}

    if(indexo(InputP7,"appe") == 1) iappend = 1;

    if(!PlotLine.Lines) { /* no old lines */

      if(iappend) 
        PrintMessage("?WARNING - no lines to append to");

      PlotLine.LineCoord = vector(6);
        PlotLine.LineCoord[0]  = Xc1 - sumx;
         PlotLine.LineCoord[1] = Yc1 - sumy;
        PlotLine.LineCoord[2]  = Zc1 - sumz;
        PlotLine.LineCoord[3]  = Xc2 - sumx;
         PlotLine.LineCoord[4] = Yc2 - sumy;
        PlotLine.LineCoord[5]  = Zc2 - sumz;

      PlotLine.Red    = svector(1);
      PlotLine.Green  = svector(1);
      PlotLine.Blue   = svector(1);

      PlotLine.Red[0]    = (short)LineRed;
      PlotLine.Green[0]  = (short)LineGreen;
      PlotLine.Blue[0]   = (short)LineBlue;
      
      PlotLine.Lines     =         1;
      PlotLine.Show      =         1;
      return(0);}
    else {
      if(!iappend) {
       DelLineSeg();
       PlotLine.LineCoord = vector(6);
        PlotLine.LineCoord[0]  = Xc1 - sumx;
         PlotLine.LineCoord[1] = Yc1 - sumy;
        PlotLine.LineCoord[2]  = Zc1 - sumz;
        PlotLine.LineCoord[3]  = Xc2 - sumx;
         PlotLine.LineCoord[4] = Yc2 - sumy;
        PlotLine.LineCoord[5]  = Zc2 - sumz;

      PlotLine.Red    = svector(1);
      PlotLine.Green  = svector(1);
      PlotLine.Blue   = svector(1);

      PlotLine.Red[0]    = (short)LineRed;
      PlotLine.Green[0]  = (short)LineGreen;
      PlotLine.Blue[0]   = (short)LineBlue;

       PlotLine.Lines     =         1;
       PlotLine.Show      =         1;
       return(0);}
      else {
       PlotLine.LineCoord = vector_add(PlotLine.LineCoord,
                                       (PlotLine.Lines + 1) * 6);
        Location = 6 * PlotLine.Lines;
        PlotLine.LineCoord[Location]  = Xc1 - sumx;
         PlotLine.LineCoord[Location + 1] = Yc1 - sumy;
        PlotLine.LineCoord[Location + 2]  = Zc1 - sumz;
        PlotLine.LineCoord[Location + 3]  = Xc2 - sumx;
         PlotLine.LineCoord[Location + 4] = Yc2 - sumy;
        PlotLine.LineCoord[Location + 5]  = Zc2 - sumz;

      PlotLine.Red    = svector_add(PlotLine.Red   , (PlotLine.Lines + 1));
      PlotLine.Green  = svector_add(PlotLine.Green , (PlotLine.Lines + 1));
      PlotLine.Blue   = svector_add(PlotLine.Blue  , (PlotLine.Lines + 1));

      PlotLine.Red[PlotLine.Lines]    = (short)LineRed;
      PlotLine.Green[PlotLine.Lines]  = (short)LineGreen;
      PlotLine.Blue[PlotLine.Lines]   = (short)LineBlue;

       PlotLine.Lines    +=         1;
       PlotLine.Show      =         1;
       return(0);}
      }
#else
      PrintMessage("?ERROR - not implemented on this device");
#endif
}
/****************************************************************************/
void PlotLineSeg()
/****************************************************************************/
{
#ifdef sgi
     int i;
     short LineCol[3];

     if(line_width < 2) linewidth(2);

     if(!PlotLine.Lines) return;

     for(i = 0 ; i < PlotLine.Lines ; i++) {
       LineCol[0] = PlotLine.Red[i];
       LineCol[1] = PlotLine.Green[i];
       LineCol[2] = PlotLine.Blue[i];
     c3s(LineCol);
     bgnline();
         v3f(&PlotLine.LineCoord[6*i]);       
         v3f(&PlotLine.LineCoord[6*i + 3]);
     endline();}

     linewidth(line_width);

#else
     PrintMessage("?ERROR - not implemented on this device");
#endif
}
/****************************************************************************/
DelLineSeg()
/****************************************************************************/
{

#ifdef sgi
       if(PlotLine.Lines) {
          free(PlotLine.LineCoord);
          free(PlotLine.Red);
          free(PlotLine.Green);
          free(PlotLine.Blue);}
       PlotLine.Lines     =         0;
       PlotLine.Show      =         0;

#else
       PrintMessage("?ERROR - not implemented on this device");
#endif
}




/****************************************************************************/
int PushSphereStack(InputP1,InputP2,InputP3,InputP4,InputP5,InputP6)
    char *InputP1;
    char *InputP2;
    char *InputP3;
    char *InputP4;
    char *InputP5;
    char *InputP6;
/****************************************************************************/
{
#ifdef sgi
    float Xc1,Yc1,Zc1;
    float radius;
    int iappend = 0;
    int Location;
    int SphereRed;
    int SphereGreen;
    int SphereBlue;

    Xc1 = atof(InputP1);
     Yc1 = atof(InputP2);
      Zc1 = atof(InputP3);

    radius = atof(InputP4);

    if(InputP6 != NULL) {
       if(isalpha(InputP6[0])) {
         if(name_to_rgb(InputP6 , &SphereRed , &SphereGreen , &SphereBlue)) {
         PrintMessage("?ERROR - can't resolve the colour");
         return(1);}}
       else {
         (void)SplitColourLine(InputP6,&SphereRed,&SphereGreen,&SphereBlue);}}
    else {
       SphereRed   = (int)obcolor[0];
       SphereGreen = (int)obcolor[1];
       SphereBlue  = (int)obcolor[2];}

    if(indexo(InputP5,"appe") == 1) iappend = 1;

    if(!PlotSphere.Spheres) { /* no old lines */

      if(iappend) 
        PrintMessage("?WARNING - no spheres to append to");

      PlotSphere.SphereCoord = vector(3);
      PlotSphere.Radius      = vector(1);
      PlotSphere.Alpha       = vector(1);
        PlotSphere.SphereCoord[0]  = Xc1 - sumx;
         PlotSphere.SphereCoord[1] = Yc1 - sumy;
        PlotSphere.SphereCoord[2]  = Zc1 - sumz;

      PlotSphere.Red    = svector(1);
      PlotSphere.Green  = svector(1);
      PlotSphere.Blue   = svector(1);

      PlotSphere.Red[0]    = (short)SphereRed;
      PlotSphere.Green[0]  = (short)SphereGreen;
      PlotSphere.Blue[0]   = (short)SphereBlue;
      
      PlotSphere.Radius[0] =    radius; 
      PlotSphere.Alpha[0]  =       1.0;
      PlotSphere.Spheres   =         1;
      PlotSphere.Show      =         1;
      return(0);}
    else {
      if(!iappend) {
       DelSphereSeg();
       PlotSphere.SphereCoord = vector(3);
       PlotSphere.Radius      = vector(1);
       PlotSphere.Alpha       = vector(1);
        PlotSphere.SphereCoord[0]  = Xc1 - sumx;
         PlotSphere.SphereCoord[1] = Yc1 - sumy;
        PlotSphere.SphereCoord[2]  = Zc1 - sumz;

      PlotSphere.Red    = svector(1);
      PlotSphere.Green  = svector(1);
      PlotSphere.Blue   = svector(1);

      PlotSphere.Red[0]    = (short)SphereRed;
      PlotSphere.Green[0]  = (short)SphereGreen;
      PlotSphere.Blue[0]   = (short)SphereBlue;
      
       PlotSphere.Radius[0] =    radius; 
       PlotSphere.Alpha[0]  =       1.0;
       PlotSphere.Spheres   =         1;
       PlotSphere.Show      =         1;
       return(0);}
      else {
       PlotSphere.SphereCoord = vector_add(PlotSphere.SphereCoord,
                                       (PlotSphere.Spheres + 1) * 3);
       PlotSphere.Radius      = vector_add(PlotSphere.Radius,
                                       (PlotSphere.Spheres + 1));
       PlotSphere.Alpha       = vector_add(PlotSphere.Alpha,
                                       (PlotSphere.Spheres + 1));
        Location = 3 * PlotSphere.Spheres;
        PlotSphere.SphereCoord[Location]  = Xc1 - sumx;
         PlotSphere.SphereCoord[Location + 1] = Yc1 - sumy;
        PlotSphere.SphereCoord[Location + 2]  = Zc1 - sumz;
       PlotSphere.Radius[PlotSphere.Spheres]  = radius; 
       PlotSphere.Alpha[PlotSphere.Spheres]   = 1.0; 

      PlotSphere.Red    = svector_add(PlotSphere.Red   , 
                                     (PlotSphere.Spheres + 1));
      PlotSphere.Green  = svector_add(PlotSphere.Green , 
                                     (PlotSphere.Spheres + 1));
      PlotSphere.Blue   = svector_add(PlotSphere.Blue  , 
                                     (PlotSphere.Spheres + 1));

      PlotSphere.Red[PlotSphere.Spheres]    = (short)SphereRed;
      PlotSphere.Green[PlotSphere.Spheres]  = (short)SphereGreen;
      PlotSphere.Blue[PlotSphere.Spheres]   = (short)SphereBlue;

       PlotSphere.Spheres  +=         1;
       PlotSphere.Show      =         1;
       return(0);}
      }
#else
      PrintMessage("?ERROR - not implemented on this device");
#endif
}
/****************************************************************************/
void PlotSphereSeg()
/****************************************************************************/
{
#ifdef sgi
     int i;
     float param[4];
     long   parami[4];
     short SphereCol[3];

     if(!PlotSphere.Spheres) return;

     for(i = 0 ; i < PlotSphere.Spheres ; i++) {

     if(PlotSphere.Alpha[i] < 1.0)
        blendfunction(BF_SA , BF_MSA);
        else
        blendfunction(BF_ONE, BF_ZERO);

              lmcolor(LMC_DIFFUSE);

/*
              RGBcolor(PlotSphere.Red[i],
                       PlotSphere.Green[i],
                       PlotSphere.Blue[i]);
*/

     parami[0]    = (int) PlotSphere.Red[i];
      parami[1]   = (int) PlotSphere.Green[i];
       parami[2]  = (int) PlotSphere.Blue[i];
        parami[3] = (int) (PlotSphere.Alpha[i] * 255.);

     c4i(parami);

              lmcolor(LMC_COLOR);

         param[0] = PlotSphere.SphereCoord[3*i];
          param[1] = PlotSphere.SphereCoord[3*i + 1];
           param[2] = PlotSphere.SphereCoord[3*i + 2];
         param[3]    = PlotSphere.Radius[i];
         if(sphdraw(param) < 0) {
            PrintMessage("?ERROR - error in sphdraw");
            return;}
       }

        blendfunction(BF_ONE, BF_ZERO);

#else
     PrintMessage("?ERROR - not implemented on this device");
#endif
}
/****************************************************************************/
DelSphereSeg()
/****************************************************************************/
{

#ifdef sgi
       if(PlotSphere.Spheres) { 
          free(PlotSphere.Red);
          free(PlotSphere.Green);
          free(PlotSphere.Blue);
          free(PlotSphere.SphereCoord);
          free(PlotSphere.Radius);
          free(PlotSphere.Alpha);}
       PlotSphere.Spheres     =         0;
       PlotSphere.Show        =         0;

#else
       PrintMessage("?ERROR - not implemented on this device");
#endif
}


/****************************************************************************/
int PushPlaneStack(InputP1,InputP2,InputP3,
                   InputP4,InputP5,InputP6,
                   InputP7,InputP8,InputP9,
                   InputP10,InputP11,InputP12,
                   InputP13,InputP14)
    char *InputP1;
    char *InputP2;
    char *InputP3;
    char *InputP4;
    char *InputP5;
    char *InputP6;
    char *InputP7;
    char *InputP8;
    char *InputP9;
    char *InputP10;
    char *InputP11;
    char *InputP12;
    char *InputP13;
    char *InputP14;
/****************************************************************************/
{
#ifdef sgi
    float Xc1,Yc1,Zc1;
    float Xc2,Yc2,Zc2;
    float Xc3,Yc3,Zc3;
    float Xc4,Yc4,Zc4;
    int iappend = 0;
    int Location;
    int PlaneRed;
    int PlaneGreen;
    int PlaneBlue;

    Xc1 = atof(InputP1);
     Yc1 = atof(InputP2);
      Zc1 = atof(InputP3);

    Xc2 = atof(InputP4);
     Yc2 = atof(InputP5);
      Zc2 = atof(InputP6);

    Xc3 = atof(InputP7);
     Yc3 = atof(InputP8);
      Zc3 = atof(InputP9);

    if(InputP10[0] != '\0') {
     Xc4 = atof(InputP10);
      Yc4 = atof(InputP11);
       Zc4 = atof(InputP12);}
    else {
     Xc4 = Xc3;
      Yc4 = Yc3;
       Zc4 = Zc3;}

    if(InputP14 != NULL) {
       if(isalpha(InputP14[0])) {
         if(name_to_rgb(InputP14 , &PlaneRed , &PlaneGreen , &PlaneBlue)) {
         PrintMessage("?ERROR - can't resolve the colour");
         return(1);}}
       else {
         (void)SplitColourLine(InputP14,&PlaneRed,&PlaneGreen,&PlaneBlue);}}
    else {
       PlaneRed   = (int)obcolor[0];
       PlaneGreen = (int)obcolor[1];
       PlaneBlue  = (int)obcolor[2];}

    if(indexo(InputP13,"appe") == 1) iappend = 1;

    if(!PlotPlane.Planes) { /* no old Planes */

      if(iappend) 
        PrintMessage("?WARNING - no Planes to append to");

      PlotPlane.PlaneCoord = vector(12);
        PlotPlane.PlaneCoord[0]   = Xc1 - sumx;
         PlotPlane.PlaneCoord[1]  = Yc1 - sumy;
          PlotPlane.PlaneCoord[2] = Zc1 - sumz;
        PlotPlane.PlaneCoord[3]   = Xc2 - sumx;
         PlotPlane.PlaneCoord[4]  = Yc2 - sumy;
          PlotPlane.PlaneCoord[5] = Zc2 - sumz;
        PlotPlane.PlaneCoord[6]   = Xc3 - sumx;
         PlotPlane.PlaneCoord[7]  = Yc3 - sumy;
          PlotPlane.PlaneCoord[8] = Zc3 - sumz;
        PlotPlane.PlaneCoord[9]   = Xc4 - sumx;
         PlotPlane.PlaneCoord[10] = Yc4 - sumy;
          PlotPlane.PlaneCoord[11]= Zc4 - sumz;

      PlotPlane.Red    = svector(1);
      PlotPlane.Green  = svector(1);
      PlotPlane.Blue   = svector(1);

      PlotPlane.Alpha  = vector(1);

      PlotPlane.Red[0]    = (short)PlaneRed;
      PlotPlane.Green[0]  = (short)PlaneGreen;
      PlotPlane.Blue[0]   = (short)PlaneBlue;

      PlotPlane.Alpha[0]  = 1.0;
      
      PlotPlane.Planes     =         1;
      PlotPlane.Show       =         1;
      return(0);}
    else {
      if(!iappend) {
       DelPlaneSeg();
       PlotPlane.PlaneCoord = vector(12);
        PlotPlane.PlaneCoord[0]   = Xc1 - sumx;
         PlotPlane.PlaneCoord[1]  = Yc1 - sumy;
        PlotPlane.PlaneCoord[2]   = Zc1 - sumz;
        PlotPlane.PlaneCoord[3]   = Xc2 - sumx;
         PlotPlane.PlaneCoord[4]  = Yc2 - sumy;
        PlotPlane.PlaneCoord[5]   = Zc2 - sumz;
        PlotPlane.PlaneCoord[6]   = Xc3 - sumx;
         PlotPlane.PlaneCoord[7]  = Yc3 - sumy;
        PlotPlane.PlaneCoord[8]   = Zc3 - sumz;
        PlotPlane.PlaneCoord[9]   = Xc4 - sumx;
         PlotPlane.PlaneCoord[10] = Yc4 - sumy;
        PlotPlane.PlaneCoord[11]  = Zc4 - sumz;

      PlotPlane.Red    = svector(1);
      PlotPlane.Green  = svector(1);
      PlotPlane.Blue   = svector(1);

      PlotPlane.Alpha  = vector(1);

      PlotPlane.Red[0]    = (short)PlaneRed;
      PlotPlane.Green[0]  = (short)PlaneGreen;
      PlotPlane.Blue[0]   = (short)PlaneBlue;
      
      PlotPlane.Alpha[0]  = 1.0;

       PlotPlane.Planes     =         1;
       PlotPlane.Show       =         1;
       return(0);}
      else {
       PlotPlane.PlaneCoord = vector_add(PlotPlane.PlaneCoord,
                                       (PlotPlane.Planes + 1) * 12);
        Location = 12 * PlotPlane.Planes;
        PlotPlane.PlaneCoord[Location]       = Xc1 - sumx;
         PlotPlane.PlaneCoord[Location + 1]  = Yc1 - sumy;
        PlotPlane.PlaneCoord[Location + 2]   = Zc1 - sumz;
        PlotPlane.PlaneCoord[Location + 3]   = Xc2 - sumx;
         PlotPlane.PlaneCoord[Location + 4]  = Yc2 - sumy;
        PlotPlane.PlaneCoord[Location + 5]   = Zc2 - sumz;
        PlotPlane.PlaneCoord[Location + 6]   = Xc3 - sumx;
         PlotPlane.PlaneCoord[Location + 7]  = Yc3 - sumy;
        PlotPlane.PlaneCoord[Location + 8]   = Zc3 - sumz;
        PlotPlane.PlaneCoord[Location + 9]   = Xc4 - sumx;
         PlotPlane.PlaneCoord[Location + 10] = Yc4 - sumy;
        PlotPlane.PlaneCoord[Location + 11]  = Zc4 - sumz;

      PlotPlane.Red    = svector_add(PlotPlane.Red   , (PlotPlane.Planes + 1));
      PlotPlane.Green  = svector_add(PlotPlane.Green , (PlotPlane.Planes + 1));
      PlotPlane.Blue   = svector_add(PlotPlane.Blue  , (PlotPlane.Planes + 1));

      PlotPlane.Alpha  = vector_add(PlotPlane.Alpha  , (PlotPlane.Planes + 1));

      PlotPlane.Red[PlotPlane.Planes]    = (short)PlaneRed;
      PlotPlane.Green[PlotPlane.Planes]  = (short)PlaneGreen;
      PlotPlane.Blue[PlotPlane.Planes]   = (short)PlaneBlue;

      PlotPlane.Alpha[PlotPlane.Planes]  = 1.0;

       PlotPlane.Planes    +=         1;
       PlotPlane.Show       =         1;
       return(0);}
      }
#else
      PrintMessage("?ERROR - not implemented on this device");
#endif
}
/****************************************************************************/
void PlotPlaneSeg()
/****************************************************************************/
{
#ifdef sgi
     int i;
     short PlaneCol[3];
     long  PlaneColo[4];

     if(!PlotPlane.Planes) return;

     for(i = 0 ; i < PlotPlane.Planes ; i++) {

   if(PlotCylinder.Alpha[i] < 1.0)
      blendfunction(BF_SA , BF_MSA);
      else
      blendfunction(BF_ONE, BF_ZERO);
   
    lmcolor(LMC_DIFFUSE);
/*
       PlaneCol[0] = PlotPlane.Red[i];
       PlaneCol[1] = PlotPlane.Green[i];
       PlaneCol[2] = PlotPlane.Blue[i];
     c3s(PlaneCol);
*/
       PlaneColo[0] = (long)PlotPlane.Red[i];
       PlaneColo[1] = (long)PlotPlane.Green[i];
       PlaneColo[2] = (long)PlotPlane.Blue[i];
       PlaneColo[3] = (long)(PlotPlane.Alpha[i] * 255.);

       c4i(PlaneColo);
    
    lmcolor(LMC_COLOR);

     bgnpolygon();
         v3f(&PlotPlane.PlaneCoord[12*i]);       
         v3f(&PlotPlane.PlaneCoord[12*i + 3]);
         v3f(&PlotPlane.PlaneCoord[12*i + 6]);
         v3f(&PlotPlane.PlaneCoord[12*i + 9]);
     endpolygon();}

#else
     PrintMessage("?ERROR - not implemented on this device");
#endif
}
/****************************************************************************/
DelPlaneSeg()
/****************************************************************************/
{

#ifdef sgi
       if(PlotPlane.Planes) {
          free(PlotPlane.PlaneCoord);
          free(PlotPlane.Alpha);
          free(PlotPlane.Red);
          free(PlotPlane.Green);
          free(PlotPlane.Blue);}
       PlotPlane.Planes     =         0;
       PlotPlane.Show       =         0;

#else
       PrintMessage("?ERROR - not implemented on this device");
#endif
}

/****************************************************************************/
FreePlotCurves()
/****************************************************************************/
{
    if(PlotCurves.NumCurves) {
      free(PlotCurves.NumObs);
      free(PlotCurves.Xvalues);
      free(PlotCurves.Yvalues);
      free(PlotCurves.Zvalues);
      PlotCurves.NumCurves = 0;}
    else {
    PrintMessage("?ERROR - nothing to free in 'FreePlotCurves'");}
  }

/****************************************************************************/
PlotCurves2Screen()
/****************************************************************************/
{

#ifdef sgi
      register int i;
      register float v3[3];
 
   if(line_width > 2) 
      linewidth(line_width);
   else
      linewidth(2);

       c3s(obcolor);
       bgnline();
       for(i = 0 ; i < PlotCurves.NumObs[0] ; i++) {
         v3[0] = PlotCurves.Xvalues[i];
          v3[1] = PlotCurves.Yvalues[i];
           v3[2] = PlotCurves.Zvalues[i];
        v3f(v3);}
       endline();

      linewidth(line_width);
#else
       PrintMessage("?ERROR - not implemented on this device");
#endif
    }
#ifdef sgi
/****************************************************************************/
int PushCylinderStack(InputP1,InputP2,InputP3,InputP4,InputP5,InputP6,InputP7,
                      InputP8,InputP9)
    char *InputP1;
    char *InputP2;
    char *InputP3;
    char *InputP4;
    char *InputP5;
    char *InputP6;
    char *InputP7;
    char *InputP8;
    char *InputP9;
/****************************************************************************/
{
#ifdef sgi
    float Xc1,Yc1,Zc1;
    float Xc2,Yc2,Zc2;
    float Radius;
    int iappend = 0;
    int Location;
    int CylinderRed;
    int CylinderGreen;
    int CylinderBlue;

    Xc1 = atof(InputP1);
     Yc1 = atof(InputP2);
      Zc1 = atof(InputP3);

    Xc2 = atof(InputP4);
     Yc2 = atof(InputP5);
      Zc2 = atof(InputP6);

    Radius = atof(InputP7);


    if(InputP9 != NULL) {
       if(isalpha(InputP9[0])) {
         if(name_to_rgb(InputP9 , &CylinderRed , 
                                  &CylinderGreen , 
                                  &CylinderBlue)) {
         PrintMessage("?ERROR - can't resolve the colour");
         return(1);}}
       else {
         (void)SplitColourLine(InputP9,&CylinderRed,
                                       &CylinderGreen,
                                       &CylinderBlue);}}
    else {
       CylinderRed   = (int)obcolor[0];
       CylinderGreen = (int)obcolor[1];
       CylinderBlue  = (int)obcolor[2];}

    if(indexo(InputP8,"appe") == 1) iappend = 1;

    if(!PlotCylinder.Cylinders) { /* no old Cylinders */

      if(iappend) 
        PrintMessage("?WARNING - no Cylinders to append to");

      PlotCylinder.CylinderCoord = vector(6);
        PlotCylinder.CylinderCoord[0]  = Xc1 - sumx;
         PlotCylinder.CylinderCoord[1] = Yc1 - sumy;
        PlotCylinder.CylinderCoord[2]  = Zc1 - sumz;
        PlotCylinder.CylinderCoord[3]  = Xc2 - sumx;
         PlotCylinder.CylinderCoord[4] = Yc2 - sumy;
        PlotCylinder.CylinderCoord[5]  = Zc2 - sumz;
      PlotCylinder.CylinderRad   = vector(1);
      PlotCylinder.CylinderRad[0]= Radius;

      PlotCylinder.Alpha     =  vector(1);
      PlotCylinder.Alpha[0]  =  1.0;

      PlotCylinder.Red    = svector(1);
      PlotCylinder.Green  = svector(1);
      PlotCylinder.Blue   = svector(1);

      PlotCylinder.Red[0]    = (short)CylinderRed;
      PlotCylinder.Green[0]  = (short)CylinderGreen;
      PlotCylinder.Blue[0]   = (short)CylinderBlue;
      
      PlotCylinder.Cylinders     =         1;
      PlotCylinder.Show          =         1;
      return(0);}
    else {
      if(!iappend) {
       DelCylinderSeg();
       PlotCylinder.CylinderCoord = vector(6);
        PlotCylinder.CylinderCoord[0]  = Xc1 - sumx;
         PlotCylinder.CylinderCoord[1] = Yc1 - sumy;
        PlotCylinder.CylinderCoord[2]  = Zc1 - sumz;
        PlotCylinder.CylinderCoord[3]  = Xc2 - sumx;
         PlotCylinder.CylinderCoord[4] = Yc2 - sumy;
        PlotCylinder.CylinderCoord[5]  = Zc2 - sumz;
      PlotCylinder.CylinderRad   = vector(1);
      PlotCylinder.CylinderRad[0]= Radius;

      PlotCylinder.Alpha     =  vector(1);
      PlotCylinder.Alpha[0]  =  1.0;

      PlotCylinder.Red    = svector(1);
      PlotCylinder.Green  = svector(1);
      PlotCylinder.Blue   = svector(1);

      PlotCylinder.Red[0]    = (short)CylinderRed;
      PlotCylinder.Green[0]  = (short)CylinderGreen;
      PlotCylinder.Blue[0]   = (short)CylinderBlue;
      
       PlotCylinder.Cylinders     =         1;
       PlotCylinder.Show          =         1;
       return(0);}
      else {
       PlotCylinder.CylinderCoord = vector_add(PlotCylinder.CylinderCoord,
                                       (PlotCylinder.Cylinders + 1) * 6);
        Location = 6 * PlotCylinder.Cylinders;
        PlotCylinder.CylinderCoord[Location]      = Xc1 - sumx;
         PlotCylinder.CylinderCoord[Location + 1] = Yc1 - sumy;
        PlotCylinder.CylinderCoord[Location + 2]  = Zc1 - sumz;
        PlotCylinder.CylinderCoord[Location + 3]  = Xc2 - sumx;
         PlotCylinder.CylinderCoord[Location + 4] = Yc2 - sumy;
        PlotCylinder.CylinderCoord[Location + 5]  = Zc2 - sumz;
       PlotCylinder.CylinderRad = vector_add(PlotCylinder.CylinderRad,
                                       (PlotCylinder.Cylinders + 1));
       PlotCylinder.CylinderRad[PlotCylinder.Cylinders]= Radius;

       PlotCylinder.Alpha = vector_add(PlotCylinder.Alpha,
                                       (PlotCylinder.Cylinders + 1));
       PlotCylinder.Alpha[PlotCylinder.Cylinders]= 1.0;

      PlotCylinder.Red    = svector_add(PlotCylinder.Red   , 
                                       (PlotCylinder.Cylinders + 1));
      PlotCylinder.Green  = svector_add(PlotCylinder.Green , 
                                       (PlotCylinder.Cylinders + 1));
      PlotCylinder.Blue   = svector_add(PlotCylinder.Blue  , 
                                       (PlotCylinder.Cylinders + 1));

      PlotCylinder.Red[PlotCylinder.Cylinders]    = (short)CylinderRed;
      PlotCylinder.Green[PlotCylinder.Cylinders]  = (short)CylinderGreen;
      PlotCylinder.Blue[PlotCylinder.Cylinders]   = (short)CylinderBlue;

       PlotCylinder.Cylinders    +=         1;
       PlotCylinder.Show          =         1;
       return(0);}
      }
#else
      PrintMessage("?ERROR - not implemented on this device");
#endif
}
/****************************************************************************/
DelCylinderSeg()
/****************************************************************************/
{

#ifdef sgi
       if(PlotCylinder.Cylinders) {
          free(PlotCylinder.Red);
          free(PlotCylinder.Green);
          free(PlotCylinder.Blue);
          free(PlotCylinder.CylinderCoord);
          free(PlotCylinder.Alpha);
          free(PlotCylinder.CylinderRad);}
       PlotCylinder.Cylinders     =         0;
       PlotCylinder.Show          =         0;

#else
       PrintMessage("?ERROR - not implemented on this device");
#endif
}



/***********************************************************************/
void PlotCylinderSeg()   /* display the molecule as liquorice */
/***********************************************************************/
{


   register int i,cyl;
   static int lookup,kc;
   static float div_rad;
   static float vec[6],vecc[4][3],rad;
   static float n0[6];
   static float alpha,beta,diffx,diffy,diffz,zproj;
   static float cyl_rot[3][3],cyl_rotm[3][3];
   static float cosa,sina;
   static float xi,yi,zi;
   static float xk,yk,zk;
   static int from,to;
   static int in_blend = 0;
   static long parami[4];


   in_blend = 0;
/*
     if(material[9] < 1.0) {
     backface(FALSE);
     in_blend = 1;
     blendfunction(BF_SA, BF_ONE);}
*/


   from = 0;
   to   = PlotCylinder.Cylinders;


/* throw out the cylinders */

   for(i = from ; i < to ; i++ ) {

   if(PlotCylinder.Alpha[i] < 1.0)
      blendfunction(BF_SA , BF_MSA);
      else
      blendfunction(BF_ONE, BF_ZERO);
   
    lmcolor(LMC_DIFFUSE);
/*
    RGBcolor( PlotCylinder.Red[i],
              PlotCylinder.Green[i],
              PlotCylinder.Blue[i]);
*/
     parami[0]    = (long) PlotCylinder.Red[i];
      parami[1]   = (long) PlotCylinder.Green[i];
       parami[2]  = (long) PlotCylinder.Blue[i];
        parami[3] = (long) (PlotCylinder.Alpha[i] * 255.);

        c4i(parami);
    
    lmcolor(LMC_COLOR);

   build_cylinder( cyl_seg , PlotCylinder.CylinderRad[i]);
   rad = PlotCylinder.CylinderRad[i];  /* radius of the cylinder */
   div_rad = 1.0 / rad;


   xi = PlotCylinder.CylinderCoord[6 * i];
    yi = PlotCylinder.CylinderCoord[6 * i + 1];
     zi = PlotCylinder.CylinderCoord[6 * i + 2];

    vec[0]=xi;
     vec[1]=yi;
      vec[2]=zi;

  
   xk = PlotCylinder.CylinderCoord[6 * i + 3];
    yk = PlotCylinder.CylinderCoord[6 * i + 4];
     zk = PlotCylinder.CylinderCoord[6 * i + 5];

   diffx = xk-xi;
   diffy = yk-yi;
   diffz = zk-zi;

/*  rotate first alpha degrees around the z-axis to get the x-axis along
    the vector r(i,j) (the projection on the x-y plane) */
 
   if(Rabs(diffx) > 1.e-05) {
   alpha = atan(diffy/diffx);}
   else  alpha = pia/2.;
/*   if(diffy < 0.0 && diffx < 0.0) alpha = alpha + pia; */

#ifdef sgi
   cosa = fcos(alpha);
    sina = fsin(alpha);
#else
   cosa = cos((double)alpha);
    sina = sin((double)alpha);
#endif

   cyl_rot[0][0]=  cosa;
   cyl_rot[0][1]=  sina;
   cyl_rot[0][2]=  0.0;
   cyl_rot[1][0]= -sina;
   cyl_rot[1][1]=  cosa;
   cyl_rot[1][2]=  0.0;
   cyl_rot[2][0]=  0.0;
   cyl_rot[2][1]=  0.0;
   cyl_rot[2][2]=  1.0;

   zproj = sqrt( diffx*diffx + diffy*diffy);

/*  rotate now beta degrees around the y-axis to get the x' axis to point along
    the vector r(i,j,k) */

   
   if(Rabs(zproj) > 1.e-05) {
   beta = atan(diffz/zproj);}
   else beta = pia/2.;

   if(diffx < 0.0) beta =  pia - beta; 

#ifdef sgi
   cosa = fcos(beta);
    sina = fsin(beta);
#else
   cosa = cos((double)beta);
    sina = sin((double)beta);
#endif

   cyl_rotm[0][0]=   cosa;  /* + */
   cyl_rotm[0][1]=  0.0;
   cyl_rotm[0][2]=   sina;  /* - */
   cyl_rotm[1][0]=  0.0;
   cyl_rotm[1][1]=  1.0;
   cyl_rotm[1][2]=  0.0; 
   cyl_rotm[2][0]=  -sina;  /* + */
   cyl_rotm[2][1]=  0.0;
   cyl_rotm[2][2]=  cosa;   /* + */


   mult3(cyl_rotm,cyl_rot);

/* cyl_rot contains now the rotation matrix */

/* start rotating around x' to construct the cylinder */

   lookup=0;

   for(cyl = 1 ; cyl < cyl_seg ; cyl++) {

  bgnpolygon();

   mult4(vcylinder[lookup],cyl_rot,vec);
   vecc[0][0] = vec[0] + xi;
    vecc[0][1] = vec[1] + yi;
     vecc[0][2] = vec[2] + zi;

   n0[0] = vec[0] * div_rad;
    n0[1] = vec[1] * div_rad;
     n0[2] = vec[2] * div_rad;

    n3f(n0); v3f(vecc[0]);

   vecc[1][0] = vec[0] + xk;
    vecc[1][1] = vec[1] + yk;
     vecc[1][2] = vec[2] + zk;

    n3f(n0); v3f(vecc[1]);

   kc=lookup+1;
   mult4(vcylinder[kc],cyl_rot,vec);
   vecc[2][0] = vec[0] + xk;
    vecc[2][1] = vec[1] + yk;
     vecc[2][2] = vec[2] + zk;

   n0[0] = vec[0] * div_rad;
    n0[1] = vec[1] * div_rad;
     n0[2] = vec[2] * div_rad;

    n3f(n0); v3f(vecc[2]);

   vecc[3][0] = vec[0] + xi;
    vecc[3][1] = vec[1] + yi;
     vecc[3][2] = vec[2] + zi;

    n3f(n0); v3f(vecc[3]);

    endpolygon();

   lookup++;}
  
} 

     blendfunction(BF_ONE, BF_ZERO);
 }

/***********************************************************************/
void PlotStereo()
/***********************************************************************/
{
   static float saveMV[4][4];
   static float savePV[4][4];

   if(IsStereoON()) { /*   REAL STEREO   */

   (void) ShowRealStereo();

   }

   else {
   if(Model.Transformation) {
       mmode(MPROJECTION);
         getmatrix(savePV);}

   mmode(MVIEWING);
    getmatrix(saveMV); /* save transformation matrix */

         TRANSLATE(   -StereoPlot.Translate , 0.0 , 0.0);
         ROTATE((short)StereoPlot.Angle     , 'y'      );

         draw_obj();
         draw_other_stuff();

   if(Model.Transformation) {
       mmode(MPROJECTION);
         loadmatrix(savePV);
   
       mmode(MVIEWING);}

     loadmatrix(saveMV);

         TRANSLATE(     StereoPlot.Translate , 0.0 , 0.0);
         ROTATE(-(short)StereoPlot.Angle     , 'y'      );

         draw_obj();
         draw_other_stuff();

   if(Model.Transformation) {
       mmode(MPROJECTION);
         loadmatrix(savePV);
   
       mmode(MVIEWING);}

     loadmatrix(saveMV);}

   return;
}
#endif
/***********************************************************************/
int  CheckContourName(CName)
     char * CName;
/***********************************************************************/
{
     int i;

     if(ContoursDefined < 1) return(-1);

     for(i = 0 ; i < ContoursDefined ; i++) {

        if(!strncmp(CName,ContourInfo[i].Name,BUFF_LEN) &&
            strlen(CName) == strlen(ContourInfo[i].Name)) return(i);

     }

     return(-1); /* name not in the list */
}
/***********************************************************************/
int DeleteContour(ContNumb)
    int ContNumb;
/***********************************************************************/
{
       if(ContNumb < 0 || ContNumb > ContoursDefined) {
         PrintMessage("?ERROR - can't delete defined contour");
         return;}

       ContourInfo[ContNumb].Display = 0;
       ContourInfo[ContNumb].NumVal  = 0;
/*       free(ContourInfo[ContNumb].data); */
}
/***********************************************************************/
int  SplitColourLine(char *InputP , int *LineRed, int *LineGreen , 
                                    int *LineBlue) 
/***********************************************************************/
{
       char OutText[BUFF_LEN];
       char ColPar[MAXparse][MAXlinel];
       int ColI;

       own_parser(InputP,ColPar,&ColI,SEP_STRING);

            if(ColI < 1) {
              PrintMessage("?ERROR - error in colour parser");
                 *LineRed    = 255;
                  *LineGreen = 255;
                   *LineBlue = 255;
                 return;}

              *LineRed    = atoi(ColPar[0]);
               *LineGreen = atoi(ColPar[1]);
                *LineBlue = atoi(ColPar[2]);

         return;}

/***********************************************************************/
void DeleteRamachandranStuff()
/***********************************************************************/
{
    if(phi_e == 0 && psi_e == 0 && omega_e == 0) {
     PrintMessage("?ERROR - no ramachandran plot to delete");
     return;}

               draw_obj_disp = 1;
               rama_wind = 0;
               phi_e = psi_e = omega_e = 0;
               free(phi_v);
               free(psi_v);
               free(omega_v);
               free(phi_i);
               free(psi_i);
               free(omega_i);
               free(resi_num);
}
/***********************************************************************/
void DeleteClusterStuff()
/***********************************************************************/
{
               draw_obj_disp = 1;
               cluster_wind  = 0;
}

/****************************************************************************/
int PlotDistObj()
/****************************************************************************/
{

   if(play_dynam_frames.dist_len > 0) {
      draw_dist(play_dynam_frames.dist_len,play_dynam_frames.dist_vec);

    return(0);}
   else
    return(1);
	
}
/****************************************************************************/
int PlotAngleObj()
/****************************************************************************/
{

   if(play_dynam_frames.ang_len > 0)  {
        draw_ang(play_dynam_frames.ang_len,play_dynam_frames.ang_vec);

    return(0);}
   else
    return(1);
	
}
/****************************************************************************/
int PlotTorsionObj()
/****************************************************************************/
{

   if(play_dynam_frames.tors_len > 0) {
        draw_tors(play_dynam_frames.tors_len,play_dynam_frames.tors_vec);

    return(0);}
   else
    return(1);
	
}


/************************************************************************/
int TurnOFFObjPlot()
/************************************************************************/
{
    PlotVariables.PlotDist   = 0;
    PlotVariables.PlotAng    = 0;
    PlotVariables.PlotTors   = 0;

    return(0);
}
