/*

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "maxdefs.h"
#include "filemask.h"

#ifdef USEFORMS
#include "../forms/FORMS/forms.h"

  FL_FORM *FormDynFile;

  FL_FORM *PPROBE;

  FL_FORM *FL_Text_Input;

  FL_FORM *FL_Text_Edit;

  FL_OBJECT *Pobj1;
  FL_OBJECT *PXMin;
  FL_OBJECT *PXMax;
  FL_OBJECT *PYMin;
  FL_OBJECT *PYMax;
  FL_OBJECT *PZMin;
  FL_OBJECT *PZMax;
  FL_OBJECT *PPX;
  FL_OBJECT *PPY;
  FL_OBJECT *PPZ;
  FL_OBJECT *PPval;
  FL_OBJECT *PGo;
  FL_OBJECT *PQuit;
  FL_OBJECT *Pbutton;

  FL_FORM *PDENSITY;

  FL_OBJECT *Dobj1;
  FL_OBJECT *DXMin;
  FL_OBJECT *DXMax;
  FL_OBJECT *DYMin;
  FL_OBJECT *DYMax;
  FL_OBJECT *DZMin;
  FL_OBJECT *DZMax;
  FL_OBJECT *DPX;
  FL_OBJECT *DPY;
  FL_OBJECT *DPZ;
  FL_OBJECT *DMORBITAL;
  FL_OBJECT *DMORBITAL_D;
  FL_OBJECT *DMORBITAL_TD;
  FL_OBJECT *Dorbital;
  FL_OBJECT *WFfile;
  FL_OBJECT *DGo;
  FL_OBJECT *DQuit;
  FL_OBJECT *Dbutton;

  FL_OBJECT *CHARMMobj;
  FL_OBJECT *DISCOVERobj;
  FL_OBJECT *YASPobj;
  FL_OBJECT *MUMODobj;
  FL_OBJECT *GROMOSobj;
  FL_OBJECT *AMBERobj;
  FL_OBJECT *HYPERCHEMobj;
  FL_OBJECT *FLtrajfile;
  FL_OBJECT *TGo;
  FL_OBJECT *TQuit;
  FL_OBJECT *Tbutton;
  FL_OBJECT *Tfiles;

  FL_FORM *FrmReadFile;

  FL_OBJECT *FLReadFile;
  FL_OBJECT *CHARMMfile;
  FL_OBJECT *INSIGHTfile;
  FL_OBJECT *PDBfile;
  FL_OBJECT *YASPfile;
  FL_OBJECT *MOPACfile;
  FL_OBJECT *DYNframe;
  FL_OBJECT *MUMODfile;
  FL_OBJECT *GROMOSfile;
  FL_OBJECT *AMBERfile;
  FL_OBJECT *HYPERCHEMfile;
  FL_OBJECT *FileAppend;
  FL_OBJECT *FileGo;
  FL_OBJECT *FileQuit;
  FL_OBJECT *MoreFiles;
  FL_OBJECT *FileButton;

  FL_OBJECT *FL_Text_Browser;
  FL_OBJECT *FL_Text_Size;
  FL_OBJECT *FL_Text_Accept;
  FL_OBJECT *FL_Text_Cancel;
  FL_OBJECT *FL_Text_Color;
  FL_OBJECT *FL_Text_String;

  FL_OBJECT *FL_Text_Browser_Edit_String;
  FL_OBJECT *FL_Text_Browser_Edit;
  FL_OBJECT *FL_Text_Size_Edit;
  FL_OBJECT *FL_Text_Accept_Edit;
  FL_OBJECT *FL_Text_Cancel_Edit;
  FL_OBJECT *FL_Text_Color_Edit;
  FL_OBJECT *FL_Text_String_Edit;
  FL_OBJECT *FL_Text_Edit_Move;



  FL_FORM   *FL_Edit_Colour_Form;
  FL_OBJECT *FL_Edit_Colour_Button;
  FL_OBJECT *FL_Edit_Colour_Red;
  FL_OBJECT *FL_Edit_Colour_Green;
  FL_OBJECT *FL_Edit_Colour_Blue;
  FL_OBJECT *FL_Edit_Colour_Redtext;
  FL_OBJECT *FL_Edit_Colour_Greentext;
  FL_OBJECT *FL_Edit_Colour_Bluetext;
  FL_OBJECT *FL_Edit_Colour_Result;
  FL_OBJECT *FL_Edit_Colour_Quit;

  FL_FORM   *FL_Read_Dictionary;

  FL_OBJECT *FL_Read_Dic;
  FL_OBJECT *FL_Read_Dic_Filename;
  FL_OBJECT *FL_Read_Dic_Go;
  FL_OBJECT *FL_Read_Dic_Quit;
  FL_OBJECT *FL_Read_Dic_Files;


  FL_FORM *MaskPanel;

  FL_OBJECT *  FL_Mask_Coord_Charmm;
  FL_OBJECT *  FL_Mask_Coord_YASP;
  FL_OBJECT *  FL_Mask_Coord_Insight;
  FL_OBJECT *  FL_Mask_Coord_PDB;
  FL_OBJECT *  FL_Mask_Coord_MUMOD;
  FL_OBJECT *  FL_Mask_Coord_MOPAC;
  FL_OBJECT *  FL_Mask_Coord_HYPERCHEM;

  FL_OBJECT *  FL_Mask_Traj_Charmm;
  FL_OBJECT *  FL_Mask_Traj_Discover;
  FL_OBJECT *  FL_Mask_Traj_YASP;
  FL_OBJECT *  FL_Mask_Traj_MUMOD;
  FL_OBJECT *  FL_Mask_Traj_HYPERCHEM;

  FL_OBJECT *  FL_Mask_Accept;
  FL_OBJECT *  FL_Mask_Cancel;

  FL_FORM   *FL_StereoMode;

  FL_OBJECT *FL_Stereo_SMax;
  FL_OBJECT *FL_Stereo_SMin;
  FL_OBJECT *FL_Stereo_VS;
  FL_OBJECT *FL_Stereo_AMax;
  FL_OBJECT *FL_Stereo_AMin;
  FL_OBJECT *FL_Stereo_VA;
  FL_OBJECT *FL_Stereo_Return;
  FL_OBJECT *FL_Stereo_ON_OFF;


    extern struct SURF_LIM {
    int set;             /* = 0 , not set , > 0 set */
    float Xmin;
    float Xmax;
    float Ymin;
    float Ymax;
    float Zmin;
    float Zmax;
    char  MeshFile[BUFF_LEN];
    char  WFFile[BUFF_LEN];
    float ProbeVal;
    int Orbital;
    int Dmethod;
    int Xpts;
    int Ypts;
    int Zpts;
                   } ;

    extern struct SURF_LIM DENSITY_limits;
    extern struct SURF_LIM PROBE_limits;
    extern struct SURF_LIM VSS_limits;

    extern char traj_file[];

  extern int  traj_file_set;        /* switch for trajectory file set/not set 
                                    0 ==> file is not set
                                    1 ==> charmm trajectory
                                    2 ==> discover trajectory
                                    3 ==> amber trajectory
                                    4 ==> yasp trajectory
                                    5 ==> mumod trajectory
                                    6 ==> gromos trajectory
                                    7 ==> hyperchem trajectory
                                 */

   extern int   force_type;     /* type of force field
                                = 0 , undefined
                                = 1 , CHARMM
                                = 2 , DISCOVER
                                = 3 , AMBER 
                                = 4 , YASP 
                                = 5 , MUMOD
                                = 6 , GROMOS
                                = 7 , HyperChem */

/* structure for the dynamics trajectory file */

   extern struct {
   char traj_file[BUFF_LEN];                 /* file name          */
   int natom;                                /* number of atoms    */
   int nstep;                                /* number of steps    */
   int time_bw_steps;                        /* time between steps */
   int time_first_frame;                     /* time of first frame */
   int first_frame;                          /* first frame to be displayed */
   int last_frame;                           /* last frame to be displayed  */
   int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     


   extern  struct FM_FONTS_AVAIL {
      int  Numbers;                /* number of fonts defined */
      int  NumCharacters;          /* number of characters for storage */
      char *FontString;} FM_fonts;

     extern int col_tbl_max;  /* number of entries in the colour table */
     extern int col_tbl_high;

     extern struct SCARE_col_table {
     int red;      /* read value */
     int green;    /* green value */
     int blue;     /* blue value */
     char name[MAX_COL_LEN]; } ;

     extern struct SCARE_col_table *col_table;  /* colour table pointer */

     extern int indexo();
     extern void toller();
     extern void RedrawScreen();
     extern void bang_it();

     extern int display_text; /* display text if > 0 */

     extern char   *RetunTextString();
     extern char   *ReturnTextFont();
     extern int    *ReturnTextColour();
     extern float  *ReturnTextPosition();
     extern float   ReturnTextSize();
     extern int     ReturnTextEntries();

     extern int     PutTextString();
     extern int     PutTextFont();
     extern int     PutTextSize();
     extern int     PutTextColour();
     extern int     PutTextPosition();

     extern void    get_xy();

     extern void push_input_stack();

       extern struct {
         float Angle;       /* rotation angle */
         float Translate;   /* translation from the centre */
         int   Active;      /* == 0 off , != 0 on */
         int   Set;         /* == 0 reset , != do not reset */
                  } StereoPlot;

     extern float near;
     extern float far;

void create_form_1()
{
  PPROBE = fl_bgn_form(FL_NO_BOX,600.0,590.0);
  Pobj1 = fl_add_box(FL_UP_BOX,0.0,0.0,600.0,590.0,"");
  Pobj1 = 
    fl_add_text(FL_NORMAL_TEXT,70.0,550.0,410.0,40.0,"Probe Surface input");
    fl_set_object_lsize(Pobj1,FL_LARGE_FONT);
    fl_set_object_lstyle(Pobj1,FL_BOLD_STYLE);
  PXMin = fl_add_input(FL_NORMAL_INPUT,70.0,490.0,170.0,40.0,"X min");
  PYMin = fl_add_input(FL_NORMAL_INPUT,70.0,410.0,170.0,40.0,"Y min");
  PZMin = fl_add_input(FL_NORMAL_INPUT,70.0,330.0,170.0,40.0,"Z min");
  PXMax = fl_add_input(FL_NORMAL_INPUT,320.0,490.0,170.0,40.0,"X max");
  PYMax = fl_add_input(FL_NORMAL_INPUT,320.0,410.0,170.0,40.0,"Y max");
  PZMax = fl_add_input(FL_NORMAL_INPUT,320.0,330.0,170.0,40.0,"Z max");
  PPX =   fl_add_input(FL_NORMAL_INPUT,70.0,240.0,170.0,40.0,"Xpts");
  PPY =   fl_add_input(FL_NORMAL_INPUT,70.0,160.0,170.0,40.0,"Ypts");
  PPZ =   fl_add_input(FL_NORMAL_INPUT,70.0,80.0,170.0,40.0,"Zpts");
  PPval = fl_add_input(FL_NORMAL_INPUT,70.0,20.0,170.0,40.0,"Probe");
  PGo =   fl_add_button(FL_NORMAL_BUTTON,340.0,180.0,100.0,90.0,"Go ");
  PQuit = fl_add_button(FL_NORMAL_BUTTON,340.0,40.0,100.0,90.0,"Quit");
  fl_end_form();
}
void create_form_2()
{
  FL_OBJECT *obj;

  PDENSITY = fl_bgn_form(FL_NO_BOX,600.0,590.0);
  Dobj1 = fl_add_box(FL_UP_BOX,0.0,0.0,600.0,590.0,"");
  Dobj1 = 
    fl_add_text(FL_NORMAL_TEXT,70.0,550.0,410.0,40.0,"Orbital/Density input");
    fl_set_object_lsize(Dobj1,FL_LARGE_FONT);
    fl_set_object_lstyle(Dobj1,FL_BOLD_STYLE);
  DXMin = fl_add_input(FL_NORMAL_INPUT,70.0,490.0,170.0,40.0,"X min");
  DYMin = fl_add_input(FL_NORMAL_INPUT,70.0,410.0,170.0,40.0,"Y min");
  DZMin = fl_add_input(FL_NORMAL_INPUT,70.0,330.0,170.0,40.0,"Z min");
  DXMax = fl_add_input(FL_NORMAL_INPUT,320.0,490.0,170.0,40.0,"X max");
  DYMax = fl_add_input(FL_NORMAL_INPUT,320.0,410.0,170.0,40.0,"Y max");
  DZMax = fl_add_input(FL_NORMAL_INPUT,320.0,330.0,170.0,40.0,"Z max");
  DPX =   fl_add_input(FL_NORMAL_INPUT,70.0,240.0,170.0,40.0,"Xpts");
  DPY =   fl_add_input(FL_NORMAL_INPUT,70.0,160.0,170.0,40.0,"Ypts");
  DPZ =   fl_add_input(FL_NORMAL_INPUT,70.0,80.0,170.0,40.0,"Zpts");
  WFfile =fl_add_input(FL_NORMAL_INPUT,70.0,20.0,170.0,40.0,"WF file");
  Dorbital = fl_add_input(FL_NORMAL_INPUT,320.0,240.0,170.0,40.0,"Orb nr");
  DGo =   fl_add_button(FL_NORMAL_BUTTON,320.0,20.0,100.0,90.0,"Go ");
  DQuit = fl_add_button(FL_NORMAL_BUTTON,450.0,20.0,100.0,90.0,"Quit");
  DMORBITAL = 
     fl_add_roundbutton(FL_RADIO_BUTTON,320.0,200.0,40.0,40.0,"Orbital plot");
  DMORBITAL_D   =
     fl_add_roundbutton(FL_RADIO_BUTTON,320.0,160.0,40.0,40.0,"Orbital el. density");
  DMORBITAL_TD = 
     fl_add_roundbutton(FL_RADIO_BUTTON,320.0,120.0,40.0,40.0,"Total el. density");
  fl_end_form();
}


void create_form_3()
{
  FL_OBJECT *obj1;
  FL_OBJECT *obj2;
  FormDynFile = fl_bgn_form(FL_NO_BOX,360.0,510.0);
  obj1 = fl_add_box(FL_UP_BOX,0.0,0.0,360.0,510.0,"");
  FLtrajfile = 
        fl_add_input(FL_NORMAL_INPUT,10.0,320.0,350.0,40.0,"File name");
  obj2 = fl_add_text(FL_NORMAL_TEXT,20.0,390.0,380.0,60.0,"Define trajectory file");
    fl_set_object_lsize(obj2,FL_LARGE_FONT);
  CHARMMobj = 
            fl_add_roundbutton(FL_RADIO_BUTTON,40.0,210.0,40.0,40.0,"CHARMM");
  DISCOVERobj = 
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,170.0,40.0,40.0,"DISCOVER");
  YASPobj = 
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,10.0,40.0,40.0,"YASP");
  MUMODobj=
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,50.0,40.0,40.0,"MUMOD");
  AMBERobj=
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,250.0,40.0,40.0,"AMBER");
  GROMOSobj=
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,130.0,40.0,40.0,"GROMOS");
  HYPERCHEMobj=
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,90.0,40.0,40.0,"HYPERCHEM");

  TGo =   fl_add_roundbutton(FL_NORMAL_BUTTON,200.0,200.0,100.0,90.0,"Go ");
  TQuit = fl_add_roundbutton(FL_NORMAL_BUTTON,200.0,100.0,100.0,90.0,"Quit");
  Tfiles= fl_add_button(FL_NORMAL_BUTTON,210.0,30.0,50.0,50.0,"Files");
  fl_end_form();
}
void create_form_4()
{
  FL_OBJECT *obj1;
  FL_OBJECT *obj2;
  FrmReadFile = fl_bgn_form(FL_NO_BOX,360.0,550.0);
  obj1 = fl_add_box(FL_UP_BOX,0.0,0.0,360.0,550.0,"");
  obj1 =
         fl_add_box(FL_FRAME_BOX,38.0,8.0,37.0,411.0,"");
  FLReadFile = 
        fl_add_input(FL_NORMAL_INPUT,10.0,420.0,310.0,40.0,"File name");
  obj2 = fl_add_text(FL_NORMAL_TEXT,20.0,480.0,340.0,60.0,"Read coordinate file");
    fl_set_object_lsize(obj2,FL_LARGE_FONT);

  AMBERfile  =
            fl_add_roundbutton(FL_RADIO_BUTTON,40.0,370.0,40.0,40.0,"AMBER");
  CHARMMfile = 
            fl_add_roundbutton(FL_RADIO_BUTTON,40.0,330.0,40.0,40.0,"CHARMM");
  PDBfile = 
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,50.0,40.0,40.0,"PDB");
  INSIGHTfile = 
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,170.0,40.0,40.0,"INSIGHT");
  GROMOSfile  =
            fl_add_roundbutton(FL_RADIO_BUTTON,40.0,250.0,40.0,40.0,"GROMOS");
  DYNframe   =
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,290.0,40.0,40.0,"Dyn frame");
  YASPfile = 
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,10.0,40.0,40.0,"YASP");
  MOPACfile = 
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,130.0,40.0,40.0,"MOPAC5");
  MUMODfile =
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,90.0,40.0,40.0,"MUMOD");
  HYPERCHEMfile =
          fl_add_roundbutton(FL_RADIO_BUTTON,40.0,210.0,40.0,40.0,"HYPERCHEM");

  FileGo =   fl_add_roundbutton(FL_NORMAL_BUTTON,200.0,200.0,100.0,90.0,"Go ");
  FileQuit = fl_add_roundbutton(FL_NORMAL_BUTTON,200.0,100.0,100.0,90.0,"Quit");
  FileAppend = fl_add_button(FL_PUSH_BUTTON,280.0,30.0,60.0,60.0,"Append");
  MoreFiles= fl_add_button(FL_NORMAL_BUTTON,200.0,30.0,60.0,60.0,"Files");
  fl_end_form();
}

/*---------------------------------------*/

void create_the_forms()
{
  fl_init();

  create_form_1();
  create_form_2();
  create_form_3();
  create_form_4();
  create_form_Text_input();
  create_form_Text_edit();
  create_Colour_Edit_Form();
  CreateReadDict();
  create_form_MaskPanel();
  create_form_StereoMode();
}
int ShowForm1()
{
   FL_OBJECT *obj;
   char str[BUFF_LEN];
   float Xmin,Ymin,Zmin;
   float Xmax,Ymax,Zmax;
   int Xpts,Ypts,Zpts;

  sprintf(str,"%.2f",PROBE_limits.Xmin);
  fl_set_input(PXMin,str);
  sprintf(str,"%.2f",PROBE_limits.Ymin);
  fl_set_input(PYMin,str);
  sprintf(str,"%.2f",PROBE_limits.Zmin);
  fl_set_input(PZMin,str);

  sprintf(str,"%.2f",PROBE_limits.Xmax);
  fl_set_input(PXMax,str);
  sprintf(str,"%.2f",PROBE_limits.Ymax);
  fl_set_input(PYMax,str);
  sprintf(str,"%.2f",PROBE_limits.Zmax);
  fl_set_input(PZMax,str);

  sprintf(str,"%d",PROBE_limits.Xpts);
  fl_set_input(PPX,str);
  sprintf(str,"%d",PROBE_limits.Ypts);
  fl_set_input(PPY,str);
  sprintf(str,"%d",PROBE_limits.Zpts);
  fl_set_input(PPZ,str);

  sprintf(str,"%.2f",PROBE_limits.ProbeVal);
  fl_set_input(PPval,str);

  fl_show_form(PPROBE,FL_PLACE_MOUSE,FALSE,NULL);

  while(1)
  {
    Pbutton = fl_do_forms();
    if(Pbutton == PQuit) {
        fl_hide_form(PPROBE);
        return(1);}
    if(Pbutton == PGo) {
        break;}
    }
        PROBE_limits.Xmin = atof(fl_get_input(PXMin));
        PROBE_limits.Ymin = atof(fl_get_input(PYMin));
        PROBE_limits.Zmin = atof(fl_get_input(PZMin));

        PROBE_limits.Xmax = atof(fl_get_input(PXMax));
        PROBE_limits.Ymax = atof(fl_get_input(PYMax));
        PROBE_limits.Zmax = atof(fl_get_input(PZMax));

        PROBE_limits.Xpts = atoi(fl_get_input(PPX));
        PROBE_limits.Ypts = atoi(fl_get_input(PPY));
        PROBE_limits.Zpts = atoi(fl_get_input(PPZ));

        PROBE_limits.ProbeVal = atof(fl_get_input(PPval));

        fl_hide_form(PPROBE);

        return(0);
}
int ShowForm2()
{
   FL_OBJECT *obj;
   char str[BUFF_LEN];
   float Xmin,Ymin,Zmin;
   float Xmax,Ymax,Zmax;
   int Xpts,Ypts,Zpts;

  sprintf(str,"%.2f",DENSITY_limits.Xmin);
  fl_set_input(DXMin,str);
  sprintf(str,"%.2f",DENSITY_limits.Ymin);
  fl_set_input(DYMin,str);
  sprintf(str,"%.2f",DENSITY_limits.Zmin);
  fl_set_input(DZMin,str);

  sprintf(str,"%.2f",DENSITY_limits.Xmax);
  fl_set_input(DXMax,str);
  sprintf(str,"%.2f",DENSITY_limits.Ymax);
  fl_set_input(DYMax,str);
  sprintf(str,"%.2f",DENSITY_limits.Zmax);
  fl_set_input(DZMax,str);

  sprintf(str,"%d",DENSITY_limits.Xpts);
  fl_set_input(DPX,str);
  sprintf(str,"%d",DENSITY_limits.Ypts);
  fl_set_input(DPY,str);
  sprintf(str,"%d",DENSITY_limits.Zpts);
  fl_set_input(DPZ,str);

  sprintf(str,"%d",DENSITY_limits.Orbital);
  fl_set_input(Dorbital,str);

  fl_set_input(WFfile,DENSITY_limits.WFFile);

  fl_set_button(DMORBITAL, 1);
  fl_set_button(DMORBITAL_D, 0);
  fl_set_button(DMORBITAL_TD, 0);

  fl_show_form(PDENSITY,FL_PLACE_MOUSE,FALSE,NULL);

  while(1)
  {
    Dbutton = fl_do_forms();
    if(Dbutton == DQuit) {
        fl_hide_form(PDENSITY);
        return(1);}
    if(Dbutton == DGo) {
        break;}
    }
        DENSITY_limits.Xmin = atof(fl_get_input(DXMin));
        DENSITY_limits.Ymin = atof(fl_get_input(DYMin));
        DENSITY_limits.Zmin = atof(fl_get_input(DZMin));

        DENSITY_limits.Xmax = atof(fl_get_input(DXMax));
        DENSITY_limits.Ymax = atof(fl_get_input(DYMax));
        DENSITY_limits.Zmax = atof(fl_get_input(DZMax));

        DENSITY_limits.Xpts = atoi(fl_get_input(DPX));
        DENSITY_limits.Ypts = atoi(fl_get_input(DPY));
        DENSITY_limits.Zpts = atoi(fl_get_input(DPZ));

        DENSITY_limits.Orbital = atoi(fl_get_input(Dorbital));

        strncpy(DENSITY_limits.WFFile,fl_get_input(WFfile),BUFF_LEN);

        if(fl_get_button(DMORBITAL)) {
           DENSITY_limits.Dmethod = 0;
        }
        if(fl_get_button(DMORBITAL_D)) {
           DENSITY_limits.Dmethod = 1;
        }
        if(fl_get_button(DMORBITAL_TD)) {
           DENSITY_limits.Dmethod = 2;
        }

        fl_hide_form(PDENSITY);

        return(0);
}
int ShowForm3()
{
   FL_OBJECT *obj;
   char str[BUFF_LEN];
   char *fname;

  fl_set_button(CHARMMobj, 1);
  fl_set_button(DISCOVERobj, 0);
  fl_set_button(YASPobj, 0);
  fl_set_button(MUMODobj, 0);
  fl_set_button(GROMOSobj, 0);
  fl_set_button(AMBERobj, 0);
  fl_set_button(HYPERCHEMobj, 0);

  fl_show_form(FormDynFile,FL_PLACE_SIZE,TRUE,NULL);

  while(1)
  {
    Tbutton = fl_do_forms();
    if(Tbutton == TQuit) {
        fl_hide_form(FormDynFile);
        return(1);}
    if(Tbutton == TGo) {
        break;}
    if(Tbutton == Tfiles){
        if(fl_get_button(CHARMMobj)) {
        fname = fl_show_file_selector("Trajectory files","",
                                       TrajMask.Charmm,"");
         }
        if(fl_get_button(DISCOVERobj)) {
        fname = fl_show_file_selector("Trajectory files","",
                                       TrajMask.Discover,"");
        }
        if(fl_get_button(YASPobj)) {
        fname = fl_show_file_selector("Trajectory files","",
                                       TrajMask.YASP,"");
        }
        if(fl_get_button(MUMODobj)) {
        fname = fl_show_file_selector("Trajectory files","",
                                       TrajMask.MUMOD,"");
        }
        if(fl_get_button(AMBERobj)) {
        fname = fl_show_file_selector("Trajectory files","",
                                       TrajMask.AMBER,"");
        }
        if(fl_get_button(GROMOSobj)) {
        fname = fl_show_file_selector("Trajectory files","",
                                       TrajMask.GROMOS,"");
        }
        if(fl_get_button(HYPERCHEMobj)) {
        fname = fl_show_file_selector("Trajectory files","",
                                       TrajMask.HYPERCHEM,"");
        }
         if(fname != NULL) fl_set_input(FLtrajfile,fname);
     }}

        if(fl_get_button(CHARMMobj)) {
           traj_file_set = 1;
           force_type    = 1;
        }
        if(fl_get_button(DISCOVERobj)) {
           traj_file_set = 2;
           force_type    = 2;
        }
        if(fl_get_button(AMBERobj)) {
           traj_file_set = 3;
           force_type    = 3;
        }
        if(fl_get_button(YASPobj)) {
           traj_file_set = 4;
           force_type    = 4;
        }
        if(fl_get_button(MUMODobj)) {
           traj_file_set = 5;
           force_type    = 5;
        }
        if(fl_get_button(GROMOSobj)) {
           traj_file_set = 6;
           force_type    = 6;
        }
        if(fl_get_button(HYPERCHEMobj)) {
           traj_file_set = 7;
           force_type    = 7;
        }

        strncpy(traj_file,fl_get_input(FLtrajfile),BUFF_LEN);
        strncpy(trajectory_info.traj_file,fl_get_input(FLtrajfile),BUFF_LEN);

        fl_hide_form(FormDynFile);

        sprintf(str,"set dynamics file %s",traj_file);

          switch(traj_file_set) {
             case 1: /* charmmm */
             strncat(str," charmm",(BUFF_LEN - strlen(str)));
             break;
             case 2: /* discover */
             strncat(str," discover",(BUFF_LEN - strlen(str)));
             break;
             case 3: /* amber */
             strncat(str," amber",(BUFF_LEN - strlen(str)));
             return(1);
             case 4: /* yasp */
             strncat(str," yasp",(BUFF_LEN - strlen(str)));
             break;
             case 5: /* mumod */
             strncat(str," mumod",(BUFF_LEN - strlen(str)));
             break;
	     case 6: /* gromos */
             strncat(str," gromos",(BUFF_LEN - strlen(str)));
             break;
	     case 7: /* hyperchem */
             strncat(str," hyperchem",(BUFF_LEN - strlen(str)));
             break;
	     default:
             PrintMessage("ERROR - unknown dynamics file type");
             return(1);
	   }

             push_input_stack(str);

        return(0);
}
char *ShowForm4()
{
   FL_OBJECT *obj;
   static char str[BUFF_LEN];
   static char GotIt[BUFF_LEN];
   char *fname;

  fl_set_button(CHARMMfile, 1);
  fl_set_button(INSIGHTfile, 0);
  fl_set_button(PDBfile, 0);
  fl_set_button(YASPfile, 0);
  fl_set_button(MOPACfile, 0);
  fl_set_button(DYNframe, 0);
  fl_set_button(MUMODfile, 0);
  fl_set_button(GROMOSfile , 0);
  fl_set_button(AMBERfile , 0);
  fl_set_button(HYPERCHEMfile , 0);
  fl_set_button(FileAppend, 0);
  fl_set_input(FLReadFile,"\0");

  fl_show_form(FrmReadFile,FL_PLACE_SIZE,TRUE,NULL);

  while(1)
  {
    FileButton = fl_do_forms();
    if(FileButton == FileQuit) {
        fl_hide_form(FrmReadFile);
        return(0);}
    if(FileButton == FileGo) {
        break;}
    if(FileButton == MoreFiles){
        if(fl_get_button(CHARMMfile)) {
        fname = fl_show_file_selector("Coordinate files","",
                                       CoordMask.Charmm,"");
        }
        if(fl_get_button(INSIGHTfile)) {
        fname = fl_show_file_selector("Coordinates files","",
                                       CoordMask.Insight,"");
        }
        if(fl_get_button(PDBfile)) {
        fname = fl_show_file_selector("Coordinate files","",
                                       CoordMask.PDB,"");
        }
        if(fl_get_button(YASPfile)) {
        fname = fl_show_file_selector("Coordinate files","",
                                       CoordMask.YASP,"");
        }
        if(fl_get_button(MOPACfile)) {
        fname = fl_show_file_selector("Coordinate files","",
                                       CoordMask.MOPAC,"");
        }
        if(fl_get_button(MUMODfile)) {
        fname = fl_show_file_selector("Coordinate files","",
                                       CoordMask.MUMOD,"");
        }
        if(fl_get_button(AMBERfile)) {
        fname = fl_show_file_selector("Coordinate files","",
                                       CoordMask.AMBER,"");
        }
        if(fl_get_button(GROMOSfile)) {
        fname = fl_show_file_selector("Coordinate files","",
                                       CoordMask.GROMOS,"");
        }
        if(fl_get_button(HYPERCHEMfile)) {
        fname = fl_show_file_selector("Coordinate files","",
                                       CoordMask.HYPERCHEM,"");
        }
         if(fname != NULL) fl_set_input(FLReadFile,fname);
      }}

        str[0] = '\0';

        strncpy(GotIt,fl_get_input(FLReadFile),BUFF_LEN);

        if(GotIt[0] != '\0') {

        if(fl_get_button(CHARMMfile)) {
          sprintf(str,"read coord charm %s",GotIt);
        }
        if(fl_get_button(INSIGHTfile)) {
          sprintf(str,"read coord insigh %s",GotIt);
        }
        if(fl_get_button(YASPfile)) {
          sprintf(str,"read coord yasp %s",GotIt);
        }
        if(fl_get_button(PDBfile)) {
          sprintf(str,"read coord pdb %s",GotIt);
        }
        if(fl_get_button(MOPACfile)) {
          sprintf(str,"read coord mopac %s",GotIt);
        }
        if(fl_get_button(MUMODfile)) {
          sprintf(str,"read coord mumod %s",GotIt);
        }
        if(fl_get_button(DYNframe)) {
          sprintf(str,"read dynam frame %d",atoi(GotIt));
        }
        if(fl_get_button(GROMOSfile)) {
          sprintf(str,"read coord gromos %s",GotIt);
        }
        if(fl_get_button(HYPERCHEMfile)) {
          sprintf(str,"read coord hyperchem %s",GotIt);
        }
        if(fl_get_button(AMBERfile)) {
          sprintf(str,"read coord amber %s",GotIt);
        }
        if(fl_get_button(FileAppend)) 
          strncat(str," append",(BUFF_LEN - strlen(str)));

        }
        fl_hide_form(FrmReadFile);

        return(str);
}
SetUpContour()
{
    printf("******* NOT YET WORKING ************\n");
  }



create_form_Text_input()
{
  FL_OBJECT *obj;
  FL_Text_Input = fl_bgn_form(FL_NO_BOX,830.0,200.0);
  obj = fl_add_box(FL_UP_BOX,0.0,0.0,830.0,200.0,"");
 FL_Text_String  = fl_add_input(FL_NORMAL_INPUT,20.0,130.0,770.0,50.0,"Input");
    fl_set_object_lsize(FL_Text_String,FL_LARGE_FONT);
 FL_Text_Browser = fl_add_browser(FL_HOLD_BROWSER,160.0,10.0,220.0,100.0,"Font");
    fl_set_object_align(FL_Text_Browser,FL_ALIGN_TOP);
 FL_Text_Size    = fl_add_browser(FL_HOLD_BROWSER,640.0,10.0,100.0,100.0,"Size");
    fl_set_object_align(FL_Text_Size,FL_ALIGN_TOP);
 FL_Text_Color   = fl_add_browser(FL_HOLD_BROWSER,410.0,10.0,200.0,100.0,"Colour");
    fl_set_object_align(FL_Text_Color,FL_ALIGN_TOP);
 FL_Text_Accept = fl_add_button(FL_NORMAL_BUTTON,20.0,60.0,60.0,60.0,"Accept");
 FL_Text_Cancel = fl_add_button(FL_NORMAL_BUTTON,90.0,60.0,60.0,60.0,"Cancel");
  fl_end_form();
}

#define COLOURS_TO_LOAD  200  /* I can't get the browser to work with the
                                 colours. There are perhaps too many, that is
                                 why I currently use only the first 200
                                 colours (LUL 1992-02-20) */

#define START_SIZE_COUNT  10 /* start to count font size from ... */

int ShowTextInput(TextInput,FontName,rgb,size)
    char  *TextInput;
    char  *FontName;
    int   *rgb;
    float *size;
{
FL_OBJECT *obj;
int i;
char OutText[BUFF_LEN];
static int BeenHere = 0;
static int Save_FTB = 1;
static int Save_FTS = 1;
static int Save_FTC = 1;

    for(i = 0 ; i < FM_fonts.Numbers ; i++) {
        fl_add_browser_line(FL_Text_Browser,FM_fonts.FontString
                                     +FM_fonts.NumCharacters*i);}

    for(i = START_SIZE_COUNT ; i < 101 ; i++) {
        sprintf(OutText," %d ",i);
        fl_add_browser_line(FL_Text_Size,OutText);}

    for(i = 0 ; 
        i < (COLOURS_TO_LOAD > col_tbl_max ? col_tbl_max : COLOURS_TO_LOAD) ; 
        i++) {

        fl_add_browser_line(FL_Text_Color,col_table[i].name);}


fl_show_form(FL_Text_Input,FL_PLACE_CENTER,FALSE,NULL);

if(!BeenHere) {
   fl_select_browser_line(FL_Text_Browser , 1);
    fl_select_browser_line(FL_Text_Size , 1);
     fl_select_browser_line(FL_Text_Color , 1);

    fl_set_browser_topline(FL_Text_Browser , 1);
     fl_set_browser_topline(FL_Text_Size , 1);
      fl_set_browser_topline(FL_Text_Color , 1);

    BeenHere++;}
   else {
   fl_select_browser_line(FL_Text_Browser , Save_FTB);
    fl_select_browser_line(FL_Text_Size , Save_FTS);
     fl_select_browser_line(FL_Text_Color , Save_FTC);

    fl_set_browser_topline(FL_Text_Browser , Save_FTB);
     fl_set_browser_topline(FL_Text_Size , Save_FTS);
      fl_set_browser_topline(FL_Text_Color , Save_FTC);
    }

fl_set_input(FL_Text_String , "\0\0");

while(1)
{    

     obj = fl_do_forms();

     if(obj == FL_Text_Cancel) {
     fl_clear_browser(FL_Text_Browser);
     fl_clear_browser(FL_Text_Size);
     fl_clear_browser(FL_Text_Color);
        fl_hide_form(FL_Text_Input);
        return(1);}

     if(obj == FL_Text_Accept) {
       break;}
}

     strncpy(TextInput,fl_get_input(FL_Text_String),BUFF_LEN);

     Save_FTB = i = fl_get_browser(FL_Text_Browser);
      strncpy(FontName , FM_fonts.FontString + FM_fonts.NumCharacters * (i-1) ,
                         BUFF_LEN);

     Save_FTS = i = fl_get_browser(FL_Text_Size);
     *size = (float)i + (START_SIZE_COUNT - 1);

     Save_FTC = i = fl_get_browser(FL_Text_Color);

     rgb[0] = col_table[i-1].red;
     rgb[1] = col_table[i-1].green;
     rgb[2] = col_table[i-1].blue;

     fl_clear_browser(FL_Text_Browser);
     fl_clear_browser(FL_Text_Size);
     fl_clear_browser(FL_Text_Color);
     fl_hide_form(FL_Text_Input);


    strncpy(OutText,FL_Text_String,BUFF_LEN);
     toller(OutText);
      if(indexo(OutText,"exit") == 1 || indexo(OutText,"end") == 1){
       return(1);}

     display_text = 1;

     return(0);
}
/*---------------------------------------*/


/***************************************************************************/
create_form_Text_edit()
/***************************************************************************/
{
  FL_OBJECT *obj;
  FL_Text_Edit = fl_bgn_form(FL_NO_BOX,830.0,300.0);
  obj = fl_add_box(FL_UP_BOX,0.0,0.0,830.0,300.0,"");
 FL_Text_Browser_Edit_String = 
    fl_add_browser(FL_HOLD_BROWSER,20.0,220.0,770.0,50.0,"");
    fl_set_browser_fontsize(FL_Text_Browser_Edit_String,FL_LARGE_FONT);
    fl_set_object_align(FL_Text_Browser_Edit_String,FL_ALIGN_TOP);
 FL_Text_String_Edit  =
    fl_add_input(FL_NORMAL_INPUT,20.0,150.0,770.0,50.0,"Input");
    fl_set_object_lsize(FL_Text_String_Edit,FL_LARGE_FONT);
 FL_Text_Browser_Edit = 
    fl_add_browser(FL_HOLD_BROWSER,160.0,10.0,220.0,100.0,"Font");
    fl_set_object_align(FL_Text_Browser_Edit,FL_ALIGN_TOP);
 FL_Text_Size_Edit    = 
    fl_add_browser(FL_HOLD_BROWSER,640.0,10.0,100.0,100.0,"Size");
    fl_set_object_align(FL_Text_Size_Edit,FL_ALIGN_TOP);
 FL_Text_Color_Edit   = 
    fl_add_browser(FL_HOLD_BROWSER,410.0,10.0,200.0,100.0,"Colour");
    fl_set_object_align(FL_Text_Color_Edit,FL_ALIGN_TOP);
 FL_Text_Accept_Edit = 
    fl_add_button(FL_NORMAL_BUTTON,20.0,75.0,60.0,60.0,"Accept");
 FL_Text_Cancel_Edit = 
    fl_add_button(FL_NORMAL_BUTTON,90.0,75.0,60.0,60.0,"Cancel");
 FL_Text_Edit_Move =
    fl_add_roundbutton(FL_RADIO_BUTTON,20.0,20.0,40.0,40.0,"Move the text");
/*    fl_set_browser_fontstyle(FL_Text_Edit_Move,FL_BOLD_STYLE);*/
    fl_set_object_align(     FL_Text_Edit_Move,FL_ALIGN_RIGHT);
  fl_end_form();
}

/***************************************************************************/
int ShowTextInputEdit()
/***************************************************************************/
{
FL_OBJECT *obj;
int i,j;
char OutText[BUFF_LEN];

static int Save_FTB;
static int Save_FTS;
static int Save_FTC;
static int Done_Selection;
static int   BrowserRGB[3];
static float BrowserSize;
    for(i = 0 ; i < FM_fonts.Numbers ; i++) {
        fl_add_browser_line(FL_Text_Browser_Edit,FM_fonts.FontString
                                     +FM_fonts.NumCharacters*i);}

    for(i = START_SIZE_COUNT ; i < 101 ; i++) {
        sprintf(OutText," %d ",i);
        fl_add_browser_line(FL_Text_Size_Edit,OutText);}

    for(i = 0 ; 
        i < (COLOURS_TO_LOAD > col_tbl_max ? col_tbl_max : COLOURS_TO_LOAD) ; 
        i++) {

        fl_add_browser_line(FL_Text_Color_Edit,col_table[i].name);}

    for(i = 0 ; i < ReturnTextEntries() ; i++) 
        fl_add_browser_line(FL_Text_Browser_Edit_String,ReturnTextString(i));

fl_show_form(FL_Text_Edit,FL_PLACE_CENTER,FALSE,NULL);

/*
   fl_select_browser_line(FL_Text_Browser_Edit , Save_FTB);
    fl_select_browser_line(FL_Text_Size_Edit , Save_FTS);
     fl_select_browser_line(FL_Text_Color_Edit , Save_FTC);

    fl_set_browser_topline(FL_Text_Browser_Edit , Save_FTB);
     fl_set_browser_topline(FL_Text_Size_Edit , Save_FTS);
      fl_set_browser_topline(FL_Text_Color_Edit , Save_FTC);
*/

fl_set_button(FL_Text_Edit_Move, 0);  /* default do not move text */

fl_set_input(FL_Text_String_Edit , "\0\0");

Done_Selection = 0;

     j = ReturnTextEntries();

while(1)
{    

     obj = fl_do_forms();

     if(obj == FL_Text_Browser_Edit_String) {

     for(i = 0 ; i < j ; i++) {
         if(fl_isselected_browser_line(FL_Text_Browser_Edit_String , (i+1))) {

           Done_Selection = 1; /* OK */

           Save_FTB =      FindUsedFont(ReturnTextFont(i)) + 1;
           Save_FTS =              (int)ReturnTextSize(i) - 
                                        (START_SIZE_COUNT - 1);
           Save_FTC =      FindUsedColour(ReturnTextColour(i)) + 1;

   fl_select_browser_line(FL_Text_Browser_Edit , Save_FTB);
    fl_select_browser_line(FL_Text_Size_Edit , Save_FTS);
     fl_select_browser_line(FL_Text_Color_Edit , Save_FTC);

    fl_set_browser_topline(FL_Text_Browser_Edit , Save_FTB);
     fl_set_browser_topline(FL_Text_Size_Edit , Save_FTS);
      fl_set_browser_topline(FL_Text_Color_Edit , Save_FTC);

           fl_set_input(FL_Text_String_Edit , ReturnTextString(i));}
     }}

     if(obj == FL_Text_Cancel_Edit) {
        Delete_Edit_Text_Form();
        return(1);}

     if(obj == FL_Text_Accept_Edit) {
       if(!Done_Selection) {
          PrintMessage("?ERROR - you have to select the text");
          Delete_Edit_Text_Form();
          return(1);}
       break;}
}


     i = fl_get_browser(FL_Text_Browser_Edit_String);

     (void)PutTextString(fl_get_input(FL_Text_String_Edit) , (i - 1));

     j = fl_get_browser(FL_Text_Browser_Edit);

     (void)PutTextFont(FM_fonts.FontString + FM_fonts.NumCharacters * (j-1) ,
                       (i - 1));

     j = fl_get_browser(FL_Text_Size_Edit) + (START_SIZE_COUNT - 1);

      (void)PutTextSize( j , (i-1));

     j = fl_get_browser(FL_Text_Color_Edit);
      BrowserRGB[0] = col_table[j-1].red;
       BrowserRGB[1] = col_table[j-1].green;
         BrowserRGB[2] = col_table[j-1].blue;
          (void)PutTextColour(BrowserRGB , (i-1));

     fl_clear_browser(FL_Text_Browser_Edit);
     fl_clear_browser(FL_Text_Size_Edit);
     fl_clear_browser(FL_Text_Color_Edit);
     fl_clear_browser(FL_Text_Browser_Edit_String);
     fl_hide_form(FL_Text_Edit);

        if(fl_get_button(FL_Text_Edit_Move)) {

        float xs,ys;

         RedrawScreen();

        PrintMessage("****> move pointer to desired place and press LEFT mouse button ");

        get_xy(&xs,&ys);

        (void)PutTextPosition(xs,ys,(i-1));

         RedrawScreen();
        }


     return(0);
}
/*---------------------------------------*/
/***************************************************************************/
int FindUsedFont(FontString)
    char *FontString;
/***************************************************************************/
{

    int i;

    for(i = 0 ; i < FM_fonts.Numbers ; i++) {

       if((indexo(FontString , FM_fonts.FontString+FM_fonts.NumCharacters*i)
          == 1) && (strlen(FontString) == 
                    strlen(FM_fonts.FontString+FM_fonts.NumCharacters*i))) {

       return(i);}}

    return(-1);  /* Error return, did not find the font */
}
    
/***************************************************************************/
int FindUsedColour(ColourRGB)
    int *ColourRGB;
/***************************************************************************/
{
    int i;

    for(i = 0 ; i < COLOURS_TO_LOAD ; i++) {

       if(col_table[i].red   == ColourRGB[0] &&
          col_table[i].green == ColourRGB[1] &&
          col_table[i].blue  == ColourRGB[2]) {

          return(i);}}

     return(-1);
}
/***************************************************************************/
Delete_Edit_Text_Form()
/***************************************************************************/
{
     fl_clear_browser(FL_Text_Browser_Edit);
     fl_clear_browser(FL_Text_Size_Edit);
     fl_clear_browser(FL_Text_Color_Edit);
     fl_clear_browser(FL_Text_Browser_Edit_String);
        fl_hide_form(FL_Text_Edit);
   }

/***************************************************************************/
create_Colour_Edit_Form()
/***************************************************************************/
{
  FL_Edit_Colour_Form = fl_bgn_form(FL_UP_BOX,300.0,330.0);
  FL_Edit_Colour_Button = 
       fl_add_button(FL_NORMAL_BUTTON,10.0,270.0,150.0,45.0,"Return");
    fl_set_object_lsize(FL_Edit_Colour_Button,FL_LARGE_FONT);
  FL_Edit_Colour_Quit   =
       fl_add_button(FL_NORMAL_BUTTON,175.0,270.0,100.0,45.0,"Cancel");
       fl_set_object_lsize(FL_Edit_Colour_Quit,FL_LARGE_FONT);

    FL_Edit_Colour_Red = 
       fl_add_dial(FL_LINE_DIAL,30.0,30.0,60.0,60.0,"Red");
    fl_set_dial_bounds(FL_Edit_Colour_Red,0.0,255.0);
    fl_set_dial_value(FL_Edit_Colour_Red,128.0);
    fl_set_object_color(FL_Edit_Colour_Red,1,FL_DIAL_COL2);
    FL_Edit_Colour_Redtext = 
       fl_add_box(FL_DOWN_BOX,105.0,48.0,50.0,24.0,"");

    FL_Edit_Colour_Green = 
       fl_add_dial(FL_LINE_DIAL,30.0,114.0,60.0,60.0,"Green");
    fl_set_dial_bounds(FL_Edit_Colour_Green,0.0,255.0);
    fl_set_dial_value(FL_Edit_Colour_Green,128.0);
    fl_set_object_color(FL_Edit_Colour_Green,2,FL_DIAL_COL2);
    FL_Edit_Colour_Greentext = 
       fl_add_box(FL_DOWN_BOX,105.0,132.0,50.0,24.0,"");

    FL_Edit_Colour_Blue = 
       fl_add_dial(FL_LINE_DIAL,30.0,198.0,60.0,60.0,"Blue");
    fl_set_dial_bounds(FL_Edit_Colour_Blue,0.0,255.0);
    fl_set_dial_value(FL_Edit_Colour_Blue,128.0);
    fl_set_object_color(FL_Edit_Colour_Blue,4,FL_DIAL_COL2);
    FL_Edit_Colour_Bluetext = 
       fl_add_box(FL_DOWN_BOX,105.0,216.0,50.0,24.0,"");

    FL_Edit_Colour_Result = 
       fl_add_box(FL_DOWN_BOX,180.0,15.0,90.0,243.0,"");
    fl_set_object_color(FL_Edit_Colour_Result,200,200);
  fl_end_form();
}

/***************************************************************************/
int Show_Edit_Colour()
/***************************************************************************/
{
  FL_OBJECT *ret;
  int r,g,b;
  char str[BUFF_LEN];

  extern int red,green,blue;


    fl_set_dial_value(FL_Edit_Colour_Red,(float)red);
    fl_set_dial_value(FL_Edit_Colour_Green,(float)green);
    fl_set_dial_value(FL_Edit_Colour_Blue,(float)blue);
    sprintf(str,"%d",red); 
     fl_set_object_label(FL_Edit_Colour_Redtext,str);
    sprintf(str,"%d",green); 
     fl_set_object_label(FL_Edit_Colour_Greentext,str);
    sprintf(str,"%d",blue); 
     fl_set_object_label(FL_Edit_Colour_Bluetext,str);
    fl_mapcolor(200,red,green,blue);

    fl_show_form(FL_Edit_Colour_Form,FL_PLACE_SIZE,TRUE,"Colour Editor");


  do
  {
    ret = fl_do_forms();

    if(ret == FL_Edit_Colour_Quit) {
       fl_hide_form(FL_Edit_Colour_Form);
        return(1);}

    if((ret == FL_Edit_Colour_Red)   ||
       (ret == FL_Edit_Colour_Green) ||
       (ret == FL_Edit_Colour_Blue)) {
    r = (int) fl_get_dial_value(FL_Edit_Colour_Red);
    g = (int) fl_get_dial_value(FL_Edit_Colour_Green);
    b = (int) fl_get_dial_value(FL_Edit_Colour_Blue);
    fl_mapcolor(200,r,g,b);
    fl_redraw_object(FL_Edit_Colour_Result);
    sprintf(str,"%d",r); 
     fl_set_object_label(FL_Edit_Colour_Redtext,str);
    sprintf(str,"%d",g); 
     fl_set_object_label(FL_Edit_Colour_Greentext,str);
    sprintf(str,"%d",b); 
     fl_set_object_label(FL_Edit_Colour_Bluetext,str);}
  } while (ret != FL_Edit_Colour_Button);
  fl_hide_form(FL_Edit_Colour_Form);

  red   = r;
  green = g;
  blue  = b;

  return(0);
}
int ShowReadDict()
{
   FL_OBJECT *obj;
   char str[BUFF_LEN];
   char *fname;

  fl_show_form(FL_Read_Dictionary,FL_PLACE_SIZE,TRUE,NULL);

  while(1)
  {
    obj = fl_do_forms();
    if(obj == FL_Read_Dic_Quit) {
        fl_hide_form(FL_Read_Dictionary);
        return(1);}
    if(obj == FL_Read_Dic_Go) {
        break;}
    if(obj == FL_Read_Dic_Files){
        fname = fl_show_file_selector("Dictionary files","","*.dic","");
        if(fname == NULL) {
        fl_hide_form(FL_Read_Dictionary);
        return(1);
   }}}

        fl_hide_form(FL_Read_Dictionary);

        sprintf(str,"read dictionary %s",fname);

             send_command(str);

        return(0);
  }
CreateReadDict()
{
  FL_OBJECT *obj1;
  FL_OBJECT *obj2;
  FL_Read_Dictionary = fl_bgn_form(FL_NO_BOX,360.0,460.0);
  obj1 = fl_add_box(FL_UP_BOX,0.0,0.0,360.0,460.0,"");
  FL_Read_Dic_Filename = 
        fl_add_input(FL_NORMAL_INPUT,10.0,320.0,310.0,40.0,"File name");
  obj2 = fl_add_text(FL_NORMAL_TEXT,20.0,390.0,340.0,60.0,"Read dictionar file");
    fl_set_object_lsize(obj2,FL_LARGE_FONT);

  FL_Read_Dic_Go =   
      fl_add_roundbutton(FL_NORMAL_BUTTON,200.0,200.0,100.0,90.0,"Go ");
  FL_Read_Dic_Quit =
      fl_add_roundbutton(FL_NORMAL_BUTTON,200.0,100.0,100.0,90.0,"Quit");
  FL_Read_Dic_Files= 
      fl_add_button(FL_NORMAL_BUTTON,210.0,30.0,50.0,50.0,"Files");
  fl_end_form();
}
create_form_MaskPanel()
{
  FL_OBJECT *obj;
  MaskPanel = fl_bgn_form(FL_NO_BOX,400.0,500.0);
  obj = fl_add_box(FL_UP_BOX,0.0,0.0,400.0,500.0,"");
  obj = fl_add_text(FL_NORMAL_TEXT,30.0,450.0,340.0,40.0,"Fine name masks");
    fl_set_object_lsize(obj,FL_LARGE_FONT);
    fl_set_object_align(obj,FL_ALIGN_CENTER);
  obj = fl_add_text(FL_NORMAL_TEXT,10.0,420.0,190.0,40.0,"Coordinates:");
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  FL_Mask_Coord_Charmm
      = fl_add_input(FL_NORMAL_INPUT,140.0,390.0,160.0,40.0,"CHARMM");
  FL_Mask_Coord_Insight
      = fl_add_input(FL_NORMAL_INPUT,140.0,350.0,160.0,40.0,"Insight");
  FL_Mask_Coord_PDB
      = fl_add_input(FL_NORMAL_INPUT,140.0,310.0,160.0,40.0,"PDB");
  FL_Mask_Coord_YASP
      = fl_add_input(FL_NORMAL_INPUT,140.0,270.0,160.0,40.0,"YASP");
  FL_Mask_Coord_MUMOD
      = fl_add_input(FL_NORMAL_INPUT,140.0,230.0,160.0,40.0,"MUMOD");
  FL_Mask_Coord_MOPAC
      = fl_add_input(FL_NORMAL_INPUT,140.0,190.0,160.0,40.0,"MOPAC");
  obj = fl_add_text(FL_NORMAL_TEXT,10.0,160.0,190.0,40.0,"Trajectories:");
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  FL_Mask_Traj_Charmm
      = fl_add_input(FL_NORMAL_INPUT,140.0,130.0,160.0,40.0,"CHARMM");
  FL_Mask_Traj_Discover
      = fl_add_input(FL_NORMAL_INPUT,140.0,90.0,160.0,40.0,"DISCOVER");
  FL_Mask_Traj_YASP
      = fl_add_input(FL_NORMAL_INPUT,140.0,50.0,160.0,40.0,"YASP");
  FL_Mask_Traj_MUMOD
      = fl_add_input(FL_NORMAL_INPUT,140.0,10.0,160.0,40.0,"MUMOD");
  FL_Mask_Accept
      = fl_add_roundbutton(FL_NORMAL_BUTTON,310.0,320.0,80.0,80.0,"Accept");
    fl_set_object_align(FL_Mask_Accept,FL_ALIGN_TOP);
    fl_set_object_lsize(FL_Mask_Accept,FL_LARGE_FONT);
  FL_Mask_Cancel
      = fl_add_roundbutton(FL_NORMAL_BUTTON,310.0,140.0,80.0,80.0,"Cancel");
    fl_set_object_align(FL_Mask_Cancel,FL_ALIGN_TOP);
    fl_set_object_lsize(FL_Mask_Cancel,FL_LARGE_FONT);
  fl_end_form();
}

/*---------------------------------------*/
int ShowFormMask()
{
   FL_OBJECT *obj;
   char str[BUFF_LEN];

  fl_set_input(FL_Mask_Coord_Charmm,CoordMask.Charmm);
   fl_set_input(FL_Mask_Coord_Insight,CoordMask.Insight);
    fl_set_input(FL_Mask_Coord_PDB    ,CoordMask.PDB);
     fl_set_input(FL_Mask_Coord_MUMOD  ,CoordMask.MUMOD);
       fl_set_input(FL_Mask_Coord_YASP  ,CoordMask.YASP);
         fl_set_input(FL_Mask_Coord_MOPAC,CoordMask.MOPAC);

  fl_set_input(FL_Mask_Traj_Charmm,  TrajMask.Charmm);
   fl_set_input(FL_Mask_Traj_Discover,TrajMask.Discover);
    fl_set_input(FL_Mask_Traj_MUMOD   ,TrajMask.MUMOD);
     fl_set_input(FL_Mask_Traj_YASP    ,TrajMask.YASP);

  fl_show_form(MaskPanel,FL_PLACE_SIZE,TRUE,NULL);

  while(1)
  {
    obj = fl_do_forms();
    if(obj == FL_Mask_Cancel) {
        fl_hide_form(MaskPanel);
        return(1);}
    if(obj == FL_Mask_Accept) {
        break;}
  }

  strncpy(CoordMask.Charmm ,fl_get_input(FL_Mask_Coord_Charmm) ,MAX_MASK_LEN);
  strncpy(CoordMask.Insight,fl_get_input(FL_Mask_Coord_Insight),MAX_MASK_LEN);
  strncpy(CoordMask.PDB    ,fl_get_input(FL_Mask_Coord_PDB)    ,MAX_MASK_LEN);
  strncpy(CoordMask.MUMOD  ,fl_get_input(FL_Mask_Coord_MUMOD)  ,MAX_MASK_LEN);
  strncpy(CoordMask.YASP   ,fl_get_input(FL_Mask_Coord_YASP)   ,MAX_MASK_LEN);
  strncpy(CoordMask.MOPAC  ,fl_get_input(FL_Mask_Coord_MOPAC)  ,MAX_MASK_LEN);

  strncpy(TrajMask.Charmm  ,fl_get_input(FL_Mask_Traj_Charmm)  ,MAX_MASK_LEN);
  strncpy(TrajMask.Discover,fl_get_input(FL_Mask_Traj_Discover),MAX_MASK_LEN);
  strncpy(TrajMask.MUMOD   ,fl_get_input(FL_Mask_Traj_MUMOD)   ,MAX_MASK_LEN);
  strncpy(TrajMask.YASP    ,fl_get_input(FL_Mask_Traj_YASP)    ,MAX_MASK_LEN);

        fl_hide_form(MaskPanel);

        return(0);
}
create_form_StereoMode()
{
  FL_OBJECT *obj;
  FL_StereoMode = fl_bgn_form(FL_NO_BOX,820.0,370.0);
  obj = fl_add_box(FL_UP_BOX,0.0,0.0,820.0,370.0,"");
  obj = fl_add_text(FL_NORMAL_TEXT,280,290.0,250.0,80.0,"S T E R E O mode");
    fl_set_object_lcol(obj,4);
    fl_set_object_lsize(obj,FL_LARGE_FONT);
  obj = fl_add_text(FL_NORMAL_TEXT,20.0,220.0,180.0,50.0,"   Separation (in A)");
  FL_Stereo_SMax = 
       fl_add_input(FL_NORMAL_INPUT,220.0,210.0,190.0,40.0,"Max");
  FL_Stereo_SMin = 
       fl_add_input(FL_NORMAL_INPUT,220.0,150.0,190.0,40.0,"Min");
  FL_Stereo_VS   = 
       fl_add_valslider(FL_HOR_NICE_SLIDER,30.0,80.0,360.0,50.0,"");
    fl_set_object_color(FL_Stereo_VS,47,4);

  obj = fl_add_text(FL_NORMAL_TEXT,410.0,220.0,180.0,50.0,"   Angle (in degrees)");
  FL_Stereo_AMax = 
       fl_add_input(FL_NORMAL_INPUT,620.0,210.0,190.0,40.0,"Max");
  FL_Stereo_AMin = 
       fl_add_input(FL_NORMAL_INPUT,620.0,150.0,190.0,40.0,"Min");
  FL_Stereo_VA   = 
       fl_add_valslider(FL_HOR_NICE_SLIDER,430.0,80.0,360.0,50.0,"");
    fl_set_object_color(FL_Stereo_VA,47,4);

  FL_Stereo_Return =   
       fl_add_roundbutton(FL_NORMAL_BUTTON,690.0,10.0,70.0,60.0,"Return");

  FL_Stereo_ON_OFF = 
       fl_add_roundbutton(FL_PUSH_BUTTON,440.0,10.0,70.0,60.0,"ON/OFF");

fl_end_form();
}

/*---------------------------------------*/
int Show_Form_StereoMode()
{
    FL_OBJECT *obj;
    char OutText[BUFF_LEN];
    int  ModeOnOff;
    float Slider_Max,Slider_Min,Slider_Value;

    ModeOnOff = 1;
     StereoPlot.Active = ModeOnOff;

/*  set first the min max values for the sliders */

    if(!StereoPlot.Set) {

      StereoPlot.Translate = far / 2.0;

      bang_it();

      sprintf(OutText,"%.3f",far);
      fl_set_input(FL_Stereo_SMax , OutText);

      sprintf(OutText,"0.000");
      fl_set_input(FL_Stereo_SMin , OutText);

      fl_set_slider_bounds(FL_Stereo_VS , 0.0 , far);
      fl_set_slider_value( FL_Stereo_VS , StereoPlot.Translate);

      sprintf(OutText,"+10.0");
      fl_set_input(FL_Stereo_AMax , OutText);

      sprintf(OutText,"-10.0");
      fl_set_input(FL_Stereo_AMin , OutText);

      fl_set_slider_bounds(FL_Stereo_VA , -10.0 , 10.0);
      fl_set_slider_value( FL_Stereo_VA , StereoPlot.Angle / 10.);

      StereoPlot.Set = 1;
    }

    fl_show_form(FL_StereoMode,FL_PLACE_SIZE,TRUE,NULL);

    fl_set_button(FL_Stereo_ON_OFF , 1);

    while(1) 
    {
       obj = fl_do_forms();

       if(obj == FL_Stereo_Return) {
         fl_hide_form(FL_StereoMode);
         StereoPlot.Active = ModeOnOff;
         return(1);}

       else if (obj == FL_Stereo_VS) {
          if(!ModeOnOff) continue;
          StereoPlot.Translate = fl_get_slider_value(FL_Stereo_VS);
          bang_it();}

       else if (obj == FL_Stereo_VA) {
          if(!ModeOnOff) continue;
          StereoPlot.Angle     = 10.0 * fl_get_slider_value(FL_Stereo_VA);
          bang_it();}

       else if(obj == FL_Stereo_ON_OFF) {
          if(!fl_get_button(FL_Stereo_ON_OFF)) {
             ModeOnOff = 0;
             StereoPlot.Active = ModeOnOff;}
          else {
             ModeOnOff = 1;
             StereoPlot.Active = ModeOnOff;}}

       else if(obj == FL_Stereo_SMax) {
          fl_get_slider_bounds(FL_Stereo_VS , &Slider_Min , &Slider_Max);
          fl_set_slider_bounds(FL_Stereo_VS , 
                     Slider_Min , atof(fl_get_input(FL_Stereo_SMax)));
          Slider_Value = fl_get_slider_value(FL_Stereo_SMax);
          if(Slider_Value < Slider_Min) 
                          fl_set_slider_value(FL_Stereo_SMin , Slider_Min);
          if(Slider_Value > Slider_Max)
                          fl_set_slider_value(FL_Stereo_SMax , Slider_Max);
          
       }
       else if (obj == FL_Stereo_SMin) {
          fl_get_slider_bounds(FL_Stereo_VS , &Slider_Min , &Slider_Max);
          fl_set_slider_bounds(FL_Stereo_VS , 
                     atof(fl_get_input(FL_Stereo_SMin)) , Slider_Max);
          Slider_Value = fl_get_slider_value(FL_Stereo_SMin);
          if(Slider_Value < Slider_Min) 
                          fl_set_slider_value(FL_Stereo_SMin , Slider_Min);
          if(Slider_Value > Slider_Max)
                          fl_set_slider_value(FL_Stereo_SMax , Slider_Max);
       }

       else if (obj == FL_Stereo_AMax) {
          fl_get_slider_bounds(FL_Stereo_VA , &Slider_Min , &Slider_Max);
          fl_set_slider_bounds(FL_Stereo_VA , 
                     Slider_Min , atof(fl_get_input(FL_Stereo_AMax)));
          Slider_Value = fl_get_slider_value(FL_Stereo_AMax);
          if(Slider_Value < Slider_Min) 
                          fl_set_slider_value(FL_Stereo_AMin , Slider_Min);
          if(Slider_Value > Slider_Max)
                          fl_set_slider_value(FL_Stereo_AMax , Slider_Max);
       }
       else if (obj == FL_Stereo_AMin) {
          fl_get_slider_bounds(FL_Stereo_VA , &Slider_Min , &Slider_Max);
          fl_set_slider_bounds(FL_Stereo_VA , 
                     atof(fl_get_input(FL_Stereo_AMin)) , Slider_Max);
          Slider_Value = fl_get_slider_value(FL_Stereo_AMin);
          if(Slider_Value < Slider_Min) 
                          fl_set_slider_value(FL_Stereo_AMin , Slider_Min);
          if(Slider_Value > Slider_Max)
                          fl_set_slider_value(FL_Stereo_AMax , Slider_Max);
       }

    }
}
         


/*---------------------------------------*/

#else
FORMS_DUMMY()
{
}
#endif
