/*  

                       Copyright (c) 1990, 1994 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#include <sys/types.h>
#include <malloc.h>

#ifdef sgi
#include <device.h>
#include <gl/gl.h>
#endif

#include "traja.h"
#include "maxdefs.h"

#ifdef sgi
#define TRANSLATE(a,b,c) translateO(a,b,c)
#endif


#define MAX(a,b)  ((a) > (b) ? (a) : (b))
#define MIN(a,b)  ((a) < (b) ? (a) : (b))
#define Rabs(a)    ( ( a ) > 0 ? (a) : -(a))

#define DIALOG_BUFFER BUFF_LEN

#define POINTER  REDv

#define BOX_here()           {  c3s(BLUEv);\
                                rectf(xm1,ym1,xm2,ym2);\
                                c3s(WHITEv);\
                                bgnline();\
                                  v2f(&vect[0]);\
                                  v2f(&vect[2]);\
                                  v2f(&vect[4]);\
                                  v2f(&vect[6]);\
                                  v2f(&vect[0]);\
                                  endline();\
                                            \
                                 cmov2(xm3,ym3);\
                                 charstr(text1);\
                                 cmov2(xm5,ym5);\
                                 charstr(text2);}

   extern char parsed[MAXparse][MAXlinel];

   extern int numat;
   extern float *x,*y,*z;
   extern short CYANv[3];
   extern short REDv[];
   extern int *ivector();
   extern float *vector();
   extern int *res1;
   extern char *disp_list;
   extern int term_type;
   extern char *segment;
   extern char *resnam;
   extern char *atnam;
   extern int yes_no_graph;
   extern int find_hydr_bond();
   extern void MakeOrtho();
   extern float *atm_charge;

   extern float damp;
   extern float near,far;
   extern int calc_neigh;
   extern long dev;
   extern short val;
   extern int IsNumber(char *Text);

        extern float near;
        extern short BLUEv[3];
        extern short WHITEv[3];
        extern float rotB[][4];
        extern long xsize,ysize,xorg,yorg;

   extern int keyb_input();
   extern float idmat[][4];

   extern int current_struct;
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */


   extern struct Bline {
     int Start;      /* index to a filed in the message start point */
     int Stop;       /*                                 end   point */
     int Llength;    /* length of message line                      */
     char *Message;}
                      Sline;

/*
      Scarecrow is using the following Projection Transformations

      0 => Scarecrow is using ortho
      1 =>                    perspective
*/
      extern struct Projection {
       int Fovy;           /* in tenths of degrees */
       int Transformation; } Model;

 
   float hydbond = 3.10;   /* default length for hydrogen bonds 
                              distance between the heavy atoms */
   float hydhyd  = 2.6;    /* distance between the heavy atom and
                              the hydrogen */

/* structure to save the distance list */

   struct flush_dist_list {
          int num;
          int *list;};

   struct flush_dist_list graf_dist_list;

   void dialog4();
   
/******************************************************************/
neighbours(alt)  /* find neighbours to atom (index iatom) */
     int alt;    /* alt = 0 from menu selection
                    alt = 1 from keyboard
                    alt = 2 delete list                   */
/******************************************************************/
{

   static int find_neib = 10; /* find 10 neighbours */
   static int *iatom; /* find neighbours to this atom list */
   static int *nlist; /* neibour list */
   static int external;
   static float *ndist; /* neighbour distance list */
   static float xd,yd,zd,dist,mxdist,mndist,RCut;
   static float tmp1,tmp2,tmp3;
   static int i,j,k,l,lstr;
   int  pick_list;
   int shuffle;
   char text[BUFF_LEN];
   char text1[BUFF_LEN];

   if(mliste[0] < 1) {
   printf("?ERROR - no atoms defined in the program \n");
   return;}

/* special case kill list                  */
     if(alt == 2) { /* delete list */
        if(graf_dist_list.num < 1) {
          PrintMessage("?ERROR - no neigbours to be deleted");
          return;}
        free(graf_dist_list.list);
        graf_dist_list.num = 0;
        calc_neigh = 0;
     return;}
/*                                         */

/* kill the old list if there is one */
   if(graf_dist_list.num > 0) {
     free(graf_dist_list.list);}
    shuffle = 0;
    graf_dist_list.num = 0;

   switch(alt) {

   case 0: /* from menu selection */

#ifdef sgi
   dialog4("Neighbour display ... ","Number of neighbours :  ",text);
   find_neib = atoi(text);
   dialog4("Neighbour display ... ","'All atoms' or 'external' :  ",text);
   bang_it();
#else
   printf("?ERROR - not implemented \n");
#endif

   break;

   case 1: /* from keyboard */

   if(parsed[3][0] == '\0') {  /* check that the selection list is there */
     printf("?ERROR - selection list was not supplied \n");
      return;}

   strncpy(text,parsed[6],BUFF_LEN);
   strncpy(text1,parsed[7],BUFF_LEN);

   if(isdigit(parsed[2][0])) { /* check that it is a digit */
   find_neib = atoi(parsed[2]);}
   else {
    printf("?ERROR - number of neigbours supplied is not a digit \n");
     return;}

   break;
   }  /* end of switch */

   RCut = 1.e+20;

   if(IsNumber(text)) RCut = atof(text);
   else {
         if(IsNumber(text1)) RCut = atof(text1);}

   if(find_neib == 0) find_neib=10;
   external = 1; /* default externals */
   tupper(text);
   tupper(text1);
   if((indexo(text,"ALL")  == 1) ||
      (indexo(text1,"ALL") == 1)) external = 0;

   iatom = ivector(MAXplen);
   nlist = ivector(2*find_neib);
   ndist =  vector(2*find_neib);

   pick_list = 0;
   if(term_type == 1 && yes_no_graph == 1 && alt == 0)
   point_arr(&pick_list,iatom);
   else
   select_point_arr(&pick_list,iatom);

   if(pick_list == 0 ) {
/* free scratch space */
   free(iatom);
   free(nlist);
   free(ndist);
   return;}

   graf_dist_list.list = ivector(2 * pick_list * find_neib * sizeof(int));
   if(graf_dist_list.list == NULL) {
     printf("?ERROR - can't allocate space for graphics distance list \n");
     calc_neigh = 0;
      return;}

   for(l = 0 ; l < pick_list ; l++) { /* main loop */

   for(i = 0 ; i < find_neib ; i++) ndist[i] = 1.e+20;

   printf("Neighbours for %.4s:%.4s(%d):%.4s (charge %5.3f)\n",
                                             segment+4*iatom[l],
                                             resnam+4*iatom[l],
                                             res1[iatom[l]],
                                             atnam+4*iatom[l],
                                             atm_charge[iatom[l]]);

   for(i = mlists[current_struct] ; i < mliste[current_struct] ; i++) {

/* don't count non displayed atoms   */
   if(disp_list[i] == 0) continue;

   if((external == 1) && (res1[iatom[l]] == res1[i])) continue; 
   if(iatom[l] == i) continue;

   xd = x[iatom[l]] - x[i];
    yd = y[iatom[l]] - y[i];
     zd = z[iatom[l]] - z[i];

     dist = sqrt(xd*xd + yd*yd + zd*zd);

/* check stack and put into it if distance small enough */

     for(j = 0 ; j < find_neib ; j++) {
      if(dist < ndist[j]) {

       for(k = find_neib-1 ; k >= j ; k--) {
        ndist[k+1] = ndist[k];
        nlist[k+1] = nlist[k];}

         ndist[j] = dist;
         nlist[j] = i;
         break;}
      }

/*            done                                      */
   }
/* check how many atoms in the neibour list should be displayed */
   i=0;
   for(j = 0 ; j < find_neib ; j++)  if(ndist[j] < RCut) i++; 
/* search for min max                         */

   mxdist = 0.0;
   mndist = 1.e+20;

   for(j = 0 ; j < i ; j++) {
    if(ndist[j] < mndist) mndist = ndist[j];
    if(ndist[j] > mxdist) mxdist = ndist[j];}

/* order nlist suitable for draw_dist program */

   if(i < 1) {
   PrintMessage("?WARNING - in neighbours less than 1 point \n");
   goto NoHit;}

   for(j = i ; j > 0 ; j--) {
   nlist[2*j-1] = nlist[j-1];
   nlist[2*j-2] = iatom[l];} 


   if(term_type == 1 || term_type == 3) {

   calc_neigh = 1;

   graf_dist_list.num += 2*i; /* number of elements */
/* fill new list */
     if(calc_neigh > 0) {
       for(lstr = 0 ; lstr < 2*i ; lstr++) 
          graf_dist_list.list[lstr + shuffle] = nlist[lstr];}
   }


   shuffle += lstr;
   graf_dist_list.num = shuffle;

{
    int i1,j1;
    char hb;

    for(j = 0; j < 2*i ; j = j + 2) {
       i1 = nlist[j];
       j1 = nlist[j+1];

          tmp1 = (x[i1] - x[j1]);
          tmp2 = (y[i1] - y[j1]);
          tmp3 = (z[i1] - z[j1]);

       dist = sqrt(tmp1 * tmp1 +
                   tmp2 * tmp2 +
                   tmp3 * tmp3);

   if(find_hydr_bond(i1,j1,dist)) hb = 'Y';
   else
   hb = 'N';

   printf("               %.4s:%.4s(%d):%.4s , distance %f , h-bond %c (charge %5.3f)\n",segment+4*j1,
                                                           resnam+4*j1,
                                                           res1[j1],
                                                           atnam+4*j1,
                                                           dist,hb,
                                                           atm_charge[j1]);}

   }

NoHit:;
   }

/* free scratch space */
   free(iatom);
   free(nlist);
   free(ndist);
}

#ifdef sgi

/***************************************************************************/
void dialog4(text1 , text2 , input_text)    /* dialog box   */
/***************************************************************************/

      char *text1,*text2,*input_text;
{

        char	buff [DIALOG_BUFFER];
        char    TempB[BUFF_LEN];
        int     i;
        static float   vect[8];
        static float xm1,ym1,zm1,xm2,ym2,zm2;
        static float xm3,ym3,zm3,xm4,ym4,zm4;
        static float xm5,ym5,zm5,xm6,ym6,zm6;
        static float xl=0.5,yl=0.5,xr=1.0,yr=0.75;
        static long stringw;
        static int no=0;
        static float saveMV[4][4];
        static float saveP[4][4];
 
        stringw = strwidth(text2);
        getsize(&xsize,&ysize);
        getorigin(&xorg,&yorg);

         mmode(MVIEWING);
         getmatrix(saveMV); /* save transformation matrix */

      if(Model.Transformation) {
        mmode(MPROJECTION);
        getmatrix(saveP);
        mmode(MVIEWING);}


        for(i = 0 ; i < DIALOG_BUFFER ; i++) buff[i]='\0';

        frontbuffer(TRUE);
         zbuffer(FALSE);
          ortho2(0.0 , 1.0 , 0.0 , 1.0);
           loadmatrix(idmat);

        if(no == 0) {
        xm6 = xl + ((float)stringw) / ((float)xsize);
         ym6 = yl + 0.1;

        xm1 = xl;
         ym1 = yl;

        xm2 = xr;
         ym2 = yr;

               vect[0] = xl + 0.005; vect[1] = yl + 0.005;

                vect[2] = xr - 0.005 ; vect[3] = yl + 0.005;

                vect[4] = xr - 0.005; vect[5] = yr - 0.005;

                vect[6] = xl + 0.005   ; vect[7] = yr - 0.005; 

        xm3 = xl + 0.01;
         ym3 = yr - 0.1;

        xm4 = xl + 0.01;
         ym4 = yr - 0.7;

        xm5 = xl + 0.01;
         ym5 = yl + 0.1;

          no=0;}

        BOX_here();

        while(1) {
          while(qtest()) {  /* read the event queue */
               dev = qread(&val);
                   if (dev == KEYBD) { /* check that input is from keyboard */
                        c3s(BLUEv);
                        cmov2(xm6,ym6);
                        charstr(buff);

                   if (keyb_input(buff)) goto InputReady; 

                        c3s(WHITEv);
                        cmov2(xm6,ym6);
                        charstr(buff);

     if(Sline.Start < Sline.Llength) {
       strncpy(TempB,buff,BUFF_LEN);
       for(i = 0 ; i < strlen(buff) ; i++) buff[i] = ' ';
       strncpy(buff+Sline.Start,
               (TempB+Sline.Start),
               (Sline.Stop - Sline.Start + 1));
                        c3s(POINTER);
                        cmov2(xm6,ym6);
                        charstr(buff);
     }
		   }
	     }
	}

InputReady:;

        strncpy(input_text,buff,BUFF_LEN);

                        c3s(WHITEv);
                        cmov2(xm6,ym6);
                        charstr(buff);

        zbuffer(TRUE);
         frontbuffer(FALSE);

        mmode(MVIEWING);

        MakeOrtho();                          /* put transformation
                                                        matrix back */
         loadmatrix(saveMV);


      if(Model.Transformation) {
        mmode(MPROJECTION);
        loadmatrix(saveP);
        mmode(MVIEWING);}

          qreset();
        return; /* return now , bye bye */
}

#endif

/***************************************************************************/
plot_dist_list()
/***************************************************************************/
{

#ifdef sgi

/* display neighbours                                     */

    c3s(CYANv);

    draw_dist(graf_dist_list.num,graf_dist_list.list);

#else

    printf("?ERROR - not implemented on this device \n");

#endif

}












