/*  

                       Copyright (c) 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include "maxdefs.h"

#define SPHERE_PART      0
#define PLANE_PART       1
#define CYLINDER_PART    2
#define LINE_PART        3

#define RADIUS_OBJ       0
#define ALPHA_OBJ        1
#define COLOUR_OBJ       2
#define LOCATION_OBJ     3
#define DELETE_OBJ       4

     extern void  PrintMessage();
     extern int   name_to_rgb();
     extern int   SetTrajectoryUserLimits();
     extern int   ChangeLDPBounds();
     extern int   ChangeClusterBounds();
     extern int   ResetLDPBounds();
     extern int   ResetClusterBounds();

     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern float sumx;
     extern float sumy;
     extern float sumz;
     extern int max_traj_mem;
     extern int traj_in_core;


    extern struct LineSeg {
      int    Show;           /* if != 0 show the lines     */
      int    Lines;          /* number of lines            */
      float *LineCoord;      /* pointer to the coordinates */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
    } PlotLine;

    extern struct SphereSeg {
      int    Show;             /* if != 0 show the sphere      */
      int    Spheres;          /* number of spheres            */
      float *SphereCoord;      /* pointer to the coordinates   */
      float *Radius;           /* pointer to sphere radius     */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
      float *Alpha;
    } PlotSphere;

    extern struct PlaneSeg {
      int    Show;             /* if != 0 show the plane       */
      int    Planes;           /* number of planes             */
      float *PlaneCoord;       /* pointer to the coordinates   */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
      float *Alpha;
    } PlotPlane;

    extern struct {
      int NumCurves;
      int Step;
      int *NumObs;
      float *Xvalues;
      float *Yvalues;
      float *Zvalues;} PlotCurves;

    extern struct CylinderSeg {
      int    Show;           /* if != 0 show the cylinders       */
      int    Cylinders;          /* number of cylinders          */
      float *CylinderCoord;      /* pointer to the coordinates   */
      float *CylinderRad;        /* cylinder radius              */
      short *Red;            /* pointer to contain the colour */
      short *Green;
      short *Blue;
      float *Alpha;
    } PlotCylinder;

int AllowedCylinderObj();
int AllowedSphereObj();
int AllowedLineObj();
int AllowedPlaneObj();
int ChangeObjParam();
int MakeObjColour();
int ChangeSphereParams();
int ChangePlaneParams();
int ChangeCylinderParams();
int ChangeLineParams();

/************************************************************************/
modify_fac(input,num)   /* display command */
   char *input; 
   int num;
/************************************************************************/
{

     int i;
     int ihelp;
     char OutText[BUFF_LEN];

/* switch to small characters                 */
     toller(parsed[1]);

/* help modify                               */
   if(indexo(parsed[1],"?") == 1) {
   PrintMessage("modi*fy cyli*nder nr alph*a value           ! Modify object");
   PrintMessage("                     colo*ur  colour/r:g:b                 ");
   PrintMessage("                     loca*tion x1:y1:z1 x2:y2:z2           ");
   PrintMessage("                     radi*us  value                        ");
   PrintMessage("        line      nr colo*ur  colour/r:g:b                 ");
   PrintMessage("                     loca*tion x1:y1:z1 x2:y2:z2           ");
   PrintMessage("        plan*e    nr alph*a   value                        ");
   PrintMessage("                     colo*ur  colour/r:g:b                 ");
   PrintMessage("                      loca*tion 4 * x:y:z                  ");
   PrintMessage("        sphe*re   nr alpha value                           ");
   PrintMessage("                     colo*ur  colour/r:g:b                 ");
   PrintMessage("                     loca*tion x:y:z                       ");
   PrintMessage("                     radi*us  value                        ");
   PrintMessage("        traj*ectory  limi*ts  first last step              ");
   PrintMessage("                     memo*ry value              !(in MB)   ");
   PrintMessage("        ldp      rang*e  f1 f2 f3 f4 f5 f6 f7 f8 f9        ");
   PrintMessage("        clus*ter rang*e  f1 f2 f3 f4 f5 f6 f7 f8 f9        ");

   return;}

/* sphere                                    */
   if(indexo(parsed[1],"sphe") == 1) {
      toller(parsed[3]);
         if(indexo(parsed[3],"radi") == 1) {
            if(ChangeObjParam(SPHERE_PART , parsed[2] ,
                              RADIUS_OBJ ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in sphere object(s)");
            return;}
         if(indexo(parsed[3],"colo") == 1) {
            if(ChangeObjParam(SPHERE_PART , parsed[2] ,
                              COLOUR_OBJ ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in sphere object(s)");
            return;}
         if(indexo(parsed[3],"alph") == 1) {
            if(ChangeObjParam(SPHERE_PART ,  parsed[2] ,
                              ALPHA_OBJ   ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in sphere object(s)");
            return;}
         if(indexo(parsed[3],"loca") == 1) {
            if(ChangeObjParam(SPHERE_PART  ,  parsed[2] ,
                              LOCATION_OBJ ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in sphere object(s)");
            return;}
   }
/* plane                                    */
   if(indexo(parsed[1],"plan") == 1) {
      toller(parsed[3]);
         if(indexo(parsed[3],"colo") == 1) {
            if(ChangeObjParam(PLANE_PART , parsed[2] ,
                              COLOUR_OBJ ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in plane object(s)");
            return;}
         if(indexo(parsed[3],"alph") == 1) {
            if(ChangeObjParam(PLANE_PART ,  parsed[2] ,
                              ALPHA_OBJ   ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in plane object(s)");
            return;}
         if(indexo(parsed[3],"loca") == 1) {
            if(ChangeObjParam(PLANE_PART  ,  parsed[2] ,
                              LOCATION_OBJ ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in plane object(s)");
            return;}
   }
/* cylinder                                    */
   if(indexo(parsed[1],"cyli") == 1) {
      toller(parsed[3]);
         if(indexo(parsed[3],"radi") == 1) {
            if(ChangeObjParam(CYLINDER_PART , parsed[2] ,
                              RADIUS_OBJ ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in cylinder object(s)");
            return;}
         if(indexo(parsed[3],"colo") == 1) {
            if(ChangeObjParam(CYLINDER_PART , parsed[2] ,
                              COLOUR_OBJ ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in cylinder object(s)");
            return;}
         if(indexo(parsed[3],"alph") == 1) {
            if(ChangeObjParam(CYLINDER_PART ,  parsed[2] ,
                              ALPHA_OBJ   ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in cylinder object(s)");
            return;}
         if(indexo(parsed[3],"loca") == 1) {
            if(ChangeObjParam(CYLINDER_PART  ,  parsed[2] ,
                              LOCATION_OBJ ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in cylinder object(s)");
            return;}
   }

/* line                                    */
   if(indexo(parsed[1],"line") == 1) {
      toller(parsed[3]);
         if(indexo(parsed[3],"colo") == 1) {
            if(ChangeObjParam(LINE_PART , parsed[2] ,
                              COLOUR_OBJ ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in line object(s)");
            return;}
         if(indexo(parsed[3],"loca") == 1) {
            if(ChangeObjParam(LINE_PART  ,  parsed[2] ,
                              LOCATION_OBJ ,  parsed[4] ,
                              parsed[5]  , parsed[6] , parsed[7] ,
                              parsed[8]  , parsed[9] , parsed[10] ,
                              parsed[11] , parsed[12], parsed[13],
                              parsed[14] , parsed[15])) 
            PrintMessage("?ERROR - in line object(s)");
            return;}
   }

/* set maximun trajectory store memory                       */
      if(indexo(parsed[1],"traj") == 1) {
         toller(parsed[2]);

         if(indexo(parsed[2],"memo") == 1) {
           sprintf(OutText,
               "Maximum trajectory memory is now: %d Mbytes",max_traj_mem);
           PrintMessage(OutText);
           ihelp = atoi(parsed[3]);
           if(ihelp < 1) return;
           sprintf(OutText,
                "Maximum trajectory memory limit changed to: %d Mbytes",ihelp);
           PrintMessage(OutText);
           max_traj_mem = ihelp;
           traj_in_core = 0; /* reset switch to force check */
           return;}

         if(indexo(parsed[2],"limi") == 1) {
            if(SetTrajectoryUserLimits(atoi(parsed[3]) ,
                                       atoi(parsed[4]) ,
                                       atoi(parsed[5]))) {
                                       return;}
         return;}
       }


/* modify LDP ranges                  */
      if(indexo(parsed[1],"ldp") == 1) {
         toller(parsed[2]);
         if(indexo(parsed[2],"rang") == 1) {
            if(ChangeLDPBounds(parsed[3] , parsed[4] , parsed[5] ,
                               parsed[6] , parsed[7] , parsed[8] ,
                               parsed[9] , parsed[10], parsed[11])) {
               PrintMessage("?ERROR - can't change LDP ranges");
               return;}
         return;}
       }

/* modify CLUSTER ranges                  */
      if(indexo(parsed[1],"clus") == 1) {
         toller(parsed[2]);
         if(indexo(parsed[2],"rang") == 1) {
            if(ChangeClusterBounds(parsed[3] , parsed[4] , parsed[5] ,
                                   parsed[6] , parsed[7] , parsed[8] ,
                                   parsed[9] , parsed[10], parsed[11])) {
               PrintMessage("?ERROR - can't change cluster ranges");
               return;}
         return;}
       }


/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of modify_fac */

/************************************************************************/
int ChangeObjParam(int WhichObj , char *Part0 , int WhichParam , 
                     char *Part1 , char *Part2 , char *Part3 ,
                     char *Part4 , char *Part5 , char *Part6 ,
                     char *Part7 , char *Part8 , char *Part9 ,
                     char *Part10, char *Part11, char *Part12)
/************************************************************************/
{
       int WhichNumb;


       WhichNumb = atoi(Part0);

       switch(WhichObj) {

       case SPHERE_PART:   
       if(ChangeSphereParams(WhichNumb , WhichParam , Part1, Part2 , Part3)) {
          PrintMessage("?ERROR - in change of sphere parameters");
          return(1);}
       break;

       case PLANE_PART:
       if(ChangePlaneParams(WhichNumb , WhichParam , 
                            Part1 , Part2 , Part3 ,
                            Part4 , Part5 , Part6 ,
                            Part7 , Part8 , Part9 ,
                            Part10, Part11, Part12)) {
          PrintMessage("?ERROR - in change of plane parameters");
          return(1);}
       break;

       case CYLINDER_PART:
       if(ChangeCylinderParams(WhichNumb , WhichParam , 
                                 Part1, Part2 , Part3 ,
                                 Part4, Part5 , Part6)) {
          PrintMessage("?ERROR - in change of cylinder parameters");
          return(1);}
       break;

       case LINE_PART:
       if(ChangeLineParams(WhichNumb , WhichParam , 
                             Part1, Part2 , Part3 ,
                             Part4, Part5 , Part6)) {
          PrintMessage("?ERROR - in change of line parameters");
          return(1);}
       break;

       default:
       PrintMessage("?ERROR  - serious error");
       break;
     }

       return(0);
}
/************************************************************************/
int ChangeSphereParams(int WhichNumb , int WhichParam , 
                       char *Part1 , char *Part2 , char *Part3)
/************************************************************************/
{

     if(AllowedSphereObj(WhichNumb))
                         return(1);

     switch(WhichParam) {

     case RADIUS_OBJ:
          PlotSphere.Radius[WhichNumb - 1] = atof(Part1);
          return(0);
          break;

     case ALPHA_OBJ:
          PlotSphere.Alpha[WhichNumb - 1]  = atof(Part1);
          return(0);
          break;

     case COLOUR_OBJ:
          if(MakeObjColour(Part1 , Part2 , Part3 , 
             &PlotSphere.Red[WhichNumb   - 1]   ,
             &PlotSphere.Green[WhichNumb - 1] ,
             &PlotSphere.Blue[WhichNumb  - 1])) {
            PrintMessage("?ERROR - can't change colour");
            return(1);}
          break;

     case LOCATION_OBJ:
        PlotSphere.SphereCoord[3 * (WhichNumb - 1)    ]  = atof(Part1) - sumx;
        PlotSphere.SphereCoord[3 * (WhichNumb - 1) + 1]  = atof(Part2) - sumy;
        PlotSphere.SphereCoord[3 * (WhichNumb - 1) + 2]  = atof(Part3) - sumz;
        break;

     }

     return(0);
}
/************************************************************************/
int ChangePlaneParams(int WhichNumb , int WhichParam ,
                         char *Part1 , char *Part2 , char *Part3 ,
                         char *Part4 , char *Part5 , char *Part6 ,
                         char *Part7 , char *Part8 , char *Part9 ,
                         char *Part10, char *Part11, char *Part12)
/************************************************************************/
{

     if(AllowedPlaneObj(WhichNumb))
                         return(1);

     switch(WhichParam) {

     case ALPHA_OBJ:
          PlotPlane.Alpha[WhichNumb - 1]  = atof(Part1);
          return(0);
          break;

     case COLOUR_OBJ:
          if(MakeObjColour(Part1 , Part2 , Part3 , 
             &PlotPlane.Red[WhichNumb   - 1]   ,
             &PlotPlane.Green[WhichNumb - 1] ,
             &PlotPlane.Blue[WhichNumb  - 1])) {
            PrintMessage("?ERROR - can't change colour");
            return(1);}
          break;

     case LOCATION_OBJ:
       PlotPlane.PlaneCoord[12 * (WhichNumb - 1)    ]  = atof(Part1) - sumx;
       PlotPlane.PlaneCoord[12 * (WhichNumb - 1) + 1]  = atof(Part2) - sumy;
       PlotPlane.PlaneCoord[12 * (WhichNumb - 1) + 2]  = atof(Part3) - sumz;
       PlotPlane.PlaneCoord[12 * (WhichNumb - 1) + 3]  = atof(Part4) - sumx;
       PlotPlane.PlaneCoord[12 * (WhichNumb - 1) + 4]  = atof(Part5) - sumy;
       PlotPlane.PlaneCoord[12 * (WhichNumb - 1) + 5]  = atof(Part6) - sumz;
       PlotPlane.PlaneCoord[12 * (WhichNumb - 1) + 6]  = atof(Part7) - sumx;
       PlotPlane.PlaneCoord[12 * (WhichNumb - 1) + 7]  = atof(Part8) - sumy;
       PlotPlane.PlaneCoord[12 * (WhichNumb - 1) + 8]  = atof(Part9) - sumz;
       PlotPlane.PlaneCoord[12 * (WhichNumb - 1) + 9]  = atof(Part10) - sumx;
       PlotPlane.PlaneCoord[12 * (WhichNumb - 1) +10]  = atof(Part11) - sumy;
       PlotPlane.PlaneCoord[12 * (WhichNumb - 1) +11]  = atof(Part12) - sumz;
       break;

     }

     return(0);
}
/************************************************************************/
int ChangeCylinderParams(int WhichNumb , int WhichParam ,
                         char *Part1 , char *Part2 , char *Part3 ,
                         char *Part4 , char *Part5 , char *Part6)
/************************************************************************/
{

     if(AllowedCylinderObj(WhichNumb))
                         return(1);

     switch(WhichParam) {

     case RADIUS_OBJ:
          PlotCylinder.CylinderRad[WhichNumb - 1] = atof(Part1);
          return(0);
          break;

     case ALPHA_OBJ:
          PlotCylinder.Alpha[WhichNumb - 1]  = atof(Part1);
          return(0);
          break;

     case COLOUR_OBJ:
          if(MakeObjColour(Part1 , Part2 , Part3 , 
             &PlotCylinder.Red[WhichNumb   - 1]   ,
             &PlotCylinder.Green[WhichNumb - 1] ,
             &PlotCylinder.Blue[WhichNumb  - 1])) {
            PrintMessage("?ERROR - can't change colour");
            return(1);}
          break;

     case LOCATION_OBJ:
       PlotCylinder.CylinderCoord[6 * (WhichNumb - 1)    ]  = atof(Part1) - sumx;
       PlotCylinder.CylinderCoord[6 * (WhichNumb - 1) + 1]  = atof(Part2) - sumy;
       PlotCylinder.CylinderCoord[6 * (WhichNumb - 1) + 2]  = atof(Part3) - sumz;
       PlotCylinder.CylinderCoord[6 * (WhichNumb - 1) + 3]  = atof(Part4) - sumx;
       PlotCylinder.CylinderCoord[6 * (WhichNumb - 1) + 4]  = atof(Part5) - sumy;
       PlotCylinder.CylinderCoord[6 * (WhichNumb - 1) + 5]  = atof(Part6) - sumz;
       break;

     }

     return(0);
}
/************************************************************************/
int ChangeLineParams(int WhichNumb , int WhichParam ,
                    char *Part1 , char *Part2 , char *Part3 ,
                    char *Part4 , char *Part5 , char *Part6)
/************************************************************************/
{

     if(AllowedLineObj(WhichNumb))
                         return(1);

     switch(WhichParam) {

     case COLOUR_OBJ:
          if(MakeObjColour(Part1 , Part2 , Part3 , 
             &PlotLine.Red[WhichNumb   - 1]   ,
             &PlotLine.Green[WhichNumb - 1] ,
             &PlotLine.Blue[WhichNumb  - 1])) {
            PrintMessage("?ERROR - can't change colour");
            return(1);}
          break;

     case LOCATION_OBJ:
       PlotLine.LineCoord[6 * (WhichNumb - 1)    ]  = atof(Part1) - sumx;
       PlotLine.LineCoord[6 * (WhichNumb - 1) + 1]  = atof(Part2) - sumy;
       PlotLine.LineCoord[6 * (WhichNumb - 1) + 2]  = atof(Part3) - sumz;
       PlotLine.LineCoord[6 * (WhichNumb - 1) + 3]  = atof(Part4) - sumx;
       PlotLine.LineCoord[6 * (WhichNumb - 1) + 4]  = atof(Part5) - sumy;
       PlotLine.LineCoord[6 * (WhichNumb - 1) + 5]  = atof(Part6) - sumz;
       break;

     }

     return(0);
}
/************************************************************************/
int AllowedSphereObj(int Number)
/************************************************************************/
{

    if(Number < 1) {
       PrintMessage("?ERROR - object number less than zero");
       return(1);}

    if(Number > PlotSphere.Spheres) {
       PrintMessage("?ERROR - object number greater than max numbers");
       return(1);}

     return(0);
}
/************************************************************************/
int AllowedCylinderObj(int Number)
/************************************************************************/
{

    if(Number < 1) {
       PrintMessage("?ERROR - object number less than zero");
       return(1);}

    if(Number > PlotCylinder.Cylinders) {
       PrintMessage("?ERROR - object number greater than max numbers");
       return(1);}

     return(0);
}
/************************************************************************/
int AllowedPlaneObj(int Number)
/************************************************************************/
{

    if(Number < 1) {
       PrintMessage("?ERROR - object number less than zero");
       return(1);}

    if(Number > PlotPlane.Planes) {
       PrintMessage("?ERROR - object number greater than max numbers");
       return(1);}

     return(0);
}
/************************************************************************/
int AllowedLineObj(int Number)
/************************************************************************/
{

    if(Number < 1) {
       PrintMessage("?ERROR - object number less than zero");
       return(1);}

    if(Number > PlotLine.Lines) {
       PrintMessage("?ERROR - object number greater than max numbers");
       return(1);}

     return(0);
}
/************************************************************************/
int MakeObjColour(char *Part1 , char *Part2 , char *Part3 ,
                  short *RedC , short *GreenC , short *BlueC)
/************************************************************************/
{
    if(Part1[0] != NULL) {
       if(isalpha(Part1[0])) {
         if(name_to_rgb(Part1 , RedC , GreenC , BlueC)) {
         PrintMessage("?ERROR - can't resolve the colour");
         return(1);}}
       else {
         *RedC   = (short)atoi(Part1);
         *GreenC = (short)atoi(Part2);
         *BlueC  = (short)atoi(Part3);}}
     else {
        PrintMessage("?ERROR - colour missing");
        return(1);}

    return(0);

}
