
/* definitions                   */

#define BUFF_LEN  256      /* default buffer length for text */

#define  MAXobjects  50      /*  Max graphical objects allowed */
#define  MAXconn 10
#define  MAXatm  5000        /*  Maximum number of atoms at start */
#define  MAXcat   100        /*  Maximum number of colour atoms */
#define  GRIDB 0.2        /* square radius of sphere around a point which 
                             is regarded as a hit */
#define  MAXmom  10           /*  Highest moment                    */
#define GAP_dist 25.          /*  Gap distance for different alpha-carbon */
#define MAXsphp   1000            /*  Max points in the surface generation  */
#define MAXcylp   1000
#define MAXatc   250      /*  Max number of elements in the parameter file */
#define Sphere_max   40 /*  A sphere is max divided in 10 segments (20 segments
                              for the other angle     */
#define LIMIT 0.2       /* square radius of sphere around a point which 
                           is regarded as a hit */
#define COVdelt 0.4     /* tolerance value when calculating connectivity */
#define MAXelements 94  /* max number of elements in the covalent list */
#define MAXlinel BUFF_LEN   /* max line length */
#define MAXparse 80    /* max deep of parse */
#define MAXwater   100    /* max entries for the water specifity */
#define SCREENXP   getgdesc(GD_XPMAX)   /* screen pixels in x-direction */
#define SCREENYP   getgdesc(GD_YPMAX)   /* screen pixels in y-direction */

#define MAXft      2000    /* maximum number of different atoms defined */

#define MAX_COL 800        /* max colours in the colour table */
#define MAX_COL_LEN 40     /* max num of characters for colour name */

#define MAX_MLIST 10       /* max number of molecules in the display list */

#define MAX_FILES 10       /* number of recursive files allowed */

#define MAX_SAVE  30      /* stack depth to save commands */

#define PORTline 20         /* lines of text displayed in the window */
#define PORTchar BUFF_LEN        /* characters on one text line */

#define MAX_ENT_ON_LINE 100 /* max entries on one line for parsing the
                               selection list */

#define MAX_SEG_NAME_LEN 4 /* max four characters */

#define MAX_RES_NAME_LEN 4 /* max four characters */

#define MAX_ATM_NAME_LEN 4 /* max four characters */

#define SEP_STRING " :="   /* separator string to the own parser function */

#define SEP_COLOR  "^"     /* separator string for rgb colors             */

#define SEP_BOX    "^"     /* separator string for the box dimensions  */

#define SEP_STRUCT '^'     /* separator character for structures       */

#define MIN_W_X 40         /* smallest window size in x-direction */

#define MIN_W_Y 40         /* smallest window size in y-direction */

#define CURS_TYPE  6       /* coffee cup (see cursors.h for other)  */

#define MAX_CONT   50      /* maximum contouring levels */

#define MAX_TITLE_LINES_TRAJ 100       /* max number of title lines in the 
                                          CHARMM trajectory */

#define BACKBUFFER    0     /* these are used in the text output funtions */
#define FRONTBUFFER   1

#define QUEUE_LEN 500         /* length of the event queue buffer */

#define USE_ORTHO       0     /* no perspective                   */

#define USE_PERSPECTIVE 1     /*    perspective                   */

#define MAX_CONTOURS    50    /* max number of countours (files/entries) */

#define REP_CHAR    "%"       /* repetition character (used in atom fields) */

#define UPDATE_ON    1        /* update screen */

#define UPDATE_OFF   0        /* do not update screen */

/* type of plots supported */
#define  MOLECULE_PLOT 1
#define  LDP_PLOT      2
#define  RAMA_PLOT     3
#define  CLUSTER_PLOT  4

/* type of coordinate files supported */

#define CHARMM_COORD    1
#define FREE_COORD      2
#define INSIGHT_COORD   3
#define AMBER_COORD     4
#define YASP_COORD      5
#define MUMOD_COORD     6
#define GROMOS_COORD    7
#define MOPAC_COORD     8
#define PDB_COORD       9
#define GAMESS_COORD   10
#define OPENMOL_COORD  11
#define HYPER_COORD    12
#define SOCKET_COORD   13

/* ................................. */

/* for window control */

#define MAX_WINDOWS 10
#define MAX_PLOTS   10

