/*  

                       Copyright (c) 1990, 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "maxdefs.h"

extern void PrintMessage();
extern int keyb_command;
extern int ArrayManipulation();
extern int DoTheJobSpec();

extern int    MSDdataSet();
extern int    GetNumCorrObs();
extern float *GetCorrVec();
extern int    GetNumRDFObs();
extern float *GetRDFVecX();
extern float *GetRDFVecY();
extern int    GetMSDObs();
extern float *GetMSDVec();
extern int GetPowerObs();
extern int GetPowerVec();
extern float *GetDynamVec();
extern int    GetNumDynamVec();

    extern struct {
      int corr_wind;   /* switch to indicate that window is on = 1 , off = 0 */
      int corr_vec1;   /* number of correlation vector 1 */
      int corr_vec2;   /* number of correlation vector 2 */
      int corr_obs;    /* number of points in vectors 1 and 2 */
      float *corr_val;} /* pointer to the correlation values */  
    corr_info;

    extern  struct {
       int    Mean;                   /* != 0 average is calulated  */
       int    Plot;                   /* != 0 plot is on            */
       int    Set;                    /* != 0 collection is on      */
       int    Numbers;                /* number of observations     */
       float *XValues;                /* X - pointer to values      */
       float *YValues;                /* Y - pointer to values      */
     } RaDiFu;

    int man_times_int;
    int times_nr;
    float man_times_float;

    struct {
    int Type;        /* = 0 , unknown
                        = 1 , time series
                        = 2 , correlation
                        = 3 , mean square displacement
                        = 4 , radial distribution function
                     */
             } ManiType = { 0 };


/************************************************************************/
manipulate_fac(input,num)   /* manipulate time series */
   char *input; 
   int num;
/************************************************************************/
{

     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     int i;
     char OutText[BUFF_LEN];

/* switch to small characters                 */
     toller(parsed[1]);

/* help text                                  */
     if(indexo(parsed[1],"?") == 1) {
     PrintMessage("mani*pulate time*series      alt iseries ");
     PrintMessage("            corr*elation     alt");
     PrintMessage("            msdi*splacement  alt");
/*     PrintMessage("            powe*r           alt");*/
     PrintMessage("            rdf              alt");

     printf(" (The capital letters gives the needed characters for an alt) \n \
     DAVErage  ;  Q(t) = Q(t) - <Q(t)> \n \
     SQUAre  ;  Q(t) = Q(t) ** 2   \n \
     COS  ;  Q(t) = cos(Q(t))  \n \
     COS2  ;  Q(t) = 3*cos(Q(t))**2 - 1   \n \
     SQRT  ;  Q(t) = sqrt(Q(t))  \n \
     DINItial  ;  Q(t) = Q(t) - Q(0)  \n \
     COPY nr ;  Q(t) = Q2(t)   \n \
     ADD nr ;  Q(t) = Q(t) + Q2(t)   \n \
     LOG ;  Q(t) = log(Q(t))  \n \
     EXP ;  Q(t) = exp(Q(t))  \n \
     POWer real ;  Q(t) = Q(t) ** real  \n \
     MULT real ;  Q(t) = real * Q(t)  \n \
     DIVIde real ;  Q(t) = Q(t) / real  \n \
     SHIFt real ;  Q(t) = Q(t) + real  \n \
     DMIN ;  Q(t) = Q(t) - Q(min) \n \
     ABS ;  Q(t) = abs(Q(t)) \n \
     DIVFirst ;  Q(t) = Q(t) / Q(0)  \n \
     DIVMaximum ;  Q(t) = Q(t) /max(Q(t))  \n \
     PSPEctrum nr ; Power spectrum \n \
     ZERO ;  Q(t) = 0.0  \n");
     return;}

     if(indexo(parsed[1],"time") == 1) {  /* manipulate time series */

     toller(parsed[2]);

/* DAVErag                          */
   if(indexo(parsed[2],"dave") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   keyb_command = 1;
   study_dynamics(26);
    ManiType.Type = 0;
   return;
   }

/* SQUAre                          */
   if(indexo(parsed[2],"squa") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   keyb_command = 1;
   study_dynamics(27);
    ManiType.Type = 0;
   return;
   }

/* COS                          */
   if(indexo(parsed[2],"cos") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   keyb_command = 1;
   study_dynamics(28);
    ManiType.Type = 0;
   return;
   }

/* COS2                          */
   if(indexo(parsed[2],"cos2") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   keyb_command = 1;
   study_dynamics(29);
    ManiType.Type = 0;
   return;
   }

/* SQRT                          */
   if(indexo(parsed[2],"sqrt") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   keyb_command = 1;
   study_dynamics(30);
    ManiType.Type = 0;
   return;
   }

/* DINItial                          */
   if(indexo(parsed[2],"dini") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   keyb_command = 1;
   study_dynamics(31);
    ManiType.Type = 0;
   return;
   }

/* COPY                          */
   if(indexo(parsed[2],"copy") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
    man_times_int = atoi(parsed[4]);
   keyb_command = 1;
   study_dynamics(32);
    ManiType.Type = 0;
   return;
   }

/* ADD                          */
   if(indexo(parsed[2],"add") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
    man_times_int = atoi(parsed[4]);
   keyb_command = 1;
   study_dynamics(33);
    ManiType.Type = 0;
   return;
   }

/* log                          */
   if(indexo(parsed[2],"log") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   study_dynamics(34);
    ManiType.Type = 0;
   return;
   }

/* exp                          */
   if(indexo(parsed[2],"exp") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   keyb_command = 1;
   study_dynamics(35);
    ManiType.Type = 0;
   return;
   }

/* powe                          */
   if(indexo(parsed[2],"powe") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
    man_times_float = atof(parsed[4]);
   keyb_command = 1;
   study_dynamics(36);
    ManiType.Type = 0;
   return;
   }

/* mult                          */
   if(indexo(parsed[2],"mult") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
    man_times_float = atof(parsed[4]);
   keyb_command = 1;
   study_dynamics(37);
    ManiType.Type = 0;
   return;
   }

/* DIVIde                          */
   if(indexo(parsed[2],"divi") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
    man_times_float = atof(parsed[4]);
   keyb_command = 1;
   study_dynamics(38);
    ManiType.Type = 0;
   return;
   }

/* SHIFt                          */
   if(indexo(parsed[2],"shif") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
    man_times_float = atof(parsed[4]);
   study_dynamics(39);
    ManiType.Type = 0;
   return;
   }

/* DMIN                          */
   if(indexo(parsed[2],"dmin") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   keyb_command = 1;
   study_dynamics(40);
    ManiType.Type = 0;
   return;
   }

/* ABS                          */
   if(indexo(parsed[2],"abs") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   keyb_command = 1;
   study_dynamics(41);
    ManiType.Type = 0;
   return;
   }

/* DIVFirst                          */
   if(indexo(parsed[2],"divf") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   keyb_command = 1;
   study_dynamics(42);
    ManiType.Type = 0;
   return;
   }

/* DIVMaximum                          */
   if(indexo(parsed[2],"divm") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   keyb_command = 1;
   study_dynamics(43);
    ManiType.Type = 0;
   return;
   }

/* ZERO                          */
   if(indexo(parsed[2],"zero") == 1) {
    ManiType.Type = 1;
    times_nr = atoi(parsed[3]);
   keyb_command = 1;
   study_dynamics(44);
    ManiType.Type = 0;
   return;
   }

/* POWEr spectrum                */
   if(indexo(parsed[2],"pspe") == 1) {
    ManiType.Type = 1;
     times_nr = atoi(parsed[3]);
     (void)DoTheJobSpec(GetDynamVec(times_nr) , GetNumDynamVec());
    ManiType.Type = 0;
    return;}
   }

    if(indexo(parsed[1],"corr") == 1) {  /* manipulate correlation */
      if(corr_info.corr_obs == 0) {
         PrintMessage("?ERROR - no correleation data to write ");
         return(1);}
        ManiType.Type = 2;
        (void)ArrayManipulation(parsed[2] ,GetNumCorrObs() , 
                                           GetCorrVec()    , parsed[3]);
        ManiType.Type = 0;
      return(0);
     }

    if(indexo(parsed[1],"rdf") == 1) {  /* manipulate rdf */
      if(!RaDiFu.Set || !RaDiFu.Numbers) {
         PrintMessage("?ERROR - no RDF to be written to disk");
         return(1);}
        ManiType.Type = 3;
        (void)ArrayManipulation(parsed[2] , GetNumRDFObs() , 
                                            GetRDFVecY() , parsed[3]);
        ManiType.Type = 0;
        return(0);
     }

    if(indexo(parsed[1],"msdi") == 1 ||
        indexo(parsed[1],"cmsd") == 1) {  /* manipulate MSD */
    if(!MSDdataSet()) {
        PrintMessage("?ERROR - no array for the mean square displacement defined");
         return(1);}
        ManiType.Type = 4;
        (void)ArrayManipulation(parsed[2] , GetMSDObs() , 
                                            GetMSDVec() , parsed[3]);
        ManiType.Type = 0;
        return(0);
     }

#ifdef JUNK
    if(indexo(parsed[1],"powe") == 1 ||
        indexo(parsed[1],"pspe") == 1) {  /* manipulate POWER spectrum */
        (void)ArrayManipulation(parsed[2] , GetPowerObs , 
                                            GetPowerVec , parsed[3]);
        return(0);
     }
#endif
/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of manipulate_fac */













