/*  

                       Copyright (c) 1990, 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#ifdef sgi
#include <gl.h>
#include <device.h>
#endif
#include <setjmp.h>
#include "traja.h"
#include "maxdefs.h"

#define TRANSLATE(a,b,c) translate(a,b,c)

#define CHECK_LINE_LEN(i)         {   if(i >= BUFF_LEN) { \
                                  printf("?ERROR - input buffer full \n");\
                                  line_length = BUFF_LEN - 1;\
                                  where_in_line = BUFF_LEN - 1;\
                                  return(0);}}

#define DELETE_ON_LINE()          {if(where_in_line == line_length) {\
                                   line_length--;\
                                    where_in_line--;\
                                     if(line_length < 0) \
                                        line_length = 0;\
                                     if(where_in_line < 0)\
                                        where_in_line = 0;\
                                      \
                                      buff[line_length] = '\0';\
                                      input_text[line_length] = '\0';\
                                      strncpy(input_text,buff,BUFF_LEN);\
                             Sline.Start   = Sline.Stop = where_in_line;\
                             Sline.Llength = line_length;\
                                      return(0);}\
                                  else {\
                                     if(where_in_line == 0) {\
                             Sline.Start   = Sline.Stop = where_in_line;\
                             Sline.Llength = line_length;\
                                      return(0);}\
                                                 \
                             for(i = where_in_line ; i < line_length ; i++)\
                                     buff[i-1] = buff[i];\
                                     line_length--;\
                                     where_in_line--;\
                                     buff[line_length] = '\0';\
                                     strncpy(input_text,buff,BUFF_LEN);\
                             Sline.Start   = Sline.Stop = where_in_line;\
                             Sline.Llength = line_length;\
                                     return(0);}}

#define DELETE_CURR_CHAR()        {if(where_in_line == line_length) {\
                                   line_length--;\
                                    where_in_line--;\
                                     if(line_length < 0) \
                                        line_length = 0;\
                                     if(where_in_line < 0)\
                                        where_in_line = 0;\
                                      \
                                      buff[line_length] = '\0';\
                                      input_text[line_length] = '\0';\
                                      strncpy(input_text,buff,BUFF_LEN);\
                             Sline.Start   = Sline.Stop = where_in_line;\
                             Sline.Llength = line_length;\
                                      return(0);}\
                                  else {\
                                     if(where_in_line == 0) {\
                             for(i = where_in_line + 1; i < line_length ; i++)\
                                     buff[i-1] = buff[i];\
                                      line_length--;\
                                       if(line_length < 0)\
                                          line_length = 0;\
                                      buff[line_length] = '\0';\
                                      strncpy(input_text,buff,BUFF_LEN);\
                             Sline.Start   = Sline.Stop = where_in_line;\
                             Sline.Llength = line_length;\
                                      return(0);}\
                                                 \
                             for(i = where_in_line + 1; i < line_length ; i++)\
                                     buff[i-1] = buff[i];\
                                     line_length--;\
                                     where_in_line--;\
                                     buff[line_length] = '\0';\
                                     strncpy(input_text,buff,BUFF_LEN);\
                             Sline.Start   = Sline.Stop = where_in_line;\
                             Sline.Llength = line_length;\
                                     return(0);}}



extern jmp_buf jumper;

     extern void send_command();
     extern int HowManyDigits();
     extern int save_deep;
     extern char save_stack[MAXparse][MAXlinel];

     extern int  save_input_l;                   /* stack depth            */
     extern char save_input[MAX_SAVE][MAXlinel]; /* save commands in stack */

        extern float near;
        extern short BLUEv[3];
        extern short WHITEv[3];
        extern float rotB[][4];
        extern int dev ;
        extern short val;


   extern struct Bline {
      int Start;      /* index to a filed in the message start point */
      int Stop;       /*                                 end   point */
      int Llength;    /* length of message line                      */
      char *Message;}
                      Sline;

/*

  I will reserve ascii value 26 (decimal) as a channel into this function
  from other parts of SCARECROW

*/

/***************************************************************************/
int keyb_input( input_text )    /* input from keyboard   */
/***************************************************************************/

      char *input_text;
{

        static char    buff [BUFF_LEN] = {"\0"};
        static int i                     = 0;
        static int   where_in_save_input = 0;
        static int   where_in_line       = 0;
        static int   line_length         = 0;

/* I can't get switch to hook on val = 127 (del character) so will do it
   up here */

        if(val == 127) 
          DELETE_ON_LINE();


/* end of curiosity               */

        switch(val) {

        case 0:  return(0);
        case 1:  /* ^A , beginning of line */
                 where_in_line = 0;
                 Sline.Start   = Sline.Stop = where_in_line;
                 return(0);
        case 2:  /* ^B , move on input line one character backwards */ 
                 where_in_line--;
                 if(where_in_line < 0) {
                    printf("\007\n");
                    where_in_line = 0;}
                 strncpy(input_text,buff,BUFF_LEN);
                 Sline.Start   = Sline.Stop = where_in_line;
                 Sline.Llength = line_length;
                 return(0);
        case 3:  /* ^C ,  make a longjmp */
                 longjmp(jumper,1);
        case 4:  /* ^D , delete current character */
                 DELETE_CURR_CHAR();
        case 5:  /* ^E , go to end of line */
                  where_in_line = line_length;
                  Sline.Start   = Sline.Stop = where_in_line;
                  return(0);
        case 6:  /* ^F , move on input line one character forward */
                 where_in_line++;
                 if(where_in_line >  line_length) { /* end of line */
                    printf("\007\n");
                     where_in_line = line_length;}
                 strncpy(input_text,buff,BUFF_LEN);
                 Sline.Start   = Sline.Stop = where_in_line;
                 Sline.Llength = line_length;
                 return(0);
        case 7:  return(0);
        case 9:  return(0);
/*      case 10  is now after case 12 ... */
        case 11: /* ^K , delete to end of line */
                 if(where_in_line < line_length) {
                    for(i = where_in_line ; i < line_length ; i++)
                        buff[i] = '\0';
                    line_length = where_in_line;
                    strncpy(input_text,buff,BUFF_LEN);
                    Sline.Start   = Sline.Stop = where_in_line;
                    Sline.Llength = line_length;}
                 return(0);
        case 12: return(0);
        case 10: /* <lf> means end of line */
        case 13: /* <cr> means end of line */
                 buff[line_length] = '\0';
                 strcpy(input_text,buff);
                 for(i = 0 ; i < BUFF_LEN ; i++ ) buff[i] = '\0';
                 line_length = 0;
                 where_in_line = 0;
                 Sline.Start   = Sline.Stop = where_in_line;
                 Sline.Llength = line_length;
                 where_in_save_input = 0;
                 return(1); /* return now , bye bye */
        case 14:  /* rotate input command buffer forward */
                 where_in_save_input--;
                 if(where_in_save_input <= 0) {
                    where_in_save_input = 0;
                    printf("\007\n");}

                 strncpy(input_text,save_input[where_in_save_input],BUFF_LEN);
                 strncpy(buff,save_input[where_in_save_input],BUFF_LEN);
                 line_length = where_in_line = 
                             strlen(save_input[where_in_save_input]);
                 Sline.Start   = Sline.Stop = where_in_line;
                 Sline.Llength = line_length;
                 return(0);
        case 15: return(0);
        case 16:  /* rotate input command buffer backwards */ 
                 where_in_save_input++;
                 if(where_in_save_input ==  save_input_l) {
                    where_in_save_input = save_input_l -1;
                    printf("\007\n");}

                 strncpy(input_text,save_input[where_in_save_input],BUFF_LEN);
                 strncpy(buff,save_input[where_in_save_input],BUFF_LEN);
                 line_length = where_in_line = 
                             strlen(save_input[where_in_save_input]);
                 Sline.Start   = Sline.Stop = where_in_line;
                 Sline.Llength = line_length;
                 return(0);
        case 17: return(0);
        case 18: return(0);
        case 19: return(0);
        case 20: return(0);
        case 21: /* ^U ,  is delete line */
                    input_text[0] = '\0';
                 for(i = 0 ; i < BUFF_LEN ; i++) 
                    buff[i] = '\0';
                 line_length = 0;
                 where_in_line = 0;
                 return(0);
        case 22: return(0);
        case 23: return(0);
        case 24: return(0);
        case 25: return(0);
        case 26: /* special entry into this function */
                 strncpy(buff,input_text,BUFF_LEN);
                 line_length = where_in_line = 
                             strlen(input_text);
                 Sline.Start   = Sline.Stop = where_in_line;
                 Sline.Llength = line_length;
                 return(0);
        case 27: return(0);
        case 28: return(0);
        case 29: return(0);
        case 30: return(0);
        case 31: return(0);

        case   8: /* backspace character *
        case 127: /* delete character */

         DELETE_ON_LINE();

         default: /* add new characters here ... */
           if(where_in_line == line_length) {
             buff[where_in_line] = val;
              line_length++;
              where_in_line++;
              strncpy(input_text,buff,BUFF_LEN);
              CHECK_LINE_LEN(line_length);
                 Sline.Start   = Sline.Stop = where_in_line;
                 Sline.Llength = line_length;
             return(0);}
           else {
              CHECK_LINE_LEN(line_length + 1);
              for(i = line_length - 1 ; i >= where_in_line ; i--) 
                  buff[i+1] = buff[i];
              buff[where_in_line] = val;
              line_length++;
              where_in_line++;
              strncpy(input_text,buff,BUFF_LEN);
                 Sline.Start   = Sline.Stop = where_in_line;
                 Sline.Llength = line_length;
              return(0);}

      }
}




/***************************************************************************/
PrintHistory()
/***************************************************************************/
{
    int i;
    char OutText[BUFF_LEN];

    for(i = 0 ; i < save_input_l ; i++) {
       sprintf(OutText,"%d %s",(i+1),save_input[i]);
       PrintMessage(OutText);}
}
/***************************************************************************/
TakeFromStack(Text)
     char *Text;
/***************************************************************************/
{
     int i;
     char OutText[BUFF_LEN];

     if(Text[1] == '!') {   /* take the latest command and send it */
      strncpy(OutText,save_input[0],BUFF_LEN);
      strncat(OutText,Text+2,(BUFF_LEN - strlen(OutText)));
      send_command(OutText);
       return; 
        }

     if(isdigit(Text[1])) {    /* it is refering to a number */
     i = atoi(Text+1) - 1;

     if(i > 0 && i < save_input_l) { 
      strncpy(OutText,save_input[i],BUFF_LEN);
       i = HowManyDigits(Text+1) + 1;
       if( i < 2) {
         PrintMessage("?ERROR - can't substitute command");
         return;}
      strncat(OutText,Text+i,(BUFF_LEN - strlen(OutText)));
      send_command(OutText);}
     else {
     sprintf(OutText,"?ERROR - can't substitute command nr: %d",(i+1));
     PrintMessage(OutText);}}

     else { /* no it is part of the command */

         for(i = 0 ; i < save_input_l ; i++) {
           if(!strncasecmp(Text+1,save_input[i],strlen(Text+1))) {
           strncpy(OutText,save_input[i],BUFF_LEN);
           send_command(OutText);
           return; 
           }}

     sprintf(OutText,"?ERROR - can't find the command '%s'",Text+1);
     PrintMessage(OutText);}

}


