/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "maxdefs.h"

     extern void PrintMessage();

     extern float *vdw_list;                    /* vdW radius list */
     extern char parsed[MAXparse][MAXlinel];
     extern int **atmcol;
     extern int numat;

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */


/************************************************************************/
interface_fac(input,num)   /* interpret the interface command */
   char *input; 
   int num;
/************************************************************************/
{
     int ret_val;
     int i;
     char OutText[BUFF_LEN];

     static char *lusage = "\n\
*************************** interface help ****************************\n\
                                                                          \n\
  inte*rface make icon8                  ! Make input for ICON8 program   \n\
                  dens*ity               ! Make input for DENSITY progra, \n\
                  game*ss                ! Make input for GAMESS program  \n\
                  mopa*c                 ! Make input for MOPAC program   \n\
                  prob*esurface          ! Make input for ProbeSurf       \n\
                  vss                    ! Make input for VSS             \n\
                                                                          \n\
**************************************************************************";

     if(indexo(parsed[1],"?") == 1) {
       printf("%s\n",lusage);
        return;}

     if(mliste[0] < 1 ) {
     printf("?ERROR - no atoms in buffer. No input file can be made \n");
     return;}

     if(num < 3) {
     printf("?ERROR - incomplete qm command - : %s \n",input);
     return;}

     toller(parsed[1]);

/* Make input file                            */
   if(indexo(parsed[1],"make") == 1) {
   interface_make(input,num);
   return;}

/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of qm_fac */

/************************************************************************/
interface_make(input,num)
   char *input; 
   int num;
/************************************************************************/
{
     extern char parsed[MAXparse][MAXlinel];
     extern int numat;

     int ret_val;
     char OutText[BUFF_LEN];

     toller(parsed[2]);

/* icon8 interface                     */
   if(indexo(parsed[2],"icon8") == 1) {
   ret_val = input_gen("icon8");
   return;}

/* mopac interface                     */
   if(indexo(parsed[2],"mopa") == 1) {
   ret_val = input_gen("mopac");
   return;}

/* gamess interface                     */
   if(indexo(parsed[2],"game") == 1) {
   ret_val = input_gen("gamess");
   return;}

/* probsurf interface                   */
   if(indexo(parsed[2],"prob") == 1) {
   ret_val = input_gen("probesurf");
   return;}

/* density interface                   */
   if(indexo(parsed[2],"dens") == 1) {
   ret_val = input_gen("density");
   return;}

/* vss interface                   */
   if(indexo(parsed[2],"vss") == 1) {
   ret_val = input_gen("vss");
   return;}

/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}







