/*  

                       Copyright (c) 1993 by:
        Leif Laaksonen , Center for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "maxdefs.h"

     extern void PrintMessage();
     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern float *x;
     extern float *y;
     extern float *z;

/* structure for the dynamics trajectory file */

   extern struct {
    char traj_file[BUFF_LEN];                 /* file name          */
    int natom;                                /* number of atoms    */
    int nstep;                                /* number of steps    */
    int time_bw_steps;                        /* time between steps */
    int time_first_frame;                     /* time of first frame */
    int first_frame;                          /* first frame to be displayed */
    int last_frame;                           /* last frame to be displayed  */
    int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

   extern int SetTrajectoryUserLimits();

int TrajectoryLastFrame();
int TrajectoryFirstFrame();
int TrajectoryStepFrame();
int FramesInSet();
float *XCoordPoint();
float *YCoordPoint();
float *ZCoordPoint();

/************************************************************************/
int TrajectoryLastFrame()
/************************************************************************/
{
    return(trajectory_info.last_frame);
}
/************************************************************************/
int TrajectoryFirstFrame()
/************************************************************************/
{
    return(trajectory_info.first_frame);
}
/************************************************************************/
int TrajectoryStepFrame()
/************************************************************************/
{
    return(trajectory_info.delta_frame);
}
/************************************************************************/
float *XCoordPoint(int System)
/************************************************************************/
{
      return(x);
}
/************************************************************************/
float *YCoordPoint(int System)
/************************************************************************/
{
      return(y);
}
/************************************************************************/
float *ZCoordPoint(int System)
/************************************************************************/
{
      return(z);
}

/**************************************************************************/
int FramesInSet()
/**************************************************************************/
{

    if(trajectory_info.delta_frame == 0)
                                         return(0);

    return((trajectory_info.last_frame - trajectory_info.first_frame + 1) /
            trajectory_info.delta_frame);
}

/************************************************************************/
int SetTrajectoryUserLimits(int FirstF , int LastF , int StepF)
/************************************************************************/
{
    int i,j,k;

    if(FirstF < 1) 
       i = 1;
    else
       i = FirstF;

    trajectory_info.first_frame = i;

    if(LastF < 1) 
       j = 0;
    else
       j = LastF;
      
    trajectory_info.last_frame  = j;

    if(StepF < 1)
       k = 1;
    else
       k = StepF;

    trajectory_info.delta_frame = k;

#ifdef DEBUG
printf(": 1\n");
printf("First:   %d\n",trajectory_info.first_frame);
printf("Last:    %d\n",trajectory_info.last_frame);
printf("Delta:   %d\n",trajectory_info.delta_frame);
#endif

    return(0);
}
       



