#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include <string.h>
#include "maxdefs.h"

#define MOD(a,b)  (((a+1)/b)*b - (a+1))

    extern double *dvector();
    extern float   *vector();
/* structure for the dynamics trajectory file */

   extern struct {
   char traj_file[BUFF_LEN];                 /* file name          */
   int natom;                                /* number of atoms    */
   int nstep;                                /* number of steps    */
   int time_bw_steps;                        /* time between steps */
   int time_first_frame;                     /* time of first frame */
   int first_frame;                          /* first frame to be displayed */
   int last_frame;                           /* last frame to be displayed  */
   int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

     extern int MAXatom;
     extern int traj_in_core;


/***************************************************************************/
get_frame_amber(alt,iappend)  /* read one frame from a amber trajectory   */


    int alt;     /* mode of operation (=0) first time in read
                                      (>0) trajectory number */
    int iappend; /* if = 0 no append , if = 1 append */
/***************************************************************************/
{
/* externals    */
    extern FILE *charmm_oc;
    extern float *x,*y,*z;
    extern int numat;
    extern char traj_file[BUFF_LEN];

   static long record_len=0;         /* the "record" length in bytes of one
                                       record containing the x,y and z
                                       coordinates plus the information
                                       in between the coordinates */
   static long ret_fseek;

   static char title[BUFF_LEN];  /* amber title */
   static int natom;       /* number of amber atoms */
   static int icount;
   static int record;
   static int i;
   static int idx1;
   static float *Master;

           /* always from first atom list */

/* determine the "record length"    */
        natom = mliste[0] - mlists[0];
        numat = mliste[0] - mlists[0];
        record_len = 2 * sizeof(int) +  natom * sizeof(float) * 3;

/*  start reading  */

/* read controll record */
    icount = fread(&record,sizeof(int), 1 , charmm_oc);
/* read 80 characters   */
    icount = fread(title,sizeof(char), 80 ,charmm_oc);
    icount = fread(&record,sizeof(int), 1 , charmm_oc);

    if(alt > 0) {
    ret_fseek = fseek(charmm_oc,(alt*record_len),1);
    if(ret_fseek) {
    printf("?ERROR - can't read trajectory file : %s \n",traj_file);
    return(-1);}}

/* next records are specific for one frame */
/* read controll record */

    Master = vector(3 * natom);

    if(iappend == 0) {

/* read controll record */
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(Master,sizeof(float), 3 * natom,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = 0;
    for(i = 0 ; i < natom ; i++) {
       x[i] = Master[icount];
        y[i] = Master[icount + 1];
         z[i] = Master[icount + 2];
       icount += 3;}
  }
    else {

    idx1 = mliste[mlist_deep - 1];

/* check dimensions */
    if((idx1+natom) > MAXatom) {
      PrintMessage("?ERROR - next frame does not fit into the coordinate array");
      free(Master);
      return(-1);}

    icount = fread(&record,sizeof(int), 1 ,charmm_oc);
    icount = fread(Master,sizeof(float),3 * natom,charmm_oc);
    icount = fread(&record,sizeof(int), 1 ,charmm_oc);

    icount = 0;
    for(i = 0 ; i < natom ; i++) {
       x[idx1 + i] = Master[icount];
        y[idx1 + i] = Master[icount + 1];
         z[idx1 + i] = Master[icount + 2];
       icount += 3;}

  }

    update_mlist(natom);

    free(Master);
    return(0);
/*                                  */

}
/***************************************************************************/
read_traj_amber(alt,numset,pasback)/* read one frame from a amber trajectory   */


    int alt;     /* mode of operation (=0) first time in read
                                      (>0) trajectory number */
    int pasback[];
    int *numset;
/***************************************************************************/
{
/* externals    */
    extern FILE *charmm_oc;
    extern float *x,*y,*z;
    extern int numat;
    extern char traj_file[BUFF_LEN];

   FILE *amber_oc;

   static long record_len=0;         /* the "record" length in bytes of one
                                       record containing the x,y and z
                                       coordinates plus the information
                                       in between the coordinates */
   static char title[BUFF_LEN];  /* amber title */

   static int natom;       /* number of amber atoms */
   static int icount;
   static int record;
   static int nstep;

   amber_oc = fopen(traj_file,"r");
   if(amber_oc == NULL) {
   sprintf(title,">>> Can't open input file: %s",traj_file);
   PrintMessage(title);
   return(-1); }


/*  start reading  */

/* read controll record */
    icount = fread(&record,sizeof(int), 1 , amber_oc);
/* read 80 characters   */
    icount = fread(title,sizeof(char), 80 ,amber_oc);
    title[79] = '\0';
    icount = fread(&record,sizeof(int), 1 , amber_oc);
   printf("Title: \n");
   printf("%s\n",title);

   natom = trajectory_info.natom = mliste[0] - mlists[0]; 
                                   /* always from first atom list */

    if(alt == 1) {

/* check number of records */

/* go first to the end of file */
        icount = fseek(amber_oc,0L,2);
         if(icount != 0) {
         PrintMessage("?ERROR - can't find end of trajectory file");
         return(0);}

        record = ftell(amber_oc);
        icount = fseek(amber_oc, 88L ,0);
        icount = ftell(amber_oc);

        record_len = 2 * sizeof(int) +  natom * sizeof(float) * 3;

        nstep = (record-icount)/record_len;

/* update trajectory info ... */
        trajectory_info.natom            = natom;
        trajectory_info.nstep            = nstep;
        *numset =                          nstep;

        pasback[0] = nstep;
        pasback[1] = 0;
        pasback[2] = 0;
/*
        trajectory_info.time_bw_steps    = icntrl[2] = 0;
        trajectory_info.time_first_frame = icntrl[1] = 0;

*/
        printf(" Info for trajectory file   : %s \n",traj_file);
	printf(" Atoms found                : %d \n",natom);
	printf(" Dynamics steps             : %d \n",nstep);

        if(trajectory_info.time_bw_steps) {
        printf(" Time between data frames   : %d \n",trajectory_info.time_bw_steps);
        pasback[2] = trajectory_info.time_bw_steps;}
/*
        printf(" Time between data sets     : %d \n",icntrl[2]);
        printf(" Time of the first data set : %d \n",icntrl[1]);
*/
        traj_in_core = 2; /* always out of core */
        fclose(amber_oc);
        return(0);}


        PrintMessage("?ERROR - you should not land here ???");

        return(0);

/*                                  */

}

