
/*  

                       Copyright (c) 1990, 1992 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>

#ifdef sgi
#include <device.h>
#include <gl.h>
#endif

#include "maxdefs.h"

#ifdef sgi
#define SURFACE_DEF def_simple_light_calc(); use_simple_light_calc()
#endif

#define ROTATE(a,b) rotateO(a,b)
#define TRANSLATE(a,b,c) translateO(a,b,c)

     extern void going_on();
     extern void qcomm();
     extern void PrintMessage();
     extern int own_parser();
     extern void PrintHistory();
     extern void coordinate_fac();
     extern void DoSanitary();
     extern int  UpdateAllPlots();

     extern short bgcolor[3];
     extern int term_type;
     extern float damp;
     extern char parsed[MAXparse][MAXlinel];
     extern char *bottom_line;
     extern int rfile_deep;
     extern FILE *rfile_point[MAX_FILES];
     extern int rama_wind;
     extern int draw_obj_disp;
     extern char scr_data[];
     extern char prompt[];

    extern struct {
      int   argc;
      char **argv;
    } ComLinePars;

/*  MAGIC structure */
    extern struct {
    int level;}  Magic;

   extern struct {       /* log file structure */
    char file[BUFF_LEN];
    FILE *log_p;
    int ok;
    int lines;} LogFile;

     int alias_deep=0;
     char alias_stack[MAXparse][MAXlinel];
     char alias_eq[MAXparse][MAXlinel];
     int save_deep = 0;
     char save_stack[MAXparse][MAXlinel];
     char snap_mark  = '$'; /* this is the character for which I look
                             into the subsitution stack (save_stack) */
     char snap_mark1 = '%'; /* character to recognice the input parameters
                               to a macro */

      FILE *push_file;     /* file pointer to a file opened with '@' */


     int  save_input_l = 0;               /* stack depth            */
     char save_input[MAX_SAVE][MAXlinel]; /* save commands in stack */
     int fake_now = 0;      /* switch to fool the program to think that
                              it should NOT use the selection list by mouse
                             and if the user is using an internal
                             makro SCARECROW
                             should think that the program is entirely
                             driven from a file (makro) */

     struct FileInput {
       int Set;           /* = 0 no input saved, > 0 information saved */
       int Pos;           /* number of parameters saved                */
       char Commands[MAXparse][MAXlinel]; /* saved input parameters    */
     } FIP;               /* file input parameters                     */

     int AllowedGraphDispl();

/************************************************************************/
int exe_command(input,num)   /* exe input string */
     char *input;
     int num;
/************************************************************************/
{

     extern char parsed[MAXparse][MAXlinel];
     extern int  term_type;
     extern long win_ids[10];
     extern int winnr;
     extern short BLACKv[3];

     static int alt_disp=1;
     static int ret_val,k;
     int ihelp;
     float fhelp,fhelp1,fhelp2,fhelp3;
     char OutText[BUFF_LEN];

/* help text section */
     static char *alias_help = "\n\
********************** add an alias to the alias stack ********************\n\
  Command:                                                                 \n\
                                                                           \n\
  alias name command                                                       \n\
                                                                           \n\
  adds the command with the name 'name' to the command table.              \n\
  It is also possile to use symbols $1, $2 ... in the command              \n\
  then everything after the alias is substituted into $1, $2 ...           \n\
                                                                           \n\
  Example:                                                                 \n\
            alias readig get karpl tswater.crd                             \n\
                                                                           \n\
  now 'readig' is added to the command table as a command.                 \n\
                                                                           \n\
";
     toller(parsed[0]); /* switch to lower characters */

/* > '?' give me some help                 <*/
     if(parsed[0][0] == '?' || indexo(parsed[0],"help") == 1) {
  PrintMessage(">>>> Help at the basic command level                <<<<");
  PrintMessage("     alia*s symbol command    ! Make an alias              ");
  PrintMessage("     beep                     ! Beep                       ");
  PrintMessage("     bord*ers                 ! Put borders back           ");
  PrintMessage("     nobo*border              ! Remove borders             ");
  PrintMessage("     calc*ulate               ! Calc various things        ");
  PrintMessage("     check                    ! Check various things       ");
  PrintMessage("     clea*r                   ! Clear screen               ");
  PrintMessage("     conn*ect server name     ! Connect to server          ");
  PrintMessage("     coor*dinate              ! Manipulate the atom coord  ");
  PrintMessage("     defi*ne                  ! Define various things      ");
  PrintMessage("     delali*as or remali*as   ! Delete an alias            ");
  PrintMessage("     disp*lay                 ! Display various things     ");
  PrintMessage("     edit                     ! Edit various things        ");
  PrintMessage("     end                      ! Exit program               ");
  PrintMessage("     fill                     ! Fill different vectors     ");
  PrintMessage("     find                     ! Find different things     ");
  PrintMessage("     get or rea*d             ! Read various files         ");
  PrintMessage("     hard*copy file_name      ! Make a screen dump         ");
  PrintMessage("     mani*pulate              ! Manipulate time series     ");
  PrintMessage("     modi*fy                  ! Modify parameters          ");
  PrintMessage("     play                     ! Play dynamics frames       ");
  PrintMessage("     plot                     ! Plot various things        ");
  PrintMessage("     inte*rface               ! Interface to other programs");
  PrintMessage("     rese*t                   ! Reset various things       ");
  PrintMessage("     rota*te x y z            ! Rotate in x,y or z         ");
  PrintMessage("     scal*e factor            ! Scale object               ");
  PrintMessage("     set                      ! Set various things         ");
  PrintMessage("     shel*l                   ! Create a shell             ");
  PrintMessage("     sho*w                    ! Show various things        ");
  PrintMessage("     slee*p secs              ! Sleep secs seconds         ");
  PrintMessage("     stre*am program file     ! Stream file to program     ");
  PrintMessage("     tran*slate x y z         ! Translate in x,y or z      ");
  PrintMessage("     trac*e atoms             ! Trace atoms                ");
  PrintMessage("     write                    ! Write various things on disk ");
  PrintMessage("     winpu*sh                 ! Push current graphics window ");
  PrintMessage("     winpo*p                  ! Pops the current graphics window ");
     return(0);}


/* take command from stack                    */
    if(indexo(input,"!") == 1) {
      TakeFromStack(input);
        return;}

/* > look first into the alias data base   <*/
     ret_val = lookinto_abase(num);
     if(ret_val) return(0); /* yes it was in the data base */

     push_input_stack(input);


/* junk */
/*
     if(indexo(parsed[0],"secstr") == 1) {
     sec_struct(2);
       return(0);}
*/
     if(indexo(parsed[0],"gopenmol") == 1) {
/*     GOpenMol(ComLinePars.argc , ComLinePars.argv); */
       return(0);}

/* it's all MAGIC    */
     if(indexo(parsed[0],"magic") == 1) {
       toller(parsed[1]);
       if(indexo(parsed[1],"on")  == 1) Magic.level = 1;
       if(indexo(parsed[1],"off") == 1) Magic.level = 0;
       return;}

/* > trace atom facility               < */
     if(indexo(parsed[0],"trac") == 1) {
       trace_fac(input,num);
       return(0);}

/* > exit from this routine and program < */
     if(indexo(parsed[0],"end") == 1)  shut_down(0);

/* > beep                               < */
     if(indexo(parsed[0],"beep") == 1) {
       printf("\007\n");
        return(0);}

/* > noborders                          < */
     if(indexo(parsed[0],"nobo") == 1) {
#ifdef sgi
     noborder();
     winconstraints();
     reshapeviewport();
#else
     PrintMessage("?ERROR - not implemented on this device ");
#endif
     return(0);}

/* > borders                            < */
     if(indexo(parsed[0],"bord") == 1) {
#ifdef sgi
     winconstraints();
     winconstraints();
     reshapeviewport();
#else
     PrintMessage("?ERROR - not implemented on this device");
#endif
     return(0);}


/* > edit                               < */
     if(indexo(parsed[0],"edit") == 1) {
     edit_fac(input,num);
     return(0);}


/* > find                               <*/
     if(indexo(parsed[0],"find") == 1) {
      find_fac(input,num);
      return(0);}

/* > slice                              < */
     if(indexo(parsed[0],"slic") == 1) {
     slice_fac(input,num);
     return(0);}

/* > winpush                            < */
     if(indexo(parsed[0],"winpu") == 1) {
#ifdef sgi
     if(term_type == 1) {
       winpush();
       return(0);}
     else {
     PrintMessage("?ERROR - I don't know how to do it on a non-graphics terminal");
     return(0);}
#else
     PrintMessage("?ERROR - not implemented on this device");
#endif
     }

/* > winpop                              < */
     if(indexo(parsed[0],"winpo") == 1) {
#ifdef sgi
     if(term_type == 1) {
       winpop();
       return(0);}
     else {
     PrintMessage("?ERROR - I don't know how to do it on a non-graphics terminal ");
     return(0);}
#else
     PrintMessage("?ERROR - not implemented on this device");
#endif
     }

/* > play                               < */
     if(indexo(parsed[0],"play") == 1) {
     play_fac(input,num);
     return(0);}

/* > input from file                    < */

     if(indexo(parsed[0],"@") == 1) {         /* read from file */
/* save the other possible input variables on the input line ... */
     if(k > 1 && rfile_deep == 0)  /* for recursion take only the first one */
       SaveFileInput(k);
     read_from_file(input);
     return(0); } /* end read from file */

/* > connect to server                  < */
     if(indexo(parsed[0],"conn") == 1) {
     connect_fac(input,num);
     return(0);}

/* > fill                               < */
     if(indexo(parsed[0],"fill") == 1) {
     fill_fac(input,num);
     return(0);}

/* > check                              < */
     if(indexo(parsed[0],"check") == 1) {
     check_fac(input,num);
     return(0);}

/* > set facility                       < */
     if(indexo(parsed[0],"set") == 1) {
     set_fac(input,num);
     return(0);}

/* > define facility                    < */
     if(indexo(parsed[0],"defi") == 1) {
     define_fac(input,num);
     return(0);}

/* > plot facility                      < */
     if(indexo(parsed[0],"plot") == 1) {
     plot_fac(input,num);
     return(0);}
   
/* > contour facility                   < */
     if(indexo(parsed[0],"cont") == 1) {
     contour_fac(input,num);
     return(0);}

/* > show facility                      < */
     if(indexo(parsed[0],"sho") == 1) {
     show_fac(input,num);
     return(0);}

/* > read facility (or get)             < */
     if(indexo(parsed[0],"rea") == 1 || indexo(parsed[0],"get") == 1) {
     read_fac(input,num);
     alt_disp = 1;
     return(0);}

/* > interface to other programs        <*/
     if(indexo(parsed[0],"inte") == 1) {
     interface_fac(input,num);
     return(0);}

/* > Manipulate facility    <*/
     if(indexo(parsed[0],"mani") == 1) {
     manipulate_fac(input,num);
     return(0);}

/* > delete alias                        <*/
     if(indexo(parsed[0],"delali") == 1 ||
        indexo(parsed[0],"remali") == 1) {
        if(parsed[1][0] == '\0') {
          PrintMessage("?ERROR - alias name missing");
          return(0);}
        rem_alias(parsed[1]);
        return(0);
     }

/* > build alias                        <*/
     if(indexo(parsed[0],"alia") == 1) {
       if(parsed[1][0] == '?') { /* alias help */
         sprintf(OutText,"%s",alias_help);
         PrintMessage(OutText);
          return(0);}

        if(num < 3) {
        PrintMessage("?ERROR - incomplete alias command");
        return(0);}

        strcpy(alias_eq[alias_deep],parsed[1]);
        for(k = 0 ; k < MAXlinel ; k++) alias_stack[alias_deep][k] = '\0';
        for(k = 2 ; k < num ; k++)  {
         strcat(alias_stack[alias_deep]," ");
         strcat(alias_stack[alias_deep],parsed[k]);}
         if(alias_deep == MAXparse) {
         PrintMessage("?ERROR - alias stack is full ");
         return(0);}
        alias_deep++;
     return(0);}

/* > display                                  <*/
     if(indexo(parsed[0],"disp") == 1) {
       (void)UpdateAllPlots();
       display_mol(alt_disp);
       alt_disp = 0;
       return(0);}

/* > sleep the amount of secs                 <*/
     if(indexo(parsed[0],"slee") == 1 || indexo(parsed[0],"paus") == 1) {
       if(num < 2) {
       sprintf(OutText,"?ERROR - parameter undefined in command : %s",input);
       PrintMessage(OutText);
       return(0);}
     rest_sec(atof(parsed[1]));
     return(0);}

/* > rotate command                           <*/
     if(indexo(parsed[0],"rota") == 1) {
     fhelp1 = atof(parsed[1]);
     ihelp  = (int)(fhelp1 * 10.);
           if(fhelp != 0.0)
            ROTATE( -ihelp , 'x');
     fhelp2 = atof(parsed[2]);
     ihelp  = (int)(fhelp2 * 10.);
           if(fhelp != 0.0)
             ROTATE( -ihelp , 'y');
     fhelp3 = atof(parsed[3]);
     ihelp  = (int)(fhelp3 * 10.);
           if(ihelp != 0)
              ROTATE( ihelp , 'z');
     sprintf(OutText,"Rotate (degrees) x-axis: %f , y-axis: %f , z-axis: %f",
             fhelp1,fhelp2,fhelp3);
     PrintMessage(OutText);
     return(0);}

/* > translate command                        <*/
     if(indexo(parsed[0],"tran") == 1) {
       fhelp = atof(parsed[1]);
           if(fhelp != 0.0)
             TRANSLATE( fhelp , 0.0 , 0.0);
     sprintf(OutText," x-translate: %f ",fhelp);
     PrintMessage(OutText);
       fhelp = atof(parsed[2]);
           if(fhelp != 0.0)
              TRANSLATE( 0.0 , fhelp , 0.0);
     sprintf(OutText," y-translate: %f ",fhelp);
     PrintMessage(OutText);
       fhelp = atof(parsed[3]);
           if(fhelp != 0.0)
               TRANSLATE( 0.0 , 0.0 ,  fhelp);
     sprintf(OutText," z-translate: %f ",fhelp);
     PrintMessage(OutText);
     return(0);}

/* > scale command                            <*/
     if(indexo(parsed[0],"scal") == 1) {

       if(AllowedGraphDispl()) return(0);
#ifdef sgi
     if(num < 2) {
       PrintMessage("?ERROR - scale factor is missing");
       return(0);}
     if(fhelp = atof(parsed[1])) scale(fhelp , fhelp , fhelp);
     return(0);

#else

     PrintMessage("?ERROR - not implemented on this device");

#endif

     }

/* > make a hardcopy                         <*/
     if(indexo(parsed[0],"hard") == 1) {
       if(term_type != 1) {
       PrintMessage("?ERROR - not possible to make a hardcopy on a non-SGI machine");
       return(0);}
     if(num < 2) {
     PrintMessage("?WARNING - file name is missing , it is now 'picture.pic'");
     hardcopy("picture.pic");}
     else 
     hardcopy(parsed[1]);
     return(0);}

/* create a shell                             */
     if(indexo(parsed[0],"shel") == 1) {
       {
          int status;
          if(fork() == 0) { 
             if(term_type != 1) 
             execlp("/bin/csh/","csh",(char *) 0);
#ifdef sgi
             else
             execlp("/bin/wsh/","wsh","-F","-p 100,100",(char *) 0);
#endif
	  }
          wait(&status);
	}
        return(0);
     }

/* calculate various things                   */

     if(indexo(parsed[0],"calc") == 1) {
     calc_fac(input,num);
     return(0);}

/* write various things on disk               */

     if(indexo(parsed[0],"writ") == 1) {
       write_fac(input,num);
       return(0);}

/* stream a file to a program                 */
      if(indexo(parsed[0],"stre") == 1) {
        stream_p(input,num);
        return(0);}

/* reset various things                       */
       if(indexo(parsed[0],"rese") == 1) {
         reset_fac(input,num);
         return(0);}

#ifdef VIDEO_SCARE
/* fperrec (frames per record) minivas command */
     if(indexo(parsed[0],"fperrec")) {
       ihelp = atoi(parsed[1]);
       if(ihelp  < 1) return;
       minivas_fperrec(ihelp);
       sprintf(OutText,"Frames per record is now %d ",ihelp);
       PrintMessage(OutText);
       return;}
#endif

/* pal command                                */
     if(indexo(parsed[0],"pal")  == 1) {
#ifdef VIDEO_SCARE
       toller(parsed[1]);
       if(indexo(parsed[1],"off") == 1) {
       minivas_close(1);
       system("pal 0");
       return;}
     system("pal");
     sleep(3);
#else
     PrintMessage("?ERROR - video facility not implemented on this device");
#endif
     return;
     }

/* > prepare    */
     if(indexo(parsed[0],"prep") == 1) {
#ifdef VIDEO_SCARE
{
     int start , frames;
     int ret_val;

     start = atoi(parsed[1]);
     frames = atoi(parsed[2]);
     sprintf(OutText," Start frame is : %d ",start);
     PrintMessage(OutText);
     sprintf(OutText," Frames / records : %d ", frames);
     PrintMessage(OutText);
     minivas_open();
     ret_val = minivas_prepare( start , frames , 5);
     if(ret_val == 0) shut_down(1);
}
#else
     PrintMessage("?ERROR - video facility not implemented on this device ");
#endif
     return;}
    
/* history                                    */
    if(indexo(parsed[0],"hist") == 1) {
      PrintHistory();
      return;}

/* some extra stuff added                     */
    if(indexo(parsed[0],"dyna") == 1) {
       toller(parsed[1]);
       if(indexo(parsed[1],"disp") == 1) {
          toller(parsed[2]);
          if(indexo(parsed[2],"movi") == 1) {
            study_dynamics(2);
            return;}
          if(indexo(parsed[2],"step") == 1) {
            study_dynamics(6);
            return;}
	}
     }

/* coordinate                                    */
    if(indexo(parsed[0],"coor") == 1) {
      (void)coordinate_fac(input,num);
      return;}

/* clear screen                                  */
    if(indexo(parsed[0],"clea") == 1) {
      if(term_type == 1 || term_type == 3)
       DoSanitary();
        return;}

/* > modify                              < */
     if(indexo(parsed[0],"modi") == 1) {
     modify_fac(input,num);
     return(0);}

/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: '%s' \n",input);
     PrintMessage(OutText);

}      /* end of exe_command routine */

/***********************************************************************/
int lookinto_abase(deep)
    int deep;
/***********************************************************************/
{
     extern char parsed[MAXparse][MAXlinel];
     int i,j,k,l,m;
     int num_pos;
     char TemP[BUFF_LEN];

     if(alias_deep < 1 ) return(0);

     for(i = 0 ; i < alias_deep ; i++) {
       if(indexo(parsed[0],alias_eq[i]) == 1) { /* ok this is an alias */
/* save next positions after alias command */
       if(deep > 1) {
       save_deep = 0;
       for(j = 1 ; j < deep ; j++) {
          strcpy(save_stack[j-1],parsed[j]);
          save_deep++;}
       }
/* done ...                                */

     own_parser(alias_stack[i],parsed,&num_pos,SEP_STRING); /* parsing driver */

/* look into new list for symbols $1 , $2 ... */
     if(save_deep > 0) {
     for(j = 0 ; j < num_pos ; j++) {
      for(l = 0 ; l < strlen(parsed[j]) ; l++) {
        if(parsed[j][l] == snap_mark) {
          k = atoi(&parsed[j][l + 1]);
          if(k < 1 || k > save_deep) {
          printf("?ERROR - can't substitute nr: %d\n",k);
          return(1);}
/* save first rest of string (you never know ...) */
   m = HowManyDigits(&parsed[j][l + 1]);
      if(k < 0) {
       return;}
       strncpy(TemP,&parsed[j][l + m + 1],BUFF_LEN);
       strncpy(&parsed[j][l],save_stack[k-1],(MAXlinel - strlen(parsed[j])));
       strncat(parsed[j],TemP,(MAXlinel - strlen(parsed[j])));}}
     }
     for(j = 0 ; j < save_deep ; j++) save_stack[j][0] = '\0';
     save_deep = 0;
     }

/* look into new list for symbols %1 , %2 ... */
     if(FIP.Set) {
     for(j = 0 ; j < num_pos ; j++) {
      for(l = 0 ; l < strlen(parsed[j]) ; l++) {
        if(parsed[j][l] == snap_mark1) {
          k = atoi(&parsed[j][l + 1]);
          if(k < 1 || k > FIP.Pos) {
          printf("?ERROR - can't substitute nr: %d\n",k);
          return(1);}
/* save first rest of string (you never know ...) */
   m = HowManyDigits(&parsed[j][l + 1]);
       if(k < 0) {
       return;}
     strncpy(TemP,&parsed[j][l + m + 1],BUFF_LEN);
     strncpy(&parsed[j][l],FIP.Commands[k-1],(MAXlinel - strlen(parsed[j])));
       strncat(parsed[j],TemP,(MAXlinel - strlen(parsed[j])));}}
      }}

/* done ...                                   */

     if(num_pos < 1) continue;
       i = exe_command(alias_stack[i],num_pos);
       return(1);}}
     return(0);
}
/***********************************************************************/
rem_alias(text)     /* remove an alias from the stack */
    char *text;     /* alias to be removed            */
/***********************************************************************/
{
    int i,j;
    int alias_long;
    char chelp1[BUFF_LEN];
    char chelp2[BUFF_LEN];
    char OutText[BUFF_LEN];

    if(alias_deep  < 1) {
     PrintMessage("?ERROR - alias stack is empty");
     return;
    }

    alias_long = strlen(text);

    strncpy(chelp1,text,alias_long);
    toller(chelp1);
    
/* go and look for the alia */
    j = -1;
    for(i = 0 ; i < alias_deep ; i++) {
       strncpy(chelp2,alias_eq[i],strlen(alias_eq[i]));
       toller(chelp2);
       if(strncmp(chelp2,chelp1,strlen(chelp1)) == 0) {
       j = i + 1;
       break;}
    }

    if(j < 0) {
      sprintf(OutText,"?ERROR - can't find '%s' in the alias stack\n",text);
      PrintMessage(OutText);
      return;} /* exit */

    if(j-1 == alias_deep) alias_deep--;

    for(i = j-1 ; i < alias_deep-1 ; i++)  {
     strcpy(alias_stack[i],alias_stack[i+1]);
     strcpy(alias_eq[i],alias_eq[i+1]);}
      alias_stack[alias_deep][0] = '\0';
      alias_eq[alias_deep][0] = '\0';
      alias_deep--;

    return;
}
/***********************************************************************/
display_mol(alt)
     int alt;
/***********************************************************************/
{

/* bang it on the screen ...   */

#ifdef sgi
      if(term_type == 2) {
        PrintMessage("?ERROR - I don't know how to do it on a vt100 terminal ");
        return;}

      if(term_type == 0 || term_type == 4) {
        PrintMessage("?ERROR - I don't know how to do it on this terminal");
        return;}

      reshapeviewport();
      bang_it();
#else

      PrintMessage("?ERROR - not implemented on this device");

#endif

}


/************************************************************************/
read_from_file(input)  /* if there is '@file' in the input string it means
                          open file and read from it */
      char *input;
/************************************************************************/
{
      extern char parsed[MAXparse][MAXlinel];
      extern char prompt[BUFF_LEN];

      int i,lines;
      long dev_gr;
      short val_gr;
      int num_pos;
      char chelp[BUFF_LEN];
      char chelp1[BUFF_LEN];
      char *ret_val;
      char OutText[BUFF_LEN];

      lines = 0;
      i = indexo(input,"@");
      strncpy(chelp,input+i,BUFF_LEN);
/* try first to open in working directory */
      push_file = fopen(chelp,"r");
      if(push_file == NULL) {
       strncpy(chelp1,chelp,BUFF_LEN);
       strncpy(chelp,scr_data,BUFF_LEN);
        strcat(chelp,"/");
         strncat(chelp,chelp1,(BUFF_LEN - strlen(chelp)));
/* try then in the "data" directory */
         push_file = fopen(chelp,"r");}
      if(push_file == NULL) {
      sprintf(OutText,"?ERROR - can't open file: %s",chelp);
      PrintMessage(OutText);
      FIP.Pos = 0;
       FIP.Set = 0;
      return;}

      sprintf(OutText,"Reading from file: %s",chelp);
      PrintMessage(OutText);

      fake_now = 1;

/* update file pointer stack */
      rfile_point[rfile_deep] = push_file;
      rfile_deep++;
      if(rfile_deep == MAX_FILES) {
       PrintMessage("?ERROR - max recursion , can't continue");
       shut_down(1);}

      while(1) {
      ret_val = fgets(chelp1,MAXlinel,rfile_point[rfile_deep - 1]);

        if(ret_val == NULL) {
         sprintf(OutText,"End of file: %s (read %d lines)",chelp,lines);
         PrintMessage(OutText);
          rfile_deep--; /* decrement stack pointer */
          fclose(rfile_point[rfile_deep]);
          if(rfile_deep == 0) {
           fake_now = 0;
           FIP.Pos = 0;
            FIP.Set = 0;}
          return;}

/* check if there is something coming in from the graphics window */
#ifdef sgi
          if(term_type == 1) {  /* just for iris terminal sessions */
/* test if there is something in the queue */
          if(qtest()) {  
          dev_gr = qread(&val_gr); 
          if(dev_gr == KEYBD) {

          switch(val_gr) {

          case 3:
           sprintf(OutText,"**** user interrup during reading of file '%s'",chelp);
           PrintMessage(OutText);
           for(i = 0 ; i < rfile_deep ; i++) 
               fclose(rfile_point[i]);
           rfile_deep = 0; 
           fake_now = 0;
            FIP.Pos = 0;
             FIP.Set = 0;
              qreset();
           return;

	  default:
           PrintMessage("**** no action ****");
           break;
          }}}} 
          
#endif

/* this is done to remove the new line \n (line feed) character from the end */
      if(chelp1[strlen(chelp1)-1] == '\n') chelp1[strlen(chelp1)-1] = '\0';
       lines++;

/* check the input line for '?name' entries */
      qcomm(chelp1);

     sprintf(OutText,"%s %s",prompt,chelp1); /* type command */
     PrintMessage(OutText);

          strncpy(bottom_line,prompt,PORTchar);
          strncat(bottom_line,chelp1,(PORTchar - strlen(bottom_line)));
          going_on();

     own_parser(chelp1,parsed,&num_pos,SEP_STRING); /* parsing driver */

     if(num_pos < 1) continue;

     i = exe_command(chelp1,num_pos); /* execute the command on input string */

    }
}

/************************************************************************/
void send_command(text)
     char *text;
/************************************************************************/
{

     int j,k;
     char OutText[BUFF_LEN];

          strncpy(bottom_line,prompt,PORTchar);
          strncat(bottom_line,text,(PORTchar - strlen(bottom_line)));
          going_on();
     sprintf(OutText,"%s%s",prompt,text);
     PrintMessage(OutText);
     j=own_parser(text,parsed,&k,SEP_STRING); /* parsing driver */

     if(k < 1) return;
     exe_command(text,k); /* execute the command on input string */
}

/************************************************************************/
push_input_stack(inputl)
     char *inputl;
/************************************************************************/
{

   static int i,j;

   if(inputl[0] == '\0') return;

   for(i = MAX_SAVE - 2 ; i >= 0 ; i--) {
      if(save_input[i][0] == '\0') continue;
      strncpy(save_input[i+1],save_input[i],MAXlinel);}

      strncpy(save_input[0],inputl,MAXlinel);

   save_input_l++;

   if(save_input_l >= MAX_SAVE) save_input_l = MAX_SAVE; 
}
/************************************************************************/
show_comm_stack()
/************************************************************************/
{
   static int i;
   char OutText[BUFF_LEN];

   if(save_input_l < 1) {
     PrintMessage("?ERROR - command stack is empty");
     return;}

   for(i = 0 ; i < save_input_l ; i++){ 
      sprintf(OutText,"(%d):'%s'",(i+1),save_input[i]);
      PrintMessage(OutText);}

   PrintMessage("  ");
}
/************************************************************************/
SaveFileInput(Numbers)
    int Numbers;
/************************************************************************/
{
    int i;

    FIP.Pos = Numbers - 1;

    for(i = 1 ; i < Numbers ; i++)
       strncpy(FIP.Commands[i],parsed[i],MAXparse);

    FIP.Set = 1;
}
/************************************************************************/
   int  HowManyDigits(Text)
        char *Text;
/************************************************************************/
{
        int i,j,k;

        k = strlen(Text);

        if(k >= MAXlinel) {
        PrintMessage("?ERROR - in 'HowManyDigits'");
        return(-1);}

        j = 0;
        for(i = 0 ; i < k ; i++) 
          if(isdigit(Text[i])) 
             j++;
          else
            return(j);

        return(j);
}

/*
      On return:

      0:  There is graphics supported
      1:  No graphics
*/

/************************************************************************/
int AllowedGraphDispl()
/************************************************************************/
{

      if(term_type == 2) {
        PrintMessage("?ERROR - I don't know how to do it on a vt100 terminal ");
        return(1);}

      if(term_type == 0 || term_type == 4) {
        PrintMessage("?ERROR - I don't know how to do it on this terminal");
        return(1);}

      return(0);
}
