/*  

                       Copyright (c) 1992, 1993 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include "maxdefs.h"

#define Rabs(a)    ( ( a ) > 0.0 ? (a) : -(a))

     extern void PrintMessage();
     extern int FindSSbonds();
     extern char parsed[MAXparse][MAXlinel];
     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */
     extern int current_struct;
     extern float Piper180;

extern void  ApplyRota();
extern float GetXCoord();
extern float GetYCoord();
extern float GetZCoord();

extern int PutXCoord();
extern int PutYCoord();
extern int PutZCoord();

extern int  atom_list_max();
extern int *ivector();
extern float *vector();

     extern struct {
        int InUse;
        int  slong;           /* length of the list */
        int *sel_list;        /* index to atoms     */
      } ManSelection;

int CalcCoordAverageSet12(char *a, char *b , char *c , char *d);
int CalcCoordWeightSet12(char *a , char *b , char *c , char *d);
int TranslateCoordinates(char *a, char *b, char *c, char *d, char *e,char *f);
int RotateCoordinates1(char *a , char *b , char *c , char *d , char *e);
int RotateCoordinates3(char *a, char *b, char *c, char *d, char *e, char *f);
int TranslateCoordinatesX(float a , float b , float c);
int RotateCoordinates1X(float a , char b);
int RotateCoordinates3X(float a , float b , float c);

/************************************************************************/
coordinate_fac(input,num)   /* coordinate command */
   char *input; 
   int num;
/************************************************************************/
{

     int i;
     int RetV;
     char OutText[BUFF_LEN];

/* switch to small characters                 */
     toller(parsed[1]);

/* help display                               */
   if(indexo(parsed[1],"?") == 1) {
 PrintMessage("coor*dinate aver*age      fvalue [seg:res:atm]           ! ");
 PrintMessage("            rota*te       axis  fvalue  [seg:res:atm]    ! ");
 PrintMessage("                          fvalueX fvalueY fvalueZ [s:r:a]! "); 
 PrintMessage("            tran*slate    xvalue yvalue zvalue  [s:r:a]  ! ");
 PrintMessage("            weig*ht       fvalue [seg:res:atm]           ! ");
   return;}

/*                               */
   if(indexo(parsed[1],"aver") == 1) {
   (void) CalcCoordAverageSet12(parsed[2],parsed[3],parsed[4],parsed[5]);
   return;
   }

/*                               */
   if(indexo(parsed[1],"weig") == 1) {
   (void) CalcCoordWeightSet12(parsed[2],parsed[3],parsed[4],parsed[5]);
   return;
   }

/*  translate                    */
   if(indexo(parsed[1],"tran") == 1) {
   (void) TranslateCoordinates(parsed[2],parsed[3],parsed[4],
                               parsed[5],parsed[6],parsed[7]);
   return;}

/*  rotate                    */
   if(indexo(parsed[1],"rota") == 1) {

    if(isalpha(parsed[2][0])) {
      (void) RotateCoordinates1(parsed[2],parsed[3],
                                parsed[4],parsed[5],parsed[6]);}
    else {
      (void) RotateCoordinates3(parsed[2],parsed[3],parsed[4],
                                parsed[5],parsed[6],parsed[7]);}

   return;}

/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of coordinate_fac */

/************************************************************************/
CalcCoordAverageSet12(Factor,Segment,Residue,Atom)
    char *Factor;
    char *Segment;
    char *Residue;
    char *Atom;
/************************************************************************/
{
     int *sel_list; /* selection list */
     int  ent_list; /* entries in the selection list */
     int  i,j,k;
     float Afactor,Xtemp,Ytemp,Ztemp; 

    if(mlist_deep < 2) {
      PrintMessage("?ERROR - two sets have to be defined for an average");
      return(1);}

    if((mliste[0] - mlists[0]) != (mliste[1] - mlists[1])) {
      PrintMessage("?ERROR - atom number in set 1 does not match atom numer in set 2");
      return(1);}

     sel_list = ivector(atom_list_max());
     ent_list = select_list(Segment,Residue,Atom,sel_list);

     Afactor = atof(Factor);


     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
         k = mlists[1] + j;
        Xtemp = Afactor * (GetXCoord(j) + GetXCoord(k));
        PutXCoord(Xtemp , j);

        Ytemp = Afactor * (GetYCoord(j) + GetYCoord(k));
        PutYCoord(Ytemp , j);

        Ztemp = Afactor * (GetZCoord(j) + GetZCoord(k));
        PutZCoord(Ztemp , j);
       }

        free(sel_list);
        return(0);
   }
/************************************************************************/
TranslateCoordinates(CXtra,CYtra,CZtra,Segment,Residue,Atom)
    char *CXtra;
    char *CYtra;
    char *CZtra;
    char *Segment;
    char *Residue;
    char *Atom;
/************************************************************************/
{
     int *sel_list; /* selection list */
     int  ent_list; /* entries in the selection list */
     int  i,j,k;
     float Xtemp,Ytemp,Ztemp; 
     float Xtemp1,Ytemp1,Ztemp1; 

    if(mlist_deep < 1) {
      PrintMessage("?ERROR - no atoms defined");
      return(1);}

     sel_list = ivector(atom_list_max());
     ent_list = select_list(Segment,Residue,Atom,sel_list);


     Xtemp = atof(CXtra);
      Ytemp = atof(CYtra);
       Ztemp = atof(CZtra);     

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
        Xtemp1 = Xtemp +  GetXCoord(j);
        PutXCoord(Xtemp1 , j);

        Ytemp1 = Ytemp + GetYCoord(j);
        PutYCoord(Ytemp1 , j);

        Ztemp1 = Ztemp + GetZCoord(j);
        PutZCoord(Ztemp1 , j);
       }

        free(sel_list);
        return(0);
   }
/*

     Rotate always around the coordinate center of the selected atoms
     
     Changed 1993-09-03  LUL
*/

/************************************************************************/
RotateCoordinates1(Caxis,Crot,Segment,Residue,Atom)
    char *Caxis;
    char *Crot;
    char *Segment;
    char *Residue;
    char *Atom;
/************************************************************************/
{
     int *sel_list; /* selection list */
     int  ent_list; /* entries in the selection list */
     int  i,j,k;
     int AxisRot;
     float Xtemp,Ytemp,Ztemp; 
     float Xtemp1,Ytemp1,Ztemp1; 
     float *XCtemp,*YCtemp,*ZCtemp;
     float cosa,sina;
     float XCcenter;
     float YCcenter;
     float ZCcenter;

    if(mlist_deep < 1) {
      PrintMessage("?ERROR - no atoms defined");
      return(1);}

     sel_list = ivector(atom_list_max());
     ent_list = select_list(Segment,Residue,Atom,sel_list);

     Xtemp = Piper180 * atof(Crot);

#ifdef sgi
  cosa = fcos(Xtemp);
  sina = fsin(Xtemp);
#else
  cosa = cos((double)Xtemp);
  sina = sin((double)Xtemp);
#endif

     XCcenter = YCcenter = ZCcenter = 0.0;

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
         XCcenter += GetXCoord(j);
         YCcenter += GetYCoord(j);
         ZCcenter += GetZCoord(j);}

     XCcenter /= (float)ent_list;
     YCcenter /= (float)ent_list;
     ZCcenter /= (float)ent_list;

     AxisRot = 0;
     if(Caxis[0] == 'x' || Caxis[0] == 'X') AxisRot = 1;
      if(Caxis[0] == 'y' || Caxis[0] == 'Y') AxisRot = 2;
       if(Caxis[0] == 'z' || Caxis[0] == 'Z') AxisRot = 3;

     if(AxisRot < 1 || AxisRot > 3) {
        PrintMessage("?ERROR - unknown axis defined");
        free(sel_list);
        return(1);}

     i = atom_list_max();
     XCtemp = vector(i);
      YCtemp = vector(i);
       ZCtemp = vector(i);

     for(i = 0 ; i < ent_list ; i++) {

         k = sel_list[i];

         switch(AxisRot) {

         case 1:

         Ytemp = GetYCoord(k) - YCcenter;
         Ztemp = GetZCoord(k) - ZCcenter;
         YCtemp[i] =  cosa * Ytemp + sina * Ztemp;
         ZCtemp[i] = -sina * Ytemp + cosa * Ztemp;

                break;

	 case 2:

         Xtemp = GetXCoord(k) - XCcenter;
         Ztemp = GetZCoord(k) - ZCcenter;
         XCtemp[i] = cosa * Xtemp - sina * Ztemp;
         ZCtemp[i] = sina * Xtemp + cosa * Ztemp;
                break;

         case 3:

         Xtemp = GetXCoord(k) - XCcenter;
         Ytemp = GetYCoord(k) - YCcenter;
         XCtemp[i] =  cosa * Xtemp + sina * Ytemp;
         YCtemp[i] = -sina * Xtemp + cosa * Ytemp;
                break;
       }
         j++;
     }

     for(i = 0 ; i < ent_list ; i++) {
        k = sel_list[i];

        switch(AxisRot) {

        case 1:
        PutYCoord((YCtemp[i]+YCcenter) , k);
        PutZCoord((ZCtemp[i]+ZCcenter) , k);
               break;
        case 2:
        PutXCoord((XCtemp[i]+XCcenter) , k);
        PutZCoord((ZCtemp[i]+ZCcenter) , k);
               break;
        case 3:
        PutXCoord((XCtemp[i]+XCcenter) , k);
        PutYCoord((YCtemp[i]+YCcenter) , k);
               break;
        }
        }


        free(XCtemp);
         free(YCtemp);
          free(ZCtemp);
        free(sel_list);
        return(0);
   }

/*

     Take the coordinates in set 1 and multiply them with Factor
                                 2                        (1-Factor)
*/
/************************************************************************/
CalcCoordWeightSet12(Factor,Segment,Residue,Atom)
    char *Factor;
    char *Segment;
    char *Residue;
    char *Atom;
/************************************************************************/
{
     int *sel_list; /* selection list */
     int  ent_list; /* entries in the selection list */
     int  i,j,k;
     float Afactor,Xtemp,Ytemp,Ztemp; 

    if(mlist_deep < 2) {
      PrintMessage("?ERROR - two sets have to be defined for a weighted sum");
      return(1);}

    if((mliste[0] - mlists[0]) != (mliste[1] - mlists[1])) {
      PrintMessage("?ERROR - atom number in set 1 does not match atom numer in set 2");
      return(1);}

     sel_list = ivector(atom_list_max());
     ent_list = select_list(Segment,Residue,Atom,sel_list);

     Afactor = atof(Factor);


     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
         k = mlists[1] + j;
        Xtemp = Afactor * GetXCoord(j) + (1. - Afactor) * GetXCoord(k);
        PutXCoord(Xtemp , j);

        Ytemp = Afactor * GetYCoord(j) + (1. - Afactor) * GetYCoord(k);
        PutYCoord(Ytemp , j);

        Ztemp = Afactor * GetZCoord(j) + (1. - Afactor) * GetZCoord(k);
        PutZCoord(Ztemp , j);
       }

        free(sel_list);
        return(0);
   }
/************************************************************************/
RotateCoordinates3(CXrot,CYrot,CZrot,Segment,Residue,Atom)
    char *CXrot;
    char *CYrot;
    char *CZrot;
    char *Segment;
    char *Residue;
    char *Atom;
/************************************************************************/
{
     int *sel_list; /* selection list */
     int  ent_list; /* entries in the selection list */
     int  i,j,k;
     float Xtemp,Ytemp,Ztemp; 
     float Xtemp1,Ytemp1,Ztemp1; 
     float *XCtemp,*YCtemp,*ZCtemp;
     float Fcos,Fsin;
     float XCcenter;
     float YCcenter;
     float ZCcenter;
     float Fentries;
     float Temp1;
     float Temp2;

    if(mlist_deep < 1) {
      PrintMessage("?ERROR - no atoms defined");
      return(1);}

     sel_list = ivector(atom_list_max());
     ent_list = select_list(Segment,Residue,Atom,sel_list);

     Xtemp = Piper180 * atof(CXrot);
      Ytemp = Piper180 * atof(CYrot);
       Ztemp = Piper180 * atof(CZrot);     

     XCtemp = vector(ent_list);
      YCtemp = vector(ent_list);
       ZCtemp = vector(ent_list);

     XCcenter = YCcenter = ZCcenter = 0.0;

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
         XCcenter += GetXCoord(j);
         YCcenter += GetYCoord(j);
         ZCcenter += GetZCoord(j);}

     Fentries  = 1./((float)ent_list);
     XCcenter *= Fentries;
     YCcenter *= Fentries;
     ZCcenter *= Fentries;

/* rotate around x - axis */

     if(Rabs(Xtemp) > 0.001) {
     Fcos = cos(Xtemp);
      Fsin = sin(Xtemp);

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];

        Temp1 = GetYCoord(j) - YCcenter;
        Temp2 = GetZCoord(j) - ZCcenter;

        YCtemp[i] =  Fcos * Temp1 + 
                     Fsin * Temp2;
        ZCtemp[i] = -Fsin * Temp1 + 
                     Fcos * Temp2;

       }

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
         PutYCoord((YCtemp[i]+YCcenter) , j);
         PutZCoord((ZCtemp[i]+ZCcenter) , j);
       }}

/* rotate around y - axis */

     if(Rabs(Ytemp) > 0.001) {
     Fcos = cos(Ytemp);
      Fsin = sin(Ytemp);

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];

        Temp1 = GetXCoord(j) - XCcenter;
        Temp2 = GetZCoord(j) - ZCcenter;

        XCtemp[i] =  Fcos * Temp1
                   - Fsin * Temp2;
        ZCtemp[i] =  Fsin * Temp1 
                   + Fcos * Temp2;

       }

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
         PutXCoord((XCtemp[i]+XCcenter) , j);
         PutZCoord((ZCtemp[i]+ZCcenter) , j);
       }}

/* rotate around z - axis */

     if(Rabs(Ztemp) > 0.001) {
     Fcos = cos(Ztemp);
      Fsin = sin(Ztemp);

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];

        Temp1 = GetXCoord(j) - XCcenter;
        Temp2 = GetYCoord(j) - YCcenter;

        XCtemp[i] =  Fcos * Temp1 
                   + Fsin * Temp2;
        YCtemp[i] = -Fsin * Temp1 
                   + Fcos * Temp2;

       }

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
         PutXCoord((XCtemp[i]+XCcenter) , j);
         PutYCoord((YCtemp[i]+YCcenter) , j);
       }}


        free(sel_list);
        free(XCtemp);
         free(YCtemp);
          free(ZCtemp);
        return(0);
   }

/************************************************************************/
int TranslateCoordinatesX(float CXtra, float CYtra, float CZtra)
/************************************************************************/
{
     static int *sel_list; /* selection list */
     static int  ent_list; /* entries in the selection list */
     static int  i,j,k;
     static float Xtemp,Ytemp,Ztemp; 
     static float Xtemp1,Ytemp1,Ztemp1; 

    if(mlist_deep < 1) {
      PrintMessage("?ERROR - no atoms defined");
      return(1);}

    if(ManSelection.slong < 1) return(1);

     sel_list = ManSelection.sel_list;
     ent_list = ManSelection.slong;

     Xtemp = CXtra;
      Ytemp = CYtra;
       Ztemp = CZtra;     

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
        Xtemp1 = Xtemp +  GetXCoord(j);
        PutXCoord(Xtemp1 , j);

        Ytemp1 = Ytemp + GetYCoord(j);
        PutYCoord(Ytemp1 , j);

        Ztemp1 = Ztemp + GetZCoord(j);
        PutZCoord(Ztemp1 , j);
       }

        return(0);
   }
/*

     Rotate always around the coordinate center of the selected atoms
     
     Changed 1993-09-03  LUL
*/

/************************************************************************/
int RotateCoordinates1X(float Crot , char Caxis)
/************************************************************************/
{
     static int *sel_list; /* selection list */
     static int  ent_list; /* entries in the selection list */
     static int  i,j,k;
     static int AxisRot;
     static float Xtemp,Ytemp,Ztemp; 
     static float Xtemp1,Ytemp1,Ztemp1; 
     static float *XCtemp,*YCtemp,*ZCtemp;
     static float cosa,sina;
     static float XCcenter;
     static float YCcenter;
     static float ZCcenter;
     static float Fentries;

    if(mlist_deep < 1) {
      PrintMessage("?ERROR - no atoms defined");
      return(1);}

    if(ManSelection.slong < 1) return(1);

     AxisRot = 0;
     if(Caxis == 'x' || Caxis == 'X') AxisRot = 1;
      if(Caxis == 'y' || Caxis == 'Y') AxisRot = 2;
       if(Caxis == 'z' || Caxis == 'Z') AxisRot = 3;

     if(AxisRot < 1 || AxisRot > 3) {
        PrintMessage("?ERROR - unknown axis defined");
        return(1);}

     sel_list =  ManSelection.sel_list;
     ent_list =  ManSelection.slong;

     Xtemp = Piper180 * Crot;

#ifdef sgi
  cosa = fcos(Xtemp);
  sina = fsin(Xtemp);
#else
  cosa = cos((double)Xtemp);
  sina = sin((double)Xtemp);
#endif

     XCcenter = YCcenter = ZCcenter = 0.0;

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
         XCcenter += GetXCoord(j);
         YCcenter += GetYCoord(j);
         ZCcenter += GetZCoord(j);}

     Fentries = 1.0 / ((float)ent_list);

     XCcenter *= Fentries;
     YCcenter *= Fentries;
     ZCcenter *= Fentries;

     i = atom_list_max();
     XCtemp = vector(i);
      YCtemp = vector(i);
       ZCtemp = vector(i);

     for(i = 0 ; i < ent_list ; i++) {

         k = sel_list[i];

         switch(AxisRot) {

         case 1:

         Ytemp = GetYCoord(k) - YCcenter;
         Ztemp = GetZCoord(k) - ZCcenter;
         YCtemp[i] =  cosa * Ytemp + sina * Ztemp;
         ZCtemp[i] = -sina * Ytemp + cosa * Ztemp;

                break;

	 case 2:

         Xtemp = GetXCoord(k) - XCcenter;
         Ztemp = GetZCoord(k) - ZCcenter;
         XCtemp[i] = cosa * Xtemp - sina * Ztemp;
         ZCtemp[i] = sina * Xtemp + cosa * Ztemp;
                break;

         case 3:

         Xtemp = GetXCoord(k) - XCcenter;
         Ytemp = GetYCoord(k) - YCcenter;
         XCtemp[i] =  cosa * Xtemp + sina * Ytemp;
         YCtemp[i] = -sina * Xtemp + cosa * Ytemp;
                break;
       }
         j++;
     }

     for(i = 0 ; i < ent_list ; i++) {
        k = sel_list[i];

        switch(AxisRot) {

        case 1:
        PutYCoord((YCtemp[i]+YCcenter) , k);
        PutZCoord((ZCtemp[i]+ZCcenter) , k);
               break;
        case 2:
        PutXCoord((XCtemp[i]+XCcenter) , k);
        PutZCoord((ZCtemp[i]+ZCcenter) , k);
               break;
        case 3:
        PutXCoord((XCtemp[i]+XCcenter) , k);
        PutYCoord((YCtemp[i]+YCcenter) , k);
               break;
        }
        }


        free(XCtemp);
         free(YCtemp);
          free(ZCtemp);
        return(0);
   }
/************************************************************************/
int RotateCoordinates3X(float CXrot,float CYrot,float CZrot)
/************************************************************************/
{
     static int *sel_list; /* selection list */
     static int  ent_list; /* entries in the selection list */
     static int  i,j,k;
     static float Xtemp,Ytemp,Ztemp; 
     static float Xtemp1,Ytemp1,Ztemp1; 
     static float *XCtemp,*YCtemp,*ZCtemp;
     static float Fcos,Fsin;
     static float XCcenter;
     static float YCcenter;
     static float ZCcenter;
     static float Fentries;
     static float Temp1;
     static float Temp2;


    if(mlist_deep < 1) {
      PrintMessage("?ERROR - no atoms defined");
      return(1);}

    if(ManSelection.slong < 1) return(1);

    ent_list = ManSelection.slong;
    sel_list = ManSelection.sel_list;

     Xtemp = Piper180 * CXrot;
      Ytemp = Piper180 * CYrot;
       Ztemp = Piper180 * CZrot;     

     XCtemp = vector(ent_list);
      YCtemp = vector(ent_list);
       ZCtemp = vector(ent_list);

     XCcenter = YCcenter = ZCcenter = 0.0;

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
         XCcenter += GetXCoord(j);
         YCcenter += GetYCoord(j);
         ZCcenter += GetZCoord(j);}

     Fentries  = 1.0 / ((float)ent_list);
     XCcenter *= Fentries;
     YCcenter *= Fentries;
     ZCcenter *= Fentries;

/* rotate around x - axis */

     if(Rabs(Xtemp) > 0.001) {
     Fcos = cos(Xtemp);
      Fsin = sin(Xtemp);

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];

        Temp1     =  GetYCoord(j) - YCcenter;
        Temp2     =  GetZCoord(j) - ZCcenter;

        YCtemp[i] =  Fcos * Temp1 + 
                     Fsin * Temp2;
        ZCtemp[i] = -Fsin * Temp1 + 
                     Fcos * Temp2;

       }

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
         PutYCoord((YCtemp[i]+YCcenter) , j);
         PutZCoord((ZCtemp[i]+ZCcenter) , j);
       }}

/* rotate around y - axis */

     if(Rabs(Ytemp) > 0.001) {
     Fcos = cos(Ytemp);
      Fsin = sin(Ytemp);

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];

        Temp1     =  GetXCoord(j) - XCcenter;
        Temp2     =  GetZCoord(j) - ZCcenter;

        XCtemp[i] =  Fcos * Temp1
                   - Fsin * Temp2;
        ZCtemp[i] =  Fsin * Temp1 
                   + Fcos * Temp2;

       }

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
         PutXCoord((XCtemp[i]+XCcenter) , j);
         PutZCoord((ZCtemp[i]+ZCcenter) , j);
       }}

/* rotate around z - axis */

     if(Rabs(Ztemp) > 0.001) {
     Fcos = cos(Ztemp);
      Fsin = sin(Ztemp);

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];

        Temp1     =  GetXCoord(j) - XCcenter;
        Temp2     =  GetYCoord(j) - YCcenter;

        XCtemp[i] =  Fcos * Temp1 
                   + Fsin * Temp2;
        YCtemp[i] = -Fsin * Temp1 
                   + Fcos * Temp2;

       }

     for(i = 0 ; i < ent_list ; i++) {
         j = sel_list[i];
         PutXCoord((XCtemp[i]+XCcenter) , j);
         PutYCoord((YCtemp[i]+YCcenter) , j);
       }}


        free(XCtemp);
         free(YCtemp);
          free(ZCtemp);
        return(0);
   }

