/*  

                       Copyright (c) 1990, 1991, 1992, 1993 by:
        Leif Laaksonen , Centre for Scientific Computing, ESPOO, FINLAND
            Confidential unpublished property of Leif Laaksonen
                        All rights reserved
  

*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <ctype.h>
#include <sys/types.h>
#include <malloc.h>
#include "maxdefs.h"
#include "traja.h"
#ifdef sgi
#include <gl/gl.h>
#include <device.h>
#endif

#define MAX_DIFF_RES   5000

#define ON     1
#define OFF    0

#define Rabs(a)    ( ( a ) > 0 ? (a) : -(a))
#define ROTATE(a,b)   rotateO(a,b)

#define PICK_READY()     {      getmatrix(xycoor);\
                                 mmode(MPROJECTION);\
                                  getmatrix(RotT);\
                                   multmatrix(xycoor);\
                                  getmatrix(xycoor);\
                                 loadmatrix(RotT);\
                                mmode(MVIEWING);}

#define FREE_ALL()       {   free(tx);\
                             free(ty);\
                             free(tz);\
                              free(txs);\
                              free(tys);\
                              free(tzs);\
                               free(sel_list);\
                                free(Xcalc);\
                                free(Ycalc);}
  
extern void print_names();
extern int  IsStringFloat();
extern int LookRepField();
extern void calc_cmass();
extern void calc_ccentre();
extern int calc_cmass_gen();
extern int calc_ccentre_gen();
extern int check_frame_region();
extern int LookRepField();
extern char *sprint_names();
extern int SaveCoordinates();
extern int DeleteOldSavedCoord();
extern int GetSavedCoord();
extern int TrajectoryLastFrame();
extern int TrajectoryFirstFrame();
extern int TrajectoryStepFrame();
extern int FramesInSet();
extern char traj_file[BUFF_LEN];
extern int traj_file_set;
extern int get_frame();
extern float QuatFit();
extern void add_names();
extern void vecsub();
extern int  AddNames();
extern float find_mass();
extern int *ivector();
extern int select_list();
extern void update_mlist(int Atoms);


   extern FILE *charmm_oc;
   extern int term_type;
   extern float near,far;
   extern int fake_now;
   extern float sumx,sumy,sumz;
   extern int current_struct;
   extern int *res1;
   extern int   *ivector();
   extern float *vector();
   extern int atom_list_max();
   extern void PrintMessage();
   extern int keyb_command;
   extern int numat;
   extern char parsed[MAXparse][MAXlinel];
   extern int *atm_type;
   extern int numat;
   extern int *atm_type;
   extern int select_list();
   extern int nreg();
   extern int traj_av_structure();
   extern char *sprint_names();
   extern int dynamics_frames;

     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern float *x;
     extern float *y;
     extern float *z;

     extern int mlist_deep;      /* stack number indicator */
     extern int mlists[MAX_MLIST]; /* First index for molecule list */
     extern int mliste[MAX_MLIST]; /* Second index for molecule list */
     extern char mnlist[MAX_MLIST][BUFF_LEN]; 
                                /* name list for molecule file names */

/*  cell dimensions */
    extern struct cell_dim {
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;
    float Xtrans;
    float Ytrans;
    float Ztrans;};
    
    extern struct cell_dim cell;

/* structur containing pointers to dynamics display variables */
    extern struct dyna_disp_var {
      int numset;             /* number of sets (or variables) */
      int current_set;        /* index to current set          */
      int point_len;          /* length of point array         */
      int *point_vec;         /* pointer to point array        */
      int dist_len;           /* length of dist array          */
      int *dist_vec;          /* pointer to dist array         */
      int ang_len;            /* length of angle array         */
      int *ang_vec;           /* pointer to angle array        */
      int tors_len;           /* length of torsion array       */
      int *tors_vec;          /* pointer to torsion array      */
      int obs_vec_len;        /* observation array length      */
      int obs_vec_curr;       /* display current               */
      float *obs_vec;};       /* pointer to observation array  */

    extern struct dyna_disp_var play_dynam_frames;

/* structure for the dynamics trajectory file */

   extern struct {
    char traj_file[BUFF_LEN];                 /* file name          */
    int natom;                                /* number of atoms    */
    int nstep;                                /* number of steps    */
    int time_bw_steps;                        /* time between steps */
    int time_first_frame;                     /* time of first frame */
    int first_frame;                          /* first frame to be displayed */
    int last_frame;                           /* last frame to be displayed  */
    int delta_frame;                          /* display every delta frame */
                   }    trajectory_info;     

   extern struct flush_dist_list {
    int num;
    int *list;};

   extern struct flush_dist_list graf_dist_list;

   extern int yes_no_graph;
   extern float xycoor[][4];
   extern float rotB[][4];
   extern float HitSphere2;
   extern int dev;
   extern short val;
   extern long menuval;
   extern long identmenu;
   extern int text_port;
   extern int xval;
   extern int yval;
   extern int xc;
   extern int yc;
   extern char *bottom_line;
   extern char *disp_list;
   extern int selection_mode;

    extern  struct {
       int    Mean;                   /* != 0 average is calulated  */
       int    Plot;                   /* != 0 plot is on            */
       int    Set;                    /* != 0 collection is on      */
       int    Numbers;                /* number of observations     */
       float *XValues;                /* X - pointer to values      */
       float *YValues;                /* Y - pointer to values      */
     } RaDiFu;

    struct {
      int corr_wind;   /* switch to indicate that window is on = 1 , off = 0 */
      int corr_vec1;   /* number of correlation vector 1 */
      int corr_vec2;   /* number of correlation vector 2 */
      int corr_obs;    /* number of points in vectors 1 and 2 */
      float *corr_val;} /* pointer to the correlation values */  
    corr_info;

    int    GetNumCorrObs();
    float *GetCorrVec();

    int calc_neigh = 0;   /* = 0 no calculation , > 0 calculation */

    int MeanSquareDisplacement();
    int MSDdataSet();
    int MSDdataDelete();
    int MSDdataDefine();
    int MSDdataWrite();
    int MSDdataFill();

    int CalcCMassList();

    float *GetDynamVec();
    int    GetNumDynamVec();

    struct {
       float *MSDarray;
       int    Start;
       int    Stop;
       int    Step;} MSDdata = {NULL , 0 , 0 , 0};

    int    GetMSDObs();
    float *GetMSDVec();

    struct ResSplit {
       int    Hits[MAX_DIFF_RES];
       int    Levels;} ResSplitList;

    struct {
       int NumSets;
       float *DataArray;
           } ClusterData = {0 , NULL};

    float  calculate_quatfit();
    int    SplitIntoResiduesList();
    int    GetNumResiduesList();
    int    CalcCluster();
    int    DeleteClusterData();
    int    GetClusterSpace();
    int    PutClusterData();

/************************************************************************/
calc_fac(input,num)   /* calculate command */
   char *input; 
   int num;
/************************************************************************/
{

     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern char *cvector();

     static float fhelp;
     static float fhelp1,fhelp2,fhelp3;
     static int i;
     static int ihelp1,ihelp2,ihelp3;
     char OutText[BUFF_LEN];
     char chelp[BUFF_LEN];

/* switch to small characters                 */
     toller(parsed[1]);

/* ?  give me some help                       */
    if(parsed[1][0] == '?') {
    printf(">>>> Help for calc*ulate command <<<<\n\
 Commands available              \n\
     calc*ulate  aver*age stru*cture \n\
                 atom*s arou*nd cmas*s   seg1:res1:atm1 fdist [seg2:res2:atm2]\n\
                                gcen*tre seg1:res1:atm1 fdist [seg2:res2:atm2]\n\
                                x:y:z                   fdist [seg2:res2:atm2]\n\
                                seg1:res1:atm1          fdist [seg2:res2:atm2]\n\
                 clus*ter  seg1:res1:atm1 [seg2:res2:atm2] \n\
                 cmas*s seg:res:atm \n\
                 conn*ectivity structure_num \n\
                 corr*elation set1:set2 [ifrst ilast istep]\n\
                 dist*ance  seg1:res1:atom1 seg2:res2:atom2 [nocr*oss]  \n\
                 angl*e    s1:r1:a1 s2:r2:a2 s3:r3:a3 [nocr*oss]\n\
                 tors*ion  s1:r1:a1 s2:r2:a2 s3:r3:a3 s4:r4:a4 [nocr*oss]\n\
                 minm*ax \n\
                 msfl*uctuation   seq:res:atm \n\
                 rmsf*luctuation   seq:res:atm [first last step]\n\
                 frms*fluctuation  seq:res:atm [first last step]\n\
                 msd*isplacement  seq:res:atm [first last step]\n\
                 ams*displacement seq:res:atm [first last step]\n\
                 mola*rmas {segment:residue:atom} \n\
                 neig*hbours nr seg:res:atm [external/all] [rcut] \n\
                -nei*ghbours                         \n\
                 pbou*ndary                          \n\
                 rdf seg:res:atm seg1:res1:atm1 [rcut fvalue boxl fvalue nbin ivalue]\n\
                 rdf cmas*s seg:res:atm seg1:res1:atm1 [rcut fvalue boxl fvalue nbin ivalue]\n\
                 rdf rmean             \n\
                -rdf                   \n\
                 rms seg:res:atom \n\
                 seco*ndary stru*cture \n\
                 vdwe*l seg:res:atm \n");
    return;}

/* calculate min/max   of the x,y and z coordinates     */
   if(indexo(parsed[1],"minm") == 1) {
     {
     float lxmin,lxmax,lymin,lymax,lzmin,lzmax;
              /* find min and max for the x,y,z coordinates */
		find_coord_max(&lxmin,&lxmax,&lymin,&lymax,&lzmin,&lzmax);
		sprintf(OutText,"Min and max values for the coordinates");
                PrintMessage(OutText);
		sprintf(OutText,"Min x: %f",lxmin);
                PrintMessage(OutText);
		sprintf(OutText,"Max x: %f",lxmax);
                PrintMessage(OutText);
		sprintf(OutText,"Min y: %f",lymin);
                PrintMessage(OutText);
		sprintf(OutText,"Max y: %f",lymax);
                PrintMessage(OutText);
		sprintf(OutText,"Min z: %f",lzmin);
                PrintMessage(OutText);
		sprintf(OutText,"Max z: %f",lzmax);
                PrintMessage(OutText);
                sprintf(OutText,"Near : %f , far : %f ",near,far);
                PrintMessage(OutText);
   }
   return;}

/* calculate molar mass                       */
   if(indexo(parsed[1],"mola") == 1) {
   molar_mass(num);
   return;
   }

/* calculate vdw and coulomb interaction      */
   if(indexo(parsed[1],"vdwe") == 1) {
   pre_vdwel();
   return;}

/* calc secondary structure                   */
   if(indexo(parsed[1],"seco") == 1) {
     toller(parsed[2]);
     if(indexo(parsed[2],"stru") == 1) {
     sec_struct(3);
     return;}
   }
/* calculate average structure                */
   if(indexo(parsed[1],"aver") == 1) {
     toller(parsed[2]);
     if(indexo(parsed[2],"stru") == 1) {
        if(traj_av_structure()) {
        return;}
/* flag the file name */
        strncpy(mnlist[0],"Average structure",BUFF_LEN);
        return;}
    }

/* calculate mean square fluctuation for a selection list of atoms on a md 
   trajectory */
   if(indexo(parsed[1],"msfl") == 1) {
     ms_fluctuation(parsed[2],parsed[3],parsed[4],parsed[5],parsed[6],parsed[7]);
     return;}

/* calculate root mean square fluctuation for a selection list of atoms on a md  trajectory */
   if(indexo(parsed[1],"rmsf") == 1) {  /* no superimpose (no fit) */
     RMS_Fluctuation(0 , parsed[2],parsed[3],parsed[4],parsed[5],
                         parsed[6],parsed[7]);
     return;}
   if(indexo(parsed[1],"frms") == 1) { /* superimpose conformations (fit) */
     RMS_Fluctuation(1 , parsed[2],parsed[3],parsed[4],parsed[5],
                         parsed[6],parsed[7]);
     return;}
  
/* calculate mean square displacement for a selected list of atoms */
   if(indexo(parsed[1],"msdi") == 1) {  /* from centre of mass */
     (void)MeanSquareDisplacement(1,parsed[2],parsed[3],parsed[4],
                                    parsed[5],parsed[6],parsed[7]);
     return;}

   if(indexo(parsed[1],"amsd") == 1) {  /* from atom positions */
     (void)MeanSquareDisplacement(0,parsed[2],parsed[3],parsed[4],
                                    parsed[5],parsed[6],parsed[7]);
     return;}

/* calculate neighbours                       */
   if(indexo(parsed[1],"neigh") == 1) {
     neighbours(1);
     return;}
   if(indexo(parsed[1],"-nei") == 1) {
     if(graf_dist_list.num < 1) {
       PrintMessage("?ERROR - no neigbours to be deleted");
       return;}
     free(graf_dist_list.list);
      graf_dist_list.num = 0;
       calc_neigh = 0;
        return;}

/* calculate centre of mass                   */
   if(indexo(parsed[1],"cmas") == 1) {
   calc_cmass();
   return;
   }

/* calculate coordinate centre                */
   if((indexo(parsed[1],"ccen") == 1) || (indexo(parsed[1],"gcen") == 1)) {
   calc_ccentre();
   return;
   }

/* calculate correlation                      */
   if(indexo(parsed[1],"corr") == 1) {

     if(play_dynam_frames.obs_vec_len < 1) {
       printf("?ERROR - no time series defined \n");
       return;}

     corr_info.corr_vec1 = atoi(parsed[2]);
     corr_info.corr_vec2 = atoi(parsed[3]);

     if(corr_info.corr_vec1 < 1 || corr_info.corr_vec1 > play_dynam_frames.obs_vec_len 
     || corr_info.corr_vec2 < 1 || corr_info.corr_vec2 > play_dynam_frames.obs_vec_len) {
     PrintMessage("?ERROR - error in the range specified ");
     return;}

     ihelp1    = atoi(parsed[4]);
     if(ihelp1 == 0) ihelp1 = 1;
      ihelp2   = atoi(parsed[5]);
      if(ihelp2 == 0) ihelp2 = trajectory_info.nstep;  
       ihelp3  = atoi(parsed[6]);
       if(ihelp3 == 0) ihelp3 = 1;

      i = check_frame_region(&ihelp1,&ihelp2,&ihelp3);
      if(i > 0) return;

   trajectory_info.first_frame = ihelp1;
    trajectory_info.delta_frame = ihelp3;

   PrintMessage("Correlation calculation specified:");
   sprintf(OutText,"Correlation between sets '%d':'%d'",
           corr_info.corr_vec1,
           corr_info.corr_vec2);
   PrintMessage(OutText);
   sprintf(OutText,"First frame number: %d , last frame number: %d , step: %d",
           ihelp1,ihelp2,ihelp3);
   PrintMessage(OutText);

   keyb_command = 1;
   study_dynamics(20);
   return;}
        
/* calculate distance                         */
   if(indexo(parsed[1],"dist") == 1) {

          (void)LookRepField( 2 , parsed[2]);

   calculate_dist();
   return;}

/* calculate angle                            */
   if(indexo(parsed[1],"angl") == 1) {

          (void)LookRepField( 3 , parsed[2]);

   calculate_ang();
   return;}

/* calculate torsion                          */
   if(indexo(parsed[1],"tors") == 1) {

          (void)LookRepField( 4 , parsed[2]);

   calculate_tors();
   return;}

/* calculate rms                              */
   if(indexo(parsed[1],"rms") == 1) {
     if(mlist_deep < 2) {
       PrintMessage("?ERROR - no structure or only one structure in buffer ");
       return;}
   calculate_rms(parsed[2],parsed[3],parsed[4]);
   return;}

/* calculate rdf (radial distribution function) */
   if(indexo(parsed[1],"rdf") == 1) {

      strncpy(chelp,parsed[2],BUFF_LEN);
       toller(chelp);
        if(indexo(chelp,"rmean") == 1) {
         CalcMeanRDF();
          return;}
  
     /* look for optional params */
      i = 8 ; 

        if(indexo(chelp,"cmas") == 1) {
          (void)LookRepField( 2 , parsed[3]);
            i = 9;}
        else
          (void)LookRepField( 2 , parsed[2]);

       fhelp   = 10.;    /* rcut = 10. */
/* take the defined cell parameters */
       fhelp1 = cell.a;
        fhelp2 = cell.b;
         fhelp3  = cell.c; 

       ihelp1  = 101;    /* nbins (number of bins) */
      while(1) {
         if(parsed[i][0] == '\0') break; /* all done */

           toller(parsed[i]);

           if(indexo(parsed[i],"nbin") == 1 ||
              indexo(parsed[i],"bins") == 1) {
              i++;
               ihelp1 = atoi(parsed[i]);
              continue;}

           if(indexo(parsed[i],"rcut") == 1) {
              i++;
               fhelp = atof(parsed[i]);
              continue;}

           if(indexo(parsed[i],"boxl") == 1) {
              i++;
               (void)SolveBoxSize(parsed[i] , &fhelp1 , &fhelp2 , &fhelp3);
/*               fhelp1 = fhelp2 = fhelp3 = atof(parsed[i]); */
              continue;}
                i++;
            }


     calculate_rdf(parsed[2],parsed[3],parsed[4],
                   parsed[5],parsed[6],parsed[7],parsed[8],
                   fhelp,ihelp1,fhelp1,fhelp2,fhelp3);
     return;}

/* calculate rdf (radial distribution function) */
   if(indexo(parsed[1],"-rdf") == 1) {

     if(!RaDiFu.Set) {
       PrintMessage("?ERROR - no RDF defined to be deleted");
       return;}

      if(DeleteRDF()) return;

     return;}


/* calc number of specified atoms around an atom or point in the x,y,z space */
     if(indexo(parsed[1],"atom") == 1) {
        toller(parsed[2]);
        if(indexo(parsed[2],"roun") == 1 || indexo(parsed[2],"arou") == 1 ) {

/* round centre of mass                       */
          strncpy(chelp,parsed[3],BUFF_LEN);
          toller(chelp);
          if(indexo(chelp,"cmas") == 1) {
            Show_round_atoms(3);
            return;}

          if(indexo(chelp,"gcen") == 1) {
            Show_round_atoms(4);
            return;}
/* .......................................... */

/* it as accepted as a number if first character is number,+ ,- or . */
/* handle the fact that the segment name can have a digit as the first char */
/* temporary fix up (if it happens change it to a char) */

          if((isdigit(parsed[3][0]) || parsed[3][0] == '+' || 
                                       parsed[3][0] == '-' ||
                                       parsed[3][0] == '.' ) &&
             (isdigit(parsed[4][0]) || parsed[4][0] == '+' || 
                                       parsed[4][0] == '-' ||
                                       parsed[4][0] == '.' ) &&
             (isdigit(parsed[5][0]) || parsed[5][0] == '+' || 
                                       parsed[5][0] == '-' ||
                                       parsed[5][0] == '.' )) {
          Show_round_atoms(1);
          return;}
          else {
          Show_round_atoms(2);
          return;}}
      }

/* prepare periodic bounday conditions     */
   if(indexo(parsed[1],"pbou") == 1) {
      (void)CalcPBound();
      return;}

/* calculate connectivity (force the calculation of new connectivity matrix) */
   if(indexo(parsed[1],"conn") == 1) {
     ihelp1 = atoi(parsed[2]);
     if(ihelp1 < 1 ) ihelp1 = 1;
     if(ihelp1 > mlist_deep) {
       PrintMessage("?ERROR - in structure number ");
       return;} 
     (void)atom_conn(ihelp1);
      return;}

/* calculate quatfit of two molecules         */
    if(indexo(parsed[1],"quat") == 1) {
       (void)calculate_quatfit(parsed[2] , parsed[3] , parsed[4] ,
                               parsed[5] , parsed[6] , parsed[7] ,
                               ON);
       return;}

/* calculate cluster         */
    if(indexo(parsed[1],"clus") == 1) {
       (void) CalcCluster(parsed[2] , parsed[3] , parsed[4] ,
                          parsed[5] , parsed[6] , parsed[7] );
       return;}

/* default position "command not recognized"  */

     sprintf(OutText,"?ERROR: Following command not recognized: %s \n",input);
     PrintMessage(OutText);

}      /* end of calc_fac */

/************************************************************************/
molar_mass(num)   /* calculate molar mass  */
    
     int num;
/************************************************************************/
{

      extern int numat;
      extern char parsed[MAXparse][MAXlinel];
      extern int *atm_type;
      extern float find_mass();
      extern int *ivector();
      extern int select_list();

      int i,atom_max;
      float mmass;
      int *sel_list;
      int slong;
      char OutText[BUFF_LEN];
      
      atom_max = atom_list_max();

      sel_list = ivector(atom_max);

      mmass = 0.0;

      if(num < 5) {
        for(i = 0 ; i < mliste[0] ; i++) sel_list[i] = i;
        slong = mliste[0];
      }
      else {
      slong = select_list(parsed[2],parsed[3],parsed[4],sel_list);
      }

      if(slong > 0) {
      for(i = 0 ; i < slong ; i++) {
         mmass+= find_mass(atm_type[sel_list[i]]);
      }}
      else
      PrintMessage("?ERROR - no atoms in the selection list ");

      free(sel_list);

      sprintf(OutText," Molar mass is : %f ",mmass);
      PrintMessage(OutText);
}       

/************************************************************************/
calculate_dist()
/************************************************************************/
{
     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern int *ivector();

     int *sel_list1;
     int slong1;
     int *sel_list2;
     int slong2;
     int i,j,si,sj;
     float dist;
     int atom_max;
     int cross;
     char OutText[BUFF_LEN];
     int FirstFloat  = 0;
     int SecondFloat = 0;
     float TempX,TempY,TempZ;
     float TempX1,TempY1,TempZ1;

     FirstFloat  = IsStringFloat(parsed[2]);
     SecondFloat = IsStringFloat(parsed[5]);

/* neither is float */
   if(!FirstFloat && !SecondFloat) {
     atom_max = atom_list_max();

     sel_list1 = ivector(atom_max);
     slong1 = select_list(parsed[2],parsed[3],parsed[4],sel_list1);     
     sel_list2 = ivector(atom_max);
     slong2 = select_list(parsed[5],parsed[6],parsed[7],sel_list2);     

     cross = check_if_cross(parsed[8]);

     if(slong1 > 0 && slong2 > 0) {
      for(i = 0 ; i < slong1 ; i++) {
         si = sel_list1[i];
         for(j = 0 ; j < slong2 ; j++) { 
            sj = sel_list2[j];

       if(cross) {
                 if(res1[si] != res1[sj]) continue;}

  dist = sqrt(pow((x[si]-x[sj]),2.)+
              pow((y[si]-y[sj]),2.)+
              pow((z[si]-z[sj]),2.));
  sprintf(OutText,"Distance >%.4s<>%.4s(%d)<>%.4s<  -  >%.4s<>%.4s(%d)<>%.4s< :",
         segment+4*si,resnam+4*si,res1[si],atnam+4*si,
         segment+4*sj,resnam+4*sj,res1[sj],atnam+4*sj);
   PrintMessage(OutText);
  sprintf(OutText," %f ",dist);
   PrintMessage(OutText);}
     }}
     else
     PrintMessage("?ERROR - no atoms in selection list 1 or 2");

     free(sel_list1);
     free(sel_list2);
     return;}

/* first is float */

     if(FirstFloat && !SecondFloat) {

     TempX = atof(parsed[2]);
      TempY = atof(parsed[3]);
       TempZ = atof(parsed[4]);

     atom_max = atom_list_max();

     sel_list2 = ivector(atom_max);
     slong2 = select_list(parsed[5],parsed[6],parsed[7],sel_list2);     

     if(slong2 > 0) {
         for(j = 0 ; j < slong2 ; j++) { 
            sj = sel_list2[j];

  dist = sqrt(pow((TempX-x[sj] - sumx),2.)+
              pow((TempY-y[sj] - sumy),2.)+
              pow((TempZ-z[sj] - sumz),2.));

  sprintf(OutText,"Distance >x:%f<>y:%f<>z:%f<  -  >%.4s<>%.4s(%d)<>%.4s< :",
         TempX,TempY,TempZ,
         segment+4*sj,resnam+4*sj,res1[sj],atnam+4*sj); 
   PrintMessage(OutText);
  sprintf(OutText," %f ",dist);
   PrintMessage(OutText);}
       }
     else
     PrintMessage("?ERROR - no atoms in selection list 1 or 2");

     free(sel_list2);
     return;}

/* second is float */

     if(!FirstFloat && SecondFloat) {

     TempX = atof(parsed[5]);
      TempY = atof(parsed[6]);
       TempZ = atof(parsed[7]);

     atom_max = atom_list_max();

     sel_list1 = ivector(atom_max);
     slong1 = select_list(parsed[2],parsed[3],parsed[4],sel_list1);     

     if(slong1 > 0) {
         for(j = 0 ; j < slong1 ; j++) { 
            si = sel_list1[j];

  dist = sqrt(pow((TempX-x[si] - sumx),2.)+
              pow((TempY-y[si] - sumy),2.)+
              pow((TempZ-z[si] - sumz),2.));

  sprintf(OutText,"Distance >%.4s<>%.4s(%d)<>%.4s< - >x:%f<>y:%f<>z:%f<  :",
         segment+4*si,resnam+4*si,res1[si],atnam+4*si,
         TempX,TempY,TempZ);
   PrintMessage(OutText);
  sprintf(OutText," %f ",dist);
   PrintMessage(OutText);}
     }
     else
     PrintMessage("?ERROR - no atoms in selection list 1 or 2");

     free(sel_list1);
     return;}

/* both are float      */
    if(FirstFloat && SecondFloat) {

       TempX = atof(parsed[2]);
       TempX1= atof(parsed[5]);
        TempY = atof(parsed[3]);
        TempY1= atof(parsed[6]);
         TempZ = atof(parsed[4]);
         TempZ1= atof(parsed[7]);

       dist = sqrt(pow((TempX - TempX1), 2.) + 
                   pow((TempY - TempY1), 2.) + 
                   pow((TempZ - TempZ1), 2.));

  sprintf(OutText,"Distance >x:%f<>y:%f<>z:%f<  -  >x:%f<>y:%f<>z:%f< :",
         
        TempX,TempY,TempZ,TempX1,TempY1,TempZ1);
   PrintMessage(OutText);
  sprintf(OutText," %f ",dist);
   PrintMessage(OutText);}
     else
     PrintMessage("?ERROR - no atoms in selection list 1 or 2");


}



/************************************************************************/
calculate_ang()
/************************************************************************/
{
     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern int *ivector();
     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern float *x;
     extern float *y;
     extern float *z;
     extern float pia;

     int *sel_list1;
     int slong1;
     int *sel_list2;
     int slong2;
     int *sel_list3;
     int slong3;
     int i,j,k,si,sj,sk;
     float angle;
     int atom_max;
     int cross;
     char OutText[BUFF_LEN];

     atom_max = atom_list_max();

     sel_list1 = ivector(atom_max);
     slong1 = select_list(parsed[2],parsed[3],parsed[4],sel_list1);     
     sel_list2 = ivector(atom_max);
     slong2 = select_list(parsed[5],parsed[6],parsed[7],sel_list2);     
     sel_list3 = ivector(atom_max);
     slong3 = select_list(parsed[8],parsed[9],parsed[10],sel_list3);     

     cross = check_if_cross(parsed[11]);

     if(slong1 > 0 && slong2 > 0 && slong3 > 0) {
      for(i = 0 ; i < slong1  ; i++) {
         si = sel_list1[i];
         for(j = 0 ; j < slong2  ; j++) {
            sj = sel_list2[j]; 
            for(k = 0 ; k < slong3 ; k++) {
               sk = sel_list3[k];

          if(cross) {
                    if(res1[si] != res1[sj] ||
                       res1[si] != res1[sk] || 
                       res1[sj] != res1[sk]) continue;}

bangle(si,sj,sk,&angle);
sprintf(OutText,"Angle >%.4s<>%.4s(%d)<>%.4s<->%.4s<>%.4s(%d)<>%.4s<->%.4s<>%.4s(%d)<>%.4s< :",
         segment+4*si,resnam+4*si,res1[si],atnam+4*si,
         segment+4*sj,resnam+4*sj,res1[sj],atnam+4*sj,
         segment+4*sk,resnam+4*sk,res1[sk],atnam+4*sk);
      PrintMessage(OutText);
     sprintf(OutText," %f ",180.*angle/pia);
      PrintMessage(OutText);}
         }
     }}
     else
     PrintMessage("?ERROR - no atoms in selection list 1, 2 or 3 ");

     free(sel_list1);
     free(sel_list2);
     free(sel_list3);
}


/************************************************************************/
calculate_tors()
/************************************************************************/
{
     extern char parsed[MAXparse][MAXlinel];
     extern int numat;
     extern int *ivector();
     extern char *segment;
     extern char *resnam;
     extern char *atnam;
     extern float *x;
     extern float *y;
     extern float *z;
     extern float pia;

     int *sel_list1;
     int slong1;
     int *sel_list2;
     int slong2;
     int *sel_list3;
     int slong3;
     int *sel_list4;
     int slong4;
     int i,j,k,l,si,sj,sk,sl;
     float angle;
     int atom_max;
     int cross;
     char OutText[BUFF_LEN];
     

     atom_max = atom_list_max();

     sel_list1 = ivector(atom_max);
     slong1 = select_list(parsed[2],parsed[3],parsed[4],sel_list1);     
     sel_list2 = ivector(atom_max);
     slong2 = select_list(parsed[5],parsed[6],parsed[7],sel_list2);     
     sel_list3 = ivector(atom_max);
     slong3 = select_list(parsed[8],parsed[9],parsed[10],sel_list3);     
     sel_list4 = ivector(atom_max);
     slong4 = select_list(parsed[11],parsed[12],parsed[13],sel_list4);     

     cross = check_if_cross(parsed[14]);

     if(slong1 > 0 && slong2 > 0 && slong3 > 0 && slong4 > 0) {
      for(i = 0 ; i < slong1  ; i++) {
         si = sel_list1[i];
         for(j = 0 ; j < slong2  ; j++) { 
            sj = sel_list2[j];
            for(k = 0 ; k < slong3 ; k++) {
               sk = sel_list3[k];
               for(l = 0 ; l < slong4 ; l++) {
                  sl = sel_list4[l];

         if(cross) {
                   if(res1[si] != res1[sj] || 
                      res1[si] != res1[sk] || 
                      res1[si] != res1[sl] || 
                      res1[sj] != res1[sk] ||
                      res1[sj] != res1[sl] || 
                      res1[sk] != res1[sl]) continue;}

dihed(si,sj,sk,sl,&angle);
sprintf(OutText,"Torsion >%.4s<>%.4s(%d)<>%.4s<->%.4s<>%.4s(%d)<>%.4s<->%.4s<>%.4s(%d)<>%.4s<->%.4s<>%.4s(%d)<>%.4s< :",
         segment+4*si,resnam+4*si,res1[si],atnam+4*si,
         segment+4*sj,resnam+4*sj,res1[sj],atnam+4*sj,
         segment+4*sk,resnam+4*sk,res1[sk],atnam+4*sk,
         segment+4*sl,resnam+4*sl,res1[sl],atnam+4*sl);
    PrintMessage(OutText);
   sprintf(OutText," %f ",180.*angle/pia);
    PrintMessage(OutText);}
         }
     }
   }}
   else
   PrintMessage("?ERROR - no atoms in the selection list 1,2,3 or 4 ");

     free(sel_list1);
     free(sel_list2);
     free(sel_list3);
     free(sel_list4);
}



/***************************************************************************/
pre_correl(obs_vec_point,obs_vec,n,ans)
         int obs_vec_point;
         float *obs_vec;
         float *ans;
         int n;
/***************************************************************************/
{
          extern int check_pow_2();
          extern float *vector();

          static float *fft;
          static float *data1;
          static float *data2;
          static float fhelp1,fhelp2;
          static int n2;
          static int i;
          static int vec1,vec2;
         
          n2 = check_pow_2(n);
          fft = vector(2 * n2);
          data1 = vector(n2);
          data2 = vector(n2);

/* fill data arrays with zero padding if necessary */
    /* first array .... */
          if(corr_info.corr_vec1 == corr_info.corr_vec2) { /* autocorr */

          vec1 = (corr_info.corr_vec1-1) * n;
          for(i = 0 ; i < n2 ; i++) {
           if(i < n)   data1[i] = obs_vec[i+vec1];
            else
             data1[i] = 0.0;
	 }
    /* now handle the other one */
          vec2 = (corr_info.corr_vec2-1) * n;
          for(i = 0 ; i < n2 ; i++) {
           if(i < n)  data2[i] = obs_vec[i+vec2];
           else
           data2[i] = 0.0;
	 }

          correl((data1-1),(data2-1),(fft-1),n2,(ans-1));

          fhelp1 = ans[0];
          for(i=0 ; i<n2 ; i++) { /* normalize the result */
          ans[i] = ans[i] / fhelp1;}}

          else { /* cross correlation */

          vec1 = (corr_info.corr_vec1-1) * n;
          for(i = 0 ; i < n2 ; i++) {
           if(i < n)   data1[i] = obs_vec[i+vec1];
            else
             data1[i] = 0.0;
	 }

          correl((data1-1),(data1-1),(fft-1),n2,(ans-1));

          fhelp1 = ans[0];

    /* now handle the other one */
          vec2 = (corr_info.corr_vec2-1) * n;
          for(i = 0 ; i < n2 ; i++) {
           if(i < n)  data2[i] = obs_vec[i+vec2];
           else
           data2[i] = 0.0;
	 }

          correl((data2-1),(data2-1),(fft-1),n2,(ans-1));

          fhelp2 = ans[0];

    /* do now the cross correlation */

          correl((data1-1),(data2-1),(fft-1),n2,(ans-1));

          fhelp1 = sqrt(fhelp1*fhelp2);
          for(i=0 ; i<n2 ; i++) { /* normalize the result */
          ans[i] = ans[i] / fhelp1;}

	}
           free(fft);
            free(data1);
             free(data2);
}

/***************************************************************************/
mantime(obs_vec,ndim,nr,alt,fnum,inum)  /* manipulate time series */
       float *obs_vec;        /* vector with the data   */
       int    ndim;           /* number of observations in one "set" */
       int    nr;             /* number of time series to be manipulated */
       int    alt;            /* switch for the different alternatives */
       float fnum;            /* real number needed for some series */
       int   inum;            /* integer number needed for some series */
/***************************************************************************/
{

       extern float vecsum();
       extern float fmini();
       extern float fmaxi();

       static int i;
       static int ihelp,ihelp1;
       static float fhelp;

       ihelp = (nr - 1) * ndim;

       switch(alt) {

     case 1:   /* DAVErage    Q(t) = Q(t) - <Q(t)> */

       /* calculate first average */
       fhelp = vecsum(&obs_vec[ihelp],ndim) / ((float) ndim);

       /* do the rest             */
       for(i = 0 ; i < ndim ; i++) obs_vec[ihelp + i] -= fhelp;

       break;

     case 2:  /* SQUAre   Q(t) = Q(t) ** 2   */

       for(i = 0 ; i < ndim ; i++) {
        fhelp = obs_vec[ihelp + i];
         obs_vec[ihelp+i] = fhelp * fhelp;}

       break;

     case 3:  /* COS  Q(t) = cos(Q(t))  */

        for(i = 0 ; i < ndim ; i++) obs_vec[ihelp+i] = fcos(obs_vec[ihelp+i]);
        
        break;

     case 4: /* COS2  Q(t) = 3*cos(Q(t))**2 - 1   */

        for(i = 0 ; i < ndim ; i++) {
         fhelp = obs_vec[ihelp+i];
          obs_vec[ihelp+i] = 3.*fhelp*fhelp - 1.;}

         break;
      
     case 5:  /* SQRT  Q(t) = sqrt(Q(t))  */

        for(i = 0 ; i < ndim ; i++) obs_vec[ihelp+i] = sqrt(obs_vec[ihelp+i]);

         break;

     case 6: /* DINItial  Q(t) = Q(t) - Q(0)  */

         fhelp = obs_vec[ihelp];
         for(i = 0 ; i < ndim ; i++) obs_vec[ihelp+i] -= fhelp;

          break;

     case 7: /*  COPY nr Q(t) = Q2(t)   */

          ihelp1 = inum * ndim;
          for(i = 0 ; i < ndim ; i++) obs_vec[ihelp+i] = obs_vec[ihelp1+i];

           break;

     case 8: /* ADD nr Q(t) = Q(t) + Q2(t)   */

          ihelp1 = inum * ndim;
          for(i = 0 ; i < ndim ; i++) obs_vec[ihelp+i] += obs_vec[ihelp1+i];

           break;

     case 9: /* LOG Q(t) = log(Q(t))  */

         for(i = 0 ; i < ndim ; i++) obs_vec[ihelp+i] = flog(obs_vec[ihelp+i]);

            break;

     case 10: /* EXP Q(t) = exp(Q(t))  */

         for(i = 0 ; i < ndim ; i++) obs_vec[ihelp+i] = fexp(obs_vec[ihelp+i]);

          break;

     case 11: /* POWer real Q(t) = Q(t) ** real  */

          for(i = 0 ; i < ndim ; i++) 
             obs_vec[ihelp+i] = pow(obs_vec[ihelp+i],fnum);

           break;

     case 12: /* MULT real Q(t) = real * Q(t)  */

          for(i = 0 ; i < ndim ; i++)
             obs_vec[ihelp+i] *= fnum;

           break;

     case 13: /* DIVIde real Q(t) = Q(t) / real  */

           for(i = 0 ; i < ndim ; i++) 
              obs_vec[ihelp+i] /= fnum;

            break;

     case 14: /* SHIFt real Q(t) = Q(t) + real  */

            for(i = 0 ; i < ndim ; i++) 
               obs_vec[ihelp+i] += fnum;

            break;

     case 15: /* DMIN Q(t) = Q(t) - Q(min) */

     /* calc min first */
     fhelp = fmini(obs_vec[ihelp],ndim);
           for(i = 0 ; i < ndim ; i++)
              obs_vec[ihelp+i] -= fhelp;

            break;

     case 16: /* ABS Q(t) = abs(Q(t)) */

           for(i = 0 ; i < ndim ; i++) 
              obs_vec[ihelp+i] = Rabs(obs_vec[ihelp+i]);

           break;

     case 17: /* DIVFirst Q(t) = Q(t) / Q(0)  */

           fhelp = obs_vec[ihelp];
           for(i = 0 ; i < ndim ; i++) obs_vec[ihelp+i] /= fhelp;

           break;

     case 18: /* DIVMaximum Q(t) = Q(t) /max(Q(t))  */

           fhelp = fmaxi(obs_vec[ihelp],ndim);
           for(i = 0 ; i < ndim ; i++)
              obs_vec[ihelp+i] /= fhelp;

            break;

     case 19: /* ZERO Q(t) = 0.0  */

           for(i = 0 ; i < ndim ; i++) obs_vec[ihelp+i] = 0.0;

            break;

     }
}



/************************************************************************/
pre_vdwel()   /* pre vdw + el routine  */
/************************************************************************/
{

      extern int numat;
      extern char parsed[MAXparse][MAXlinel];
      extern int *atm_type;
      extern float near,far;
      extern float find_mass();
      extern float vdwel();
      extern int *ivector();
      extern int select_list();

      int i;
      float energy;
      float rcut;
      int *sel_list;
      int slong;
      int atom_max;
      char OutText[BUFF_LEN];

      atom_max = atom_list_max();
      
      sel_list = ivector(atom_max);

      energy = 0.0;

      slong = select_list(parsed[2],parsed[3],parsed[4],sel_list);

      rcut = atof(parsed[5]);
      if(rcut < 0.001) rcut = Rabs(far - near);
      sprintf(OutText,"*** Calculating vdW + electrostatic energy (rcut = %f )",rcut);
      PrintMessage(OutText);

      if(slong > 0) {
      for(i = 0 ; i < slong ; i++) {
      strncpy(OutText,sprint_names(sel_list[i]),BUFF_LEN);
      PrintMessage(OutText);
         energy += vdwel(sel_list[i] , rcut);
      PrintMessage(" ");
      }
      sprintf(OutText,"Total energy for total selection list: %f ",energy);
      PrintMessage(OutText);
      }
      else
      PrintMessage("?ERROR - no atoms in the selection list");

      free(sel_list);

}       

/*

    This is a very primitive RMS calculator. The idea is to minimize 
    the function sum([x(atom_i) - ((x(atom_j + dist)))]**2) where one looks
    for the value of 'dist' which gives the smallest sum.

    The first molecule is always the FIXED molecule while the second
    molecule is allowed to move.


    Leif Laaksonen 1990

*/

/************************************************************************/
calculate_rms(text1,text2,text3)   /* calculate rms  */
    
     char *text1;
     char *text2;
     char *text3;
/************************************************************************/
{

      extern int numat;
      extern char parsed[MAXparse][MAXlinel];
      extern int *atm_type;
      extern float find_mass();
      extern int *ivector();
      extern int select_list();

      static int i,j,jj,ipush;
      static float temp,temp1,temp2,temp3;
      static float mmass,deno;
      static int *sel_list;
      static int slong,save1,save2,atom_max;
      static int imax,imin;
      static float vmax,vmin;

      char OutText[BUFF_LEN];

      atom_max = atom_list_max();      

      sel_list = ivector(atom_max);

      temp1 = 0.0;
       temp2 = 0.0;
        temp3 = 0.0;
         mmass = 0.0;

      if(text1[0] == '\0') {
        for(i = mlists[0] ; i < mliste[0] ; i++) sel_list[i] = i;
        slong = mliste[0];
      }
      else {
      save1 = current_struct;
      save2 = term_type;
       current_struct = 0;
       term_type = 0;
/* select from the first structure (cheat the selection list) */
      slong = select_list(text1,text2,text3,sel_list);
        current_struct = save1;
        term_type = save2;
      }

      if(slong > 0) {

     imax = -1;
     imin = -1;
     vmax =  0.0;
     vmin =  1.e+20;

      ipush = mliste[0]; /* start from the end of first list */
      sprintf(OutText,"Number of atoms in the selection list: %d ",slong);
      PrintMessage(OutText);
      for(i = 0 ; i < slong ; i++) {

      j  = sel_list[i];
      jj = j + ipush;

/* that the peek is allowed */
      if(jj >= mliste[1]) {
        PrintMessage("?ERROR - you peeked through your second atom list ");
        free(sel_list);
        return;}

      temp1 += x[j] - x[jj];
       temp2 += y[j] - y[jj];
        temp3 += z[j] - z[jj];
      
      mmass += 1.;
      }
      temp1 /= mmass;
      temp2 /= mmass;
      temp3 /= mmass;

      sprintf(OutText,"Translation: x '%f' y '%f' z '%f'",
             temp1 ,temp2 ,temp3 );
      PrintMessage(OutText);


      for(i = mlists[1] ; i < mliste[1] ; i++) {

         x[i] += temp1;
         y[i] += temp2;
         z[i] += temp3;}

      deno = mmass;
      mmass = 0.0;
      for(j = 0 ; j < slong ; j++) {
       i = sel_list[j];
       jj= i + ipush;
       temp1 = (x[i] - x[jj]);
        temp2 = (y[i] - y[jj]);
         temp3 = (z[i] - z[jj]);
       temp = temp1*temp1 + temp2*temp2 + temp3*temp3; 

      if(temp < vmin) {
                      vmin = temp;
                      imin = i;}
      if(temp > vmax) {
                      vmax = temp;
                      imax = i;}
       mmass += temp;
       }

       sprintf(OutText,"RMS ( = sqrt(a/b)) where a: %f  b: %f\nand RMS: %f",
               mmass,deno,sqrt(mmass/deno));
       PrintMessage(OutText);
       printf("Max. diff (atom '");
       print_names(imax);
       printf("') %f\n",sqrt(vmax));

       printf("Min. diff (atom '");
       print_names(imin);
       printf("'): %f\n",sqrt(vmin));
      }
      else
      PrintMessage("?ERROR - no atoms in the selection list ");

      free(sel_list);

}       

/************************************************************************/
ms_fluctuation(text1,text2,text3,text4,text5,text6) /*  calculate mean square fluctuation */
     char *text1; /* segment name */
     char *text2; /* residue name */
     char *text3; /* atom name    */
     char *text4; /* first frame */
     char *text5; /* last frame */
     char *text6; /* step frame */
/************************************************************************/
{
     extern int *ivector();
     extern float *vector();

     static float *tx,*ty,*tz; /* save coordinates */
     static float *mx,*my,*mz; /* average coordinate set */
     static float msfx,msfx2,msfy,msfy2,msfz,msfz2;
     static float fhelp;
     static int i,j,jj,retv;
     static int atom_max;
     static int slong;
     static int *sel_list;
     static int imax,imin,jmax,jmin;
     static float vmax,vmin;
     static float vx2,vy2,vz2;
     static int FirstF,LastF,StepF;

     char OutText[BUFF_LEN];

     if(text4[0] != '\0') {
        FirstF    = atoi(text4);
        LastF     = atoi(text5);
        StepF     = atoi(text6);
        if(StepF < 1) StepF = 1;

/* check the boundaries */
        if(check_frame_region(&FirstF,&LastF,&StepF)) return;}
      else {
        FirstF    = TrajectoryFirstFrame();
        LastF     = TrajectoryLastFrame();
        StepF     = TrajectoryStepFrame();
      }

/* check that there is a file connected */

     if(trajectory_info.traj_file[0] == '\0') {
       PrintMessage("?ERROR - no trajectory file is defined ");
       return;}

     if(trajectory_info.natom != mliste[0]) {
       PrintMessage("?ERROR - number of atoms defined is not the same as that in md file");
       return;}

     sprintf(OutText,"First frame: %d, Last frame: %d, Step frame: %d",FirstF,LastF,StepF);
     PrintMessage(OutText);

     atom_max = atom_list_max();

     sel_list = ivector(atom_max);

     slong = select_list(text1,text2,text3,sel_list);

     if(slong > 0) { 

     imax = -1;
     jmax = -1;
     imin = -1;
     jmin = -1;
     vmax =  0.0;
     vmin =  1.e+20;

/* save coordinates */
        tx = vector(atom_max);
         ty = vector(atom_max);
          tz = vector(atom_max);

        for(i = 0 ; i < mliste[0] ; i++) {
           tx[i] = x[i];
            ty[i] = y[i];
             tz[i] = z[i];}

/* first calculate average structure */

       if(traj_av_structure()) {
         free(tx); /* free the scratch space */
          free(ty);
           free(tz);
            return;}

/* reserve space for it */
        mx = vector(atom_max);
         my = vector(atom_max);
          mz = vector(atom_max);
/* save it           */
        for(i = 0 ; i < mliste[0] ; i++) {
           mx[i] = x[i];
            my[i] = y[i];
             mz[i] = z[i];}


/* open trajectory file */

        charmm_oc = fopen(trajectory_info.traj_file,"r");
        if(charmm_oc == NULL) {
        sprintf(OutText,">>> Can't open input file: '%s'",trajectory_info.traj_file);
        PrintMessage(OutText);
        check_if_fatal(1);
         free(tx); /* free the scratch space */
          free(ty);free(tz);
          free(mx);free(my);free(mz);
        return; }


/* loop through the conformations */

   msfx2 = 0.0;
    msfy2 = 0.0;
     msfz2 = 0.0;

   fhelp = 0.0;

   for(i = FirstF - 1 ; i < LastF ; i += StepF) {  /* frames         */

      mlist_deep     = 0;
      current_struct = 0;
      retv = rtraj_frame(i);         /* read trajectory into x,y and z */
      if(retv < 0) {
        fclose(charmm_oc);
         free(tx); /* free the scratch space */
          free(ty);free(tz);
          free(mx);free(my);free(mz);
        return;}
      rewind(charmm_oc);

      fhelp += 1.0;

      for(j = 0 ; j < slong ; j++) {  /* atoms */
      jj = sel_list[j];
      msfx     = (mx[jj] - x[jj] + sumx);
      vx2      = msfx*msfx;
      msfx2   += vx2;
       msfy    = (my[jj] - y[jj] + sumy);
       vy2     = msfy*msfy;
       msfy2  += vy2;
        msfz   = (mz[jj] - z[jj] + sumz);
        vz2    = msfz*msfz; 
        msfz2 += vz2; 

      vx2 = vx2 + vy2 + vz2;

      if(vx2 < vmin) {
                      vmin = vx2;
                      imin = i + 1;
                      jmin = jj + 1;}
      if(vx2 > vmax) {
                      vmax = vx2;
                      imax = i + 1;
                      jmax = jj + 1;}
       }}

  msfx2 /= (fhelp * (float)slong);
  msfy2 /= (fhelp * (float)slong);
  msfz2 /= (fhelp * (float)slong);

/*        printf("By definition msfx >= msfy >= msfz\n"); */

        PrintMessage(" ... A1 ...");

        PrintMessage(" A1x = [ msfx2 / 0.5*{msfy2+msfz2}]**0.5 - 1.0");
        sprintf(OutText," A1x = %f",(sqrt(msfx2 /(0.5*(msfy2+msfz2))) - 1.0));
        PrintMessage(OutText);

        PrintMessage(" A1y = [ msfy2 / 0.5*{msfx2+msfz2}]**0.5 - 1.0");
        sprintf(OutText," A1y = %f",(sqrt(msfy2 /(0.5*(msfx2+msfz2))) - 1.0)); 
        PrintMessage(OutText);

        PrintMessage(" A1z = [ msfz2 / 0.5*{msfx2+msfy2}]**0.5 - 1.0");
        sprintf(OutText," A1z = %f",(sqrt(msfz2 /(0.5*(msfx2+msfy2))) - 1.0));
        PrintMessage(OutText);

        PrintMessage(" ... A2 ...");

        PrintMessage(" A2y-z = [ msfy2 / 0.5*{msfy2+msfz2}]**0.5 - 1.0");
        sprintf(OutText," A2y-z = %f",(sqrt(msfy2 /(0.5*(msfy2+msfz2))) - 1.0));
        PrintMessage(OutText);

        PrintMessage(" A2x-z = [ msfx2 / 0.5*{msfx2+msfz2}]**0.5 - 1.0");
        sprintf(OutText," A2x-z = %f",(sqrt(msfx2 /(0.5*(msfx2+msfz2))) - 1.0)); 
        PrintMessage(OutText);

        PrintMessage(" A2x-y = [ msfx2 / 0.5*{msfx2+msfy2}]**0.5 - 1.0");
        sprintf(OutText," A2x-y = %f",(sqrt(msfx2 /(0.5*(msfx2+msfy2))) - 1.0));
        PrintMessage(OutText);

        PrintMessage(" ");

  sprintf(OutText," MSF2 - x: %f",msfx2);
  PrintMessage(OutText);
  sprintf(OutText," MSF2 - y: %f",msfy2);
  PrintMessage(OutText);
  sprintf(OutText," MSF2 - z: %f",msfz2);
  PrintMessage(OutText);

  sprintf(OutText," Max. total msf2 value for frame '%d'(atom '%d') : %f",imax,jmax,vmax);
  PrintMessage(OutText);
  printf(" Atom ('%d') = ",jmax); print_names(jmax - 1);printf("\n");
  sprintf(OutText," Min. total msf2 value for frame '%d'(atom '%d') : %f",imin,jmin,vmin);
  PrintMessage(OutText);
  printf(" Atom ('%d') = ",jmin); print_names(jmin - 1);printf("\n");

/* put coordinates back */
        for(i = 0 ; i < mliste[0] ; i++) { 
           x[i] = tx[i];
            y[i] = ty[i];
             z[i] = tz[i];}


   free(tx); /* free the scratch space */
    free(ty);
     free(tz);
   free(mx);
    free(my);
     free(mz);
   free(sel_list);

   fclose(charmm_oc);}
   else {
   PrintMessage("?ERROR - no atoms in the selection list ");
   return;}

}

/************************************************************************/
int check_if_cross(text)   /* on return = 0 include cross terms     */
         char *text;       /*           > 0 include not cross terms */
/************************************************************************/
{
      if(text[0] == '\0') return(0);
      toller(text);
      if(indexo(text,"nocr") == 1) return(1);

      return(0);
}

/***********************************************************************/
BuildPairArray(dist_len,dist_vec)

    int *dist_len,*dist_vec;
/***********************************************************************/
{
      extern int *atm_type;
      extern float *atm_charge;

     register int oldx,oldy;
     register short dx,dy;

      static long xsiz,ysiz,xo,yo;
      static int DisplayFlag,i,j;
      static int pick_p,pick_num,repeat;
      static float xx,yy,xtr,ytr;
      static float ddx,ddy,tmp1,tmp2;
      float diffs;
      char text[BUFF_LEN];
      float RotT[4][4];

#ifdef sgi

      switch(yes_no_graph) {

      case 0: /* graphics is turned off */
              select_dist_arr(dist_len,dist_vec);
              break;

      case 1: /* pick your selection list with mouse */

      diffs = far - near;

      PICK_READY();
  
      PrintMessage(" >>>>>> PRESS e-key to return from Pair builder <<<<<< ");

      text_port = 1;  /* display text from now */

      strncpy(bottom_line,"Pick two atoms for a pair",PORTchar);

      going_on();

      *dist_len = 0;

      pick_p=0;   /* reset the pick */
      repeat = mliste[mlist_deep - 1] + 1;

      while(1) {

      DisplayFlag = 0;

        while(qtest()) {

          dev=qread(&val);

          switch(dev) {              /* main switch board */

                      case ESCKEY:
                        shut_down(0); 

		      case EKEY: 
                        qreset();
                        text_port = 0;
                        return; 

		      case REDRAW:
                        DisplayFlag = 1;
                        reshapeviewport();
                        break;

		      case MENUBUTTON:
                       { menuval = dopup(identmenu);
                           switch( menuval) {
                           case 1:
                           text_port = 0;
                            qreset();
                           return;break;
                           case 2:
                           shut_down(0);
                           case 3:
                           if(text_port ==0) text_port = 1;
                           else
                           text_port =0;
                           DisplayFlag = 1;
                           break;}}
                        break;

/* track MOUSEX                         */
		      case MOUSEX:
                        oldx=xval;
                         xval=val;
                          dx= oldx-xval;
                      
                       if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
                        ddx=Rabs((float) xval/((float) oldx));
                        DisplayFlag = 0;
                        scale(ddx , ddx , ddx);
                        qreset();
                        bang_it(); break;}

		        if(getbutton(LEFTMOUSE)) {
                          ROTATE( -dx ,'y');
                           DisplayFlag = 1;}

                        if(getbutton(MIDDLEMOUSE)) {
                          ROTATE( dx , 'z');
                           DisplayFlag = 1;}
                       break;

/* track MOUSEY                         */
		      case MOUSEY:
                        oldy=yval;
                         yval=val;
                          dy= oldy-yval;

                        if(getbutton(LEFTMOUSE) && getbutton(MIDDLEMOUSE)) {
                         ddy=Rabs((float) yval/((float) oldy));
                         DisplayFlag = 0;
                         scale(ddy , ddy , ddy);
                         qreset();
                         bang_it(); break;}

		         if(getbutton(LEFTMOUSE)) {
                           ROTATE(  dy ,'x');
                            DisplayFlag = 1;}

		         if(getbutton(MIDDLEMOUSE)) {
                           ROTATE( dy , 'z');
                            DisplayFlag = 1;}
                       break;

		    case LEFTMOUSE:
                       { if(!val) break;
                          xc=getvaluator(MOUSEX);
                          yc=getvaluator(MOUSEY);
            
                          getmatrix(xycoor);
                           mmode(MPROJECTION); 
                            getmatrix(RotT);
                             multmatrix(xycoor);
                            getmatrix(xycoor);
                           loadmatrix(RotT);
                           mmode(MVIEWING);

                         /* Reset queue                              */
                          qreset();

                          getsize(&xsiz,&ysiz);
                          getorigin(&xo,&yo);

            xx=near + diffs*((float)(xc+1-xo)/ (float) xsiz);
            yy=near + diffs*((float)(yc+1-yo)/ (float) ysiz);


            for( j = 0 ; j < mlist_deep ; j++) {
            for( i = mlists[j] ; i < mliste[j] ; i++) {
    
/* don't count undisplayed atoms (disp_list[i] = 0)      */
            if(disp_list[i] == 0) continue;

     xtr= 0.5 * diffs * (xycoor[0][0]*x[i]+xycoor[1][0]*y[i]+
          xycoor[2][0]*z[i]+xycoor[3][0]-rotB[3][0]);
     ytr= 0.5 * diffs * (xycoor[0][1]*x[i]+xycoor[1][1]*y[i]+
          xycoor[2][1]*z[i]+xycoor[3][1]-rotB[3][1]);

           tmp1 = (xx-xtr);
           tmp2 = (yy-ytr);

             if((tmp1 * tmp1 + tmp2 * tmp2) < HitSphere2 ) {

             if( i == repeat) break;
             repeat = i;
             sprintf(text," (%d:%.4s:%.4s)(%d)",i+1,atnam+4*i,resnam+(4*i),(j+1));
             printf("\007\n");
             PrintMessage(text);

             DisplayFlag = 1;

             if(!pick_p) { pick_num=i ; pick_p++ ; goto PickExit;}

             sprintf(text,"Pair %d_%.4s:%.4s- %d_%.4s:%.4s ",
                                                        res1[pick_num],
                                                      atnam+4*pick_num,
                                                     resnam+4*pick_num,
                                                               res1[i],
                                                             atnam+4*i,
                                                            resnam+4*i);

             PrintMessage(text);

/* fill distance vector  */

            if((*dist_len + 2) >= MAXdlen) {
            printf("\07\07\n");
            PrintMessage(" ****** ERROR too many distances defined ***** ");
            return;}

            dist_vec[*dist_len] = pick_num;
            dist_vec[(*dist_len)+1] = i;
            *dist_len = (*dist_len) + 2;

            text_port = 0;
            qreset();
            return;
/*             pick_p=0; break; */

	   }}}
PickExit:;
		       }
            break;
		      }
	  } 
            if(DisplayFlag) {
              DisplayFlag = 0;
              bang_it();}
    }

    }
#else
              select_dist_arr(dist_len,dist_vec);
#endif
}

/************************************************************************/
int calculate_rdf(text1,text2,text3,text4,text5,text6,text7,Rcut,Nbin,
                                                            BoxL1,BoxL2,BoxL3)
                     /* calculate rdf  */
     char *text1;
     char *text2;
     char *text3;
     char *text4;
     char *text5;
     char *text6;
     char *text7;
     float Rcut;
     int   Nbin;
     float BoxL1;
     float BoxL2;
     float BoxL3;

/************************************************************************/
{


      static int *sel_list;
      static int slong,atom_max;
      static float CMASSx;
      static float CMASSy;
      static float CMASSz;

      char OutText[BUFF_LEN];

      if(BoxL1 < 0.1 || BoxL2 < 0.1 || BoxL3 < 0.1) {
        sprintf(OutText,"?ERROR - box dimensions too small (%f * %f * %f)",
                BoxL1 , BoxL2 , BoxL3);
        PrintMessage(OutText);
        return(1);}

        if(!strncasecmp(text1,"cmas",4)) {   /* calculate from centre of mass */

          if(Rcut < 0.01) Rcut = 10.;

      sprintf(OutText,"Rcut =  %f, BoxL =  %g * %g * %g, Nbin =  %d \n",
              Rcut,BoxL1,BoxL2,BoxL3,Nbin);
      PrintMessage(OutText);

      (void) calc_cmass_gen(text2  , text3   , text4 ,
                         &CMASSx, &CMASSy , &CMASSz);

      cmass_rdf(CMASSx , CMASSy , CMASSz , 
                BoxL1 , BoxL2 , BoxL3 , Rcut   , Nbin , text6 , text6 , text7);

      return(0); }    /* job done */

      atom_max = atom_list_max();      

      sel_list  = ivector(atom_max);

/* select from the first structure (cheat the selection list) */
      slong  = select_list(text1,text2,text3,sel_list );

      if(slong > 0) {

      if(Rcut < 0.01) Rcut = 10.;

      sprintf(OutText,"Rcut =  %f, BoxL =  %g * %g * %g, Nbin =  %d \n",
              Rcut,BoxL1,BoxL2,BoxL3,Nbin);
      PrintMessage(OutText);

      rdf(sel_list , slong , 
          BoxL1 , BoxL2 ,BoxL3 , Rcut , Nbin , text4 , text5 , text6);
      }
      else
      PrintMessage("?ERROR - no atoms in the selection list ");

      free(sel_list);

      return(0);
}       

/************************************************************************/
CalcMeanRDF()
/************************************************************************/
{
     int i;
     float RDFsets;
     char OutText[BUFF_LEN];

   if(!RaDiFu.Set || !RaDiFu.Numbers) {
     PrintMessage("?ERROR - no rdf defined ");
     return;}

   if(RaDiFu.Set && RaDiFu.Mean) {
     PrintMessage("?ERROR - the average value is already calculated");
     return;}

   PrintMessage("Calculating the average values for the RDF");
   sprintf(OutText,"Number of sets: %d",RaDiFu.Set);
   PrintMessage(OutText);   

   RDFsets = (float)(RaDiFu.Set);

   for(i = 0 ; i < RaDiFu.Numbers ; i++) 
                RaDiFu.YValues[i] /= RDFsets;


   RaDiFu.Mean = 1;  /* it's  done now */
}
/************************************************************************/
int DeleteRDF()
/************************************************************************/
{
     if(!RaDiFu.Set) {
                      return(1);}
     RaDiFu.Set     = 0;
     RaDiFu.Numbers = 0;
     RaDiFu.Plot    = 0;
     RaDiFu.Mean    = 0;   
     if(RaDiFu.Numbers) {
       free(RaDiFu.XValues);
       free(RaDiFu.YValues);}

     return(0);
}

/************************************************************************/
Show_round_atoms(alt)
     int alt;
/************************************************************************/
{

     static int i,j;
     static int *sel_list;
     static int *already_in_list;
     static int slong;
     static float rad;
     static float xcm,ycm,zcm;
     static char chelp[BUFF_LEN];
     static int ihelp;
     static int ihelp1,atom_list;

     ihelp = 0;     

     if(selection_mode == 0) 
       printf("Selecting by whole residues ...\n");
     if(selection_mode == 1)
       printf("Selecting by atoms ...\n");

     switch(alt) {

     case 1: /* given as x,y and z coordinates */

           Show_round_xyz(atof(parsed[3]),atof(parsed[4]),atof(parsed[5]),
                          atof(parsed[6]),
                               parsed[7] ,     parsed[8],      parsed[9]);
           break;

     case 2: /* given as res:seg:atom */

     atom_list = atom_list_max();

     sel_list        = ivector(atom_list);
     already_in_list = ivector(atom_list);

     slong = select_list(parsed[3],parsed[4],parsed[5],sel_list);

     if(slong > 0) {
     rad = atof(parsed[6]);
     if(rad < 0.001) {
      printf("?ERROR - search radius too small \n");
       free(sel_list);
        free(already_in_list);
         return;}

     ihelp1 = ihelp;

     for(j = mlists[0] ; j < mliste[mlist_deep - 1] ; j++)
         already_in_list[j] = 0;

     j = 0;
     for(i = 0 ; i < slong ; i++ ) {
           Show_round(i,sel_list,slong,rad,&j,
                      already_in_list,parsed[7],parsed[8],parsed[9]);
           }

     PrintMessage("Number of atoms in the set is :");
     sprintf(chelp,"  %d",j);
     PrintMessage(chelp);

     }
     else
     PrintMessage("?ERROR - no atoms in the selection list");

     free(sel_list);
      free(already_in_list);
     break;

     case 3:  /* select round centre of mass (select list can be used ) */     

     rad = atof(parsed[7]);
     if(rad < 0.001) {
     printf("?ERROR - search radius too small \n");
     return;}

     ihelp1 = calc_cmass_gen(parsed[4],parsed[5],parsed[6],&xcm,&ycm,&zcm);

     if(ihelp1 > 0) return;

     Show_round_xyz(xcm,ycm,zcm,rad,parsed[8],parsed[9],parsed[10]);

     break;

     case 4:  /* select round coordinate centre (select list can be used ) */     

     rad = atof(parsed[7]);
     if(rad < 0.001) {
     printf("?ERROR - search radius too small \n");
     return;}

     ihelp1 = calc_ccentre_gen(parsed[4],parsed[5],parsed[6],&xcm,&ycm,&zcm);

     if(ihelp1 > 0) return;

     Show_round_xyz(xcm,ycm,zcm,rad,parsed[8],parsed[9],parsed[10]);

     break;

     }
}
/*
       Calculate the periodic boundaries (turn in the loops outside
       the box)

       Leif Laaksonen 1992
*/
/************************************************************************/
int CalcPBound() 
/************************************************************************/
{

    int i;
    char OutText[BUFF_LEN];

    PrintMessage("** Preparing the periodic boundary conditions **");
    PrintMessage("Cell dimensions:");
    sprintf(OutText,"a: %f , b: %f , c: %f",cell.a,cell.b,cell.c);
    PrintMessage(OutText);
    sprintf(OutText,"Alpha: %f , Beta: %f , Gamma: %f",
            cell.alpha,cell.beta,cell.gamma);
    PrintMessage(OutText);
    sprintf(OutText,"Xtrans: %f , Ytrans: %f , Ztrans: %f",
            cell.Xtrans,cell.Ytrans,cell.Ztrans);
    PrintMessage(OutText);

    for(i = mlists[0] ; i < mliste[0] ; i++) {

/* do the x - test */
    x[i] = x[i] - cell.a * rint(x[i] / cell.a) + cell.Xtrans;
/* do the y - test */
    y[i] = y[i] - cell.b * rint(y[i] / cell.b) + cell.Ytrans;
/* do the z - test */
    z[i] = z[i] - cell.c * rint(z[i] / cell.c) + cell.Ztrans;
  }
}

/************************************************************************/
int SolveBoxSize(InText , Xbox , Ybox , Zbox)
    char  *InText;
    float *Xbox;
    float *Ybox;
    float *Zbox;
/************************************************************************/
{

    char BoxPar[MAXparse][MAXlinel];
    int  BoxI;

    own_parser(InText , BoxPar , &BoxI , SEP_BOX);

    if(BoxI < 1) {
      PrintMessage("?ERROR - error in box dimension parser");
      return(1);}

    *Xbox = atof(BoxPar[0]);

    if(BoxI == 3) {
     *Ybox = atof(BoxPar[1]);
      *Zbox = atof(BoxPar[2]);}

    if(BoxI == 2) {
     *Ybox = atof(BoxPar[1]);
      *Zbox = *Ybox;}

    if(BoxI == 1) {
     *Ybox = *Xbox;
      *Zbox = *Xbox;}

    if(BoxI > 3) {
      PrintMessage("?ERROR - too many box dimensions given (taking first 3)");
    }
    

    return(0);
}
/*
    This routine is written to be able to calculate the diffusion
    coefficient.

    The alghoritm uses the mean square displacements

    <r2> = 1/N sum([ri(t) - ri(0)]2

    lim <r2> = 6Dt + C
     t-> inf

    where D is the diffucion constant and C is a constant

    Leif Laaksonen 1993
*/

#define MAXdeg   10        /* maximum degree of polynom  (check from nreg.c)    */

/************************************************************************/
MeanSquareDisplacement(MASSCoord,text1,text2,text3,text4,text5,text6) 
                                 /*  calculate mean square displacement */
     int   MASSCoord;  /* if  = 0 calculate from atom positions
                             != 0 calculate from residue mass centre */
     char *text1; /* segment name */
     char *text2; /* residue name */
     char *text3; /* atom name    */
     char *text4; /* start frame number */
     char *text5; /* stop frame number  */
     char *text6; /* frame step         */
/************************************************************************/
{

     static float *tx,*ty,*tz;
     static float *txs,*tys,*tzs;
     static float msfx,msfy,msfz;
     static float *Xcalc,*Ycalc;
     static float fhelp;
     static int i,j,jj,retv;
     static int atom_max,loop;
     static int slong;
     static int *sel_list;
     static float vt2,vx2,vy2,vz2;
     static float cellaa,cellbb,cellcc;
     static int from_frame;
     static int to_frame;
     static int delta_frame;
     
     float RegCoeff[MAXdeg];
     char OutText[BUFF_LEN];

/* check limits */
        if(dynamics_frames < 1) {
        PrintMessage("?ERROR - number of frames is not defined ");
        return(1);}
   

     if(text4[0] != '\0') {
        from_frame    = atoi(text4);
        to_frame      = atoi(text5);
        delta_frame   = atoi(text6);
        if(delta_frame < 1) delta_frame = 1;

/* check the boundaries */
        if(check_frame_region(&from_frame,&to_frame,&delta_frame)) return;}
     else {
        from_frame    = TrajectoryFirstFrame();
        to_frame      = TrajectoryLastFrame();
        delta_frame   = TrajectoryStepFrame();
     }

      sprintf(OutText,
      "> Mean square displacement, first frame: %d , last frame: %d , step: %d",
      from_frame,to_frame,delta_frame);
      PrintMessage(OutText);
      if(MASSCoord)
         PrintMessage("Calculating from residue mass centre");
      else
         PrintMessage("Calculating from atom positions");

/* done ... */

     atom_max = atom_list_max();

     sel_list = ivector(atom_max);

     slong = select_list(text1,text2,text3,sel_list);

     if(slong > 0) { 

     sprintf(OutText,"Calculating rmd for a box: %g A x %g A x %g A",
              cell.a,cell.b,cell.c);
     PrintMessage(OutText);

     (void)MSDdataDefine(from_frame , to_frame , delta_frame);

/* check that there is a file connected */

     if(trajectory_info.traj_file[0] == '\0') {
       PrintMessage("?ERROR - no trajectory file is defined ");
       return(1);}

     if(trajectory_info.natom != mliste[0]) {
       PrintMessage("?ERROR - number of atoms defined is not the same as that in md file");
       return(1);}

/* save coordinates (major savings here) */
        txs = vector(atom_max);
         tys = vector(atom_max);
          tzs = vector(atom_max);
        for(i = 0 ; i < mliste[0] ; i++) {
           txs[i] = x[i];
            tys[i] = y[i];
             tzs[i] = z[i];}

/* open trajectory file */

        charmm_oc = fopen(trajectory_info.traj_file,"r");
        if(charmm_oc == NULL) {
        sprintf(OutText,">>> Can't open input file: '%s'",trajectory_info.traj_file);
        PrintMessage(OutText);
             free(sel_list);
              free(txs);
               free(tys);
                free(tzs);
        check_if_fatal(1);
        return(1); }

/* read first frame */
      mlist_deep     = 0;
      current_struct = 0;
      retv = rtraj_frame(from_frame - 1);     /* read trajectory into x,y and z */
      if(retv < 0) {
        fclose(charmm_oc);
             free(sel_list);
              free(txs);
               free(tys);
                free(tzs);
        return(1);}

/* time zero coordinates */
        tx = vector(atom_max);
         ty = vector(atom_max);
          tz = vector(atom_max);

        for(i = 0 ; i < mliste[0] ; i++) {
           tx[i] = x[i];
            ty[i] = y[i];
             tz[i] = z[i];}

    if(MASSCoord) {
     (void) SplitIntoResiduesList(sel_list,slong);
     if(CalcCMassList(tx,ty,tz,sel_list)) {
        free(sel_list);
         free(tx);
          free(ty);
           free(tz);
            free(txs);
             free(tys);
              free(tzs);
        fclose(charmm_oc);
     return(1);}
    }
      rewind(charmm_oc);

      i = (to_frame - from_frame + 1) / delta_frame;

      Xcalc = vector(i);
      Ycalc = vector(i);

      loop = 0;

/* loop through the conformations */
   cellaa = 1./cell.a;
    cellbb = 1./cell.b;
     cellcc = 1./cell.c;

   for(i = from_frame - 1 ; i < to_frame ; i += delta_frame) {  /* frames         */

      mlist_deep     = 0;
      current_struct = 0;
      retv = rtraj_frame(i);         /* read trajectory into x,y and z */
      if(retv < 0) {
        fclose(charmm_oc);
        FREE_ALL();
        return(1);}
      rewind(charmm_oc);

      vt2 = 0.0; 

    if(!MASSCoord) {     /* calculate msd from atoms */

      for(j = 0 ; j < slong ; j++) {  /* atoms */
      jj = sel_list[j];
      msfx     = (tx[jj] - x[jj]);
      msfx     = msfx  - cell.a * rint(cellaa * msfx);
      vx2      = msfx*msfx;
       msfy    = (ty[jj] - y[jj]);
       msfy    = msfy  - cell.b * rint(cellbb * msfy);
       vy2     = msfy*msfy;
        msfz   = (tz[jj] - z[jj]);
        msfz   = msfz  - cell.c * rint(cellcc * msfz);
        vz2    = msfz*msfz; 

      vt2 += vx2 + vy2 + vz2;

    }

      vt2 /= (float)slong;
   }
    else {          /* from residue mass centre */

     (void) CalcCMassList(x,y,z,sel_list);

      for(j = 0 ; j < ResSplitList.Levels ; j++) { 
      msfx     = (tx[j] - x[j]);
      msfx     = msfx  - cell.a * rint(cellaa * msfx);
      vx2      = msfx*msfx;
       msfy    = (ty[j] - y[j]);
       msfy    = msfy  - cell.b * rint(cellbb * msfy);
       vy2     = msfy*msfy;
        msfz   = (tz[j] - z[j]);
        msfz   = msfz  - cell.c * rint(cellcc * msfz);
        vz2    = msfz*msfz; 

      vt2 += vx2 + vy2 + vz2;

    }

      vt2 /= (float)ResSplitList.Levels;
   }

      (void)MSDdataFill(loop , vt2);

      Ycalc[loop] = vt2;
      if(trajectory_info.time_bw_steps) 
         Xcalc[loop] = (float)(loop * trajectory_info.time_bw_steps * delta_frame);
      else
         Xcalc[loop] = (float)loop;

      loop++;

    }


/*  for(i = 0 ; i < loop - 2 ; i++) */ 
  if(MASSCoord) {
    sprintf(OutText,"Number of center of mass points: %d",GetNumResiduesList());
  }
  else {
    sprintf(OutText,"Number of particles: %d",slong);
  }
  PrintMessage(OutText);

  i = 0;
  (void) nreg((Xcalc-1+i) , (Ycalc-1+i) , 
              (to_frame - from_frame + 1) / delta_frame , 1 , RegCoeff);

  if(trajectory_info.time_bw_steps) {
     sprintf(OutText,"Fitted line: a0 = %f , a1 = %f",RegCoeff[0],RegCoeff[1]);
     PrintMessage(OutText); 

      fhelp = 0.1 * RegCoeff[1] / 6.0;
      sprintf(OutText,"Diffusion coefficient: %.4e cm2/s",fhelp);
      PrintMessage(OutText);
  }
  else {
     PrintMessage("?WARNING - can't calculate diffusion coefficient");
     PrintMessage("           trajectory timing is missing");
     PrintMessage(" ** X-axis values are just running numbers, not the right time **");
     sprintf(OutText,"Fitted line: a0 = %f , a1 = %f",RegCoeff[0],RegCoeff[1]);
     PrintMessage(OutText); 
   }

/* put coordinates back */
        for(i = 0 ; i < mliste[0] ; i++) { 
           x[i] = txs[i];
            y[i] = tys[i];
             z[i] = tzs[i];}

       FREE_ALL();

   fclose(charmm_oc);}
   else {
   PrintMessage("?ERROR - no atoms in the selection list ");
   return(0);}

   return(0);
}
/*
     on return
     1:    Structure is set
     0:    Structure is not set
*/
/************************************************************************/
MSDdataSet()
/************************************************************************/
{
   if(MSDdata.Stop > 0) return(1);

   return(0);
 }
/************************************************************************/
MSDdataDelete()
/************************************************************************/
{
    if(MSDdataSet) {
       free(MSDdata.MSDarray);
            MSDdata.Start = 0;
            MSDdata.Stop  = 0;
            MSDdata.Step  = 0;}

     return(0);
}
/************************************************************************/
MSDdataDefine(Start,Stop,Step)
     int Start;
     int Stop;
     int Step;
/************************************************************************/
{
     int GetNum;

     if(MSDdataSet())
        (void)MSDdataDelete();

     MSDdata.Start = Start;
     MSDdata.Stop  = Stop;
     MSDdata.Step  = Step;

     GetNum = (Stop - Start + 1)/Step;

     if(GetNum < 1) {
        (void)MSDdataDelete();
         return(1);}

     MSDdata.MSDarray = vector(GetNum);

     return(0);
}
/************************************************************************/
MSDdataWrite(FileName)
    char *FileName;
/************************************************************************/
{
     FILE *write_p;
     int i,j;
     char OutText[BUFF_LEN];

     if(!MSDdataSet()) {
        PrintMessage("?ERROR - no array for the mean square displacement defined");
         return(1);}

     if(FileName[0] == '?') {
       PrintMessage("?ERROR - file name can't contain '?' ");
       return(1);}

     write_p = fopen(FileName,"w");
     if(write_p == NULL) {
       sprintf(OutText,"?ERROR - unable to open file : '%s' ",FileName);
       PrintMessage(OutText);
        return(1);}

/* ready to write now ... */
     sprintf(OutText,"Writing mean square displacement to file '%s' on disk",FileName);
     PrintMessage(OutText);

     for(i = 0 ; i < (MSDdata.Stop - MSDdata.Start + 1)/MSDdata.Step ; i++) {
      if(trajectory_info.time_bw_steps) 
       j = i * trajectory_info.time_bw_steps * MSDdata.Step;
      else
       j = i;
       fprintf(write_p," %d %f \n",j,MSDdata.MSDarray[i]);}

     fclose(write_p);
     PrintMessage("Done...");

     return(0);
}

/*
       WARNING !!!!!!!!!!

       No index checking, be aware!!!
*/
/************************************************************************/
MSDdataFill(Indx , Value)
       int   Indx;
       float Value;
/************************************************************************/
{
       MSDdata.MSDarray[Indx] = Value;

       return(0);
}
/************************************************************************/
int SplitIntoResiduesList(List,ListLong)
     int  *List;
     int   ListLong;
/************************************************************************/
{
     int i,j;
     int ListH;
     int Level;

     ListH                = res1[0];
     Level                = 0;
     ResSplitList.Hits[0]    = 1;
     ResSplitList.Levels     = 1;

     if(ListLong < 2) return(0);

     for(i = 1 ; i < ListLong ; i++) {

      j =  res1[List[i]];

        if(ListH == j) {
          ResSplitList.Hits[Level]++;
	  }
        else {
          Level++;
          if(Level == MAX_DIFF_RES) {
           PrintMessage("?ERROR - MAX_DIFF_RES list is too small");
           return(1);}
          ListH                    = j;
          ResSplitList.Hits[Level] = 1;
        }
      }

          ResSplitList.Levels = Level;

          if(Level < 2) 
               PrintMessage("?WARNING - only one residue type found");

          return(0);
}
/************************************************************************/
CalcCMassList(tx,ty,tz,sel_list)
     float *tx;
     float *ty;
     float *tz;
     int   *sel_list;
/************************************************************************/
{

     int Istart = 0;
     int Loop1  = 0;
     int Loop2  = 0;
     int i,j,jj;
     float fhelp,Tmass;

     for(j = 0 ; j < ResSplitList.Levels ; j++) {

      Tmass = 0.0;

      for(i = Istart ; i < ResSplitList.Hits[j] + Istart ; i++) {
      jj = sel_list[Loop2];
      fhelp = find_mass(atm_type[jj]);

      tx[Loop1] += x[jj] * fhelp;
       ty[Loop1] += y[jj] * fhelp;
        tz[Loop1] += z[jj] * fhelp;

      Tmass += fhelp;
      Loop2++;
      }
      tx[Loop1] /= Tmass;
       ty[Loop1] /= Tmass;
        tz[Loop1] /= Tmass;

      if(Tmass < 1.e-05) {
         PrintMessage("?ERROR - atom masses not defined");
         return(1);}

      Istart += ResSplitList.Hits[j];
      Loop1++;
      }
      return(0);
}
/************************************************************************/
int GetNumCorrObs()
/************************************************************************/
{
    return(corr_info.corr_obs);
}
/************************************************************************/
float *GetCorrVec()
/************************************************************************/
{
    return(corr_info.corr_val);
}
/************************************************************************/
int GetMSDObs()
/************************************************************************/
{
    return((MSDdata.Stop - MSDdata.Start + 1)/MSDdata.Step);
}
/************************************************************************/
float *GetMSDVec()
/************************************************************************/
{
    return(MSDdata.MSDarray);
}
/************************************************************************/
int GetNumResiduesList()
/************************************************************************/
{
          return(ResSplitList.Levels);
}
/************************************************************************/
float *GetDynamVec(PIndex)
       int PIndex;
/************************************************************************/
{
       return(play_dynam_frames.obs_vec + ((PIndex - 1) * play_dynam_frames.numset));
}
/************************************************************************/
int     GetNumDynamVec()
/************************************************************************/
{
        return(play_dynam_frames.numset);
}
/*

   (rms fluct)i =  SQRT(<dRi**2>)

    dRi**2 = (xi - <xi>)**2 + (yi - <yi>)**2 + (zi - <zi>)**2

  where xi,yi,zi are cartesian coordinates of atom i,
  x - <x>, ...etc. are the displacements from the average positions,
  <...> denotes averaging over the trajectory

  Leif Laaksonen, CSC, 1993

*/
/************************************************************************/
int RMS_Fluctuation(What , text1,text2,text3,text4,text5,text6) 
                                  /*  calculate mean square fluctuation */
     int   What;  /* == 0 , no fitting , != 0 , fitting */
     char *text1; /* segment name */
     char *text2; /* residue name */
     char *text3; /* atom name    */
     char *text4; /* first frame */
     char *text5; /* last frame */
     char *text6; /* step frame */
/************************************************************************/
{
     extern int *ivector();
     extern float *vector();

     static float *tx,*ty,*tz; /* save coordinates */
     static float *mx,*my,*mz; /* average coordinate set */
     static float msfx,*msfx2,msfy,*msfy2,msfz,*msfz2;
     static float fhelp;
     static int i,ii,j,jj,retv;
     static int atom_max;
     static int slong;
     static int *sel_list;
     static int FirstF,LastF,StepF;
     static char SaveT1[MAXlinel];
     static char SaveT2[MAXlinel];
     static char SaveT3[MAXlinel];

     char OutText[BUFF_LEN];


     if(text4[0] != '\0') {
        FirstF    = atoi(text4);
        LastF     = atoi(text5);
        StepF     = atoi(text6);
        if(StepF < 1) StepF = 1;

/* check the boundaries */
      if(check_frame_region(&FirstF,&LastF,&StepF)) return;}
     else {
        FirstF    = TrajectoryFirstFrame();
        LastF     = TrajectoryLastFrame();
        StepF     = TrajectoryStepFrame();
     }

/* check that there is a file connected */

     if(trajectory_info.traj_file[0] == '\0') {
       PrintMessage("?ERROR - no trajectory file is defined ");
       return;}

     if(trajectory_info.natom != mliste[0]) {
       PrintMessage("?ERROR - number of atoms defined is not the same as that in md file");
       return;}

     atom_max = atom_list_max();

     sel_list = ivector(atom_max);

     fake_now = 1;
     strncpy(SaveT1,text1,MAXlinel);
      strncpy(SaveT2,text2,MAXlinel);
       strncpy(SaveT3,text3,MAXlinel);
     slong = select_list(text1,text2,text3,sel_list);
     fake_now = 0;

     if(slong > 0) { 

/* save coordinates */
        tx = vector(atom_max);
         ty = vector(atom_max);
          tz = vector(atom_max);

        for(i = 0 ; i < mliste[0] ; i++) {
           tx[i] = x[i];
            ty[i] = y[i];
             tz[i] = z[i];}

/* first calculate average structure */

       if(TrajAvStructure(FirstF,LastF,StepF)) {
         free(tx); /* free the scratch space */
          free(ty);
           free(tz);
            return;}

/* reserve space for it */
        mx = vector(atom_max);
         my = vector(atom_max);
          mz = vector(atom_max);
/* save it           */
        for(i = mlists[0] ; i < mliste[0] ; i++) {
           mx[i] = x[i];
            my[i] = y[i];
             mz[i] = z[i];}

/* open trajectory file */

        charmm_oc = fopen(trajectory_info.traj_file,"r");
        if(charmm_oc == NULL) {
        sprintf(OutText,">>> Can't open input file: '%s'",trajectory_info.traj_file);
        PrintMessage(OutText);
        check_if_fatal(1);
         free(tx); /* free the scratch space */
          free(ty);free(tz);
           free(mx);free(my);free(mz);
        return; }


        msfx2 = vector(slong);
        msfy2 = vector(slong);
        msfz2 = vector(slong);
        for(i = 0 ; i < slong ; i++) {
            msfx2[i] = msfy2[i] = msfz2[i] = 0.0;}

/* loop through the conformations */

   fhelp = 0.0;

   for(i = FirstF - 1 ; i < LastF ; i += StepF) {  /* frames         */

      mlist_deep     = 0;
      current_struct = 0;
      retv = rtraj_frame(i);         /* read trajectory into x,y and z */
      if(retv < 0) {
        fclose(charmm_oc);
        free(msfx2);free(msfy2);free(msfz2);
        free(tx); /* free the scratch space */
         free(ty);
          free(tz);
         free(mx);free(my);free(mz);
         free(msfx2);free(msfy2);free(msfz2);
          free(sel_list);
        return;}
      rewind(charmm_oc);

/* put up system and superimpose the two conformations */

        j = mliste[0]; /* start point */
        for(ii = mlists[0] ; ii < mliste[0] ; ii++) {
           x[ii + j]    =  x[ii] - sumx;
           x[ii]        = mx[ii];
            y[ii + j]   =  y[ii] - sumy;
            y[ii]       = my[ii];
             z[ii + j]  =  z[ii] - sumz;
             z[ii]      = mz[ii];}

        (void)update_mlist(mliste[0]);
        if(mlist_deep < 2) return;
        (void)AddNames();

       if(What) {
         if(calculate_quatfit(SaveT1,
                              SaveT2,
                              SaveT3,SaveT1,SaveT2,SaveT3,OFF) < 0.0) {
            PrintMessage("?ERROR: Can't complete QUATFIT");  
         /* put coordinates back */
          for(i = mlists[0] ; i < mliste[0] ; i++) { 
           x[i] = tx[i];
            y[i] = ty[i];
             z[i] = tz[i];}
          free(tx); /* free the scratch space */
          free(ty);free(tz);
          free(mx);free(my);free(mz);
          free(sel_list);
          free(msfx2);free(msfy2);free(msfz2);
          fclose(charmm_oc);
          mlist_deep = 1;
          return;}}

      fhelp += 1.0;

      ii = mliste[0];

      for(j = 0 ; j < slong ; j++) {  /* atoms */
      jj = sel_list[j];
      msfx       = (x[jj] - x[jj + ii]);
      msfx2[j]  += msfx*msfx;
       msfy       = (y[jj] - y[jj + ii]);
       msfy2[j]  += msfy*msfy;
        msfz       = (z[jj] - z[jj + ii]);
        msfz2[j]  += msfz*msfz; 

     }}

      for(j = 0 ; j < slong ; j++) {
      jj = sel_list[j];
       msfx2[j] /= fhelp;
       msfy2[j] /= fhelp;
       msfz2[j] /= fhelp;
       msfx = sqrt(msfx2[j] + msfy2[j] + msfz2[j]);
       sprintf(OutText,"(%d) RMS for %s: %f",(j+1),sprint_names(jj),msfx);
       PrintMessage(OutText);}

/* put coordinates back */
        for(i = mlists[0] ; i < mliste[0] ; i++) { 
           x[i] = tx[i];
            y[i] = ty[i];
             z[i] = tz[i];}


   free(tx); /* free the scratch space */
    free(ty);
     free(tz);
   free(mx);
    free(my);
     free(mz);
   free(sel_list);
   free(msfx2);free(msfy2);free(msfz2);

   fclose(charmm_oc);}
   else {
   PrintMessage("?ERROR - no atoms in the selection list ");
   return;}

}

/************************************************************************/
float calculate_quatfit(text1,text2,text3,
                        text4,text5,text6,
                         no_extra)   
    
     char *text1;
     char *text2;
     char *text3;
     char *text4;
     char *text5;
     char *text6;
     int   no_extra;
/************************************************************************/
{

      static int i,j,jj,ipush;
      static float temp,temp1,temp2,temp3;
      static float mmass,deno;
      static int *sel_list1;
      static int *sel_list2;
      static int slong1,slong2,save1,save2,atom_max;
      static float QuatFitValue;

      char OutText[BUFF_LEN];

      if(mlist_deep < 2) {
          PrintMessage("?ERROR - no molecules defined to be fitted");
          return(-1.0);}

      atom_max = atom_list_max();      

      sel_list1 = ivector(atom_max);
      sel_list2 = ivector(atom_max);

      temp1 = 0.0;
       temp2 = 0.0;
        temp3 = 0.0;
         mmass = 0.0;

      if(text1[0] == '\0') {
        for(i = mlists[0] ; i < mliste[0] ; i++) 
                                sel_list1[i] = i;
        j = 0;
        for(i = mlists[1] ; i < mliste[1] ; i++) {
                                sel_list2[j] = i;
                                j++;}
        slong1 = mliste[0];
        slong2 = mliste[1] - mlists[1];

       if(slong1 != slong2) {
        PrintMessage("?ERROR - number of atoms in list 1 and 2 must be equal");
         free(sel_list1);
         free(sel_list2);
        return(-1.0);}
      }
      else {
      save1 = current_struct;
      save2 = term_type;
      term_type = 0;
/* select from the first structure (cheat the selection list) */
      current_struct = 0;
      slong1 = select_list(text1,text2,text3,sel_list1);
      current_struct = 1;
      slong2 = select_list(text4,text5,text6,sel_list2);
        current_struct = 0;
        current_struct = save1;
        term_type = save2;
      }

       if(slong1 < 1) {
        PrintMessage("?ERROR - no atoms selected from list 1");
         free(sel_list1);
         free(sel_list2);
        return(-1.0);}

       if(slong2 < 1) {
        PrintMessage("?ERROR - no atoms selected from list 2");
         free(sel_list1);
         free(sel_list2);
        return(-1.0);}

       if(slong1 != slong2) {
        PrintMessage("?ERROR - number of atoms in list 1 and 2 must be equal");
         free(sel_list1);
         free(sel_list2);
        return(-1.0);}

      for(i = 0  ; i < slong2 ; i++) {
                                     sel_list2[i] -= mlists[1];}

      QuatFitValue = QuatFit(&x[0] ,         &y[0] ,          &z[0] ,
                              mliste[0] ,
                             &x[mlists[1]] , &y[mlists[1]] , &z[mlists[1]] ,
                             (mliste[1] - mlists[1]) ,
                              sel_list1 , slong1 ,
                              sel_list2 , slong2 ,
                              no_extra);

      free(sel_list1);
      free(sel_list2);

      return(QuatFitValue);
}       
/************************************************************************/
int CalcCluster(char *text1 , char *text2 , char *text3,
                char *text4 , char *text5 , char *text6)
/************************************************************************/
{
    int i,j;
    int iLoop,jLoop;
    int ihelp,jhelp;
    float Temp;
    float SaveSumx,SaveSumy,SaveSumz;
    char OutText[BUFF_LEN];

    if(dynamics_frames < 1) {
    PrintMessage("?ERROR - number of frames is not defined ");
    return(1);}

    if(traj_file_set == 0) {
    PrintMessage("?ERROR - no trajectory file name set \n");
    return(1);}

    if(text4[0] == '\0') {
       if(text1[0] != '\0')
        strncpy(text4,text1,BUFF_LEN);}
    if(text5[0] == '\0') {
       if(text2[0] != '\0')
        strncpy(text5,text2,BUFF_LEN);}
    if(text6[0] == '\0') {
       if(text3[0] != '\0')
        strncpy(text6,text3,BUFF_LEN);}

    sprintf(OutText,"Selection1: '%s' '%s' '%s' . Selection2: '%s' '%s' '%s'",
            text1,text2,text3,text4,text5,text6);
    PrintMessage(OutText);

    charmm_oc        = fopen(traj_file,"r");
    if(charmm_oc    == NULL) {
    sprintf(OutText,"?ERROR - can't open trajectory file : %s\n",traj_file);
    PrintMessage(OutText);
    check_if_fatal(1);
    return;}

    if(ClusterData.NumSets) /* delete old data */
                        (void)DeleteClusterData();

       ClusterData.NumSets = FramesInSet();

    (void)SaveCoordinates();

    SaveSumx = sumx;
    SaveSumy = sumy;
    SaveSumz = sumz;

    (void)GetClusterSpace(FramesInSet());

    iLoop = 0;

    for(i = TrajectoryFirstFrame() - 1 ; 
        i < TrajectoryLastFrame()  - TrajectoryStepFrame() ;
        i +=TrajectoryStepFrame()) {

        jLoop = iLoop + 1;

        for(j = i + TrajectoryFirstFrame() + TrajectoryStepFrame() - 1;
            j < TrajectoryLastFrame();
            j +=TrajectoryStepFrame()) {

        current_struct = 0;
        mlist_deep     = 0;

        if(get_frame(i , 0)) {
           PrintMessage("?ERROR - can't read first frame");
           fclose(charmm_oc);
           return(1);}
        rewind(charmm_oc);

        if(get_frame(j , 1)) {
           PrintMessage("?ERROR - can't read second frame");
           fclose(charmm_oc);
           return(1);}
        rewind(charmm_oc);

        (void)AddNames();

        Temp = calculate_quatfit(text1,text2,text3,text4,text5,text6,OFF);

        if(PutClusterData(iLoop , jLoop , &Temp)) {
           PrintMessage("?ERROR - can't save cluster data");
           return(1);};

        jLoop++;

	}
        iLoop++;}

    (void)GetSavedCoord();

    mlist_deep = 1;

    sumx = SaveSumx;
    sumy = SaveSumy;
    sumz = SaveSumz;

          fclose(charmm_oc);

          return(0);
}
/************************************************************************/
int DeleteClusterData()
/************************************************************************/
{
    if(ClusterData.NumSets) 
       free(ClusterData.DataArray);
    ClusterData.NumSets = 0;

    return(0);
}
/************************************************************************/
int GetClusterSpace(int Observ)
/************************************************************************/
{
    if(ClusterData.NumSets) {
      (void)DeleteClusterData();
    }

    ClusterData.DataArray = vector(Observ * (Observ - 1) / 2);

    ClusterData.NumSets   = Observ;

    return(0);
}
/************************************************************************/
int PutClusterData(int ip , int jp , float *Value)
/************************************************************************/
{
    int i;

    if(!ClusterData.NumSets) {
        PrintMessage("?ERROR - no space to put Cluster Data");
        return(1);}

    i = ip + jp * (jp - 1)/2 ;

    ClusterData.DataArray[i] = *Value;

    return(0);
}
