/*
   Main program for the spectrum package for the analysation of the
   main components in time series.

   Leif Laaksonen 1991
*/

#include <stdio.h>
#include <math.h>
#include <string.h>

#include "spectrum.h"

   char *usage = 
"   \n\
     spectrum -ffile.name -dinumber \n\
    \n\
             -f defines the input file name \n\
             -d defines the multiple with which every sample will be\n\
                played\n";

/***************************************************************************/
main(argc,argv)
     int    argc;
     char  *argv[];
/***************************************************************************/
{
   int i;

   if(argc > 1) {
     for(i = 1 ; i < argc ; i++) {
          
        if(argv[i][0] == '-') {

        switch(argv[i][1]) {

	case 'f':
                 strncpy(FileName,&argv[i][2],BUFF_LEN);
                 printf("*** Input file is '%s' *****\n",FileName);
                 break;
        case 'd':
                 TempBuffLen = atoi(&argv[i][2]);
                 if(TempBuffLen < 1) {
                   PrintMessage("Buffer value has to be > 0");
                   exit(1);}
                 break;
         default:
                 PrintMessage("?ERROR - unknown option");
                 exit(1);}
      }}}
    else {
      printf("%s\n",usage);
      exit(0);}

/* prepare graphics (if there is any) */
   if((ErrorTrap.ErrorCode = PrepareGraphics())) exit(1);

/* go and do the job                  */
   if((ErrorTrap.ErrorCode = DoTheJob())) exit(1);
   
}
/***************************************************************************/
DoTheJob()
/***************************************************************************/
{
   int i;
   int Lines;

   float *Data;


   if(FileName[0] == '\0') {
     printf("?Error - input file name not defined \n");
     exit(1);}

   PFile = fopen(FileName,"r");
           if(PFile == NULL) {
              printf("?ERROR - can't open input file '%s'\n",FileName);
              exit(1);}

   Lines = LinesInFile(PFile);

   printf("Number of lines: %d , value used: %d \n",Lines,2*check_pow_2(Lines/2));

   GoGetSpace(2 * check_pow_2(Lines/2));

   if(GetXYFile(PFile , Lines)) exit(1);

   if(CalcAver(Lines)) exit(1);

   Data = TimeSeries.YData;
  
   realft((Data-1),TimeSeries.Observ/2,1);

#ifdef DEBUG   
   for(i = 0 ; i < TimeSeries.Observ ; i++) {
   printf(" %d %f \n",(i+1),Data[i]);}
#endif

   if(PowSpec()) {
     PrintMessage("?ERROR in PowSpec");
     exit(1);}
}

