/*
 * text.c
 *
 * Forms Object class: TEXT
 *
 * Written by: Mark Overmars
 *
 * Version 2.0 a
 * Date: Nov 11, 1991
 */

#include "forms.h"

static int handle_text(FL_OBJECT *ob,int event,float mx,float my,char key)
/* Handles an event */
{
  switch (event)
  {
    case FL_DRAW:
	fl_drw_box(ob->boxtype,ob->x,ob->y,ob->w,ob->h,ob->col1,FL_TEXT_BW);
        fl_drw_text(ob->align,ob->x,ob->y,ob->w,ob->h,
			ob->lcol,ob->lsize,ob->lstyle,ob->label);
        break;
  }
  return 0;
}

/*------------------------------*/

FL_OBJECT *fl_create_text(int type,float x,float y,float w,float h,char label[])
/* creates an object */
{
  FL_OBJECT *ob;
  ob = fl_make_object(FL_TEXT,type,x,y,w,h,label,handle_text);
  ob->boxtype = FL_TEXT_BOXTYPE;
  ob->col1 = FL_TEXT_COL1;
  ob->col2 = FL_TEXT_COL1;
  ob->lcol = FL_TEXT_LCOL;
  ob->align = FL_TEXT_ALIGN;
  ob->active = 0;
  return ob;
}

FL_OBJECT *fl_add_text(int type, float x, float y, float w, float h, char label[])
/* Adds an object */
{
  FL_OBJECT *ob;
  ob = fl_create_text(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}
