/*
 * clock.c
 *
 * Forms Object class: CLOCK
 *
 * Written by: Mark Overmars (based on clock by Paul Haeberli)
 *
 * Version 2.1 a
 * Date: Sep 29, 1992
 */

#include "forms.h"

#include <malloc.h>
#include <sys/types.h>
#include <stdio.h>
#include <time.h>
#include <gl/gl.h>
#include <gl/device.h>

float hourhand[4][2] = { {-0.5,0.0},{0.0,-1.5},{0.5,0.0},{0.0,7.0}};
float  minhand[4][2] = { {-0.5,0.0},{0.0,-1.5},{0.5,0.0},{0.0,11.5}};
float  sechand[4][2] = { {-0.05,0.0},{0.0,-2.0},{0.05,0.0},{0.0,11.5}};

int hours,minutes,seconds;

static void showhands(int fillcolor,int bordercolor)
{
    pushmatrix();
        rotate(-(hours*3600/12)-(minutes*5),'z');
        fl_color(fillcolor); 
	polf2(4,hourhand);
        fl_color(bordercolor);
	poly2(4,hourhand);
    popmatrix();
    pushmatrix();
        rotate(-(minutes*3600/60)-(seconds),'z');	
        fl_color(fillcolor); 
	polf2(4,minhand);
        fl_color(bordercolor);
	poly2(4,minhand);
    popmatrix();
    pushmatrix();
        rotate(-seconds*3600/60,'z');
        fl_color(fillcolor); 
	polf2(4,sechand);
        fl_color(bordercolor);
	poly2(4,sechand);
    popmatrix();
    pnt(0.0,0.0,0.0);
}

static void draw_clock(int type,int col1,int col2)
{
  int i;
  pushmatrix();
    if (type == FL_ROUND_CLOCK)
    {
      fl_color(col1);  circf(0.0,0.0,14.0);
      fl_color(BLACK); circ(0.0,0.0,14.0);
    }
    pushmatrix();
      fl_color(52);
      for (i=0; i<12; i++)
      {
        if (i==0) rectf(-0.5,9.0,0.5,11.0);
        else if (i==3 || i==6 || i== 9) rectf(-0.5,9.5,0.5,10.5);
        else rectf(-0.25,9.5,0.25,10.5);
        rotate(-300,'z');
      }
    popmatrix();
    pushmatrix();
      translate(0.60,-0.60,0.0);
      showhands(34,34);
    popmatrix();
    showhands(col2,54);
  popmatrix();
} 

/*--------------------------------------*/

/* Object specific information. */

typedef struct {
  int sec;	/* Last number of seconds */
} SPEC;

static int handle_clock(FL_OBJECT *ob,int event,float mx,float my,char key)
{
  long clock;
  int c1;
  struct tm *timeofday;
  switch (event)
  {
    case FL_DRAW:
	if (ob->type == FL_ROUND_CLOCK) c1 =FL_CLOCK_TOPCOL; else c1 = ob->col1;
  	fl_drw_box(ob->boxtype,ob->x,ob->y,ob->w,ob->h,c1,FL_BOX_BW);
  	fl_drw_text_beside(ob->align,ob->x,ob->y,ob->w,ob->h,
				ob->lcol,ob->lsize,ob->lstyle,ob->label);
        pushmatrix();
    	translate(ob->x+ob->w/2.0 - 0.5,ob->y+ob->h/2.0 - 0.5,0.0);
        scale(ob->w/28.0,ob->h/28.0,1.0);
	if (ob->type == FL_ROUND_CLOCK && ob->boxtype != FL_NO_BOX)
	  scale(0.85,0.85,1.0);
	draw_clock(ob->type,ob->col1,ob->col2);
	popmatrix();
	return 0;
    case FL_STEP:
    	time(&clock);
    	timeofday = (struct tm *)localtime(&clock);
    	hours = timeofday->tm_hour;
    	minutes = timeofday->tm_min;
    	seconds = timeofday->tm_sec;
	if (((SPEC *)(ob->spec))->sec != seconds)
	{
	  ((SPEC *)(ob->spec))->sec = seconds;
	  fl_redraw_object(ob);
	}
	return 0;
    case FL_FREEMEM:
	free(ob->spec);
	return 0;
  }
  return 0;
}

/*--------------------------------------*/

FL_OBJECT *fl_create_clock(int type,float x,float y,float w,float h,char label[])
/* creates an object */
{
  FL_OBJECT *ob;
  ob = fl_make_object(FL_CLOCK,type,x,y,w,h,label,handle_clock);
  if (type == FL_ROUND_CLOCK)
    ob->boxtype = FL_NO_BOX;
  else
    ob->boxtype = FL_CLOCK_BOXTYPE;
  ob->col1 = FL_CLOCK_COL1;
  ob->col2 = FL_CLOCK_COL2;
  ob->lcol = FL_CLOCK_LCOL;
  ob->align = FL_CLOCK_ALIGN;

  ob->spec = (int *)(fl_malloc(sizeof(SPEC)));

  ob->active = 1;
  ob->automatic = 1;
  return ob;
}

FL_OBJECT *fl_add_clock(int type, float x, float y, float w, float h, char label[])
/* Adds an object */
{
  FL_OBJECT *ob;
  ob = fl_create_clock(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}

void fl_get_clock(FL_OBJECT *ob,int *h,int *m,int *s)
/* returns the time */
{
  *h = hours;
  *m = minutes;
  *s = seconds;
}
