/*
 * box.c
 *
 * Forms Object class: BOX
 *
 * Written by: Mark Overmars
 *
 * Version 2.0 a
 * Date: Nov 11, 1991
 */

#include "forms.h"

static int handle_box(FL_OBJECT *ob, int event, float mx, float my, char key)
/* Handles an event */
{
  switch (event)
  {
    case FL_DRAW:
  	fl_drw_box(ob->boxtype,ob->x,ob->y,ob->w,ob->h,ob->col1,FL_BOX_BW);
  	fl_drw_text_beside(ob->align,ob->x,ob->y,ob->w,ob->h,
				ob->lcol,ob->lsize,ob->lstyle,ob->label);
        break;
  }
  return 0;
}

/*------------------------------*/

FL_OBJECT *fl_create_box(int type,float x,float y,float w,float h,char label[])
/* Creates an object */
{
  FL_OBJECT *ob;
  ob = fl_make_object(FL_BOX,type,x,y,w,h,label,handle_box);
  ob->boxtype = type;
  ob->col1 = FL_BOX_COL1;
  ob->col2 = FL_BOX_COL1;
  ob->lcol = FL_BOX_LCOL;
  ob->align = FL_BOX_ALIGN;
  ob->active = 0;
  return ob;
}

FL_OBJECT *fl_add_box(int type, float x, float y, float w, float h, char label[])
/* Adds an object */
{
  FL_OBJECT *ob;
  ob = fl_create_box(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}
