/*
 * bitmap.c
 *
 * Forms Object class: BITMAP
 *
 * Written by: Mark Overmars
 *
 * Version 2.1 a
 * Date: Sep 29, 1992
 */

#include <malloc.h>
#include <gl/gl.h>
#include "forms.h"

typedef struct {
int bits_w,bits_h;		/* width and height of bitmap */
char *bits;			/* pointer to the bitmap */
} SPEC;

static unsigned long thebits[FL_BITMAP_MAXSIZE];

static void draw_bitmap(FL_OBJECT *ob)
/* draws the bitmap */
{
  SPEC *sp = ((SPEC *)(ob->spec));
  int i,j,c,k = 0;
  short r,g,b;
  int xx,yy;		/* position of bitmap */

  /* Draw the box */
  fl_drw_box(ob->boxtype,ob->x,ob->y,ob->w,ob->h,ob->col2,FL_BITMAP_BW);
  fl_drw_text_beside(ob->align,ob->x,ob->y,ob->w,ob->h,
				ob->lcol,ob->lsize,ob->lstyle,ob->label);

  if (sp->bits_w == 0) return;
  /* Create the bitmap */
  for (j=0; j<sp->bits_h; j++)
  {
    for (i=0; i<sp->bits_w; i++)
    {
      if (sp->bits[k + i/8] & (1 << (i % 8))) c = ob->col1; else c = ob->col2;
      if (fl_rgbmode)
      {
        fl_getmcolor(c,&r,&g,&b);
        thebits[(sp->bits_h-j-1)*sp->bits_w+i] = 0x10000 * b + 0x100 * g + r;
      }
      else
        thebits[(sp->bits_h-j-1)*sp->bits_w+i] = (short)c;
    }
    k += (sp->bits_w+7)/8;
  }

  /* Calculate position and draw bitmap */
  xx = (int) (ob->x + (ob->w - (float) sp->bits_w)/2.0);
  yy = (int) (ob->y + (ob->h - (float) sp->bits_h)/2.0);
  lrectwrite(xx,yy,xx-1+sp->bits_w,yy-1+sp->bits_h,thebits);
}

static int handle_bitmap(FL_OBJECT *ob, int event, float mx, float my, char key)
/* Handles an event, returns whether value has changed. */
{
  switch (event)
  {
    case FL_DRAW:
        draw_bitmap(ob);
	return 0;
    case FL_FREEMEM:
	free(ob->spec);
	return 0;
  }
  return 0;
}
       
/*------------------------------*/

FL_OBJECT *fl_create_bitmap(int type,float x,float y,float w,float h,char label[])
/* Creates an object */
{
  FL_OBJECT *ob;
  ob = fl_make_object(FL_BITMAP,type,x,y,w,h,label,handle_bitmap);
  ob->boxtype = FL_BITMAP_BOXTYPE;
  ob->col1 = FL_BITMAP_COL1;
  ob->col2 = FL_BITMAP_COL2;
  ob->lcol = FL_BITMAP_LCOL;
  ob->align = FL_BITMAP_ALIGN;
  ob->active = 0;
  ob->spec = (int *) fl_malloc(sizeof(SPEC));
  ((SPEC *)(ob->spec))->bits_w = 0;
  return ob;
}

FL_OBJECT *fl_add_bitmap(int type, float x, float y, float w, float h, char label[])
/* Adds an object */
{
  FL_OBJECT *ob;
  ob = fl_create_bitmap(type,x,y,w,h,label);
  fl_add_object(fl_current_form,ob);
  return ob;
}

void fl_set_bitmap(FL_OBJECT *ob,int w, int h, char *b)
/* Fills the bitmap with a bitmap. */
{
  SPEC *sp;
  if (ob == NULL || ob->objclass != FL_BITMAP) return;
  sp = ((SPEC *)(ob->spec));
  sp->bits_w = w;
  sp->bits_h = h;
  sp->bits = b;
  if (w*h > FL_BITMAP_MAXSIZE) sp->bits_h = FL_BITMAP_MAXSIZE / w;
  fl_redraw_object(ob);
}
