/************   Object Class: Slider       ************/

/***** Class    *****/

#define FL_SLIDER		21
#define FL_VALSLIDER		24

/***** Types    *****/

#define FL_VERT_SLIDER		0
#define FL_HOR_SLIDER		1
#define FL_VERT_FILL_SLIDER	2
#define FL_HOR_FILL_SLIDER	3
#define FL_VERT_NICE_SLIDER	4
#define FL_HOR_NICE_SLIDER	5

/***** Defaults *****/

#define FL_SLIDER_BOXTYPE	FL_DOWN_BOX
#define FL_SLIDER_COL1		FL_COL1
#define FL_SLIDER_COL2		FL_COL1
#define FL_SLIDER_LCOL		FL_LCOL
#define FL_SLIDER_ALIGN		FL_ALIGN_BOTTOM

/***** Others   *****/

#define FL_SLIDER_BW1		FL_BOUND_WIDTH
#define FL_SLIDER_BW2		2.0

#define FL_SLIDER_FINE		0.05
#define FL_SLIDER_WIDTH		0.08

/***** Routines *****/

FL_OBJECT	*fl_create_slider(int, float, float, float, float, char []);
FL_OBJECT	*fl_add_slider(int, float, float, float, float, char []);

FL_OBJECT	*fl_create_valslider(int, float, float, float, float, char []);
FL_OBJECT	*fl_add_valslider(int, float, float, float, float, char []);

void 	fl_set_slider_value(FL_OBJECT *, float);
float 	fl_get_slider_value(FL_OBJECT *);
void 	fl_set_slider_bounds(FL_OBJECT *, float, float);
void 	fl_get_slider_bounds(FL_OBJECT *, float *, float *);

void	fl_set_slider_return(FL_OBJECT *, int);

void	fl_set_slider_step(FL_OBJECT *, float);
void	fl_set_slider_size(FL_OBJECT *, float);
void	fl_set_slider_precision(FL_OBJECT *, int);

/***** Routines in sldraw.c *****/

void	fl_drw_slider(int, float, float, float, float, int, int, int,
			float, float, char[]);

int	fl_get_pos_in_slider(float, float, float, float, int,
			float, float, float, float, float *);
