/************************************************************************
 *									*
 *  Forms is a library for building up dialogue and interaction boxes.  *
 *  It is based of the Silicon Graphics Graphical Library.		*
 *									*
 *  This software is public domain. It may not be resold.		*
 *									*
 *  Written by: Mark Overmars						*
 *              Department of Computer Science				*
 *              University of Utrecht					*
 *		P.O. Box 80.089						*
 *              3508 TB Utrecht, the Netherlands			*
 *		Email: markov@cs.ruu.nl					*
 *									*
 *  Version 2.2 d							*
 *  Date:  Jun 23, 1993							*
 ************************************************************************/

#ifndef __FORMS_H__
#define __FORMS_H__

#if defined(_LANGUAGE_C_PLUS_PLUS) || defined(__cplusplus)
extern "C" {
#endif

#include <stddef.h>
#include <gl/gl.h>

/************   The type OBJECT            ************/

struct forms;

typedef struct objs {
   int objclass;        /* What type of object */
   int type;            /* The type within the class */
   int boxtype;         /* The type of the bounding box */
   float x,y,w,h;       /* The bounding box */
   int col1,col2;       /* Two possible colors */

   char *label;		/* The label */
   int align;		/* Label or text alignment */
   int lcol;		/* Color of the label */
   float lsize; 	/* Size of the label */
   int lstyle;		/* Style of the text label */

   char *shortcut;	/* The list of shortcuts */

   int (*handle)(struct objs *, int, float, float, char);
			/* Handling procedure. */

   int *spec;           /* pointer to special stuff for object */

   int pushed;		/* wheter pushed */
   int focus; 		/* wheter focussed */
   int belowmouse;	/* Whether currently below the mouse */

   int redraw;		/* How often the object must be redrawn (0,1,2) */

   int active;		/* Whether active */
   int input;		/* Whether receiving input */
   int wantall;		/* Whether the input object wants <Ret>, <Tab> */
   int visible;         /* Whether being displayed */
   int radio;           /* Whether a radio object */
   int automatic;       /* Whether this object gets timer events */
   void (*object_call_back)(struct objs *, long);
			/* The call-back routine */
   long argument;	/* Its argument */

   struct objs *next;	/* Next object in the form */
   struct objs *prev;	/* Previous object in the form */
   struct forms *form;	/* Form to which object belong */
} FL_OBJECT;

/************   The type FORM              ************/

typedef struct forms {
   long window;         /* Window of the form */
   float w,h;           /* The size of the form */
   long x,y;		/* Position of form on screen */

   int deactivated;	/* Whether deactivated */
   int visible;         /* Whether being displayed */
   int frozen;          /* When true no redraws are performed */

   int doublebuf;	/* Whether in double buffer mode */

   void (*form_call_back)(struct objs *);
			/* The call-back routine */

   struct objs *first;	/* First object in the form */
   struct objs *last;	/* Last object in the form */

   struct objs *focusobj; /* Object to which input is directed */
} FL_FORM;

/************   General Constants          ************/

#ifndef NULL
#define NULL                    0
#endif

#ifndef FALSE
#define FALSE                   0
#endif

#ifndef TRUE
#define TRUE                    1
#endif

/***** Placement *****/

#define FL_PLACE_FREE		0
#define FL_PLACE_SIZE		1
#define FL_PLACE_ASPECT		2
#define FL_PLACE_MOUSE		3
#define FL_PLACE_CENTER		4
#define FL_PLACE_POSITION	5
#define FL_PLACE_FULLSCREEN	6

/***** Finds *****/

#define FL_FIND_INPUT		0
#define FL_FIND_AUTOMATIC	1
#define FL_FIND_MOUSE		2

/***** Special Objects  *****/

#define FL_BEGIN_GROUP		10000
#define FL_END_GROUP		20000

/***** Alignments *****/

#define FL_ALIGN_TOP		0
#define FL_ALIGN_BOTTOM		1
#define FL_ALIGN_LEFT		2
#define FL_ALIGN_RIGHT		3
#define FL_ALIGN_CENTER		4

/***** Bounding boxes *****/

#define FL_NO_BOX		0
#define FL_UP_BOX		1
#define FL_DOWN_BOX		2
#define FL_FLAT_BOX		3
#define FL_BORDER_BOX		4
#define FL_SHADOW_BOX		5
#define FL_FRAME_BOX		6
#define FL_ROUNDED_BOX		7
#define FL_RFLAT_BOX		8
#define FL_RSHADOW_BOX		9

/***** Boundary Colors *****/

#define FL_TOP_BOUND_COL	51
#define FL_LEFT_BOUND_COL	55
#define FL_BOT_BOUND_COL	40
#define FL_RIGHT_BOUND_COL	35

#define FL_COL1			47
#define FL_MCOL			49
#define FL_LCOL			0

#define FL_BOUND_WIDTH		3.0

/***** Events *****/

#define FL_DRAW			0
#define FL_PUSH			1
#define FL_RELEASE		2
#define FL_ENTER		3
#define FL_LEAVE		4
#define FL_MOUSE		5
#define FL_FOCUS		6
#define FL_UNFOCUS		7
#define FL_KEYBOARD		8
#define FL_STEP			9
#define FL_MOVE			10
#define FL_SHORTCUT		11
#define FL_FREEMEM		12

/***** Font *****/

#define FL_MAXFONT		32

#define FL_FONT_NAME_0		"Helvetica"
#define FL_FONT_NAME_1		"Helvetica-Bold"
#define FL_FONT_NAME_2		"Helvetica-Oblique"
#define FL_FONT_NAME_3		"Courier"
#define FL_FONT_NAME_4		"Courier-Bold"
#define FL_FONT_NAME_5		"Courier-Oblique"
#define FL_FONT_NAME_6		"Times-Roman"
#define FL_FONT_NAME_7		"Times-Bold"
#define FL_FONT_NAME_8		"Times-Italic"
#define FL_FONT_NAME_9		"Bookman-Light"
#define FL_FONT_NAME_10		"Bookman-Demi"
#define FL_FONT_NAME_11		"Bookman-LightItalic"
#define FL_FONT_NAME_12		"Symbol"
#define FL_FONT_NAME_13		"Type"
#define FL_FONT_NAME_14		"Iris"
#define FL_FONT_NAME_15		"ZapfDingbats"

#define FL_SMALL_FONT		8.0
#define FL_NORMAL_FONT		10.0
#define FL_LARGE_FONT		18.0

#define FL_NORMAL_STYLE		0
#define FL_BOLD_STYLE		1
#define FL_ITALIC_STYLE		2
#define FL_FIXED_STYLE		3

/* NEXT ONES WILL BE REMOVED */
#define FL_ENGRAVED_STYLE	4
#define FL_ICON_STYLE		5


/************   General Routines           ************/

/***** In objects.c *****/

typedef int (*FL_HANDLEPTR)(FL_OBJECT *, int , float, float, char);

FL_FORM		*fl_make_form(float,float); 
FL_OBJECT	*fl_make_object(int,int,float,float,float,float,char [], FL_HANDLEPTR);

void	fl_free_object(FL_OBJECT *);
void	fl_free_form(FL_FORM *);

void	fl_add_object(FL_FORM *, FL_OBJECT*);
void	fl_insert_object(FL_OBJECT *, FL_OBJECT*);
void	fl_delete_object(FL_OBJECT *);

void	fl_set_object_align(FL_OBJECT *, int);
void	fl_set_object_boxtype(FL_OBJECT *, int);
void	fl_set_object_color(FL_OBJECT *, int, int);
void	fl_set_object_label(FL_OBJECT *, char []);
void	fl_set_object_lcol(FL_OBJECT *, int);
void	fl_set_object_lsize(FL_OBJECT *, float );
void	fl_set_object_lstyle(FL_OBJECT *, int);

void	fl_show_object(FL_OBJECT *);
void	fl_hide_object(FL_OBJECT *);

void	fl_activate_object(FL_OBJECT *);
void	fl_deactivate_object(FL_OBJECT *);

void 	fl_set_object_focus(FL_FORM *, FL_OBJECT *);

void	fl_set_object_shortcut(FL_OBJECT *, char []);

FL_OBJECT	*fl_find_object(FL_OBJECT *, int, float, float);
FL_OBJECT	*fl_find_first(FL_FORM *, int, float, float);
FL_OBJECT	*fl_find_last(FL_FORM *, int, float, float);

void	fl_redraw_object(FL_OBJECT *);
void	fl_redraw_form(FL_FORM *);

void	fl_freeze_object(FL_OBJECT *);
void	fl_unfreeze_object(FL_OBJECT *);
void	fl_freeze_form(FL_FORM *);
void	fl_unfreeze_form(FL_FORM *);

void	fl_handle_object(FL_OBJECT *, int, float, float, char);
int	fl_handle_object_direct(FL_OBJECT *, int, float, float, char);

/***** In forms.c *****/

extern FL_FORM *fl_current_form;

FL_FORM		*fl_bgn_form(int, float, float);
void		fl_end_form(void);
void  		fl_addto_form(FL_FORM *);

FL_OBJECT	*fl_bgn_group(void);
FL_OBJECT	*fl_end_group(void);

void		fl_scale_form(FL_FORM *, float, float);
void		fl_set_form_position(FL_FORM *, long, long);
void		fl_set_form_size(FL_FORM *, long, long);
long		fl_show_form(FL_FORM *, int, int, char *); 
void		fl_hide_form(FL_FORM *);	

void		fl_treat_interaction_events(int);
FL_OBJECT	*fl_do_forms(void);
FL_OBJECT	*fl_check_forms(void);
FL_OBJECT	*fl_do_only_forms(void);
FL_OBJECT	*fl_check_only_forms(void);

void		fl_activate_form(FL_FORM *);
void		fl_deactivate_form(FL_FORM *);
void		fl_activate_all_forms();
void		fl_deactivate_all_forms();

/***** In events.c *****/

extern FL_OBJECT *FL_EVENT;

typedef void (*FL_CALLBACKPTR)(FL_OBJECT *, long);
typedef void (*FL_FORMCALLBACKPTR)(FL_OBJECT *);
typedef void (*FL_EVENTCALLBACKPTR)(short, short);

void	fl_init_events();

void	fl_set_call_back(FL_OBJECT *, FL_CALLBACKPTR, long);
void	fl_set_event_call_back(FL_EVENTCALLBACKPTR);
void	fl_set_form_call_back(FL_FORM *, FL_FORMCALLBACKPTR);

void 	fl_qdevice(Device);
void 	fl_unqdevice(Device);
int 	fl_isqueued(Device);
long 	fl_qtest(void);
long 	fl_qread(short *);
long 	fl_blkqread(short *, short);
void 	fl_qreset(void);
void 	fl_qenter(short,short);
void 	fl_tie(Device, Device, Device);

void	fl_treat_user_events(void);

FL_OBJECT 	*fl_object_qread(void);
void 		fl_object_qenter(FL_OBJECT *);

/***** In goodies.c *****/

long 	fl_show_buttonbox(void);
void 	fl_hide_buttonbox(void);
void 	fl_set_buttonbox_label(int, char []);

void 	fl_show_message(char [], char[], char []);
int 	fl_show_question(char [], char[], char []);
int 	fl_show_choice(char [], char[], char [], int,char [], char[], char []);
char 	*fl_show_input(char[], char[]);

int 	fl_show_colormap(int);

/***** In fselect.c *****/

char 	*fl_show_file_selector(char [], char [], char [], char []);

char 	*fl_get_directory();
char 	*fl_get_pattern();
char 	*fl_get_filename();

/***** In draw.c *****/

void	fl_get_mouse(float *, float *);

void	fl_set_clipping(float, float, float, float);
void	fl_unset_clipping(void);

void	fl_init_fonts();
void	fl_set_font_name(int, char []);
void	fl_set_font(char [], char [], char [], char[]); /* REMOVED SOON */
float	fl_get_char_height(float, int);
float	fl_get_char_width(float, int, char);
float	fl_get_string_width(float, int, char []);

void	fl_init_colormap();
void	fl_color(int);
void	fl_mapcolor(int, short, short, short);
void	fl_getmcolor(int, short *, short *, short *);

void    fl_line(float, float, float, float, int);
void    fl_rect(float, float, float, float, int);
void    fl_bound(float, float, float, float, int);
void    fl_rectbound(float, float, float, float, int);

void	fl_drw_box(int ,float, float, float, float, int,float);
void	fl_drw_string(int, int, float, float, float, float,
			int, int, int, int, float, int,
			int, int, int, char []);
int	fl_get_pos_in_string(int, int, float, float, float, float,
			float, int, float, float, char []);
			
void	fl_drw_text(int, float, float, float, float, int, float, int, char[]);
void	fl_drw_text_beside(int, float, float, float, float, int, float, int, char[]);
void	fl_drw_text_cursor(int, float, float, float, float, int, float, int, char[], int, int);

/***** In symbols.c *****/

typedef void (*FL_DRAWPTR)(int);

void 	fl_init_symbols();

int 	fl_add_symbol(char [], FL_DRAWPTR, int);
int 	fl_draw_symbol(char [], float, float, float,float, int);

/***** In support.c *****/

extern int fl_rgbmode;
extern int fl_doublebuf;

void	fl_init();
void	fl_set_graphics_mode(int, int);

void	fl_show_errors(int);
void	fl_error(char [], char []);

void	*fl_malloc(size_t);

void	fl_save_user_window();
void	fl_restore_user_window();
void	fl_set_forms_window(FL_FORM *);

/************************* The Classes ***********************/

