/*
 *		Copyright IBM Corporation 1989
 *
 *                      All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 * University of Illinois at Urbana-Champaign
 * Department of Computer Science
 * 1304 W. Springfield Ave.
 * Urbana, IL	61801
 *
 * (C) Copyright 1987, 1988 by The University of Illinois Board of Trustees.
 *	All rights reserved.
 *
 * Tool: X 11 Graphical Kernel System
 * Author: Gregory Scott Rogers
 * Author: Sung Hsien Ching Kelvin
 * Author: Yu Pan
 */

#ifndef lint
    static char	rcsid[]	= "$Id: mi.c,v 2.2 1991/07/26 19:06:31 steve Exp $";
    static char	afsid[]	= "$__Header$";
#endif

#include <stdlib.h>
#include <stdio.h>
#include "xgks.h"
#include "demo.h"

#define CLEAR_WORKSTATION	1


main(argc, argv)
    int             argc;
    char           *argv[];
{
    int		    lineno;
    int		    error;
    int             c;
    char           *conn	= NULL;
    char           *mi_path	= NULL;
    Gchar          *record;
    Ggksmit         gksmit;
    extern char    *optarg;
    extern int      optind;

    while ((c = getopt(argc, argv, "d:")) != -1) {
	switch (c) {
	case 'd':
	    conn	= optarg;
	    break;
	}
    }

    if (optind >= argc) {
	fprintf(stderr, "usage: %s [-d display] file\n", argv[0]);
	exit(0);
    }

    mi_path	= argv[optind];

    gopengks(stderr, 0);

    gopenws(5, mi_path, "MI");
    gopenws(1, conn, conn);

    gactivatews(1);

    for (lineno = 1, error = 0; !error; ++lineno) {
	int	status	= ggetgksm(5, &gksmit);

	if (status != 0) {
	    error	= status != 162;
	    break;
	}

	if (gksmit.type == CLEAR_WORKSTATION) {
	    Gwsdus         du;

	    (void) ginqwsdeferupdatest(1, &du);

	    if (du.dspsurf == GNOTEMPTY) {
		fprintf(stderr, "Hit BREAK in window to continue\n");
		WaitForBreak(1);
	    }
	}

	record	= malloc((size_t) gksmit.length);

	if ((status = greadgksm(5, gksmit.length, record)) != 0) {
	    error	= status != 162;
	    break;
	}
	error	= ginterpret(&gksmit, record) != 0;
    }
    if (error)
	fprintf(stderr, "Error occured at line %d\n", lineno);

    fprintf(stderr, "Done.  Hit BREAK in window to quit.\n");

    WaitForBreak(1);

    gdeactivatews(1);

    gclosews(1);
    gclosews(5);

    gclosegks();

    return 0;
}
