/*
 *		Copyright IBM Corporation 1989
 *
 *                      All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of IBM not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 *
 * University of Illinois at Urbana-Champaign
 * Department of Computer Science
 * 1304 W. Springfield Ave.
 * Urbana, IL	61801
 *
 * (C) Copyright 1987, 1988 by The University of Illinois Board of Trustees.
 * All rights reserved.
 *
 * Tool: X 11 Graphical Kernel System
 * Author: Gregory Scott Rogers
 * Author: Sung Hsien Ching Kelvin
 * Author: Yu Pan
 *
 * This header-file depends upon header-files "gks_defines.h", "primitive.h",
 * and "wdt.h".
 */


#ifndef  WSLIST_H
#define  WSLIST_H


/*
 * NDC to DC, DC to X, and NDC to X transformations are stored in the
 * workstation structure using the WS_TRANS structure.
 */
typedef struct {
    Gfloat          xScale, xTrans;
    Gfloat          yScale, yTrans;
}               WS_TRANS;


/* Workstation type */
typedef enum {
    WST_INVALID,			/* Invalid workstation */
    X_WIN,				/* X Window System */
    WISS,				/* Workstation-independent segment-
					 * storage */
    MI,					/* Metafile input */
    MO					/* Metafile output */
} EWSTYPE;


/* Dash-list type */
typedef struct {
    int             dn;			/* dash list length */
    char            dashl[17];		/* dash list */
} DashList;


extern DashList xgksDASHES[10];		/* defined in xpline.c */


/*
 * Workstation information for an X window (this structure is unused as yet):
 */
typedef struct Xwindow {
    struct ws_struct
		   *ws;			/* (Enclosing) workstation entry */
    Display        *dpy;		/* the display ID */
    Window          win;		/* the window ID */
    unsigned long   event_mask;		/* the initial window event mask */
    GC              gc;			/* the window graphics context */
    GC              plinegc;		/* graphics contexts for specific */
    GC              pmarkgc;		/* primitives */
    GC              fillareagc;
    GC              textgc;
    Colormap        dclmp;		/* the screen default colour map ID */
    Colormap        wclmp;		/* the window colourmap ID */
    Gpoint          wbound;		/* Current x window bound */
    Gint            wscolour;		/* Number of available colours on the
					 * ws */
    Gcobundl       *set_colour_rep;	/* colours set by user */
    Gint            wsfg, wsbg;		/* foreground and background pixel
					 * values */
    WS_TRANS        dctoxtrans;		/* transformation constants from DC
					 * space to X_WIN space */
    WS_TRANS        ndctoxtrans;	/* composite of ndctodc and dctox */
    XRectangle      xclip;		/* the clip area in the X window */
    XRectangle      last_pline_rectangle;
    XRectangle      last_pmarker_rectangle;
    XRectangle      last_farea_rectangle;
    XRectangle      last_text_rectangle;
    Gint            last_dash_index;
    Gint            last_message_width;
    XcMap           XcMap;		/* GKS <-> X color-mapping */
    int             soft_clipping_on;   /* soft-clipping is enabled? */
    int		    backing_store_on;	/* backing-store is enabled? */
}               Xwindow;


/*
 * Type of Metafile:
 */
typedef enum mf_type {
    MF_GKSM	= 0,
    MF_CGM
}		mf_type;


/*
 * Workstation information common to every Metafile implementation:
 */
#define MF_COMMON \
    mf_type	type;			/* Type of Metafile */ \
    Gfile	*fp;			/* File structure */ \
    Gint	filestat;		/* File status */ \
    Ggksmit	CurItem;		/* Current item (type, length) */ \
    Gint	GksmEmpty;		/* Metafile is empty? */ \
    struct ws_struct \
		*ws;			/* Associated workstation structure */


/*
 * Common Metafile information:
 */
typedef struct mf_any {
    MF_COMMON
}		mf_any;


/*
 * Workstation information specific to GKS Metafiles (GKSM):
 */
typedef struct mf_gksm {
    MF_COMMON
    Gchar	std[5];		/* the string GKSM + NULL */
    Gchar	info[41];	/* author installation etc. + NULL */
    Gchar	date[9];	/* yy/mm/dd + NULL */
    Gint	ver;		/* version numer */
    Gint	h;		/* Number of bytes of "GKSM" at start of each
				 * item record (0-4) */
    Gint	t;		/* length of item-type indicator field */
    Gint	l;		/* length of item data-record length-indicator 
				 * field */
    Gint	i;		/* length of field for each integer in the 
				 * item data-record */
    Gint	r;		/* length of field for each real in the item
				 * data-record */
    Gint	f;		/* Number representation indicator: 
				 *	1:	all numbers formatted according
				 *		to ISO 6093
				 *	2:	all numbers stored in internal 
				 *		binary format. */
    Gint	ri;		/* Representation of real values:
				 *	1:	real
				 *	2:	integer */
    Gchar	d1[12];		/* Integer equivalent to 0.0 iff ri==2 */
    Gchar	d2[12];		/* Integer equivalent to 1.0 iff ri==2 */
}		mf_gksm;


/*
 * A CGM direct color:
 */
typedef struct cgm_direct_color {
    int		red;		/* Less than 0 implies RGB value not set */
    int		green;
    int		blue;
}	cgm_direct_color;


/*
 * A CGM color (either direct or indexed, depending on color selection mode):
 */
typedef union cgm_color {
    int			index;
    cgm_direct_color	direct;
}	cgm_color;


/*
 * Output CGM modes:
 */
typedef enum cgmo_mode {
    CGMO_UNSET	= 0,
    CGMO_IN_METAFILE,		/* BEGIN PICTURE not yet seen */
    CGMO_IN_PICTURE,		/* BEGIN PICTURE seen */
    CGMO_IN_BODY,		/* BEGIN PICTURE BODY seen */
    CGMO_NOT_EMPTY		/* Graphic written to view surface */
}	cgmo_mode;


/*
 * Workstation information specific to output Computer Graphics Metafiles 
 * (CGMOs):
 */
typedef struct mf_cgmo {
    MF_COMMON
    cgmo_mode	mode;			/* Output CGM mode */
    int		picture_number;		/* Origin-1 picture number */
    unsigned long
		isset;
#	define	CGM_MASK_BACKCOLR	(1 << 0)
#	define	CGM_MASK_LINEINDEX	(1 << 1)
#	define	CGM_MASK_LINETYPE	(1 << 2)
#	define	CGM_MASK_LINEWIDTH	(1 << 3)
#	define	CGM_MASK_LINECOLR	(1 << 4)
#	define	CGM_MASK_MARKERINDEX	(1 << 5)
#	define	CGM_MASK_MARKERTYPE	(1 << 6)
#	define	CGM_MASK_MARKERSIZE	(1 << 7)
#	define	CGM_MASK_MARKERCOLR	(1 << 8)
#	define	CGM_MASK_TEXTINDEX	(1 << 9)
#	define	CGM_MASK_TEXTFONTINDEX	(1 << 10)
#	define	CGM_MASK_TEXTPREC	(1 << 11)
#	define	CGM_MASK_CHAREXPAN	(1 << 12)
#	define	CGM_MASK_CHARSPACE	(1 << 13)
#	define	CGM_MASK_TEXTCOLR	(1 << 14)
#	define	CGM_MASK_CHARHEIGHT	(1 << 15)
#	define	CGM_MASK_CHARORI	(1 << 16)
#	define	CGM_MASK_TEXTPATH	(1 << 17)
#	define	CGM_MASK_TEXTALIGN	(1 << 18)
#	define	CGM_MASK_FILLINDEX	(1 << 19)
#	define	CGM_MASK_INTSTYLE	(1 << 20)
#	define	CGM_MASK_FILLCOLR	(1 << 21)
#	define	CGM_MASK_HATCHINDEX	(1 << 22)
#	define	CGM_MASK_PATINDEX	(1 << 23)
#	define	CGM_MASK_PATSIZE	(1 << 24)
#	define	CGM_MASK_COLRTABLE	(1 << 25)
    Glimit	wswindow;		/* Workstation window */
    Gcobundl	backcolr;		/* Background color */
    int		lineindex;		/* Line bundle index */
    int		linetype;		/* Line type */
    float	linewidth;		/* Line width */
    cgm_color	linecolr;		/* Line color */
    int		markerindex;		/* Marker bundle index */
    int		markertype;		/* Marker type */
    float	markersize;		/* Marker size */
    cgm_color	markercolr;		/* Marker color */
    int		textindex;		/* Text bundle index */
    Gtxfp	txfp;			/* Text font index and precision */
    float	charexpan;		/* Character expansion factor */
    float	charspace;		/* Inter-character spacing */
    cgm_color	textcolr;		/* Text color index */
    float	charheight;		/* Character height */
    float	charori[4];		/* Character orientation */
    Gtxpath	textpath;		/* Text path */
    Gtxalign	textalign;		/* Text alignment */
    int		fillindex;		/* Fill bundle index */
    Gflinter	intstyle;		/* Interior fill style */
    cgm_color	fillcolr;		/* Fill color */
    int		hatchindex;		/* Hatch index */
    int		patindex;		/* Pattern index */
} mf_cgmo;


/*
 * Workstation information specific to input Computer Graphics Metafiles 
 * (CGMIs):
 */
typedef struct mf_cgmi {
    MF_COMMON
    long	total_length;		/* Total amount of data (excludes 
					 * padding) */
    long	total_left;		/* Total amount of data left (excludes
					 * padding) */
    int		partition_length;	/* Amount of data in current partition
					 * (excludes padding) */
    int		partition_left;		/* Amount left in current partition
					 * (excludes padding) */
    long	start_this_element;	/* File-offset to current element */
    long	start_next_element;	/* File-offset to next element */
    int		mode;			/* CGMI mode */
#	define	NORMAL_MODE		0
#	define	READING_COLOR_TABLE	1
    int		class;			/* Command class of current element */
    int		id;			/* Element ID of current element */
    int		hash_id;		/* Element class and id combination */
    Glimit	clip_rect;		/* Clipping rectangle */
    Gtxfp	txfp;			/* Text font and precision */
    Gpoint	char_up;		/* Character up vector */
    Gpoint	char_base;		/* Character base vector */
    Gfloat	char_height;		/* Character height */
    int		color_index;		/* Color table index */
} mf_cgmi;


/*
 * Workstation information specific to Computer Graphics Metafiles (input or
 * output).
 */
typedef union mf_cgm {
    mf_cgmo	mo;
    mf_cgmi	mi;
} mf_cgm;


/*
 * Workstation information specific to (general) Metafiles:
 */
typedef union Metafile {
    mf_any	any;
    mf_gksm	gksm;
    mf_cgm	cgm;
}		Metafile;


/*
 * Workstation information:
 */
typedef struct ws_struct {
    Gint            ws_id;		/* Workstation identifier */
    Gchar          *conn;		/* Workstation Connection and type */
    Gchar          *wstype;		/* workstation type */
    EWSTYPE         ewstype;		/* enum ws type */

    Gint            ws_is_closing;	/* true = closing */

    Metafile        mf;			/* Metafile information: */

    /*
     * Entries in this group do not exist for workstation of categories INPUT
     * and MI
     */
    Gwsstate        wsstate;		/* Workstation state
					 * [ACTIVE/INACTIVE] */

    /*
     * Entries in this group do not exist for workstation of categoeies
     * INPUT, WISS, MI
     */
    Gstore          primi_store;	/* state of storage of non-segment
					 * primitives */
    Gpoint          size;		/* Workstation DC space size */
    Gwsti           wsti;		/* Workstation transformation
					 * information */
    Gwsdus          wsdus;		/* Workstation defferal & update
					 * state */
    /*
     * User-defined function called each time after workstation redraw
     */
    Gint            (*redrawfuncp) ();

    /*
     * Entries in this group do not exist for workstation of categoeies
     * INPUT, WISS, MI, MO
     */
    Glnbundl        lnbundl_table[MAX_BUNDL_TBL];	/* Polyline bundle
							 * table */
    Gmkbundl        mkbundl_table[MAX_BUNDL_TBL];	/* Polymarker bundle
							 * table */
    Gtxbundl        txbundl_table[MAX_BUNDL_TBL];	/* Text bundle table */
    Gflbundl        flbundl_table[MAX_BUNDL_TBL];	/* Fill area bundle
							 * table */
    Gptbundl        ptbundl_table[MAX_BUNDL_TBL];	/* Pattern bundle
							 * table */

    /*
     * Segments associated with this workstation -- this structure is very
     * important when we want to clear a ws
     */
    WS_SEG_LIST    *seglist;
    WS_SEG_LIST    *seg_insertpt;
    Gint            seg_list_dirty;	/* Flag indicating that ws->seglist
					 * needs to be re-arrange before next
					 * gks-redraw */

    /*
     * A note on implementation, this list will be mantain by routines in
     * segment.c and should only be changed by routines in it !
     */

    /*
     * logical input devices are implemented as a linked list of all the
     * devices that have been used
     */
    INPUT_DEV      *in_dev_list;

    Glimit          clip;		/* Intersection between NDC-viewport
					 * and WS_window */

    /*
     * Following output primitive list are for non-segment primitives
     * associated with this workstation
     */
    OUT_PRIMI       primi_list;		/* First primitve is always a
					 * CLIP_REC */
    OUT_PRIMI      *primi_insert_pt;
    /*
     * Primitive manager needs this for efficient insertion
     */
    OUT_PRIMI      *message_pt;		/* Points to mesg. prim. in list;
					 * NULL if none */
    OUT_PRIMI      *bef_message;	/* Points to node before mesg in list */

    WS_TRANS        ndctodctrans;	/* transformation constants from NDC
					 * space to DC space */

    /*
     * X-specific stuff.  NB: this should be unioned (and, hopefully, will
     * eventually be) with the Metafile union defined above.
     */
    Display        *dpy;		/* the display ID */
    Window          win;		/* the window ID */
    unsigned long
                    event_mask;		/* the initial window event mask */
    GC              gc;			/* the window graphics context */
    GC              plinegc;		/* graphics contexts for specific */
    GC              pmarkgc;		/* primitives */
    GC              fillareagc;
    GC              textgc;
    Colormap        dclmp;		/* the screen default colour map ID */
    Colormap        wclmp;		/* the window colourmap ID */
    Gpoint          wbound;		/* Current x window bound */
    Gint            wscolour;		/* Number of available colours on the
					 * ws */
    Gcobundl       *set_colour_rep;	/* colours set by user */
    Gint            wsfg, wsbg;		/* foreground and background pixel
					 * values */
    WS_TRANS        dctoxtrans;		/* transformation constants from DC
					 * space to X_WIN space */
    WS_TRANS        ndctoxtrans;	/* composite of ndctodc and dctox */
    XRectangle      xclip;		/* the clip area in the X window */
    XRectangle      last_pline_rectangle;
    XRectangle      last_pmarker_rectangle;
    XRectangle      last_farea_rectangle;
    XRectangle      last_text_rectangle;
    Gint            last_dash_index;
    Gint            last_message_width;
    XcMap           XcMap;		/* GKS <-> X color-mapping */
    int             soft_clipping_on;	/* soft-clipping is enabled? */
    int		    backing_store_on;	/* backing-store is enabled? */
}              *WS_STATE_PTR, WS_STATE_ENTRY;


#define	NOT_SET	(-9.99)


extern Gwscat          XgksWsCategory		PROTO((WS_STATE_PTR ws));
extern EWSTYPE         XgksWsTypeToEnum		PROTO((Gchar *wstype));
extern WS_STATE_PTR    XgksValidWsId		PROTO((Gint ws_id));


/*
 * VALID_WSID(i) used to check to see if there was a workstation open with
 * the name i.  I renamed this function OPEN_WSID and created a new VALID_WSID
 * that checks if the ws id is valid (non-negative).  This was all done in the
 * name of PTR c1012: many functions returned error 25 (ws not open) in cases
 * where error 20 (ws invalid) would be more appropriate.
 */
#define VALID_WSID(i)	((i) >= 0)
#define OPEN_WSID(i)	(XgksValidWsId(i))
#define WS_CAT(t)	(XgksWsCategory(t))


#define NdcToDc(ws, ndc, dc) { \
    /* WS_STATE_ENTRY *ws; Gpoint *ndc, *dc; */  \
    (dc)->x = (ndc)->x * (ws)->ndctodctrans.xScale \
	    + (ws)->ndctodctrans.xTrans; \
    (dc)->y = (ndc)->y * (ws)->ndctodctrans.yScale \
	    + (ws)->ndctodctrans.yTrans; \
}


#define DcToNdc(ws, dc, ndc) { \
    /* WS_STATE_ENTRY *ws; Gpoint *dc, *ndc; */  \
    (ndc)->x = ((dc)->x - (ws)->ndctodctrans.xTrans) \
	    / (ws)->ndctodctrans.xScale; \
    (ndc)->y = ((dc)->y - (ws)->ndctodctrans.yTrans) \
	    / (ws)->ndctodctrans.yScale; \
}


/*
 * Note the rounding performed in the following by the addition of the 0.5
 * term.  We do this to obtain the X pixel closest to the DC point.  We use
 * a positive 0.5 for rounding because only non-negative X window co-ordinates
 * are useful.
 */
#define DcToX(ws, dc, xpt) { \
    /* WS_STATE_ENTRY *ws; Gpoint *dc; XPoint *xpt; */  \
    (xpt)->x = (short)((dc)->x * (ws)->dctoxtrans.xScale \
	    + (ws)->dctoxtrans.xTrans + 0.5); \
    (xpt)->y = (short)(ws->wbound.y - ((dc)->y * (ws)->dctoxtrans.yScale \
	    + (ws)->dctoxtrans.yTrans) + 0.5); \
}


#define XToDc(ws, xpt, dc) { \
    /* WS_STATE_ENTRY *ws; Gpoint *dc; XPoint *xpt; */  \
    (dc)->x = ((xpt)->x - (ws)->dctoxtrans.xTrans) \
	    / (ws)->dctoxtrans.xScale; \
    (dc)->y = ((ws->wbound.y - (xpt)->y) - (ws)->dctoxtrans.yTrans) \
	    / (ws)->dctoxtrans.yScale; \
}


/*
 * Note the rounding performed in the following by the addition of the 0.5
 * term.  We do this to obtain the X pixel closest to the NDC point.  We use
 * a positive 0.5 for rounding because only non-negative X window co-ordinates
 * are useful.  (Aside: Instead of the 0.5 term in the following, Harry Edmon,
 * in his fix, had 0.001).
 */
#define NdcToX(ws, ndc, xpt) { \
    /* WS_STATE_ENTRY *ws; Gpoint *ndc; XPoint *xpt; */  \
    (xpt)->x = (short)((ndc)->x * (ws)->ndctoxtrans.xScale \
	    + (ws)->ndctoxtrans.xTrans + 0.5); \
    (xpt)->y = (short)(ws->wbound.y - ((ndc)->y * (ws)->ndctoxtrans.yScale \
	    + (ws)->ndctoxtrans.yTrans) + 0.5); \
}


#define XToNdc(ws, xpt, ndc) { \
    /* WS_STATE_ENTRY *ws; Gpoint *ndc; XPoint *xpt; */  \
    (ndc)->x = ((xpt)->x - (ws)->ndctoxtrans.xTrans) \
	    / (ws)->ndctoxtrans.xScale; \
    (ndc)->y = ((ws->wbound.y - (xpt)->y) - (ws)->ndctoxtrans.yTrans) \
	    / (ws)->ndctoxtrans.yScale; \
}


/*
 * The following lines are for the GKS-color-index-to-X-color-cell mapping
 * abstraction.
 *
 * The "Xc" prefix refers to "X-color".
 */

#ifndef PROTO
#   define	PROTO(x)	()
#endif


/*
 * Procedural interface to the GKS <-> X color-mapping abstraction:
 */
extern int	XcNew		PROTO((WS_STATE_PTR XcWs));
extern int	XcInit		PROTO((WS_STATE_PTR XcWs, XVisualInfo *vinfo));
extern int	XcSetColour	PROTO((WS_STATE_PTR XcWs, Gint ColourIndex,
				       Gcobundl *XcRep));
extern unsigned long	
	    	XcPixelValue    PROTO((WS_STATE_PTR XcWs, Gint ColourIndex));
extern Gint	XcColourIndex	PROTO((WS_STATE_PTR XcWs,
				       unsigned long PixelValue));
extern int	XcEnd		PROTO((WS_STATE_PTR XcWs));

#endif					/* WSLIST_H not defined */
