%{
/*
 * yacc(1)-based parser for decoding formatted units(3) specifications.
 */

/*LINTLIBRARY*/

#ifndef lint
    static char rcsid[] = "$Id: parser.y,v 1.6 1992/01/06 15:26:35 steve Exp $";
    static char afsid[] = "$__Header$";
#endif

#include <udposix.h>
#include <string.h>
#include "udalloc.h"
#include "uderrmsg.h"
#include "udunits.h"
#include "scanner.h"
#include "utprivate.h"

#define	malloc		udmalloc
#define realloc		udrealloc

int	UtLineno;		/* input-file line index */
int	UnitNotFound;		/* parser didn't find unit */
char	*buffer;                /* input-string buffer */
char	*pointer;               /* position in input buffer */
utUnit	*FinalUnit;		/* fully-parsed specification */

static void	yyerror();

%}

%union {
    double	rval;			/* floating-point numerical value */
    int		ival;			/* integer numerical value */
    char	name[UT_NAMELEN];	/* name of a quantity */
    utUnit	unit;			/* "unit" structure */
}
%token  <ival>	INT
%token  <ival>	ERR
%token  <ival>	END
%token	<ival>	SHIFT
%token  <ival>	SPACE
%token  <ival>	MULTIPLY
%token  <ival>	DIVIDE
%token  <ival>	EXPONENT
%token  <rval>	REAL
%token  <name>	NAME

%type   <ival>	sign
%type	<ival>	s_integer
%type   <rval>	number_exp
%type   <rval>	s_number_exp
%type   <rval>	value_exp
%type   <unit>	shift_exp
%type   <unit>	power_exp
%type   <unit>	factor_exp
%type   <unit>	quant_exp
%type   <unit>	s_unit_exp
%type   <unit>	unit_exp
%type	<unit>	unit_spec

%%

unit_spec:     /* nothing */			{
			YYACCEPT;
		  }
		| s_unit_exp END		{
			(void)utCopy(&$1, FinalUnit);
			YYACCEPT;
		  }
		| error END                     { 
			yyerrok;
			yyclearin;
			YYABORT;
		  }
		;

s_unit_exp:	  sign unit_exp		{ 
			(void)utScale(&$2, $1 < 0 ? -1.0 : 1.0, &$$);
		  }
		| unit_exp			{
			(void)utCopy(&$1, &$$);
		  }
		;

unit_exp:	  shift_exp			{
			(void)utCopy(&$1, &$$);
		  }
		| unit_exp shift_exp	{
			(void)utMultiply(&$1, &$2, &$$);
		  }
		| unit_exp MULTIPLY shift_exp	{
			(void)utMultiply(&$1, &$3, &$$);
		  }
		| unit_exp DIVIDE shift_exp	{
			(void)utDivide(&$1, &$3, &$$);
		  }
		;

shift_exp:	  power_exp			{
			(void)utCopy(&$1, &$$);
		  }
		| shift_exp SHIFT value_exp	{
			(void)utShift(&$1, $3, &$$);
		  }
		;

power_exp:	  factor_exp			{
			(void)utCopy(&$1, &$$);
		  }
		| power_exp s_integer		{
			(void)utRaise(&$1, $2, &$$);
		  }
		| power_exp EXPONENT s_integer	{
			(void)utRaise(&$1, $3, &$$);
		  }
		;

factor_exp:	  number_exp			{
			utUnit	unit;
			(void)utScale(utClear(&unit), $1, &$$);
		  }
		| quant_exp			{
			(void)utCopy(&$1, &$$);
		  }
		| '(' unit_exp ')'		{
			(void)utCopy(&$2, &$$);
		  }
		;

quant_exp:	  NAME                          { 
			utUnit     unit;
			if (utFind($1, &unit) != 0) {
			    UnitNotFound	= 1;
			    YYERROR;
			}
			(void)utCopy(&unit, &$$);
		  }
		| NAME s_integer		{
			utUnit     unit;
			if (utFind($1, &unit) != 0) {
			    UnitNotFound	= 1;
			    YYERROR;
			}
			(void)utRaise(&unit, $2, &$$);
		  }
		;

value_exp:	  s_number_exp			{ $$ = $1; }
		| '(' value_exp ')'		{ $$ = $2; }
		;

s_number_exp:	  sign number_exp		{ $$ = $1*$2; }
		| number_exp			{ $$ = $1; }
		;

s_integer:	  INT				{ $$ = $1; }
		| sign INT			{ $$ = $1 < 0 ? -$2 : $2; }
		;

sign:             '+'                           { $$ =  1; }
		| '-'                           { $$ = -1; }
		;

number_exp:	  INT				{ $$ = $1; }
		| REAL				{ $$ = $1; }
		;

%%

/*
 *  YACC error routine:
 */
    static void
yyerror(s)
    char        *s;
{
    char	buf[512];
    register	i;

    udadvise("utParseSpec: %s:", s);
    udadvise(buffer);
    if (strlen(buffer) < sizeof(buf)) {
	for (i = 0; buffer+i+1 < pointer; ++i)
	    buf[i]	= ' ';
	buf[i]		= '^';
	buf[i+1]	= 0;
	udadvise(buf);
    }
}
