/*
 * $Id: udposix.h,v 1.2 1991/07/24 21:23:11 steve Exp $
 *
 * Configuration header-file for the Ultrix 4.2 version of the Unidata 
 * POSIX programming environment.
 */

#ifdef UD_FORTRAN_SOURCE
#   undef UDPOSIX_H_INCLUDED
#endif

#ifndef UDPOSIX_H_INCLUDED
#define	UDPOSIX_H_INCLUDED

#ifndef	POSIX
#   define	POSIX
#endif
#ifndef	_POSIX_SOURCE
#   define	_POSIX_SOURCE
#endif

/*
 * Set NDEBUG according to DEBUG.
 */
#ifdef DEBUG
#   undef NDEBUG
#else
#   define NDEBUG
#endif

typedef	int		bool;
#define	NO		0
#define	YES		1
#define FREE_ARG	void*			/* argument to free(3) */
typedef void		*VOIDP;
typedef void		*voidp;

/*
 *	Compiler-dependent, ANSI-C symbols:
 *
 *	The PROTO() Macro is for declaring functions regardless of the 
 *	availability of function prototypes.  It will need double parens
 *	in actual use (e.g.  "int func PROTO((int a, char *cp))").
 */
#define	PROTO(a)	a

#       if defined(__cplusplus) || defined(c_plusplus)
#           define      UD_CPLUSPLUS_SOURCE
#       endif

	/*
	 * Macro for declaring external functions.  Note that it does not
	 * take a trailing semicolon.
	 */
#       ifdef UD_CPLUSPLUS_SOURCE
#           define      EXTERN_FUNC(func, args) extern "C" {extern func args;}
#       else
#           define      EXTERN_FUNC(func, args) extern func PROTO(args)
#       endif

        /*
         * Macro for ensuring the proper compilation of macros which contain
         * conditional statements (the trick is to generate a syntax error if 
         * and when the user forgets the final semicolon):
         */
#       ifdef lint
            extern int  UD_ZERO;
#       else
#           define UD_ZERO      0
#       endif
#       define UD_STMT(stuff) do {stuff} while (UD_ZERO)

#if defined(__STDC__) || defined(__GNUC__) || defined(UD_CPLUSPLUS_SOURCE)
#   define	GLUE(a,b)	a##b
#   define	MAKESTRING(s)	# s
#else
#   define	GLUE(a,b)	a/**/b
#   define	MAKESTRING(s)	"s"
#   define	const
#endif

#endif	/* UDPOSIX_H_INCLUDED not defined */
