/*
 * ex: se wm=0:
 *
 * $Id: udposix.h,v 1.5 1992/04/28 15:00:35 steve Exp $
 *
 * Header-file for the SunOS 4.1.1 version of the Unidata POSIX
 * programming environment.
 */

#ifdef UD_FORTRAN_SOURCE
#   undef UDPOSIX_H_INCLUDED
#endif

#ifndef UDPOSIX_H_INCLUDED
#   define	UDPOSIX_H_INCLUDED

#   ifndef UD_FORTRAN_SOURCE

#       define  _POSIX_SOURCE

        /*
         * Set NDEBUG according to DEBUG.
         */
#       ifdef DEBUG
#           undef NDEBUG
#       else
#           define NDEBUG
#       endif

        typedef int             bool;
#       define  NO              0
#       define  YES             1
        typedef void            *VOIDP;
        typedef void            *voidp;
#       define FREE_ARG void*                   /* argument to free(3) */

#       if defined(__cplusplus) || defined(c_plusplus)
#           define      UD_CPLUSPLUS_SOURCE
#       endif

        /*
         * Macro for declaring functions regardless of the availability of 
         * function prototypes.  NB: will need double parens in actual use (e.g.
         * "int func PROTO((int a, char *cp))").
         */
#       if defined(__STDC__) || defined(__GNUC__) || defined(UD_CPLUSPLUS_SOURCE)
#           define      PROTO(a)        a
#       else
#           define      PROTO(a)        ()
#       endif

	/*
	 * Macro for declaring external functions.  Note that it does not
	 * take a trailing semicolon.
	 */
#       ifdef UD_CPLUSPLUS_SOURCE
#           define      EXTERN_FUNC(func, args) extern "C" {extern func args;}
#       else
#           define      EXTERN_FUNC(func, args) extern func PROTO(args)
#       endif

        /*
         * Macro for ensuring the proper compilation of macros which contain
         * conditional statements (the trick is to generate a syntax error if 
         * and when the user forgets the final semicolon):
         */
#       ifdef lint
            extern int  UD_ZERO;
#       else
#           define UD_ZERO      0
#       endif
#       define UD_STMT(stuff) do {stuff} while (UD_ZERO)

#       if defined(__STDC__) || defined(__GNUC__) || defined(UD_CPLUSPLUS_SOURCE)
#           define      MAKESTRING(s)   # s
#           define      GLUE(a,b)       a##b
#       else
#           define      volatile
#           define      const
#           define      signed
#           define      MAKESTRING(s)   "s"
#           define      GLUE(a,b)       a/**/b
#           if 0        /* alternative definitions: */
#               define UD_IDENT(x)      x
#               define GLUE(a,b)        UD_IDENT(a)b
#           endif
#       endif

#   endif       /* UD_FORTRAN_SOURCE not defined above */

#endif  /* UDPOSIX_H_INCLUDED not defined above */
