/*
 * $Id: fortc.c,v 1.1 1992/04/28 14:30:07 steve Exp $
 *
 * This file implements some support routines for FORTRAN-callable C
 * functions.
 */

/*LINTLIBRARY*/

#include "udposix.h"
#include <stddef.h>		/* for size_t */
#include "udalloc.h"
#include "fortc.h"


/*
 * Return the length of the non-blank portion of a FORTRAN character variable.
 */
    size_t
fclen(string, maxlen)
    const char	*string;	/* string to have its length returned */
    int		maxlen;		/* maximum possible length of string */
{
    const char	*cp;

    for (cp = string + maxlen; cp > string; --cp)
	if (cp[-1] != ' ')
	    break;

    return cp - string;
}


/*
 * Duplicate the meaningful portion of a FORTRAN character variable.  Ensure 
 * it's 0-termination.
 */
    char*
fcdup(string, maxlen)
    const char	*string;	/* string to be duplicated */
    int		maxlen;		/* maximum length of string */
{
    return udstrndup(string, fclen(string, maxlen));
}

/* ex: se wm=0 ts=0: */
