      subroutine add_label
c
      logical display
      character*80 string
      common/string_labels/display(80),string(80),x_string(80),
     &                     y_string(80),angle(80),height(80),
     &                     len_string(80),next_string
c
      read(*,'(a80)') string(next_string)
      len_string(next_string) = lenstr(string(next_string))
      x = page_x(16384)
      y = page_y(16384)
c
      call set_char(height(next_string),0.0)
      call bound_box(x,y,
     &               string(next_string)(1:len_string(next_string)),
     &               angle(next_string)) 
      x_string(next_string) = x
      y_string(next_string) = y
      call symbol(x_string(next_string),y_string(next_string),
     &            height(next_string),string(next_string),
     &            angle(next_string),len_string(next_string))
      display(next_string) = .true.
      next_string = next_string + 1
      return
      end

c
c
      subroutine init_labels
c
      logical display
      character*80 string
      common/string_labels/display(80),string(80),x_string(80),
     &                     y_string(80),angle(80),height(80),
     &                     len_string(80),next_string
c
      do i = 1, 80
         display(i) = .false.
         string(i) = '\0'
         x_string(i) = 0.0
         y_string(i) = 0.0
         angle(i) = 0.0
         height(i) = 0.15
         len_string(i) = 0
      enddo
      next_string = 1
      return
      end
c
c
      subroutine draw_labels
c
      logical display
      character*80 string
      common/string_labels/display(80),string(80),x_string(80),
     &                     y_string(80),angle(80),height(80),
     &                     len_string(80),next_string
c
      do i = 1, next_string - 1
         if(display(i)) then
            call symbol(x_string(i),y_string(i),height(i),string(i),
     &                  angle(i),len_string(i))
         endif
      enddo 
      return
      end
c
c
      subroutine delete_label
c
      logical display,inbox
      character*80 string
      integer llx,lly,ulx,uly,urx,ury,button,lrx,lry
      common/string_labels/display(80),string(80),x_string(80),
     &                     y_string(80),angle(80),height(80),
     &                     len_string(80),next_string
c
      call notify('Click on the label you wish to delete. ')
      call getpoint(x,y,button)
      do i = 1, next_string - 1
         call set_char(height(i),0.0)
c
         call cfqtextext(string(i)(1:len_string(i)),' ',
     &                   iconx,icony,llx,lly,ulx,uly,urx,ury)
         lrx = urx + llx - ulx
         lry = ury + lly - uly
         call rotate(llx,lly,angle(i))
         call rotate(ulx,uly,angle(i))
         call rotate(urx,ury,angle(i))
         call rotate(lrx,lry,angle(i))
         xmin = page_x(ulx) + x_string(i)
         ymin = page_y(lly) + y_string(i)
         xmax = page_x(lrx) + x_string(i)
         ymax = page_y(ury) + y_string(i)
         if(inbox(x,y,xmin,ymin,xmax,ymax)) then
            display(i) = .false.
            string(i) = ' '
            x_string(i) = 0.0
            y_string(i) = 0.0
            call notify('Label deleted. ')
            return
         endif
      enddo
      return
      end
c
c
      subroutine text_style(text_attr) 
c
      logical display,inbox
      character*80 string
      integer llx,lly,ulx,uly,urx,ury,button,lrx,lry
      common/string_labels/display(80),string(80),x_string(80),
     &                     y_string(80),angle(80),height(80),
     &                     len_string(80),next_string
c
      call notify('Click on the label you wish to restyle. ')
      call getpoint(x,y,button)
      do i = 1, next_string - 1
         call set_char(height(i),0.0)
         call cfqtextext(string(i)(1:len_string(i)),' ',
     &                   iconx,icony,llx,lly,ulx,uly,urx,ury)
         lrx = urx + llx - ulx
         lry = ury + lly - uly
         call rotate(llx,lly,angle(i))
         call rotate(ulx,uly,angle(i))
         call rotate(urx,ury,angle(i))
         call rotate(lrx,lry,angle(i))
         xmin = page_x(ulx) + x_string(i)
         ymin = page_y(lly) + y_string(i)
         xmax = page_x(lrx) + x_string(i)
         ymax = page_y(ury) + y_string(i)
         if(inbox(x,y,xmin,ymin,xmax,ymax)) then
            if(text_attr .lt. 0.025 .or. text_attr .gt. 1.0) then
               angle(i) = text_attr
            else
               height(i) = text_attr
            endif
            call notify('Label restyled. ')
            return
         endif
      enddo
      return
      end
c
c
      subroutine move_label
c
      logical display,inbox
      character*80 string
      integer llx,lly,ulx,uly,urx,ury,button,lrx,lry
      common/string_labels/display(80),string(80),x_string(80),
     &                     y_string(80),angle(80),height(80),
     &                     len_string(80),next_string
c
      call notify('Click on the label you wish to move. ')
      call getpoint(x,y,button)
      do i = 1, next_string - 1
         call set_char(height(i),0.0)
         call cfqtextext(string(i)(1:len_string(i)),' ',
     &                   iconx,icony,llx,lly,ulx,uly,urx,ury)
         lrx = urx + llx - ulx
         lry = ury + lly - uly
         call rotate(llx,lly,angle(i))
         call rotate(ulx,uly,angle(i))
         call rotate(urx,ury,angle(i))
         call rotate(lrx,lry,angle(i))
         xmin = page_x(ulx) + x_string(i)
         ymin = page_y(lly) + y_string(i)
         xmax = page_x(lrx) + x_string(i)
         ymax = page_y(ury) + y_string(i)
         if(inbox(x,y,xmin,ymin,xmax,ymax)) then
            yc = page_y(ury) + y_string(i)
            xc = page_x(urx) + x_string(i)
            call bound_box(xc,yc,string(i)(1:len_string(i)),
     &                     angle(i)) 
            x_string(i) = xc
            y_string(i) = yc
            call notify('Label moved. ')
            return
         endif
      enddo
      return
      end
c
c
      logical function inbox(x,y,xmin,ymin,xmax,ymax)
c
      inbox = .false.
      r_xmin = min(xmin,xmax)
      r_xmax = max(xmin,xmax)
      r_ymin = min(ymin,ymax)
      r_ymax = max(ymin,ymax)
      if(x .lt. r_xmin .or. x .gt. r_xmax) return
      if(y .lt. r_ymin .or. y .gt. r_ymax) return
      inbox = .true.
      return
      end
