      subroutine plots (iuse,device)
c
c Initialize plotting for the Sun Workstation or PostScript.
c
c iuse=0 implies full initialization of all plotting variables  
c iuse=1 implies screen erasure only (i.e. origins and scaling 
c        factors are not changed)
c James Blake
c @(#)plots.f	1.3  9/8/89 
c
      include 'cgidefs77.h'
      include 'device_type.h'
      integer name,windowfd,retained,dd,cmapsize,fb
      integer flags,noargs,defflag,color,device
      integer hatch2(6), hatch3(12)
      character*256 screenname,windowname,cmapname,ptr
c
      common /chr/ screenname,windowname,cmapname,ptr
      common /int/ name,windowfd,retained,dd,       
     *   cmapsize,flags,noargs,defflag,color
      common /tscale/ sfactt
      common /origin/ origx,origy
      common/local_color/gray_level
c
      common /cqpbnf/ xold, yold, fac, ires
c
      logical first_ps,first_ws
      save    first_ps,first_ws
      data    first_ps /.true./
      data    first_ws /.true./
c
      data defflag / 1 /
c
      data hatch2 /0,1,0,1,1,1/
c
      if (device .eq. 1) then
         PostScript = .false.
         if (iuse.eq.0 .and. first_ws) then
c
c          figure out if we are on a color workstation :
c
            idepth = fb()
            cmapsize = 0
            dd = PIXWINDD
            if (idepth .eq. 1) then
               color = 0
               mono_ws = .true.
            else
               color = 7
               color_ws = .true.
               mono_ws = .false.
            endif
            first_ws = .false.
c
c     set up origin and starting scale factor.
c
            origx  = 0.0
            origy  = 0.0
            sfactt = 1.0
            retained = 0
c
c Initialize SunCGI and open a view surface.
c
            call cfopencgi ()
            call cfopenvws (name,screenname,windowname,
     *                      windowfd,retained,dd,
     *                      cmapsize,cmapname,flags,ptr,   
     *                      noargs)
c
c Set the background color to white.
c
            call cfclrvws (name,defflag,color)
c
c Set the interior style to SOLIDI and perimeter visibility set ON
c 
            call cfintstyle(1,1)
c
c Set the VDC map size
c
            call cfvdcext (0,0,32767,32767)
c
c Set the text precision to STROKE.
c
            call cftextprec(2)
c
c Set the character height and orientation.
c
            call set_char(0.15,0.0)
c
c Set the character expansion factor
c
            call cfcharspacing(0.01)

c
c Set the width to height ratio.
c
            call cfcharexpfac(0.915)
c
c Set the line width mode to absolute and one pixel.
c
      call cflnspecmode(0)
      call cflnwidth(1.0)
 
c
c Fix the color yellow.
c
            if (color_ws) then
               call cfcotable(2,250,200,0,1)
            endif
c
c Define hatch pattern(s) for mono WS
c
            if (mono_ws) then
               call cfpattable(2,2,3,hatch2)
               do i = 1, 12
                  hatch3(i) = 1
               enddo
               hatch3(1)  = 0
               hatch3(7)  = 0
               hatch3(10) = 0
               call cfpattable(3,4,3,hatch3)
            endif

c
c Pick the first pen (black) and ROMAN font.
c
            call newpen (1)
            call fontstyle(0)
c
c Initialize the cursor
c
            call cursor
         else
            call cfclrvws (name,defflag,color)
         endif
      elseif (device .eq. 2) then
         color_ws = .false.
         mono_ws = .false.
         PostScript = .true.
C
C   Initialise plot storage - if we haven't already
C
         if (iuse .eq. 1) then
            call pldone
            first_ps = .true.
         endif
         if (first_ps) then
            first_ps = .false.
C
C Check for problems opening a plot file
C
            call plbegn
            call plogue
         endif

C
C   Initialise common variables
C
         gray_level = 0.0
         fac        = 1.0
         xold       = 0.0
         yold       = 0.0
         ires       = 300
      endif
      return
      end
c
c
c
      integer function ieee_retrospective()
      return
      end
